<?php

class BridgeCoreElementorPieChart extends \Elementor\Widget_Base{
    public function get_name() {
        return 'bridge_pie_chart';
    }

    public function get_title() {
        return esc_html__( "Pie Chart", 'bridge-core' );
    }

    public function get_icon() {
        return 'bridge-elementor-custom-icon bridge-elementor-pie-chart';
    }

    public function get_categories() {
        return [ 'qode' ];
    }
	
	public function get_script_depends() {
		return array( 'easyPieChart', 'countTo', 'qode-pie-chart' );
	}
	
	protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'bridge-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'percent',
            [
                'label' => esc_html__( "Percentage", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '25'
            ]
        );

        $this->add_control(
            'percentage_color',
            [
                'label' => esc_html__( "Percentage Color", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'percent_font_size',
            [
                'label' => esc_html__( "Percentage Font Size", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'percent_font_weight',
            [
                'label' => esc_html__( "Percentage Font weight", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => bridge_qode_get_font_weight_array(false),
                'default' => '400'
            ]
        );

        $this->add_control(
            'active_color',
            [
                'label' => esc_html__( "Bar Active Color", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'noactive_color',
            [
                'label' => esc_html__( "Bar Noactive Color", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'line_width',
            [
                'label' => esc_html__( "Pie Chart Line Width (px)", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( "Title", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( "Title Color", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( "Title Tag", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    "h2" => "h2",
                    "h3" => "h3",
                    "h4" => "h4",
                    "h5" => "h5",
                    "h6" => "h6",
                ],
                'default' => 'h4'
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => esc_html__( "Text", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( "Text Color", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'separator',
            [
                'label' => esc_html__( "Separator", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => bridge_qode_get_yes_no_select_array(false, true),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'separator_color',
            [
                'label' => esc_html__( "Separator Color", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'separator' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'element_appearance',
            [
                'label' => esc_html__('Element Appearance', 'bridge-core'),
                'description' => esc_html__('Set distance (related to browser bottom) to start the animation', 'bridge-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo bridge_core_get_shortcode_template_part('templates/pie-chart', '_pie-chart', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new BridgeCoreElementorPieChart() );