<div class="wrap timetable_settings_section first">
	<h2><?php esc_html_e("Google Calendar", "timetable"); ?></h2>
</div>
	<div id="timetable_configuration_tabs" class="tt_hide">
		<ul class="nav-tabs">
			<li class="nav-tab">
				<a href="#tab-configuration">
					<?php esc_html_e('Configuration', 'timetable'); ?>
				</a>
			</li>
			<li class="nav-tab">
				<a href="#tab-export">
					<?php esc_html_e('Export', 'timetable'); ?>
				</a>
			</li>
			<li class="nav-tab">
				<a href="#tab-import">
					<?php esc_html_e('Import', 'timetable'); ?>
				</a>
			</li>
		</ul>
		<div id="tab-configuration">
			<form action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>" method="post" class="google_calendar">
				<input type="hidden" name="action" value="save" />
				<table class="timetable_table form-table">
					<tbody>
						<tr valign="top">
							<th scope="row">
								<label for="calendar_id">
									<?php esc_html_e("Calendar ID", "timetable"); ?>
								</label>
							</th>
							<td>
								<input type="text" class="regular-text" value="<?php echo esc_attr($googleCalendar->id); ?>" id="calendar_id" name="calendar_id">
							</td>
							<td>
								<span class="description"><?php esc_html_e("Google Calendar ID.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top" class="no-border">
							<th scope="row">
								<label for="service_account_encoded">
									<?php esc_html_e("Service account", "timetable"); ?>
								</label>
							</th>
							<td colspan="2">
								<span class="description long"><?php esc_html_e("Copy/paste the contents of downloaded *.json file.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<td colspan="3">
								<textarea id="service_account_encoded" name="service_account_encoded" class="regular-text" style="width: 770px; height: 200px;"><?php echo esc_html($googleCalendar->service_account_encoded); ?></textarea>
							</td>
						</tr>
						<tr valign="top" >
							<th colspan="3">
								<input type="submit" value="<?php esc_attr_e("Save Options", "timetable") ?>" class="button-primary" name="Submit">
							</th>
						</tr>
					</tbody>
				</table>
			</form>
			<table class="timetable_table form-table">
				<tbody>
					<tr valign="top" class="no-border">
						<td colspan="3">
							<h3><?php esc_html_e("Integration instructions", "timetable"); ?></h3>
							<p><?php esc_html_e("1. Log in to your Gmail account.", "timetable"); ?></p>
							<p><?php echo sprintf(wp_kses(__("2. Visit <a href='%s' target='_blank'>Google API Console</a> page and create a new project (<a href='%s' target='_blank'>screen</a>). In 'Project name' field specify the name and click 'Create' (<a href='%s' target='_blank'>screen</a>).", "timetable"), array("a" => array("href" => array(), "target" => array()))), "https://console.developers.google.com/", "http://support.quanticalabs.com/wp-content/uploads/2018/11/new-project-1.png", "http://support.quanticalabs.com/wp-content/uploads/2018/11/create-project.png"); ?></p>
							<p><?php echo sprintf(wp_kses(__("3. In 'Navigation Menu' select 'IAM & admin->Service accounts' (<a href='%s' target='_blank'>screen</a>), now click on '+ Create Service Account' option (<a href='%s' target='_blank'>screen</a>). Specify the account name and click 'Create'. In next step set Role to 'Project->Editor' and click 'Continue'. In 3rd step select '+ Create Key' button, set 'Key type' to 'JSON' and click 'Create' button, download the .json file generated by Google.", "timetable"), array("a" => array("href" => array(), "target" => array()))), "http://support.quanticalabs.com/wp-content/uploads/2018/11/service-accounts-menu-item.png", "http://support.quanticalabs.com/wp-content/uploads/2018/11/create-service-account.png"); ?></p>
							<p><?php echo sprintf(wp_kses(__("4. Now go to API library (<a href='%s' target='_blank'>screen</a>), search for 'Calendar' and select 'Google Calendar API' result. Click on 'Enable' button, this way the API will be enabled for your project (<a href='%s' target='_blank'>screen</a>).", "timetable"), array("a" => array("href" => array(), "target" => array()))), "http://support.quanticalabs.com/wp-content/uploads/2018/11/menu-api-library.png", "http://support.quanticalabs.com/wp-content/uploads/2018/11/enable-calendar-api.png"); ?></p>
							<p><?php echo sprintf(wp_kses(__("5. Visit <a href='%s' target='_blank'>Google Calendar</a> and add new calendar (<a href='%s' target='_blank'>screen</a>). Go to 'Calendar settings' panel and in 'Share with specific people' section add the service account email created in point 4. Permissions options must be set to 'Make changes to events' (<a href='%s' target='_blank'>screen</a>). If you don't remember your service account email then please visit <a href='%s' target='_blank'>Google API Console</a> and select the calendar project that you've created earlier. Now from 'IAM & admin' menu select the 'Service accounts' option (<a href='%s' target='_blank'>screen</a>). Now just look for 'Email' column in service accounts list (<a href='%s' target='_blank'>screen</a>). In 'Calendar settings' please check 'Integrate Calendar' section copy the 'Calendar ID' value (<a href='%s' target='_blank'>screen</a>).", "timetable"), array("a" => array("href" => array(), "target" => array()))), "https://calendar.google.com/", "http://support.quanticalabs.com/wp-content/uploads/2018/11/create-calendar.png", "http://support.quanticalabs.com/wp-content/uploads/2018/11/share-calendar.png", "https://console.developers.google.com/", "http://support.quanticalabs.com/wp-content/uploads/2018/11/service-accounts-menu-item.png", "http://support.quanticalabs.com/wp-content/uploads/2018/11/service-accounts-list.png", "http://support.quanticalabs.com/wp-content/uploads/2018/11/google-calendar-id.png"); ?></p>
							<p><?php echo sprintf(wp_kses(__("6. Now visit 'Timetable->Google Calendar' panel and open 'Configuration' tab. In 'Calendar ID' field you must specify the ID from previous step and in 'Service account' textarea insert the contents of .json file downloaded in step 4 (<a href='%s' target='_blank'>screen</a>).", "timetable"), array("a" => array("href" => array(), "target" => array()))), "http://support.quanticalabs.com/wp-content/uploads/2018/11/timetable-calendar-settings.png"); ?></p>
							<p><?php esc_html_e("7. In 'Settings->General' panel please make sure that 'Timezone' option has the same value as in your Google Calendar.", "timetable"); ?></p>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div id="tab-export">
			<form action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>#tab-export" method="post" class="google_calendar">
				<input type="hidden" name="action" value="export" />
				<table class="form-table timetable_table">
					<tbody>
						<tr valign="top">
							<th scope="row">
								<label for="events-export">
									<?php esc_html_e("Events", "timetable"); ?>
								</label>
							</th>
							<td>
								<select id="events-export" name="event[]" multiple="multiple">
									<?php
									if($Events)
									{
										foreach($Events as $Event)
										{
											echo '<option value="' . urldecode($Event->post_name) . '">' . $Event->post_title . ' (id: ' . $Event->ID . ')' . '</option>';
										}
									}
									?>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Select the events that should be exported. Hold the CTRL key to select multiple items.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="monday-export">
									<?php esc_html_e("Monday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="monday-export">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==1 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Monday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="tuesday-export">
									<?php esc_html_e("Tuesday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="tuesday-export">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==2 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Tuesday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="wednesday-export">
									<?php esc_html_e("Wednesday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="wednesday-export">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==3 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Wednesday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="thursday-export">
									<?php esc_html_e("Thursday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="thursday-export">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==4 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Thursday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="friday-export">
									<?php esc_html_e("Friday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="friday-export">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==5 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Friday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="saturday-export">
									<?php esc_html_e("Saturday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="saturday-export">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==6 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Saturday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="sunday-export">
									<?php esc_html_e("Sunday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="sunday-export">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==7 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Sunday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th colspan="2">
								<input type="submit" value="<?php esc_attr_e("Export", "timetable") ?>" class="button-primary" name="Export">
							</th>
							<td>
								<span class="description"><?php esc_html_e("Export selected events to Google Calendar.", "timetable"); ?></span>
							</td>
						</tr>
					</tbody>
				</table>
			</form>
			<table class="timetable_table form-table">
				<tbody>
					<tr valign="top" class="no-border">
						<td colspan="3">
								<h3><?php esc_html_e("Export instructions", "timetable"); ?></h3>
								<p><?php esc_html_e("This panel allows you to export event hours into Google Calendar. You can specify which events should be used and you can also assign columns to weekdays.", "timetable"); ?></p>
								<p><?php esc_html_e("When you click 'Export' button then the plugin will create mentioned events in the Calendar. If you make changes to the exported event hours then you can once again use export feature to update event details in Google Calendar.", "timetable"); ?></p>
							</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div id="tab-import">
			<form action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>#tab-import" method="post" class="google_calendar">
				<input type="hidden" name="action" value="get_calendar_data" />
				<table class="timetable_table form-table">
					<tbody>
						<tr valign="top">
							<th scope="row">
								<label for="get_calendar_data">
									<?php esc_html_e("Google Calendar", "timetable"); ?>
								</label>
							</th>
							<td>
								<?php
								$label_calendar_data = '';
								if($UniqueCalendarEvents)
									$label_calendar_data = __("Refresh Calendar data", "timetable");
								else
									$label_calendar_data = __("Get Calendar data", "timetable");
								?>
								<input id="get_calendar_data" type="submit" value="<?php echo esc_attr($label_calendar_data) ?>" class="button-primary regular-text" name="Import">
							</td>
							<td>
								<span class="description"><?php esc_html_e("Fetches events data from Google Calendar.", "timetable"); ?></span>
							</td>
						</tr>
					</tbody>
				</table>
			</form>
			<?php
			if($UniqueCalendarEvents)
			{
			?>
			<form action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>#tab-import" method="post" class="google_calendar">
				<input type="hidden" name="action" value="import" />
				<table class="timetable_table form-table">
					<tbody>
						<tr valign="top">
							<th scope="row">
								<label for="calendar_event">
									<?php esc_html_e("Calendar Events", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="calendar_event[]" id="calendar_event" multiple="multiple">
									<?php
									foreach($UniqueCalendarEvents as $UniqueCalendarEvent)
									{
										echo '<option value="' . esc_attr($UniqueCalendarEvent) . '" >' . esc_html($UniqueCalendarEvent) . '</option>';
									}
									?>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Select the events that should be imported. Hold the CTRL key to select multiple items.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="monday-import">
									<?php esc_html_e("Monday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="monday-import">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==1 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Monday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="tuesday-import">
									<?php esc_html_e("Tuesday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="tuesday-import">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==2 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Tuesday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="wednesday-import">
									<?php esc_html_e("Wednesday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="wednesday-import">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==3 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Wednesday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="thursday-import">
									<?php esc_html_e("Thursday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="thursday-import">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==4 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Thursday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="friday-import">
									<?php esc_html_e("Friday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="friday-import">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==5 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Friday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="saturday-import">
									<?php esc_html_e("Saturday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="saturday-import">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==6 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Saturday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row">
								<label for="sunday-import">
									<?php esc_html_e("Sunday", "timetable"); ?>
								</label>
							</th>
							<td>
								<select name="weekday[]" id="sunday-import">
									<?php
									if($Weekdays)
									{
										foreach($Weekdays as $Weekday)
										{
											echo '<option value="' . urldecode($Weekday->post_name) . '"  ' . ($Weekday->menu_order==7 ? 'selected' : '') . '>' . $Weekday->post_title . ' (id: ' . $Weekday->ID . ')' . '</option>';
										}
									}
									?>
									<option value=""><?php esc_html_e("None", "timetable"); ?></option>
								</select>
							</td>
							<td>
								<span class="description"><?php esc_html_e("Assign column to Sunday.", "timetable"); ?></span>
							</td>
						</tr>
						<tr valign="top">
							<th colspan="2">
								<input type="submit" value="<?php esc_attr_e("Import", "timetable") ?>" class="button-primary" name="Import">
							</th>
							<td>
								<span class="description"><?php esc_html_e("Import events from Google Calendar.", "timetable"); ?></span>
							</td>
						</tr>
					</tbody>
				</table>
			</form>
			<?php
			}
			?>
			<table class="timetable_table form-table">
				<tbody>
					<tr valign="top" class="no-border">
						<td colspan="3">
							<h3><?php esc_html_e("Import instructions", "timetable"); ?></h3>
							<p><?php esc_html_e("Panel allows you to import events from your calendar to the Timetable plugin. Before you import events you have to fetch calendar data, after that you will see a list of available events that you can import into timetable. Simillary to Export feature you can assign your columns to the weekdays.", "timetable"); ?></p>
							<p><?php esc_html_e("If you made changes to the calendar events, then you can once again perform an import. This way the event hours in Timetable will be updated with new data.", "timetable"); ?></p>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>

