<?php

class BridgeCoreElementorImageWithText extends \Elementor\Widget_Base{
    public function get_name() {
        return 'bridge_image_with_text';
    }

    public function get_title() {
        return esc_html__( "Image With Text", 'bridge-core' );
    }

    public function get_icon() {
        return 'bridge-elementor-custom-icon bridge-elementor-image-with-text';
    }

    public function get_categories() {
        return [ 'qode' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'bridge-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__( "Image", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( "Title", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( "Title Color", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( "Title Tag", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    "h1" => "h1",
                    "h2" => "h2",
                    "h3" => "h3",
                    "h4" => "h4",
                    "h5" => "h5",
                    "h6" => "h6",
                ],
                'default' => 'h3'
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => esc_html__( "Content", 'bridge-core' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => "<p>".esc_html__( 'I am test text for Image with text shortcode.', 'bridge-core' )."</p>"
            ]
        );
	    
	    $this->add_control(
		    'link',
		    [
			    'label' => esc_html__( "Link", 'bridge-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );
	    
	    $this->add_control(
		    'link_target',
		    [
			    'label' => esc_html__( "Link Target", 'bridge-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    '_self' => esc_html__( 'Self', 'bridge-core' ),
				    '_blank' => esc_html__( 'Blank', 'bridge-core' ),
			    ],
			    'default' => '_self'
		    ]
	    );
		
		$this->add_control(
		    'link_position',
		    [
			    'label' => esc_html__( "Link Position", 'bridge-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'overlay' => esc_html__( 'Overlay', 'bridge-core' ),
				    'image_title' => esc_html__( 'Blank', 'bridge-core' ),
			    ],
			    'default' => 'overlay'
		    ]
	    );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        if( ! empty($params['image']) ){
            $params['image'] = $params['image']['id'];
        }

        echo bridge_core_get_shortcode_template_part('templates/image-with-text', '_image-with-text', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register( new BridgeCoreElementorImageWithText() );