<?php

$field = xprofile_get_field( 2 );

$map = [
	'CUNY Graduate Center ' => 'CUNY Graduate Center',
	'CUNY Graduate School of Journalism' => 'Craig Newmark Graduate School of Journalism',
	'City College' => 'City College of New York',
	'Macaulay Honors College ' => 'Macaulay Honors College',
	'NYC College of Technology' => 'New York City College of Technology',
	'New Community College at CUNY' => 'Guttman Community College',
	'Stella and Charles Guttman Community College' => 'Guttman Community College',
];

global $wpdb, $bp;
foreach ( $map as $old => $new ) {
	$like = '%' . $wpdb->esc_like( $old ) . '%';
	$user_ids = $wpdb->get_col( $wpdb->prepare( "SELECT user_id FROM {$bp->profile->table_name_data} WHERE field_id = 2 and value LIKE %s", $like ) );

	foreach ( $user_ids as $user_id ) {
		$current = xprofile_get_field_data( 2, $user_id );

		if ( is_array( $current ) ) {
			foreach ( $current as &$value ) {
				if ( $old === $value ) {
					$value = $new;
				}
			}
		} else {
			$current = $new;
		}

		xprofile_set_field_data( 2, $user_id, $current );
	}

	// Positions.
	$term = get_term_by( 'name', $old, 'cacap_position_college' );
	if ( $term ) {
		// Don't bother with the ones that are just about trailing spaces.
		if ( trim( $old ) !== $new ) {
			$updated = wp_update_term(
				$term->term_id,
				'cacap_position_college',
				[
					'name' => $new,
				]
			);
		}
	}
}
