<?php

global $wpdb, $bp;

$gms = $wpdb->get_results( "SELECT * FROM {$bp->groups->table_name_members} WHERE is_banned = 0 AND is_confirmed = 1" );

$cols = [
	0 => 'user_id',
	1 => 'user_email',
	2 => 'group_name',
	3 => 'group_id',
];

$data_rows = array_map(
	function( $gm ) {
		$user  = get_userdata( $gm->user_id );
		$group = groups_get_group( $gm->group_id );

		return [
			0 => $user->ID,
			1 => $user->user_email,
			2 => $group->name,
			3 => $group->id
		];
	},
	$gms
);

$csv_path = ABSPATH . '/al-cop-group-members-' . date( 'Y-m-d' ) . '.csv';

$fh = fopen( $csv_path, 'w+' );

fprintf( $fh, chr(0xEF) . chr(0xBB) . chr(0xBF) );

fputcsv( $fh, $cols );

foreach ( $data_rows as $data_row ) {
	fputcsv( $fh, $data_row );
}

fclose( $fh );
die();
