<?php
/**
 * Attitude Pro Theme Options
 *
 * Contains all the function related to theme options.
 *
 * @package Theme Horse
 * @subpackage Attitude Pro
 * @since Attitude Pro 1.0
 */

/****************************************************************************************/

add_action( 'admin_print_scripts-appearance_page_theme_options', 'attitude_admin_scripts' );
/**
 * Enqueuing some scripts.
 *
 * @uses wp_enqueue_script to register javascripts.
 * @uses wp_enqueue_script to add javascripts to WordPress generated pages.
 */
function attitude_admin_scripts() {
   wp_enqueue_script( 'attitude_toggle_effect', ATTITUDE_ADMIN_JS_URL . '/toggle-effect.js' );
   wp_enqueue_script( 'wp-color-picker' );
   wp_enqueue_script( 'attitude_colorpicker', ATTITUDE_ADMIN_JS_URL . '/colorpicker-admin.js', array( 'jquery','wp-color-picker' ), false, true );
}

/****************************************************************************************/

add_action( 'admin_print_styles-appearance_page_theme_options', 'attitude_admin_styles' );
/**
 * Enqueuing some styles.
 *
 * @uses wp_enqueue_style to register stylesheets.
 * @uses wp_enqueue_style to add styles.
 */
function attitude_admin_styles() {
	wp_enqueue_style( 'attitude_admin_style', ATTITUDE_ADMIN_CSS_URL. '/admin.css' );
	wp_enqueue_style( 'wp-color-picker' );
}

/****************************************************************************************/

add_action( 'admin_menu', 'attitude_options_menu' );
/**
 * Create sub-menu page.
 *
 * @uses add_theme_page to add sub-menu under the Appearance top level menu.
 */
function attitude_options_menu() {
    
	add_theme_page( 
		__( 'Theme Options', 'attitude' ),           // Name of page
		__( 'Theme Options', 'attitude' ),           // Label in menu
		'edit_theme_options',                           // Capability required
		'theme_options',                                // Menu slug, used to uniquely identify the page
		'attitude_theme_options_do_page'             // Function that renders the options page
	);

}

/****************************************************************************************/

add_action( 'admin_init', 'attitude_register_settings' );
/**
 * Register options and validation callbacks
 *
 * @uses register_setting
 */
function attitude_register_settings() {
   register_setting( 'attitude_theme_options', 'attitude_theme_options', 'attitude_theme_options_validate' );
}

/****************************************************************************************/

/**
 * Render Attitude Pro Theme Options page
 */
function attitude_theme_options_do_page() {
?>
	   
	<div class="them_option_block clearfix">
		<div class="theme_option_title"><h2><?php _e( 'Theme Options by', 'attitude' ); ?></h2></div><div class="theme_option_link"><a href="<?php echo esc_url( __( 'http://themehorse.com/', 'attitude' ) ); ?>" title="<?php esc_attr_e( 'Theme Horse', 'attitude' ); ?>" target="_blank"><img src="<?php echo ATTITUDE_ADMIN_IMAGES_URL . '/theme-horse.png'; ?>" alt="'<?php _e( 'Theme Horse', 'attitude' ); ?>" /></a> </div>
	</div><br/><br/><br/>
	<div class="donate-info">
		<?php _e( 'Some of the Theme Option settings has been moved to ', 'attitude' ); ?> <a class="instruction" href="<?php echo wp_customize_url();?>" target="_blank"> <?php _e( 'Customizer', 'attitude' ); ?></a> <?php  _e('where you can customize or modify apperance settings in a live Preview.','attitude')?>
	</div>
   <div id="themehorse" class="wrap">
        
      <form method="post" action="options.php">
			<?php
				settings_fields( 'attitude_theme_options' );
				global $attitude_theme_options_settings;
				$options = $attitude_theme_options_settings;             
			?>        
	            
			<?php if( isset( $_GET [ 'settings-updated' ] ) && 'true' == $_GET[ 'settings-updated' ] ): ?>
					<div class="updated" id="message">
					   <p><strong><?php _e( 'Settings saved.', 'attitude' );?></strong></p>
					</div>
			<?php endif; ?> 
            
         <div id="attitude_tabs">
					<h3><?php _e( 'Design Options', 'attitude' );?></h3>
				<!-- Option for Design Options -->
				<div id="designoptions">

					<?php
							$attitude_typography_options = array(
								'attitude_general_typography'	=> array( 
																				'title' => __( 'Content','attitude' ),
																				'description' => __( 'Changes will reflect in content.', 'attitude' )
																				 ),
								'attitude_navigation'			=> array( 
																				'title' => __( 'Navigation','attitude' ),
																				'description' => __( 'Changes will reflect in the menu', 'attitude' )
																				 ),
								'attitude_title'					=> array( 
																				'title' => __( 'Title','attitude' ),
																				'description' => __( 'Changes will reflect in all titles', 'attitude' )
																				 )
																			);	
							$attitude_font_size_options = array(
								'site_title'							=> array( 
																				'title' => __( 'Site Title','attitude' )
																				 ),
								'navigation'							=> array( 
																				'title' => __( 'Navigation Parent','attitude' )
																				 ),
								'navigation_child'							=> array( 
																				'title' => __( 'Navigation Child','attitude' )
																				 ),
								'service_gallery_title'							=> array( 
																				'title' => __( 'Slogan Button and Service/Gallery Title/Promotionla Bar Button','attitude' )
																				 ),
								'page_post_title'						=> array( 
																				'title' => __( 'Page/Post Title/Slogan/Promotional Bar','attitude' )
																				),
								'sidebar_widget_title'				=> array( 
																				'title' => __( 'Sidebar Widget Title','attitude' )
																				 ),
								'footer_widget_title'				=> array( 
																				'title' => __( 'Footer Widget Title','attitude' )
																				 ),
								'content'								=> array( 
																				'title' => __( 'Content','attitude' )
																				 ),
								'widget_content'						=> array( 
																				'title' => __( 'Widget Content','attitude' )
																				 )							
																			);
						?>
						
						<div class="option-container">
							<h3 class="option-toggle"><a href="#"><?php _e( 'Typography Options', 'attitude' ); ?></a></h3>
							<?php /* Font family */ ?>
							<div class="option-content inside">
								<table class="form-table">  
										<tr>
											<th>
												<h3><?php _e( 'Font Family','attitude' ); ?></h3>
											</th>
										</tr>    
	                            	<?php foreach( $attitude_typography_options as $key => $attitude_typography_option ) { ?>
										<tr>
											<th scope="row">
												<label for="<?php echo $key; ?>"><?php echo $attitude_typography_option[ 'title' ]; ?></label>
												<p><small><?php printf( __( '%s', 'attitude' ), $attitude_typography_option[ 'description' ] ); ?></small></p>
											</th>
											<td>
											  	<div class="<?php echo $key; ?>">
											      <select class="selected" name="attitude_theme_options[<?php echo $key; ?>]" id="<?php echo $key; ?>">
											         <?php 
											         foreach ( attitude_google_fonts() as $value ) { ?>
											               <option value="<?php echo esc_attr( $value ); ?>" <?php selected( $options[ $key ], $value ); ?>><?php printf( esc_attr( '%s', 'attitude' ), $value ); ?></option>
											         <?php } ?>
											      </select>
											  	</div>
											</td>
										</tr>
	                               	<?php } ?>
								</table>

								<?php /* Font sizes */ ?>
								<table class="form-table">  
										<tr>
											<th>
												<h3><?php _e( 'Font Size','attitude' ); ?></h3>
											</th>
										</tr>    
	                            	<?php foreach( $attitude_font_size_options as $key => $attitude_font_size_options ) { ?>
										<tr>
											<th scope="row">
												<label for="<?php echo $key; ?>"><?php echo $attitude_font_size_options[ 'title' ]; ?></label>
											</th>
											<td>
											    <div class="<?php echo $key; ?>">
											      <select class="selected" name="attitude_theme_options[<?php echo $key; ?>]" id="<?php echo $key; ?>">
											         <?php 
											         $attitude_multidimension = attitude_font_sizes();
											         foreach ( $attitude_multidimension[$key.'_sizes'] as $value_key => $attitude_font_size ) { ?>
											               <option value="<?php echo esc_attr( $value_key ); ?>" <?php selected( $options[ $key ], $value_key ); ?>><?php printf( esc_attr( '%s', 'attitude' ), $attitude_font_size ); ?></option>
											         <?php } ?>
											      </select>
											      <?php _e( 'px','attitude' ); ?>
											  	</div>
											</td>
										</tr>
	                               	<?php } ?>
								</table>
								<p class="submit"><input type="submit" class="button-primary" value="<?php esc_attr_e( 'Save All Changes', 'attitude' ); ?>" /></p>
								<p class="submit"><input type="submit" name="attitude_theme_options[reset_font_family]" class="button-primary reset" value="Reset Defaults" /></p>
							</div><!-- .option-content -->
	          		</div><!-- .option-container -->                      

						<div class="option-container">
							<h3 class="option-toggle"><a href="#"><?php _e( 'Color Options', 'attitude' ); ?></a></h3>
							<div class="option-content inside">
								<table class="form-table">
									<tbody>
										<tr>                            
											<th><h3><?php _e( 'Color Skin','attitude' ); ?></h3></th>
										</tr>
										<tr>                            
											<th scope="row"><label for="color_scheme"><?php _e( 'Choose Color', 'attitude' ); ?></label></th>

												<td>
													<div class="font">
														<select class="select-color" id="attitude_cycle_style" name="attitude_theme_options[color_scheme]">
															<?php 
																$attitude_colors = array();
																$attitude_colors = array( 		'Purple',
																										'Pink',
																										'Yellow',
																										'Orange',
																										'Brown',
																										'Maroon',
																										'Aquamarine',
																										'Light Red',
																										'Light Green',
																										'Light Blue',
																							);
																foreach( $attitude_colors as $attitude_color ) {
															?>

															<option value="<?php echo $attitude_color; ?>" <?php selected( $attitude_color, $options['color_scheme']); ?>><?php printf( __( '%s', 'attitude' ), $attitude_color ); ?></option>
															<?php 
															}
															?>
														</select>
													</div>
												</td>
											</tr>
										<?php     
										global $colour_options;                                            
										$colour_options = array(
											'attitude_slogan_slider_title_color'		=> array( 
																					'title' => __( 'Slogan/Slider Title Color/Promotional Bar','attitude' ),
																					'description' => __( 'Changes will reflect on Slogan, Slider Title background', 'attitude' ) ),
											'attitude_buttons_color'		=> array( 
																					'title' => __( 'Buttons Color','attitude' ),
																					'description' => __( 'Changes will reflect on buttons, Pagination, Custom Tags', 'attitude' ) ),
											'attitude_link_color'		=> array( 
																					'title' => __( 'Link Color','attitude' ),
																					'description' => __( 'Changes will reflect on links', 'attitude' ) )
										);
														
										foreach ( $colour_options as $key => $colour_option) :
										?>      	
										<tr>
											<th scope="row">
												<label for="<?php echo $key; ?>"><?php echo $colour_option['title']; ?></label>
											</th>
											<td width="115px">
												<input type="text" class="color" id="<?php echo $key; ?>" name="attitude_theme_options[<?php echo $key; ?>]" size="8" value="<?php echo $options[$key]; ?>" />
											<div id="colorpicker_<?php echo $key; ?>" style="z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;"></div>
											</td>
											<td>
													<p><small><?php printf( __( '%s', 'attitude' ), $colour_option[ 'description' ] ); ?></small></p>
												</td>
										</tr>
										<?php endforeach; ?>
									</tbody>
								</table>

								<table class="form-table">
									<tbody>
										<tr>                            
											<th><h3><?php _e( 'Background Color Options','attitude' ); ?></h3></th>
										</tr>
										<?php     
										global $background_options;                                            
										$background_options = array(
											'attitude_input_field_color'		=> array( 
																					'title' => __( 'Form Input Fields Color','attitude' ) ),
											'attitude_content_background_color'		=> array( 
																					'title' => __( 'Body Background Color','attitude' ) ),
											'attitude_footer_background_color'		=> array( 
																					'title' => __( 'Footer Background Color', 'attitude' ) ),
											'attitude_sitegenerator_background_color'		=> array( 
																					'title' => __( 'Site Generator Background Color', 'attitude' ) ),
											'attitude_header_search_color'		=> array( 
																					'title' => __( 'Header Search Form Color','attitude' ) ),
											'attitude_page_title_wrap_color'		=> array( 
																					'title' => __( 'Page Title Wrap Color','attitude' ) ),
											'attitude_top_navigation_background_color'		=> array( 
																					'title' => __( 'Top Menu Navigation Background Color','attitude' ) ),
											'attitude_sticky_post_color'		=> array( 
																					'title' => __( 'Sticky Post Background Color','attitude' ) )
										);
														
										foreach ( $background_options as $key => $background_option) :
											?>      	
											<tr>
											<th scope="row">
												<label for="<?php echo $key; ?>"><?php echo $background_option['title']; ?></label>
											</th>
											<td>
												<input type="text" class="color" id="<?php echo $key; ?>" name="attitude_theme_options[<?php echo $key; ?>]" size="8" value="<?php echo $options[$key]; ?>" />
											</td>
										</tr>
										<?php endforeach; ?>
									</tbody>
								</table>

								<table class="form-table">
									<tbody>
										<tr>                            
											<th><h3><?php _e( 'Font Color Options','attitude' ); ?></h3></th>
										</tr>
										<?php     
										global $colour_options;                                            
										$font_colour_options = array(
											'attitude_site_title_color'		=> array( 
																					'title' => __( 'Site Title','attitude' ),
																					'description' => __( 'Changes will reflect on Site title', 'attitude' ) ),
											'attitude_heading_title_color'		=> array( 
																					'title' => __( 'Heading Title','attitude' ),
																					'description' => __( 'Changes will reflect on Post/Page title, slogans,custom gallery', 'attitude' ) ),
											'attitude_meta_color'		=> array( 
																					'title' => __( 'Meta Tags/Breadcrumb','attitude' ),
																					'description' => __( 'Changes will reflect on meta tags and breadcrumbs', 'attitude' ) ),
											'attitude_contents_color'		=> array( 
																					'title' => __( 'Content', 'attitude' ),
																					'description' => __( 'Changes will reflect on all content including widget content.', 'attitude' ) ),
											'attitude_widget_title_color'		=> array( 
																					'title' => __( 'Widget Title', 'attitude' ),
																					'description' => __( 'Changes will reflect on all widget title.', 'attitude' ) ),
											'attitude_widget_content_color'		=> array( 
																					'title' => __( 'Widget Content', 'attitude' ),
																					'description' => __( 'Changes will reflect on all  widget content.', 'attitude' ) )
										);
														
										foreach ( $font_colour_options as $key => $font_colour_option) :
											?>      	
											<tr>
												<th scope="row">
													<label for="<?php echo $key; ?>"><?php echo $font_colour_option['title']; ?></label>
												</th>
												<td width=115px>
													<input type="text" class="color" id="<?php echo $key; ?>" name="attitude_theme_options[<?php echo $key; ?>]" size="8" value="<?php echo esc_attr( $options[ $key ] );?>"  />
												</td>
												<td>
													<p><small><?php printf( __( '%s', 'attitude' ), $font_colour_option[ 'description' ] ); ?></small></p>
												</td>
											</tr>
										<?php endforeach; ?>
									</tbody>
								</table>
								<p class="submit"><input type="submit" class="button-primary" value="<?php esc_attr_e( 'Save All Changes', 'attitude' ); ?>" /></p>
								<p class="submit"><input type="submit" name="attitude_theme_options[reset_colors]" class="button-primary reset" value="Reset Defaults" /></p>
							</div><!-- .option-content -->
						</div><!-- .option-container -->

						<div class="option-container">
							<h3 class="option-toggle"><a href="#"><?php _e( 'Background Pattern', 'attitude' ); ?></a></h3>
							<div class="option-content inside">
								<?php                                            
										$background_patterns = array(
											'pattern1'		=> array( 
																					'title' => __( 'pattern 1','attitude' ),
																					'img' => 'pattern-1' ),
											'pattern2'		=> array( 
																					'title' => __( 'pattern 2','attitude' ),
																					'img' => 'pattern-2' ),
											'pattern3'		=> array( 
																					'title' => __( 'pattern 3', 'attitude' ),
																					'img' => 'pattern-3' ),
											'pattern4'		=> array( 
																					'title' => __( 'pattern 4','attitude' ),
																					'img' => 'pattern-4' ),
											'pattern5'		=> array( 
																					'title' => __( 'pattern 5','attitude' ),
																					'img' => 'pattern-5' ),
											'pattern6'		=> array( 
																					'title' => __( 'pattern 6','attitude' ),
																					'img' => 'pattern-6' ),
											'pattern7'		=> array( 
																					'title' => __( 'pattern 7','attitude' ),
																					'img' => 'pattern-7' ),
											'pattern8'		=> array( 
																					'title' => __( 'pattern 8','attitude' ),
																					'img' => 'pattern-8' ),
											'pattern9'		=> array( 
																					'title' => __( 'pattern 9','attitude' ),
																					'img' => 'pattern-9' ),
											'pattern10'		=> array( 
																					'title' => __( 'pattern 10','attitude' ),
																					'img' => 'pattern-10' ),
											'pattern11'		=> array( 
																					'title' => __( 'pattern 11','attitude' ),
																					'img' => 'pattern-11' ),
											'pattern12'		=> array( 
																					'title' => __( 'pattern 12','attitude' ),
																					'img' => 'pattern-12' ),
											'pattern13'		=> array( 
																					'title' => __( 'pattern 13','attitude' ),
																					'img' => 'pattern-13' ),
											'pattern14'		=> array( 
																					'title' => __( 'pattern 14','attitude' ),
																					'img' => 'pattern-14' ),
											'No Pattern'		=> array( 
																					'title' => __( 'No Pattern','attitude' ),
																					'img' => 'disable' )
										); ?>							
								<table class="form-table">
									<tbody>
										<tr>                            
											<th><h3><?php _e( 'Content Background Pattern','attitude' ); ?></h3></th>
										</tr>
										<tr>
											<td>
												<?php				
												foreach ( $background_patterns as $key => $background_pattern) : 
													if( $key == 'No Pattern'){ ?>
														<?php _e( 'Disable Pattern','attitude' ); ?>
														<label class="pattern_box <?php echo $key; ?>" title="<?php printf( esc_attr__( '%s','attitude' ), $background_pattern['title'] ); ?>">
															<input class="check" id="<?php echo $key; ?>" type="radio" <?php checked( $options[ 'content_background_pattern'], $background_pattern['img']) ?> value="<?php echo $background_pattern['img']; ?>" name="attitude_theme_options[content_background_pattern]">
														</label>		
													<?php }else{ ?>												
														<label class="pattern_box <?php echo $key; ?>" title="<?php printf( esc_attr__( '%s','attitude' ), $background_pattern['title'] ); ?>">
															<img alt="pattern" src="<?php echo ATTITUDE_ADMIN_IMAGES_URL ?>/patterns/<?php echo $background_pattern['img']; ?>.jpg ">
															<input class="check" id="<?php echo $key; ?>" type="radio" <?php checked( $options[ 'content_background_pattern'], $background_pattern['img']) ?> value="<?php echo $background_pattern['img']; ?>" name="attitude_theme_options[content_background_pattern]">
														</label>
													<?php } ?>
												<?php endforeach; ?>
											</td>
										</tr>
									</tbody>
								</table>

								<table class="form-table">
									<tbody>
										<tr>                            
											<th><h3><?php _e( 'Footer Background Pattern','attitude' ); ?></h3></th>
										</tr>
										<tr>
											<td>
												<?php				
												foreach ( $background_patterns as $key => $background_pattern) :
													if( $key == 'No Pattern'){ ?>
														<?php _e( 'Disable Pattern','attitude' ); ?>
														<label class="pattern_box <?php echo $key; ?>" title="<?php printf( esc_attr__( '%s','attitude' ), $background_pattern['title'] ); ?>">
															<input class="check" id="<?php echo $key; ?>" type="radio" <?php checked( $options[ 'footer_background_pattern'], $background_pattern['img'] ) ?> value="<?php echo $background_pattern['img']; ?>" name="attitude_theme_options[footer_background_pattern]">
														</label>
													<?php }else{ ?>
														<label class="pattern_box <?php echo $key; ?>" title="<?php printf( esc_attr__( '%s','attitude' ), $background_pattern['title'] ); ?>">
															<img alt="pattern" src="<?php echo ATTITUDE_ADMIN_IMAGES_URL ?>/patterns/<?php echo $background_pattern['img']; ?>.jpg ">
															<input class="check" id="<?php echo $key; ?>" type="radio" <?php checked( $options[ 'footer_background_pattern'], $background_pattern['img'] ) ?> value="<?php echo $background_pattern['img']; ?>" name="attitude_theme_options[footer_background_pattern]">
														</label>
													<?php } ?>
														
												<?php endforeach; ?>
											</td>
										</tr>
									</tbody>
								</table>

									<table class="form-table">
									<tbody>
										<tr>                            
											<th><h3><?php _e( 'Site Generator Background Pattern','attitude' ); ?></h3></th>
										</tr>
										<tr>
											<td>
												<?php				
												foreach ( $background_patterns as $key => $background_pattern) :
													if( $key == 'No Pattern'){ ?>
														<label class="pattern_box <?php echo $key; ?>" title="<?php printf( esc_attr__( '%s','attitude' ), $background_pattern['title'] ); ?>">
															<?php _e( 'Disable Pattern','attitude' ); ?>
															<input class="check" id="<?php echo $key; ?>" type="radio" <?php checked( $options[ 'sitegenerator_background_pattern'], $background_pattern['img']) ?> value="<?php echo $background_pattern['img']; ?>" name="attitude_theme_options[sitegenerator_background_pattern]">
														</label>
													<?php }else{ ?>
															<label class="pattern_box <?php echo $key; ?>" title="<?php printf( esc_attr__( '%s','attitude' ), $background_pattern['title'] ); ?>">
																<img alt="pattern" src="<?php echo ATTITUDE_ADMIN_IMAGES_URL ?>/patterns/<?php echo $background_pattern['img']; ?>.jpg ">
																<input class="check" id="<?php echo $key; ?>" type="radio" <?php checked( $options[ 'sitegenerator_background_pattern'], $background_pattern['img']) ?> value="<?php echo $background_pattern['img']; ?>" name="attitude_theme_options[sitegenerator_background_pattern]">
															</label>
													<?php } ?>
														
												<?php endforeach; ?>
											</td>
										</tr>
									</tbody>
								</table>
								<p class="submit"><input type="submit" class="button-primary" value="<?php esc_attr_e( 'Save All Changes', 'attitude' ); ?>" /></p>
								<p class="submit"><input type="submit" name="attitude_theme_options[reset_background]" class="button-primary reset" value="Reset Defaults" /></p>
							</div><!-- .option-content -->
						</div><!-- .option-container -->
					</div> <!-- #designoptions -->
				<!-- Option for Featured Post Slier -->
                        
         </div><!-- #attitude_tabs -->
            
      </form>
        
   </div><!-- .wrap -->
<?php
}

/****************************************************************************************/

/**
 * Validate all theme options values
 * 
 * @uses esc_url_raw, absint, esc_textarea, sanitize_text_field, attitude_invalidate_caches
 */
function attitude_theme_options_validate( $options ) {
	global $attitude_theme_options_settings, $attitude_theme_options_defaults;
	$input_validated = $attitude_theme_options_settings;
	$input = array();
	$input = $options;

	//font family validation
	if( isset( $input['reset_font_family'] ) && $input['reset_font_family'] == 'Reset Defaults' ) {
			$input_validated['attitude_general_typography'] = $attitude_theme_options_defaults['attitude_general_typography'];
			$input_validated['attitude_navigation'] = $attitude_theme_options_defaults['attitude_navigation'];
			$input_validated['attitude_title'] = $attitude_theme_options_defaults['attitude_title'];
	}
	else {
		 if ( isset( $input['attitude_general_typography'] ) ) {
		 	$input_validated['attitude_general_typography'] = stripslashes($input['attitude_general_typography']);
		 }
		if ( isset( $input['attitude_navigation'] ) ) {
		 	$input_validated['attitude_navigation'] = stripslashes($input['attitude_navigation']);
		 }
		 if ( isset( $input['attitude_title'] ) ) {
		 	$input_validated['attitude_title'] = stripslashes($input['attitude_title']);
		 }
	}

	//font size validation
	if( isset( $input['reset_font_family'] ) && $input['reset_font_family'] == 'Reset Defaults' ) {
			$input_validated['site_title'] = $attitude_theme_options_defaults['site_title'];
			$input_validated['navigation'] = $attitude_theme_options_defaults['navigation'];
			$input_validated['navigation_child'] = $attitude_theme_options_defaults['navigation_child'];
			$input_validated['service_gallery_title'] = $attitude_theme_options_defaults['service_gallery_title'];
			$input_validated['page_post_title'] = $attitude_theme_options_defaults['page_post_title'];
			$input_validated['sidebar_widget_title'] = $attitude_theme_options_defaults['sidebar_widget_title'];
			$input_validated['footer_widget_title'] = $attitude_theme_options_defaults['footer_widget_title'];
			$input_validated['widget_content'] = $attitude_theme_options_defaults['widget_content'];
			$input_validated['content'] = $attitude_theme_options_defaults['content'];
	}else{
		if( isset( $input['site_title'] ) ) {
			$input_validated['site_title'] = absint($input['site_title']);
		}
		if( isset( $input['navigation'] ) ) {
			$input_validated['navigation'] = absint($input['navigation']);
		}
		if( isset( $input['navigation_child'] ) ) {
			$input_validated['navigation_child'] = absint($input['navigation_child']);
		}
		if( isset( $input['service_gallery_title'] ) ) {
			$input_validated['service_gallery_title'] = absint($input['service_gallery_title']);
		}
		if( isset( $input['page_post_title'] ) ) {
			$input_validated['page_post_title'] = absint($input['page_post_title']);
		}
		if( isset( $input['sidebar_widget_title'] ) ) {
			$input_validated['sidebar_widget_title'] = absint($input['sidebar_widget_title']);
		}
		if( isset( $input['footer_widget_title'] ) ) {
			$input_validated['footer_widget_title'] = absint($input['footer_widget_title']);
		}
		if( isset( $input['content'] ) ) {
			$input_validated['content'] = absint($input['content']);
		}
		if( isset( $input['widget_content'] ) ) {
			$input_validated['widget_content'] = absint($input['widget_content']);
		}
	}

	//Font Colors Validation
	if( isset( $input['reset_colors'] ) && $input['reset_colors'] == 'Reset Defaults' ) {
			$input_validated['attitude_site_title_color'] = $attitude_theme_options_defaults['attitude_site_title_color'];
			$input_validated['attitude_heading_title_color'] = $attitude_theme_options_defaults['attitude_heading_title_color'];
			$input_validated['attitude_meta_color'] = $attitude_theme_options_defaults['attitude_meta_color'];
			$input_validated['attitude_contents_color'] = $attitude_theme_options_defaults['attitude_contents_color'];		
			$input_validated['attitude_widget_title_color'] = $attitude_theme_options_defaults['attitude_widget_title_color'];		
			$input_validated['attitude_widget_content_color'] = $attitude_theme_options_defaults['attitude_widget_content_color'];
		
	}else{
		if ( isset( $input['attitude_site_title_color'] ) ) {
			$input_validated['attitude_site_title_color'] = stripslashes($input['attitude_site_title_color']);
		}
		if ( isset( $input['attitude_heading_title_color'] ) ) {
			$input_validated['attitude_heading_title_color'] = stripslashes($input['attitude_heading_title_color']);
		}
		if ( isset( $input['attitude_meta_color'] ) ) {
			$input_validated['attitude_meta_color'] = stripslashes($input['attitude_meta_color']);
		}
		if ( isset( $input['attitude_contents_color'] ) ) {
			$input_validated['attitude_contents_color'] = stripslashes($input['attitude_contents_color']);
		}
		if ( isset( $input['attitude_widget_title_color'] ) ) {
			$input_validated['attitude_widget_title_color'] = stripslashes($input['attitude_widget_title_color']);
		}
		if ( isset( $input['attitude_widget_content_color'] ) ) {
			$input_validated['attitude_widget_content_color'] = stripslashes($input['attitude_widget_content_color']);
		}
	}

	//Color skin validation
	if( isset( $input['reset_colors'] ) && $input['reset_colors'] == 'Reset Defaults' ) {
			$input_validated['color_scheme'] = $attitude_theme_options_defaults['color_scheme'];
			$input_validated['attitude_slogan_slider_title_color'] = $attitude_theme_options_defaults['attitude_slogan_slider_title_color'];
			$input_validated['attitude_buttons_color'] = $attitude_theme_options_defaults['attitude_buttons_color'];
			$input_validated['attitude_link_color'] = $attitude_theme_options_defaults['attitude_link_color'];	
	}else{
		if ( isset( $input['color_scheme'] ) ) {
			$input_validated['color_scheme'] = stripslashes($input['color_scheme']);
		}
		if ( isset( $input['attitude_slogan_slider_title_color'] ) ) {
			$input_validated['attitude_slogan_slider_title_color'] = stripslashes($input['attitude_slogan_slider_title_color']);
		}
		if ( isset( $input['attitude_buttons_color'] ) ) {
			$input_validated['attitude_buttons_color'] = stripslashes($input['attitude_buttons_color']);
		}
		if ( isset( $input['attitude_link_color'] ) ) {
			$input_validated['attitude_link_color'] = stripslashes($input['attitude_link_color']);
		}
	}

	//Colors Validation
	if( isset( $input['reset_colors'] ) && $input['reset_colors'] == 'Reset Defaults' ) {
			$input_validated['attitude_input_field_color'] = $attitude_theme_options_defaults['attitude_input_field_color'];
			$input_validated['attitude_content_background_color'] = $attitude_theme_options_defaults['attitude_content_background_color'];
			$input_validated['attitude_footer_background_color'] = $attitude_theme_options_defaults['attitude_footer_background_color'];
			$input_validated['attitude_sitegenerator_background_color'] = $attitude_theme_options_defaults['attitude_sitegenerator_background_color'];
			$input_validated['attitude_header_search_color'] = $attitude_theme_options_defaults['attitude_header_search_color'];
			$input_validated['attitude_page_title_wrap_color'] = $attitude_theme_options_defaults['attitude_page_title_wrap_color'];
			$input_validated['attitude_top_navigation_background_color'] = $attitude_theme_options_defaults['attitude_top_navigation_background_color'];
			$input_validated['attitude_sticky_post_color'] = $attitude_theme_options_defaults['attitude_sticky_post_color'];		
			
		
	}else{
		if ( isset( $input['attitude_input_field_color'] ) ) {
			$input_validated['attitude_input_field_color'] = stripslashes($input['attitude_input_field_color']);
		}
		if ( isset( $input['attitude_content_background_color'] ) ) {
			$input_validated['attitude_content_background_color'] = stripslashes($input['attitude_content_background_color']);
		}
		if ( isset( $input['attitude_footer_background_color'] ) ) {
			$input_validated['attitude_footer_background_color'] = stripslashes($input['attitude_footer_background_color']);
		}
		if ( isset( $input['attitude_sitegenerator_background_color'] ) ) {
			$input_validated['attitude_sitegenerator_background_color'] = stripslashes($input['attitude_sitegenerator_background_color']);
		}
		if ( isset( $input['attitude_header_search_color'] ) ) {
			$input_validated['attitude_header_search_color'] = stripslashes($input['attitude_header_search_color']);
		}
		if ( isset( $input['attitude_page_title_wrap_color'] ) ) {
			$input_validated['attitude_page_title_wrap_color'] = stripslashes($input['attitude_page_title_wrap_color']);
		}
		if ( isset( $input['attitude_top_navigation_background_color'] ) ) {
			$input_validated['attitude_top_navigation_background_color'] = stripslashes($input['attitude_top_navigation_background_color']);
		}
		if ( isset( $input['attitude_sticky_post_color'] ) ) {
			$input_validated['attitude_sticky_post_color'] = stripslashes($input['attitude_sticky_post_color']);
		}
	}

	//Background pattern validation
	if( isset( $input['reset_background'] ) && $input['reset_background'] == 'Reset Defaults' ) {
			$input_validated['content_background_pattern'] = $attitude_theme_options_defaults['content_background_pattern'];
			$input_validated['footer_background_pattern'] = $attitude_theme_options_defaults['footer_background_pattern'];
			$input_validated['sitegenerator_background_pattern'] = $attitude_theme_options_defaults['sitegenerator_background_pattern'];		
	}else{
		//Content Background pattern validation
		if ( isset( $input['content_background_pattern'] ) ) {
				$input_validated['content_background_pattern'] = stripslashes($input['content_background_pattern']);
		}
		//Footer Background pattern validation
		if ( isset( $input['footer_background_pattern'] ) ) {
				$input_validated['footer_background_pattern'] = stripslashes($input['footer_background_pattern']);
		}
		//Sitegenerator Background pattern validation
		if ( isset( $input['sitegenerator_background_pattern'] ) ) {
				$input_validated['sitegenerator_background_pattern'] = stripslashes($input['sitegenerator_background_pattern']);
		}
	}


	if ( isset( $input[ 'header_logo' ] ) ) {
		$input_validated[ 'header_logo' ] = esc_url_raw( $input[ 'header_logo' ] );
	}

	if( isset( $input[ 'header_show' ] ) ) {
		$input_validated[ 'header_show' ] = $input[ 'header_show' ];
	}

	if( isset( $input[ 'header_position' ] ) ) {
		$input_validated[ 'header_position' ] = $input[ 'header_position' ];
	}

	if( isset( $input[ 'menu_position' ] ) ) {
		$input_validated[ 'menu_position' ] = $input[ 'menu_position' ];
	}

   if ( isset( $options[ 'hide_header_searchform' ] ) ) {
		$input_validated[ 'hide_header_searchform' ] = $input[ 'hide_header_searchform' ];
	}
    
	if ( isset( $options[ 'disable_slogan' ] ) ) {
		$input_validated[ 'disable_slogan' ] = $input[ 'disable_slogan' ];
	}

	if( isset( $options[ 'home_slogan1' ] ) ) {
		$input_validated[ 'home_slogan1' ] = sanitize_text_field( $input[ 'home_slogan1' ] );
	}

	if( isset( $options[ 'home_slogan2' ] ) ) {
		$input_validated[ 'home_slogan2' ] = sanitize_text_field( $input[ 'home_slogan2' ] );
	}

	if( isset( $input[ 'slogan_position' ] ) ) {
		$input_validated[ 'slogan_position' ] = $input[ 'slogan_position' ];
	}	

	if( isset( $options[ 'button_text' ] ) ) {
		$input_validated[ 'button_text' ] = sanitize_text_field( $input[ 'button_text' ] );
	}

	if( isset( $options[ 'redirect_button_link' ] ) ) {
		$input_validated[ 'redirect_button_link' ] = esc_url_raw( $input[ 'redirect_button_link' ] );
	}

	if( isset( $input[ 'reset_foooterinfo' ] ) ) {
		$input_validated[ 'reset_foooterinfo' ] = $input[ 'reset_foooterinfo' ];
	}

	if( 0 == $input_validated[ 'reset_foooterinfo' ] ) {
		if( isset( $input[ 'footer_code' ] ) ) {
			$input_validated['footer_code'] =  stripslashes( wp_filter_post_kses( addslashes ( $input['footer_code'] ) ) );
		}
	}
	else {
		$input_validated['footer_code'] = $attitude_theme_options_defaults[ 'footer_code' ];
	}

	if ( isset( $input[ 'excerpt_length' ] ) ) {
		$input_validated[ 'excerpt_length' ] = absint( $input[ 'excerpt_length' ] ) ? $input [ 'excerpt_length' ] : 30;
	}

	if( isset( $input[ 'post_excerpt_more_text' ] ) ) {
		$input_validated[ 'post_excerpt_more_text' ] = sanitize_text_field( $input[ 'post_excerpt_more_text' ] );
	}

	if ( isset( $input[ 'gallery_posts_number' ] ) ) {
		$input_validated[ 'gallery_posts_number' ] = absint( $input[ 'gallery_posts_number' ] ) ? $input [ 'gallery_posts_number' ] : 12;
	}

	//Site Layout
	if( isset( $input[ 'site_layout' ] ) ) {
		$input_validated[ 'site_layout' ] = $input[ 'site_layout' ];
	}

   // Front page posts categories
	if( isset( $input['front_page_category' ] ) ) {
		$input_validated['front_page_category'] = $input['front_page_category'];
	}

	if( isset( $input[ 'slider_type' ] ) ) {
		$input_validated[ 'slider_type' ] = $input[ 'slider_type' ];
	}

	if( isset( $input[ 'featured_text_position' ] ) ) {
		$input_validated[ 'featured_text_position' ] = $input[ 'featured_text_position' ];
	}

	if( isset( $input[ 'slider_status' ] ) ) {
		$input_validated[ 'slider_status' ] = $input[ 'slider_status' ];
	}
    
	// Data Validation for Featured Slider
	if( isset( $input[ 'disable_slider' ] ) ) {
		$input_validated[ 'disable_slider' ] = $input[ 'disable_slider' ];
	}

	if ( isset( $input[ 'slider_quantity' ] ) ) {
		$input_validated[ 'slider_quantity' ] = absint( $input[ 'slider_quantity' ] ) ? $input [ 'slider_quantity' ] : 4;
	}
	if ( isset( $input['exclude_slider_post'] ) ) {
		$input_validated[ 'exclude_slider_post' ] = $input[ 'exclude_slider_post' ];	

	}
	if ( isset( $input[ 'featured_post_slider' ] ) ) {
		$input_validated[ 'featured_post_slider' ] = array();
	}   
	if( isset( $input[ 'slider_quantity' ] ) )   
	for ( $i = 1; $i <= $input [ 'slider_quantity' ]; $i++ ) {
		if ( intval( $input[ 'featured_post_slider' ][ $i ] ) ) {
			$input_validated[ 'featured_post_slider' ][ $i ] = absint($input[ 'featured_post_slider' ][ $i ] );
		}
		$input_validated[ 'featured_image_slider_image' ][ $i ] = esc_url_raw($input[ 'featured_image_slider_image' ][ $i ] );
		$input_validated[ 'featured_image_slider_link' ][ $i ] = esc_url_raw($input[ 'featured_image_slider_link' ][ $i ]);
		$input_validated[ 'featured_image_slider_title' ][ $i ] = sanitize_text_field($input[ 'featured_image_slider_title' ][ $i ]);
		$input_validated[ 'featured_image_slider_description' ][ $i ] = wp_kses_stripslashes($input[ 'featured_image_slider_description' ][ $i ]);
	}
    
   // data validation for transition effect
	if( isset( $input[ 'transition_effect' ] ) ) {
		$input_validated['transition_effect'] = wp_filter_nohtml_kses( $input['transition_effect'] );
	}

	// data validation for transition delay
	if ( isset( $input[ 'transition_delay' ] ) && is_numeric( $input[ 'transition_delay' ] ) ) {
		$input_validated[ 'transition_delay' ] = $input[ 'transition_delay' ];
	}

	// data validation for transition length
	if ( isset( $input[ 'transition_duration' ] ) && is_numeric( $input[ 'transition_duration' ] ) ) {
		$input_validated[ 'transition_duration' ] = $input[ 'transition_duration' ];
	}

	if( isset( $input[ 'header_slider' ] ) ) {
		$input_validated[ 'header_slider' ] = $input[ 'header_slider' ];
	}

	if ( isset( $input[ 'revslider_homepage' ] ) ) {
		$input_validated[ 'revslider_homepage' ] = $input[ 'revslider_homepage' ];	
	}  

	if( isset( $options[ 'pages_id_revslider' ] ) ) {
		$input_validated[ 'pages_id_revslider' ] = sanitize_text_field( $input[ 'pages_id_revslider' ] );
	}
    
   // data validation for Social Icons
	if( isset( $input[ 'social_facebook' ] ) ) {
		$input_validated[ 'social_facebook' ] = esc_url_raw( $input[ 'social_facebook' ] );
	}
	if( isset( $input[ 'social_twitter' ] ) ) {
		$input_validated[ 'social_twitter' ] = esc_url_raw( $input[ 'social_twitter' ] );
	}
	if( isset( $input[ 'social_googleplus' ] ) ) {
		$input_validated[ 'social_googleplus' ] = esc_url_raw( $input[ 'social_googleplus' ] );
	}
	if( isset( $input[ 'social_pinterest' ] ) ) {
		$input_validated[ 'social_pinterest' ] = esc_url_raw( $input[ 'social_pinterest' ] );
	}   
	if( isset( $input[ 'social_youtube' ] ) ) {
		$input_validated[ 'social_youtube' ] = esc_url_raw( $input[ 'social_youtube' ] );
	}
	if( isset( $input[ 'social_vimeo' ] ) ) {
		$input_validated[ 'social_vimeo' ] = esc_url_raw( $input[ 'social_vimeo' ] );
	}   
	if( isset( $input[ 'social_linkedin' ] ) ) {
		$input_validated[ 'social_linkedin' ] = esc_url_raw( $input[ 'social_linkedin' ] );
	}
	if( isset( $input[ 'social_flickr' ] ) ) {
		$input_validated[ 'social_flickr' ] = esc_url_raw( $input[ 'social_flickr' ] );
	}
	if( isset( $input[ 'social_tumblr' ] ) ) {
		$input_validated[ 'social_tumblr' ] = esc_url_raw( $input[ 'social_tumblr' ] );
	}   
	if( isset( $input[ 'social_myspace' ] ) ) {
		$input_validated[ 'social_myspace' ] = esc_url_raw( $input[ 'social_myspace' ] );
	}  
	if( isset( $input[ 'social_rss' ] ) ) {
		$input_validated[ 'social_rss' ] = esc_url_raw( $input[ 'social_rss' ] );
	}
	if( isset( $input[ 'social_dribbble' ] ) ) {
		$input_validated[ 'social_dribbble' ] = esc_url_raw( $input[ 'social_dribbble' ] );
	}
	if( isset( $input[ 'social_wordpress' ] ) ) {
		$input_validated[ 'social_wordpress' ] = esc_url_raw( $input[ 'social_wordpress' ] );
	}
	if( isset( $input[ 'social_deviantart' ] ) ) {
		$input_validated[ 'social_deviantart' ] = esc_url_raw( $input[ 'social_deviantart' ] );
	}
	if( isset( $input[ 'social_aim' ] ) ) {
		$input_validated[ 'social_aim' ] = esc_url_raw( $input[ 'social_aim' ] );
	}
	if( isset( $input[ 'social_github' ] ) ) {
		$input_validated[ 'social_github' ] = esc_url_raw( $input[ 'social_github' ] );
	}
	if( isset( $input[ 'social_blogger' ] ) ) {
		$input_validated[ 'social_blogger' ] = esc_url_raw( $input[ 'social_blogger' ] );
	}
	if( isset( $input[ 'social_stumbleupon' ] ) ) {
		$input_validated[ 'social_stumbleupon' ] = esc_url_raw( $input[ 'social_stumbleupon' ] );
	}
	if( isset( $input[ 'social_skype' ] ) ) {
		$input_validated[ 'social_skype' ] = esc_url_raw( $input[ 'social_skype' ] );
	}
	if( isset( $input[ 'social_foursquare' ] ) ) {
		$input_validated[ 'social_foursquare' ] = esc_url_raw( $input[ 'social_foursquare' ] );
	}
	if( isset( $input[ 'social_picasa' ] ) ) {
		$input_validated[ 'social_picasa' ] = esc_url_raw( $input[ 'social_picasa' ] );
	}
	if( isset( $input[ 'social_path' ] ) ) {
		$input_validated[ 'social_path' ] = esc_url_raw( $input[ 'social_path' ] );
	}
	if( isset( $input[ 'social_slideshare' ] ) ) {
		$input_validated[ 'social_slideshare' ] = esc_url_raw( $input[ 'social_slideshare' ] );
	}
	if( isset( $input[ 'social_paypal' ] ) ) {
		$input_validated[ 'social_paypal' ] = esc_url_raw( $input[ 'social_paypal' ] );
	}
	if( isset( $input[ 'social_delicious' ] ) ) {
		$input_validated[ 'social_delicious' ] = esc_url_raw( $input[ 'social_delicious' ] );
	}
	if( isset( $input[ 'social_lastfm' ] ) ) {
		$input_validated[ 'social_lastfm' ] = esc_url_raw( $input[ 'social_lastfm' ] );
	} 
	if( isset( $input[ 'social_behance' ] ) ) {
		$input_validated[ 'social_behance' ] = esc_url_raw( $input[ 'social_behance' ] );
	} 
	if( isset( $input[ 'social_netvibes' ] ) ) {
		$input_validated[ 'social_netvibes' ] = esc_url_raw( $input[ 'social_netvibes' ] );
	} 
	if( isset( $input[ 'social_digg' ] ) ) {
		$input_validated[ 'social_digg' ] = esc_url_raw( $input[ 'social_digg' ] );
	} 
	if( isset( $input[ 'social_reddit' ] ) ) {
		$input_validated[ 'social_reddit' ] = esc_url_raw( $input[ 'social_reddit' ] );
	} 
	if( isset( $input[ 'social_mail' ] ) ) {
		$input_validated[ 'social_mail' ] = esc_url_raw( $input[ 'social_mail' ] );
	} 
	if( isset( $input[ 'social_instagram' ] ) ) {
		$input_validated[ 'social_instagram' ] = esc_url_raw( $input[ 'social_instagram' ] );
	} 
	if( isset( $input[ 'social_xing' ] ) ) {
		$input_validated[ 'social_xing' ] = esc_url_raw( $input[ 'social_xing' ] );
	}   
    
	//Custom CSS Style Validation
	if ( isset( $input['custom_css'] ) ) {
		$input_validated['custom_css'] = wp_filter_nohtml_kses($input['custom_css']);
	}
        
	//Webmaster Tool Verification
	if( isset( $input[ 'google_verification' ] ) ) {
		$input_validated[ 'google_verification' ] = wp_filter_post_kses( $input[ 'google_verification' ] );
	}
	if( isset( $input[ 'yahoo_verification' ] ) ) {
		$input_validated[ 'yahoo_verification' ] = wp_filter_post_kses( $input[ 'yahoo_verification' ] );
	}
	if( isset( $input[ 'bing_verification' ] ) ) {
		$input_validated[ 'bing_verification' ] = wp_filter_post_kses( $input[ 'bing_verification' ] );
	}   
	if( isset( $input[ 'analytic_header' ] ) ) {
		$input_validated[ 'analytic_header' ] = wp_kses_stripslashes( $input[ 'analytic_header' ] );
	}
	if( isset( $input[ 'analytic_footer' ] ) ) {
		$input_validated[ 'analytic_footer' ] = wp_kses_stripslashes( $input[ 'analytic_footer' ] );    
	}       
    
	// Layout settings verification
	if( isset( $input[ 'reset_layout' ] ) ) {
		$input_validated[ 'reset_layout' ] = $input[ 'reset_layout' ];
	}
	if( 0 == $input_validated[ 'reset_layout' ] ) {
		if( isset( $input[ 'default_layout' ] ) ) {
			$input_validated[ 'default_layout' ] = $input[ 'default_layout' ];
		}
	}
	else {
		$input_validated['default_layout'] = $attitude_theme_options_defaults[ 'default_layout' ];
	}

	//Feed Redirect
	if(isset($input['feed_url'])){
		$input_validated['feed_url'] = esc_url_raw($input['feed_url']);
   }
	//Clearing the theme option cache
	if( function_exists( 'attitude_themeoption_invalidate_caches' ) ) attitude_themeoption_invalidate_caches();
    
   return $input_validated;
}

?>