<?php 
/**
 * @package Theme Horse
 * @subpackage Attitude
 * @since Attitude 3.0
 */
if ( ! class_exists( 'WP_Customize_Section' ) ) {
	return null;
}
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
function attitude_textarea_register($wp_customize){
	class Attitude_Customize_Attitude_upgrade extends WP_Customize_Control {
		public function render_content() { ?>
		<div class="theme-info"> 
			<a href="<?php echo esc_url( 'http://themehorse.com/theme-instruction/attitude-pro/' ); ?>" title="<?php esc_attr_e( 'Attitude Pro Theme Instructions', 'attitude' ); ?>" target="_blank">
			<?php _e( 'Theme Instructions', 'attitude' ); ?>
			</a>
			<a href="<?php echo esc_url( 'http://themehorse.com/support-forum/' ); ?>" title="<?php esc_attr_e( 'Support Forum', 'attitude' ); ?>" target="_blank">
			<?php _e( 'Support Forum', 'attitude' ); ?>
			</a>
			<a href="<?php echo esc_url( 'http://themehorse.com/preview/attitude-pro/' ); ?>" title="<?php esc_attr_e( 'Attitude Pro Demo', 'attitude' ); ?>" target="_blank">
			<?php _e( 'View Demo', 'attitude' ); ?>
			</a>
		</div>
		<?php
		}
	}
	class Attitude_Customize_Typography_Options extends WP_Customize_Control {
		public function render_content() { 
			_e('Set your Typography Options from Theme Options', 'attitude');?> <br/>
			<a href="<?php echo esc_url( home_url() );?>/wp-admin/themes.php?page=theme_options" title="<?php esc_attr_e( 'Typography Options', 'attitude' ); ?>" target="_blank">
			<?php _e( 'Typography Options', 'attitude' ); ?>
			</a>
		<?php
		}
	}
	class Attitude_Customize_Color_Options extends WP_Customize_Control {
		public function render_content() { 
			_e('Set your Color Options from Theme Options', 'attitude');?> <br/>
			<a href="<?php echo esc_url( home_url() );?>/wp-admin/themes.php?page=theme_options" title="<?php esc_attr_e( 'Color Options', 'attitude' ); ?>" target="_blank">
			<?php _e( 'Color Options', 'attitude' ); ?>
			</a>
		<?php
		}
	}
	class Attitude_Customize_Background_Pattern extends WP_Customize_Control {
		public function render_content() { 
			_e('Set your Background Pattern from Theme Options', 'attitude');?> <br/>
			<a href="<?php echo esc_url( home_url() );?>/wp-admin/themes.php?page=theme_options" title="<?php esc_attr_e( 'Background Pattern', 'attitude' ); ?>" target="_blank">
			<?php _e( 'Background Pattern', 'attitude' ); ?>
			</a>
		<?php
		}
	}
	class Attitude_Customize_Category_Control extends WP_Customize_Control {
		/**
		* The type of customize control being rendered.
		*/
		public $type = 'multiple-select';
		/**
		* Displays the multiple select on the customize screen.
		*/
		public function render_content() {
		global $options, $array_of_default_settings;
		$options = wp_parse_args(  get_option( 'attitude_theme_options', array() ),  attitude_get_option_defaults());
		$categories = get_categories(); ?>
			<label>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<select <?php $this->link(); ?> multiple="multiple" style="height: 100%;">
				<option value="0" <?php if ( empty( $options['front_page_category'] ) ) { selected( true, true ); } ?>><?php _e( '--Disabled--', 'attitude' ); ?></option>
				<?php
					foreach ( $categories as $category) :?>
						<option value="<?php echo $category->cat_ID; ?>" <?php if ( in_array( $category->cat_ID, $options['front_page_category']) ) { echo 'selected="selected"';}?>><?php echo $category->cat_name; ?></option>
					<?php endforeach; ?>
				</select>
			</label>
		<?php 
		}
	}
	class Attitude_Revolution_Slider_Control extends WP_Customize_Control {
		public function render_content() { ?>
		 <?php
			if ( is_plugin_active( 'revslider/revslider.php' ) ) {
								$slider = new RevSlider();
								$objSliders = $slider->get_sliders();
								if(empty($objSliders))
									echo __( 'No sliders found, Please create a slider. You can create it', 'attitude' ).'  '.'<a href="'.esc_url( home_url() ).'/wp-admin/themes.php?page=revslider">'.__( 'here', 'attitude' ).'</a>';
								else{
								?>
								<label>
									<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
									<select <?php $this->link(); ?> style="height: 100%;">
									<?php
										foreach ( $objSliders as $slider) :?>
										 <option value="<?php echo esc_attr( $slider->alias ); ?>" <?php selected( 'attitude_revolution_options', $slider->alias ); ?>><?php echo esc_html($slider->title); ?></option>
										<?php endforeach; ?>
									</select>
								</label>
								<?php } ?>
		<?php
			}
		}
	}
}

function attitude_customize_register($wp_customize){
	$wp_customize->add_panel( 'attitude_design_options_panel', array(
	'priority'       => 200,
	'capability'     => 'edit_theme_options',
	'title'          => __('Design Options', 'attitude')
	));

	$wp_customize->add_panel( 'attitude_advanced_options_panel', array(
	'priority'       => 300,
	'capability'     => 'edit_theme_options',
	'title'          => __('Advanced Options', 'attitude')
	));

	$wp_customize->add_panel( 'attitude_featured_post_page_panel', array(
	'priority'       => 400,
	'capability'     => 'edit_theme_options',
	'title'          => __('Slider Options', 'attitude')
	));

	$wp_customize->add_panel( 'attitude_webmaster_tools_panel', array(
	'priority'       => 600,
	'capability'     => 'edit_theme_options',
	'title'          => __('Webmaster Tools', 'attitude')
	));

	global $options, $array_of_default_settings;
	$options = wp_parse_args(  get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());
/********************Attitude Upgrade ******************************************/
	$wp_customize->add_section('attitude_upgrade', array(
		'title'					=> __('Attitude Support', 'attitude'),
		'priority'				=> 1,
	));
	$wp_customize->add_setting( 'attitude_theme_options[attitude_upgrade]', array(
		'default'				=> false,
		'capability'			=> 'edit_theme_options',
		'sanitize_callback'	=> 'wp_filter_nohtml_kses',
	));
	$wp_customize->add_control(
		new Attitude_Customize_Attitude_upgrade(
		$wp_customize,
		'attitude_upgrade',
			array(
				'label'					=> __('Attitude Upgrade','attitude'),
				'section'				=> 'attitude_upgrade',
				'settings'				=> 'attitude_theme_options[attitude_upgrade]',
			)
		)
	);
	/******************** Design Options ******************************************/
/******************** Custom Header ******************************************/
	$wp_customize->add_section('custom_header_setting', array(
		'title'					=> __('Custom Header', 'attitude'),
		'priority'				=> 200,
		'panel'					=>'attitude_design_options_panel'
	));
	$wp_customize->add_setting( 'attitude_theme_options[hide_header_searchform]', array(
		'default'				=> 0,
		'sanitize_callback'	=> 'prefix_sanitize_integer',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options'
	));
	$wp_customize->add_control( 'custom_header_setting', array(
		'label'					=> __('Hide Searchform from Header', 'attitude'),
		'section'				=> 'custom_header_setting',
		'settings'				=> 'attitude_theme_options[hide_header_searchform]',
		'type'					=> 'checkbox',
	));
	$wp_customize->add_setting( 'attitude_theme_options[header_logo]',array(
		'sanitize_callback'	=> 'esc_url_raw',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options'
	));
	$wp_customize->add_control(
		new WP_Customize_Image_Control(
		$wp_customize,
		'header_logo',
			array(
				'label'				=> __('Header Logo','attitude'),
				'section'			=> 'custom_header_setting',
				'settings'			=> 'attitude_theme_options[header_logo]'
			)
		)
	);
	$wp_customize->add_setting('attitude_theme_options[header_show]', array(
		'default'				=> 'header-text',
		'sanitize_callback'	=> 'prefix_sanitize_integer',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options'
	));
	$wp_customize->add_control('custom_header_display', array(
		'label'					=> __('Display', 'attitude'),
		'section'				=> 'custom_header_setting',
		'settings'				=> 'attitude_theme_options[header_show]',
		'type'					=> 'radio',
		'checked'				=> 'checked',
			'choices'			=> array(
			'header-logo'		=> __('Header Logo Only','attitude'),
			'header-text'		=> __('Header Text Only','attitude'),
			'disable-both'		=> __('Disable','attitude'),
			),
	));
	$wp_customize->add_setting('attitude_theme_options[header_position]', array(
		'default'				=> 'default-position',
		'sanitize_callback'	=> 'prefix_sanitize_integer',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options'
	));
	$wp_customize->add_control('custom_header_positon', array(
		'label'					=> __('Header Text/Logo Position', 'attitude'),
		'section'				=> 'custom_header_setting',
		'settings'				=> 'attitude_theme_options[header_position]',
		'type'					=> 'radio',
		'checked'				=> 'checked',
			'choices'			=> array(
			'default-position'		=> __('Default/ Left Side','attitude'),
			'center-position'		=> __('Center','attitude'),
			'right-position'		=> __('Right Side','attitude'),
			),
	));
	$wp_customize->add_setting('attitude_theme_options[menu_position]', array(
		'default'				=> 'default-position',
		'sanitize_callback'	=> 'prefix_sanitize_integer',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options'
	));
	$wp_customize->add_control('custom_menu_positon', array(
		'label'					=> __('Header Menu Position', 'attitude'),
		'section'				=> 'custom_header_setting',
		'settings'				=> 'attitude_theme_options[menu_position]',
		'type'					=> 'radio',
		'checked'				=> 'checked',
			'choices'			=> array(
			'default-position'		=> __('Default/ Left Side','attitude'),
			'center-position'		=> __('Center','attitude'),
			'right-position'		=> __('Right Side','attitude'),
			),
	));
	/********************Site Layout Options******************************************/
	$wp_customize->add_section('attitude_site_layout', array(
		'title'					=> __('Site Layout Options', 'attitude'),
		'priority'				=> 230,
		'panel'					=>'attitude_design_options_panel'
	));
	$wp_customize->add_setting('attitude_theme_options[site_layout]', array(
		'default'				=> 'narrow-layout',
		'sanitize_callback'	=> 'prefix_sanitize_integer',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options'
	));
	$wp_customize->add_control('attitude_site_layout', array(
		'section'				=> 'attitude_site_layout',
		'settings'				=> 'attitude_theme_options[site_layout]',
		'type'					=> 'radio',
		'checked'				=> 'checked',
		'choices'				=> array(
			'wide-layout'					=> __('Wide Layout','attitude'),
			'narrow-layout'					=> __('Narrow Layout','attitude'),
		),
	));
	/********************Default Layout options ******************************************/
	$wp_customize->add_section('attitude_default_layout', array(
		'title'					=> __('Default Layout Options', 'attitude'),
		'description'			=> __('Make sure that you have not set the layout from specific page','attitude'),
		'priority'				=> 240,
		'panel'					=>'attitude_design_options_panel'
	));
	$wp_customize->add_setting('attitude_theme_options[default_layout]', array(
		'default'				=> 'right-sidebar',
		'sanitize_callback'	=> 'prefix_sanitize_integer',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options'
	));
	$wp_customize->add_control('attitude_default_layout', array(
		'section'				=> 'attitude_default_layout',
		'settings'				=> 'attitude_theme_options[default_layout]',
		'type'					=> 'radio',
		'checked'				=> 'checked',
		'choices'				=> array(
			'right-sidebar'				=> __('Right Sidebar','attitude'),
			'left-sidebar'				=> __('Left Sidebar','attitude'),
			'no-sidebar'			=> __('No Sidebar','attitude'),
			'no-sidebar-full-width'			=> __('No Sidebar, Full Width','attitude'),
			'no-sidebar-one-column'	=> __('No Sidebar, One Column','attitude'),
		),
	));
	/********************Custom Css ******************************************/
	$wp_customize->add_section( 'attitude_custom_css', array(
		'title'					=> __('Custom CSS', 'attitude'),
		'description'			=> __('This CSS will overwrite the CSS of style.css file.','attitude'),
		'priority'				=> 250,
		'panel'					=>'attitude_design_options_panel'
	));
	$wp_customize->add_setting( 'attitude_theme_options[custom_css]', array(
		'default'				=> '',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'wp_filter_nohtml_kses'
	));
	$wp_customize->add_control( 'custom_css', array(
		'section'				=> 'attitude_custom_css',
				'settings'				=> 'attitude_theme_options[custom_css]',
				'type'					=> 'textarea'
	));
	/******************** Typography Options ******************************************/
	$wp_customize->add_section( 'attitude_typography_options', array(
		'title'					=> __('Typography Options', 'attitude'),
		'priority'				=> 260,
		'panel'					=>'attitude_design_options_panel'
	));
	$wp_customize->add_setting( 'attitude_theme_options[typography_options]', array(
		'default'				=> false,
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'wp_filter_nohtml_kses'
	));
	$wp_customize->add_control( new Attitude_Customize_Typography_Options(
		$wp_customize,
		'attitude_typography_options', array(
		'section'				=> 'attitude_typography_options',
		'settings'				=> 'attitude_theme_options[typography_options]',
	)));
	/******************** Color Options ******************************************/
	$wp_customize->add_section( 'attitude_color_options', array(
		'title'					=> __('Color Options', 'attitude'),
		'priority'				=> 270,
		'panel'					=>'attitude_design_options_panel'
	));
	$wp_customize->add_setting( 'attitude_theme_options[color_options]', array(
		'default'				=> false,
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'wp_filter_nohtml_kses'
	));
	$wp_customize->add_control( new Attitude_Customize_Color_Options(
		$wp_customize,
		'attitude_color_options', array(
		'section'				=> 'attitude_color_options',
		'settings'				=> 'attitude_theme_options[color_options]',
	)));
	/******************** Background Pattern ******************************************/
	$wp_customize->add_section( 'attitude_background_pattern', array(
		'title'					=> __('Background Pattern', 'attitude'),
		'priority'				=> 280,
		'panel'					=>'attitude_design_options_panel'
	));
	$wp_customize->add_setting( 'attitude_theme_options[background_pattern]', array(
		'default'				=> false,
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'wp_filter_nohtml_kses'
	));
	$wp_customize->add_control( new Attitude_Customize_Background_Pattern(
		$wp_customize,
		'attitude_background_pattern', array(
		'section'				=> 'attitude_background_pattern',
		'settings'				=> 'attitude_theme_options[background_pattern]',
	)));
	/******************** Advanced Options ******************************************/
	/******************** Home Slogan Options ******************************************/
	$wp_customize->add_section('home_slogan_options', array(
		'title'					=> __('Home Slogan Options', 'attitude'),
		'priority'				=> 300,
		'panel'					=>'attitude_advanced_options_panel'
	));
	$wp_customize->add_setting( 'attitude_theme_options[disable_slogan]', array(
		'default'				=> 0,
		'sanitize_callback'	=> 'prefix_sanitize_integer',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options'
	));
	$wp_customize->add_control( 'home_slogan_options', array(
		'label'					=> __('Disable Slogan Part', 'attitude'),
		'section'				=> 'home_slogan_options',
		'settings'				=> 'attitude_theme_options[disable_slogan]',
		'type'					=> 'checkbox',
	));
	$wp_customize->add_setting('attitude_theme_options[slogan_position]', array(
		'default'				=> 'below-slider',
		'sanitize_callback'	=> 'prefix_sanitize_integer',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options'
	));
	$wp_customize->add_control('attitude_design_layout', array(
		'label'					=> __('Slogan Position', 'attitude'),
		'section'				=> 'home_slogan_options',
		'settings'				=> 'attitude_theme_options[slogan_position]',
		'type'					=> 'radio',
		'checked'				=> 'checked',
		'choices'				=> array(
			'below-slider'					=> __('Below Slider','attitude'),
			'above-slider'					=> __('Above Slider','attitude'),
		),
	));
	$wp_customize->add_setting( 'attitude_theme_options[home_slogan1]', array(
		'default'				=> '',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'esc_textarea'
	));
	$wp_customize->add_control( 'home_slogan1', array(
		'label'					=> __('Home Page Slogan1', 'attitude'),
		'description'			=> __('The appropriate length of the slogan is around 10 words.','attitude'),
		'section'				=> 'home_slogan_options',
		'settings'				=> 'attitude_theme_options[home_slogan1]',
		'type'					=> 'textarea'
	));
	$wp_customize->add_setting( 'attitude_theme_options[home_slogan2]', array(
		'default'				=> '',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'esc_textarea'
	));
	$wp_customize->add_control( 'home_slogan2', array(
		'label'					=> __('Home Page Slogan2', 'attitude'),
		'description'			=> __('The appropriate length of the slogan is around 10 words.','attitude'),
		'section'				=> 'home_slogan_options',
		'settings'				=> 'attitude_theme_options[home_slogan2]',
		'type'					=> 'textarea'
	));
	$wp_customize->add_setting('attitude_theme_options[button_text]', array(
		'default'					=>'',
		'sanitize_callback'		=> 'sanitize_text_field',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('button_text', array(
		'label'						=> __('Redirect Button Text', 'attitude'),
		'description'			=> __('Text to show in Button','attitude'),
		'section'					=> 'home_slogan_options',
		'settings'					=> 'attitude_theme_options[button_text]',
		'type'						=> 'text',
	));
	$wp_customize->add_setting('attitude_theme_options[redirect_button_link]', array(
		'default'					=>'',
		'sanitize_callback'		=> 'esc_url_raw',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('redirect_button_link', array(
		'label'						=> __('Redirect Button Link', 'attitude'),
		'description'			=> __('Link this button to show your special work, portfolio','attitude'),
		'section'					=> 'home_slogan_options',
		'settings'					=> 'attitude_theme_options[redirect_button_link]',
		'type'						=> 'text',
	));
	/******************** Feed Url *****************************************/
	$wp_customize->add_section('feed_redirect', array(
		'title'					=> __('Feed Redirect', 'attitude'),
		'priority'				=> 310,
		'panel'					=>'attitude_advanced_options_panel'
	));
	$wp_customize->add_setting('attitude_theme_options[feed_url]', array(
		'default'					=>'',
		'sanitize_callback'		=> 'esc_url',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('feed_url', array(
		'priority'					=>9,
		'label'						=> __('Feed Redirect URL', 'attitude'),
		'section'					=> 'feed_redirect',
		'settings'					=> 'attitude_theme_options[feed_url]',
		'type'						=> 'text',
	));
	/******************** Homepage / Frontpage Category Setting *********************/
	$wp_customize->add_section(
		'attitude_category_section', array(
		'title' 						=> __('Homepage / Frontpage Category Setting','attitude'),
		'description'				=> __('Only posts that belong to the categories selected here will be displayed on the front page. ( You may select multiple categories by holding down the CTRL key. ) ','attitude'),
		'priority'					=> 320,
		'panel'					=>'attitude_advanced_options_panel'
	));
	$wp_customize->add_setting( 'attitude_theme_options[front_page_category]', array(
		'default'					=>array(),
		'sanitize_callback'		=> 'prefix_sanitize_integer',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control(
		new Attitude_Customize_Category_Control(
		$wp_customize,
			'front_page_category',
			array(
			'label'					=> __('Front page posts categories','attitude'),
			'section'				=> 'attitude_category_section',
			'settings'				=> 'attitude_theme_options[front_page_category]',
			'type'					=> 'multiple-select',
			)
		)
	);
	/******************** Excerpt Options *********************************************/
	$wp_customize->add_section( 'attitude_excerpt_section', array(
		'title' 						=> __('Excerpt Options','attitude'),
		'priority'					=> 330,
		'panel'						=>'attitude_advanced_options_panel'
	));
	$wp_customize->add_setting('attitude_theme_options[excerpt_length]', array(
		'default'					=> '40',
		'sanitize_callback'		=> 'attitude_sanatize_excerpt_length',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('excerpt_length', array(
		'label'						=> __('Excerpt Length', 'attitude'),
		'section'					=> 'attitude_excerpt_section',
		'type'						=> 'text',
		'settings'					=> 'attitude_theme_options[excerpt_length]'
	) );
	$wp_customize->add_setting('attitude_theme_options[post_excerpt_more_text]', array(
		'default'					=> 'Read more',
		'sanitize_callback'		=> 'sanitize_text_field',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('post_excerpt_more_text', array(
		'label'						=> __('Post Excerpt More Text', 'attitude'),
		'section'					=> 'attitude_excerpt_section',
		'type'						=> 'text',
		'settings'					=>'attitude_theme_options[post_excerpt_more_text]'
	) );
	/******************** Edit Footer Options *****************************************/
	$wp_customize->add_section('edit_footer_options', array(
		'title'					=> __('Edit Footer Options', 'attitude'),
		'priority'				=> 340,
		'panel'					=>'attitude_advanced_options_panel'
	));
	$wp_customize->add_setting('attitude_theme_options[footer_code]', array(
		'default'					=>'Copyright &copy; [the-year] [site-link] Theme by: [th-link] Powered by: [wp-link] ',
		'sanitize_callback'		=> 'footer_edit_validate',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('footer_code', array(
		'label'						=> __('Footer Editor', 'attitude'),
		'description'			=> __('You can add custom HTML and/or shortcodes, which will be automatically inserted into your theme.
Some shorcodes: [the-year], [site-link], [wp-link], [th-link] for current year, your site link, wordpress site link and attitude site link respectively.
It is completely optional, but if you like the Theme We would appreciate it if you keep the credit link at the bottom.','attitude'),
		'section'					=> 'edit_footer_options',
		'settings'					=> 'attitude_theme_options[footer_code]',
		'type'						=> 'textarea',
	));
	/********************Slider Options ******************************************************/
	/********************Featured Post/ Page Slider******************************************/
	$wp_customize->add_section( 'attitude_featured_content_setting', array(
		'title'					=> __('Slider Options', 'attitude'),
		'priority'				=> 400,
		'panel'					=>'attitude_featured_post_page_panel'
	));
	$wp_customize->add_setting('attitude_theme_options[slider_type]', array(
		'default'					=> 'post-slider',
		'sanitize_callback'		=> 'prefix_sanitize_integer',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('slider_type', array(
		'priority'					=> 402,
		'label'						=> __('Select Slider Type', 'attitude'),
		'section'					=> 'attitude_featured_content_setting',
		'settings'					=> 'attitude_theme_options[slider_type]',
		'type'						=> 'radio',
		'checked'					=> 'checked',
		'choices'					=> array(
			'post-slider'					=> __('Featured Post/Page Slider','attitude'),
			'image-slider'					=> __('Featured Image Slider','attitude'),
			'revolution-slider'			=> __('Revolution Slider','attitude'),
		),
	));
	$wp_customize->add_setting( 'attitude_theme_options[disable_slider]', array(
		'default'					=> 0,
		'sanitize_callback'		=> 'prefix_sanitize_integer',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control( 'attitude_disable_slider', array(
		'priority'					=>401,
		'label'						=> __('Disable Slider', 'attitude'),
		'section'					=> 'attitude_featured_content_setting',
		'settings'					=> 'attitude_theme_options[disable_slider]',
		'type'						=> 'checkbox',
	));
	$wp_customize->add_setting('attitude_theme_options[slider_status]', array(
		'default'					=> 'slider-on-homepage',
		'sanitize_callback'		=> 'prefix_sanitize_integer',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('slider_status', array(
		'label'						=> __('Slider Status', 'attitude'),
		'priority'					=> 412,
		'description'				=>__('The below mentioned options are only effective with the Featured Post/Page Slider and Featured Image Slider and not with the Revolution Slider', 'attitude'),
		'section'					=> 'attitude_featured_content_setting',
		'settings'					=> 'attitude_theme_options[slider_status]',
		'type'						=> 'radio',
		'checked'					=> 'checked',
		'choices'					=> array(
			'slider-on-homepage'				=> __('Enabale on Homepage/Frontpage','attitude'),
			'slider-on-everypage'			=> __('Enable on All Page','attitude')
		),
	));
	$wp_customize->add_setting('attitude_theme_options[featured_text_position]', array(
		'default'					=> 'default-position',
		'sanitize_callback'		=> 'prefix_sanitize_integer',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('featured_text_position', array(
		'label'						=> __('Featured Text Position', 'attitude'),
		'priority'					=> 414,
		'section'					=> 'attitude_featured_content_setting',
		'type'						=> 'radio',
		'settings'					=> 'attitude_theme_options[featured_text_position]',
		'checked'					=> 'checked',
		'choices'					=> array(
			'default-position'					=> __('Default/ Right Side','attitude'),
			'left-position'					=> __('Left Align','attitude'),
			'hide'					=> __('Hide','attitude')
		),
	));
	$wp_customize->add_setting('attitude_theme_options[slider_quantity]', array(
		'default'					=> '4',
		'sanitize_callback'		=> 'attitude_sanitize_delay_transition',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('slider_quantity', array(
		'priority'					=>420,
		'label'						=> __('Number of Slides', 'attitude'),
		'description'				=> __('Please refresh the page to display effect on Slider Quantity','attitude'),
		'section'					=> 'attitude_featured_content_setting',
		'settings'					=> 'attitude_theme_options[slider_quantity]',
		'type'						=> 'text',
	) );
	$wp_customize->add_setting('attitude_theme_options[transition_effect]', array(
		'default'					=> 'fade',
		'sanitize_callback'		=> 'attitude_sanitize_effect',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('transition_effect', array(
		'priority'					=>430,
		'label'						=> __('Transition Effect', 'attitude'),
		'section'					=> 'attitude_featured_content_setting',
		'settings'					=> 'attitude_theme_options[transition_effect]',
		'type'						=> 'select',
		'choices'					=> array(
			'fade'					=> __('Fade','attitude'),
			'wipe'					=> __('Wipe','attitude'),
			'scrollUp'				=> __('Scroll Up','attitude' ),
			'scrollDown'			=> __('Scroll Down','attitude' ),
			'scrollLeft'			=> __('Scroll Left','attitude' ),
			'scrollRight'			=> __('Scroll Right','attitude' ),
			'blindX'					=> __('Blind X','attitude' ),
			'blindY'					=> __('Blind Y','attitude' ),
			'blindZ'					=> __('Blind Z','attitude' ),
			'cover'					=> __('Cover','attitude' ),
			'shuffle'				=> __('Shuffle','attitude' ),
		),
	));
	$wp_customize->add_setting('attitude_theme_options[transition_delay]', array(
		'default'					=> '4',
		'sanitize_callback'		=> 'attitude_sanitize_delay_transition',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('transition_delay', array(
		'priority'					=>440,
		'label'						=> __('Transition Delay', 'attitude'),
		'section'					=> 'attitude_featured_content_setting',
		'settings'					=> 'attitude_theme_options[transition_delay]',
		'type'						=> 'text',
	) );
	$wp_customize->add_setting('attitude_theme_options[transition_duration]', array(
		'default'					=> '1',
		'sanitize_callback'		=> 'attitude_sanitize_delay_transition',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('transition_duration', array(
		'priority'					=>450,
		'label'						=> __('Transition Length', 'attitude'),
		'section'					=> 'attitude_featured_content_setting',
		'settings'					=> 'attitude_theme_options[transition_duration]',
		'type'						=> 'text',
	) );
/******************** Revolution Slider Options *********************************************/
	$wp_customize->add_section( 'attitude_revolution_options', array(
		'title' 						=> __('Revolution Slider Options','attitude'),
		'priority'					=> 550,
		'panel'						=>'attitude_featured_post_page_panel'
	));
	$wp_customize->add_setting('attitude_theme_options[header_slider]', array(
		'default'					=> '',
		'sanitize_callback'		=> 'esc_attr',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control(
		new Attitude_Revolution_Slider_Control(
		$wp_customize,
		'header_slider',
			array(
				'label'				=> __('Choose Slider','attitude'),
				'section'			=> 'attitude_revolution_options',
				'settings'			=> 'attitude_theme_options[header_slider]'
			)
		)
	);
	$wp_customize->add_setting('attitude_theme_options[revslider_homepage]', array(
		'default'					=>0,
		'sanitize_callback'		=>'prefix_sanitize_integer',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control( 'revslider_homepage', array(
		'priority'					=>20,
		'label'						=> __('Check to Display in Home Page', 'attitude'),
		'section'					=> 'attitude_revolution_options',
		'settings'					=> 'attitude_theme_options[revslider_homepage]',
		'type'						=> 'checkbox',
	));
	$wp_customize->add_setting('attitude_theme_options[pages_id_revslider]', array(
		'default'					=> '',
		'sanitize_callback'		=> 'esc_attr',
		'type' 						=> 'option',
		'capability' 				=> 'manage_options'
	));
	$wp_customize->add_control('pages_id_revslider', array(
		'priority'					=>30,
		'label'						=> __('Enter Pages ID', 'attitude'),
		'description'				=> __('Example: 2,10 Enter the ID of pages in which you want to display this slider on header.','attitude'),
		'section'					=> 'attitude_revolution_options',
		'type'						=> 'text',
		'settings'					=> 'attitude_theme_options[pages_id_revslider]'
	) );
	/******************** Featured Post/ Page Slider Options  *********************************************/
		$wp_customize->add_section( 'attitude_page_post_options', array(
			'title' 						=> __('Featured Post/ Page Slider Options','attitude'),
			'priority'					=> 460,
			'panel'					=>'attitude_featured_post_page_panel'
		));
		$wp_customize->add_setting('attitude_theme_options[exclude_slider_post]', array(
			'default'					=>0,
			'sanitize_callback'		=>'prefix_sanitize_integer',
			'type' 						=> 'option',
			'capability' 				=> 'manage_options'
		));
		$wp_customize->add_control( 'exclude_slider_post', array(
			'priority'					=>470,
			'label'						=> __('Exclude Slider Post', 'attitude'),
			'description'				=>__('Exclude Slider post from Homepage posts?','attitude'),

			'section'					=> 'attitude_page_post_options',
			'settings'					=> 'attitude_theme_options[exclude_slider_post]',
			'type'						=> 'checkbox',
		));
		// featured post/page
		for ( $i=1; $i <= $options['slider_quantity'] ; $i++ ) {
			$wp_customize->add_setting('attitude_theme_options[featured_post_slider]['. $i.']', array(
				'default'					=>'',
				'sanitize_callback'		=>'prefix_sanitize_integer',
				'type' 						=> 'option',
				'capability' 				=> 'manage_options'
			));
			$wp_customize->add_control( 'featured_post_slider]['. $i .']', array(
				'priority'					=> 480 . $i,
				'label'						=> __(' Featured Slider Post/Page #', 'attitude') . ' ' . $i ,
				'section'					=> 'attitude_page_post_options',
				'settings'					=> 'attitude_theme_options[featured_post_slider]['. $i .']',
				'type'						=> 'text',
			));
		}
		/******************** Image Slider Options *********************************************/
		$wp_customize->add_section( 'attitude_image_options', array(
			'title' 						=> __('Featured Image Slider Options','attitude'),
			'priority'					=> 500,
			'panel'					=>'attitude_featured_post_page_panel'
		));
		// featured post/page
		for ( $i=1; $i <= $options['slider_quantity'] ; $i++ ) {
			$wp_customize->add_setting('attitude_theme_options[featured_image_slider_image]'.'['. $i .']', array(
				'default'					=>'',
				'sanitize_callback'		=>'esc_url_raw',
				'type' 						=> 'option',
				'capability' 				=> 'manage_options'
			));
			$wp_customize->add_control(
				new WP_Customize_Image_Control(
				$wp_customize,
					'featured_image_slider_image'. $i,
					array(
					'priority'					=> 500 . $i,
					'label'				=> 'Featured Image Slider #' . $i,
					'description'		=>__('For Narrow Layout: 1038px(w)*460px(h)<br/> For Wide Layout: 1400px(w)*460px(h)','attitude'),
					'section'			=> 'attitude_image_options',
					'settings'			=> 'attitude_theme_options[featured_image_slider_image]'.'['. $i .']',
					)
				)
			);
			$wp_customize->add_setting('attitude_theme_options[featured_image_slider_link]'.'['. $i .']', array(
				'default'					=>'',
				'sanitize_callback'		=>'esc_url_raw',
				'type' 						=> 'option',
				'capability' 				=> 'manage_options'
			));
			$wp_customize->add_control( 'featured_image_slider_link'. $i .'', array(
				'priority'					=> 500 . $i,
				'label'						=> __(' Redirect Link #', 'attitude') . ' ' . $i ,
				'section'					=> 'attitude_image_options',
				'settings'					=> 'attitude_theme_options[featured_image_slider_link]'.'['. $i .']',
				'type'						=> 'text',
			));
			$wp_customize->add_setting('attitude_theme_options[featured_image_slider_title]'.'['. $i .']', array(
				'default'					=>'',
				'sanitize_callback'		=>'sanitize_text_field',
				'type' 						=> 'option',
				'capability' 				=> 'manage_options'
			));
			$wp_customize->add_control( 'featured_image_slider_title'. $i .'', array(
				'priority'					=> 500 . $i,
				'label'						=> __(' Title #', 'attitude') . ' ' . $i ,
				'section'					=> 'attitude_image_options',
				'settings'					=> 'attitude_theme_options[featured_image_slider_title]'.'['. $i .']',
				'type'						=> 'text',
			));
			$wp_customize->add_setting('attitude_theme_options[featured_image_slider_description]'.'['. $i .']', array(
				'default'					=>'',
				'sanitize_callback'		=>'esc_textarea',
				'type' 						=> 'option',
				'capability' 				=> 'manage_options'
			));
			$wp_customize->add_control( 'featured_image_slider_description'. $i .'', array(
				'priority'					=> 500 . $i,
				'label'						=> __(' Short Description #', 'attitude') . ' ' . $i ,
				'section'					=> 'attitude_image_options',
				'settings'					=> 'attitude_theme_options[featured_image_slider_description]'.'['. $i .']',
				'type'						=> 'textarea',
			));
	}
	/****************************************************************************/
	/******************** Social Links******************************************/
	$wp_customize->add_section(
		'attitude_sociallinks_section', array(
		'title' 						=> __('Social Links','attitude'),
		'priority'					=> 500,
	));
	$social_links = array(); 
		$social_links_name = array();
		$social_links_name = array( __( 'Facebook', 'attitude' ),
									__( 'Twitter', 'attitude' ),
									__( 'Google Plus', 'attitude' ),
									__( 'Pinterest', 'attitude' ),
									__( 'Youtube', 'attitude' ),
									__( 'Vimeo', 'attitude' ),
									__( 'LinkedIn', 'attitude' ),
									__( 'Flickr', 'attitude' ),
									__( 'Tumblr', 'attitude' ),
									__( 'Myspace', 'attitude' ),
									__( 'RSS', 'attitude' ),
									__( 'Dribbble', 'attitude' ),
									__( 'WordPress', 'attitude' ),
									__( 'DeviantART', 'attitude' ),
									__( 'AIM', 'attitude' ),
									__( 'GitHub', 'attitude' ),
									__( 'Blogger', 'attitude' ),
									__( 'StumbleUpon', 'attitude' ),
									__( 'Skype', 'attitude' ),
									__( 'Foursquare', 'attitude' ),
									__( 'Picasa', 'attitude' ),
									__( 'Path', 'attitude' ),
									__( 'SlideShare', 'attitude' ),
									__( 'PayPal', 'attitude' ),
									__( 'Delicious', 'attitude' ),
									__( 'Last.fm', 'attitude' ),
									__( 'Behance', 'attitude' ),
									__( 'Netvibes', 'attitude' ),
									__( 'Digg', 'attitude' ),
									__( 'Reddit', 'attitude' ),
									__( 'Mail', 'attitude' ),
									__( 'Instagram', 'attitude' ),
									__( 'Xing', 'attitude' )
									);
		$social_links = array( 	'Facebook' 		=> 'social_facebook',
										'Twitter' 		=> 'social_twitter',
										'Google-Plus'	=> 'social_googleplus',
										'Pinterest' 	=> 'social_pinterest',
										'You-tube'		=> 'social_youtube',
										'Vimeo'			=> 'social_vimeo',
										'Linked'			=> 'social_linkedin',
										'Flickr'			=> 'social_flickr',
										'Tumblr'			=> 'social_tumblr',
										'My-Space'		=> 'social_myspace',
										'RSS'				=> 'social_rss',
										'Dribbble'		=> 'social_dribbble',
										'WordPress'		=> 'social_wordpress', 
										'Deviantart'	=> 'social_deviantart',
										'Aim'				=> 'social_aim',
										'Github'			=> 'social_github',
										'Blogger'		=> 'social_blogger',
										'Stumbleupon'	=> 'social_stumbleupon',
										'Skype'			=> 'social_skype',
										'Foursquare'	=> 'social_foursquare',
										'Picasa'			=> 'social_picasa',
										'Path'			=> 'social_path',
										'Slideshare'	=> 'social_slideshare',
										'Paypal'			=> 'social_paypal',
										'Delicious'		=> 'social_delicious',
										'Lastfm'			=> 'social_lastfm',
										'Behance'		=> 'social_behance',
										'Netvibes'		=> 'social_netvibes',
										'Digg'			=> 'social_digg',
										'Reddit'			=> 'social_reddit',
										'Mail'			=> 'social_mail',
										'Instagram'		=> 'social_instagram',
										'Xing'			=> 'social_xing'
									);
		$i = 0;
		foreach( $social_links as $key => $value ) {
			$wp_customize->add_setting( 'attitude_theme_options['. $value. ']', array(
				'default'					=>'',
				'sanitize_callback'		=> 'esc_url',
				'type' 						=> 'option',
				'capability' 				=> 'manage_options'
			));
			$wp_customize->add_control( $value, array(
					'label'					=> $social_links_name[ $i ],
					'section'				=> 'attitude_sociallinks_section',
					'settings'				=> 'attitude_theme_options['. $value. ']',
					'type'					=> 'text',
					)
			);
			$i++;
		}
	/********************************************************************************/
	/******************** Webmaster Tools ******************************************/
	$wp_customize->add_section('webmaster_analytics_tools', array(
		'title'					=> __('Analytics', 'attitude'),
		'panel'					=> 'attitude_webmaster_tools_panel'
	));
	$wp_customize->add_setting( 'attitude_theme_options[analytic_header]', array(
		'default'				=> '',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'wp_kses_stripslashes'
	));
	$wp_customize->add_control( 'analytic_header', array(
		'label'					=> __('Code to display on Header','attitude'),
		'description'			=> __('Note: Enter your custom header script.','attitude'),
		'section'				=> 'webmaster_analytics_tools',
		'settings'				=> 'attitude_theme_options[analytic_header]',
		'type'					=> 'textarea'
	));
	$wp_customize->add_setting( 'attitude_theme_options[analytic_footer]', array(
		'default'				=> '',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'wp_kses_stripslashes'
	));
	$wp_customize->add_control( 'analytic_footer', array(
		'label'					=> __('Code to display on Footer','attitude'),
		'description'			=> __('Note: Enter your custom footer script.','attitude'),
		'section'				=> 'webmaster_analytics_tools',
		'settings'				=> 'attitude_theme_options[analytic_footer]',
		'type'					=> 'textarea'
	));
	$wp_customize->add_section('site_verification', array(
		'title'					=> __('Site Verification', 'attitude'),
		'panel'					=> 'attitude_webmaster_tools_panel'
	));
	$wp_customize->add_setting( 'attitude_theme_options[google_verification]', array(
		'default'				=> '',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'wp_filter_post_kses'
	));
	$wp_customize->add_control( 'google_verification', array(
		'label'					=> __('Google Site Verification ID','attitude'),
		'description'			=> __('Enter your Google ID number only','attitude'),
		'section'				=> 'site_verification',
		'settings'				=> 'attitude_theme_options[google_verification]',
		'type'					=> 'text'
	));
	$wp_customize->add_setting( 'attitude_theme_options[yahoo_verification]', array(
		'default'				=> '',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'wp_filter_post_kses'
	));
	$wp_customize->add_control( 'yahoo_verification', array(
		'label'					=> __('Yahoo Site Verification ID','attitude'),
		'description'			=> __('Enter your Yahoo ID number only','attitude'),
		'section'				=> 'site_verification',
		'settings'				=> 'attitude_theme_options[yahoo_verification]',
		'type'					=> 'text'
	));
	$wp_customize->add_setting( 'attitude_theme_options[bing_verification]', array(
		'default'				=> '',
		'type' 					=> 'option',
		'capability' 			=> 'manage_options',
		'sanitize_callback'	=> 'wp_filter_post_kses'
	));
	$wp_customize->add_control( 'bing_verification', array(
		'label'					=> __('Bing Site Verification ID','attitude'),
		'description'			=> __('Enter your Bing ID number only','attitude'),
		'section'				=> 'site_verification',
		'settings'				=> 'attitude_theme_options[bing_verification]',
		'type'					=> 'text'
	));

}
/********************Sanitize the values ******************************************/
function prefix_sanitize_integer( $input ) {
	return $input;
}
function attitude_sanitize_effect( $input ) {
	if ( ! in_array( $input, array( 'fade', 'wipe', 'scrollUp', 'scrollDown', 'scrollLeft', 'scrollRight', 'blindX', 'blindY', 'blindZ', 'cover', 'shuffle' ) ) ) {
		$input = 'fade';
	}
	return $input;
}
function attitude_sanitize_delay_transition( $input ) {
	if(is_numeric($input)){
	return $input;
	}
}
function attitude_sanatize_excerpt_length( $input ) {
	if(is_numeric($input)){
	return $input;
	}
}

function footer_edit_validate( $input ) {
		$input = stripslashes( wp_filter_post_kses( addslashes ( $input) ) );
		return $input;
}
function attitude_customizer_control_scripts() {

	wp_enqueue_style( 'attitude-customize-controls',
	 get_template_directory_uri() . '/library/admin/css/customize-controls.css' );

}

add_action( 'customize_controls_enqueue_scripts', 'attitude_customizer_control_scripts', 0 );
add_action('customize_register', 'attitude_textarea_register');
add_action('customize_register', 'attitude_customize_register');
?>
