<?php
/**
 * Attitude Pro functions and definitions
 *
 * This file contains all the functions and it's defination that particularly can't be
 * in other files.
 * 
 * @package Theme Horse
 * @subpackage Attitude Pro
 * @since Attitude Pro 1.0
 */

/****************************************************************************************/

add_action( 'wp_enqueue_scripts', 'attitude_scripts_styles_method' );
/**
 * Register jquery scripts
 */
function attitude_scripts_styles_method() {

   global $attitude_theme_options_settings, $attitude_theme_options_defaults;
	$default_options = $attitude_theme_options_defaults;
	$options = $attitude_theme_options_settings;

   /**
	 * Loads our main stylesheet.
	 */ 
	wp_enqueue_style( 'attitude_style', get_stylesheet_uri() );
	wp_enqueue_style('attitude-font-awesome', get_template_directory_uri().'/font-awesome/css/font-awesome.css');
	// Load the html5 shiv.
	wp_enqueue_script( 'html5', get_template_directory_uri() . '/library/js/html5.min.js', array(), '3.7.3' );
	wp_script_add_data( 'html5', 'conditional', 'lt IE 9' );

	/**
	 * Adds JavaScript to pages with the comment form to support
	 * sites with threaded comments (when in use).
	 */
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/**
	 * Register JQuery cycle js file for slider.
	 * Register Jquery fancybox js and css file for fancybox effect.
	 */
	wp_register_script( 'jquery_cycle', ATTITUDE_JS_URL . '/jquery.cycle.all.js', array( 'jquery' ), '3.0.3', true );

	wp_register_script( 'jquery_fancybox', ATTITUDE_JS_URL . '/jquery.fancybox.min.js', array('jquery'), '3.5.7', true ); 
   wp_register_style( 'jquery_fancybox_style', ATTITUDE_CSS_URL . '/jquery.fancybox.min.css', true ); 

   $attitude_google_font_loads = array();
   if( $default_options['attitude_general_typography'] != $options[ 'attitude_general_typography' ] ) :
   	array_push( $attitude_google_font_loads,$options[ 'attitude_general_typography' ] );
   endif;

    if( $default_options['attitude_navigation'] != $options[ 'attitude_navigation' ] ) :
   	array_push( $attitude_google_font_loads,$options[ 'attitude_navigation' ] );
   endif;

    if( $default_options['attitude_title'] != $options[ 'attitude_title' ] ) :
   	array_push( $attitude_google_font_loads,$options[ 'attitude_title' ] );
   endif;

   if( 'PT Sans' == $options[ 'attitude_general_typography' ] || 'PT Sans' == $options[ 'attitude_navigation' ] ):
   	array_push( $attitude_google_font_loads,'PT+Sans');
  	endif;

  	if( 'Philosopher' == $options[ 'attitude_title' ] ):
   	array_push( $attitude_google_font_loads,'Philosopher');
  	endif;
  	$attitude_google_font_load = implode("|", $attitude_google_font_loads);

  	wp_register_style( 'attitude_google_font', '//fonts.googleapis.com/css?family='.$attitude_google_font_load );
  	wp_enqueue_style( 'attitude_google_font' );

   wp_register_script('quicksand', ATTITUDE_JS_URL . '/jquery.quicksand.js', 'jquery');
	wp_register_script('easing', ATTITUDE_JS_URL . '/jquery.easing.1.3.js', 'jquery');
	wp_register_script('custom', ATTITUDE_JS_URL . '/jquery.custom.js', 'jquery', '1.0', true);

	
	/**
	 * Enqueue Slider setup js file.
	 * Enqueue Fancy Box setup js and css file.	 
	 */	
	global $options, $array_of_default_settings;
	$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());
	if( 'revolution-slider' != $options[ 'slider_type' ] && 1 != $options[ 'disable_slider' ] ) { 
		if ( (  'slider-on-everypage' == $options[ 'slider_status' ] ) || ( ( is_home() || is_front_page() ) &&  'slider-on-homepage' == $options[ 'slider_status' ] ) ) {
			wp_enqueue_script( 'attitude_slider', ATTITUDE_JS_URL . '/attitude-slider-setting.js', array( 'jquery_cycle' ), false, true );
		}
	}
	
	wp_enqueue_script( 'attitude_fancybox_setup', ATTITUDE_JS_URL . '/attitude-custom-fancybox-script.js', array('jquery_fancybox'), false , true); 
   wp_enqueue_script( 'attitude-scripts', ATTITUDE_JS_URL . '/scripts.js', array( 'jquery' ) );
   wp_enqueue_script( 'backtotop', ATTITUDE_JS_URL. '/backtotop.js', array( 'jquery' ) );

   wp_enqueue_style( 'jquery_fancybox_style' ); 

   wp_enqueue_script( 'quicksand' );
   wp_enqueue_script( 'easing' );
   wp_enqueue_script( 'custom', array('jquery_fancybox'), false , true);

} 
/****************************************************************************************/
function attitude_add_editor_styles() {
	$font_url = str_replace( ',', '%2C', '//fonts.googleapis.com/css?family=PT+Sans|Philosopher' );
	add_editor_style( $font_url );
}
add_action( 'after_setup_theme', 'attitude_add_editor_styles' );
/****************************************************************************************/

add_action( 'admin_print_scripts', 'attitude_media_js' );
/**
 * Register scripts for image upload
 *
 * @uses wp_register_script
 * Hooked to admin_print_scripts action hook
 */
function attitude_media_js() {
    wp_enqueue_script( 'attitude_meta_upload_widget', ATTITUDE_ADMIN_JS_URL . '/add-image-script-widget.js', array( 'jquery','media-upload','thickbox' ) );
    wp_enqueue_media();
}

/****************************************************************************************/

add_filter( 'wp_page_menu', 'attitude_wp_page_menu' );
/**
 * Remove div from wp_page_menu() and replace with ul.
 * @uses wp_page_menu filter
 */
function attitude_wp_page_menu ( $page_markup ) {
	preg_match('/^<div class=\"([a-z0-9-_]+)\">/i', $page_markup, $matches);
	$divclass = $matches[1];
	$replace = array('<div class="'.$divclass.'">', '</div>');
	$new_markup = str_replace($replace, '', $page_markup);
	$new_markup = preg_replace('/^<ul>/i', '<ul class="'.$divclass.'">', $new_markup);
	return $new_markup; 
}

/****************************************************************************************/

if ( ! function_exists( 'attitude_pass_cycle_parameters' ) ) :
/**
 * Function to pass the slider effectr parameters from php file to js file.
 */
function attitude_pass_cycle_parameters() {
    
   global $options, $array_of_default_settings;
	$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());

    $transition_effect = $options[ 'transition_effect' ];
    $transition_delay = $options[ 'transition_delay' ] * 1000;
    $transition_duration = $options[ 'transition_duration' ] * 1000;
    wp_localize_script( 
        'attitude_slider',
        'attitude_slider_value',
        array(
            'transition_effect' => $transition_effect,
            'transition_delay' => $transition_delay,
            'transition_duration' => $transition_duration
        )
    );
    
}
endif;

/****************************************************************************************/

add_filter( 'excerpt_length', 'attitude_excerpt_length' );
/**
 * Sets the post excerpt length to 30 words.
 *
 * function tied to the excerpt_length filter hook.
 *
 * @uses filter excerpt_length
 */
function attitude_excerpt_length( $length ) {
	global $options, $array_of_default_settings;
	$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());

	return $options[ 'excerpt_length' ];
}

add_filter( 'excerpt_more', 'attitude_continue_reading' );
/**
 * Returns a "Continue Reading" link for excerpts
 */
function attitude_continue_reading() {
	return '&hellip; ';
}

/****************************************************************************************/

add_filter( 'body_class', 'attitude_body_class' );
/**
 * Filter the body_class
 *
 * Throwing different body class for the different layouts in the body tag
 */
function attitude_body_class( $classes ) {
	global $post;	
	global $options, $array_of_default_settings;
	$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());

	if( $post ) {
		$layout = get_post_meta( $post->ID,'attitude_sidebarlayout', true ); 
	}
	if( empty( $layout ) || is_archive() || is_search() || is_home() ) {
		$layout = 'default';
	}
	if( 'default' == $layout ) {

		$themeoption_layout = $options[ 'default_layout' ];

		if( 'left-sidebar' == $themeoption_layout ) {
			$classes[] = 'left-sidebar-template';
		}
		elseif( 'right-sidebar' == $themeoption_layout  ) {
			$classes[] = '';
		}
		elseif( 'no-sidebar-full-width' == $themeoption_layout ) {
			$classes[] = 'full-width-template';
		}
		elseif( 'no-sidebar-one-column' == $themeoption_layout ) {
			$classes[] = 'one-column-template';
		}		
		elseif( 'no-sidebar' == $themeoption_layout ) {
			$classes[] = 'no-sidebar-template';
		}
	}
	elseif( 'left-sidebar' == $layout ) {
      $classes[] = 'left-sidebar-template';
   }
   elseif( 'right-sidebar' == $layout ) {
		$classes[] = '';
	}
	elseif( 'no-sidebar-full-width' == $layout ) {
		$classes[] = '';
	}
	elseif( 'no-sidebar-one-column' == $layout ) {
		$classes[] = 'one-column-template';
	}
	elseif( 'no-sidebar' == $layout ) {
		$classes[] = 'no-sidebar-template';
	}

	if( is_page_template( 'page-template-blog-image-medium.php' ) ) {
		$classes[] = 'blog-medium';
	}
	if( 'wide-layout' == $options[ 'site_layout' ] ) {
		$classes[] = 'wide-layout';
	}
	if( is_page_template( 'page-template-gallery-four-column.php' ) ||  is_page_template( 'page-template-gallery-three-column.php' ) || is_page_template( 'page-template-gallery-two-column.php' ) ) {
		$classes[] = 'custom-gallery';
	}
	return $classes;
}

/****************************************************************************************/

add_action('wp_head', 'attitude_site_title_position_css');
/**
 * Hooks the Custom Internal CSS to head section for header text/logo position
 */
function attitude_site_title_position_css() { 
	$attitude_site_title_position_css = '';

		global $options, $array_of_default_settings;
		$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());
		$attitude_site_title_position_css = '';

		if( 'center-position' == $options[ 'header_position' ] ) {
			$attitude_site_title_position_css .= '<!-- '.get_bloginfo('name').' Header Text/Logo Position CSS -->' . "\n";
			$attitude_site_title_position_css .= '<style type="text/css" media="screen">' . "\n";
			$attitude_site_title_position_css .=  '/* Center Align */
				.hgroup-right { 
					margin-top: 0;
				}
				#site-logo {
					clear: both;
					float: none;
					text-align: center;
				} 
				@media only screen and (max-width: 767px) { 
					.hgroup-right { 
						margin-top: 15px;
					}
				}' . "\n";
			$attitude_site_title_position_css .= '</style>' . "\n";
		}
		elseif( 'right-position' == $options[ 'header_position' ] ) {
			$attitude_site_title_position_css .= '<!-- '.get_bloginfo('name').' Header Text/Logo Position CSS -->' . "\n";
			$attitude_site_title_position_css .= '<style type="text/css" media="screen">' . "\n";
			$attitude_site_title_position_css .=  '/* Right Align */
				.hgroup-right { 
					float: left;
				}
				#site-logo,
				#branding .searchform { 
					float: right;
				}' . "\n";
			$attitude_site_title_position_css .= '</style>' . "\n";
		}
		else {
			$attitude_site_title_position_css .= '';
		}
	echo $attitude_site_title_position_css;
}

/****************************************************************************************/

add_action('wp_head', 'attitude_menu_position_css');
/**
 * Hooks the Custom Internal CSS to head section for header menu postion
 */
function attitude_menu_position_css() { 
		$attitude_menu_position_css = '';

		global $options, $array_of_default_settings;
		$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());
		$attitude_menu_position_css = '';

		if( 'center-position' == $options[ 'menu_position' ] ) {
			$attitude_menu_position_css .= '<!-- '.get_bloginfo('name').' Header Menu Position CSS -->' . "\n";
			$attitude_menu_position_css .= '<style type="text/css" media="screen">' . "\n";
			$attitude_menu_position_css .=  '/* Center Align */
			#access {
				text-align: center;
			}
			#access li {
				display: inline-block;
				float: none;
			}
			#access a { 
				display: block;
				float: none;
			}
			#access ul li ul {
				text-align: left;
			}
			#access ul li ul li {
				display: block;
			} 
			/* RTL Support */
			html[dir="rtl"] #access ul.root,
			body.rtl #access ul.root {
				float: none;
			}
			html[dir="rtl"] #access ul li ul,
			body.rtl #access ul li ul {
				text-align: right;
			} 
			@media only screen and (max-width: 767px) {
				#access ul li ul {
					text-align: center;
				}
				#access ul li ul li a,
				#access ul li.current-menu-item ul li a,
				#access ul li ul li.current-menu-item a,
				#access ul li.current_page_ancestor ul li a,
				#access ul li.current-menu-ancestor ul li a,
				#access ul li.current_page_item ul li a,
				#access ul li ul li ul a,
				#access ul li.current-menu-item ul li ul a,
				#access ul li ul li.current-menu-item ul a,
				#access ul li.current_page_ancestor ul li ul a,
				#access ul li.current-menu-ancestor ul li ul a,
				#access ul li.current_page_item ul li ul a {
					padding-left: 0;
					padding-right: 0;
				}
				html[dir="rtl"] #access ul li ul,
				body.rtl #access ul li ul {
					text-align: center;
				}
			}' . "\n";
			$attitude_menu_position_css .= '</style>' . "\n";
		}
		elseif( 'right-position' == $options[ 'menu_position' ] ) {
			$attitude_menu_position_css .= '<!-- '.get_bloginfo('name').' Header Menu Position CSS -->' . "\n";
			$attitude_menu_position_css .= '<style type="text/css" media="screen">' . "\n";
			$attitude_menu_position_css .=  '/* Right Align */
			#access ul {
				float: right;
			}
			#access ul li {
				padding: 0 0 0 20px;
			}
			/* RTL Support */
			html[dir="rtl"] #access ul.root,
			body.rtl #access ul.root {
				float: right;
			}
			@media only screen and (max-width: 767px) {
				#access {
					text-align: right;
				}
				#access ul {
					float: none;
				}
				#access ul li {
					padding: 0;
				}
				#access ul li ul li a,
				#access ul li.current-menu-item ul li a,
				#access ul li ul li.current-menu-item a,
				#access ul li.current_page_ancestor ul li a,
				#access ul li.current-menu-ancestor ul li a,
				#access ul li.current_page_item ul li a {
					padding-right: 15px;
					padding-left: 0;
				}
				#access ul li ul li ul a,
				#access ul li.current-menu-item ul li ul a,
				#access ul li ul li.current-menu-item ul a,
				#access ul li.current_page_ancestor ul li ul a,
				#access ul li.current-menu-ancestor ul li ul a,
				#access ul li.current_page_item ul li ul a {
					padding-right: 25px;
				}
			}' . "\n";
			$attitude_menu_position_css .= '</style>' . "\n";
		}
		else {
			$attitude_menu_position_css .= '';
		}
	echo $attitude_menu_position_css;
}

/****************************************************************************************/

add_action('wp_head', 'attitude_featured_text_position_css');
/**
 * Hooks the Custom Internal CSS to head section for featured text postion of slogan
 */
function attitude_featured_text_position_css() { 
		$attitude_featured_text_position_css = '';

		global $options, $array_of_default_settings;
		$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());
		$attitude_featured_text_position_css = '';

		if( 'left-position' == $options[ 'featured_text_position' ] ) {
			$attitude_featured_text_position_css .= '<!-- '.get_bloginfo('name').' Featured Text of Post/Image Slider Position CSS -->' . "\n";
			$attitude_featured_text_position_css .= '<style type="text/css" media="screen">' . "\n";
			$attitude_featured_text_position_css .=  '.featured-text { text-align: left; left: 30px; right: 0; } .featured-text .featured-title { float: left; } .featured-text .featured-content { float: left; clear: left; }' . "\n";
			$attitude_featured_text_position_css .= '</style>' . "\n";
		}
		elseif( 'hide' == $options[ 'featured_text_position' ] ) {
			$attitude_featured_text_position_css .= '<!-- '.get_bloginfo('name').' Featured Text of Post/Image Slider Position CSS -->' . "\n";
			$attitude_featured_text_position_css .= '<style type="text/css" media="screen">' . "\n";
			$attitude_featured_text_position_css .=  '.featured-text { display: none; }' . "\n";
			$attitude_featured_text_position_css .= '</style>' . "\n";
		}
		else {
			$attitude_featured_text_position_css .= '';
		}
	echo $attitude_featured_text_position_css;
}

/****************************************************************************************/

add_action('wp_head', 'attitude_internal_css');
/**
 * Hooks the Custom Internal CSS to head section
 */
function attitude_internal_css() { 
	$attitude_internal_css = '';

	global $options, $array_of_default_settings;
	$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());

		if( !empty( $options[ 'custom_css' ] ) ) {
			$attitude_internal_css = '<!-- '.get_bloginfo('name').' Custom CSS Styles -->' . "\n";
			$attitude_internal_css .= '<style type="text/css" media="screen">' . "\n";
			$attitude_internal_css .=  $options['custom_css'] . "\n";
			$attitude_internal_css .= '</style>' . "\n";
		}
	echo $attitude_internal_css;
}

/****************************************************************************************/

add_action('wp_head', 'attitude_verification');
/**
 * Site Verification and Header Analytic Tools
 *
 * If user sets the code we're going to display meta verification
 */ 
function attitude_verification() {

	global $options, $array_of_default_settings;
	$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());
		$attitude_verification = '';
		// google verification
		if ( !empty( $options['google_verification'] ) ) {
		$attitude_verification .= '<meta name="google-site-verification" content="' . $options['google_verification']. '" />' . "\n";
		}

		// bing verification
		if ( !empty( $options['bing_verification'] ) ) {
		$attitude_verification .= '<meta name="msvalidate.01" content="' .  $options['bing_verification']  . '" />' . "\n";
		}

		// yahoo verification
		if ( !empty( $options['yahoo_verification'] ) ) {
		$attitude_verification .= '<meta name="y_key" content="' .  $options['yahoo_verification'] . '" />' . "\n";
		}

		// site stats, analytics header code
		if ( !empty( $options['analytic_header'] ) ) {
		$attitude_verification .=  $options[ 'analytic_header' ] ;
		}
	echo $attitude_verification;
}

/****************************************************************************************/

add_action('wp_footer', 'attitude_footercode');
/**
 * Footer Analytics Code
 */
function attitude_footercode() { 
    
   $attitude_footercode = '';

	global $options, $array_of_default_settings;
	$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());

		// site stats, analytics footer code
		if ( !empty( $options['analytic_footer'] ) ) {  
		$attitude_footercode .=  $options[ 'analytic_footer' ] ;
		}
	echo $attitude_footercode;
}

/****************************************************************************************/

add_action('template_redirect', 'attitude_feed_redirect');
/**
 * Redirect WordPress Feeds To FeedBurner
 */
function attitude_feed_redirect() {
	global $options, $array_of_default_settings;
	$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());

	if ( !empty( $options['feed_url'] ) ) {
		$url = 'Location: '.$options['feed_url'];
		if ( is_feed() && !preg_match('/feedburner|feedvalidator/i', $_SERVER['HTTP_USER_AGENT'])) {
			header($url);
			header('HTTP/1.1 302 Temporary Redirect');
		}
	}
}

/****************************************************************************************/

add_action( 'pre_get_posts','attitude_alter_home' );
/**
 * Alter the query for the main loop in home page
 *
 * @uses pre_get_posts hook
 */
function attitude_alter_home( $query ){
	global $options, $array_of_default_settings;
	$options = wp_parse_args( get_option( 'attitude_theme_options', array() ), attitude_get_option_defaults());
	$cats = $options[ 'front_page_category' ];

	if ( $options[ 'exclude_slider_post'] != 0 && !empty( $options[ 'featured_post_slider' ] ) ) {
		if( $query->is_main_query() && $query->is_home() ) {
			$query->query_vars['post__not_in'] = $options[ 'featured_post_slider' ];
		}
	}

	if ( !in_array( '0', $cats ) ) {
		if( $query->is_main_query() && $query->is_home() ) {
			$query->query_vars['category__in'] = $options[ 'front_page_category' ];
		}
	}
}

/*************************************************************************************/

add_action('wp_head', 'attitude_check_background_color');
/**
 * Checking if background color is empty
 * If the background color is not empty background-image should be set to none 
 * else background color will be not displayed in the site.
 */
function attitude_check_background_color() {

	$background_color = esc_attr(get_background_color());
			if ( $background_color != "" ) {
				$attitude_css  = '<!-- '.get_bloginfo('name').' Custom CSS Styles -->' . "\n";
		      $attitude_css .= '<style type="text/css" media="screen">' . "\n";
				$attitude_css .= 'body { background-image: none; }' . "\n";
				$attitude_css .= '</style>' . "\n";
			}
	if( isset( $attitude_css ) ) {
		echo $attitude_css;
	}
}

/****************************************************************************************/

add_action( 'pre_get_posts', 'attitude_custom_posts_per_page' );
/**
 * Alter the query for the gallery loop page
 *
 * @uses pre_get_posts hook
 */
function attitude_custom_posts_per_page($query) {
	global $attitude_theme_options_settings;
	$options = $attitude_theme_options_settings;
    if( !empty( $query->query_vars['post_type'] ) ) {
        switch ( $query->query_vars['post_type'] )
        {
            case 'gallery':  // Post Type named 'gallery'
               // $query->query_vars['posts_per_page'] = $options[ 'gallery_posts_number' ];
                break;

            default:
                break;
        }
    }
    return $query;
}

/****************************************************************************************/

add_filter('wp_page_menu', 'attitude_wp_page_menu_filter');
/**
 * @uses wp_page_menu filter hook
 */
if ( !function_exists('attitude_wp_page_menu_filter') ) {
	function attitude_wp_page_menu_filter( $text ) {
		$replace = array(
			'current_page_item'     => 'current-menu-item'
	 	);

	  $text = str_replace(array_keys($replace), $replace, $text);
	  return $text;
	}
}

/**************************************************************************************/

?>