<?php
/**
 * Attitude style functions and definitions
 *
 * This file contains all the functions related to styles.
 * 
 * @package Theme Horse
 * @subpackage Attitude Pro 
 * @since Attitude Pro 1.0
 */

/****************************************************************************************/

/**
 * Changes the style according to theme options value
 */
add_action( 'wp_head', 'attitude_options_style');
function attitude_options_style() {
	global $attitude_theme_options_settings, $attitude_theme_options_defaults;
	$default_options = $attitude_theme_options_defaults;  ?>
	<style type="text/css">
		/* Font Family */
		<?php if( $default_options['attitude_general_typography'] != $attitude_theme_options_settings['attitude_general_typography' ] ) : ?>
			/* Content */
			body, 
			input, 
			textarea,
			select,
			.slogan-wrap .slogan span,
			.widget_promotional_bar .promotional-text span { 
				font-family: "<?php echo esc_attr( $attitude_theme_options_settings['attitude_general_typography' ] ); ?>";
			}
		<?php endif; ?>
		<?php if( $default_options['attitude_navigation'] != $attitude_theme_options_settings['attitude_navigation' ] ) : ?>
			/* Navigation */
			#access a { 
				font-family: "<?php echo esc_attr( $attitude_theme_options_settings['attitude_navigation' ] ); ?>";
			}
		<?php endif; ?>
		<?php if( $default_options['attitude_title'] != $attitude_theme_options_settings[ 'attitude_title' ] ) : ?>
			/* All Headings/Titles */
			h1, h2, h3, h4, h5, h6,
			#site-title,
			#site-description,
			.featured-text .featured-title,
			.slogan-wrap,
			.entry-title, 
			.custom-gallery-title {
				font-family: "<?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_title' ] ); ?>";
			}
		<?php endif; ?>
		/* Font Size */
		<?php if( $default_options[ 'site_title' ] != $attitude_theme_options_settings[ 'site_title' ] ) : ?>
			/* Site Title */
			#site-title { 
				font-size: <?php echo esc_attr( $attitude_theme_options_settings[ 'site_title' ] ); ?>px;
			}
		<?php endif; ?>
		<?php if( $default_options[ 'navigation' ] != $attitude_theme_options_settings[ 'navigation' ] ) : ?>
			/* Navigation */
			#access a {
				font-size: <?php echo esc_attr( $attitude_theme_options_settings[ 'navigation' ] ); ?>px;
			}
		<?php endif; ?>
		<?php if( $default_options[ 'navigation_child' ] != $attitude_theme_options_settings[ 'navigation_child' ] ) : ?>
			/* Navigation child */
			#access ul li ul li a {
				font-size: <?php echo esc_attr( $attitude_theme_options_settings[ 'navigation_child' ] ); ?>px;
			}
		<?php endif; ?>
		<?php if( $default_options[ 'service_gallery_title' ] != $attitude_theme_options_settings[ 'service_gallery_title' ] ) : ?>
			/* Slogan button, Service/ Gallery Title and Promotional Bar Button */
			.slogan-wrap .view-work,
			.widget_promotional_bar .call-to-action,
			#content .service-item .service-title,
			#content .custom-gallery-title,
			#content .widget_our_team .our-team-name, 
			.custom-gallery-title a,
			.woocommerce ul.products li.product .woocommerce-loop-category__title,
			.woocommerce ul.products li.product .woocommerce-loop-product__title,
			.woocommerce ul.products li.product h3 {
				font-size: <?php echo esc_attr( $attitude_theme_options_settings[ 'service_gallery_title' ] ); ?>px;
			}
		<?php endif; ?>
		<?php if( $default_options[ 'page_post_title' ] != $attitude_theme_options_settings[ 'page_post_title' ] ) : ?>
			/* Page/Post Title, Slogan and Promotional Bar  */
			.featured-text .featured-title,
			.page-title,
			.entry-title,
			.slogan-wrap .slogan,
			.widget_promotional_bar .promotional-text,
			#content .widget-title  { 
				font-size: <?php echo esc_attr( $attitude_theme_options_settings[ 'page_post_title' ] ); ?>px;
			}
		<?php endif; ?>
		<?php if( $default_options[ 'sidebar_widget_title' ] != $attitude_theme_options_settings[ 'sidebar_widget_title' ] ) : ?>
			/* Sidebar Widget Title */
			.widget-title {
				font-size: <?php echo esc_attr( $attitude_theme_options_settings[ 'sidebar_widget_title' ] ); ?>px;
			}
		<?php endif; ?>
		<?php if( $default_options[ 'footer_widget_title' ] != $attitude_theme_options_settings[ 'footer_widget_title' ] ) : ?>
			/* Footer Widget Title */	
			#colophon .widget-title {
				font-size: <?php echo esc_attr( $attitude_theme_options_settings[ 'footer_widget_title' ] ); ?>px;
			}
		<?php endif; ?>
		<?php if( $default_options[ 'content' ] != $attitude_theme_options_settings[ 'content' ] ) : ?>
			/* Content */
			body,
			input,
			textarea,
			select,
			.slogan-wrap .slogan span,
			#bbpress-forums,
			#bbpress-forums button,
			#bbpress-forums ul.bbp-lead-topic,
			#bbpress-forums ul.bbp-topics,
			#bbpress-forums ul.bbp-forums,
			#bbpress-forums ul.bbp-replies,
			#bbpress-forums ul.bbp-search-results,
			div.bbp-search-form input,
			div.bbp-search-form button,
			div.bbp-breadcrumb,
			div.bbp-topic-tags,
			.widget_promotional_bar .promotional-text span,
			.wp-block-quote cite,
			.wp-block-pullquote.alignleft blockquote cite,
			.wp-block-pullquote.alignright blockquote cite,
			.wp-block-search .wp-block-search__button {
				font-size: <?php echo esc_attr( $attitude_theme_options_settings[ 'content' ] ); ?>px;
			}
			.has-small-font-size {
				font-size: calc(<?php echo esc_attr( $attitude_theme_options_settings[ 'content' ] ); ?>px - 2px);
			}
			blockquote.wp-block-quote,
			.wp-block-quote.is-style-large cite,
			.wp-block-pullquote blockquote cite,
			.wp-block-button__link,
			.wp-block-pullquote.alignleft p,
			.wp-block-pullquote.alignright p,
			.wp-block-pullquote.alignleft.is-style-solid-color p,
			.wp-block-pullquote.alignright.is-style-solid-color p {
				font-size: calc(<?php echo esc_attr( $attitude_theme_options_settings[ 'content' ] ); ?>px + 2px);
			}
			.has-medium-font-size,
			.wp-block-quote.is-large p,
			.wp-block-quote.is-style-large p,
			.wp-block-pullquote p,
			.wp-block-pullquote.is-style-solid-color blockquote p {
				font-size: calc(<?php echo esc_attr( $attitude_theme_options_settings[ 'content' ] ); ?>px + 4px);
			}
			.has-large-font-size {
				font-size: calc(<?php echo esc_attr( $attitude_theme_options_settings[ 'content' ] ); ?>px + 11px);
			}
			.has-huge-font-size {
				font-size: calc(<?php echo esc_attr( $attitude_theme_options_settings[ 'content' ] ); ?>px + 21px);
			}
		<?php endif; ?>
		<?php if( $default_options[ 'widget_content' ] != $attitude_theme_options_settings[ 'widget_content' ] ) : ?>
			/* Widget Content and Site Generator text */	
			#secondary, 
			#colophon { 
				font-size: <?php echo esc_attr( $attitude_theme_options_settings[ 'widget_content' ] ); ?>px;
			}
		<?php endif; ?>
		<?php /* font color */ ?>
		<?php if( $default_options[ 'attitude_site_title_color' ] != $attitude_theme_options_settings[ 'attitude_site_title_color' ] ) : ?>
			/* Site Title */
			#site-title a {
				color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_site_title_color' ] ); ?>
			}
		<?php endif; ?>
		<?php if( $default_options[ 'attitude_heading_title_color' ] != $attitude_theme_options_settings[ 'attitude_heading_title_color' ] ) : ?>
			/* All Headings/Titles */
			h1, h2, h3, h4, h5, h6,
			.page-title,
			.entry-title, 
			.entry-title a,
			.custom-gallery-title,
			.custom-gallery-title a,
			#content .service-item .service-title,
			#content .widget-title,
			#content .widget-title a,
			.entry-content th,
			.comment-content th {
				color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_heading_title_color' ] ); ?>
			}
		<?php endif; ?>
		<?php if( $default_options[ 'attitude_meta_color' ] != $attitude_theme_options_settings[ 'attitude_meta_color' ] ) : ?>
			/* Breadcrumb and Meta */
			.breadcrumb,
			.breadcrumb a:hover, 
			.entry-meta a,
			#site-generator .copyright a { 
				color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_meta_color' ] ); ?>;
			}
		<?php endif; ?>
		<?php if( $default_options[ 'attitude_contents_color' ] != $attitude_theme_options_settings[ 'attitude_contents_color' ] ) : ?>
			/* Content */
			body, 
			input, 
			textarea,
			select,
			input.s,
			#access a, 
			#access ul li ul li a,
			.menu-toggle,
			.breadcrumb a,
			#content ul a, 
			#content ol a,
			.entry-meta, 
			#wp_page_numbers ul li.page_info,
			#wp_page_numbers ul li a,
			.wp-pagenavi .pages,
			.wp-pagenavi a,
			ul.default-wp-page li a,
			.pagination,
			.pagination a span,
			input.s,
			.widget_search input.s,
			#site-generator,
			.woocommerce ul.products li.product .price,
			.woocommerce div.product p.price,
			.woocommerce div.product span.price,
			.woocommerce-page .select2-container--default .select2-selection--single .select2-selection__rendered { 
				color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_contents_color' ] ); ?>;
			}
		<?php endif; ?>
		<?php if( $default_options[ 'attitude_widget_title_color' ] != $attitude_theme_options_settings[ 'attitude_widget_title_color' ] ) : ?>
			/* Widget Titles */
			.widget-title, 
			.widget-title a {
				color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_widget_title_color' ] ); ?>;
			}
		<?php endif; ?>
		<?php if( $default_options[ 'attitude_widget_content_color' ] != $attitude_theme_options_settings[ 'attitude_widget_content_color' ] ) : ?>
			/* Widget Content */
			#secondary,
			.widget ul li a,
			.widget_search input.s, 
			.widget_custom-tagcloud a,
			.widget_tag_cloud a,
			#secondary select,
			#colophon .widget-area select,
			#colophon {
				color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_widget_content_color' ] ); ?>;
			}
			.widget_custom-tagcloud a {
				border-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_widget_content_color' ] ); ?>;
				background-color: transparent;
			}
			<?php endif; ?>
			<?php /* Color skin */ ?>
			<?php if( $default_options[ 'attitude_slogan_slider_title_color' ] != $attitude_theme_options_settings[ 'attitude_slogan_slider_title_color' ] ) : ?>
				/* Featured Title, Slogan and Promotional Bar */
				.featured-text .featured-title,
				#controllers a:hover,
				#controllers a.active
				{
					background: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_slogan_slider_title_color' ] ); ?>;
					opacity:0.9;
					-moz-opacity: 0.9;
					filter:alpha(opacity=90);
				}
				#controllers a:hover,
				#controllers a.active {
					color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_slogan_slider_title_color' ] ); ?>;
				}
				.slogan-wrap, 
				.widget_promotional_bar .promotional_bar_content { 
					background-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_slogan_slider_title_color' ] ); ?>;
				}
				.slogan-wrap .view-work,
				.widget_promotional_bar .call-to-action {
					background: #ffffff;
					opacity:0.9;
					-moz-opacity: 0.9;
					filter:alpha(opacity=90);
				}
				.slogan-wrap .view-work:hover,
				.widget_promotional_bar .call-to-action:hover {
					opacity:10;
					-moz-opacity:10;
					filter:alpha(opacity=100);
					background: #ffffff;
				}
			<?php endif; ?>
			<?php if( $default_options[ 'attitude_buttons_color' ] != $attitude_theme_options_settings[ 'attitude_buttons_color' ] ) : ?>
				/* Buttons, Custom Tag Cloud and Paginations */
				input[type="reset"],
				input[type="button"],
				input[type="submit"],
				input[type="reset"]:hover,
				input[type="button"]:hover,
				input[type="submit"]:hover,
				a.readmore,
				a.readmore:hover,
				.widget_custom-tagcloud a:hover,
				#wp_page_numbers ul li a:hover,
				#wp_page_numbers ul li.active_page a,
				.wp-pagenavi .current,
				.wp-pagenavi a:hover,
				ul.default-wp-page li a:hover,
				.pagination span,
				div.bbp-submit-wrapper button,
				.woocommerce #respond input#submit,
				.woocommerce a.button,
				.woocommerce button.button,
				.woocommerce input.button,
				.woocommerce #respond input#submit.alt,
				.woocommerce a.button.alt,
				.woocommerce button.button.alt,
				.woocommerce input.button.alt,
				.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
				.woocommerce input.button:disabled,
				.woocommerce input.button:disabled[disabled],
				.woocommerce input.button:disabled:hover,
				.woocommerce input.button:disabled[disabled]:hover,
				.woocommerce #respond input#submit:hover,
				.woocommerce a.button:hover,
				.woocommerce button.button:hover,
				.woocommerce input.button:hover,
				.woocommerce #respond input#submit.alt:hover,
				.woocommerce a.button.alt:hover,
				.woocommerce button.button.alt:hover,
				.woocommerce input.button.alt:hover,
				.woocommerce span.onsale,
				.woocommerce .widget_price_filter .ui-slider .ui-slider-range,
				.woocommerce .widget_price_filter .ui-slider .ui-slider-handle {
					background: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_buttons_color' ] ); ?>;
					border-color: rgba(0, 0, 0, 0.2);
				}
			<?php endif; ?>
			<?php if( $default_options[ 'attitude_link_color' ] != $attitude_theme_options_settings[ 'attitude_link_color' ] ) : ?>
				/* links */
				a,
				#site-title a span,
				#site-title a:hover,
				#site-title a:focus,
				#site-title a:active,
				#access a:hover,
				#access ul li.current-menu-item > a,
				#access ul li.current_page_ancestor > a,
				#access ul li.current-menu-ancestor > a,
				#access ul li.current_page_item > a,
				#access ul li:hover > a,
				#access ul li ul li a:hover,
				#access ul li ul li:hover > a,
				#access ul li.current-menu-item ul li a:hover,
				#content ul a:hover,
				#content ol a:hover,
				#content .gal-filter li.active a,
				.entry-title a:hover,
				.entry-title a:focus,
				.entry-title a:active,
				.entry-meta a:hover,
				.tags a:hover,
				.custom-gallery-title a:hover,
				.widget ul li a:hover,
				.widget-title a:hover,
				.widget_tag_cloud a:hover,
				#site-generator .copyright a:hover,
				.woocommerce .star-rating,
				.woocommerce .star-rating:before,
				.widget_categories .current-cat a,
				.widget_nav_menu ul li.current_page_item > a,
				.widget_nav_menu ul li.current_page_ancestor > a,
				.widget_nav_menu ul li.current-menu-item > a,
				.widget_nav_menu ul li.current-menu-ancestor > a,
				.widget_pages ul li.current_page_item > a,
				.widget_pages ul li.current_page_ancestor > a {
					color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_link_color' ] ); ?>;
				}
				#access ul li ul,
				blockquote {
					border-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_link_color' ] ); ?>;
				}
			<?php endif; ?>
			<?php /* Background color */ ?>
			<?php if( ( $default_options[ 'attitude_content_background_color' ] != $attitude_theme_options_settings[ 'attitude_content_background_color' ] ) || ( $default_options[ 'content_background_pattern' ] != $attitude_theme_options_settings[ 'content_background_pattern' ] ) ) : ?>
				/* Main Content */
				.wrapper { 
					<?php if( $attitude_theme_options_settings[ 'content_background_pattern' ] != 'disable' ): ?>
						background-image: url("<?php echo ATTITUDE_IMAGES_URL; ?>/patterns/<?php echo $attitude_theme_options_settings[ 'content_background_pattern' ]; ?>.png");
					<?php endif; ?>
					background-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_content_background_color' ] ); ?>;
					-webkit-box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
					-moz-box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
					box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
				}
				#content .post,
				.entry-meta-bar,
				#wp_page_numbers, 
				.wp-pagenavi, 
				#content ul.default-wp-page,
				.pagination { 
					border-color: rgba(0, 0, 0, 0.2); 
				}
			<?php endif; ?>
			<?php if( $default_options[ 'attitude_input_field_color' ] != $attitude_theme_options_settings[ 'attitude_input_field_color' ] ) : ?>
			/* Form Input Fields */
			input,
			textarea,
			select,
			.woocommerce-page .select2-container--default .select2-selection--single,
			.widget_search input.s {
				border-color: rgba(0, 0, 0, 0.05);
				background-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_input_field_color' ] ); ?>;
			}
			<?php endif; ?>
			<?php if( $default_options[ 'attitude_header_search_color' ] != $attitude_theme_options_settings[ 'attitude_header_search_color' ] ) : ?>
			/* Header Search Form */
			input.s {
				background-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_header_search_color' ] ); ?>;
			}
			<?php endif; ?>
			<?php if( $default_options[ 'attitude_top_navigation_background_color' ] != $attitude_theme_options_settings[ 'attitude_top_navigation_background_color' ] ) : ?>
			/* Access */
			#access { 
				background-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_top_navigation_background_color' ] ); ?>;
				border-color: rgba(0, 0, 0, 0.2); 
			}
			<?php endif; ?>
			<?php if( $default_options[ 'attitude_page_title_wrap_color' ] != $attitude_theme_options_settings[ 'attitude_page_title_wrap_color' ] ) : ?>
			/* Page Title, Paginations  */
			.widget_testimonial .testimonial-post,
			.page-title-wrap,
			#wp_page_numbers ul li a,
			.wp-pagenavi a,
			ul.default-wp-page li a,
			.pagination a:hover span {
				background-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_page_title_wrap_color' ] ); ?>;
			   border-color: rgba(0, 0, 0, 0.2);
			}
			pre, code, kbd,
			blockquote {
				background-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_page_title_wrap_color' ] ); ?>;
			}
			<?php endif; ?>
			<?php if( $default_options[ 'attitude_sticky_post_color' ] != $attitude_theme_options_settings[ 'attitude_sticky_post_color' ] ) : ?>
				/* Sticky Post  */
				.sticky { 
					background-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_sticky_post_color' ] ); ?>; 
				}
			<?php endif; ?>
			<?php if( ( $default_options[ 'attitude_footer_background_color' ] != $attitude_theme_options_settings[ 'attitude_footer_background_color' ] ) || ( $default_options[ 'footer_background_pattern' ] != $attitude_theme_options_settings[ 'footer_background_pattern' ] ) ): ?>
				/* Footer */
				#colophon .widget-wrap { 
					<?php if( $attitude_theme_options_settings[ 'footer_background_pattern' ] != 'disable' ): ?>
						background-image: url("<?php echo ATTITUDE_IMAGES_URL; ?>/patterns/<?php echo $attitude_theme_options_settings[ 'footer_background_pattern' ]; ?>.png");
					<?php endif; ?>
					background-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_footer_background_color' ] ); ?>;  
					border-color: rgba(0, 0, 0, 0.2); 
				}
			<?php endif; ?>
			<?php if( ( $default_options[ 'attitude_sitegenerator_background_color' ] != $attitude_theme_options_settings[ 'attitude_sitegenerator_background_color' ] ) || ( $default_options[ 'sitegenerator_background_pattern' ] != $attitude_theme_options_settings[ 'sitegenerator_background_pattern' ] ) ): ?>
				/* Site Generator */
				#site-generator { 
					<?php if( $attitude_theme_options_settings[ 'sitegenerator_background_pattern' ] != 'disable' ): ?>
						background-image: url("<?php echo ATTITUDE_IMAGES_URL; ?>/patterns/<?php echo $attitude_theme_options_settings[ 'sitegenerator_background_pattern' ]; ?>.png");
					<?php endif; ?>
					background-color: <?php echo esc_attr( $attitude_theme_options_settings[ 'attitude_sitegenerator_background_color' ] ); ?>;
					border-color: rgba(0, 0, 0, 0.2); 
				}
			<?php endif; ?>
	</style>
<?php	
}
?>