/* global FusionPageBuilderApp, FusionPageBuilder, FusionPageBuilderElements */
/* eslint no-unused-vars: 0 */

( function() {

	// Insert shortcode into post editor
	window.fusionBuilderInsertIntoEditor = function( shortcode, editorID ) { // jshint ignore:line
		var editorArea,
			editor;

		if ( 'tinymce' === window.SCmoduleContentEditorMode && ( '' === editorID || 'undefined' === typeof editorID ) ) {

			if ( 'undefined' !== typeof window.tinyMCE ) {

				// Set active editor
				editor = FusionPageBuilderApp.shortcodeGeneratorActiveEditor;
				editor.focus();

				if ( 'excerpt' === editor.id ) {
					FusionPageBuilderApp.fromExcerpt = true;
				}

				// Insert shortcode
				window.tinyMCE.activeEditor.execCommand( 'mceInsertContent', false, shortcode );
				window.tinyMCE.activeEditor.execCommand( 'mceCleanup', false );
			}

		} else {

			if ( null === editorID || '' === editorID || 'undefined' === typeof editorID ) {
				editorArea = jQuery( window.editorArea );

			} else {
				editorArea = jQuery( '#' + editorID );
			}

			if ( 'excerpt' === editorArea.attr( 'id' ) ) {
				FusionPageBuilderApp.fromExcerpt = true;
			}

			if ( 'undefined' === typeof window.cursorPosition ) {
				if ( 0 === editorArea.getCursorPosition() ) {
					editorArea.val( shortcode + editorArea.val() );
				} else if ( editorArea.val().length === editorArea.getCursorPosition() ) {
					editorArea.val( editorArea.val() + shortcode );
				} else {
					editorArea.val( editorArea.val().slice( 0, editorArea.getCursorPosition() ) + shortcode + editorArea.val().slice( editorArea.getCursorPosition() ) );
				}
			} else {
				editorArea.val( [ editorArea.val().slice( 0, window.cursorPosition ), shortcode, editorArea.val().slice( window.cursorPosition ) ].join( '' ) );
			}

			editorArea.trigger( 'change' );
		}

		if ( false === FusionPageBuilderApp.manuallyAdded ) {
			FusionPageBuilderApp.shortcodeGeneratorActiveEditor = '';
		}
	};

}( jQuery ) );

function openShortcodeGenerator( trigger ) { // jshint ignore:line

	// Get editor id from event.trigger.  parent.parent

	var view,
		viewSettings,
		editorArea,
		editorCid;

	if ( 'object' === typeof trigger && 'undefined' !== typeof trigger[ 0 ].$el ) {
		trigger = trigger[ 0 ].$el;
	}

	editorArea = '#' + trigger.parent().parent().find( '.wp-editor-area' ).attr( 'id' );
	editorCid  = trigger.closest( '.fusion-builder-module-settings' ).attr( 'data-element-cid' );

	window.cursorPosition = 0;
	window.editorArea = editorArea;

	// Set shortcode generator flag
	FusionPageBuilderApp.shortcodeGenerator = true;

	// Get active editor mode
	if ( FusionPageBuilderApp.isTinyMceActive() ) {
		window.SCmoduleContentEditorMode = 'tinymce';
	} else {
		window.SCmoduleContentEditorMode = 'html';
	}

	// Get current cursor position ( for html editor )
	if ( 'tinymce' !== window.SCmoduleContentEditorMode ) {
		window.cursorPosition = jQuery( editorArea ).getCursorPosition();
	}

	viewSettings = {
		collection: FusionPageBuilderElements,
		view: this,
		targetCid: editorCid
	},

	view = new FusionPageBuilder.GeneratorElementsView( viewSettings );

	jQuery( view.render().el ).dialog( {
		title: 'Select Element',
		draggable: false,
		modal: true,
		resizable: false,
		dialogClass: 'fusion-builder-dialog fusion-builder-large-library-dialog fusion-builder-element-library-dialog',
		open: function( event, ui ) { // jshint ignore: line
			window.FusionApp.dialog.resizeDialog();
		},
		close: function( event, ui ) { // jshint ignore: line
			view.remove();
		}
	} );
}

// Helper function to check the cursor position of text editor content field before the shortcode generator is opened
( function() {
	jQuery.fn.getCursorPosition = function() {
		var el  = jQuery( this ).get( 0 ),
			pos = 0,
			Sel,
			SelLength;

		if ( 'selectionStart' in el ) {
			pos = el.selectionStart;
		} else if ( 'selection' in document ) {
			el.focus();
			Sel       = document.selection.createRange();
			SelLength = document.selection.createRange().text.length;
			Sel.moveStart( 'character', -el.value.length );
			pos = Sel.text.length - SelLength;
		}
		return pos;
	};
}( jQuery ) );
;/* global FusionPageBuilderApp, FusionApp, fusionBuilderText, FusionEvents */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	// Builder Builder History
	FusionPageBuilder.BuilderHistory = window.wp.Backbone.View.extend( {

		template: FusionPageBuilder.template( jQuery( '#fusion-builder-front-end-history' ).html() ),
		className: 'fusion-builder-history-list submenu-trigger-target',
		tagName: 'ul',

		/**
		 * Init.
		 *
		 * @since 2.0.0
		 * @param {Object} data - The data.
		 * @return {void}
		 */
		initialize: function() {
			var data = FusionApp.data;

			this.fusionCommands       = new Array( '[]' );
			this.fusionCommandsStates = new Array( '[]' ); // History states
			this.maxSteps             = 25; // Maximum steps allowed/saved
			this.currStep             = 1; // Current Index of step
			this.allElements          = data.postDetails.post_content;
			this.fusionHistoryState   = '';
			this.tracking             = 'on';
			this.trackingPaused       = 'off';
			this.unsavedStep          = 1; // Unsaved steps.

			// Set initial history step
			this.fusionCommands[ this.currStep ]       = { allElements: data.postDetails.post_content };
			this.fusionCommandsStates[ this.currStep ] = fusionBuilderText.empty;

			this.listenTo( FusionEvents, 'fusion-history-pause-tracking', this.pauseTracking );
			this.listenTo( FusionEvents, 'fusion-history-resume-tracking', this.resumeTracking );
			this.listenTo( FusionEvents, 'fusion-history-save-step', this.saveHistoryStep );
			this.listenTo( FusionEvents, 'fusion-history-turn-on-tracking', this.turnOnTracking );
			this.listenTo( FusionEvents, 'fusion-history-turn-off-tracking', this.turnOffTracking );
			this.listenTo( FusionEvents, 'fusion-history-go-to-step', this.historyStep );
			this.listenTo( FusionEvents, 'fusion-history-clear', this.clearEditor );
			this.listenTo( FusionEvents, 'fusion-history-capture-editor', this.captureEditor );
			this.listenTo( FusionEvents, 'fusion-history-undo', this.doUndo );
			this.listenTo( FusionEvents, 'fusion-history-redo', this.doRedo );
			this.listenTo( FusionEvents, 'fusion-app-saved', this.clearEditor );
			this.listenTo( FusionEvents, 'fusion-builder-reset', this.resetStates );
			this.listenTo( FusionEvents, 'fusion-element-removed', this.resetStates );
		},

		resetStates: function( cid ) {
			var self = this;

			if ( 'object' === typeof this.fusionCommands ) {
				_.each( this.fusionCommands, function( state, index ) {
					if ( 'undefined' === typeof cid || ! cid || ( 'param' === state.type && 'undefined' !== typeof state.cid && cid === state.cid ) ) {
						self.fusionCommands[ index ] = { allElements: state.allElements };
					}
				} );
			}
		},

		/**
		 * Renders the view.
		 *
		 * @since 2.0.0
		 * @return {Object} this
		 */
		render: function() {
			var self = this;

			this.$el.html( this.template( { steps: this.fusionCommandsStates, currentStep: this.currStep } ) );
			this.$el.attr( 'aria-expanded', false );
			this.$el.find( 'li' ).on( 'click', function( event ) {
				if ( event ) {
					event.preventDefault();
				}
				self.historyStep( event );
			} );

			this.updateUI();

			return this;
		},

		/**
		 * Saves a step in the history.
		 *
		 * @since 2.0.0
		 * @param {string} text - The text to be displayed in the history log.
		 * @return {void}
		 */
		saveHistoryStep: function( text, state ) {

			this.fusionHistoryState = text;

			this.turnOnTracking();
			this.captureEditor( state );
			this.turnOffTracking();
		},

		/**
		 * Captures the editor (used in front-end.js)
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		captureEditor: function( state ) {
			if ( 'object' !== typeof state ) {
				state = {};
			}

			if ( 'undefined' === typeof FusionPageBuilderApp ) {
				return;
			}

			FusionPageBuilderApp.builderToShortcodes();

			if ( this.isTrackingOn() && ! this.isTrackingPaused() ) {

				// If reached limit
				if ( this.currStep == this.maxSteps ) {

					// Remove first index
					this.fusionCommands.shift();
					this.fusionCommandsStates.shift();
				} else {

					// Else increment index
					this.currStep    += 1;
					this.unsavedStep += 1;
				}

				// If we are not at the end of the states, we need to wipe those ahead.
				if ( this.currStep !== this.fusionCommands.length ) {
					this.fusionCommandsStates.length = this.currStep;
					this.fusionCommands.length       = this.currStep;
				}

				// Get content
				this.allElements = FusionApp.data.postDetails.post_content;

				// Add all elements as fallback method.
				state.allElements = this.allElements;

				// Add editor data to Array
				this.fusionCommands[ this.currStep ] = state;

				// Add history state
				this.fusionCommandsStates[ this.currStep ] = this.fusionHistoryState;

				FusionApp.contentChange( 'page', 'builder-content' );

				// Update buttons
				this.fusionHistoryState = '';
				this.render();
			}
		},

		/**
		 * Turn history tracking ON.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		turnOnTracking: function() {
			this.tracking = 'on';
		},

		/**
		 * Turn history tracking OFF.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		turnOffTracking: function() {
			this.tracking = 'off';
		},

		/**
		 * Turn history tracking ON.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		pauseTracking: function() {
			this.trackingPaused = 'on';
		},

		/**
		 * Turn history tracking OFF.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		resumeTracking: function() {
			this.trackingPaused = 'off';
		},

		canApplyStep: function( historyStep ) {
			if ( 'object' !== typeof historyStep || 'undefined' === typeof historyStep.type ) {
				return false;
			}

			if ( 'param' === historyStep.type || 'price-param' === historyStep.type || 'pricefooter-param' === historyStep.type || 'pricefeatures-param' === historyStep.type ) {
				return true;
			}

			return false;
		},

		canApplySteps: function( stepIndex ) {
			var self     = this,
				redo     = stepIndex < this.currStep ? false : true,
				steps    = [],
				canApply = true;

			if ( ! redo ) {
				steps = this.fusionCommands.slice( stepIndex + 1, this.currStep + 1 );
			} else {
				steps = this.fusionCommands.slice( this.currStep + 1, stepIndex + 1 );
			}

			_.each( steps, function( step ) {
				if ( ! self.canApplyStep( step ) ) {
					canApply = false;
				}
			} );

			return canApply;
		},

		applySteps: function( stepIndex ) {
			var self  = this,
				redo  = stepIndex < this.currStep ? false : true,
				steps = [];

			if ( ! redo ) {
				steps     = this.fusionCommands.slice( stepIndex + 1, this.currStep + 1 ).reverse();
			} else {
				steps = this.fusionCommands.slice( this.currStep + 1, stepIndex + 1 );
			}

			_.each( steps, function( step ) {
				self.applyStep( step, redo );
			} );
		},

		applyStep: function( historyStep, redo ) {
			var elementView,
				params,  // eslint-disable-line no-unused-vars
				columnView;

			redo = 'undefined' === typeof redo ? false : redo;

			switch ( historyStep.type ) {

			case 'param':
				elementView = window.FusionPageBuilderViewManager.getView( historyStep.cid );
				if ( elementView ) {
					params = elementView.model.get( 'params' ); // eslint-disable-line no-unused-vars

					// If undo, set new value to step so redo can use it.
					if ( ! redo ) {
						elementView.historyUpdateParam( historyStep.param, historyStep.oldValue );
						FusionEvents.trigger( 'fusion-param-changed', historyStep.param, historyStep.oldValue );
						FusionEvents.trigger( 'fusion-param-changed-' + historyStep.cid, historyStep.param, historyStep.oldValue );
					} else {
						elementView.historyUpdateParam( historyStep.param, historyStep.newValue );
						FusionEvents.trigger( 'fusion-param-changed', historyStep.param, historyStep.newValue );
						FusionEvents.trigger( 'fusion-param-changed-' + historyStep.cid, historyStep.param, historyStep.newValue );
					}
				}
				break;

			case 'price-param':
				elementView = window.FusionPageBuilderViewManager.getView( historyStep.cid );
				if ( elementView ) {

					// If undo, set new value to step so redo can use it.
					if ( ! redo ) {
						elementView.updatePricingTablePrice( historyStep.param, historyStep.oldValue );
						FusionEvents.trigger( 'fusion-param-changed', historyStep.param, historyStep.oldValue );
						FusionEvents.trigger( 'fusion-param-changed-' + historyStep.cid, historyStep.param, historyStep.oldValue );
					} else {
						elementView.updatePricingTablePrice( historyStep.param, historyStep.newValue );
						FusionEvents.trigger( 'fusion-param-changed', historyStep.param, historyStep.newValue );
						FusionEvents.trigger( 'fusion-param-changed-' + historyStep.cid, historyStep.param, historyStep.newValue );
					}
				}
				break;

			case 'pricefooter-param':
				elementView = window.FusionPageBuilderViewManager.getView( historyStep.cid );
				if ( elementView ) {

					// If undo, set new value to step so redo can use it.
					if ( ! redo ) {
						elementView.updatePricingTableFooter( historyStep.oldValue );
						FusionEvents.trigger( 'fusion-param-changed', 'footer_content', historyStep.oldValue );
						FusionEvents.trigger( 'fusion-param-changed-' + historyStep.cid, 'footer_content', historyStep.oldValue );
					} else {
						elementView.updatePricingTableFooter( historyStep.newValue );
						FusionEvents.trigger( 'fusion-param-changed', 'footer_content', historyStep.newValue );
						FusionEvents.trigger( 'fusion-param-changed-' + historyStep.cid, 'footer_content', historyStep.newValue );
					}
				}
				break;

			case 'pricefeatures-param':
				elementView = window.FusionPageBuilderViewManager.getView( historyStep.cid );
				if ( elementView ) {

					// If undo, set new value to step so redo can use it.
					if ( ! redo ) {
						elementView.updatePricingTableFeatures( historyStep.oldValue );
						FusionEvents.trigger( 'fusion-param-changed', 'footer_content', historyStep.oldValue );
						FusionEvents.trigger( 'fusion-param-changed-' + historyStep.cid, 'feature_rows', historyStep.oldValue );
					} else {
						elementView.updatePricingTableFeatures( historyStep.newValue );
						FusionEvents.trigger( 'fusion-param-changed', 'footer_content', historyStep.newValue );
						FusionEvents.trigger( 'fusion-param-changed-' + historyStep.cid, 'feature_rows', historyStep.newValue );
					}
				}
				break;

			case 'add-element':
				if ( redo ) {
					FusionPageBuilderApp.collection.add( historyStep.model );
				} else {
					elementView = window.FusionPageBuilderViewManager.getView( historyStep.model.cid );
					if ( elementView ) {
						elementView.removeElement();
					}
				}
				break;

			case 'remove-element':
				if ( redo ) {
					elementView = window.FusionPageBuilderViewManager.getView( historyStep.model.cid );
					if ( elementView ) {
						elementView.removeElement();
					}
				} else {
					FusionPageBuilderApp.collection.add( historyStep.model );
				}
				break;

			case 'move-element':
				elementView = window.FusionPageBuilderViewManager.getView( historyStep.cid );

				// Need to ignore itself.
				elementView.$el.addClass( 'ignore-me' );

				if ( redo ) {
					columnView = window.FusionPageBuilderViewManager.getView( historyStep.newParent );
					if ( elementView && columnView ) {
						columnView.$el.find( '.fusion-builder-column-content' ).first().find( '> span, > div' ).not( '.ignore-me' ).eq( ( historyStep.newIndex - 1 ) ).after( elementView.$el );
						FusionPageBuilderApp.onDropCollectionUpdate( elementView.model, historyStep.newIndex, historyStep.newParent );
					}
				} else {
					columnView = window.FusionPageBuilderViewManager.getView( historyStep.oldParent );
					if ( elementView && columnView ) {
						columnView.$el.find( '.fusion-builder-column-content' ).first().find( '> span, > div' ).not( '.ignore-me' ).eq( ( historyStep.oldIndex - 1 ) ).after( elementView.$el );
						FusionPageBuilderApp.onDropCollectionUpdate( elementView.model, historyStep.oldIndex, historyStep.oldParent );
					}
				}

				elementView.$el.removeClass( 'ignore-me' );

				break;
			}
		},

		updateActiveStyling: function() {
			FusionApp.builderToolbarView.$el.find( '.fusion-builder-history-list li' ).removeClass( 'fusion-history-active-state' );
			FusionApp.builderToolbarView.$el.find( '.fusion-builder-history-list' ).find( '[data-state-id="' + this.currStep + '"]' ).addClass( 'fusion-history-active-state' );
		},

		fullContentReplace: function( data ) {
			this.resetStates();
			FusionPageBuilderApp.clearBuilderLayout();
			FusionPageBuilderApp.$el.find( '.fusion_builder_container' ).remove();

			// Reset models with new elements
			FusionPageBuilderApp.createBuilderLayout( data );
		},

		/**
		 * Undo last step in history.
		 * Saves the undone step so that we may redo later if needed.
		 *
		 * @since 2.0.0
		 * @param {Object} event - The event.
		 * @return {void}
		 */
		doUndo: function( event ) {

			var undoData,
				historyStep = {};

			if ( event ) {
				event.preventDefault();
			}

			// Turn off tracking first, so these actions are not captured
			if ( this.hasUndo() ) { // If no data or end of stack and nothing to undo

				// Close opened nested cols to make sure UI works after history change.
				this.closeNestedCols();

				this.turnOffTracking();

				// Data to undo
				historyStep = this.fusionCommands[ this.currStep ];

				if ( this.canApplyStep( historyStep ) ) {
					this.applyStep( historyStep, false );
					this.currStep -= 1;
				} else {
					this.currStep -= 1;
					historyStep    = this.fusionCommands[ this.currStep ];
					undoData       = 'object' === typeof historyStep ? historyStep.allElements : false;
					if ( undoData && '[]' !== undoData ) {
						this.fullContentReplace( undoData );
					}
				}
				this.updateActiveStyling();

				// TODO: check what this is for.
				if ( FusionPageBuilderApp.wireframeActive ) {
					FusionEvents.trigger( 'fusion-undo-state' );
				}
			}
		},

		/**
		 * Redo last step.
		 *
		 * @since 2.0.0
		 * @param {Object} event - The event.
		 * @return {void}
		 */
		doRedo: function( event ) {

			var redoData;

			if ( event ) {
				event.preventDefault();
			}

			if ( this.hasRedo() ) { // If not at end and nothing to redo

				// Close opened nested cols to make sure UI works after history change.
				this.closeNestedCols();

				// Turn off tracking, so these actions are not tracked
				this.turnOffTracking();

				// Move index
				this.currStep += 1;

				window.historyStep = this.fusionCommands[ this.currStep ];
				redoData           = 'object' === typeof window.historyStep ? window.historyStep.allElements : false;

				if ( this.canApplyStep( window.historyStep ) ) {
					this.applyStep( window.historyStep, true );
				} else if ( redoData && '[]' !== redoData ) {
					this.fullContentReplace( redoData );
				}

				this.updateActiveStyling();
			}
		},

		/**
		 * Go to a step.
		 *
		 * @since 2.0.0
		 * @param {string|number} step - The step.
		 * @param {Object}     event - The event.
		 * @return {void}
		 */
		historyStep: function( event ) {
			var step,
				stepData;

			if ( event ) {
				event.preventDefault();
			}

			// Close opened nested cols to make sure UI works after history change.
			this.closeNestedCols();

			step = jQuery( event.currentTarget ).data( 'state-id' );

			// Turn off tracking, so these actions are not tracked
			this.turnOffTracking();

			if ( this.canApplySteps( step ) ) {
				this.applySteps( step );
				this.currStep = step;
			} else {
				this.currStep = step;
				stepData      = 'object' === typeof this.fusionCommands[ this.currStep ] ? this.fusionCommands[ this.currStep ].allElements : false;
				if ( stepData && '[]' !== stepData ) {

					this.fullContentReplace( stepData );

					// TODO: Check what this is for.
					if ( FusionPageBuilderApp.wireframeActive ) {
						FusionEvents.trigger( 'fusion-undo-state' );
					}
				}
			}
			this.updateActiveStyling();
		},

		/**
		 * Are we currently tracking history?
		 *
		 * @since 2.0.0
		 * @return {boolean}
		 */
		isTrackingOn: function() {
			return 'on' === this.tracking;
		},

		/**
		 * Is tracking paused currently?
		 *
		 * @since 2.0.0
		 * @return {boolean}
		 */
		isTrackingPaused: function() {
			return 'on' === this.trackingPaused;
		},

		/**
		 * Log commands in the console as JSON.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		logStacks: function() {
			console.log( JSON.parse( this.fusionCommands ) );
		},

		/**
		 * Clear the editor.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		clearEditor: function() {
			this.fusionCommands       = new Array( '[]' );
			this.fusionCommandsStates = new Array( '[]' );
			this.currStep             = 1;
			this.unsavedStep          = 1;
			this.fusionHistoryState   = '';

			this.fusionCommands[ this.currStep ]       = { allElements: FusionApp.data.postDetails.post_content };
			this.fusionCommandsStates[ this.currStep ] = fusionBuilderText.empty;
			this.render();
		},

		/**
		 * Do we have an undo? Checks if the current step is the 1st one.
		 *
		 * @since 2.0.0
		 * @return {boolean}
		 */
		hasUndo: function() {
			return 1 !== this.currStep;
		},

		/**
		 * Do we have a redo? Checks if a step greater than current one exists.
		 *
		 * @since 2.0.0
		 * @return {boolean}
		 */
		hasRedo: function() {
			return this.currStep < ( this.fusionCommands.length - 1 );
		},

		/**
		 * Get the array of steps/fusionCommands.
		 *
		 * @since 2.0.0
		 * @return {Array}
		 */
		getCommands: function() {
			return this.fusionCommands;
		},

		/**
		 * Update the undo/redo/history buttons.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		updateUI: function() {
			if ( 1 < this.unsavedStep ) {
				FusionApp.builderToolbarView.$el.find( '#fusion-builder-toolbar-history-menu' ).attr( 'data-has-unsaved', true );
			} else {
				FusionApp.builderToolbarView.$el.find( '#fusion-builder-toolbar-history-menu' ).attr( 'data-has-unsaved', false );
			}
			this.updateActiveStyling();
		},

		/**
		 * Close nested cols.
		 *
		 * @since 2.2
		 * @return {void}
		 */
		closeNestedCols: function() {
			var activeNestedCols = FusionPageBuilderApp.$el.find( '.fusion-nested-columns.editing' ).length;

			if ( activeNestedCols ) {
				activeNestedCols.find( '.fusion-builder-cancel-row' ).trigger( 'click' );
			}
		}
	} );
}( jQuery ) );
;/* global FusionPageBuilderApp, fusionAppConfig, FusionApp, FusionEvents, fusionBuilderText */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Toolbar
		FusionPageBuilder.BuilderToolbar = window.wp.Backbone.View.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-front-end-toolbar' ).html() ),
			className: 'fusion-toolbar-nav fb',
			tagName: 'ul',
			events: {
				'click .fusion-builder-clear-layout': 'clearLayout',
				'click .fusion-builder-open-library': 'openLibrary',
				'click .fusion-builder-save-template': 'openLibrary',
				'click #fusion-builder-toolbar-new-post .add-new': 'newPost',
				'click .fusion-builder-preferences': 'openPreferences',
				'click #fusion-builder-toolbar-history-menu': 'preventDefault',
				'click .fusion-preview-only-link': 'generatePreview'
			},

			toggleWireframe: function( event ) {

				if ( 'undefined' !== typeof event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.wireframe.toggleWireframe();
			},

			initialize: function() {
				this.builderHistory = new FusionPageBuilder.BuilderHistory();
				this.listenTo( FusionEvents, 'fusion-post_title-changed', this.updatePreviewTitle );
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				this.$el.html( this.template() );
				this.$el.find( '.fusion-builder-history-container' ).append( this.builderHistory.render().el );

				this.moveWireframe();
				this.delegateEvents();

				return this;
			},

			/**
			 * Due to placement wireframe icon needs moved into shared area.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			moveWireframe: function() {

				// Remove existing.
				FusionApp.toolbarView.$el.find( '.fusion-wireframe-holder' ).remove();

				// Copy new to location.
				FusionApp.toolbarView.$el.find( '.fusion-builder-preview-viewport' ).after( this.$el.find( '.fusion-wireframe-holder' ) );

				// Add listener to new location.
				FusionApp.toolbarView.$el.find( '.fusion-builder-wireframe-toggle' ).on( 'click', this.toggleWireframe );
			},

			/**
			 * Make sure all the unsaved content is set like on frame refresh, then open page.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The JS event.
			 * @return {Object} this
			 */
			generatePreview: function( event ) {
				var $element = jQuery( event.currentTarget );

				if ( 'undefined' !== typeof event ) {
					event.preventDefault();
					event.stopPropagation();
				}

				if ( $element.attr( 'data-disabled' ) ) {
					return;
				}

				$element.attr( 'data-disabled', true );

				// Avada Builder
				if ( 'undefined' !== typeof FusionPageBuilderApp ) {
					FusionPageBuilderApp.builderToShortcodes();
				}

				// Fusion Panel
				if ( this.sidebarView ) {
					this.setGoogleFonts();
				}

				FusionApp.formPost( FusionApp.getAjaxData( 'fusion_app_preview_only' ), false, '_blank' );

				$element.removeAttr( 'data-disabled' );
			},

			/**
			 * Opens the library.
			 * Calls the LibraryView and then renders it.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			openLibrary: function( event ) {
				var view,
					libraryModel = {
						target: jQuery( event.currentTarget ).data( 'target' ),
						focus: jQuery( event.currentTarget ).data( 'focus' )
					},
					viewSettings = {
						model: libraryModel
					};

				if ( 'undefined' !== typeof event ) {
					event.preventDefault();
					event.stopPropagation();
				}

				if ( jQuery( '.fusion-builder-dialog' ).length && jQuery( '.fusion-builder-dialog' ).is( ':visible' ) ) {
					FusionApp.multipleDialogsNotice();
					return;
				}

				view = new FusionPageBuilder.LibraryView( viewSettings );
				view.render();
			},

			/**
			 * Clears the layout.
			 * Calls FusionPageBuilderApp.clearLayout
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			clearLayout: function( event ) {
				if ( event ) {
					event.preventDefault();
				}

				FusionApp.confirmationPopup( {
					title: fusionBuilderText.are_you_sure,
					content: fusionBuilderText.are_you_sure_you_want_to_delete_this_layout,
					actions: [
						{
							label: fusionBuilderText.cancel,
							classes: 'cancel',
							callback: function() {
								FusionApp.confirmationPopup( {
									action: 'hide'
								} );
							}
						},
						{
							label: fusionBuilderText.remove,
							classes: 'delete-layout',
							callback: function() {

								// Close dialogs.
								if ( jQuery( '.ui-dialog-content' ).length ) {
									jQuery( '.ui-dialog-content' ).dialog( 'close' );
								}

								FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.layout_cleared );
								FusionPageBuilderApp.clearLayout( event );

								FusionApp.confirmationPopup( {
									action: 'hide'
								} );
							}
						}
					]
				} );
			},

			/**
			 * Create a new draft of specific post type.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			newPost: function( event ) {
				var postType = jQuery( event.currentTarget ).data( 'post-type' );

				if ( event ) {
					event.preventDefault();
				}

				jQuery.ajax( {
					type: 'POST',
					url: fusionAppConfig.ajaxurl,
					dataType: 'JSON',
					data: {
						action: 'fusion_create_post',
						fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
						post_type: postType
					}
				} )
				.done( function( response ) {
					FusionApp.checkLink( event, response.permalink );
				} );
			},

			/**
			 * Renders the FusionPageBuilder.PreferencesView view.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			openPreferences: function( event ) {
				var view;

				if ( 'undefined' !== typeof event ) {
					event.preventDefault();
					event.stopPropagation();
				}

				if ( jQuery( '.fusion-builder-dialog' ).length && jQuery( '.fusion-builder-dialog' ).is( ':visible' ) ) {
					FusionApp.multipleDialogsNotice();
					return;
				}

				view = new FusionPageBuilder.PreferencesView();
				view.render();
			},

			/**
			 * Prevents default action.
			 *
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			preventDefault: function( event ) {
				event.preventDefault();
			},

			/**
			 * Updates the text for the title of the page.
			 *
			 * @return {void}
			 */
			updatePreviewTitle: function() {
				this.$el.find( '.fusion-preview-only-link strong' ).html( FusionApp.getPost( 'post_title' ) );
			}
		} );
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	// Builder element model
	FusionPageBuilder.Element = Backbone.Model.extend( {
		defaults: {
			type: 'element'
		}
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	FusionPageBuilder.ExtraShortcodes = Backbone.Model.extend( {
		defaults: {
			elementCount: 0,
			shortcodes: {}
		},

		addData: function( content ) {
			var self         = this,
				shortcodes   = self.get( 'shortcodes' ),
				elementCount = self.get( 'elementCount' );

			_.each( content, function( shortcode ) {
				shortcode.id               = elementCount;
				shortcode.matcher          = self.convert( shortcode.shortcode );
				shortcodes[ elementCount ] = shortcode;
				elementCount++;
			} );

			this.set( { elementCount: elementCount } );
			this.set( { shortcodes: shortcodes } );
		},

		addShortcode: function( shortcode, output, tag ) {
			var self          = this,
				shortcodes    = self.get( 'shortcodes' ),
				elementCount  = self.get( 'elementCount' ),
				originalCount = self.get( 'elementCount' );

			shortcodes[ elementCount ] = {
				shortcode: shortcode,
				output: output,
				matcher: self.convert( shortcode ),
				id: elementCount,
				tag: tag
			};
			elementCount++;

			this.set( { elementCount: elementCount } );
			this.set( { shortcodes: shortcodes } );

			return originalCount;
		},

		byId: function( id ) {
			var shortcodes = this.get( 'shortcodes' );
			return shortcodes[ id ];
		},

		byShortcode: function( content ) {
			var shortcodes = this.get( 'shortcodes' ),
				$matches = _.findWhere( shortcodes, { shortcode: content } );

			if ( 'undefined' === typeof $matches ) {
				content  = this.convert( content );
				$matches = _.findWhere( shortcodes, { matcher: content } );
			}

			return $matches;
		},

		byOutput: function( content ) {
			var shortcodes = this.get( 'shortcodes' );
			return _.findWhere( shortcodes, { ouput: content } );
		},

		getAll: function() {
			return this.get( 'shortcodes' );
		},

		convert: function( content ) {

			// Clean up any parts which can be ignored for sake of matching.
			content = content.replace( / /g, '' );
			content = content.replace( /\r?\n|\r/g, '' );
			content = content.replace( /(<p[^>]+?>|<p>|<\/p>)/g, '' );
			content = content.replace( /(<br[^>]+?>|<br>|<\/br>)/g, '' );
			content = content.replace( /\[fusion_text\]\[\/fusion_text\]/g, '' );
			return content.trim();
		}
	} );
}( jQuery ) );
;/* global FusionEvents, FusionApp, fusionBuilderText */

var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	FusionPageBuilder.DynamicValues = Backbone.Model.extend( {
		defaults: {
			values: {},
			options: {},
			orderedParams: false
		},

		getOrderedParams: function() {
			var params  = this.get( 'orderedParams' ),
				options = this.getOptions();

			if ( ! params ) {
				params = {};
				_.each( options, function( object, id ) {
					var group,
						groupText;

					if ( 'object' !== typeof object ) {
						return;
					}

					group     = object.group;
					groupText = group;

					if ( 'string' !== typeof object.group ) {
						group     = 'other';
						groupText = fusionBuilderText.other;
					}

					group = group.replace( /\s+/g, '_' ).toLowerCase();

					if ( 'object' !== typeof params[ group ] ) {
						params[ group ] = {
							label: '',
							params: {}
						};
					}

					params[ group ].label        = groupText;
					params[ group ].params[ id ] = object;
				} );
			}
			return params;
		},

		addData: function( data, options ) {
			this.set( 'values', data );
			this.set( 'options', options );
		},

		getOptions: function() {
			var options = this.get( 'options' );

			return jQuery.extend( true, {}, options );
		},

		getOption: function( param ) {
			var options = this.getOptions();

			return 'undefined' !== typeof options[ param ] ? options[ param ] : false;
		},

		getAll: function() {
			var values = this.get( 'values' );

			return jQuery.extend( true, {}, values );
		},

		getValue: function( args ) {
			var values   = this.getAll(),
				id       = args.data,
				postId   = FusionApp.getDynamicPost( 'post_id' ),
				idValues = false,
				match    = false;

			if ( 'undefined' !== typeof values[ postId ] ) {
				idValues = 'object' === typeof values[ postId ][ id ] ? values[ postId ][ id ] : false;
			}

			// No initial match, fetch it.
			if ( ! idValues ) {
				return this.fetchValue( id, args );
			}

			// Check each value object with same ID.
			match = this.findMatch( idValues, args );

			// We found a matching object, then return its value.
			if ( match ) {
				return match.value;
			}

			// No match, fetch.
			return this.fetchValue( id, args );
		},

		findMatch: function( idValues, args, idWanted ) {
			var match = false;

			idWanted = 'undefined' === typeof idWanted ? false : idWanted;

			_.each( idValues, function( idValue, idCount ) {
				var argsMatch = true;

				// Already found a match, just return early.
				if ( match ) {
					return true;
				}

				// Value object has no args, then set match and return.
				if ( 'undefined' === typeof idValue.args ) {
					match = idWanted ? idCount : idValue;
					return true;
				}

				// We do have args, check that each value matches.
				if ( 'object' === typeof idValue.args ) {
					_.each( idValue.args, function( argValue, argId ) {
						if ( 'undefined' === typeof args[ argId ] || 'before' === argId || 'after' === argId || 'fallback' === argId ) {
							return true;
						}
						if ( args[ argId ] !== argValue ) {
							argsMatch = false;
						}
					} );

					if ( argsMatch ) {
						match = idWanted ? idCount : idValue;
					}
				}
			} );
			return match;
		},

		fetchValue: function( id, args ) {
			var options          = this.getOptions(),
				param            = 'object' === typeof options && 'object' === typeof options[ id ] ? options[ id ] : false,
				callback         = param && 'undefined' !== typeof param.callback ? param.callback : false,
				callbackFunction = callback && 'string' === typeof callback[ 'function' ] ? callback[ 'function' ] : false,
				callbackExists   = callbackFunction && 'function' === typeof FusionApp.callback[ callbackFunction ] ? true : false,
				callbackAjax     = callbackExists && 'undefined' !== typeof callback.ajax ? callback.ajax : false,
				value;

			// If no callback found, use default ajax one.
			if ( ! callbackExists ) {
				callbackFunction = 'defaultDynamicCallback';
				callbackAjax     = true;
			}
			if ( ! param ) {
				this.setValue( args, false );
				return false;
			}

			// Return default (dummy) value if template post is set as target post.
			if ( true === FusionApp.data.is_singular && 'fusion_tb_section' === FusionApp.data.postDetails.post_type && -99 === FusionApp.getDynamicPost( 'post_id' ) && 'undefined' !== typeof param[ 'default' ] ) {
				return param[ 'default' ];
			}

			// If ajax callback should be run when template is edited.
			if ( true === FusionApp.data.is_singular && 'fusion_tb_section' === FusionApp.data.postDetails.post_type && 'undefined' !== typeof param.ajax_on_template && true === param.ajax_on_template ) {
				return FusionApp.callback.defaultDynamicCallback( args );
			}

			if ( callbackAjax ) {
				return FusionApp.callback[ callbackFunction ]( args );
			}

			value = FusionApp.callback[ callbackFunction ]( args );
			this.setValue( args, value );
			return value;
		},

		setValue: function( args, value ) {
			var values   = this.getAll(),
				id       = args.data,
				postId   = FusionApp.getDynamicPost( 'post_id' ),
				existing = {},
				matchId  = false,
				newData  = {
					args: jQuery.extend( true, {}, args ),
					value: value
				};

			if ( 'object' !== typeof values[ postId ] ) {
				values[ postId ] = [];
			}

			existing = jQuery.extend( true, {}, values[ postId ][ id ] );

			if ( 'object' !== typeof values[ postId ][ id ] ) {
				values[ postId ][ id ] = [];
			} else if ( 'function' !== typeof values[ postId ][ id ].push ) {
				values[ postId ][ id ] = [ existing[ 0 ] ];
			}

			matchId = this.findMatch( values[ postId ][ id ], args, true );

			if ( ! matchId ) {
				values[ postId ][ id ].push( newData );
			} else {
				values[ postId ][ id ][ matchId ] = newData;
			}

			this.set( 'values', values );

			// ReRender the element.  Perhaps via event using id.
			FusionEvents.trigger( 'fusion-dynamic-data-value', id );
		},

		removeValue: function( id ) {
			var values = this.getAll(),
				postId   = FusionApp.getDynamicPost( 'post_id' );

			if ( 'object' === typeof values[ postId ][ id ] ) {
				delete values[ postId ][ id ];
			}
			this.set( 'values', values );
		}
	} );
}( jQuery ) );
;/* global FusionEvents, FusionPageBuilderApp, fusionAllElements, fusionBuilderText */

var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	FusionPageBuilder.DynamicParams = Backbone.Model.extend( {
		defaults: {
			params: {},
			elementView: false,
			listeners: []
		},

		initialize: function() {
			this._historyPush = _.debounce( _.bind( this.historyPush, this ), 300 );
		},

		setData: function( data ) {
			if ( 'object' === typeof data ) {
				this.set( 'params', data );
				this.setListeners();
			}
		},

		getAll: function() {
			var params = this.get( 'params' );

			return jQuery.extend( true, {}, params );
		},

		setListeners: function() {
			var params = this.getAll(),
				self   = this;

			_.each( params, function( param ) {
				var option = FusionPageBuilderApp.dynamicValues.getOption( param.data );

				if ( option && 'object' === typeof option.listeners ) {
					_.each( option.listeners, function( listenerData, listenerId ) {
						self.setListener( listenerId, listenerData, param );
					} );
				}
			} );
		},

		setListener: function( id, data, args ) {
			var location  = 'undefined' !== typeof data.location ? data.location : false,
				self      = this,
				cid       = this.cid,
				listeners = this.get( 'listeners' );

			if ( ! location ) {
				return;
			}

			switch ( location ) {

			case 'postDetails':
				FusionEvents.on( 'fusion-' + id + '-changed', function() {
					FusionPageBuilderApp.dynamicValues.removeValue( args.data );

					self.getValueAndUpdate( args );
				}, cid );
				listeners.push( 'fusion-' + id + '-changed' );
				self.set( 'listeners', listeners );
				break;
			case 'postMeta':
				FusionEvents.on( 'fusion-po-' + id + '-changed', function() {
					FusionPageBuilderApp.dynamicValues.removeValue( args.data );

					self.getValueAndUpdate( args );
				}, cid );
				listeners.push( 'fusion-po-' + id + '-changed' );
				self.set( 'listeners', listeners );
				break;
			}
		},

		hasDynamicParam: function( param ) {
			var params = this.getAll();

			if ( 'undefined' !== typeof params[ param ] ) {
				return true;
			}
			return false;
		},

		getParamValue: function( data ) {
			var value        = FusionPageBuilderApp.dynamicValues.getValue( data ),
				beforeString = 'string' === typeof data.before ? data.before : '',
				afterString  = 'string' === typeof data.after ? data.after : '',
				fallback     = 'undefined' !== typeof data.fallback ? data.fallback : false,
				hasValue     = 'undefined' !== typeof value && false !== value && '' !== value,
				elementView  = this.get( 'elementView' );

			if ( ! hasValue && fallback ) {
				return fallback;
			}
			if ( ! hasValue ) {
				return undefined;
			}

			if ( 'object' === typeof value && 'function' === typeof value.then ) {
				value.then( function() {
					elementView.reRender();
				} );
				return false;
			}
			return beforeString + value + afterString;
		},

		addParam: function( param, data ) {
			var self    = this,
				params  = this.getAll(),
				options = FusionPageBuilderApp.dynamicValues.getOptions(),
				option  = false;

			if ( 'object' !== typeof data ) {
				data = {
					data: data
				};
			}

			// // Set default values.
			_.each( options[ data.data ].fields, function( field, key ) {
				if ( 'undefined' === typeof data[ key ] ) {
					if ( 'undefined' !== typeof field[ 'default' ] ) {
						data[ key ] = field[ 'default' ];
					} else if ( 'undefined' !== typeof field.value ) {
						data[ key ] = field.value;
					}
				}
			} );

			params[ param ] = data;

			option = FusionPageBuilderApp.dynamicValues.getOption( data.data );
			if ( option && 'object' === typeof option.listeners ) {
				_.each( option.listeners, function( listenerData, listenerId ) {
					self.setListener( listenerId, listenerData, param );
				} );
			}

			this.set( 'params', params );

			this.saveData();

			FusionEvents.trigger( 'fusion-dynamic-data-added', param );

			this.getValueAndUpdate( params[ param ] );
		},

		updateParam: function( param, subParam, value ) {
			var params      = this.getAll();

			if ( 'object' === typeof params[ param ] ) {
				params[ param ][ subParam ] = value;
				this.set( 'params', params );

				FusionEvents.trigger( 'fusion-dynamic-data-updated', param );

				this.saveData();

				this.getValueAndUpdate( params[ param ] );
			}
		},

		getValueAndUpdate: function( args ) {
			var elementView = this.get( 'elementView' ),
				valueReturn = FusionPageBuilderApp.dynamicValues.getValue( args, elementView );

			if ( 'object' === typeof valueReturn && 'function' === typeof valueReturn.then ) {
				elementView.addLoadingOverlay();
				valueReturn.then( function() {
					elementView.reRender();
				} );
			} else {
				elementView.reRender();
			}
		},

		updateListeners: function() {
			var cid = this.cid;

			_.each( this.get( 'listeners' ), function( listener ) {
				FusionEvents.off( listener, null, cid );
			} );
			this.setListeners();
		},

		removeParam: function( param ) {
			var params      = this.getAll(),
				elementView = this.get( 'elementView' );

			delete params[ param ];

			this.set( 'params', params );

			this.updateListeners();

			this.saveData();

			elementView.reRender();

			FusionEvents.trigger( 'fusion-dynamic-data-removed', param );
		},

		historyPush: function() {
			var elementView   = this.get( 'elementView' ),
				elementMap    = fusionAllElements[ elementView.model.get( 'element_type' ) ];

			// TODO: refactor history.
			FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.edited + ' ' + elementMap.name + ' - ' + fusionBuilderText.dynamic_data );
		},

		saveData: function() {
			var elementView   = this.get( 'elementView' ),
				elementParams = elementView.model.get( 'params' ),
				originalValue = elementParams.dynamic_params;

			elementParams.dynamic_params = FusionPageBuilderApp.base64Encode( JSON.stringify( this.getAll() ) );

			elementView.model.set( 'params', elementParams );

			// Make sure that parent is updated, usually done in base view changeParam.
			if ( 'function' === typeof elementView.forceUpdateParent ) {
				elementView.forceUpdateParent();
			}

			if ( originalValue !== elementParams.dynamic_params ) {
				this._historyPush();
			}
		}
	} );
}( jQuery ) );
;/* global FusionApp, FusionEvents */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	FusionPageBuilder.FormStyles = Backbone.Model.extend( {

		initialize: function() {
			this.baseSelector = '.fusion-form';
			this.dynamic_css  = {};
			this.formData     = FusionApp.data.postMeta._fusion;

			this.buildStyles();

			this.listenTo( FusionEvents, 'fusion-form-styles', this.buildStyles );
			this.listenTo( FusionEvents, 'fusion-builder-loaded', this.buildStyles );
		},

		addCssProperty: function ( selectors, property, value, important ) {

			if ( 'object' === typeof selectors ) {
				selectors = Object.values( selectors );
			}

			if ( 'object' === typeof selectors ) {
				selectors = selectors.join( ',' );
			}

			if ( 'object' !== typeof this.dynamic_css[ selectors ] ) {
				this.dynamic_css[ selectors ] = {};
			}

			if ( 'undefined' !== typeof important && important ) {
				value += ' !important';
			}
			if ( 'undefined' === typeof this.dynamic_css[ selectors ][ property ] || ( 'undefined' !== typeof important && important ) || ! this.dynamic_css[ selectors ][ property ].includes( 'important' ) ) {
				this.dynamic_css[ selectors ][ property ] = value;
			}
		},

		isDefault: function( param, subset ) {
			if ( 'string' === typeof subset ) {
				return 'undefined' === typeof this.formData[ param ] || 'undefined' === typeof this.formData[ param ][ subset ] || '' === this.formData[ param ][ subset ];
			}
			return 'undefined' === typeof this.formData[ param ] || '' === this.formData[ param ];
		},

		parseCSS: function () {
			var css = '';

			if ( 'object' !== typeof this.dynamic_css ) {
				return '';
			}

			_.each( this.dynamic_css, function ( properties, selector ) {
				if ( 'object' === typeof properties ) {
					css += selector + '{';
					_.each( properties, function ( value, property ) {
						css += property + ':' + value + ';';
					} );
					css += '}';
				}
			} );

			return css;
		},

		buildStyles: function() {
			var selectors,
				css              = '',
				inputs           = [ this.baseSelector + ' input:not([type="submit"])', this.baseSelector + ' select', this.baseSelector + ' textarea' ],
				placeholderColor = '',
				hoverColor       = '',
				borderTop,
				borderBottom;

			this.dynamic_css  = {};

			if ( 'fusion_form' !== FusionApp.getPost( 'post_type' ) ) {
				return;
			}

			// Help tooltips.
			this.addCssProperty( this.baseSelector + ' .fusion-form-tooltip .fusion-form-tooltip-content', 'color',  this.formData['tooltip_text_color'], true);
			this.addCssProperty( this.baseSelector + ' .fusion-form-tooltip .fusion-form-tooltip-content', 'background-color',  this.formData['tooltip_background_color'], true);
			this.addCssProperty( this.baseSelector + ' .fusion-form-tooltip .fusion-form-tooltip-content', 'border-color',  this.formData['tooltip_background_color'], true);
			// Field margin.
			if (!this.isDefault('field_margin', 'top')) {
			  this.addCssProperty( this.baseSelector + ' .fusion-form-field', 'margin-top',  this.formData['field_margin']['top']);
			}

			if (!this.isDefault('field_margin', 'bottom')) {
			  this.addCssProperty( this.baseSelector + ' .fusion-form-field', 'margin-bottom',  this.formData['field_margin']['bottom']);
			}

			if (!this.isDefault('form_input_height')) {
			  height_inputs = [ this.baseSelector + ' input:not([type="submit"])', this.baseSelector + ' select' ];
			  this.addCssProperty(height_inputs, 'height',  this.formData['form_input_height']);
			  this.addCssProperty( this.baseSelector + ' .fusion-form-input-with-icon > i', 'line-height',  this.formData['form_input_height']);
			}

			if (!this.isDefault('form_bg_color')) {
			  this.addCssProperty(inputs, 'background-color',  this.formData['form_bg_color']);
			}

			if ( !this.isDefault( 'form_font_size' ) ) {
				this.addCssProperty( inputs, 'font-size',  this.formData.form_font_size );
				this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-input-with-icon>i', 'font-size',  this.formData.form_font_size );
			}

			if (!this.isDefault('form_text_color')) {
			 placeholders_color = jQuery.Color( this.formData.form_text_color ).alpha( 0.5 ).toRgbaString();
			  // Regular browser placeholders.
			  selectors = [ this.baseSelector + ' input::placeholder', this.baseSelector + ' textarea::placeholder' ];
			  this.addCssProperty(selectors, 'color', placeholders_color);
			  // Select field.
			  this.addCssProperty( this.baseSelector + ' select:invalid', 'color', placeholders_color, true);
			  this.addCssProperty( this.baseSelector + ' option', 'color',  this.formData['form_text_color']);
			  // Upload field.
			  this.addCssProperty( this.baseSelector + ' input.fusion-form-upload-field::placeholder', 'color',  this.formData['form_text_color']);
			  this.addCssProperty( this.baseSelector + ' input.fusion-form-upload-field:-ms-input-placeholder', 'color',  this.formData['form_text_color']);
			  // IE selectors needs to be separate and after.
			  selectors = [ this.baseSelector + ' input:-ms-input-placeholder', this.baseSelector + ' textarea:-ms-input-placeholder' ];
			  this.addCssProperty(selectors, 'color', placeholders_color);
			  // Icon color.
			  this.addCssProperty( this.baseSelector + ' .fusion-form-input-with-icon > i', 'color',  this.formData['form_text_color'], true);
			  // Input text color.
			  this.addCssProperty(inputs, 'color',  this.formData['form_text_color']);
			}

			if ( !this.isDefault( 'form_label_color' ) ) {
				this.addCssProperty( this.baseSelector + ' label', 'color',  this.formData.form_label_color );
			}

			if (!this.isDefault('form_border_width', 'top')) {
			  this.addCssProperty(inputs, 'border-top-width', _.fusionGetValueWithUnit( this.formData['form_border_width']['top'], 'px'));
			  this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-image-select label', 'border-top-width', _.fusionGetValueWithUnit( this.formData['form_border_width']['top'], 'px'));
			}

			if (!this.isDefault('form_border_width', 'bottom')) {
			  this.addCssProperty(inputs, 'border-bottom-width', _.fusionGetValueWithUnit( this.formData['form_border_width']['bottom'], 'px'));
			  this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-image-select label', 'border-bottom-width', _.fusionGetValueWithUnit( this.formData['form_border_width']['bottom'], 'px'));
			}

			if (!this.isDefault('form_border_width', 'right')) {
			  this.addCssProperty(inputs, 'border-right-width', _.fusionGetValueWithUnit( this.formData['form_border_width']['right'], 'px'));
			  this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-image-select label', 'border-right-width', _.fusionGetValueWithUnit( this.formData['form_border_width']['right'], 'px'));
			  if (jQuery( 'body' ).hasClass( 'rtl' )) {
			    this.addCssProperty( this.baseSelector + ' .fusion-form-field .fusion-form-input-with-icon > i', 'right', 'calc( 1em + ' + _.fusionGetValueWithUnit( this.formData['form_border_width']['right'], 'px') + ')', true);
			  }
			  else {
			    this.addCssProperty( this.baseSelector + ' .fusion-select-wrapper .select-arrow', 'right', 'calc( 1em + ' + _.fusionGetValueWithUnit( this.formData['form_border_width']['right'], 'px') + ')', true);
			  }

			}

			if (!this.isDefault('form_border_width', 'left')) {
			  this.addCssProperty(inputs, 'border-left-width', _.fusionGetValueWithUnit( this.formData['form_border_width']['left'], 'px'));
			  this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-image-select label', 'border-left-width', _.fusionGetValueWithUnit( this.formData['form_border_width']['left'], 'px'));
			  if (jQuery( 'body' ).hasClass( 'rtl' )) {
			    this.addCssProperty( this.baseSelector + ' .fusion-select-wrapper .select-arrow', 'left', 'calc( 1em + ' + _.fusionGetValueWithUnit( this.formData['form_border_width']['left'], 'px') + ')', true);
			  }
			  else {
			    this.addCssProperty( this.baseSelector + ' .fusion-form-field .fusion-form-input-with-icon > i', 'left', 'calc( 1em + ' + _.fusionGetValueWithUnit( this.formData['form_border_width']['left'], 'px') + ')', true);
			  }

			}

			if (!this.isDefault('form_border_width', 'bottom') || !this.isDefault('form_border_width', 'top')) {
				borderTop    = this.isDefault('form_border_width', 'top') ? 'var(--form_border_width-top)' : _.fusionGetValueWithUnit( this.formData['form_border_width']['top'], 'px');
				borderBottom = this.isDefault('form_border_width', 'bottom') ? 'var(--form_border_width-bottom)' : _.fusionGetValueWithUnit( this.formData['form_border_width']['bottom'], 'px');
				this.addCssProperty( this.baseSelector + ' .fusion-form-field:not( .fusion-form-upload-field ) .fusion-form-input-with-icon > i', 'top', 'calc( 50% + (' + borderTop + ' - ' + borderBottom + ' ) / 2 )', true );
			}

			if (!this.isDefault('form_border_color')) {
			  selectors = [ this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-checkbox label:before', this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-radio label:before', this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-image-select label' ];
			  this.addCssProperty(inputs, 'border-color',  this.formData['form_border_color']);
			  this.addCssProperty(selectors, 'border-color',  this.formData['form_border_color']);
			  selectors = [ this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-rating-area .fusion-form-rating-icon' ];
			  this.addCssProperty(selectors, 'color',  this.formData['form_border_color']);

				// Range input type.
			  this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field input[type=range]::-webkit-slider-runnable-track', 'background',  this.formData['form_border_color']);
			  this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field input[type=range]::-moz-range-track', 'background',  this.formData['form_border_color']);
			}

			if (!this.isDefault('form_focus_border_color')) {
				hoverColor = jQuery.Color( this.formData.form_focus_border_color ).alpha( 0.5 ).toRgbaString();

				selectors = [
					this.baseSelector + ' input:not([type="submit"]):focus',
				this.baseSelector + ' select:focus',
					this.baseSelector + ' textarea:focus',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field.focused.fusion-form-upload-field .fusion-form-upload-field',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-radio input:checked + label:before',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-radio input:hover + label:before',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-checkbox input:checked + label:before',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-checkbox input:hover + label:before',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-image-select .fusion-form-input:checked + label',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-image-select .fusion-form-input:hover + label',
				];

			  this.addCssProperty(selectors, 'border-color',  this.formData['form_focus_border_color']);

				selectors = [
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-radio input:hover:not(:checked) + label:before',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-checkbox input:hover:not(:checked) + label:before',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-image-select .fusion-form-input:hover:not(:checked) + label',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-upload-field-container:hover .fusion-form-upload-field',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-range-field-container .fusion-form-range-value:hover:not(:focus)',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-input:hover:not(:focus)'
				];

				this.addCssProperty(selectors, 'border-color',  hoverColor);

				selectors = [
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-rating-area .fusion-form-input:checked ~ label i',
				];

				this.addCssProperty(selectors, 'color',  this.formData['form_focus_border_color']);

				selectors = [
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-rating-area .fusion-form-input:checked:hover ~ label i',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-rating-area .fusion-form-rating-icon:hover i',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-rating-area .fusion-form-rating-icon:hover ~ label i',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-rating-area .fusion-form-input:hover ~ label i',
				];

				this.addCssProperty(selectors, 'color',  hoverColor);

				selectors = [
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-checkbox input:checked + label:after',
					this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-radio input:checked + label:after',
				];

				this.addCssProperty(selectors, 'background',  this.formData['form_focus_border_color']);

				// Range input type.
			  this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field input[type=range]::-ms-track', 'background',  this.formData['form_focus_border_color']);
				this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field input[type=range]::-webkit-slider-thumb', 'background',  this.formData['form_focus_border_color']);
				this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field input[type=range]::-moz-range-thumb', 'background',  this.formData['form_focus_border_color']);
				this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field input[type=range]::-ms-thumb', 'background',  this.formData['form_focus_border_color']);
			}

			if (!this.isDefault('form_border_radius')) {
			  this.addCssProperty(inputs, 'border-radius', _.fusionGetValueWithUnit( this.formData['form_border_radius'], 'px'));
			  this.addCssProperty( this.baseSelector + '.fusion-form-form-wrapper .fusion-form-field .fusion-form-image-select label', 'border-radius', _.fusionGetValueWithUnit( this.formData['form_border_radius'], 'px'));
			}

			css = this.parseCSS();

			if ( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'head' ).find( '#fusion-form-style-block' ).length ) {
				 jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'head' ).find( '#fusion-form-style-block' ).html( css );
				 return;
			}

			jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'head' ).append( '<style id="fusion-form-style-block">' + css + '</style>' );
		}
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	// Element collection
	FusionPageBuilder.Collection = Backbone.Collection.extend( {
		model: FusionPageBuilder.Element
	} );

	window.FusionPageBuilderElements = new FusionPageBuilder.Collection(); // jshint ignore: line

}( jQuery ) );
;/* global FusionPageBuilderElements, fusionBuilderText, fusionGlobalManager, FusionApp, FusionPageBuilderViewManager, fusionAllElements, FusionPageBuilderApp, FusionEvents */
/* eslint no-empty-function: 0 */
/* eslint no-shadow: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Element View
		FusionPageBuilder.BaseView = window.wp.Backbone.View.extend( {

			modalDialogMoreView: null,

			events: {
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
			},

			/**
			 * Before initial render.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			beforeRender: function() {
			},

			/**
			 * Filters render markup.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			filterRender: function( $markup ) {
				return $markup;
			},

			/**
			 * Runs during render() call.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			onRender: function() {
			},

			/**
				* Runs during initialize() call.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			onInit: function() {
			},

			/**
			 * Runs just before view is removed.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			beforeRemove: function() {
			},

			/**
			 * Runs just after render on cancel.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			onCancel: function() {
			},

			/**
			 * Triggers a refresh.
			 *
			 * @since 2.0.0
			 * @return void
			 */
			refreshJs: function() {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-element-render-' + this.model.attributes.element_type, this.model.attributes.cid );
			},

			/**
			 * Triggers responsive typography to recalculate.
			 *
			 * @since 2.0.0
			 * @return void
			 */
			updateResponsiveTypography: function() {
				document.querySelector( '#fb-preview' ).contentWindow.document.body.dispatchEvent( new Event( 'fusion-force-typography-update', { 'bubbles': true, 'cancelable': true } ) );
			},

			/**
			 * Re-Renders the view.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the rerender.
			 * @return {void}
			 */
			reRender: function( event ) {
				if ( event && 'object' === typeof event ) {
					event.preventDefault();
				}

				this.patchView( event );

				if ( this.model.get( 'inline_editor' ) && ! this.activeInlineEditing ) {
					FusionPageBuilderApp.inlineEditorHelpers.liveEditorEvent( this );
					this.activeInlineEditing = false;
				}
			},

			patchView: function() {
				var self            = this,
					$oldContent     = '',
					$newContent     = '',
					MultiGlobalArgs = {},
					diff,
					heightBeforePatch;

				if ( 'generated_element' === this.model.get( 'type' ) ) {
					return;
				}

				heightBeforePatch = this.$el.outerHeight();
				this.beforePatch();
				FusionPageBuilderApp.disableDocumentWrite();

				this.renderWireframePreview();

				$oldContent = this.getElementContent();
				$newContent = $oldContent.clone();

				$newContent.html( self.getTemplate() );

				// Find the difference
				diff = FusionPageBuilderApp._diffdom.diff( $oldContent[ 0 ], $newContent[ 0 ] );

				// Columns. Skip resizable patching.
				if ( 'function' === typeof this.patcherFilter ) {
					diff = this.patcherFilter( diff );
				}

				// Apply the difference.
				FusionPageBuilderApp._diffdom.apply( $oldContent[ 0 ], diff );

				if ( 'fusion_builder_column' !== this.model.get( 'element_type' ) ) {

					// Handle multiple global elements.
					MultiGlobalArgs = {
						currentModel: this.model,
						handleType: 'changeView',
						difference: diff
					};
					fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );
				}

				$oldContent.removeClass( 'fusion-loader' );

				FusionPageBuilderApp.enableDocumentWrite();
				this.afterPatch();

				// So equalHeights columns are updated.
				if ( heightBeforePatch !== this.$el.outerHeight() && 'function' === typeof this._triggerColumn ) {
					this._triggerColumn();
				}
			},

			/**
			 * Filter out DOM before patching.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			patcherFilter: function( diffs ) {
				var filteredDiffs = [],
					ignoreList    = [
						'aria-multiline',
						'contenteditable',
						'data-inline-fontsize',
						'data-medium-editor-index',
						'data-medium-editor-element',
						'data-medium-focused',
						'data-placeholder',
						'medium-editor-index',
						'role',
						'spellcheck'
					],
					skipReInit = false;

				if ( this.activeInlineEditing ) {
					_.each( diffs, function( diff ) {
						if ( 'removeAttribute' === diff.action && -1 !== jQuery.inArray( diff.name, ignoreList ) ) {
							skipReInit = true;
							return;
						} else if ( 'modifyAttribute' === diff.action && -1 !== diff.oldValue.indexOf( 'medium-editor-element' ) && -1 === diff.oldValue.indexOf( 'medium-editor-element' ) ) {
							diff.newValue = diff.newValue + ' medium-editor-element';
							filteredDiffs.push( diff );
							skipReInit = true;
							return;
						}

						filteredDiffs.push( diff );
					} );
					diffs = filteredDiffs;

					// If we are not just removing/modifying attributes then inline needs recreated.
					this.activeInlineEditing = skipReInit;
					this.autoSelectEditor    = ! skipReInit;
				}
				return diffs;
			},

			/**
			 * Runs before view DOM is patched.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			beforePatch: function() {
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			afterPatch: function() {

				// This will trigger a JS event on the preview frame.
				this._refreshJs();
			},

			/**
			 * Runs after render to open any newly added inline element settings.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			renderInlineSettings: function() {
				var newlyAdded;

				if ( 'undefined' === typeof FusionPageBuilderApp.inlineEditors || ! FusionPageBuilderApp.inlineEditors.shortcodeAdded ) {
					return;
				}

				newlyAdded = this.model.inlineCollection.find( function( model ) {
					return 'true' == model.get( 'params' ).open_settings; // jshint ignore: line
				} );

				if ( 'undefined' !== typeof newlyAdded ) {
					newlyAdded.parentView = this;
					newlyAdded.$target    = this.$el.find( '.fusion-disable-editing[data-id="' + newlyAdded.get( 'cid' ) + '"]' );
					delete newlyAdded.attributes.params.open_settings;

					if ( 'undefined' !== typeof FusionApp && 'off' !== FusionApp.preferencesData.open_settings ) {
						newlyAdded.set( 'added',  true );
						FusionPageBuilderApp.inlineEditorHelpers.getInlineElementSettings( newlyAdded );
					}
				}
			},

			/**
			 * Get the template.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getTemplate: function() {
				var atts = this.getTemplateAtts();

				if ( 'undefined' !== typeof this.elementTemplate ) {
					return this.elementTemplate( atts );
				}
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0.0
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				return atts;
			},

			/**
			 * Get dynamic values.
			 *
			 * @since 2.0.0
			 * @return {Object}
			 */
			getDynamicAtts: function( atts ) {
				var self = this;

				if ( 'undefined' !== typeof this.dynamicParams && this.dynamicParams && ! _.isEmpty( this.dynamicParams.getAll() ) ) {
					_.each( this.dynamicParams.getAll(), function( data, id ) {
						var value = self.dynamicParams.getParamValue( data );

						if ( 'undefined' !== typeof value && false !== value ) {
							atts.values[ id ] = value;
						}
					} );
				}
				return atts;
			},

			/**
			 * Gets element DOM for patching.
			 *
			 * @since 2.1
			 * @return {Object}
			 */
			getValues: function() {
				var elementType = this.model.get( 'element_type' ),
					element     = fusionAllElements[ elementType ];

				return this.getDynamicAtts( jQuery.extend( true, {}, element.defaults, _.fusionCleanParameters( this.model.get( 'params' ) ) ) );
			},

			/**
			 * Gets element DOM for patching.
			 *
			 * @since 2.0.0
			 * @return {Object}
			 */
			getElementContent: function() {
				var self = this;

				switch ( this.model.get( 'type' ) ) {

				case 'fusion_builder_column':
				case 'fusion_builder_container':
				case 'fusion_builder_column_inner':
					return self.$el;
				case 'element':
					if ( 'multi_element_child' !== self.model.get( 'multi' ) ) {
						return self.$el.find( '.fusion-builder-element-content' );
					}
					return self.$el.find( '.fusion-builder-child-element-content' );
				}
			},

			/**
			 * Settings handler.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			settings: function( event ) {

				var self = this,
					viewSettings = {
						model: this.model,
						collection: this.collection
					},
					customSettingsViewName,
					modalView,
					parentView,
					generated         = 'generated_element' === this.model.get( 'type' ),
					childElementClass = '',
					dialogTitle       = '',
					resizePopupClass  = localStorage.getItem( 'resizePopupClass' );

				if ( event ) {
					event.preventDefault();
				}

				this.onSettingsOpen();

				customSettingsViewName = fusionAllElements[ this.model.get( 'element_type' ) ].custom_settings_view_name;

				// Check for generated element child.
				if ( 'multi_element_child' === this.model.get( 'multi' ) ) {
					parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
					if ( parentView && 'generated_element' === parentView.model.get( 'type' ) ) {
						generated = true;
						viewSettings.model.set( 'type', 'generated_element' );
						viewSettings.model.set( 'display', 'dialog' );
					}

				}

				if ( 'undefined' !== typeof customSettingsViewName && '' !== customSettingsViewName ) {
					modalView = new FusionPageBuilder[ customSettingsViewName ]( viewSettings );
				} else {
					modalView = new FusionPageBuilder.ElementSettingsView( viewSettings );
				}

				// Activate column spacing.
				if ( 'fusion_builder_column' === this.model.get( 'element_type' ) || 'fusion_builder_column_inner' === this.model.get( 'element_type' ) ) {
					this.columnSpacing();
					this.paddingDrag();
					this.marginDrag();

					// Hides column size popup.
					this.$el.removeClass( 'active' );
					this.$el.closest( '.fusion-builder-container' ).removeClass( 'fusion-column-sizer-active' );
				}

				// Activate resize handles.
				if ( 'fusion_builder_container' === this.model.get( 'element_type' ) ) {
					this.paddingDrag();
					this.marginDrag();
				}

				if ( 'fusion_builder_container' === this.model.get( 'element_type' ) || 'fusion_builder_column' === this.model.get( 'element_type' ) || 'fusion_builder_column_inner' === this.model.get( 'element_type' ) ) {
					this.$el.addClass( 'fusion-builder-element-edited' );
				}

				childElementClass = 'undefined' !== this.model.get( 'multi' ) && 'multi_element_child' === this.model.get( 'multi' ) ? ' fusion-builder-child-element' : '';
				dialogTitle       = this.getDialogTitle();

				// No need to render if it already is.
				if ( ! FusionPageBuilderApp.SettingsHelpers.shouldRenderSettings( modalView ) ) {
					return;
				}

				// If we want dialog.
				if ( 'dialog' === FusionApp.preferencesData.editing_mode || generated ) {
					jQuery( modalView.render().el ).dialog( {
						title: dialogTitle,
						width: FusionApp.dialog.dialogData.width,
						height: FusionApp.dialog.dialogData.height,
						position: FusionApp.dialog.dialogData.position,
						dialogClass: 'fusion-builder-dialog fusion-builder-settings-dialog' + childElementClass,
						minWidth: 327,
						type: this.model.get( 'type' ),

						dragStop: function( event, ui ) {
							FusionApp.dialog.saveDialogPosition( ui.offset );
						},

						resizeStart: function() {
							FusionApp.dialog.addResizingClasses();
						},

						resizeStop: function( event, ui ) {
							var $dialog = jQuery( event.target ).closest( '.ui-dialog' ),
								width   = $dialog.find( '.fusion-tabs-menu > li' ).length;

							if ( width ) {
								width = 100 * width;
							}
							if ( width && ui.size.width > width ) {
								$dialog.find( '.fusion-tabs-menu' ).addClass( 'show-text' );
							} else {
								$dialog.find( '.fusion-tabs-menu' ).removeClass( 'show-text' );
							}

							FusionApp.dialog.saveDialogSize( ui.size );

							if ( 450 > ui.size.width && ! $dialog.hasClass( 'fusion-builder-dialog-narrow' ) ) {
								$dialog.addClass( 'fusion-builder-dialog-narrow' );
							} else if ( 450 <= ui.size.width && $dialog.hasClass( 'fusion-builder-dialog-narrow' ) ) {
								$dialog.removeClass( 'fusion-builder-dialog-narrow' );
							}

							FusionApp.dialog.removeResizingClasses();
						},

						open: function( event ) {
							var $dialogContent = jQuery( event.target ),
								$dialog        = $dialogContent.closest( '.ui-dialog' ),
								width;

							// On start can sometimes be laggy/late.
							FusionApp.dialog.addResizingHoverEvent();

							if ( modalView.$el.find( '.has-group-options' ).length ) {
								$dialog.addClass( 'fusion-builder-group-options' );
							}

							$dialogContent.find( '.fusion-builder-section-name' ).blur();

							jQuery( '.ui-dialog' ).not( $dialog ).hide();

							jQuery( '.fusion-back-menu-item' ).on( 'click', function() {
								modalView.openParent();

								self.onSettingsClose();
							} );

							self.modalDialogMoreView = new FusionPageBuilder.modalDialogMore( { model: self.model } );

							// We need to render context submenu on open.
							FusionPageBuilderApp.SettingsHelpers.renderDialogMoreOptions( modalView );

							if ( null !== resizePopupClass ) {
								jQuery( 'body' ).addClass( resizePopupClass );
								self.modalDialogMoreView.resizePopup( resizePopupClass );
							}

							jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).addClass( 'fusion-dialog-ui-active' );

							if ( 450 > $dialog.width() && ! $dialog.hasClass( 'fusion-builder-dialog-narrow' ) ) {
								$dialog.addClass( 'fusion-builder-dialog-narrow' );
							} else if ( 450 <= $dialog.width() && $dialog.hasClass( 'fusion-builder-dialog-narrow' ) ) {
								$dialog.removeClass( 'fusion-builder-dialog-narrow' );
							}

							// Check if dialog is positioned outside of viewport and reposition it if needed.
							if ( FusionApp.dialog.maybeRepositionDialog( $dialog ) ) {
								FusionApp.dialog.saveDialogPosition( $dialog.offset() );
							}

							width = $dialog.find( '.fusion-tabs-menu > li' ).length;
							if ( width ) {
								width = 100 * width;
							}
							if ( width && $dialog.width() > width ) {
								$dialog.find( '.fusion-tabs-menu' ).addClass( 'show-text' );
							}

						},

						dragStart: function( event ) {

							// Used to close any open drop-downs in TinyMce.
							jQuery( event.target ).trigger( 'click' );
						},

						beforeClose: function( event ) {

							FusionApp.dialogCloseResets( modalView );
							self.modalDialogMoreView = null;
							modalView.saveSettings( event );

							FusionEvents.trigger( 'fusion-content-changed' );
						}

					} );
				} else {

					// Adding into sidebar view instead.
					modalView.model.set( 'title', dialogTitle );
					modalView.model.set( 'display', 'sidebar' );
					FusionApp.sidebarView.renderElementSettings( modalView );
				}
			},

			getDialogTitle: function() {
				var dialogTitle = fusionAllElements[ this.model.get( 'element_type' ) ].name,
					params;

				if ( 'multi_element_child' === this.model.get( 'multi' ) ) {
					params = jQuery.extend( true, {}, this.model.get( 'params' ) );
					dialogTitle = 'Item';
					if ( 'undefined' !== typeof params.title && params.title.length ) {
						dialogTitle = params.title;
					} else if ( 'undefined' !== typeof params.title_front && params.title_front.length ) {
						dialogTitle = params.title_front;
					} else if ( 'undefined' !== typeof params.name && params.name.length ) {
						dialogTitle = params.name;
					} else if ( 'undefined' !== typeof params.image && params.image.length ) {
						dialogTitle = params.image;

						// If contains backslash, retrieve only last part.
						if ( -1 !== dialogTitle.indexOf( '/' ) && -1 === dialogTitle.indexOf( '[' ) ) {
							dialogTitle = dialogTitle.split( '/' );
							dialogTitle = dialogTitle.slice( -1 )[ 0 ];
						}
					} else if ( 'image' === this.model.attributes.element_name && 'undefined' !== typeof params.element_content && params.element_content.length ) {
						dialogTitle = params.element_content;

						// If contains backslash, retrieve only last part.
						if ( -1 !== dialogTitle.indexOf( '/' ) && -1 === dialogTitle.indexOf( '[' ) ) {
							dialogTitle = dialogTitle.split( '/' );
							dialogTitle = dialogTitle.slice( -1 )[ 0 ];
						}
					} else if ( 'undefined' !== typeof params.video && params.video.length ) {
						dialogTitle = params.video;
					} else if ( 'undefined' !== typeof params.element_content && params.element_content.length ) {
						dialogTitle = params.element_content;
					}

					// Remove HTML tags but keep quotation marks etc.
					dialogTitle = jQuery( '<div/>' ).html( dialogTitle ).text();
					dialogTitle = jQuery( '<div/>' ).html( dialogTitle ).text();
					dialogTitle = ( dialogTitle && 15 < dialogTitle.length ) ? dialogTitle.substring( 0, 15 ) + '...' : dialogTitle;

					dialogTitle = _.fusionUcFirst( dialogTitle );
				}
				return dialogTitle;
			},

			/**
			 * Generate wireframe preview.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			renderWireframePreview: function() {
				var elementType = this.model.get( 'element_type' ),
					viewSettings,
					params,
					emptySectionText,
					self = this;

				// Skip wireframe rendering unless required.
				if ( ! FusionPageBuilderApp.wireframeActive ) {
					return;
				}

				// Change empty section desc depending on bg image param.
				if ( 'fusion_builder_container' === elementType ) {
					params           = this.model.get( 'params' );
					emptySectionText = fusionBuilderText.empty_section;

					if ( '' !== params.background_image ) {
						emptySectionText = fusionBuilderText.empty_section_with_bg;
					}

					this.$el.find( '.fusion-builder-empty-section' ).html( emptySectionText );
				}

				// If child element is changed we need to reRender parent.
				if ( this.model.get( 'parent' ) && ( 'true' === this.model.get( 'child_element' ) || true === this.model.get( 'child_element' ) ) ) {
					self        = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
					elementType = self.model.get( 'element_type' );
				}

				if ( 'undefined' !== typeof fusionAllElements[ elementType ].preview || 'element' === self.model.get( 'type' ) ) {
					if ( 'undefined' === typeof self.previewView || ! self.previewView ) {
						viewSettings = {
							model: self.model,
							collection: FusionPageBuilderElements,
							dynamicParams: self.dynamicParams
						};
						self.previewView = new FusionPageBuilder.ElementPreviewView( viewSettings );
					}

					self.$el.find( '.fusion-builder-module-preview' ).html( self.previewView.render().el );
				}
			},

			/**
			 * Extendable function for when settings is opened.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			onSettingsOpen: function() {
			},

			/**
			 * Extendable function for when settings is closed.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			onSettingsClose: function() {
				var $dialog = jQuery( '.ui-dialog:not( .fusion-video-dialog ):not( .fusion-builder-preferences-dialog )' ).first();

				// If there are opened dialogs which are resizable.
				if ( 0 < $dialog.length && ! jQuery( 'body' ).hasClass( 'fusion-settings-dialog-large' ) ) {

					// Change it's size.
					jQuery( $dialog ).css( 'width', FusionApp.dialog.dialogData.width + 'px' );
					jQuery( $dialog ).css( 'height', FusionApp.dialog.dialogData.height + 'px' );

					// Reposition it.
					jQuery( $dialog ).position( {
						my: FusionApp.dialog.dialogData.position.my,
						at: FusionApp.dialog.dialogData.position.at,
						of: window
					} );
				}
			},

			/**
			 * Renders the content.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			renderContent: function() {
			},

			/**
			 * Adds loading overlay while ajax is performing.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			addLoadingOverlay: function() {
				var contentType = 'element',
					$elementContent;

				if ( _.isObject( this.model.attributes ) ) {
					if ( 'fusion_builder_container' === this.model.attributes.element_type ) {
						contentType = 'container';
					} else if ( 'fusion_builder_column' === this.model.attributes.element_type ) {
						contentType = 'columns';
					}
				}

				$elementContent = this.$el.find( '.fusion-builder-' + contentType + '-content' );

				if ( ! $elementContent.hasClass( 'fusion-loader' ) ) {
					$elementContent.addClass( 'fusion-loader' );
					$elementContent.append( '<span class="fusion-builder-loader"></span>' );
				}
			},

			/**
			 * Removes an element.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the element removal.
			 * @return {void}
			 */
			removeElement: function( event ) {
				var parentCid = this.model.get( 'parent' );

				if ( event ) {
					event.preventDefault();
					FusionEvents.trigger( 'fusion-content-changed' );
				}

				// Remove element view
				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				// Destroy element model
				this.model.destroy();

				FusionEvents.trigger( 'fusion-element-removed', this.model.get( 'cid' ) );

				// Update column trigger.
				this.triggerColumn( parentCid );

				// Destroy dyamic param model.
				if ( this.dynamicParam ) {
					this.dynamicParam.destroy();
				}

				this.remove();
			},

			/**
			 * Opens the library. Builds the settings for this view
			 * and then calls FusionPageBuilder.LibraryView and renders it.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The js event.
			 * @return {void}
			 */
			openLibrary: function( event ) {
				var view,
					libraryModel = {
						target: jQuery( event.currentTarget ).data( 'target' ),
						focus: jQuery( event.currentTarget ).data( 'focus' ),
						element_cid: this.model.get( 'cid' ),
						element_name: 'undefined' !== typeof this.model.get( 'admin_label' ) && '' !== this.model.get( 'admin_label' ) ? this.model.get( 'admin_label' ) : ''
					},
					viewSettings = {
						model: libraryModel
					};

				if ( event ) {
					event.preventDefault();
					event.stopPropagation();
					FusionPageBuilderApp.sizesHide( event );
				}

				view = new FusionPageBuilder.LibraryView( viewSettings );
				view.render();

				// Make sure to close any context menus which may be open.
				FusionPageBuilderApp.removeContextMenu();
			},

			/**
			 * Disable external links.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			disableLink: function( event ) {
				if ( ! jQuery( event.target ).closest( '.fusion-builder-module-controls-container' ).length && 'lightbox' !== jQuery( event.currentTarget ).attr( 'target' ) ) {
					event.preventDefault();

					if ( FusionApp.modifierActive && ! jQuery( event.target ).parent().hasClass( 'fusion-lightbox' ) ) {
						FusionApp.checkLink( event );
					}
				}
			},

			/**
			 * Creates droppable zone and makes element draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			droppableElement: function() {
				var self  = this,
					$el   = this.$el,
					cid   = this.model.get( 'cid' ),
					$body = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' );

				if ( ! $el ) {
					return;
				}
				if ( 'undefined' === typeof this.elementTarget || ! this.elementTarget.length ) {
					this.elementTarget = this.$el.find( '.fusion-element-target' );
				}

				$el.draggable( {
					appendTo: FusionPageBuilderApp.$el,
					zIndex: 999999,
					delay: 100,
					cursorAt: { top: 15, left: 15 },
					iframeScroll: true,
					containment: $body,
					cancel: '.fusion-live-editable, .fusion-builder-live-child-element:not( [data-fusion-no-dragging] )',
					helper: function() {
						var $classes = FusionPageBuilderApp.DraggableHelpers.draggableClasses( cid );
						return jQuery( '<div class="fusion-element-helper ' + $classes + '" data-cid="' + cid + '"><span class="' + fusionAllElements[ self.model.get( 'element_type' ) ].icon + '"></span></div>' );
					},
					start: function() {
						$body.addClass( 'fusion-element-dragging fusion-active-dragging' );
						$el.addClass( 'fusion-being-dragged' );
						$el.prev( '.fusion-builder-live-element' ).find( '.target-after' ).addClass( 'target-disabled' );
					},
					stop: function() {
						setTimeout( function() {
							$body.removeClass( 'fusion-element-dragging fusion-active-dragging' );
						}, 10 );
						$el.removeClass( 'fusion-being-dragged' );
						FusionPageBuilderApp.$el.find( '.target-disabled' ).removeClass( 'target-disabled' );
					}
				} );

				this.elementTarget.droppable( {
					tolerance: 'touch',
					hoverClass: 'ui-droppable-active',
					accept: '.fusion-builder-live-element, .fusion_builder_row_inner',
					drop: function( event, ui ) {
						var parentCid      = jQuery( event.target ).closest( '.fusion-builder-column' ).data( 'cid' ),
							columnView     = FusionPageBuilderViewManager.getView( parentCid ),
							elementCid     = ui.draggable.data( 'cid' ),
							elementView    = FusionPageBuilderViewManager.getView( elementCid ),
							MultiGlobalArgs,
							newIndex;

						// Move the actual html.
						if ( jQuery( event.target ).hasClass( 'target-after' ) ) {
							$el.after( ui.draggable );
						} else {
							$el.before( ui.draggable );
						}

						newIndex = ui.draggable.parent().children( '.fusion-builder-live-element, .fusion_builder_row_inner' ).index( ui.draggable );

						FusionPageBuilderApp.onDropCollectionUpdate( elementView.model, newIndex, parentCid );

						// Save history state
						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.moved + ' ' + fusionAllElements[ elementView.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );

						// Handle multiple global elements.
						MultiGlobalArgs = {
							currentModel: elementView.model,
							handleType: 'save',
							attributes: elementView.model.attributes
						};
						fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

						FusionEvents.trigger( 'fusion-content-changed' );

						columnView._equalHeights();
					}
				} );

				// If we are in wireframe mode, then disable.
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.disableDroppableElement();
				}
			},

			/**
			 * Destroy or disable the droppable and draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			disableDroppableElement: function() {
				var $el = this.$el;

				// If its been init, just disable.
				if ( 'undefined' !== typeof $el.draggable( 'instance' ) ) {
					$el.draggable( 'disable' );
				}

				// If its been init, just disable.
				if ( 'undefined' !== typeof this.elementTarget && this.elementTarget.length && 'undefined' !== typeof this.elementTarget.droppable( 'instance' ) ) {
					this.elementTarget.droppable( 'disable' );
				}
			},

			/**
			 * Enable the droppable and draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			enableDroppableElement: function() {
				var $el = this.$el;

				// If they have been init, then just disable.
				if ( 'undefined' !== typeof $el.draggable( 'instance' ) && 'undefined' !== typeof this.elementTarget && this.elementTarget.length && 'undefined' !== typeof this.elementTarget.droppable( 'instance' ) ) {
					$el.draggable( 'enable' );
					this.elementTarget.droppable( 'enable' );
				} else {

					// No sign of init, then need to call it.
					this.droppableElement();
				}
			},

			/**
			 * Fired when wireframe mode is toggled.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			wireFrameToggled: function() {
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.renderWireframePreview();
					this.disableDroppableElement();
				} else {
					this.enableDroppableElement();
				}
			},

			/**
			 * Gets edit label.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getEditLabel: function() {
				var editLabel   = fusionBuilderText.element_settings,
					elementType = this.model.get( 'element_type' );
				if ( 'undefined' !== typeof fusionAllElements[ elementType ] ) {
					editLabel = fusionBuilderText.custom_element_settings;
					editLabel = editLabel.replace( '%s', fusionAllElements[ elementType ].name );
				}
				return editLabel;
			},

			/**
			 * Simple prevent default function.
			 *
			 * @since 2.0.0
			 * @param {Object} event - Click event object.
			 * @return {void}
			 */
			preventDefault: function( event ) {
				event.preventDefault();
			},

			/**
			 * Update element settings on drag (columns and containers).
			 *
			 * @since 2.0.0
			 * @param {string} selector - Selector of option.
			 * @param {string} value - Value to update to.
			 * @return {void}
			 */
			updateDragSettings: function( selector, value ) {
				var $option = jQuery( '[data-element-cid="' + this.model.get( 'cid' ) + '"] ' + selector ),
					$elementSettings,
					$section;

				if ( $option.length ) {
					$elementSettings = $option.closest( '.fusion_builder_module_settings' );
					if ( ! $elementSettings.find( '.fusion-tabs-menu a[href="#design"]' ).parent().hasClass( 'current' ) ) {
						$elementSettings.find( '.fusion-tabs-menu a[href="#design"]' ).parent().trigger( 'click' );
					}
					$section = $elementSettings.find( '.fusion-tabs-menu a[href="#design"]' ).closest( '.fusion-sidebar-section, .ui-dialog-content' );
					$section.scrollTop(  $option.position().top + $section.scrollTop() );
					$option.val( value ).trigger( 'change' );
				}
			},

			baseInit: function() {
				var elementType = this.model.get( 'element_type' );

				this.initialValue = {};
				this.logHistory   = {};
				if ( 'string' === typeof elementType && -1 === jQuery.inArray( elementType, FusionPageBuilderApp.inlineElements ) ) {
					this.listenTo( FusionEvents, 'fusion-global-update-' + elementType, this.updateDefault );
					this.listenTo( FusionEvents, 'fusion-extra-update-' + elementType, this.updateExtra );
				}

				this.initDynamicParams();
			},

			initDynamicParams: function() {
				var self        = this,
					params      = this.model.get( 'params' ),
					dynamicData = params.dynamic_params;

				this.dynamicParams = new FusionPageBuilder.DynamicParams( { elementView: this } );

				if ( 'string' === typeof params.dynamic_params && '' !== params.dynamic_params ) {
					try {
						if ( FusionPageBuilderApp.base64Encode( FusionPageBuilderApp.base64Decode( dynamicData ) ) === dynamicData ) {
							dynamicData = FusionPageBuilderApp.base64Decode( dynamicData );
							dynamicData = _.unescape( dynamicData );
							dynamicData = JSON.parse( dynamicData );
						}
						self.dynamicParams.setData( dynamicData );
					} catch ( error ) {
						console.log( error ); // jshint ignore:line
					}
				}
			},

			/**
			 * Check for element ajax callbacks and run them.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			triggerAjaxCallbacks: function( skip ) {
				var self          = this,
					AjaxCallbacks = {},
					args          = {
						skip: 'undefined' === typeof skip ? false : skip
					};

				if ( 'undefined' !== typeof fusionAllElements[ this.model.get( 'element_type' ) ].has_ajax ) {

					// Collect callbacks. Do not fire the same action twice.
					_.each( fusionAllElements[ this.model.get( 'element_type' ) ].has_ajax, function( callback ) {
						AjaxCallbacks = {};
						AjaxCallbacks[ callback.action ] = {};
						AjaxCallbacks[ callback.action ][ 'function' ]   = callback[ 'function' ];
						AjaxCallbacks[ callback.action ].param_name = callback.param_name;
						AjaxCallbacks[ callback.action ].action     = callback.action;
					} );

					// Trigger ajax callbacks to populate query_data attribute
					_.each( AjaxCallbacks, function( callback ) {
						FusionApp.callback[ callback[ 'function' ] ]( callback.param_name, self.model.attributes.params[ callback.param_name ], self.model.attributes, args, self.model.get( 'cid' ), callback.action, self.model, self );
					} );
				}
			},

			updateExtra: function() {
				this.reRender();
			},

			updateDefault: function( param, value ) {
				var modelData        = jQuery.extend( this.model.attributes, {} ),
					reRender         = true,
					callbackFunction = false,
					params           = this.model.get( 'params' );

				// Only re-render if actually using default.
				if ( ( 'undefined' === typeof params[ param ] || '' === params[ param ] || 'default' === params[ param ] ) && ! this.dynamicParams.hasDynamicParam( param ) ) {

					callbackFunction = FusionPageBuilderApp.getCallbackFunction( modelData, param, value, this, true );
					if ( false !== callbackFunction && 'function' === typeof FusionApp.callback[ callbackFunction[ 'function' ] ] ) {
						reRender = this.doCallbackFunction( callbackFunction, false, param, value, modelData, true );
					}

					if ( reRender ) {
						this.reRender();
					}
				}
			},

			historyUpdateParam: function( param, value ) {
				var modelData        = jQuery.extend( this.model.attributes, {} ),
					reRender         = true,
					callbackFunction = false;

				this.changeParam( param, value, false, true );

				callbackFunction = FusionPageBuilderApp.getCallbackFunction( modelData, param, value, this, true );
				if ( false !== callbackFunction && 'function' === typeof FusionApp.callback[ callbackFunction[ 'function' ] ] ) {
					reRender = this.doCallbackFunction( callbackFunction, false, param, value, modelData, true );
				}

				if ( reRender ) {
					this.reRender();
				}
			},

			updateParam: function( param, value, event ) {
				var modelData        = jQuery.extend( this.model.attributes, {} ),
					reRender         = true,
					callbackFunction = FusionPageBuilderApp.getCallbackFunction( modelData, param, value, this );

				if ( false !== callbackFunction && 'function' === typeof FusionApp.callback[ callbackFunction[ 'function' ] ] ) {
					reRender = this.doCallbackFunction( callbackFunction, event, param, value, modelData );
				} else {
					this.changeParam( param, value );
				}

				return reRender;
			},

			setInitialValue: function( param ) {
				if ( 'undefined' !== typeof this.initialValue && 'undefined' === typeof this.initialValue[ param ] && 'undefined' !== typeof param ) {
					this.initialValue[ param ] = 'undefined' !== typeof this.model.get( 'params' )[ param ] ? this.model.get( 'params' )[ param ] : '';
				}
			},

			logChangeEvent: function( param, value, label ) {
				this.logHistory._param = this.logHistory._param || {};
				if ( ! ( param in this.logHistory._param ) ) {
					this.logHistory._param[ param ] = _.debounce( _.bind( function( param, value, label ) {
						var state = {
								type: 'param',
								param: param,
								newValue: value,
								cid: this.model.get( 'cid' )
							},
							elementMap  = fusionAllElements[ this.model.get( 'element_type' ) ],
							paramObject = elementMap.params[ param ],
							paramTitle  = 'object' === typeof paramObject ? paramObject.heading : param;

						if ( 'undefined' !== typeof label ) {
							paramTitle = label;
						} else if ( 'object' !== typeof paramObject && jQuery( '.multi-builder-dimension #' + param ).length ) {
							paramObject = elementMap.params[ jQuery( '.multi-builder-dimension #' + param ).closest( '.multi-builder-dimension' ).attr( 'id' ) ];
							if ( 'object' === typeof paramObject && 'string' === typeof paramObject.heading ) {
								paramTitle = paramObject.heading;
							}
						} else if ( 'object' !== typeof paramObject && jQuery( '.font_family #' + param ).length ) {
							paramObject = elementMap.params[ jQuery( '.font_family #' + param ).closest( '.fusion-builder-option' ).attr( 'data-option-id' ) ];
							if ( 'object' === typeof paramObject && 'string' === typeof paramObject.heading ) {
								paramTitle = paramObject.heading;
							}
						}

						state.oldValue = this.initialValue[ param ];
						delete this.initialValue[ param ];

						this.model.trigger( 'change' );
						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.edited + ' ' + elementMap.name + ' - ' + paramTitle, state );
					}, this ), 500 );
				}
				this.logHistory._param[ param ]( param, value, label );
			},

			changeParam: function( param, value, label, silent ) {
				var parentView;
				if ( ! silent && ! this.model.get( 'inlineElement' ) ) {
					this.setInitialValue( param );
					this.model.attributes.params[ param ] = value;

					// Update parent after param has been changed.
					if ( 'multi_element_child' === this.model.get( 'multi' ) ) {
						parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
						if ( parentView && 'function' === typeof parentView.updateElementContent ) {
							parentView.updateElementContent();
						}
					}
					this.logChangeEvent( param, value, label );
				} else {
					this.model.attributes.params[ param ] = value;
				}
			},

			/**
			 * Gets callback function for option change.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			doCallbackFunction: function( callbackFunction, event, paramName, paramValue, modelData, skipChange ) {
				var reRender = true,
					returnData;

				callbackFunction.args   = 'undefined' === typeof callbackFunction.args ? {} : callbackFunction.args;
				callbackFunction.ajax   = 'undefined' === typeof callbackFunction.ajax ? false : callbackFunction.ajax;
				callbackFunction.action = 'undefined' === typeof callbackFunction.action ? false : callbackFunction.action;
				skipChange              = 'undefined' === typeof skipChange ? false : skipChange;

				// If skip is set then param will not be changed.
				callbackFunction.args.skip = skipChange;

				// If ajax trigger via debounce, else do it here and retun data.
				if ( callbackFunction.ajax ) {
					reRender = false;
					this.addLoadingOverlay();
					this._triggerCallback( event, callbackFunction, paramName, paramValue, modelData.cid, modelData );
				} else {
					returnData = FusionApp.callback[ callbackFunction[ 'function' ] ]( paramName, paramValue, callbackFunction.args, this );
				}
				if ( 'undefined' !== typeof returnData && 'undefined' !== typeof returnData.render ) {
					reRender = returnData.render;
				}

				return reRender;
			},

			/**
			 * Triggers a callback function.
			 *
			 * @since 2.0.0
			 * @param {Object}        event - The event.
			 * @param {string|Object} callbackFunction - The callback function.
			 * @return {void}
			 */
			triggerCallback: function( event, callbackFunction, paramName, paramValue, cid, modelData ) {

				if ( 'undefined' === typeof modelData ) {
					modelData = jQuery.extend( this.model.attributes, {} );
				}

				// This is added due to the new elements causing max call stack.  Not sure why but it shouldn't be necessary in any case.
				if ( 'undefined' !== typeof modelData ) {
					delete modelData.view;
				}
				if ( 'fusion_do_shortcode' !== callbackFunction[ 'function' ] ) {
					FusionApp.callback[ callbackFunction[ 'function' ] ]( paramName, paramValue, modelData, callbackFunction.args, cid, callbackFunction.action, this.model, this );
				} else {
					FusionApp.callback[ callbackFunction[ 'function' ] ]( cid, callbackFunction.content, callbackFunction.parent );
				}
			}

		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderViewManager, FusionPageBuilderApp, FusionApp, FusionEvents, fusionBuilderText */
/* eslint no-shadow: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Row View
		FusionPageBuilder.BaseRowView = window.wp.Backbone.View.extend( {

			/**
			 * On init for both regular and nested columns.
			 *
			 * @since 3.0
			 * @return null
			 */
			baseRowInit: function() {
				this._updateResponsiveColumnsOrder = _.debounce( this.updateResponsiveColumnsOrder, 100 );
			},

			reRender: function() {
				this.render( true );
			},

			/**
			 * Calculate virtual rows.
			 *
			 * @since 2.0.0
			 * @return {null}
			 */
			createVirtualRows: function() {
				var container = FusionPageBuilderApp.getParentContainer( this.model.get( 'parent' ) );

				// If we are flex, no need for virtual rows.
				if ( 'function' === typeof container.isFlex && container.isFlex() ) {
					return;
				}
				this.updateVirtualRows();
				this.assignColumn();
			},

			/**
			 * Set the initial column data to the model.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			updateVirtualRows: function() {
				var rows        = {},
					column      = {},
					columns     = [],
					count       = 0,
					index       = 0,
					oldRows     = this.model.get( 'rows' ),
					columnWidth;

				this.model.children.each( function( child ) {
					column      = {};
					columnWidth = child.attributes.params.type;

					if ( ! columnWidth ) {
						columnWidth = '1_1';
					}
					columnWidth = columnWidth.split( '_' );
					columnWidth = columnWidth[ 0 ] / columnWidth[ 1 ];
					count += columnWidth;

					if ( 1 < count ) {
						index += 1;
						count = columnWidth;
					}

					column = {
						cid: child.attributes.cid
					};

					if ( 'undefined' === typeof rows[ index ] ) {
						rows[ index ] = [ column ];
					} else {
						rows[ index ].push( column );
					}

					columns[ child.attributes.cid ] = index;
				} );

				this.model.set( 'columns', columns );
				this.model.set( 'rows', rows );

				if ( 'object' === typeof oldRows ) {
					this.model.set( 'oldRows', oldRows );
				}
			},

			/**
			 * Change the column in the model.
			 *
			 * @since 2.0.0
			 * @param {Object} column - The column view.
			 * @return {void}
			 */
			assignColumn: function() {
				var columnParams,
					self         = this,
					oldRows      = this.model.get( 'oldRows' ),
					updatedCols  = false,
					emptySpacing = true;

				// Reset first, last positions
				this.model.children.each( function( column ) {
					columnParams       = jQuery.extend( true, {}, column.get( 'params' ) );
					columnParams.first = false;
					columnParams.last  = false;
					column.set( 'params', columnParams );
				} );

				// Loop over virtual rows
				_.each( this.model.get( 'rows' ), function( row, rowIndex ) {
					var total           = row.length,
						lastIndex       = total - 1,
						rowSame         = true,
						previousSpacing = '';

					// Loop over columns inside virtual row
					_.each( row, function( col, colIndex ) {
						var columnFirst     = false,
							columnLast      = false,
							model           = self.model.children.find( function( model ) {
								return model.get( 'cid' ) == col.cid; // jshint ignore: line
							} ),
							params          = jQuery.extend( true, {}, model.get( 'params' ) ),
							spacing,
							weightedSpacing;

						// First index
						if ( 0 === colIndex ) {
							columnFirst = true;
						}

						if ( lastIndex === colIndex ) {
							columnLast = true;
						}

						params.first = columnFirst;
						params.last  = columnLast;

						// Check if we need legacy column spacing set.
						if ( 'undefined' !== typeof params.spacing && FusionPageBuilderApp.loaded ) {
							spacing = params.spacing;
							if ( 'yes' === spacing ) {
								spacing = '4%';
							} else if ( 'no' === spacing ) {
								spacing = '0px';
							}

							if ( ! params.last && '0px' !== spacing && 0 !== spacing && '0' !== spacing ) {
								emptySpacing = false;
							}
							weightedSpacing = self.getWeightedSpacing( spacing, params, total );

							// Only set params if both are unset.
							if ( 'undefined' === typeof params.spacing_left && 'undefined' === typeof params.spacing_right ) {
								// Use what is set as right spacing.
								if ( ! params.last ) {
									params.spacing_right = weightedSpacing;
								}

								// Check right spacing of previous column.
								if ( '' !== previousSpacing ) {
									params.spacing_left = self.getWeightedSpacing( previousSpacing, params, total );
								}
							}

							previousSpacing = spacing;
						} else {
							emptySpacing = false;
						}

						model.set( 'params', params );

						// Check if col is same as before.
						if ( rowSame ) {
							if ( 'object' !== typeof oldRows || 'undefined' === typeof oldRows[ rowIndex ] || 'undefined' === typeof oldRows[ rowIndex ][ colIndex ] || oldRows[ rowIndex ][ colIndex ].cid !== col.cid ) {
								rowSame = false;
							}
						}
					} );

					if ( ! rowSame && FusionPageBuilderApp.loaded ) {
						if ( false === updatedCols ) {
							updatedCols = [];
						}
						_.each( row, function( col ) {
							updatedCols.push( col.cid );
						} );
					}
				} );

				this.model.set( 'emptySpacing', emptySpacing );
				this.model.set( 'updatedCols', updatedCols );
			},

			getVirtualRowByCID: function( cid ) {
				var rows    = this.model.get( 'rows' ),
					columns = this.model.get( 'columns' ),
					index   = columns[ cid ],
					row     = rows[ index ];

				return row;
			},

			/**
			 * First render, work out legacy column map only once.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			legacyColumns: function() {
				var container    = FusionPageBuilderApp.getParentContainer( this.model.get( 'parent' ) ),
					emptySpacing = false,
					nestedRows   = {};

				// If we are not in need of legacy conversion then skip.
				if ( ! container || ! container.needsLegacyConversion() ) {
					return;
				}

				// Create map of row to get correct spacing.
				this.updateVirtualRows();
				this.assignColumn();

				if ( ! this.nestedRow ) {
					// This row is all empty spacing.
					emptySpacing = this.model.get( 'emptySpacing' );

					// Run through same process for nested rows.
					this.$el.find( '.fusion-builder-row-inner' ).each( function() {
						var nestedRowCid               = jQuery( this ).attr( 'data-cid' ),
							nestedView                 = FusionPageBuilderViewManager.getView( nestedRowCid );

						// Store for later looping if necessary.
						nestedRows[ nestedRowCid ] = nestedView;

						// Update legacy maps and nested column styles.
						nestedView.legacyColumns();

						// If nested row is not empty spacing, parent row shouldn't be also.
						if ( false === nestedView.model.get( 'emptySpacing' ) ) {
							emptySpacing = false;
						}
					} );

					// If its empty spacing and all nested rows also, we will set spacing on container and re-render.
					if ( emptySpacing ) {

						// Set the spacing on container.
						container = FusionPageBuilderApp.getParentContainer( this.model.get( 'parent' ) );
						if ( container ) {
							container.setEmptySpacing();
						}

						// If we have nested rows, update them visually.
						if ( 'object' === typeof nestedRows && ! _.isEmpty( nestedRows ) ) {
							_.each( nestedRows, function( nestedRow ) {
								nestedRow.recalculateMargins();
							} );
						}

						// Update parent row visually.
						this.recalculateMargins();
					}
				}
				// Update visual appearance for direct children columns.
				this.model.children.each( function( child ) {
					var view = FusionPageBuilderViewManager.getView( child.attributes.cid );

					view.setArgs();
					view.validateArgs();
					view.setExtraArgs();
					view.setColumnMapData();
					view.setResponsiveColumnStyles();

					view.$el.find( '.fusion-column-responsive-styles' ).last().html( view.responsiveStyles );
				} );

				// Set param on container to stop it rerunning.
				if ( container && 'function' === typeof container.setType ) {
					container.setType();
				}
			},

			getHalfSpacing: function( value ) {
				var unitlessSpacing = parseFloat( value ),
					unitlessHalf    = unitlessSpacing / 2;

				return value.replace( unitlessSpacing, unitlessHalf );
			},

			validateColumnWidth: function( columnSize ) {
				var fractions;

				if ( 'undefined' === typeof columnSize ) {
					columnSize = '1_3';
				}

				// Fractional value.
				if ( -1 !== columnSize.indexOf( '_' ) ) {
					fractions = columnSize.split( '_' );
					return parseFloat( fractions[ 0 ] ) / parseFloat( fractions[ 1 ] );
				}

				// Greater than one, assume percentage and divide by 100.
				if ( 1 < parseFloat( columnSize ) ) {
					return parseFloat( columnSize ) / 100;
				}

				return columnSize;
			},

			getWeightedSpacing: function( value, params, total ) {
				var width            = parseFloat( this.validateColumnWidth( params.type ) ),
					unitlessSpacing  = parseFloat( value ),
					unitlessWeighted;

				total = 'undefined' === typeof total || false === total ? false : parseInt( total );

				if ( false !== total && 3 > total ) {
					unitlessWeighted = unitlessSpacing * width;
				} else {
					unitlessWeighted = unitlessSpacing / 2;
				}

				return value.replace( unitlessSpacing, unitlessWeighted );
			},

			updateColumnsPreview: function() {
				var container   = FusionPageBuilderApp.getParentContainer( this.model.get( 'parent' ) ),
					updatedCols = this.model.get( 'updatedCols' ),
					self        = this;

				// Update flex column preview here.
				if ( 'function' === typeof container.isFlex && container.isFlex() ) {
					return;
				}

				if ( true === FusionPageBuilderApp.loaded ) {
					this.model.children.each( function( child ) {
						var view,
							singleRow,
							columnRow;

						if ( false === updatedCols || _.contains( updatedCols, child.attributes.cid ) ) {
							view      = FusionPageBuilderViewManager.getView( child.attributes.cid );
							singleRow = self.getVirtualRowByCID( view.model.get( 'cid' ) );
							columnRow = [];

							// Update first/last classes
							view.$el.removeClass( 'fusion-column-last' );
							view.$el.removeClass( 'fusion-column-first' );

							if ( true === view.model.attributes.params.last ) {
								view.$el.addClass( 'fusion-column-last' );
							}

							if ( true === view.model.attributes.params.first ) {
								view.$el.addClass( 'fusion-column-first' );
							}

							// Update column spacing.
							_.each( singleRow, function( cid ) {
								var model,
									value;

								cid   = cid.cid;
								model = self.collection.find( function( model ) {
									return model.get( 'cid' ) == cid; // jshint ignore: line
								} );
								value = model.attributes.params.spacing;

								columnRow.push( value );
							} );

							view.columnSpacingPreview( columnRow );
						}
					} );
				}
			},

			/**
			 * Sets the row data.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			setRowData: function() {
				this.createVirtualRows();
				this.updateColumnsPreview();
			},

			setSingleRowData: function( cid ) {
				var row = this.getVirtualRowByCID( cid ),
					view;

				_.each( row, function( column ) {
					view = FusionPageBuilderViewManager.getView( column.cid );
					view.reRender();
				} );
			},

			/**
			 * Mode change for container.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			modeChange: function() {
				this.setRowData();
				this.reRender( true );
				this.reRenderColumns();

				// Refresh nested rows if they exist.
				if ( ! this.nestedRow ) {
					this.reRenderNestedRows();
				}
			},

			/**
			 * Mode change for container.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			updateInnerStyles: function() {
				this.setRowData();
				this.reRender( true );

				if ( this.nestedRow ) {
					this.appendChildren( false );
				}

				this.model.children.each( function( child ) {
					var cid  = child.attributes.cid;
					var column = FusionPageBuilderViewManager.getView( cid );

					if ( column ) {
						column.updateInnerStyles();
					}
				} );

				// Refresh nested rows if they exist.
				if ( ! this.nestedRow ) {
					this.$el.find( '.fusion_builder_row_inner' ).each( function( ) {
						var cid = jQuery( this ).attr( 'data-cid' ),
							row = FusionPageBuilderViewManager.getView( cid );
						if ( row ) {
							row.updateInnerStyles();
						}
					} );
				}
				this.delegateChildEvents();
			},

			/**
			 * Re-render the nested rows.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			reRenderNestedRows: function() {
				this.$el.find( '.fusion_builder_row_inner' ).each( function( ) {
					var cid = jQuery( this ).attr( 'data-cid' ),
						row = FusionPageBuilderViewManager.getView( cid );

					if ( 'object' === typeof row ) {
						row.modeChange();
						row.appendChildren();
					}
				} );
			},

			/**
			 * Re-render columns
			 *
			 * @since 3.0
			 * @return {void}
			 */
			reRenderColumns: function() {
				var cid,
					view;
				this.model.children.each( function( child ) {

					cid  = child.attributes.cid;
					view = FusionPageBuilderViewManager.getView( cid );

					if ( view ) {
						view.reRender();
					}
				} );
			},

			/**
			 * Updates columns' order params.
			 * @return {void}
			 */
			updateResponsiveColumnsOrder: function( draggedColumn, columns, targetColumnCID, insertAfterTargetColumn ) {
				var viewportSize       = FusionApp.getPreviewWindowSize(),
					draggedColumnCID   = parseInt( draggedColumn.data( 'cid' ) ),
					draggedColumnOrder = parseInt( draggedColumn.css( 'order' ) ),
					columnsArray       = [],
					index              = 0,
					columnView;

				if ( 'large' === viewportSize ) {
					return;
				}

				jQuery( columns ).each( function( scopedIndex, column ) {

					// TODO: handle case when multiple columns have same order set.
					if ( draggedColumnCID !== jQuery( column ).data( 'cid' ) ) {
						columnsArray.push( [ parseInt( jQuery( column ).data( 'cid' ) ), parseInt( jQuery( column ).css( 'order' ) ) ] );
					}

				} );

				// Sort columns by CSS order.
				columnsArray.sort( function( col1, col2 ) {
					return col1[ 1 ] - col2[ 1 ];
				} );

				// Find index (position) of target column.
				for ( index = 0; index < columnsArray.length; index++ ) {
					if ( targetColumnCID === columnsArray[ index ][ 0 ] ) {
						break;
					}
				}

				// In case we're inserting before target column.
				if ( ! insertAfterTargetColumn ) {
					index--;
				}

				// Insert dragged column in it's place. Note that index is position in 'splice' context (not array index).
				columnsArray.splice( index + 1, 0, [ draggedColumnCID, draggedColumnOrder ] );

				// Index is not longer relevant, using it just as iterator.
				for ( index = 0; index < columnsArray.length; index++ ) {

					// Get column view by CID.
					columnView = FusionPageBuilderViewManager.getView( columnsArray[ index ][ 0 ] );

					// Update order param and value.
					columnView.model.attributes.params[ 'order_' + viewportSize  ] = index;
					columnView.values[ 'order_' + viewportSize  ]                  = index;

					// Update column's responsive styles.
					columnView.setResponsiveColumnStyles();
					columnView.$el.find( '.fusion-column-responsive-styles' ).last().html( columnView.responsiveStyles );

					// Update EO panel if opened.
					if ( jQuery( '.fusion-builder-module-settings[data-element-cid="' + columnsArray[ index ][ 0 ] + '"' ) ) {
						FusionEvents.trigger( 'fusion-param-changed-' + columnView.model.get( 'cid' ), 'order_' + viewportSize, index );
					}
				}

				// Trigger change and add history event.
				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.column + ' order changed' );
			}

		} );
	} );
}( jQuery ) );
;/* global FusionApp, fusionBuilderText, fusionAllElements, cssua, FusionPageBuilderViewManager, FusionPageBuilderApp, FusionEvents, fusionSettings */
/* eslint no-unused-vars: 0 */
/* eslint no-shadow: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Nested Column View
		FusionPageBuilder.BaseColumnView = FusionPageBuilder.BaseView.extend( {

			/**
			 * On init for both regular and nested columns.
			 *
			 * @since 3.0
			 * @return null
			 */
			baseColumnInit: function() {
				this.model.children = new FusionPageBuilder.Collection();

				this.listenTo( FusionEvents, 'fusion-param-changed-' + this.model.get( 'cid' ), this.onOptionChange );
				this.listenTo( this.model.children, 'add', this.addChildView );
				this.listenTo( FusionEvents, 'fusion-wireframe-toggle', this.wireFrameToggled );

				// Responsive control updates on resize.
				this.listenTo( FusionEvents, 'fusion-preview-viewport-update', this.onPreviewResize );

				this._triggerCallback = _.debounce( _.bind( this.triggerCallback, this ), 200 );
				this._toolTipHide     = _.debounce( _.bind( this.toolTipHide, this ), 500 );
				this._refreshJs       = _.debounce( _.bind( this.refreshJs, this ), 300 );
				this._equalHeights    = _.debounce( _.bind( this.equalHeights, this ), 300 );

				this.deprecatedParams();

				// Hold the DOM elements for resizables.
				this.marginResize  = {};
				this.paddingResize = {};
			},

			/**
			 * Runs before view DOM is patched.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			beforePatch: function() {
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.$el.find( '.fusion-builder-column-content' ).removeClass( 'ui-sortable' );
				}
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			afterPatch: function() {
				var self = this;

				if ( 'undefined' !== typeof this.model.attributes.selectors ) {
					if ( this.model.get( 'dragging' ) ) {
						this.model.attributes.selectors.style      += ';display: none;';
						this.model.attributes.selectors[ 'class' ] += ' ignore-me-column';
					}

					this.$el.removeAttr( 'data-animationType' );
					this.$el.removeAttr( 'data-animationDuration' );
					this.$el.removeAttr( 'data-animationOffset' );

					this.setElementAttributes( this.$el, this.model.attributes.selectors );
				}

				if ( this.forceAppendChildren ) {
					this.appendChildren();
					this.forceAppendChildren = false;
				}

				setTimeout( function() {
					self.droppableColumn();
				}, 300 );

				this._refreshJs();

				if ( FusionPageBuilderApp.wireframeActive ) {
					this.$el.find( '.fusion-builder-column-content' ).addClass( 'ui-sortable' );
				}
			},

			/**
			 * Delegates multiple child elements.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			delegateChildEvents: function() {
				var cid,
					view;

				this.model.children.each( function( child ) {
					cid  = child.attributes.cid;
					view = FusionPageBuilderViewManager.getView( cid );

					view.delegateEvents();

					// Re init for elements.
					if ( 'function' === typeof view.droppableElement ) {
						view.droppableElement();
					}

					// Re init for nested row.
					if ( 'function' === typeof view.droppableColumn ) {
						view.droppableColumn();
					}

					// Multi elements
					if ( 'undefined' !== typeof view.model.get( 'multi' ) && 'multi_element_parent' === view.model.get( 'multi' ) ) {
						view.delegateChildEvents();
						view.sortableChildren();
					}
				} );
			},

			updateInnerStyles: function() {
				this.setArgs();
				this.validateArgs();
				this.setExtraArgs();
				this.setColumnMapData();
				this.setResponsiveColumnStyles();
				this.$el.find( '.fusion-column-responsive-styles' ).last().html( this.responsiveStyles );

				this.delegateChildEvents();
			},

			/**
			 * Updates now deprecated params and adds BC checks.
			 *
			 * @since 2.1
			 * @return {void}
			 */
			deprecatedParams: function() {
				var params               = this.model.get( 'params' ),
					alphaBackgroundColor = 1,
					radiaDirectionsNew   = { 'bottom': 'center bottom', 'bottom center': 'center bottom', 'left': 'left center', 'right': 'right center', 'top': 'center top', 'center': 'center center', 'center left': 'left center' },
					borderSize;

				// Correct radial direction params.
				if ( 'undefined' !== typeof params.radial_direction && ( params.radial_direction in radiaDirectionsNew ) ) {
					params.radial_direction = radiaDirectionsNew[ params.radial_direction ];
				}

				// No align self set but ignore equal heights is on.
				if ( 'undefined' === typeof params.align_self && 'undefined' !== typeof params.min_height && 'none' === params.min_height ) {
					params.align_self = 'flex-start';
				}

				// No align content set, but legacy center_content is on.
				if ( 'undefined' === typeof params.align_content && 'undefined' !== typeof params.center_content && 'yes' === params.center_content ) {
					params.align_content = 'center';
				}

				// Border sizes.
				if ( ( 'undefined' === typeof params.border_sizes_top || 'undefined' === typeof params.border_sizes_bottom || 'undefined' === typeof params.border_sizes_left || 'undefined' === typeof params.border_sizes_right ) && 'string' === typeof params.border_size ) {
					switch ( params.border_position ) {
						case 'all':
							borderSize = _.fusionGetValueWithUnit( params.border_size );
							params.border_sizes_top    = borderSize;
							params.border_sizes_bottom = borderSize;
							params.border_sizes_left   = borderSize;
							params.border_sizes_right  = borderSize;
							break;

						default:
							params[ 'border_sizes_' + params.border_position ] = _.fusionGetValueWithUnit( params.border_size );
					}

					delete params.border_size;
				}

				this.model.set( 'params', params );
			},

			/**
			 * Handle margin adjustments on drag.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			marginDrag: function() {
				var $el            = this.$el,
					self           = this,
					directions     = { top: 's', bottom: 's' },
					parentWidth    = 'fusion_builder_column_inner' === this.model.get( 'type' ) ? $el.closest( '.fusion-builder-row-container-inner' ).width() : $el.closest( '.fusion-row' ).width(),
					isFlex         = false,
					$spacers       = this.$el.find( '> .fusion-column-wrapper > .fusion-column-spacers, > .fusion-column-margins' );

				// If flex we also use left and right.
				if ( 'undefined' !== typeof this.isFlex && true === this.isFlex ) {
					directions = { top: 's', bottom: 's', left: 'e', right: 'w' };
					isFlex     = true;
				}

				// If class is set, do not init again.
				if ( this.$el.hasClass( 'resizable-active' ) ) {
					return;
				}

				_.each( directions, function( handle, direction )  {
					var optionKey       = FusionApp.getResponsiveOptionKey( 'top' === direction || 'bottom' === direction ? 'margin_' + direction : 'spacing_' + direction, self.isFlex ),
						actualDimension = self.values[ optionKey ],
						percentSpacing  = false;

					// No value, use half column spacing (not upsized).
					if ( ! actualDimension || '' === actualDimension ) {
						if ( isFlex &&
							( 'top' === direction || 'bottom' === direction ) &&
							self.values[ 'margin_' + direction ] ) {
							actualDimension = self.values[ 'margin_' + direction ];
						} else {
							actualDimension = self.getHalfSpacing();
						}
					}

					// Check if using a percentage.
					percentSpacing = -1 !== actualDimension.indexOf( '%' );

					// If percentage, get the actual px dimension.
					if ( percentSpacing ) {
						actualDimension = ( parentWidth / 100 ) * parseFloat( actualDimension );
					}

					// Overlap checks.
					if ( 'bottom' === direction ) {
						if ( 20 > parseInt( actualDimension, 10 ) ) {
							$spacers.find( '.fusion-column-margin-bottom, .fusion-column-padding-bottom' ).addClass( 'fusion-overlap' );
						} else {
							$spacers.find( '.fusion-column-margin-bottom, .fusion-column-padding-bottom' ).removeClass( 'fusion-overlap' );
						}
					}

					// Find element and display it.
					self.marginResize[ direction ] = $spacers.find( '.fusion-column-margin-' + direction );
					self.marginResize[ direction ].css( 'display', 'block' );

					// Set initial width or height.
					if ( 'left' === direction || 'right' === direction ) {
						self.marginResize[ direction ].width( actualDimension );
					} else {
						self.marginResize[ direction ].height( actualDimension );
					}

					// Init resizable.
					self.marginResize[ direction ].resizable( {
						handles: handle,
						minHeight: 0,
						minWidth: 0,
						grid: ( percentSpacing ) ? [ parentWidth / 1000, 10 ] : '',
						resize: function( event, ui ) {
							var optionKey      = FusionApp.getResponsiveOptionKey( 'top' === direction || 'bottom' === direction ? 'margin_' + direction : 'spacing_' + direction, self.isFlex ),
								percentSpacing = 'undefined' !== typeof self.values[ optionKey ] ? -1 !== self.values[ optionKey ].indexOf( '%' ) : false,
								$resizer       = jQuery( ui.element ),
								value          = 'top' === direction || 'bottom' === direction ? ui.size.height : ui.size.width;

							// If nothing is set and left and right, check row column spacing
							if ( '' === self.values[ optionKey ] && ( 'left' === direction || 'right' === direction ) ) {
								percentSpacing =  -1 !== self.getHalfSpacing().indexOf( '%' );
							}

							// Active class to prevent multiple inits.
							$resizer.closest( '.fusion-builder-column:not( .resizable-active )' ).addClass( 'resizable-active' );

							// Work out value.
							value = 0 > value ? 0 : value;
							value = value + 'px';
							if ( percentSpacing ) {
								value = 0 === parseFloat( value ) ? '0%' : ( Math.round( parseFloat( parseFloat( value ) / ( parentWidth / 1000 ) ) ) / 10 ) + '%';
							}

							// Bottom margin overlap
							if ( 'bottom' === direction ) {
								if ( 20 > ui.size.height ) {
									$resizer.addClass( 'fusion-overlap' );
									$spacers.find( '.fusion-column-padding-bottom' ).addClass( 'fusion-overlap' );
								} else {
									$resizer.removeClass( 'fusion-overlap' );
									$spacers.find( '.fusion-column-padding-bottom' ).removeClass( 'fusion-overlap' );
								}
							}

							// Display tooltip.
							$resizer.find( '.fusion-spacing-tooltip, .fusion-column-spacing' ).addClass( 'active' );
							$resizer.find( '.fusion-spacing-tooltip' ).text( value );

							// Update open settings modal.
							self.updateDragSettings( '#' + optionKey, value );
						},
						stop: function( event, ui ) {
							var $resizer = jQuery( ui.element );

							$resizer.closest( '.fusion-builder-column' ).removeClass( 'resizable-active' );
							$resizer.find( '.fusion-spacing-tooltip, .fusion-column-spacing' ).removeClass( 'active' );

							// Delete all spacing resizable within because parent width has changed.
							if ( $resizer.find( '.fusion-builder-column-inner'  ).find( '.fusion-element-spacing .ui-resizable' ).length ) {
								$resizer.closest( '.fusion-builder-column-inner'  ).find( '.fusion-element-spacing .ui-resizable' ).resizable( 'destroy' );
							}
						}
					} );
				} );
			},

			/**
			 * Handle padding adjustments on drag.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			paddingDrag: function() {
				var $el            = this.$el,
					self           = this,
					directions     = { top: 's', right: 'w', bottom: 's', left: 'e' },
					percentSpacing = false,
					parentWidth    = $el.find( '> .fusion-column-wrapper' ).first().width(),
					$spacers	   = this.$el.find( '> .fusion-column-wrapper > .fusion-column-spacers, > .fusion-column-margins' ),
					valueAllowed   = ( parentWidth / 100 ),
					isFlex         = false,
					value,
					actualDimension;

				if ( this.$el.hasClass( 'resizable-active' ) ) {
					return;
				}

				if ( 'undefined' !== typeof this.isFlex && true === this.isFlex ) {
					isFlex = true;
				}

				_.each( directions, function( handle, direction )  {
					var optionKey       = FusionApp.getResponsiveOptionKey( 'padding_' + direction, isFlex ),
						actualDimension = self.values[ optionKey ] || self.values[ 'padding_' + direction ],
						percentSpacing  = false;

					if ( ! isFlex && ! actualDimension ) {
						actualDimension = '0px';
					}

					// Check if using a percentage.
					percentSpacing = 'undefined' !== typeof actualDimension ? -1 !== actualDimension.indexOf( '%' ) : false;

					if ( percentSpacing ) {

						// Get actual dimension and set.
						actualDimension = ( parentWidth / 100 ) * parseFloat( actualDimension );
					}

					if ( 'bottom' !== direction && ( isFlex || 'top' === direction ) ) {
						if ( 20 > parseInt( actualDimension, 10 ) ) {
							$spacers.find( '.fusion-column-margin-' + direction + ', .fusion-column-padding-' + direction ).addClass( 'fusion-overlap' );
						} else {
							$spacers.find( '.fusion-column-margin-' + direction + ', .fusion-column-padding-' + direction ).removeClass( 'fusion-overlap' );
						}
					}

					self.paddingResize[ direction ] = $spacers.find( '.fusion-column-padding-' + direction );
					self.paddingResize[ direction ].css( 'display', 'block' );
					if ( 'top' === direction || 'bottom' === direction ) {
						self.paddingResize[ direction ].height( actualDimension );
					} else {
						self.paddingResize[ direction ].width( actualDimension );
					}

					self.paddingResize[ direction ].resizable( {
						handles: handle,
						minHeight: 0,
						minWidth: 0,

						resize: function( event, ui ) {
							var optionKey 		= FusionApp.getResponsiveOptionKey( 'padding_' + direction, isFlex ),
								actualDimension = self.values[ optionKey ],
								dimension 		= 'top' === direction || 'bottom' === direction ? 'height' : 'width',
								$resizer  		= jQuery( ui.element );

							// Recheck in case unit is changed in the modal.
							percentSpacing = 'undefined' !== typeof actualDimension ? -1 !== actualDimension.indexOf( '%' ) : false;

							// Force to grid amount.
							if ( percentSpacing ) {
								ui.size[ dimension ] = Math.round( ui.size[ dimension ] / valueAllowed ) * valueAllowed;
							}

							$resizer.closest( '.fusion-builder-column' ).addClass( 'resizable-active' );

							// Change format of value.
							value = ui.size[ dimension ];
							value = 0 > value ? 0 : value;
							value = value + 'px';
							if ( percentSpacing ) {
								value = 0 === parseFloat( value ) ? '0%' : Math.round( parseFloat( parseFloat( value ) / ( parentWidth / 100 ) ) ) + '%';
							}

							// Overlaps top left, right.
							if ( 'top' === direction ) {
								if ( 20 > ui.size.height ) {
									$resizer.addClass( 'fusion-overlap' );
									$spacers.find( '.fusion-column-margin-top' ).addClass( 'fusion-overlap' );
								} else {
									$resizer.removeClass( 'fusion-overlap' );
									$spacers.find( '.fusion-column-margin-top' ).removeClass( 'fusion-overlap' );
								}
							} else if ( 'right' === direction ) {
								if ( 20 > ui.size.width && ( isFlex || 20 > $spacers.find( '.fusion-column-spacing .fusion-spacing-value' ).width() ) ) {
									$resizer.addClass( 'fusion-overlap' );
									$spacers.find( '.fusion-column-spacing, .fusion-column-margin-right' ).addClass( 'fusion-overlap' );
								} else {
									$resizer.removeClass( 'fusion-overlap' );
									$spacers.find( '.fusion-column-spacing, .fusion-column-margin-right' ).removeClass( 'fusion-overlap' );
								}
							} else if ( 'left' === direction && isFlex ) {
								if ( 20 > ui.size.width ) {
									$resizer.addClass( 'fusion-overlap' );
									$spacers.find( '.fusion-column-margin-left' ).addClass( 'fusion-overlap' );
								} else {
									$resizer.removeClass( 'fusion-overlap' );
									$spacers.find( '.fusion-column-margin-left' ).removeClass( 'fusion-overlap' );
								}
							}

							// Set values.
							$resizer.find( '.fusion-spacing-tooltip, .fusion-column-spacing' ).addClass( 'active' );
							$resizer.find( '.fusion-spacing-tooltip' ).text( value );

							// Update open modal.
							self.updateDragSettings( '#' + optionKey, value );
						},
						stop: function( event, ui ) {
							var $resizer = jQuery( ui.element );

							$resizer.closest( '.fusion-builder-column' ).removeClass( 'resizable-active' );
							$resizer.find( '.fusion-spacing-tooltip, .fusion-column-spacing' ).removeClass( 'active' );

							// Delete all spacing resizable within because parent width has changed.
							if ( $resizer.find( '.fusion-builder-column-inner'  ).find( '.fusion-element-spacing .ui-resizable' ).length ) {
								$resizer.closest( '.fusion-builder-column-inner'  ).find( '.fusion-element-spacing .ui-resizable' ).resizable( 'destroy' );
							}
						}
					} );
				} );
			},

			/**
			 * Destroy column's resizables.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			destroyResizable: function() {
				this.destroySpacingResizable();
				this.destroyMarginResizable();
				this.destroyPaddingResizable();
			},

			/**
			 * Destroy column's spacing resizable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			destroySpacingResizable: function() {
				var $columnSpacer;

				$columnSpacer = this.$el.find( '> .fusion-column-spacing .fusion-spacing-value' );

				if ( $columnSpacer.hasClass( 'ui-resizable' ) ) {
					$columnSpacer.resizable( 'destroy' );
					$columnSpacer.hide();
					this.columnSpacer = false;
				}
			},

			/**
			 * Destroy column's margin resizable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			destroyMarginResizable: function() {
				_.each( this.marginResize, function( $marginResize ) {
					if ( $marginResize.length && $marginResize.hasClass( 'ui-resizable' ) &&  -1 !== $marginResize.attr( 'class' ).indexOf( 'fusion-column-margin-' ) ) {
						$marginResize.resizable( 'destroy' );
						$marginResize.hide();
					}
				} );

			},

			/**
			 * Destroy column's padding resizable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			destroyPaddingResizable: function() {

				_.each( this.paddingResize, function( $paddingResize ) {
					if ( $paddingResize.length && $paddingResize.hasClass( 'ui-resizable' ) &&  -1 !== $paddingResize.attr( 'class' ).indexOf( 'fusion-column-padding-' ) ) {
						$paddingResize.resizable( 'destroy' );
						$paddingResize.hide();
					}
				} );
			},

			/**
			 * Changes the column spacing.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			columnSpacing: function( event ) {
				var percentSpacing  = false,
					$el             = this.$el,
					self            = this,
					$spacers        = this.$el.find( '> .fusion-column-wrapper > .fusion-column-spacers' ),
					marginDirection = FusionPageBuilderApp.$el.hasClass( 'rtl' ) ? 'left' : 'right',
					parentWidth,
					marginRight,
					container,
					columnSpacing,
					existingSpacing,
					modelSpacing,
					$columnSpacer,
					maxWidth,
					rightPadding,
					rightOverlap;

				// We don't need column spacing when flex container is used.
				if ( 'undefined' !== typeof this.isFlex && true === this.isFlex ) {
					return;
				}

				$columnSpacer = this.$el.find( '> .fusion-column-spacing .fusion-spacing-value' );

				if ( event && 'event' !== event ) {
					event.preventDefault();
				}

				// If responsive mode and columns are 1/1 hide and return.
				if ( jQuery( '#fb-preview' ).width() < FusionApp.settings.content_break_point && FusionApp.settings.responsive ) {
					$columnSpacer.hide();
					return;
				}

				$columnSpacer.show();

				// If this is the last column in a virtual row, then no handles.
				if ( this.$el.hasClass( 'fusion-column-last' ) ) {
					return;
				}

				// No resizer for fallback method.
				if ( 'yes' === this.model.attributes.params.spacing || 'no' === this.model.attributes.params.spacing ) {
					return;
				}

				existingSpacing = this.model.attributes.params.spacing;
				if ( 'undefined' === typeof existingSpacing || '' === existingSpacing ) {
					existingSpacing = '4%';
				}
				if ( 'no' === existingSpacing ) {
					existingSpacing = '0';
				}

				// Already created spacer and not %, no need to continue.
				if ( this.columnSpacer && -1 === existingSpacing.indexOf( '%' ) ) {
					return;
				}

				// Get the container width.
				container = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );

				if ( 'fusion_builder_column_inner' === this.model.get( 'type' ) ) {
					parentWidth = container.$el.find( '.fusion-builder-row-container-inner' ).width();
				} else {
					parentWidth = container.$el.find( '.fusion-row' ).width();
				}

				// Already created spacer, % is being used and width is the same, no need to continue.
				if ( this.columnSpacer && parentWidth === this.parentWidth ) {
					return;
				}

				// Store parent width to compare.
				this.parentWidth = parentWidth;

				// Get the column right margin.  In real usage use the model attribute.
				columnSpacing = existingSpacing;
				marginRight   = existingSpacing;

				// Set column spacing width.
				if ( -1 !== existingSpacing.indexOf( '%' ) ) {
					percentSpacing = true;
					marginRight    = parseFloat( marginRight ) / 100.0;
					columnSpacing  = marginRight * parentWidth;
				}

				// Set max width spacing.
				maxWidth = parentWidth - 100;

				// Destroy in case it's already active
				if ( $columnSpacer.hasClass( 'ui-resizable' ) ) {
					$columnSpacer.resizable( 'destroy' );
				}

				$columnSpacer.width( columnSpacing );

				$columnSpacer.resizable( {
					handles: FusionPageBuilderApp.$el.hasClass( 'rtl' ) ? 'w' : 'e',
					minWidth: 0,
					maxWidth: maxWidth,
					grid: ( percentSpacing ) ? [ parentWidth / 100, 10 ] : '',
					create: function() {
						if ( 0 === $el.find( '> .fusion-column-spacing .fusion-spacing-value' ).width() ) {
							$el.find( '> .fusion-column-spacing' ).addClass( 'empty' );
						} else if ( $el.find( '> .fusion-column-spacing.empty' ).length ) {
							$el.find( '> .fusion-column-spacing' ).removeClass( 'empty' );
						}
					},
					resize: function( event, ui ) {

						ui.size.width = 0 > ui.size.width ? 0 : ui.size.width;

						if ( 0 === modelSpacing ) {
							$el.find( '> .fusion-column-spacing' ).addClass( 'empty' );
						} else if ( $el.find( '> .fusion-column-spacing.empty' ).length ) {
							$el.find( '> .fusion-column-spacing' ).removeClass( 'empty' );
						}
						modelSpacing = ui.size.width + 'px';
						if ( percentSpacing ) {
							modelSpacing = Math.round( parseFloat( ui.size.width / ( parentWidth / 100 ) ) ) + '%';
						}
						$el.css( 'margin-' + marginDirection, modelSpacing );

						// Update open modal.
						if ( jQuery( '[data-element-cid="' + self.model.get( 'cid' ) + '"]' ).length ) {
							jQuery( '[data-element-cid="' + self.model.get( 'cid' ) + '"] [data-option-id="spacing"] #spacing' ).val( modelSpacing ).trigger( 'change' );
						}

						$el.find( '> .fusion-column-spacing .fusion-spacing-tooltip, > .fusion-column-spacing' ).addClass( 'active' );
						$el.find( '> .fusion-column-spacing .fusion-spacing-tooltip' ).text( modelSpacing );
						$el.addClass( 'active-drag' );
						self._toolTipHide();

						// Right padding overlap.
						if ( 20 > ui.size.width && 20 > $spacers.find( '.fusion-column-padding-' + marginDirection ).width() ) {
							jQuery( ui.element ).parent().addClass( 'fusion-overlap' );
							$spacers.find( '.fusion-column-padding-' + marginDirection ).addClass( 'fusion-overlap' );
						} else {
							jQuery( ui.element ).parent().removeClass( 'fusion-overlap' );
							$spacers.find( '.fusion-column-padding-' + marginDirection ).removeClass( 'fusion-overlap' );
						}
					},
					stop: function( event, ui ) { // jshint ignore: line
						$el.removeClass( 'active-drag' );
					}
				} );

				rightPadding = 'undefined' === typeof this.model.attributes.params.padding_right || '' === this.model.attributes.params.padding_right ? '0px' : this.model.attributes.params.padding_right;
				rightOverlap = ( 20 > parseInt( rightPadding, 10 ) && ( '0%' === rightPadding || -1 === rightPadding.indexOf( '%' ) ) && ( 20 > parseInt( columnSpacing, 10 ) ) ) ? 'fusion-overlap' : '';

				if ( '' !== rightOverlap ) {
					$spacers.find( '.fusion-column-padding-right' ).addClass( 'fusion-overlap' );
					$el.find( '> .fusion-column-spacing' ).addClass( 'fusion-overlap' );
				} else {
					$spacers.find( '.fusion-column-padding-right' ).removeClass( 'fusion-overlap' );
					$el.find( '> .fusion-column-spacing' ).removeClass( 'fusion-overlap' );
				}

				// Column spacer created
				this.columnSpacer = true;
			},

			/**
			 * Changes the size of a column.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the change in size.
			 * @return {void}
			 */
			sizeSelect: function( event ) {
				var columnSize,
					fractionSize,
					container	= FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) ),
					viewport	= jQuery( '#fb-preview' ).attr( 'data-viewport' ),
					index		= [ 'desktop', 'tablet', 'mobile' ].findIndex( function ( vp ) {
						return viewport.includes( vp );
					} ),
					widthKeys	= [ 'type', 'type_medium', 'type_small' ];

				if ( event ) {
					event.preventDefault();
				}

				columnSize = jQuery( event.target ).data( 'column-size' );

				// Check if there's a setings view and verifify if it's the one corresponding to this element.
				if ( FusionPageBuilderApp.SettingsHelpers.openSettingsView && FusionPageBuilderApp.SettingsHelpers.openSettingsView.model.cid === this.model.cid ) {

					if ( FusionPageBuilderApp.SettingsHelpers.openSettingsView.tabsRendered.design ) {
						return jQuery( FusionPageBuilderApp.SettingsHelpers.openSettingsView.$el
							.find( '.ui-button[data-value="' + columnSize + '"]' )[ index ] )
							.trigger( 'click' );
					}
					jQuery( FusionPageBuilderApp.SettingsHelpers.openSettingsView.$el
							.find( '.width-value' )[ index ] ).val( columnSize );
				}

				// Update model.
				this.model.attributes.params[ widthKeys[ index ] ] = columnSize;

				this.$el.find( '.column-sizes' ).hide();
				this.$el.removeClass( 'active' );
				this.$el.attr( 'data-column-size', columnSize );

				fractionSize = columnSize.replace( '_', '/' );

				// Necessary for re-sizing then cloning.
				this.reRender();

				container.setRowData();

				if ( 'fusion_builder_column_inner' !== this.model.get( 'type' ) ) {
					this.renderSectionSeps();
				}

				this.$el.find( '.column-sizes .column-size' ).removeClass( 'active-size' );
				this.$el.find( '.column-size-' + columnSize ).addClass( 'active-size' );

				this.$el.closest( '.fusion-builder-container' ).removeClass( 'fusion-column-sizer-active' );

				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-column-resized', this.model.get( 'cid' ) );
				FusionEvents.trigger( 'fusion-column-resized' );

				// Save history state
				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.resized_column + ' ' + fractionSize );
			},

			/**
			 * Checks if the value is in pixels.
			 *
			 * @since 2.0.0
			 * @param {string} value - The value we want to check.
			 * @return {boolean}
			 */
			pxCheck: function( value ) {
				if ( 'undefined' === typeof value ) {
					return false;
				}

				// If 0, then consider valid.
				if ( '0' === value || 0 === value ) {
					return true;
				}

				return ( -1 !== value.indexOf( 'px' ) ) ? true : false;
			},

			/**
			 * Checks if the value is using %.
			 *
			 * @since 2.0.0
			 * @param {string} value - The value we want to check.
			 * @return {boolean}
			 */
			percentageCheck: function( value ) {
				if ( 'undefined' === typeof value ) {
					return false;
				}

				// If 0, then consider valid.
				if ( '0' === value || 0 === value ) {
					return true;
				}

				return ( -1 !== value.indexOf( '%' ) ) ? true : false;
			},

			/**
			 * Adds 2 values.
			 *
			 * @since 2.0.0
			 * @param {string|number|double} a - The 1st value.
			 * @param {string|number|double} b - The 2nd value.
			 * @return {number}
			 */
			addValues: function( a, b ) {
				return parseFloat( a ) + parseFloat( b );
			},

			/**
			 * Add a module.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the module addition.
			 * @return {void}
			 */
			addModule: function( event ) {
				var view,
					viewSettings,
					closestParent;

				if ( event ) {
					event.preventDefault();
					event.stopPropagation();
					FusionPageBuilderApp.sizesHide( event );
				}

				FusionPageBuilderApp.parentColumnId = this.model.get( 'cid' );

				viewSettings = {
					model: this.model,
					collection: this.collection,
					view: this,
					attributes: {
						'data-parent_cid': this.model.get( 'cid' )
					}
				};

				if ( ! jQuery( event.currentTarget ).closest( '.fusion-builder-empty-column' ).length && ! FusionPageBuilderApp.wireframeActive ) {
					closestParent = jQuery( event.currentTarget ).closest( '.fusion-builder-live-element' );
					if ( closestParent.length ) {
						viewSettings.targetElement = closestParent;
					} else {
						viewSettings.targetElement = jQuery( event.currentTarget ).closest( '.fusion-builder-nested-element' );
					}
				}

				view = new FusionPageBuilder.ElementLibraryView( viewSettings );

				jQuery( view.render().el ).dialog( {
					title: 'Select Element',
					draggable: false,
					modal: true,
					resizable: false,
					dialogClass: 'fusion-builder-dialog fusion-builder-large-library-dialog fusion-builder-element-library-dialog',

					resizeStart: function( event, ui ) {
						FusionApp.dialog.addResizingClasses();
					},

					resizeStop: function( event, ui ) {
						FusionApp.dialog.removeResizingClasses();
					},

					open: function( event, ui ) { // jshint ignore: line
						FusionApp.dialog.resizeDialog();

						// On start can sometimes be laggy/late.
						FusionApp.dialog.addResizingHoverEvent();
					},
					close: function( event, ui ) { // jshint ignore: line
						view.remove();
					}
				} );
			},

			/**
			 * Get dynamic values.
			 *
			 * @since 2.0.0
			 * @return {Object}
			 */
			getDynamicAtts: function( values ) {
				var self = this;

				if ( 'undefined' !== typeof this.dynamicParams && this.dynamicParams && ! _.isEmpty( this.dynamicParams.getAll() ) ) {
					_.each( this.dynamicParams.getAll(), function( data, id ) {
						var value = self.dynamicParams.getParamValue( data );

						if ( 'undefined' !== typeof value && false !== value ) {
							values[ id ] = value;
						}
					} );
				}
				return values;
			},

			/**
			 * Get the template.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getTemplate: function() {
				var atts = this.getTemplateAtts();
				return this.template( atts );
			},

			setArgs: function() {
				var params = jQuery.extend( true, {}, this.model.get( 'params' ) ),
					values;

				// Make sure initial width is correctly inherited.
				if ( 'undefined' === typeof params.type ) {
					params.type = this.model.attributes.params.type;
				}

				if ( fusionAllElements[ this.model.get( 'type' ) ] ) {
					values = jQuery.extend( true, {}, fusionAllElements[ this.model.get( 'type' ) ].defaults, _.fusionCleanParameters( params ) );
				}

				// If no blend mode is defined, check if we should set to overlay.
				if ( 'undefined' === typeof params.background_blend_mode && '' !== params.background_color && 1 > values.alpha_background_color && 0 !== values.alpha_background_color && '' !== params.background_image ) {
					values.background_blend_mode = 'overlay';
				}

				// If padding (combined all 4) is not set in params, then use individual variables.
				if ( 'undefined' === typeof params.padding ) {
					values = _.fusionGetPadding( values );
				}

				this.values = this.getDynamicAtts( values );
			},

			validateArgs: function() {
				var borderRadius;

				// Alpha related checks.
				this.values.alpha_background_color     = jQuery.Color( this.values.background_color ).alpha();
				this.values.alpha_gradient_start_color = jQuery.Color( this.values.gradient_start_color ).alpha();
				this.values.alpha_gradient_end_color   = jQuery.Color( this.values.gradient_end_color ).alpha();

				if ( '' !== this.values.margin_bottom ) {
					this.values.margin_bottom = _.fusionGetValueWithUnit( this.values.margin_bottom );
				}
				if ( '' !== this.values.margin_top ) {
					this.values.margin_top = _.fusionGetValueWithUnit( this.values.margin_top );
				}

				if ( this.values.border_size ) {
					this.values.border_size = _.fusionValidateAttrValue( this.values.border_size, 'px' );
				}

				if ( '' !== this.values.padding ) {
					this.values.padding = _.fusionGetValueWithUnit( this.values.padding );
				}

				if ( '' !== this.values.border_sizes_top ) {
					this.values.border_sizes_top = _.fusionGetValueWithUnit( this.values.border_sizes_top );
				}

				if ( '' !== this.values.border_sizes_bottom ) {
					this.values.border_sizes_bottom = _.fusionGetValueWithUnit( this.values.border_sizes_bottom );
				}

				if ( '' !== this.values.border_sizes_top ) {
					this.values.border_sizes_left = _.fusionGetValueWithUnit( this.values.border_sizes_left );
				}

				if ( '' !== this.values.border_sizes_top ) {
					this.values.border_sizes_right = _.fusionGetValueWithUnit( this.values.border_sizes_right );
				}


				// Border radius validation.
				this.values.border_radius_top_left     = this.values.border_radius_top_left ? _.fusionGetValueWithUnit( this.values.border_radius_top_left ) : '0px';
				this.values.border_radius_top_right    = this.values.border_radius_top_right ? _.fusionGetValueWithUnit( this.values.border_radius_top_right ) : '0px';
				this.values.border_radius_bottom_left  = this.values.border_radius_bottom_left ? _.fusionGetValueWithUnit( this.values.border_radius_bottom_left ) : '0px';
				this.values.border_radius_bottom_right = this.values.border_radius_bottom_right ? _.fusionGetValueWithUnit( this.values.border_radius_bottom_right ) : '0px';
				borderRadius                           = this.values.border_radius_top_left + ' ' + this.values.border_radius_top_right + ' ' + this.values.border_radius_bottom_right + ' ' + this.values.border_radius_bottom_left;
				this.values.border_radius              = '0px 0px 0px 0px' === borderRadius ? '' : borderRadius;

				this.values.border_position = 'all' !== this.values.border_position ? '-' + this.values.border_position : '';

			},

			validatePercentageMargin: function( value, columnSize, values ) {
				value      = 'undefined' === typeof value ? '' :  value;
				columnSize = 'undefined' === typeof columnSize ? 1 : columnSize;
				values     = 'undefined' === typeof values ? this.values : values;

				// If value is in percentage and not calc, make it relative to container.
				if ( 0 < parseFloat( columnSize ) &&  -1 !== value.indexOf( '%' ) && -1 === value.indexOf( 'calc' ) ) {
					// If all are in % just work it out.
					if ( -1 !== values.column_spacing.indexOf( '%' ) && -1 === values.column_spacing.indexOf( 'calc' ) ) {
						return ( parseFloat( value ) / parseFloat( columnSize ) / 100 * ( 100 - parseFloat( values.column_spacing ) ) ) + '%';
					}

						// Not all % then we need to use calc.
						return 'calc( ' + ( parseFloat( value ) / parseFloat( columnSize ) / 100 ) + ' * calc( 100% - ' + values.column_spacing + ' ) )';

				}
				return value;
			},

			setExtraArgs: function() {

				var container = FusionPageBuilderApp.getParentContainer( this.model.get( 'parent' ) ),
					containerParams,
					containerValues;

				this.values.flex             = false;
				this.values.column_spacing   = '4%';
				this.values.flex_align_items = 'flex-start';
				if ( 'object' === typeof container ) {
					containerParams              = _.fusionCleanParameters( container.model.get( 'params' ) );
					containerValues              = jQuery.extend( true, {}, fusionAllElements.fusion_builder_container.defaults, containerParams );
					this.values.flex             = 'flex' === containerValues.type;
					this.values.column_spacing   = containerValues.flex_column_spacing;
					this.values.flex_align_items = containerValues.flex_align_items;
				}

				this.values.column_counter = this.model.get( 'cid' );

				this.values.hover_or_link = ( 'none' !== this.values.hover_type && '' !== this.values.hover_type ) || '' !== this.values.link;

				this.values.shortcode_classname = 'fusion_builder_column' === this.model.get( 'type' ) ? 'fusion-builder-live-column' : 'fusion-builder-live-nested-column';

				// Store for later use.
				this.isFlex = this.values.flex;
			},

			setColumnMapData: function() {
				var self = this,
					containerSpacingOffset,
					unitlessSpacing,
					unitlessHalf,
					halfSpacing,
					emptyOffset,
					container,
					currentRow,
					containerRows,
					spacings,
					total,
					lastIndex,
					model,
					columnSpacing,
					widthKey,
					spacingLeftKey,
					spacingRightKey,
					extras;

				// If we are flex, we do not have a column map.
				if ( this.values.flex ) {
					this.setColumnSize();

					extras = jQuery.extend( true, {}, fusionAllElements.fusion_builder_column.extras );

					// Medium inherit from large or validate if set.
					if ( '' === this.values.type_medium || 0 === parseFloat( this.values.type_medium ) ) {
						this.values.type_medium = 'inherit_from_large' === extras.col_width_medium ? this.values.column_size : 1;
					} else {
						this.values.type_medium = this.validateColumnSize( this.values.type_medium );
					}

					// Small default to 1 or validate if set.
					if ( '' === this.values.type_small || 0 === parseFloat( this.values.type_small ) ) {
						this.values.type_small = 'inherit_from_large' === extras.col_width_small ? this.values.column_size : 1;
					} else {
						this.values.type_small = this.validateColumnSize( this.values.type_small );
					}

					// Full width medium, inherit from large if set.
					if ( 1 !== parseInt( this.values.type_medium ) ) {
						if ( '' === this.values.spacing_left_medium ) {
							this.values.spacing_left_medium = this.values.spacing_left;
						}
						if ( '' === this.values.spacing_right_medium ) {
							this.values.spacing_right_medium = this.values.spacing_right;
						}
					}

					// Full width small, inherit from medium or large if set.
					if ( 1 !== parseInt( this.values.type_small ) ) {
						if ( '' === this.values.spacing_left_small ) {
							this.values.spacing_left_small = '' !== this.values.spacing_left_medium ? this.values.spacing_left_medium : this.values.spacing_left;
						}
						if ( '' === this.values.spacing_right_small ) {
							this.values.spacing_right_small = '' !== this.values.spacing_right_medium ? this.values.spacing_right_medium : this.values.spacing_right;
						}
					}

					// Half the spacing on container.
					halfSpacing = this.getHalfSpacing();

					// Validate left and right margins that are set.
					_.each( [ 'large', 'medium', 'small' ], function( width ) {

						// Need to calc for each because column width may be different and that changes things.
						widthKey    = 'large' === width ? 'column_size' : 'type_' + width;
						emptyOffset = self.validatePercentageMargin( halfSpacing, self.values[ widthKey ] );

						// We have a value, validate it, else we use the empty offset.
						spacingLeftKey = 'large' === width ? 'spacing_left' : 'spacing_left_' + width;
						if ( '' !== self.values[ spacingLeftKey ] ) {
							self.values[ 'upsized_' + spacingLeftKey ] = self.validatePercentageMargin( self.values[ spacingLeftKey ], self.values[ widthKey ] );
						} else {
							self.values[ 'upsized_' + spacingLeftKey ] = emptyOffset;
						}

						spacingRightKey = 'large' === width ? 'spacing_right' : 'spacing_right_' + width;
						if ( '' !== self.values[ spacingRightKey ] ) {
							self.values[ 'upsized_' + spacingRightKey ] = self.validatePercentageMargin( self.values[ spacingRightKey ], self.values[ widthKey ] );
						} else {
							self.values[ 'upsized_' + spacingRightKey ] = emptyOffset;
						}
					} );

					return;
				}

				container     = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
				containerRows = container.model.get( 'rows' );
				currentRow    = container.getVirtualRowByCID( this.model.get( 'cid' ) );

				if ( 'yes' === this.values.spacing || '' === this.values.spacing ) {
					this.values.spacing = '4%';
				} else if ( 'no' === this.values.spacing ) {
					this.values.spacing = '0px';
				}

				this.values.spacing                   = _.fusionGetValueWithUnit( this.values.spacing );
				this.values.widthOffset               = '';
				this.values.currentRowNumberOfColumns = false;

				function fallbackCheck( value ) {
					return ( 'yes' === value || 'no' === value );
				}

				// Pop off the last because it can't have spacing.
				if ( 'undefined' !== typeof currentRow ) {

					// currentRow = currentRow.slice( 0, -1 );
					this.values.currentRowNumberOfColumns = currentRow.length + 1;
				}

				this.values.fallback = false;
				if ( 'object' === typeof currentRow ) {
					this.values.fallback = currentRow.every( fallbackCheck );
				}

				this.setColumnSize();

				// Nested column check
				if ( 'object' === typeof currentRow ) {
					spacings  = [];
					total     = currentRow.length;
					lastIndex = total - 1;

					_.each( currentRow, function( column, index ) {

						if ( lastIndex !== index ) {
							model = container.model.children.find( function( model ) {
								return model.get( 'cid' ) == column.cid; // jshint ignore: line
							} );

							columnSpacing = model.attributes.params.spacing;
							columnSpacing = ( 'undefined' === typeof columnSpacing || '' === columnSpacing ) ? '4%' : columnSpacing;

							spacings.push( columnSpacing );
						}

						if ( 1 === total ) {
							spacings.push( '' );
						}

					} );

					spacings = spacings.join( ' + ' );

					// If no fallback make sure to replace mixed values.
					if ( ! this.values.fallback ) {
						spacings = spacings.replace( /yes/g, '4%' ).replace( /no/g, '0%' );
					}
					this.values.widthOffset = '( ( ' + spacings + ' ) * ' + this.values.column_size + ' ) ';
				}

				this.setSpacingStyling();
			},

			getHalfSpacing: function () {
				var unitlessSpacing = parseFloat( this.values.column_spacing ),
					unitlessHalf    = unitlessSpacing / 2;

				return this.values.column_spacing.replace( unitlessSpacing, unitlessHalf );
			},

			setColumnSize: function() {
				var sizeClass;

				// Column size value
				switch ( this.values.type ) {
				case '1_1':
					sizeClass  = 'fusion-one-full';
					break;
				case '1_4':
					sizeClass  = 'fusion-one-fourth';
					break;
				case '3_4':
					sizeClass  = 'fusion-three-fourth';
					break;
				case '1_2':
					sizeClass  = 'fusion-one-half';
					break;
				case '1_3':
					sizeClass  = 'fusion-one-third';
					break;
				case '2_3':
					sizeClass  = 'fusion-two-third';
					break;
				case '1_5':
					sizeClass  = 'fusion-one-fifth';
					break;
				case '2_5':
					sizeClass  = 'fusion-two-fifth';
					break;
				case '3_5':
					sizeClass  = 'fusion-three-fifth';
					break;
				case '4_5':
					sizeClass  = 'fusion-four-fifth';
					break;
				case '5_6':
					sizeClass  = 'fusion-five-sixth';
					break;
				case '1_6':
					sizeClass  = 'fusion-one-sixth';
					break;
				}

				this.values.column_size = this.validateColumnSize( this.values.type );
				this.values.size_class  = sizeClass;
			},

			validateColumnSize: function( columnSize ) {
				var fractions;

				if ( 'undefined' === typeof columnSize ) {
					columnSize = '1_3';
				}

				// Fractional value.
				if ( -1 !== columnSize.indexOf( '_' ) ) {
					fractions = columnSize.split( '_' );
					return parseFloat( fractions[ 0 ] ) / parseFloat( fractions[ 1 ] );
				}

				// Greater than one, assume percentage and divide by 100.
				if ( 1 < parseFloat( columnSize ) ) {
					return parseFloat( columnSize ) / 100;
				}

				return columnSize;
			},

			setSpacingStyling: function() {
				var spacingDirection,
					width         = ( this.values.column_size * 100 ) + '%',
					mapOldSpacing = {
						0.1666: '13.3333%',
						0.8333: '82.6666%',
						0.2: '16.8%',
						0.4: '37.6%',
						0.6: '58.4%',
						0.8: '79.2%',
						0.25: '22%',
						0.75: '74%',
						0.3333: '30.6666%',
						0.6666: '65.3333%',
						0.5: '48%',
						1: '100%'
					};

				this.values.column_spacing_style = '';
				this.values.spacing_classes      = '';

				if ( 0 === parseFloat( this.values.spacing ) ) {
					this.values.spacing_classes = 'fusion-spacing-no';
				}

				if ( ! this.values.last && ! ( this.values.fallback && '0px' === this.values.spacing ) ) {
					spacingDirection = 'right';

					if ( FusionPageBuilderApp.$el.hasClass( 'rtl' ) ) {
						spacingDirection = 'left';
					}
					if ( ! this.values.fallback ) {
						this.values.column_spacing_style = 'width:' + width + ';width:calc(' + width + ' - ' + this.values.widthOffset + ');margin-' + spacingDirection + ': ' + this.values.spacing + ';';
					} else {
						this.values.column_spacing_style = 'width:' + mapOldSpacing[ this.values.column_size ] + '; margin-' + spacingDirection + ': ' + this.values.spacing + ';';
					}
				} else if ( 'undefined' !== typeof this.values.currentRowNumberOfColumns && 1 < this.values.currentRowNumberOfColumns ) {
					if ( ! this.values.fallback ) {
						this.values.column_spacing_style = 'width:' + width + ';width:calc(' + width + ' - ' + this.values.widthOffset + ');';
					} else if ( '0px' !== this.values.spacing && 'undefined' !== typeof mapOldSpacing[ this.values.column_size ] ) {
						this.values.column_spacing_style = 'width:' + mapOldSpacing[ this.values.column_size ] + ';';
					} else {
						this.values.column_spacing_style = 'width:' + width + ';';
					}
				} else if ( 'undefined' === typeof this.values.currentRowNumberOfColumns && 'undefined' !== mapOldSpacing[ this.values.column_size ] ) {
					this.values.column_spacing_style = 'width:' + mapOldSpacing[ this.values.column_size ] + ';';
				}
			},

			setSharedStyles: function() {
				this.setBackgroundColorStyle();
				this.setBackgroundImage();
				this.setBorderStyle();
				this.setBorderRadiusStyle();
				this.setBoxShadowStyle();
				this.setWrapperStyleBg();
			},

			setBackgroundColorStyle: function() {
				this.values.background_color_style = '';
				if ( '' !== this.values.background_color && ( '' === this.values.background_image || 0 !== this.values.alpha_background_color ) ) {
					this.values.background_color_style = 'background-color:' + this.values.background_color + ';';
				}
			},

			setBackgroundImage: function() {

				this.values.background_image_style = '';
				if ( '' !== this.values.background_image ) {
					this.values.background_image_style += 'background-image: url(\'' + this.values.background_image + '\');';
				}

				if ( '' !== _.getGradientString( this.values, 'column' ) ) {
					this.values.background_image_style += 'background-image:' + _.getGradientString( this.values, 'column' ) + ';';
				}

				if ( '' !== this.values.background_position ) {
					this.values.background_image_style += 'background-position:' + this.values.background_position + ';';
				}

				if ( 'none' !== this.values.background_blend_mode ) {
					this.values.background_image_style += 'background-blend-mode: ' + this.values.background_blend_mode + ';';
				}

				if ( '' !== this.values.background_repeat ) {
					this.values.background_image_style += 'background-repeat:' + this.values.background_repeat + ';';
					if ( 'no-repeat' === this.values.background_repeat ) {
						this.values.background_image_style += '-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;';
					}
				}
			},

			setBorderStyle: function() {
				var border = {
					'top': 0,
					'bottom': 0,
					'right': 0,
					'left': 0
				};
				this.values.border_full_style = '';

				if ( '' === this.values.border_sizes_top && '' === this.values.border_sizes_bottom && '' === this.values.border_sizes_left && '' === this.values.border_sizes_right ) {

					// Backwards-compatibility.
					if ( '' !== this.values.border_color && '' !== this.values.border_size && '' !== this.values.border_style ) {
						this.values.border_full_style = 'border' + this.values.border_position + ':' + this.values.border_size + ' ' + this.values.border_style + ' ' + this.values.border_color + ';';
					}
				} else {

					// Border-sizes.
					if ( '' !== this.values.border_sizes_top && 'undefined' !== typeof this.values.border_sizes_top ) {
						border.top = this.values.border_sizes_top;
					}
					if ( '' !== this.values.border_sizes_bottom && 'undefined' !== typeof this.values.border_sizes_bottom ) {
						border.bottom = this.values.border_sizes_bottom;
					}
					if ( '' !== this.values.border_sizes_left && 'undefined' !== typeof this.values.border_sizes_left ) {
						border.left = this.values.border_sizes_left;
					}
					if ( '' !== this.values.border_sizes_right && 'undefined' !== typeof this.values.border_sizes_right ) {
						border.right = this.values.border_sizes_right;
					}

					// Border-styles.
					if ( '' !== this.values.border_color ) {
						this.values.border_full_style += 'border-width: ' + border.top + ' ' + border.right + ' ' + border.bottom + ' ' + border.left + ';';
						this.values.border_full_style += 'border-color:' + this.values.border_color + ';';

						// Border-style.
						if ( '' !== this.values.border_style ) {
							this.values.border_full_style += 'border-style:' + this.values.border_style + ';';
						}
					}
				}
			},

			setBorderRadiusStyle: function() {
				this.values.border_radius_style = '';
				if ( '' !== this.values.border_radius ) {
					this.values.border_radius_style = 'border-radius:' + this.values.border_radius + ';overflow:hidden;';
				}
			},

			setBoxShadowStyle: function() {
				this.values.box_shadow_styles = '';
				if ( 'yes' === this.values.box_shadow ) {
					this.values.box_shadow_styles = 'box-shadow:' + _.fusionGetBoxShadowStyle( this.values ).trim() + ';';
				}
			},

			setWrapperStyleBg: function() {
				this.values.wrapper_style_bg = '';

				// Background color.
				if ( this.values.hover_or_link ) {
					this.values.wrapper_style_bg += this.values.background_color_style;
				}

				// Background image.
				if ( ( ! cssua.ua.ie && ! cssua.ua.edge ) || this.values.hover_or_link ) {
					this.values.wrapper_style_bg += this.values.background_image_style;
				}

				// Border.
				if ( 'liftup' === this.values.hover_type && '' !== this.values.border_full_style ) {
					this.values.wrapper_style_bg += this.values.border_full_style;
				}

				// Border radius.
				if ( '' !== this.values.border_radius_style ) {
					this.values.wrapper_style_bg += this.values.border_radius_style;
				}

				// Box shadow.
				if ( 'liftup' === this.values.hover_type && '' !== this.values.box_shadow_styles ) {
					this.values.wrapper_style_bg += this.values.box_shadow_styles;
				}
			},

			setResponsiveColumnStyles: function() {
				var self   = this,
					extras = jQuery.extend( true, {}, fusionAllElements.fusion_builder_column.extras );

				this.responsiveStyles = '';

				if ( ! this.values.flex ) {
					return;
				}

				_.each( [ 'large', 'medium', 'small' ], function( size ) {
					var columnStyles        	= '',
						wireframeColumnStyles	= '',
						columnWrapperStyles 	= '',
						hoverWrapperStyles  	= '',
						uiWrapperStyles     	= '',
						dragStyles          	= '',
						widthKey,
						paddingKey,
						keyBase,
						orderKey,
						spacingKey;

					// Width.
					widthKey = 'large' === size ? 'column_size' : 'type_' + size;
					if ( '' !== self.values[ widthKey ] && 'auto' !== self.values[ widthKey ] && 0 < parseFloat( self.values[ widthKey ] ) ) {
						columnStyles 			+= 'width:' + ( parseFloat( self.values[ widthKey ] ) * 100 ) + '%;';
						wireframeColumnStyles 	+= 'width:' + ( ( parseFloat( self.values[ widthKey ] ) * 100 )  - 3 ) + '%;';
					} else if ( 'auto' === self.values[ widthKey ] ) {
						columnStyles 			+= 'width: auto;';
						wireframeColumnStyles 	+= 'width: 97%;';
					}

					// Order.
					orderKey = 'large' === size ? 'order' : 'order_' + size;
					if ( '' !== self.values[ orderKey ] ) {
						columnStyles += 'order : ' + parseInt( self.values[ orderKey ] ) + ';';
					}

					_.each( [ 'top', 'right', 'bottom', 'left' ], function( direction ) {

						// Padding.
						paddingKey = 'large' === size ? 'padding_' + direction : 'padding_' + direction + '_' + size;
						if ( '' !== self.values[ paddingKey ] ) {
							columnWrapperStyles += 'padding-' + direction + ' : ' + self.values[ paddingKey ] + ' !important;';
						}

						// Margin.
						keyBase    = 'left' === direction || 'right' === direction ? 'upsized_spacing' : 'margin';
						spacingKey = 'large' === size ? keyBase + '_' + direction : keyBase + '_' + direction + '_' + size;
						if ( '' !== self.values[ spacingKey ] ) {
							if ( 'margin' === keyBase ) {
								columnStyles += 'margin-' + direction + ' : ' + self.values[ spacingKey ] + ';';
							} else {
								columnWrapperStyles += 'margin-' + direction + ' : ' + self.values[ spacingKey ] + ';';
							}
							if ( self.values.hover_or_link && 'margin' !== keyBase ) {
								hoverWrapperStyles += 'margin-' + direction + ':' + self.values[ spacingKey ] + ';';
							}
							if ( 'left' === direction ) {
								uiWrapperStyles += direction + ':' + self.values[ spacingKey ] + ';';
							}
							if ( 'left' === direction || 'right' === direction ) {
								dragStyles += direction + ':' + self.values[ spacingKey ] + ';';
							}
						}
					} );

					if ( '' === columnStyles && '' === columnWrapperStyles ) {
						return;
					}

					// Wrap CSS selectors
					if ( '' !== columnStyles ) {
						columnStyles = '.fusion-body .' + self.values.shortcode_classname + '-' + self.values.column_counter + '{' + columnStyles + '}';
					}
					if ( '' != wireframeColumnStyles ) {
						wireframeColumnStyles = '.fusion-body.fusion-builder-ui-wireframe .' + self.values.shortcode_classname + '-' + self.values.column_counter + '{' + wireframeColumnStyles + '}';
					}

					if ( '' !== columnWrapperStyles ) {
						columnWrapperStyles = '.' + self.values.shortcode_classname + '-' + self.values.column_counter + ' > .fusion-column-wrapper {' + columnWrapperStyles + '}';
					}
					if ( '' !== hoverWrapperStyles ) {
						hoverWrapperStyles = '.fusion-flex-container .fusion-row .' + self.values.shortcode_classname + '-' + self.values.column_counter + ' > .fusion-column-inner-bg {' + hoverWrapperStyles + '}';
					}
					if ( '' !== uiWrapperStyles ) {
						uiWrapperStyles  = '.fusion-body:not(.fusion-builder-ui-wireframe) .fusion-flex-container .fusion-row .' + self.values.shortcode_classname + '-' + self.values.column_counter + ' > .fusion-builder-module-controls-type-column {' + uiWrapperStyles + '}';
					}
					if ( '' !== dragStyles ) {
						dragStyles  = '.fusion-flex-container .fusion-row .' + self.values.shortcode_classname + '-' + self.values.column_counter + '.fusion-being-dragged:after, .fusion-builder-live .fusion-flex-container .fusion-nested-columns.editing .' + self.values.shortcode_classname + '-' + self.values.column_counter + ':hover:after {' + dragStyles + '}';
					}

					// Large styles, no wrapping needed.
					if ( 'large' === size ) {
						self.responsiveStyles += columnStyles + wireframeColumnStyles + columnWrapperStyles + hoverWrapperStyles + uiWrapperStyles + dragStyles;
					} else {
						// Medium and Small size screen styles.
						self.responsiveStyles += '@media only screen and (max-width:' + extras[ 'visibility_' + size ] + 'px) {' + columnStyles + wireframeColumnStyles + columnWrapperStyles + hoverWrapperStyles + uiWrapperStyles + dragStyles + '}';
					}
				} );
			},

			buildAttr: function() {
				var attr = {
						'class': 'fusion-layout-column ' + this.model.get( 'type' ) + ' ' + this.values.shortcode_classname + '-' + this.values.column_counter + ' fusion-builder-column-live-' + this.values.column_counter,
						'style': ''
					};

				// Flexbox column.
				if ( this.values.flex ) {
					attr[ 'class' ] += ' fusion-flex-column';

					// Alignment of column vertically.
					if ( 'auto' !== this.values.align_self ) {
						attr[ 'class' ] += ' fusion-flex-align-self-' + this.values.align_self;
					}
				} else {

					if ( '' !== this.values.type && this.values.type.includes( '_ ' ) ) {
						attr[ 'class' ] += ' ' + this.model.get( 'type' ) + '_' + this.values.type;
						attr[ 'class' ] += ' ' + this.values.type;
					}

					// Class for the specific size of column.
					if ( '' !== this.values.size_class ) {
						attr[ 'class' ] += ' ' + this.values.size_class;
					}

					// First column.
					if ( this.values.first ) {
						attr[ 'class' ] += ' fusion-column-first';
					}

					// Last column.
					if ( this.values.last ) {
						attr[ 'class' ] += ' fusion-column-last';
					}

					// Special calcs for spacing.
					if ( '' !== this.values.spacing_classes ) {
						attr[ 'class' ] += this.values.spacing_classes;
					}

					// Column spacing style, margin and width.
					if ( '' !== this.values.column_spacing_style ) {
						attr.style += this.values.column_spacing_style;
					}

					// Top margin.
					if ( '' !== this.values.margin_top ) {
						attr.style += 'margin-top:' + this.values.margin_top + ';';
					}

					// Bottom margin.
					if ( '' !== this.values.margin_bottom ) {
						attr.style += 'margin-bottom:' + this.values.margin_bottom + ';';
					}
				}

				// Custom CSS class.
				if ( '' !== this.values[ 'class' ] ) {
					attr[ 'class' ] += ' ' + this.values[ 'class' ];
				}

				// Min height for newly created columns by the converter.
				if ( 'none' === this.values.min_height ) {
					attr[ 'class' ] += ' fusion-column-no-min-height';
				}

				// Visibility classes.
				attr = _.fusionVisibilityAtts( this.values.hide_on_mobile, attr );

				attr[ 'class' ] += _.fusionGetStickyClass( this.values.sticky_display );

				// Hover type or link.
				if ( this.values.hover_or_link ) {
					attr[ 'class' ] += ' fusion-column-inner-bg-wrapper';
				}

				// TODO: check why it is looking at animation type/class.
				if ( this.values.hover_or_link && '' !== this.values.animation_type && 'liftup' === this.values.hover_type ) {
					attr[ 'class' ] += ' fusion-column-hover-type-liftup';
				}

				// Lift up and border.
				if ( 'liftup' === this.values.hover_type && '' !== this.values.border_style ) {
					attr[ 'class' ] += ' fusion-column-liftup-border';
				}

				attr = _.fusionAnimations( this.values, attr );

				if ( '' !== this.values.id ) {
					attr.id = this.values.id;
				}
				return attr;
			},

			buildWrapperAttr: function() {
				var attr = {
						'class': 'fusion-column-wrapper fusion-column-wrapper-live-' + this.values.column_counter,
						'style': ''
					};

			// Check if we have a hover, markup is different so need extra.
			if ( ! this.values.hover_or_link ) {
				// $bg_color_fix . '" ' . $lazy_bg
				attr.style += this.values.wrapper_style_bg;

				if ( cssua.ua.ie || cssua.ua.edge ) {
					attr.style += 'background-color:transparent;';
				}
			}

			// Image URL for empty dimension calculations.
			attr[ 'data-bg-url' ] = this.values.background_image;

				if ( ! this.values.hover_or_link ) {
					attr.style += this.values.background_color_style;
				}

				// Border.
				if ( '' !== this.values.border_full_style ) {
					attr.style += this.values.border_full_style;
				}

				// Border radius.
				if ( '' !== this.values.border_radius_style ) {
					attr.style += this.values.border_radius_style;
				}

				// Box shadow.
				if ( 'liftup' !== this.values.hover_type && '' !== this.values.box_shadow_styles ) {
					attr.style += this.values.box_shadow_styles;
					attr[ 'class' ] += ' fusion-column-has-shadow'; // Move this to appropriate.
				}

				// Padding.
				if ( '' !== this.values.padding ) {
					attr.style += 'padding: ' + this.values.padding + ';';
				}

				// Flex.
				if ( this.values.flex ) {
					if ( '' !== this.values.align_content ) {
						attr[ 'class' ] += ' fusion-flex-justify-content-' + this.values.align_content;
						attr[ 'class' ] += ' fusion-content-layout-' + this.values.content_layout;
						if ( 'wrap' !== this.values.content_wrap ) {
							attr[ 'class' ] += ' fusion-content-' + this.values.content_wrap;
						}
					}
				}

				return attr;
			},

			buildIeExtraAttr: function() {
				var attr = {
						'class': 'fusion-column-wrapper',
						'style': 'content:\'\';z-index:-1;position:absolute;top:0;right:0;bottom:0;left:0;'
					};

				// Border radius.
				if ( '' !== this.values.border_radius_style ) {
					this.values.wrapper_style_bg += this.values.border_radius_style;
				}

				if ( '' !== this.values.background_image_style ) {
					attr.style += this.values.background_image_style;
					if ( '' !== this.values.background_color && 1 === this.values.alpha_background_color ) {
						attr.style += 'background-color:' + this.values.background_color + ';';
					}
				}

				// Box shadow.
				if ( 'liftup' !== this.values.hover_type && '' !== this.values.box_shadow_styles ) {
					attr[ 'class' ] += ' fusion-column-has-shadow';
				}

				return attr;
			},

			buildHoverWrapperAttr: function() {
				var attr = {
						'class': 'fusion-column-inner-bg hover-type-' + this.values.hover_type,
						'style': ''
					};

				if ( ( 'zoomin' === this.values.hover_type || 'zoomout' === this.values.hover_type || '' !== this.values.link ) && '' !== this.values.border_radius_style ) {
					attr.style += 'overflow:hidden;' + this.values.border_radius_style + ';';
				}

				return attr;
			},

			buildAnchorAttr: function() {
				var attr = {};

				if ( '' !== this.values.link ) {
					attr.href = this.values.link;
				}

				if ( '_blank' === this.values.target ) {
					attr.rel    = 'noopener noreferrer';
					attr.target = '_blank';
				} else if ( 'lightbox' === this.values.target ) {
					attr[ 'data-rel' ] = 'iLightbox';
				}
				return attr;
			},

			buildHoverInnerWrapperAttr: function() {
				var attr = {
						'class': 'fusion-column-inner-bg-image',
						'style': ''
					};

				// Background style.
				if ( '' !== this.values.wrapper_style_bg ) {
					attr.style += this.values.wrapper_style_bg;
				}

				return attr;
			},

			builderIeSpanAttr: function() {
				var attr = {
						'class': 'fusion-column-inner-bg-image'
					};

				if ( '' !== this.values.background_image_style ) {
					attr.style += this.values.background_image_style;
					if ( '' !== this.values.background_color && 1 === this.values.alpha_background_color ) {
						attr.style += 'background-color:' + this.values.background_color + ';';
					}
				}

				return attr;
			},

			/**
			 * Fires when preview are is resized.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			onPreviewResize: function() {
				// Update size indicator in toolbar.
				this.updateSizeIndicators();

				if ( ! FusionPageBuilderApp.getParentContainer( this ).isFlex() ) {
					return;
				}

				// Update margin and padding indicators if we are editing this.
				if ( this.$el.hasClass( 'fusion-builder-element-edited' ) ) {
					this.updateBoxModelIndicators();
				}
			},

			/**
			 * Updates column sizes controls.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			updateSizeIndicators: function() {
				var columnSize = this.getVisibleWidth();

				this.$el.find( '.column-sizes .column-size' ).removeClass( 'active-size' );
				if ( columnSize.includes( '_' ) ) {
					this.$el.find( '.column-size-' + columnSize ).addClass( 'active-size' );
				}
				this.$el.find( '.fusion-column-size-label' ).text( columnSize.replace( '_', '/' ) );

			},

			/**
			 * Updates column sizes controls.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			updateBoxModelIndicators: function() {
				this.destroyMarginResizable();
				this.destroyPaddingResizable();
				this.marginDrag();
				this.paddingDrag();
			},

			/**
			 * Parses width to readable string.
			 *
			 * @since 3.0
			 * @param  {String} width
			 * @return {String}
			 */
			parseWidthLabel: function( width ) {
				if ( 'undefined' === typeof width ) {
					width = '1_1';
				}
				if ( 'auto' === width ) {
					return 'auto';
				}
				if ( ! width.includes( '_' ) ) {
					return width.split( '.' )[ 0 ] + '%';
				}
				return width;
			},

			/**
			 * Returns visible column width.
			 *
			 * @since 3.0
			 * @return {String}
			 */
			getVisibleWidth: function() {
				var param, defaultVal, previewFrame, legacyBreakpoint;
					// Legacy support.
					if ( ! FusionPageBuilderApp.getParentContainer( this ).isFlex() ) {
						previewFrame = jQuery( '#fb-preview' )[ 0 ];
						legacyBreakpoint = getComputedStyle( previewFrame.contentDocument.documentElement ).getPropertyValue( '--content_break_point' );
						if ( legacyBreakpoint && legacyBreakpoint >= previewFrame.offsetWidth ) {
							return '1_1';
						}
						return this.model.attributes.params.type;
					}

					param = FusionApp.getResponsiveOptionKey( 'type', true );

					// Default for medium and small sizes.
					if ( 'type' !== param &&  ! this.model.attributes.params[ param ] ) {
						// Return large value.
						defaultVal = fusionAllElements.fusion_builder_column.extras[ 'col_width_' +  param.replace( 'type_', '' ) ];
						if ( 'inherit_from_large' === defaultVal ) {
							return this.parseWidthLabel( this.model.attributes.params.type );
						}
						return '1_1';
					}
					return this.parseWidthLabel( this.model.attributes.params[ param ] );
			},

			getTemplateAtts: function() {
				var styleSelector,
					data   = {};

				this.setArgs();

				this.responsiveStyles = '';
				this.styles           = '';

				this.validateArgs();

				this.setExtraArgs();

				this.setColumnMapData();

				// Sets styles which are used on multiple elements.
				this.setSharedStyles();

				// Sets styles for responsive options.
				if ( this.values.flex ) {
					this.setResponsiveColumnStyles();
				}

				// Lift up and border radius we need to apply radius to lift up markup.
				if ( this.values.hover_or_link && '' !== this.values.border_radius_style && 'liftup' === this.values.hover_type ) {
					this.styles += '.fusion-builder-column-' + this.values.column_counter + ' .hover-type-liftup:before{' + this.values.border_radius_style + ';}';
				}

				// Get the filter style
				if ( 'fusion_builder_column' === this.model.get( 'type' ) ) {
					styleSelector = '.fusion-builder-column-live-' + this.model.get( 'cid' );
				} else {
					styleSelector = { regular: '.fusion-builder-column .fusion-column-wrapper-live-' + this.model.get( 'cid' ), hover: '.fusion-builder-column:hover .fusion-column-wrapper-live-' + this.model.get( 'cid' ) };
				}

				data.ieExtra               = ! this.values.flex && ( cssua.ua.ie || cssua.ua.edge ) && this.values.hover_or_link ? this.buildIeExtraAttr() : false;
				data.ieSpanExtra           = this.values.hover_or_link && '' !== this.values.background_color_style && ( cssua.ua.ie || cssua.ua.edge ) ? this.builderIeSpanAttr() : false;
				data.wrapperAttr           = this.buildWrapperAttr();
				data.center_content        = this.values.center_content;
				data.hoverWrapperAttr      = this.buildHoverWrapperAttr();
				data.anchorAttr            = this.buildAnchorAttr();
				data.hoverInnerWrapperAttr = this.buildHoverInnerWrapperAttr();
				data.styles                = this.styles;
				data.filterStyle           = _.fusionGetFilterStyleElem( this.values, styleSelector, this.model.get( 'cid' ) );
				data.nestedClass           = 'fusion_builder_column_inner' === this.model.get( 'type' ) ? ' fusion-nested-column-content' : '';
				data.cid                   = this.model.get( 'cid' );
				data.hoverOrLink           = this.values.hover_or_link;
				data.layout                = this.getVisibleWidth().replace( '_', '/' );
				data.isFlex                = ( 'undefined' !== typeof this.values.flex ) ? this.values.flex : false;
				data.responsiveStyles      = 'undefined' !== typeof this.responsiveStyles ? this.responsiveStyles : '';
				data.isGlobal              = ( 'undefined' !== typeof this.values.fusion_global ) ? 'yes' : 'no';

				// Main wrapper is the actual view.
				this.model.set( 'selectors', this.buildAttr() );

				return data;
			},

			/**
			 * Toggles the 'active' class.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the class toggling.
			 * @return {void}
			 */
			sizesShow: function( event ) {
				var parentContainer = this.$el.closest( '.fusion-builder-container' ),
					sizesPopover = this.$el.find( '.column-sizes' ),
					columnOffsetTop = 0,
					html, header, headerBottom, conditional;

				if ( event ) {
					event.preventDefault();
					event.stopPropagation();
				}

				sizesPopover.removeClass( 'fusion-expand-to-bottom' );

				// This needs to be the way it is setup, as nested cols could trigger sizing on several cols at once.
				if ( ! this.$el.hasClass( 'active' ) ) {
					this.$el.addClass( 'active' );
					parentContainer.addClass( 'fusion-column-sizer-active' );

					columnOffsetTop = this.$el.offset().top;
					html = this.$el.closest( 'html' );
					conditional = false;

					if ( html.children( 'body' ).hasClass( 'fusion-top-header' ) ) {
						if ( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).length ) {
							sizesPopover.on( 'mouseenter', function() {
								jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#main' ).css( 'z-index', 'auto' );

								if ( 'fixed' === jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).css( 'position' ) ) {
									jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).css( 'z-index', '-1' );

									if ( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#sliders-container' ).find( '.tfs-slider[data-parallax="1"]' ).length ) {
										jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#sliders-container' ).css( 'z-index', 'auto' );
									}
								}
							} );

							sizesPopover.on( 'mouseleave', function() {
								jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#main' ).css( 'z-index', '' );
								jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).css( 'z-index', '' );
								jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#sliders-container' ).css( 'z-index', '' );
							} );
						}

						header       = html.find( '.fusion-header-wrapper' );
						headerBottom = 0;
						if ( header.length ) {
							headerBottom = header.offset().top + header.outerHeight();
						}
						conditional = 106 > columnOffsetTop - headerBottom;
					}

					if ( 54 > columnOffsetTop - 121 || conditional || sizesPopover.parents( '.fusion-fullwidth' ).hasClass( 'bg-parallax-parent' ) ) {
						sizesPopover.addClass( 'fusion-expand-to-bottom' );
					}
				} else {
					this.$el.removeClass( 'active' );
					parentContainer.removeClass( 'fusion-column-sizer-active' );

					sizesPopover.off( 'mouseover' ).off( 'mouseleave' );
				}

			},

			/**
			 * Toggle class to show content in bottom
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			offsetClass: function() {
				if ( 100 > this.$el.offset().top ) {
					this.$el.addClass( 'fusion-content-bottom' );
				} else if ( 100 < this.$el.offset().top && this.$el.hasClass( 'fusion-content-bottom' )  ) {
					this.$el.removeClass( 'fusion-content-bottom' );
				}
			},

			/**
			 * Column spacing dimensions version.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			fallbackColumnSpacing: function( $placeholder, allNo ) {
				var columnSize      = '100%',
					fullcolumnSize  = columnSize,
					existingSpacing = '0%',
					columnWidth     = this.model.attributes.params.type,
					spacingDirection;

				if ( 'yes' === this.model.attributes.params.spacing ) {
					existingSpacing = '4%';
				}

				columnWidth = this.model.attributes.params.type;

				switch ( columnWidth ) {
				case '1_1':
					columnSize     = '100%';
					fullcolumnSize = '100%';
					break;
				case '1_4':
					columnSize     = '22%';
					fullcolumnSize = '25%';
					break;
				case '3_4':
					columnSize     = '74%';
					fullcolumnSize = '75%';
					break;
				case '1_2':
					columnSize     = '48%';
					fullcolumnSize = '50%';
					break;
				case '1_3':
					columnSize     = '30.6666%';
					fullcolumnSize = '33.3333%';
					break;
				case '2_3':
					columnSize     = '65.3333%';
					fullcolumnSize = '66.6666%';
					break;
				case '1_5':
					columnSize     = '16.8%';
					fullcolumnSize = '20%';
					break;
				case '2_5':
					columnSize     = '37.6%';
					fullcolumnSize = '40%';
					break;
				case '3_5':
					columnSize     = '58.4%';
					fullcolumnSize = '60%';
					break;
				case '4_5':
					columnSize     = '79.2%';
					fullcolumnSize = '80%';
					break;
				case '5_6':
					columnSize     = '82.6666%';
					fullcolumnSize = '83.3333%';
					break;
				case '1_6':
					columnSize     = '13.3333%';
					fullcolumnSize = '16.6666%';
					break;
				}

				if ( '4%' !== existingSpacing && ( ! this.model.attributes.params.last || allNo ) ) {
					columnSize = fullcolumnSize;
				}

				this.$el.css( 'width', columnSize );
				$placeholder.css( 'width', columnSize );

				spacingDirection = 'right';
				if ( FusionPageBuilderApp.$el.hasClass( 'rtl' ) ) {
					spacingDirection = 'left';
				}
				$placeholder.css( 'margin-' + spacingDirection, existingSpacing );
				this.$el.css( 'margin-' + spacingDirection, existingSpacing );
			},

			/**
			 * Column spacing dimensions version.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			dimensionColumnSpacing: function( columnRow, columnWidth, $placeholder ) {
				var decimalWidth,
					check,
					spacingWidth,
					existingSpacing,
					spacings = [],
					spacingDirection;

				// Remove last from calcs.
				columnRow.pop();

				columnWidth  = columnWidth[ 0 ] / columnWidth[ 1 ];
				decimalWidth = columnWidth;

				if ( 'object' === typeof columnRow ) {
					check = columnRow.every( this.pxCheck );
					if ( check ) {
						spacingWidth = ( columnRow.reduce( this.addValues, 0 ) * decimalWidth ) + 'px';
						this.$el.css( 'width', 'calc( ' + ( columnWidth * 100 ) + '% - ' + spacingWidth + ' )' );
						$placeholder.css( 'width', 'calc( ' + ( columnWidth * 100 ) + '% - ' + spacingWidth + ' )' );
					} else if ( columnRow.every( this.percentageCheck ) ) {
						columnWidth = ( columnWidth * 100 ) - ( columnRow.reduce( this.addValues, 0 ) * decimalWidth );
						this.$el.css( 'width', columnWidth + '%' );
						$placeholder.css( 'width', columnWidth + '%' );
					} else {

						_.each( columnRow, function( space ) {
							space = ( 'undefined' === typeof space || '' === space ) ? '4%' : space;
							spacings.push( space );
						} );

						spacingWidth = spacings.join( ' + ' );
						this.$el.css( 'width', 'calc( ' + ( columnWidth * 100 ) + '% - ( ( ' + spacingWidth + ' ) * ' + decimalWidth + ' )' );
						$placeholder.css( 'width', 'calc( ' + ( columnWidth * 100 ) + '% - ( ( ' + spacingWidth + ' ) * ' + decimalWidth + ' )' );
					}
				}

				existingSpacing = this.model.attributes.params.spacing;
				if ( 'undefined' === typeof this.model.attributes.params.spacing || 'yes' === this.model.attributes.params.spacing || '' === this.model.attributes.params.spacing ) {
					existingSpacing = '4%';
				}
				if ( 'no' === this.model.attributes.params.spacing ) {
					existingSpacing = '0';
				}

				spacingDirection = 'right';
				if ( FusionPageBuilderApp.$el.hasClass( 'rtl' ) ) {
					spacingDirection = 'left';
				}
				$placeholder.css( 'margin-' + spacingDirection, existingSpacing );
				this.$el.css( 'margin-' + spacingDirection, existingSpacing );
			},

			/**
			 * Check if value is valid for column spacing.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			validColumnSpacing: function( value ) {
				if ( 'yes' !== value && 'no' !== value && ! ( /\d/ ).test( value ) && '' !== value ) {
					return false;
				}
				return true;
			},

			/**
			 * Filter out DOM before patching.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			patcherFilter: function( diff ) {
				var filteredDiff = [],
					self = this;

				_.each( diff, function( info ) {
					if ( 'removeElement' === info.action ) {
						if ( 'undefined' !== typeof info.element.attributes[ 'class' ] &&
							(
								-1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-column-content-centered' ) ||
								-1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-builder-column-content' ) ||
								-1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-column-wrapper' )
							)
						) {
							self.forceAppendChildren = true;
							filteredDiff.push( info );
						} else if (
							'undefined' !== typeof info.element.attributes[ 'class' ] &&
							(
								-1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-spacing-value' ) ||
								-1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-element-spacing' ) ||
								-1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-builder-live-element' ) ||
								-1 !== info.element.attributes[ 'class' ].indexOf( 'fusion_builder_row_inner' )
							)
						) {

							// ignore
						} else {
							filteredDiff.push( info );
						}
					} else if ( 'addElement' === info.action ) {
						if ( 'undefined' !== typeof info.element.attributes[ 'class' ] &&
							(
								-1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-column-content-centered' ) ||
								-1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-builder-column-content' ) ||
								-1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-column-wrapper' )
							)
						) {
							self.forceAppendChildren = true;
							filteredDiff.push( info );
						} else if ( 'undefined' !== typeof info.element.attributes[ 'class' ] && ( -1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-spacing-value' ) || -1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-element-spacing' ) ) ) {

							// ignore
						} else {
							filteredDiff.push( info );
						}
					} else {
						filteredDiff.push( info );
					}
				} );

				return filteredDiff;
			},

			/**
			 * Adds a delay to the change trigger to accomodate equal-heights implementation.
			 *
			 * @since 2.0.0
			 * @param {number|string} cid - The CID of the element.
			 * @return {void}
			 */
			equalHeights: function( cid ) {
				cid = 'undefined' === typeof cid ? this.model.attributes.cid : cid;
				setTimeout( function() {
					jQuery( document ).trigger( 'fusion-content-changed', cid );
					jQuery( window ).trigger( 'fusion-content-changed', cid );
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-content-changed', cid );
				}, 300 );
			},

			/**
			 * Removes the 'active' class.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			toolTipHide: function() {
				this.$el.find( '.fusion-spacing-tooltip, .fusion-column-spacing' ).removeClass( 'active' );
			},

			/**
			 * Resize spacer on window resize event.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			resizeSpacer: function() {
				if ( this.columnSpacer ) {
					this.columnSpacing();
				}
			},

			/**
			 * Preview column-spacing changes.
			 *
			 * @since 2.0.0
			 * @param {Object} columnRow - The row.
			 * @return {void}
			 */
			columnSpacingPreview: function( columnRow ) {
				var columnWidth = 'undefined' !== typeof this.model.attributes.params.type ? this.model.attributes.params.type.split( '_' ) : [ '1', '1' ],
					fallback = true,
					origValue,
					$placeholder = jQuery( '.fusion-builder-column-placeholder[data-cid="' + this.model.get( 'cid' ) + '"]' ),
					allNo = true;

				_.each( columnRow, function( value, index ) {
					origValue          = value;
					value              = ( 'yes' === value ) ? '4%' : value;
					value              = ( 'no' === value ) ? '0' : value;
					fallback           = fallback && origValue !== value;
					allNo              = allNo && 0 === parseInt( value, 10 );
					columnRow[ index ]   = value;
				} );

				if ( ! fallback ) {
					this.dimensionColumnSpacing( columnRow, columnWidth, $placeholder );
				} else {
					this.fallbackColumnSpacing( $placeholder, allNo );
				}
			},

			/**
			 * Gets the column content.
			 * Alias of getColumnContent method.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getContent: function() {
				return this.getColumnContent();
			}

		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderViewManager, FusionApp, fusionGlobalManager, fusionBuilderText, FusionPageBuilderApp, FusionPageBuilderElements, FusionEvents, fusionAllElements */
/* eslint no-unused-vars: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Column View
		FusionPageBuilder.ColumnView = FusionPageBuilder.BaseColumnView.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-column-template' ).html() ),

			events: {
				'click .fusion-builder-column-settings:not(.fusion-builder-column-inner .fusion-builder-column-setting)': 'settings',
				'click .fusion-builder-column-size:not(.fusion-builder-column-inner .fusion-builder-column-size)': 'sizesShow',
				'hover .fusion-builder-column-content': 'offsetClass',
				'click .column-size:not(.fusion-builder-column-inner .column-size)': 'sizeSelect',
				'click .fusion-builder-add-element:not(.fusion-builder-column-inner .fusion-builder-add-element)': 'addModule',
				'click .fusion-builder-column-remove:not(.fusion-builder-column-inner .fusion-builder-column-remove)': 'removeColumn',
				'click .fusion-builder-column-clone:not(.fusion-builder-column-inner .fusion-builder-column-clone)': 'cloneColumn',
				'click .fusion-builder-column-save:not(.fusion-builder-column-inner .fusion-builder-column-save)': 'openLibrary',
				'click .fusion-builder-column-drag:not(.fusion-builder-column-inner .fusion-builder-column-drag)': 'preventDefault'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
				var params  = this.model.get( 'params' ),
					spacing = '' !== params.spacing ? spacing : '4%';

				this.renderedYet         = false;
				this.columnSpacer        = false;
				this.forceAppendChildren = false;

				this.listenTo( FusionEvents, 'fusion-view-update-fusion_builder_column', this.reRender );

				this.$el.attr( 'data-cid', this.model.get( 'cid' ) );
				this.$el.attr( 'id', 'fusion-column-' + this.model.get( 'cid' ) );
				this.$el.attr( 'data-column-size', this.model.attributes.params.type );
				this.$el.attr( 'data-column-spacing', spacing );

				if ( 'undefined' !== typeof this.model.attributes.params && 'undefined' !== typeof this.model.attributes.params.fusion_global ) {
					this.$el.attr( 'fusion-global-layout', this.model.attributes.params.fusion_global );
					this.$el.removeClass( 'fusion-global-column' ).addClass( 'fusion-global-column' );
				}

				this.currentClasses = '';

				this.baseColumnInit();
				this.baseInit();
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var self = this,
					data = this.getTemplateAtts(),
					columnSize = '';

				this.$el.html( this.template( data ) );

				if ( 'undefined' !== typeof this.model.attributes.selectors ) {
					this.setElementAttributes( this.$el, this.model.attributes.selectors );
				}

				// Add active column size CSS class
				columnSize = this.model.attributes.params.type;
				// TODO Check size and update class according.
				this.updateSizeIndicators();

				this.appendChildren();

				setTimeout( function() {
					self.droppableColumn();
					self.sortableElements();
					self.disableSortableElements();
				}, 100 );

				// Don't refresh on first render.
				if ( this.renderedYet ) {
					this._refreshJs();
				}

				this.renderedYet = true;

				return this;
			},

			droppableColumn: function() {
				var self = this,
					$el  = this.$el,
					cid,
					$droppables,
					$body;

				if ( ! $el ) {
					return;
				}

				cid         = this.model.get( 'cid' );
				$droppables = $el.find( '.fusion-column-target' );
				$body       = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' );

				$el.draggable( {
					appendTo: FusionPageBuilderApp.$el,
					zIndex: 999999,
					delay: 100,
					cursorAt: { top: 15, left: 15 },
					iframeScroll: true,
					containment: $body,
					cancel: '.fusion-builder-live-element, .fusion_builder_row_inner',
					helper: function() {
						var $classes = FusionPageBuilderApp.DraggableHelpers.draggableClasses( cid ),
							style = '';

						if ( $el.css( 'margin-top' ) ) {
							style = 'style="transform: translateY(' + $el.css( 'margin-top' ) + ');"';
						}

						return jQuery( '<div><div class="fusion-column-helper ' + $classes + '" data-cid="' + cid + '"' + style + '><span class="fusiona-column"></span></div></div>' );
					},
					start: function() {
						$body.addClass( 'fusion-column-dragging fusion-active-dragging' );
						$el.addClass( 'fusion-being-dragged' );

						if ( 'large' !== FusionApp.getPreviewWindowSize() ) {
							$body.addClass( 'fusion-column-dragging-responsive-mode' );
							$el.closest( '.fusion-builder-container' ).addClass( 'fusion-has-active-drop-targets' );
						}
					},
					stop: function() {
						setTimeout( function() {
							$body.removeClass( 'fusion-column-dragging fusion-active-dragging' );
						}, 10 );
						$el.removeClass( 'fusion-being-dragged' );

						if ( 'large' !== FusionApp.getPreviewWindowSize() ) {
							$el.closest( '.fusion-builder-container' ).removeClass( 'fusion-has-active-drop-targets' );
							$body.removeClass( 'fusion-column-dragging-responsive-mode' );
						}
					}
				} );

				$droppables.droppable( {
					tolerance: 'touch',
					hoverClass: 'ui-droppable-active',
					accept: '.fusion-builder-column',
					drop: function( event, ui ) {
						var destinationRow,
							columnCid      = ui.draggable.data( 'cid' ),
							columnView     = FusionPageBuilderViewManager.getView( columnCid ),
							originalCid    = columnView.model.get( 'parent' ),
							$target        = $el,
							parentCid      = $target.closest( '.fusion-builder-row' ).data( 'cid' ),
							originalView,
							newIndex;

						if ( 'large' !== FusionApp.getPreviewWindowSize() && 'undefined' !== typeof self.isFlex && true === self.isFlex ) {

							// Update columns' order.
							FusionPageBuilderViewManager.getView( self.model.get( 'parent' ) )._updateResponsiveColumnsOrder(
								ui.draggable,
								$target.closest( '.fusion-builder-row' ).children( '.fusion-builder-column' ),
								parseInt( jQuery( event.target ).closest( '.fusion-builder-column' ).data( 'cid' ) ),
								jQuery( event.target ).hasClass( 'target-after' )
							);

							return;
						}

						// Move the actual html.
						if ( jQuery( event.target ).hasClass( 'target-after' ) ) {
							$target.after( ui.draggable );
						} else {
							$target.before( ui.draggable );
						}

						destinationRow = FusionPageBuilderViewManager.getView( parentCid );

						newIndex = ui.draggable.parent().children( '.fusion-builder-column' ).index( ui.draggable );

						FusionPageBuilderApp.onDropCollectionUpdate( columnView.model, newIndex, parentCid );

						// Update destination row which is this current one.
						destinationRow.setRowData();

						// If destination row and original row are different, update original as well.
						if ( parentCid !== originalCid ) {
							originalView = FusionPageBuilderViewManager.getView( originalCid );
							originalView.setRowData();
						}

						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.column + ' order changed' );

						setTimeout( function() {
							// If different container type we re-render so that it corrects for new situation.
							if ( 'object' !== typeof originalView || FusionPageBuilderApp.sameContainerTypes( originalView.model.get( 'parent' ), destinationRow.model.get( 'parent' ) ) ) {
								columnView.droppableColumn();
							} else {
								FusionEvents.trigger( 'fusion-close-settings-' + columnView.model.get( 'cid' ) );
								columnView.reRender();
							}
						}, 300 );
					}
				} );

				$el.find( '.fusion-element-target-column' ).droppable( {
					tolerance: 'touch',
					hoverClass: 'ui-droppable-active',
					accept: '.fusion-builder-live-element, .fusion_builder_row_inner',
					drop: function( event, ui ) {
						var elementView  = FusionPageBuilderViewManager.getView( ui.draggable.data( 'cid' ) ),
							newIndex,
							MultiGlobalArgs;

						// Move the actual html.
						$el.find( '.fusion-builder-column-content:not(.fusion_builder_row_inner .fusion-builder-column-content ):not( .fusion-nested-column-content )' ).append( ui.draggable );

						newIndex = ui.draggable.parent().children( '.fusion-builder-live-element, .fusion_builder_row_inner' ).index( ui.draggable );

						FusionPageBuilderApp.onDropCollectionUpdate( elementView.model, newIndex, self.model.get( 'cid' ) );

						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.moved + ' ' + fusionAllElements[ elementView.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );

						// Handle multiple global elements.
						MultiGlobalArgs = {
							currentModel: elementView.model,
							handleType: 'save',
							attributes: elementView.model.attributes
						};
						fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

						FusionEvents.trigger( 'fusion-content-changed' );

						self._equalHeights();
					}
				} );

				// If we are in wireframe mode, then disable.
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.disableDroppableColumn();
				}
			},

			/**
			 * Things to do, places to go when options change.
			 *
			 * @since 2.0.0
			 * @param {string} paramName - The name of the parameter that changed.
			 * @param {mixed}  paramValue - The value of the option that changed.
			 * @param {Object} event - The event triggering the option change.
			 * @return {void}
			 */
			onOptionChange: function( paramName, paramValue, event ) {
				var rowView,
					parentCID            = this.model.get( 'parent' ),
					cid                  = this.model.get( 'cid' ),
					dimensionType		 = _.find( [ 'spacing_', 'margin_', 'padding_' ], function( type ) {
						return paramName.includes( type );
					} ),
					reInitDraggables     = false,
					view                 = {},
					values               = {},
					alphaBackgroundColor = 1;

				// Reverted to history step or user entered value manually.
				if ( 'undefined' === typeof event || ( 'undefined' !== typeof event && ( 'change' !== event.type || ( 'change' === event.type && 'undefined' !== typeof event.srcElement ) ) ) ) {
					reInitDraggables = true;
				}

				if ( 'spacing' === paramName ) {
					this.model.attributes.params[ paramName ] = paramValue;

					// Only update preview if it a valid unit.
					if ( this.validColumnSpacing( paramValue ) ) {
						rowView = FusionPageBuilderViewManager.getView( parentCID );
						rowView.setSingleRowData( cid );
					}

					if ( true === reInitDraggables ) {
						if ( 'yes' === paramValue || 'no' === paramValue ) {
							this.destroySpacingResizable();
						} else {
							this.columnSpacer = false;
							this.columnSpacing();
						}
					}
				}

				if ( dimensionType ) {
					this.model.attributes.params[ paramName ] = paramValue;

					if ( true === reInitDraggables ) {

						if ( 'padding_' === dimensionType ) {
							this.destroyPaddingResizable();
							this.paddingDrag();
						} else {
							this.destroyMarginResizable();
							this.marginDrag();
						}

					}
				}

				if ( 'padding' === paramName ) {
					if ( -1 === jQuery( event.target ).attr( 'name' ).indexOf( '_' ) ) {
						this.model.attributes.params[ paramName ] = paramValue;
						this.renderSectionSeps( event );
						this._refreshJs();
					}
				}


				if ( 'padding_left' === paramName || 'padding_right' === paramName ) {
					this.renderSectionSeps( event );
				}

				if ( [ 'border_size', 'border_color', 'border_style', 'border_position' ].includes( paramName ) ) {
					this.model.attributes.params[ paramName ] = paramValue;
				}
			},

			/**
			 * Render the section separators.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			renderSectionSeps: function() {
				var elements = FusionPageBuilderViewManager.getChildViews( this.model.get( 'cid' ) );

				_.each( elements, function( element ) {
					if ( 'fusion_section_separator' === element.model.get( 'element_type' ) ) {
						element.reRender();
					}
				} );
			},

			/**
			 * Triggers a refresh.
			 *
			 * @since 2.0.0
			 * @return void
			 */
			refreshJs: function() {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-element-render-fusion_builder_column', this.model.attributes.cid );
			},

			/**
			 * Changes the border styles for the element.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			borderStyle: function( event ) {
				var borderSize     = this.model.attributes.params.border_size + 'px',
					borderColor    = this.model.attributes.params.border_color,
					borderStyle    = this.model.attributes.params.border_style,
					borderPosition = this.model.attributes.params.border_position,
					positions      = [ 'top', 'right', 'bottom', 'left' ],
					self           = this,
					$target        = ( 'lift_up' === this.model.attributes.params.hover_type ) ? self.$el.find( '.fusion-column-wrapper, .fusion-column-inner-bg-image' ) : self.$el.find( '.fusion-column-wrapper' );

				if ( event ) {
					event.preventDefault();
				}
				self.$el.find( '.fusion-column-wrapper, .fusion-column-inner-bg-image' ).css( 'border', '' );
				if ( 'all' === borderPosition ) {
					_.each( positions, function( position ) {
						$target.css( 'border-' + position, borderSize + ' ' + borderStyle + ' ' + borderColor );
					} );
				} else {
					_.each( positions, function( position ) {
						if ( position === borderPosition ) {
							$target.css( 'border-' + position, borderSize + ' ' + borderStyle + ' ' + borderColor );
						} else {
							$target.css( 'border-' + position, 'none' );
						}
					} );
				}
			},

			/**
			 * Sets the attributes of an element.
			 *
			 * @since 2.0.0
			 * @param {Object} element - The element we're updating.
			 * @param {Object} attributes - The attributes we're setting/updating.
			 * @return {void}
			 */
			setElementAttributes: function( element, attributes ) {
				var self = this;

				element.removeClass( this.currentClasses );

				if ( 'object' === typeof attributes && element.length ) {
					_.each( attributes, function( values, attribute ) {
						if ( 'class' === attribute ) {
							self.currentClasses = values;
							element.addClass( values );
						} else if ( 'id' === attribute ) {
							element.attr( 'id', values );
						} else if ( 'style' === attribute ) {
							element.attr( 'style', values );
						} else if ( -1 !== attribute.indexOf( 'data' ) ) {
							attribute = attribute.replace( /_/g, '-' );
							element.attr( attribute, values );
						}
					} );
				}
			},

			/**
			 * Clones a column.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			cloneColumn: function( event ) {
				var columnAttributes = jQuery.extend( true, {}, this.model.attributes ),
					$thisColumn,
					container;

				if ( event ) {
					event.preventDefault();
				}

				columnAttributes.created       = 'manually';
				columnAttributes.cid           = FusionPageBuilderViewManager.generateCid();
				columnAttributes.targetElement = this.$el;
				columnAttributes.cloned        = true;
				columnAttributes.at_index      = FusionPageBuilderApp.getCollectionIndex( this.$el );

				FusionPageBuilderApp.collection.add( columnAttributes );

				// Parse column elements
				$thisColumn = this.$el;
				$thisColumn.find( '.fusion-builder-live-element:not(.fusion-builder-column-inner .fusion-builder-live-element), .fusion-builder-nested-element' ).each( function() {
					var $thisModule,
						moduleCID,
						module,
						elementAttributes,
						$thisInnerRow,
						innerRowCID,
						innerRowView;

					// Standard element
					if ( jQuery( this ).hasClass( 'fusion-builder-live-element' ) ) {
						$thisModule = jQuery( this );
						moduleCID   = 'undefined' === typeof $thisModule.data( 'cid' ) ? $thisModule.find( '.fusion-builder-data-cid' ).data( 'cid' ) : $thisModule.data( 'cid' );

						// Get model from collection by cid
						module = FusionPageBuilderElements.find( function( model ) {
							return model.get( 'cid' ) == moduleCID; // jshint ignore: line
						} );

						// Clone model attritubes
						elementAttributes          = jQuery.extend( true, {}, module.attributes );

						elementAttributes.created  = 'manually';
						elementAttributes.cid      = FusionPageBuilderViewManager.generateCid();
						elementAttributes.parent   = columnAttributes.cid;
						elementAttributes.from     = 'fusion_builder_column';

						// Don't need target element, position is defined from order.
						delete elementAttributes.targetElementPosition;

						FusionPageBuilderApp.collection.add( elementAttributes );

					// Inner row/nested element
					} else if ( jQuery( this ).hasClass( 'fusion_builder_row_inner' ) ) {
						$thisInnerRow = jQuery( this );
						innerRowCID   = 'undefined' === typeof $thisInnerRow.data( 'cid' ) ? $thisInnerRow.find( '.fusion-builder-data-cid' ).data( 'cid' ) : $thisInnerRow.data( 'cid' );
						innerRowView  = FusionPageBuilderViewManager.getView( innerRowCID );

						// Clone inner row
						if ( 'undefined' !== typeof innerRowView ) {
							innerRowView.cloneNestedRow( 'clone', columnAttributes.cid );
						}
					}

				} );

				// If column is cloned manually
				if ( event ) {

					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.cloned + ' ' + fusionBuilderText.column );

					container = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );

					container.createVirtualRows();
					container.updateColumnsPreview();

					FusionEvents.trigger( 'fusion-content-changed' );
				}
				this._refreshJs();
			},

			/**
			 * Append the column's children to its content.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			appendChildren: function() {
				var self = this,
					cid,
					view;

				this.model.children.each( function( child ) {

					cid  = child.attributes.cid;
					view = FusionPageBuilderViewManager.getView( cid );

					self.$el.find( '.fusion-builder-column-content:not(.fusion_builder_row_inner .fusion-builder-column-content ):not( .fusion-nested-column-content )' ).append( view.$el );

				} );

				this.delegateChildEvents();
			},

			/**
			 * Gets the column contents.
			 *
			 * @since 2.0.0
			 * @param {Object} $thisColumn - The jQuery object of the element.
			 * @return {string}
			 */
			getColumnContent: function() {
				var shortcode    = '',
					columnParams = {},
					ColumnAttributesCheck;

				_.each( this.model.get( 'params' ), function( value, name ) {
					columnParams[ name ] = ( 'undefined' === value || 'undefined' === typeof value ) ? '' : value;
				} );

				// Legacy support for new column options
				ColumnAttributesCheck = {
					min_height: '',
					last: 'no',
					hover_type: 'none',
					link: '',
					border_position: 'all'
				};

				_.each( ColumnAttributesCheck, function( value, name ) {
					if ( 'undefined' === typeof columnParams[ name ] ) {
						columnParams[ name ] = value;
					}
				} );

				// Build column shortcode
				shortcode += '[fusion_builder_column type="' + this.model.attributes.params.type + '"';

				_.each( columnParams, function( value, name ) {
					shortcode += ' ' + name + '="' + value + '"';
				} );

				shortcode += ']';

				// Find elements inside this column
				this.$el.find( '.fusion-builder-live-element:not(.fusion-builder-column-inner .fusion-builder-live-element), .fusion-builder-nested-element' ).each( function() {
					var $thisRowInner;

					// Find standard elements
					if ( jQuery( this ).hasClass( 'fusion-builder-live-element' ) ) {
						shortcode += FusionPageBuilderApp.generateElementShortcode( jQuery( this ), false );

					// Find inner rows
					} else {
						$thisRowInner = FusionPageBuilderViewManager.getView( jQuery( this ).data( 'cid' ) );
						if ( 'undefined' !== typeof $thisRowInner ) {
							shortcode += $thisRowInner.getInnerRowContent();
						}

					}
				} );

				shortcode += '[/fusion_builder_column]';

				return shortcode;
			},

			/**
			 * Removes a column.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the column removal.
			 * @return {void}
			 */
			removeColumn: function( event ) {
				var elements,
					rowView,
					parentCID = this.model.get( 'parent' );

				if ( event ) {
					event.preventDefault();
				}

				elements = FusionPageBuilderViewManager.getChildViews( this.model.get( 'cid' ) );

				_.each( elements, function( element ) {
					if ( 'fusion_builder_row' === element.model.get( 'type' ) || 'fusion_builder_row_inner' === element.model.get( 'type' ) ) {
						element.removeRow();
					} else {
						element.removeElement();
					}
				} );

				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				this._equalHeights( parentCID );

				FusionEvents.trigger( 'fusion-element-removed', this.model.get( 'cid' ) );

				this.model.destroy();

				this.remove();

				// If the column is deleted manually
				if ( event ) {

					// Update preview for spacing.
					rowView = FusionPageBuilderViewManager.getView( parentCID );
					rowView.setRowData();

					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.deleted + ' ' + fusionBuilderText.column );

					FusionEvents.trigger( 'fusion-content-changed' );

					rowView.$el.find( '.fusion-builder-module-controls-container a' ).trigger( 'mouseleave' );
				}
			},

			/**
			 * Adds a child view.
			 *
			 * @since 2.0.0
			 * @param {Object} element - The element.
			 * @return {void}
			 */
			addChildView: function( element ) {

				var view,
					viewSettings = {
						model: element,
						collection: FusionPageBuilderElements,
						attributes: {
							'data-cid': element.get( 'cid' )
						}
					},
					containerSuffix = ':not(.fusion_builder_row_inner .fusion-builder-column-content)';

				if ( 'undefined' !== typeof element.get( 'multi' ) && 'multi_element_parent' === element.get( 'multi' ) ) {

					if ( 'undefined' !== typeof FusionPageBuilder[ element.get( 'element_type' ) ] ) {
						view = new FusionPageBuilder[ element.get( 'element_type' ) ]( viewSettings );
					} else {
						view = new FusionPageBuilder.ParentElementView( viewSettings );
					}

				} else if ( 'undefined' !== typeof FusionPageBuilder[ element.get( 'element_type' ) ] ) {
					view = new FusionPageBuilder[ element.get( 'element_type' ) ]( viewSettings );
				} else if ( 'fusion_builder_row_inner' === element.get( 'element_type' ) ) {
					view = new FusionPageBuilder.InnerRowView( viewSettings );
				} else {
					view = new FusionPageBuilder.ElementView( viewSettings );
				}

				// Add new view to manager.
				FusionPageBuilderViewManager.addView( element.get( 'cid' ), view );

				if (  'undefined' !== typeof this.model && 'fusion_builder_column_inner' === this.model.get( 'type' ) ) {
					containerSuffix = '';
				}

				if ( ! _.isUndefined( element.get( 'targetElement' ) ) && 'undefined' === typeof element.get( 'from' ) ) {
					if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'after' === element.get( 'targetElementPosition' ) ) {
						element.get( 'targetElement' ).after( view.render().el );
					} else {
						element.get( 'targetElement' ).before( view.render().el );
					}
				} else if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'end' === element.get( 'targetElementPosition' ) ) {
					if ( 'fusion_widget' === view.model.get( 'element_type' ) ) {
						// eslint-disable-next-line vars-on-top
						var renderedView = view.render();
						renderedView.$el.find( 'script' ).remove();
						this.$el.find( '.fusion-builder-column-content' + containerSuffix ).append( renderedView.el );
					} else {
						this.$el.find( '.fusion-builder-column-content' + containerSuffix ).append( view.render().el );
					}
				} else {
					this.$el.find( '.fusion-builder-column-content' + containerSuffix ).find( '.fusion-builder-empty-column' ).first().after( view.render().el );
				}

				// Check if we should open the settings or not.
				if ( 'off' !== window.FusionApp.preferencesData.open_settings && 'undefined' !== typeof element.get( 'added' ) ) {
					if ( 'fusion_builder_row_inner' === element.get( 'type' ) ) {
						if ( ! jQuery( 'body' ).hasClass( 'fusion-builder-ui-wireframe' ) ) {
							view.editRow();
						}
					} else {
						view.settings();
					}
				}
			},

			/**
			 * Get the save label.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getSaveLabel: function() {
				return fusionBuilderText.save_column;
			},

			/**
			 * Returns the 'columns' string.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getCategory: function() {
				return 'columns';
			},

			/**
			 * Column spacing dimensions version.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			fallbackColumnSpacing: function( $placeholder, allNo ) {
				var columnSize      = '100%',
					fullcolumnSize  = columnSize,
					existingSpacing = '0%',
					columnWidth     = this.model.attributes.params.type;

				if ( 'yes' === this.model.attributes.params.spacing ) {
					existingSpacing = '4%';
				}

				columnWidth = this.model.attributes.params.type;

				switch ( columnWidth ) {
				case '1_1':
					columnSize     = '100%';
					fullcolumnSize = '100%';
					break;
				case '1_4':
					columnSize     = '22%';
					fullcolumnSize = '25%';
					break;
				case '3_4':
					columnSize     = '74%';
					fullcolumnSize = '75%';
					break;
				case '1_2':
					columnSize     = '48%';
					fullcolumnSize = '50%';
					break;
				case '1_3':
					columnSize     = '30.6666%';
					fullcolumnSize = '33.3333%';
					break;
				case '2_3':
					columnSize     = '65.3333%';
					fullcolumnSize = '66.6666%';
					break;
				case '1_5':
					columnSize     = '16.8%';
					fullcolumnSize = '20%';
					break;
				case '2_5':
					columnSize     = '37.6%';
					fullcolumnSize = '40%';
					break;
				case '3_5':
					columnSize     = '58.4%';
					fullcolumnSize = '60%';
					break;
				case '4_5':
					columnSize     = '79.2%';
					fullcolumnSize = '80%';
					break;
				case '5_6':
					columnSize     = '82.6666%';
					fullcolumnSize = '83.3333%';
					break;
				case '1_6':
					columnSize     = '13.3333%';
					fullcolumnSize = '16.6666%';
					break;
				}

				if ( '4%' !== existingSpacing && ( ! this.model.attributes.params.last || allNo ) ) {
					columnSize = fullcolumnSize;
				}

				this.$el.css( 'width', columnSize );
				$placeholder.css( 'width', columnSize );
				$placeholder.css( 'margin-right', existingSpacing );
				this.$el.css( 'margin-right', existingSpacing );
			},

			scrollHighlight: function( scroll ) {
				var self     = this,
					$trigger = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-one-page-text-link' ),
					$el      = this.$el;

				scroll   = 'undefined' === typeof scroll ? true : scroll;

				setTimeout( function() {
					if ( scroll && $trigger.length && 'function' === typeof $trigger.fusion_scroll_to_anchor_target ) {
						$trigger.attr( 'href', '#fusion-column-' + self.model.get( 'cid' ) ).fusion_scroll_to_anchor_target( 15 );
					}

					$el.find( '> .fusion-column-wrapper' ).addClass( 'fusion-active-highlight' );
					setTimeout( function() {
						$el.find( '> .fusion-column-wrapper' ).removeClass( 'fusion-active-highlight' );
					}, 6000 );
				}, 10 );
			},

			/**
			 * Destroy the droppable and draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			disableDroppableColumn: function() {
				var $el         = this.$el,
					$droppables = $el.find( '.fusion-column-target' );

				if ( 'undefined' !== typeof $el.draggable( 'instance' ) ) {
					$el.draggable( 'destroy' );
				}

				if ( 'undefined' !== typeof $droppables.droppable( 'instance' ) ) {
					$droppables.droppable( 'destroy' );
				}

				if ( 'undefined' !== typeof $el.find( '.fusion-element-target-column' ).droppable( 'instance' ) ) {
					$el.find( '.fusion-element-target-column' ).droppable( 'destroy' );
				}
			},

			/**
			 * Enable the droppable and draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			enableDroppableColumn: function() {
				this.droppableColumn();
			},

			/**
			 * Checks if column layout type is block.
			 *
			 * @since 3.0.0
			 * @return {Boolean}
			 */
			isBlockLayout: function() {
				return this.values && 'block' === this.values.content_layout;
			},

			/**
			 * Initialize element sortable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			sortableElements: function() {
				var self = this;

				this.$el.find( '.fusion-builder-column-content' ).sortable( {
					items: '.fusion-builder-live-element:not(.fusion_builder_row_inner .fusion-builder-live-element), .fusion_builder_row_inner',
					connectWith: '.fusion-builder-column-content',
					cancel: '.fusion-builder-settings, .fusion-builder-clone, .fusion-builder-row-clone, .fusion-builder-remove, .fusion-builder-add-element, .fusion-builder-insert-column, .fusion-builder-save-module-dialog, .fusion-builder-row-remove, .fusion-builder-save-inner-row-dialog-button, .fusion_builder_row_inner .fusion-builder-row-content',
					tolerance: 'pointer',
					appendTo: FusionPageBuilderApp.$el,
					helper: 'clone',
					disabled: ! FusionPageBuilderApp.wireframeActive,
					over: function( event ) {
						self.onSortOver( event );
					},

					update: function( event, ui ) {
						self.onSortUpdate( event, ui );
					},

					stop: function( event, ui ) {
						self.onSortStop( event, ui );
					}
				} );
			}
		} );
	} );
}( jQuery ) );
;/* global FusionApp, cssua, FusionPageBuilderApp, FusionPageBuilderViewManager, fusionAllElements, fusionBuilderText, FusionEvents, FusionPageBuilderElements */
/* jshint -W020 */
/* eslint no-shadow: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Container View
		FusionPageBuilder.ContainerView = FusionPageBuilder.BaseView.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-container-template' ).html() ),
			className: function() {
				var classes = 'fusion-builder-container fusion-builder-data-cid',
					values  = _.fusionCleanParameters( jQuery.extend( true, {}, this.model.get( 'params' ) ) );

				if ( 'yes' === values.hundred_percent_height_scroll && 'yes' === values.hundred_percent_height ) {
					classes += ' scrolling-helper';
				}

				if ( this.isFlex ) {
					classes += ' fusion-builder-flex-container';
				}

				// Absolute container.
				if ( 'undefined' !== typeof values.absolute && 'on' === values.absolute ) {
					classes += ' fusion-builder-absolute-container-wrapper';
				}

				return classes;
			},
			events: {
				'click .fusion-builder-container-settings': 'settings',
				'click .fusion-builder-container-remove': 'removeContainer',
				'click .fusion-builder-container-clone': 'cloneContainer',
				'click .fusion-builder-container-add': 'addContainer',
				'click .fusion-builder-container-save': 'openLibrary',
				'paste .fusion-builder-section-name': 'renameContainer',
				'keydown .fusion-builder-section-name': 'renameContainer',
				'click .fusion-builder-toggle': 'toggleContainer',
				'click .fusion-builder-publish-tooltip': 'publish',
				'click .fusion-builder-unglobal-tooltip': 'unglobalize',
				'click .fusion-builder-container-drag': 'preventDefault'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
				var cid = this.model.get( 'cid' ),
					el  = this.$el;

				el.attr( 'data-cid', cid );
				el.attr( 'id', 'fusion-container-' + cid );

				if ( 'undefined' !== typeof this.model.attributes.params && 'undefined' !== typeof this.model.attributes.params.fusion_global ) {
					el.attr( 'fusion-global-layout', this.model.attributes.params.fusion_global );
					this.$el.removeClass( 'fusion-global-container' ).addClass( 'fusion-global-container' );
				}

				this.listenTo( FusionEvents, 'fusion-view-update-fusion_builder_container', this.reRender );
				this.listenTo( FusionEvents, 'fusion-param-changed-' + this.model.get( 'cid' ), this.onOptionChange );
				// Responsive control updates on resize.
				this.listenTo( FusionEvents, 'fusion-preview-viewport-update', this.onPreviewResize );

				this._triggerCallback = _.debounce( _.bind( this.triggerCallback, this ), 200 );

				this.model.children = new FusionPageBuilder.Collection();
				this.listenTo( this.model.children, 'add', this.addChildView );

				this.listenTo( FusionEvents, 'fusion-wireframe-toggle', this.wireFrameToggled );

				this.renderedYet          = FusionPageBuilderApp.loaded;
				this._refreshJs           = _.debounce( _.bind( this.refreshJs, this ), 300 );
				this._triggerScrollUpdate = _.debounce( _.bind( this.triggerScrollUpdate, this ), 300 );
				this._reInitSticky        = _.debounce( _.bind( this.reInitSticky, this ), 300 );
				this._updateInnerStyles	  = _.debounce( _.bind( this.updateInnerStyles, this ), 500 );

				this.typingTimer; // jshint ignore:line
				this.doneTypingInterval = 800;

				this.scrollingSections = false;

				this.settingsControlsOffset = 0;
				this.width = el.width();
				el.on( 'mouseenter', _.bind( this.setSettingsControlsOffset, this ) );
				this.correctStackingContextForFilters();

				this.deprecatedParams();

				this.baseInit();

				this.reInitDraggables = false;
			},

			/**
			 * Set correct top offset for the container setting controls.
			 *
			 * @since 2.0
			 * @param {boolean} forced - Whether to force an update and bypass checks.
			 * @return {void}
			 */
			setSettingsControlsOffset: function( forced ) {
				var offset = 15,
					customOffset;

				if ( ( 'undefined' !== typeof forced || 0 === this.settingsControlsOffset || this.width !== this.$el.width() ) && ( 'undefined' !== typeof window.frames[ 0 ].getStickyHeaderHeight || 'undefined' !== typeof window.frames[ 0 ].fusionGetStickyOffset ) ) {
					// if we have sticky enabled, get its height.
					if ( 'off' !== FusionApp.preferencesData.sticky_header && 'on' !== this.values.sticky ) {

						// If we have a custom header, use function to retrieve lowest point.
						if ( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-tb-header' ).length && 'function' === typeof window.frames[ 0 ].fusionGetStickyOffset ) {
							customOffset = window.frames[ 0 ].fusionGetStickyOffset();
							if ( customOffset ) {
								offset += customOffset;
							}
						} else if ( 'undefined' !== typeof window.frames[ 0 ].getStickyHeaderHeight ) {
							offset += window.frames[ 0 ].getStickyHeaderHeight( true );
						}
					}

					this.settingsControlsOffset = offset + 'px';
					this.width                  = this.$el.width();

					this.$el.find( '.fusion-builder-module-controls-container-wrapper .fusion-builder-module-controls-type-container' ).css( 'top', this.settingsControlsOffset );
				}

				if ( this.$el.find( '.fusion-builder-empty-container' ).is( ':visible' ) ) {
					this.$el.find( '.fusion-builder-module-controls-container-wrapper .fusion-builder-module-controls-type-container' ).css( 'margin-top', '8.5px' );
				} else {
					this.$el.find( '.fusion-builder-module-controls-container-wrapper .fusion-builder-module-controls-type-container' ).css( 'margin-top', '' );
				}
			},

			/**
			 * Corrects the stacking context if filters are used, to make all elements accessible.
			 *
			 * @since 2.2
			 * @return {void}
			 */
			correctStackingContextForFilters: function() {
				var parent = this.$el;


				this.$el.on( 'mouseenter', '.fusion-fullwidth', function() {
					if ( 'none' !== jQuery( this ).css( 'filter' ) ) {
						parent.addClass( 'fusion-has-filters' );
					}
				} );

				this.$el.on( 'mouseleave', '.fusion-fullwidth', function() {
					if ( ! parent.hasClass( 'fusion-container-editing-child' ) ) {
						parent.removeClass( 'fusion-has-filters' );
					}
				} );
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var self = this,
					data = this.getTemplateAtts();

				this.$el.html( this.template( data ) );
				this.appendChildren();

				if ( this.renderedYet ) {
					this._refreshJs();

					// Trigger equal height columns js
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-option-change-equal_height_columns', this.model.attributes.cid );
				}

				if ( 'undefined' !== typeof this.model.attributes.params.admin_toggled && 'yes' === this.model.attributes.params.admin_toggled ) {
					this.$el.addClass( 'fusion-builder-section-folded' );
					this.$el.find( '.fusion-builder-toggle > span' ).toggleClass( 'fusiona-caret-up' ).toggleClass( 'fusiona-caret-down' );
				}

				this.onRender();

				this.renderedYet = true;

				setTimeout( function() {
					self.droppableContainer();
				}, 100 );

				this._triggerScrollUpdate();

				return this;
			},

			/**
			 * Adds drop zones for continers and makes container draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			droppableContainer: function() {

				var $el   = this.$el,
					cid   = this.model.get( 'cid' ),
					$body = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' );

				if ( ! $el ) {
					return;
				}

				$el.draggable( {
					appendTo: FusionPageBuilderApp.$el,
					zIndex: 999999,
					delay: 100,
					cursorAt: { top: 15, left: 15 },
					iframeScroll: true,
					containment: $body,
					cancel: '.fusion-builder-column',
					helper: function() {
						var $classes = FusionPageBuilderApp.DraggableHelpers.draggableClasses( cid );
						return jQuery( '<div class="fusion-container-helper ' + $classes + '" data-cid="' + cid + '"><span class="fusiona-container"></span></div>' );
					},
					start: function() {
						$body.addClass( 'fusion-container-dragging fusion-active-dragging' );
						$el.addClass( 'fusion-being-dragged' );

						//  Add a class to hide the unnecessary target after.
						if ( $el.prev( '.fusion-builder-container' ).length ) {
							$el.prev( '.fusion-builder-container' ).addClass( 'hide-target-after' );
						}

						if ( $el.prev( '.fusion-fusion-builder-next-pager' ).length ) {
							$el.prev( '.fusion-fusion-builder-next-page' ).addClass( 'hide-target-after' );
						}
					},
					stop: function() {
						setTimeout( function() {
							$body.removeClass( 'fusion-container-dragging fusion-active-dragging' );
						}, 10 );
						$el.removeClass( 'fusion-being-dragged' );
						FusionPageBuilderApp.$el.find( '.hide-target-after' ).removeClass( 'hide-target-after' );
					}
				} );

				$el.find( '.fusion-container-target' ).droppable( {
					tolerance: 'touch',
					hoverClass: 'ui-droppable-active',
					accept: '.fusion-builder-container, .fusion-builder-next-page',
					drop: function( event, ui ) {

						// Move the actual html.
						if ( jQuery( event.target ).hasClass( 'target-after' ) ) {
							$el.after( ui.draggable );
						} else {
							$el.before( ui.draggable );
						}

						FusionEvents.trigger( 'fusion-content-changed' );

						FusionPageBuilderApp.scrollingContainers();

						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.full_width_section + ' order changed' );
					}
				} );

				// If we are in wireframe mode, then disable.
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.disableDroppableContainer();
				}
			},

			/**
			 * Enable the droppable and draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			enableDroppableContainer: function() {
				var $el = this.$el;

				if ( 'undefined' !== typeof $el.draggable( 'instance' ) && 'undefined' !== typeof $el.find( '.fusion-container-target' ).droppable( 'instance' ) ) {
					$el.draggable( 'enable' );
					$el.find( '.fusion-container-target' ).droppable( 'enable' );
				} else {

					// No sign of init, then need to call it.
					this.droppableContainer();
				}
			},

			/**
			 * Destroy or disable the droppable and draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			disableDroppableContainer: function() {
				var $el = this.$el;

				// If its been init, just disable.
				if ( 'undefined' !== typeof $el.draggable( 'instance' ) ) {
					$el.draggable( 'disable' );
				}

				// If its been init, just disable.
				if ( 'undefined' !== typeof $el.find( '.fusion-container-target' ).droppable( 'instance' ) ) {
					$el.find( '.fusion-container-target' ).droppable( 'disable' );
				}
			},

			/**
			 * Fired when wireframe mode is toggled.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			wireFrameToggled: function() {
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.disableDroppableContainer();
				} else {
					this.enableDroppableContainer();
				}
			},

			/**
			 * Get the template.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getTemplate: function() {
				var atts = this.getTemplateAtts();

				return this.template( atts );
			},

			/**
			 * Remove deprecated params.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			deprecatedParams: function() {
				var params               = this.model.get( 'params' ),
					defaults             = fusionAllElements.fusion_builder_container.defaults,
					values               = jQuery.extend( true, {}, defaults, params ),
					alphaBackgroundColor = 1,
					radiaDirectionsNew   = { 'bottom': 'center bottom', 'bottom center': 'center bottom', 'left': 'left center', 'right': 'right center', 'top': 'center top', 'center': 'center center', 'center left': 'left center' };

				params = _.fusionContainerMapDeprecatedArgs( params );

				// If no blend mode is defined, check if we should set to overlay.
				if ( 'undefined' === typeof params.background_blend_mode && '' !== values.background_color  ) {
					alphaBackgroundColor = jQuery.Color( values.background_color ).alpha();
					if ( 1 > alphaBackgroundColor && 0 !== alphaBackgroundColor && ( '' !== params.background_image || '' !== params.video_bg ) ) {
						params.background_blend_mode = 'overlay';
					}
				}

				// Check if we have an old border-size. If we do, then we need to migrate it to the new options
				// and delete the old param.
				if ( 'undefined' !== typeof params.border_size ) {
					if ( '' !== params.border_size ) {
						params.border_sizes_top    = parseInt( params.border_size ) + 'px';
						params.border_sizes_bottom = parseInt( params.border_size ) + 'px';
						params.border_sizes_left   = '0px';
						params.border_sizes_right  = '0px';
					}
					delete params.border_size;
				}

				// Correct radial direction params.
				if ( 'undefined' !== typeof params.radial_direction && ( params.radial_direction in radiaDirectionsNew ) ) {
					params.radial_direction = radiaDirectionsNew[ values.radial_direction ];
				}

				// No column align, but equal heights is on, set to stretch.
				if ( 'undefined' === typeof params.flex_align_items && 'undefined' !== typeof params.equal_height_columns && 'yes' === params.equal_height_columns ) {
					params.flex_align_items = 'stretch';
				}

				// No align content, but it is 100% height and centered.
				if ( 'undefined' === typeof params.align_content && 'undefined' !== typeof params.hundred_percent_height && 'yes' === params.hundred_percent_height && 'undefined' !== typeof params.hundred_percent_height_center_content && 'yes' === params.hundred_percent_height_center_content ) {
					params.align_content = 'center';
				}

				// If legacy mode is off, remove param, causes it to run migration and then setType is called.
				if ( ( 'undefined' === typeof params.type || 'flex' !== params.type ) && 'undefined' !== typeof fusionAllElements.fusion_builder_container.extras.container_legacy_support && ( 0 === fusionAllElements.fusion_builder_container.extras.container_legacy_support || '0' === fusionAllElements.fusion_builder_container.extras.container_legacy_support || false === fusionAllElements.fusion_builder_container.extras.container_legacy_support ) ) {
					delete params.type;
				}

				this.model.set( 'params', params );
			},

			/**
			 * Set type to ensure migration does not run on front-end.
			 *
			 * @since 3.0
			 * @return {Void}
			 */
			setType: function() {
				var params   = this.model.get( 'params' ),
					defaults = fusionAllElements.fusion_builder_container.defaults;

				if ( 'undefined' === typeof params.type ) {
					params.type = defaults.type;
				}

				this.model.set( 'params', params );
			},

			/**
			 * Get dynamic values.
			 *
			 * @since 2.0.0
			 * @return {Object}
			 */
			getDynamicAtts: function( values ) {
				var self = this;

				if ( 'undefined' !== typeof this.dynamicParams && this.dynamicParams && ! _.isEmpty( this.dynamicParams.getAll() ) ) {
					_.each( this.dynamicParams.getAll(), function( data, id ) {
						var value = self.dynamicParams.getParamValue( data );

						if ( 'undefined' !== typeof value && false !== value ) {
							values[ id ] = value;
						}
					} );
				}
				return values;
			},

			setValues: function() {
				var element		= fusionAllElements[ this.model.get( 'element_type' ) ],
					defaults 	= fusionAllElements.fusion_builder_container.defaults,
					params		= jQuery.extend( true, {}, this.model.get( 'params' ) ),
					extras		= {},
					values		= {};

				extras = jQuery.extend( true, {}, fusionAllElements.fusion_builder_container.extras );

				// If 100 page template.
				if ( FusionPageBuilderApp.$el.find( '#main' ).hasClass( 'width-100' ) && 'undefined' !== typeof extras.container_padding_100 ) {
					defaults.padding_top    = extras.container_padding_100.top;
					defaults.padding_right  = extras.container_padding_100.right;
					defaults.padding_bottom = extras.container_padding_100.bottom;
					defaults.padding_left   = extras.container_padding_100.left;
				} else if ( ! FusionPageBuilderApp.$el.find( '#main' ).hasClass( 'width-100' ) && 'undefined' !== typeof extras.container_padding_default ) {
					defaults.padding_top    = extras.container_padding_default.top;
					defaults.padding_right  = extras.container_padding_default.right;
					defaults.padding_bottom = extras.container_padding_default.bottom;
					defaults.padding_left   = extras.container_padding_default.left;
				}

				params = _.fusionCleanParameters( params );

				// Set values & extras
				if ( element && 'undefined' !== typeof element.defaults ) {
					values = jQuery.extend( true, {}, defaults, params );
				}

				// Default value is an array, so we need to convert it to string.
				if ( Array.isArray( values.absolute_devices ) ) {
					values.absolute_devices = values.absolute_devices.join( ',' );
				}

				values = this.getDynamicAtts( values );

				this.defaults			= defaults;
				this.values 			= values;
				this.params				= params;

				if ( 'on' === this.values.sticky ) {
					this.values.background_parallax = 'none';
					this.values.fade                = 'no';
				}
			},

			/**
			 * Set extra args.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			setExtraValues: function() {
				this.values.alpha_background_color = jQuery.Color( this.values.background_color ).alpha();
			},

			contentStyle: function() {
				var self = this,
					contentStyle = '';

				if ( 'yes' === this.values.hundred_percent_height && 'yes' === this.values.hundred_percent_height_center_content ) {
					// Get correct container padding.
					jQuery.each( [ 'top', 'right', 'bottom', 'left' ], function( index, padding ) {
						var paddingName = 'padding_' + padding;

						// Add padding to style.
						if ( '' !== self.values[ paddingName ] ) {
							contentStyle += 'padding-' + padding + ':' + _.fusionGetValueWithUnit( self.values[ paddingName ] ) + ';';
						}
					} );
				}

				return contentStyle;
			},

			/**
			 * Sets container video data args.
			 *
			 * @access public
			 * @since 3.0
			 * @return void
			 */
			setContainerVideoData: function() {
				// If no blend mode is defined, check if we should set to overlay.
				if ( 'undefined' !== typeof this.values.background_blend_mode &&
					1 > this.values.alpha_background_color &&
					0 !== this.values.alpha_background_color &&
					! this.is_gradient_color &&
					( this.background_image || this.values.video_bg ) ) {
					this.values.background_blend_mode = 'overlay';
				}

				this.values.video_bg = false;
				if ( this.values.video_mp4 || this.values.video_webm || this.values.video_ogv || this.values.video_url ) {
					this.values.video_bg = true;
				}
			},

			parallaxAttr: function() {
				var attr 			= {},
					bgColorAlpha 	= jQuery.Color( this.values.background_color ).alpha();

				attr[ 'class' ] = 'fusion-bg-parallax';

				attr[ 'data-bg-align' ]       = this.values.background_position;
				attr[ 'data-direction' ]      = this.values.background_parallax;
				attr[ 'data-mute' ]           = 'mute' === this.values.video_mute ? 'true' : 'false';
				attr[ 'data-opacity' ]        = this.values.opacity;
				attr[ 'data-velocity' ]       = this.values.parallax_speed * -1;
				attr[ 'data-mobile-enabled' ] = 'yes' === this.values.enable_mobile ? 'true' : 'false';
				attr[ 'data-break_parents' ]  = this.values.break_parents;
				attr[ 'data-bg-image' ]       = this.values.background_image;
				attr[ 'data-bg-repeat' ]      = this.values.background_repeat && 'no-repeat' !== this.values.background_repeat ? 'true' : 'false';

				if ( 0 !== bgColorAlpha ) {
					attr[ 'data-bg-color' ] = this.values.background_color;
				}

				if ( 'none' !== this.values.background_blend_mode ) {
					attr[ 'data-blend-mode' ] = this.values.background_blend_mode;
				}

				if ( this.values.is_gradient_color ) {
					attr[ 'data-bg-gradient-type' ]           = this.values.gradient_type;
					attr[ 'data-bg-gradient-angle' ]          = this.values.linear_angle;
					attr[ 'data-bg-gradient-start-color' ]    = this.values.gradient_start_color;
					attr[ 'data-bg-gradient-start-position' ] = this.values.gradient_start_position;
					attr[ 'data-bg-gradient-end-color' ]      = this.values.gradient_end_color;
					attr[ 'data-bg-gradient-end-position' ]   = this.values.gradient_end_position;
					attr[ 'data-bg-radial-direction' ]        = this.values.radial_direction;
				}

				attr[ 'data-bg-height' ] = this.values.data_bg_height;
				attr[ 'data-bg-width' ]  = this.values.data_bg_width;

				return attr;
			},

			isFlex: function() {
				return this.values && 'flex' === this.values.type;
			},

			attr: function() {
				var attr = {
					'class': 'fusion-fullwidth fullwidth-box fusion-builder-row-live-' + this.model.get( 'cid' ),
					'style': ''
				},
					self = this;

				// Background.
				if ( '' !== this.values.background_color && ! ( 'yes' === this.values.fade && '' !== this.values.background_image && false === this.values.video_bg ) ) {
					attr.style += 'background-color: ' + this.values.background_color + ';';
				}

				if ( '' !== this.values.background_image && 'yes' !== this.values.fade ) {
					attr.style += 'background-image: url(\'' + this.values.background_image + '\');';
				}

				if ( '' !== _.getGradientString( this.values, 'main_bg' ) ) {
					attr.style += 'background-image: ' + _.getGradientString( this.values, 'main_bg' ) + ';';
				}

				if ( '' !== this.values.background_position ) {
					attr.style += 'background-position: ' + this.values.background_position + ';';
				}

				if ( '' !== this.values.background_repeat ) {
					attr.style += 'background-repeat: ' + this.values.background_repeat + ';';
				}

				if ( 'none' !== this.values.background_blend_mode ) {
					attr.style += 'background-blend-mode: ' + this.values.background_blend_mode + ';';
				}

				// Add box-shadow styles.
				if ( 'yes' === this.values.box_shadow ) {
					attr.style += 'box-shadow:' + _.fusionGetBoxShadowStyle( this.values ).replace( ';', '' ) + ' !important;';
				}

				if ( ! this.isFlex() ) {
					// Get correct container padding.
					jQuery.each( [ 'top', 'right', 'bottom', 'left' ], function( index, padding ) {
						var paddingName = 'padding_' + padding;

						// Add padding to style.
						if ( '' !== self.values[ paddingName ] ) {
							attr.style += 'padding-' + padding + ':' + _.fusionGetValueWithUnit( self.values[ paddingName ] ) + ';';
						}
					} );

					// Margin; for separator conversion only.
					if ( '' !== this.values.margin_bottom ) {
						attr.style += 'margin-bottom: ' + _.fusionGetValueWithUnit( this.values.margin_bottom ) + ';';
					}

					if ( '' !== this.values.margin_top ) {
						attr.style += 'margin-top: ' + _.fusionGetValueWithUnit( this.values.margin_top ) + ';';
					}
				}

				// Border.
				if ( 'undefined' === typeof this.values.border_sizes_top || '' === this.values.border_sizes_top ) {
					this.values.border_sizes_top = 0;
				}
				if ( 'undefined' === typeof this.values.border_sizes_bottom || '' === this.values.border_sizes_bottom ) {
					this.values.border_sizes_bottom = 0;
				}
				if ( 'undefined' === typeof this.values.border_sizes_left || '' === this.values.border_sizes_left ) {
					this.values.border_sizes_left = 0;
				}
				if ( 'undefined' === typeof this.values.border_sizes_right || '' === this.values.border_sizes_right ) {
					this.values.border_sizes_right = 0;
				}
				attr.style += 'border-top:' + _.fusionGetValueWithUnit( this.values.border_sizes_top ) + ' ' + this.values.border_style + ' ' + this.values.border_color + ';';
				attr.style += 'border-bottom:' + _.fusionGetValueWithUnit( this.values.border_sizes_bottom ) + ' ' + this.values.border_style + ' ' + this.values.border_color + ';';
				attr.style += 'border-left:' + _.fusionGetValueWithUnit( this.values.border_sizes_left ) + ' ' + this.values.border_style + ' ' + this.values.border_color + ';';
				attr.style += 'border-right:' + _.fusionGetValueWithUnit( this.values.border_sizes_right ) + ' ' + this.values.border_style + ' ' + this.values.border_color + ';';

				if ( '' !== this.values.background_image && false === this.values.video_bg ) {
					if ( 'no-repeat' === this.values.background_repeat ) {
						attr.style += '-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;';
					}
				}

				if ( this.isFlex() ) {
					attr[ 'class' ] += ' fusion-flex-container';
					if ( 'stretch' !== this.values.align_content ) {
						attr[ 'class' ] += ' fusion-flex-align-content-' + this.values.align_content;
					}
				}

				if ( this.values.video_bg ) {
					attr[ 'class' ] += ' video-background';
				}

				if ( ( cssua.ua.ie || cssua.ua.edge ) && 1 > this.values.alpha_background_color ) {
					attr[ 'class' ] += ' fusion-ie-mode';
				}

				// Fading Background.
				if ( 'yes' === this.values.fade && '' !== this.values.background_image && false === this.values.video_bg ) {
					attr[ 'class' ] += ' faded-background';
				}

				// Parallax.
				if ( false === this.values.video_bg && '' !== this.values.background_image ) {
					// Parallax css class+
					if ( '' !== this.values.background_parallax ) {
						attr[ 'class' ] += ' fusion-parallax-' + this.values.background_parallax;
					}
					if  ( 'fixed' === this.values.background_parallax ) {
						attr.style += 'background-attachment:' + this.values.background_parallax + ';';
					}
				}

				// Minimum height.
				if ( 'min' === this.values.hundred_percent_height && '' !== this.values.min_height ) {

					if ( -1 !== this.values.min_height.indexOf( '%' ) ) {
						this.values.min_height = this.values.min_height.replace( '%', 'vh' );
					}

					attr.style += 'min-height:' + _.fusionGetValueWithUnit( this.values.min_height ) + ';';
				}

				// Custom CSS class+
				if ( '' !== this.values[ 'class' ] ) {
					attr[ 'class' ] += ' ' + this.values[ 'class' ];
				}

				attr[ 'class' ] += ( 'yes' === this.values.hundred_percent ) ? ' hundred-percent-fullwidth' : ' nonhundred-percent-fullwidth';

				attr[ 'class' ] += ( 'yes' === this.values.hundred_percent_height_scroll && 'yes' === this.values.hundred_percent_height ) ? ' fusion-scrolling-section-edit' : '';
				attr[ 'class' ] += ( 'yes' === this.values.hundred_percent_height ) ? ' non-hundred-percent-height-scrolling' : '';
				attr[ 'class' ] += ( 'yes' === this.values.hundred_percent_height && 'yes' !== this.values.hundred_percent_height_center_content ) ? ' hundred-percent-height' : '';
				attr[ 'class' ] += ( 'yes' === this.values.hundred_percent_height && 'yes' === this.values.hundred_percent_height_center_content ) ? ' hundred-percent-height-center-content' : '';

				// Equal column height.
				if ( 'yes' === this.values.equal_height_columns && ! this.isFlex() ) {
					attr[ 'class' ] += ' fusion-equal-height-columns';
				}

				// Hundred percent height and centered content, if added to centerContentClass then the padding makes the container too large.
				if ( 'yes' === this.values.hundred_percent_height && 'yes' === this.values.hundred_percent_height_center_content ) {
					attr[ 'class' ] += ' hundred-percent-height non-hundred-percent-height-scrolling';
				}

				// Visibility classes.
				attr[ 'class' ] = _.fusionVisibilityAtts( this.values.hide_on_mobile, attr[ 'class' ] );

				// Animations.
				attr = _.fusionAnimations( this.values, attr );

				// Custom CSS ID.
				if ( '' !== this.values.id ) {
					attr.id = this.values.id;
				}

				// Sticky container.
				if ( 'on' === this.values.sticky ) {
					attr[ 'class' ] += ' fusion-sticky-container';

					if ( '' !== this.values.sticky_transition_offset && 0 !== this.values.sticky_transition_offset ) {
						attr[ 'data-transition-offset' ] = parseFloat( this.values.sticky_transition_offset );
					}
					if ( '' !== this.values.sticky_offset && 0 !== this.values.sticky_offset ) {
						attr[ 'data-sticky-offset' ] = this.values.sticky_offset;
					}
					if ( '' !== this.values.scroll_offset && 0 !== this.values.scroll_offset ) {
						attr[ 'data-scroll-offset' ] = parseFloat( this.values.scroll_offset );
					}

					if ( '' !== this.values.sticky_devices ) {
						if ( 'string' === typeof this.values.sticky_devices ) {
							this.values.sticky_devices = this.values.sticky_devices.split( ',' );
						}
						_.each( this.values.sticky_devices, function( stickyDevice ) {
							attr[ 'data-sticky-' + stickyDevice.replace( /\s/g, '' ) ] = true;
						} );
					}
				}

				// z-index.
			if ( 'undefined' !== typeof this.values.z_index && '' !== this.values.z_index ) {
				attr[ 'class' ] += ' fusion-custom-z-index';
			}

			// Absolute container.
			if ( 'undefined' !== typeof this.values.absolute && 'on' === this.values.absolute ) {
				attr[ 'class' ] += ' fusion-absolute-container';

				if ( 'undefined' !== typeof this.values.absolute_devices && '' !== this.values.absolute_devices ) {
					_.each( this.values.absolute_devices.split( ',' ), function( absoluteDevice ) {
						attr[ 'class' ] += ' fusion-absolute-position-' + absoluteDevice;
					} );
				}
			}

				return attr;
			},

			createVideoBackground: function() {
				var videoBackground = '',
					overlayStyle	= '',
					cid				= this.model.get( 'cid' ),
					videoAttributes,
					videoPreviewImageStyle,
					videoUrl,
					videoSrc,
					loop;

					// Videos.
				if ( 'undefined' !== typeof this.values.video_mp4 && '' !== this.values.video_mp4 ) {
					videoSrc += '<source src="' + this.values.video_mp4 + '" type="video/mp4">';
				}

				if ( 'undefined' !== typeof this.values.video_webm && '' !== this.values.video_webm ) {
					videoSrc += '<source src="' + this.values.video_webm + '" type="video/webm">';
				}

				if ( 'undefined' !== typeof this.values.video_ogv && '' !== this.values.video_ogv ) {
					videoSrc += '<source src="' + this.values.video_ogv + '" type="video/ogg">';
				}

				if ( '' !== this.values.video_url ) {
					videoUrl = _.fusionGetVideoProvider( this.values.video_url ),
					loop     = ( 'yes' === this.values.video_loop ? 1 : 0 );
					if ( 'youtube' === videoUrl.type ) {
						videoBackground += '<div style=\'opacity:0;\' class=\'fusion-background-video-wrapper\' id=\'video-' + cid + '\' data-youtube-video-id=\'' + videoUrl.id + '\' data-mute=\'' + this.values.video_mute + '\' data-loop=\'' + loop + '\' data-loop-adjustment=\'' + this.values.video_loop_refinement + '\' data-video-aspect-ratio=\'' + this.values.video_aspect_ratio + '\'><div class=\'fusion-container-video-bg\' id=\'video-' + cid + '-inner\'></div></div>';
					} else if ( 'vimeo' === videoUrl.type ) {
						videoBackground += '<div id="video-' + cid + '" data-vimeo-video-id="' + videoUrl.id + '" data-mute="' + this.values.video_mute + '" data-video-aspect-ratio="' + this.values.video_aspect_ratio + ' }}" style="visibility:hidden;"><iframe id="video-iframe-' + cid + '" src="//player.vimeo.com/video/' + videoUrl.id + '?api=1&player_id=video-iframe-' + cid + '&html5=1&autopause=0&autoplay=1&badge=0&byline=0&loop=' + loop + '&title=0" frameborder="0"></iframe></div>';
					}
				} else {
					videoAttributes = 'preload="auto" autoplay playsinline';

					if ( 'yes' === this.values.video_loop ) {
						videoAttributes += ' loop';
					}

					if ( 'yes' === this.values.video_mute ) {
						videoAttributes += ' muted';
					}

					// Video Preview Image.
					if ( '' !== this.values.video_preview_image ) {
						videoPreviewImageStyle = 'background-image: url(\'' + this.values.video_preview_image + '\');';
						videoBackground += '<div class="fullwidth-video-image" style="' + videoPreviewImageStyle + '"></div>';
					}

					videoBackground += '<div class="fullwidth-video"><video ' + videoAttributes + '>' + videoSrc + '</video></div>';
				}

				// Video Overlay.
				if ( '' !== _.getGradientString( this.values ) ) {
					overlayStyle += 'background-image:' + _.getGradientString( this.values ) + ';';
				}

				if ( '' !== this.values.background_color && 1 > jQuery.Color( this.values.background_color ).alpha() ) {
					overlayStyle += 'background-color:' + this.values.background_color + ';';
				}

				if ( '' !== overlayStyle ) {
					videoBackground   += '<div class="fullwidth-overlay" style="' + overlayStyle + '"></div>';
				}

				return videoBackground;
			},

			fadingBackgroundAttr: function() {
				var attr = {
					class: 'fullwidth-faded'
				};

				// Fading Background.
				if ( 'yes' === this.values.fade && '' !== this.values.background_image && false === this.values.video_bg ) {

					if ( this.values.background_parallax ) {
						attr.style += 'background-attachment:' + this.values.background_parallax + ';';
					}

					if ( this.values.background_color ) {
						attr.style += 'background-color:' + this.values.background_color + ';';
					}

					if ( this.values.background_image ) {
						attr.style += 'background-image: url(' + this.values.background_image + ');';
					}

					if ( '' !== _.getGradientString( this.values, 'fade' ) ) {
						attr.style += 'background-image: ' + _.getGradientString( this.values, 'fade' ) + ';';
					}

					if ( this.values.background_position ) {
						attr.style += 'background-position:' + this.values.background_position + ';';
					}

					if ( this.values.background_repeat ) {
						attr.style += 'background-repeat:' + this.values.background_repeat + ';';
					}

					if ( 'none' !== this.values.background_blend_mode ) {
						attr.style += 'background-blend-mode: ' + this.values.background_blend_mode + ';';
					}

					if ( 'no-repeat' === this.values.background_repeat ) {
						attr.style += '-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;';
					}
				}
				return attr;
			},

			styleBlock: function() {
				var styleBlock 				= '',
					cid						= this.model.get( 'cid' ),
					stylePrefix				= '.fusion-fullwidth.fusion-builder-row-live-' + cid + ' .fusion-builder-element-content',
					linkExclusionSelectors 	= ' a:not(.fusion-button):not(.fusion-builder-module-control):not(.fusion-social-network-icon):not(.fb-icon-element):not(.fusion-countdown-link):not(.fusion-rollover-link):not(.fusion-rollover-gallery):not(.add_to_cart_button):not(.show_details_button):not(.product_type_external):not(.fusion-quick-view):not(.fusion-rollover-title-link):not(.fusion-breadcrumb-link)';

				if ( 'undefined' !== typeof this.params.link_color && '' !== this.params.link_color ) {
					styleBlock += stylePrefix + linkExclusionSelectors + ', ';
					styleBlock += stylePrefix + linkExclusionSelectors + ':before, ';
					styleBlock += stylePrefix + linkExclusionSelectors + ':after ';
					styleBlock += '{color: ' + this.params.link_color + ';}';
				}

				if ( 'undefined' !== typeof this.params.link_hover_color && '' !== this.params.link_hover_color ) {
					styleBlock += stylePrefix + linkExclusionSelectors + ':hover, ' + stylePrefix + linkExclusionSelectors + ':hover:before, ' + stylePrefix + linkExclusionSelectors + ':hover:after {color: ' + this.params.link_hover_color + ';}';
					styleBlock += stylePrefix + ' .pagination a.inactive:hover, ' + stylePrefix + ' .fusion-filters .fusion-filter.fusion-active a {border-color: ' + this.params.link_hover_color + ';}';
					styleBlock += stylePrefix + ' .pagination .current {border-color: ' + this.params.link_hover_color + '; background-color: ' + this.params.link_hover_color + ';}';
					styleBlock += stylePrefix + ' .fusion-filters .fusion-filter.fusion-active a, ' + stylePrefix + ' .fusion-date-and-formats .fusion-format-box, ' + stylePrefix + ' .fusion-popover, ' + stylePrefix + ' .tooltip-shortcode {color: ' + this.params.link_hover_color + ';}';
					styleBlock += '#wrapper ' + stylePrefix + ' .fusion-widget-area .fusion-vertical-menu-widget .menu li.current_page_ancestor > a, #wrapper ' + stylePrefix + ' .fusion-widget-area .fusion-vertical-menu-widget .menu li.current_page_ancestor > a:before, #wrapper ' + stylePrefix + ' .fusion-widget-area .fusion-vertical-menu-widget .current-menu-item > a, #wrapper ' + stylePrefix + ' .fusion-widget-area .fusion-vertical-menu-widget .current-menu-item > a:before, #wrapper ' + stylePrefix + ' .fusion-widget-area .fusion-vertical-menu-widget .current_page_item > a, #wrapper ' + stylePrefix + ' .fusion-widget-area .fusion-vertical-menu-widget .current_page_item > a:before {color: ' + this.params.link_hover_color + ';}';
					styleBlock += '#wrapper ' + stylePrefix + ' .fusion-widget-area .widget_nav_menu .menu li.current_page_ancestor > a, #wrapper ' + stylePrefix + ' .fusion-widget-area .widget_nav_menu .menu li.current_page_ancestor > a:before, #wrapper ' + stylePrefix + ' .fusion-widget-area .widget_nav_menu .current-menu-item > a, #wrapper ' + stylePrefix + ' .fusion-widget-area .widget_nav_menu .current-menu-item > a:before, #wrapper ' + stylePrefix + ' .fusion-widget-area .widget_nav_menu .current_page_item > a, #wrapper ' + stylePrefix + ' .fusion-widget-area .widget_nav_menu .current_page_item > a:before {color: ' + this.params.link_hover_color + ';}';
					styleBlock += '#wrapper ' + stylePrefix + ' .fusion-vertical-menu-widget .menu li.current_page_item > a { border-right-color:' + this.params.link_hover_color + ';border-left-color:' + this.params.link_hover_color + ';}';
					styleBlock += '#wrapper ' + stylePrefix + ' .fusion-widget-area .tagcloud a:hover { color: #fff; background-color: ' + this.params.link_hover_color + ';border-color: ' + this.params.link_hover_color + ';}';
					styleBlock += '#main ' + stylePrefix + ' .post .blog-shortcode-post-title a:hover {color: ' + this.params.link_hover_color + ';}';
				}

				if ( 'undefined' !== typeof this.values.z_index && '' !== this.values.z_index ) {
					styleBlock += '.fusion-fullwidth.fusion-builder-row-live-' + cid + ' {z-index: ' + parseInt( this.values.z_index ) + ' !important; }';
				}

				if ( 'undefined' !== typeof this.values.overflow && '' !== this.values.overflow ) {
					styleBlock += '.fusion-fullwidth.fusion-builder-row-live-' + cid + ' {overflow: ' + this.values.overflow + ' }';
				}

				if ( 'on' === this.values.sticky ) {
					if ( '' !== this.values.sticky_background_color ) {
						styleBlock += '.fusion-fullwidth.fusion-builder-row-live-' + cid + '.fusion-sticky-transition { background-color:' + this.values.sticky_background_color + ' !important; }';
					}
					if ( '' !== this.values.sticky_height ) {
						styleBlock += '.fusion-fullwidth.fusion-builder-row-live-' + cid + '.fusion-sticky-transition { min-height:' + this.values.sticky_height + ' !important; }';
					}
				}


				if ( '' !== styleBlock ) {
					styleBlock = '<style type="text/css">' + styleBlock + '</style>';
				}

				return styleBlock + _.fusionGetFilterStyleElem( this.values, '.fusion-builder-row-live-' + cid, cid  );
			},

			/**
			 * Get template attributes.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getTemplateAtts: function()  {
				var templateAttributes 		= {};

				this.setValues();
				this.setExtraValues();
				this.setContainerVideoData();
				if ( this.isFlex() ) {
					this.setResponsiveContainerStyles();
				}

				// Remove old parallax bg.
				if ( this.$el.find( '.fusion-bg-parallax' ).length ) {
					if ( 'undefined' !== typeof this.$el.find( '.fusion-bg-parallax' ).data( 'parallax-index' ) ) {
						jQuery( '#fb-preview' )[ 0 ].contentWindow._fusionImageParallaxImages.splice( this.$el.find( '.fusion-bg-parallax' ).data( 'parallax-index' ), 1 );
					}

					this.$el.find( '.fusion-bg-parallax' ).remove();
					this.$el.find( '.parallax-inner' ).remove();
				}

				templateAttributes.values		         = this.values;
				templateAttributes.attr			         = this.attr();
				templateAttributes.parallax 		     = this.parallaxAttr();
				templateAttributes.createVideoBackground = _.bind( this.createVideoBackground, this );
				templateAttributes.fadingBackground	     = this.fadingBackgroundAttr();
				templateAttributes.styleBlock		     = this.styleBlock();
				templateAttributes.admin_label 			 = ( '' !== this.values.admin_label ) ? _.unescape( this.values.admin_label ) : fusionBuilderText.full_width_section;
				templateAttributes.topOverlap            = ( 20 > parseInt( this.values.padding_top, 10 ) && ( '0%' === this.values.padding_top || -1 === this.values.padding_top.indexOf( '%' ) ) ) ? 'fusion-overlap' : '';
				templateAttributes.bottomOverlap         = ( 20 > parseInt( this.values.margin_bottom, 10 ) && ( '0%' === this.values.margin_bottom || -1 === this.values.margin_bottom.indexOf( '%' ) ) ) ? 'fusion-overlap' : '';
				templateAttributes.isFlex				 = this.isFlex();
				templateAttributes.isGlobal              = ( 'undefined' !== typeof this.values.fusion_global ) ? 'yes' : 'no';
				templateAttributes.cid                   = this.model.get( 'cid' );
				templateAttributes.status                = this.values.status;
				templateAttributes.container_tag         = this.values.container_tag;
				templateAttributes.responsiveStyles      = this.responsiveStyles || '';
				templateAttributes.scrollPosition 		 = ( 'right' === FusionApp.settings.header_position || jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).hasClass( 'rtl' ) ) ? 'scroll-navigation-left' : 'scroll-navigation-right';
				templateAttributes.contentStyle 		 = this.contentStyle();


				return templateAttributes;
			},

			triggerScrollUpdate: function() {
				setTimeout( function() {
					FusionPageBuilderApp.scrollingContainers();
				}, 100 );
			},

			beforePatch: function() {
				if ( this.$el.find( '.fusion-bg-parallax' ).length ) {
					if ( 'object' === typeof jQuery( '#fb-preview' )[ 0 ].contentWindow._fusionImageParallaxImages && 'undefined' !== typeof this.$el.find( '.fusion-bg-parallax' ).attr( 'data-parallax-index' ) ) {
						jQuery( '#fb-preview' )[ 0 ].contentWindow._fusionImageParallaxImages.splice( this.$el.find( '.fusion-bg-parallax' ).attr( 'data-parallax-index' ), 1 );
					}
				}
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			afterPatch: function() {
				var self = this;

				this.appendChildren();

				// Using non debounced version for smoothness.
				this.refreshJs();

				this._triggerScrollUpdate();

				setTimeout( function() {
					self.droppableContainer();
				}, 100 );

				if ( 'yes' === this.model.attributes.params.hundred_percent_height && 'yes' === this.model.attributes.params.hundred_percent_height_scroll ) {
					this.$el.addClass( 'scrolling-helper' );
				} else {
					this.$el.removeClass( 'scrolling-helper' );
				}

				this.setSettingsControlsOffset( true );

				this._reInitSticky();

				if ( this.reInitDraggables ) {
					this.updateDragHandles();
				}
			},

			/**
			 * Triggers a refresh.
			 *
			 * @since 2.0.0
			 * @return void
			 */
			refreshJs: function( cid ) {
				cid = 'undefined' === typeof cid ? this.model.attributes.cid : cid;
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-element-render-fusion_builder_container', cid );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-reinit-carousels', cid );
			},

			/**
			 * Adds a container.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addContainer: function( event ) {
				var elementID,
					defaultParams,
					params,
					value,
					newContainer;

				if ( event ) {
					event.preventDefault();
					FusionPageBuilderApp.newContainerAdded = true;
				}

				elementID     = FusionPageBuilderViewManager.generateCid();
				defaultParams = fusionAllElements.fusion_builder_container.params;
				params        = {};

				// Process default options for shortcode.
				_.each( defaultParams, function( param )  {
					value = ( _.isObject( param.value ) ) ? param[ 'default' ] : param.value;
					params[ param.param_name ] = value;

					if ( 'dimension' === param.type && _.isObject( param.value ) ) {
						_.each( param.value, function( val, name )  {
							params[ name ] = val;
						} );
					}
				} );

				this.collection.add( [
					{
						type: 'fusion_builder_container',
						added: 'manually',
						element_type: 'fusion_builder_container',
						cid: elementID,
						params: params,
						view: this,
						created: 'auto'
					}
				] );

				// Make sure to add row to new container not current one.
				newContainer = FusionPageBuilderViewManager.getView( elementID );
				newContainer.addRow();

				FusionPageBuilderApp.scrollingContainers();
			},

			/**
			 * Adds a row.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			addRow: function() {

				this.collection.add( [
					{
						type: 'fusion_builder_row',
						element_type: 'fusion_builder_row',
						added: 'manually',
						cid: FusionPageBuilderViewManager.generateCid(),
						parent: this.model.get( 'cid' ),
						view: this,
						element_content: ''
					}
				] );
			},

			/**
			 * Removes the container.
			 *
			 * @since 2.0.0
			 * @param {Object}         event - The event.
			 * @param {boolean|undefined} skip - Should we skip this?
			 * @return {void}
			 */
			removeContainer: function( event, skip ) {

				var rows;

				if ( event ) {
					event.preventDefault();
				}

				rows = FusionPageBuilderViewManager.getChildViews( this.model.get( 'cid' ) );

				_.each( rows, function( row ) {
					if ( 'fusion_builder_row' === row.model.get( 'type' ) ) {
						row.removeRow();
					}
				} );

				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				this.model.destroy();

				FusionEvents.trigger( 'fusion-element-removed', this.model.get( 'cid' ) );

				this.remove();

				// If its the last container add empty page view.
				if ( 1 > FusionPageBuilderViewManager.countElementsByType( 'fusion_builder_container' ) && 'undefined' === typeof skip ) {
					FusionPageBuilderApp.blankPage = true;
					FusionPageBuilderApp.clearBuilderLayout( true );
				}

				if ( event ) {

					FusionPageBuilderApp.scrollingContainers();

					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.deleted_section );
					FusionEvents.trigger( 'fusion-content-changed' );
				}
			},

			/**
			 * Clones a container.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The evemt.
			 * @return {void}
			 */
			cloneContainer: function( event ) {

				var containerAttributes,
					$thisContainer;

				if ( event ) {
					event.preventDefault();
				}

				containerAttributes = jQuery.extend( true, {}, this.model.attributes );

				containerAttributes.cid = FusionPageBuilderViewManager.generateCid();
				containerAttributes.created = 'manually';
				containerAttributes.view = this;
				FusionPageBuilderApp.collection.add( containerAttributes );

				$thisContainer = this.$el;

				// Parse rows
				$thisContainer.find( '.fusion-builder-row-container:not(.fusion_builder_row_inner .fusion-builder-row-container)' ).each( function() {

					var thisRow = jQuery( this ),
						rowCID  = thisRow.data( 'cid' ),
						rowView,

						// Get model from collection by cid.
						row = FusionPageBuilderElements.find( function( model ) {
							return model.get( 'cid' ) == rowCID; // jshint ignore: line
						} ),

						// Clone row.
						rowAttributes = jQuery.extend( true, {}, row.attributes );

					rowAttributes.created = 'manually';
					rowAttributes.cid     = FusionPageBuilderViewManager.generateCid();
					rowAttributes.parent  = containerAttributes.cid;
					FusionPageBuilderApp.collection.add( rowAttributes );

					// Make sure spacing is calculated.
					rowView = FusionPageBuilderViewManager.getView( rowAttributes.cid );

					// Parse columns
					thisRow.find( '.fusion-builder-column-outer' ).each( function() {

						// Parse column elements
						var thisColumn = jQuery( this ),
							$columnCID = thisColumn.data( 'cid' ),

							// Get model from collection by cid
							column = FusionPageBuilderElements.find( function( model ) {
								return model.get( 'cid' ) == $columnCID; // jshint ignore: line
							} ),

							// Clone column
							columnAttributes = jQuery.extend( true, {}, column.attributes );

						columnAttributes.created = 'manually';
						columnAttributes.cid     = FusionPageBuilderViewManager.generateCid();
						columnAttributes.parent  = rowAttributes.cid;
						columnAttributes.from    = 'fusion_builder_container';
						columnAttributes.cloned  = true;

						// Don't need target element, position is defined from order.
						delete columnAttributes.targetElementPosition;

						FusionPageBuilderApp.collection.add( columnAttributes );

						// Find column elements
						thisColumn.find( '.fusion-builder-column-content:not( .fusion-nested-column-content )' ).children( '.fusion-builder-live-element, .fusion_builder_row_inner' ).each( function() {

							var thisElement,
								elementCID,
								element,
								elementAttributes,
								thisInnerRow,
								InnerRowCID,
								innerRowView;

							// Regular element
							if ( jQuery( this ).hasClass( 'fusion-builder-live-element' ) ) {

								thisElement = jQuery( this );
								elementCID = thisElement.data( 'cid' );

								// Get model from collection by cid
								element = FusionPageBuilderElements.find( function( model ) {
									return model.get( 'cid' ) == elementCID; // jshint ignore: line
								} );

								// Clone model attritubes
								elementAttributes         = jQuery.extend( true, {}, element.attributes );
								elementAttributes.created = 'manually';
								elementAttributes.cid     = FusionPageBuilderViewManager.generateCid();
								elementAttributes.parent  = columnAttributes.cid;
								elementAttributes.from    = 'fusion_builder_container';

								// Don't need target element, position is defined from order.
								delete elementAttributes.targetElementPosition;

								FusionPageBuilderApp.collection.add( elementAttributes );

							// Inner row element
							} else if ( jQuery( this ).hasClass( 'fusion_builder_row_inner' ) ) {

								thisInnerRow = jQuery( this );
								InnerRowCID = thisInnerRow.data( 'cid' );

								innerRowView = FusionPageBuilderViewManager.getView( InnerRowCID );

								// Clone inner row
								if ( 'undefined' !== typeof innerRowView ) {
									innerRowView.cloneNestedRow( '', columnAttributes.cid );
								}
							}
						} );
					} );

					// Update spacing for columns.
					rowView.setRowData();
				} );

				FusionPageBuilderApp.scrollingContainers();

				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.cloned_section );
				FusionEvents.trigger( 'fusion-content-changed' );
				this._refreshJs( containerAttributes.cid );
			},

			/**
			 * Adds a child view.
			 *
			 * @param {Object} element - The element model.
			 * @return {void}
			 */
			addChildView: function( element ) {

				var view,
					viewSettings = {
						model: element,
						collection: FusionPageBuilderElements
					};

				view = new FusionPageBuilder.RowView( viewSettings );

				FusionPageBuilderViewManager.addView( element.get( 'cid' ), view );

				if ( this.$el.find( '.fusion-builder-container-content' ).length ) {
					this.$el.find( '.fusion-builder-container-content' ).append( view.render().el );
				} else {
					this.$el.find( '> .fusion-builder-add-element' ).hide().end().append( view.render().el );
				}

				// Add parent view to inner rows that have been converted from shortcodes
				if ( 'manually' === element.get( 'created' ) && 'row_inner' === element.get( 'element_type' ) ) {
					element.set( 'view', FusionPageBuilderViewManager.getView( element.get( 'parent' ) ), { silent: true } );
				}
			},

			/**
			 * Appends model children.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			appendChildren: function() {
				var self = this,
					cid,
					view;

				this.model.children.each( function( child ) {

					cid  = child.attributes.cid;
					view = FusionPageBuilderViewManager.getView( cid );

					self.$el.find( '.fusion-builder-container-content' ).append( view.$el );

					view.delegateEvents();
					view.delegateChildEvents();
					view.droppableColumn();
				} );
			},

			/**
			 * Triggers event to reinit sticky container properties.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			reInitSticky: function() {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-reinit-sticky', this.model.attributes.cid );
			},

			/**
			 * Set empty spacing for legacy and re-render.
			 *
			 * @since 3.0.0
			 * @return {void}
			 */
			setEmptySpacing: function() {
				var params = this.model.get( 'params' );
				params.flex_column_spacing = '0px';
				this.model.set( 'params', params );
			},

			/**
			 * Things to do, places to go when options change.
			 *
			 * @since 2.0.0
			 * @param {string} paramName - The name of the parameter that changed.
			 * @param {mixed}  paramValue - The value of the option that changed.
			 * @param {Object} event - The event triggering the option change.
			 * @return {void}
			 */
			onOptionChange: function( paramName, paramValue, event ) {
				var reInitDraggables	= false,
					dimensionType		= _.find( [ 'spacing_', 'margin_', 'padding_' ], function( type ) {
						return paramName.includes( type );
					} );

				// Reverted to history step or user entered value manually.
				if ( 'undefined' === typeof event || ( 'undefined' !== typeof event && ( 'change' !== event.type || ( 'change' === event.type && 'undefined' !== typeof event.srcElement ) ) ) ) {
					reInitDraggables = true;
				}

				if ( dimensionType ) {
					this.model.attributes.params[ paramName ] = paramValue;

					if ( true === reInitDraggables ) {
						if ( 'padding_' === dimensionType ) {
							this.destroyPaddingResizable();
							this.paddingDrag();
						} else {
							this.destroyMarginResizable();
							this.marginDrag();
						}

					}
				}

				switch ( paramName ) {
					case 'admin_label':
						this.model.attributes.params[ paramName ] = paramValue.replace( /[[\]]+/g, '' );
						break;

					// Changing between legacy and flex.
					case 'type':
						this.model.attributes.params[ paramName ] = paramValue;
						this.values.type                          = paramValue;
						this.reRenderRows();
						this.updateResponsiveSetup();
						break;

					// Sticky options.
					case 'sticky':
					case 'sticky_devices':
					case 'sticky_height':
					case 'sticky_offset':
					case 'sticky_transition_offset':
					case 'scroll_offset':
						this._reInitSticky();
						break;

					// Changing options which alter row if in flex mode.
					case 'flex_column_spacing':
						this._updateInnerStyles();
						break;

					case 'absolute':
						if ( 'on' === paramValue && ! this.$el.hasClass( 'fusion-builder-absolute-container-wrapper' ) ) {
							this.$el.addClass( 'fusion-builder-absolute-container-wrapper' );
						} else if ( 'off' === paramValue && this.$el.hasClass( 'fusion-builder-absolute-container-wrapper' ) ) {
							this.$el.removeClass( 'fusion-builder-absolute-container-wrapper' );
						}
						break;
				}
			},

			/**
			 * Re-renders the rows.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			reRenderRows: function() {
				var rows = FusionPageBuilderViewManager.getChildViews( this.model.get( 'cid' ) );

				// TODO: check this for performance.  Ideally we just update params, not re-render row.
				_.each( rows, function( row ) {
					row.modeChange();
				} );
			},

			/**
			 * Updates the styles inside container.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			updateInnerStyles: function() {
				var rows = FusionPageBuilderViewManager.getChildViews( this.model.get( 'cid' ) );
				_.each( rows, function( row ) {
					row.updateInnerStyles();
				} );
			},

			/**
			 * Updates responsive setup.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			updateResponsiveSetup: function() {
				var $settings = jQuery( '.fusion_builder_module_settings' );

				this.isFlex() ? $settings.addClass( 'has-flex' ) : $settings.removeClass( 'has-flex' );
			},

			/**
			 * Gets the contents of the container.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getContent: function() {
				var shortcode = '';

				shortcode += FusionPageBuilderApp.generateElementShortcode( this.$el, true );

				this.$el.find( '.fusion_builder_row' ).each( function() {
					var $thisRow = jQuery( this );

					shortcode += '[fusion_builder_row]';

					$thisRow.find( '.fusion-builder-column-outer' ).each( function() {
						var $thisColumn = jQuery( this ),
							columnCID   = $thisColumn.data( 'cid' ),
							columnView  = FusionPageBuilderViewManager.getView( columnCID );

						shortcode += columnView.getColumnContent();

					} );

					shortcode += '[/fusion_builder_row]';

				} );

				shortcode += '[/fusion_builder_container]';

				return shortcode;
			},

			/**
			 * Get the save label.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getSaveLabel: function() {
				return fusionBuilderText.save_section;
			},

			/**
			 * Returns the 'sections' string.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getCategory: function() {
				return 'sections';
			},

			/**
			 * Handle margin adjustments on drag.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			marginDrag: function() {
				var $el            = this.$el,
					self           = this,
					directions     = { top: 's', bottom: 's' },
					parentWidth    = $el.closest( '.fusion-row, .fusion-builder-live-editor' ).width();

				if ( this.$el.hasClass( 'active' ) ) {
					return;
				}

				_.each( directions, function( handle, direction )  {
					var optionKey 		= FusionApp.getResponsiveOptionKey( 'margin_' + direction, self.isFlex() ),
						actualDimension = self.values[ optionKey ] || self.values[ 'margin_' + direction ],
						percentSpacing 	= false;

					percentSpacing  = actualDimension && actualDimension.includes( '%' );

					if ( percentSpacing ) {
						// Get actual dimension and set.
						actualDimension = ( parentWidth / 100 ) * parseFloat( actualDimension );
						$el.find( '.fusion-container-margin-' + direction ).css( 'height', actualDimension );
						if ( 'bottom' === direction && 20 > actualDimension ) {
							$el.find( '.fusion-container-margin-bottom, .fusion-container-padding-bottom' ).addClass( 'fusion-overlap' );
						}
					}

					$el.find( '.fusion-container-margin-' + direction ).css( 'display', 'block' );
					$el.find( '.fusion-container-margin-' + direction ).height( actualDimension );

					$el.find( '.fusion-container-margin-' + direction ).resizable( {
						handles: handle,
						minHeight: 0,
						minWidth: 0,
						grid: ( percentSpacing ) ? [ parentWidth / 100, 10 ] : '',
						create: function() {
							if ( 'bottom' === direction ) {
								if ( 20 > parseInt( actualDimension, 10 ) && ! percentSpacing ) {
									$el.find( '.fusion-container-margin-bottom, .fusion-container-padding-bottom' ).addClass( 'fusion-overlap' );
								} else {
									$el.find( '.fusion-container-margin-bottom, .fusion-container-padding-bottom' ).removeClass( 'fusion-overlap' );
								}
							}
						},
						resize: function( event, ui ) {
							var optionKey 		= FusionApp.getResponsiveOptionKey( 'margin_' + direction, self.isFlex() ),
								actualDimension = self.values[ optionKey ] || 0,
								percentSpacing 	= false,
								value 			= 'top' === direction || 'bottom' === direction ? ui.size.height : ui.size.width;

							jQuery( ui.element ).addClass( 'active' );

							// Recheck in case unit is changed in the modal.
							percentSpacing  = actualDimension && actualDimension.includes( '%' );

							jQuery( ui.element ).closest( '.fusion-builder-container' ).addClass( 'active' );

							value = 0 > value ? 0 : value;
							value = value + 'px';
							if ( percentSpacing ) {
								value = 0 === parseFloat( value ) ? '0%' : Math.round( parseFloat( parseFloat( value ) / ( parentWidth / 100 ) ) ) + '%';
							}

							// Bottom margin overlap
							if ( 'bottom' === direction ) {
								if ( 20 > ui.size.height ) {
									jQuery( ui.element ).addClass( 'fusion-overlap' );
									$el.find( '.fusion-container-padding-bottom' ).addClass( 'fusion-overlap' );
								} else {
									jQuery( ui.element ).removeClass( 'fusion-overlap' );
									$el.find( '.fusion-container-padding-bottom' ).removeClass( 'fusion-overlap' );
								}
							}

							// Legacy update.
							if ( ! self.isFlex() ) {
								$el.find( '.fusion-fullwidth' ).css( 'margin-' + direction, value );
							}

							jQuery( ui.element ).find( '.fusion-spacing-tooltip, .fusion-column-spacing' ).addClass( 'active' );
							jQuery( ui.element ).find( '.fusion-spacing-tooltip' ).text( value );

							// Update open modal.
							self.updateDragSettings( '#' + optionKey, value );
						},
						stop: function( event, ui ) {
							jQuery( ui.element ).removeClass( 'active' );
							jQuery( ui.element ).closest( '.fusion-builder-container' ).removeClass( 'active' );

							// Delete all spacing resizable within because parent width has changed.
							if ( jQuery( ui.element ).closest( '.fusion-builder-container' ).find( '.fusion-column-spacing .ui-resizable' ).length ) {
								jQuery( ui.element ).closest( '.fusion-builder-container' ).find( '.fusion-column-spacing .ui-resizable' ).resizable( 'destroy' );
							}
						}
					} );
				} );
			},

			/**
			 * Checks if the container needs to run through legacy conversion.
			 *
			 * @since 3.0.0
			 * @return {boolean}
			 */
			needsLegacyConversion: function() {
				var params = this.model.get( 'params' );
				return 'undefined' === typeof params.type;
			},

			/**
			 * Handle padding adjustments on drag.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			paddingDrag: function() {
				var $el         = this.$el,
					self        = this,
					directions  = { top: 's', right: 'w', bottom: 's', left: 'e' },
					parentWidth = $el.closest( '.fusion-row, .fusion-builder-live-editor' ).width(),
					defaults,
					extras;

				if ( this.$el.hasClass( 'active' ) ) {
					return;
				}

				defaults = fusionAllElements.fusion_builder_container.defaults;
				extras   = jQuery.extend( true, {}, fusionAllElements.fusion_builder_container.extras );

				// If 100 page template.
				if ( FusionPageBuilderApp.$el.find( '#main' ).hasClass( 'width-100' ) && 'undefined' !== typeof extras.container_padding_100 ) {
					defaults.padding_right = extras.container_padding_100.right;
					defaults.padding_left  = extras.container_padding_100.left;
				}

				_.each( directions, function( handle, direction )  {
					var optionKey 		= FusionApp.getResponsiveOptionKey( 'padding_' + direction, self.isFlex() ),
					actualDimension = self.values[ optionKey ] || self.values[ 'padding_' + direction ],
					percentSpacing 	= false;

					if ( ! actualDimension ) {
						actualDimension = defaults[ optionKey ] || 0;
					}

					// Check if using a percentage.
					percentSpacing  = actualDimension && actualDimension.includes( '%' );

					if ( percentSpacing ) {

						// Get actual dimension and set.
						actualDimension = ( parentWidth / 100 ) * parseFloat( actualDimension );
						if ( 'top' === direction || 'bottom' === direction ) {
							$el.find( '.fusion-container-padding-' + direction ).css( 'height', actualDimension );
						} else {
							$el.find( '.fusion-container-padding-' + direction ).css( 'width', actualDimension );
						}
						if ( 'top' === direction && 20 > actualDimension ) {
							$el.find( '.fusion-container-margin-top, .fusion-container-padding-top' ).addClass( 'fusion-overlap' );
						}
					}

					$el.find( '.fusion-container-padding-' + direction ).css( 'display', 'block' );
					if ( 'top' === direction || 'bottom' === direction ) {
						$el.find( '.fusion-container-padding-' + direction ).height( actualDimension );
					} else {
						$el.find( '.fusion-container-padding-' + direction ).width( actualDimension );
					}

					$el.find( '.fusion-container-padding-' + direction ).resizable( {
						handles: handle,
						minHeight: 0,
						minWidth: 0,

						create: function() {
							if ( 'top' === direction ) {
								if ( 20 > parseInt( actualDimension, 10 ) && ! percentSpacing ) {
									$el.find( '.fusion-container-margin-top, .fusion-container-padding-top' ).addClass( 'fusion-overlap' );
								} else {
									$el.find( '.fusion-container-margin-top, .fusion-container-padding-top' ).removeClass( 'fusion-overlap' );
								}
							}
						},

						resize: function( event, ui ) {
							var optionKey 		= FusionApp.getResponsiveOptionKey( 'padding_' + direction, self.isFlex() ),
								actualDimension = self.values[ optionKey ],
								percentSpacing 	= false,
								value 			= 'top' === direction || 'bottom' === direction ? ui.size.height : ui.size.width;

							percentSpacing  = actualDimension && actualDimension.includes( '%' );

							jQuery( ui.element ).addClass( 'active' );
							jQuery( ui.element ).closest( '.fusion-builder-container' ).addClass( 'active' );

							value = 0 > value ? 0 : value;
							value = value + 'px';
							if ( percentSpacing ) {
								value = 0 === parseFloat( value ) ? '0%' : Math.round( parseFloat( parseFloat( value ) / ( parentWidth / 100 ) ) ) + '%';
							}

							// Top padding overlap
							if ( 'top' === direction ) {
								if ( 20 > ui.size.height ) {
									jQuery( ui.element ).addClass( 'fusion-overlap' );
									$el.find( '.fusion-container-margin-top' ).addClass( 'fusion-overlap' );
								} else {
									jQuery( ui.element ).removeClass( 'fusion-overlap' );
									$el.find( '.fusion-container-margin-top' ).removeClass( 'fusion-overlap' );
								}
							}

							// Set values and width.
							$el.find( '.fusion-fullwidth' ).css( 'padding-' + direction, value );

							jQuery( ui.element ).find( '.fusion-spacing-tooltip, .fusion-column-spacing' ).addClass( 'active' );
							jQuery( ui.element ).find( '.fusion-spacing-tooltip' ).text( value );

							// Update open modal.
							self.updateDragSettings( '#' + optionKey, value );
						},
						stop: function( event, ui ) {
							jQuery( ui.element ).removeClass( 'active' );
							jQuery( ui.element ).closest( '.fusion-builder-container' ).removeClass( 'active' );

							// Delete all spacing resizable within because parent width has changed.
							if ( jQuery( ui.element ).closest( '.fusion-builder-container' ).find( '.fusion-column-spacing .ui-resizable' ).length ) {
								jQuery( ui.element ).closest( '.fusion-builder-container' ).find( '.fusion-column-spacing .ui-resizable' ).resizable( 'destroy' );
							}
						}
					} );
				} );
			},

			/**
			 * Destroy container resizable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			destroyResizable: function() {
				this.destroyMarginResizable();
				this.destroyPaddingResizable();
			},

			/**
			 * Destroy container margin resizable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			destroyMarginResizable: function() {
				var $containerSpacer = this.$el.find( '.fusion-container-margin-top, .fusion-container-margin-bottom' );

				jQuery.each( $containerSpacer, function( index, spacer ) {
					if ( jQuery( spacer ).hasClass( 'ui-resizable' ) ) {
						jQuery( spacer ).resizable( 'destroy' );
						jQuery( spacer ).hide();
					}
				} );
			},

			/**
			 * Destroy container padding resizable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			destroyPaddingResizable: function() {
				var $containerSpacer = this.$el.find( '.fusion-container-padding-top, .fusion-container-padding-right, .fusion-container-padding-bottom, .fusion-container-padding-left' );

				jQuery.each( $containerSpacer, function( index, spacer ) {
					if ( jQuery( spacer ).hasClass( 'ui-resizable' ) ) {
						jQuery( spacer ).resizable( 'destroy' );
						jQuery( spacer ).hide();
					}
				} );
			},

			/**
			 * Filter out DOM before patching.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			patcherFilter: function( diff ) {
				var filteredDiff = [],
					self         = this;

				self.reInitDraggables = false;

				_.each( diff, function( info ) {
					if ( 'removeElement' === info.action ) {
						if ( 'undefined' !== typeof info.element.attributes && 'undefined' !== typeof info.element.attributes[ 'class' ] && -1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-fullwidth' ) ) {
							self.reInitDraggables = true;
							filteredDiff.push( info );
						} else if ( 'undefined' !== typeof info.element.attributes && 'undefined' !== typeof info.element.attributes[ 'class' ] && -1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-container-spacing' ) ) {

							// Ignore.
						} else {
							filteredDiff.push( info );
						}
					} else if ( 'addElement' === info.action ) {
						if ( 'undefined' !== typeof info.element.attributes && 'undefined' !== typeof info.element.attributes[ 'class' ] && -1 !== info.element.attributes[ 'class' ].indexOf( 'fusion-container-spacing' ) ) {

							// Ignore.
						} else {
							filteredDiff.push( info );
						}
					} else {
						filteredDiff.push( info );
					}
				} );

				return filteredDiff;
			},

			/**
			 * Handle container name edit in wireframe mode.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			renameContainer: function( event ) {

				// Detect "enter" key
				var code,
					model,
					input,
					fusionHistoryState;

				code = event.keyCode || event.which;

				if ( 13 == code ) { // jshint ignore:line
					event.preventDefault();
					this.$el.find( '.fusion-builder-section-name' ).blur();

					return false;
				}

				fusionHistoryState = fusionBuilderText.edited + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element;

				model = this.model;
				input = this.$el.find( '.fusion-builder-section-name' );
				clearTimeout( this.typingTimer );

				this.typingTimer = setTimeout( function() {

					model.attributes.params.admin_label = input.val().replace( /[[\]]+/g, '' );
					FusionEvents.trigger( 'fusion-content-changed' );
					FusionEvents.trigger( 'fusion-history-save-step', fusionHistoryState );

				}, this.doneTypingInterval );
			},

			/**
			 * Handle container toggle in wireframe mode.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			toggleContainer: function( event ) {

				var thisEl = jQuery( event.currentTarget ),
					fusionHistoryState;

				if ( event ) {
					event.preventDefault();
				}

				this.$el.toggleClass( 'fusion-builder-section-folded' );
				thisEl.find( 'span' ).toggleClass( 'fusiona-caret-up' ).toggleClass( 'fusiona-caret-down' );

				if ( this.$el.hasClass( 'fusion-builder-section-folded' ) ) {
					this.model.attributes.params.admin_toggled = 'yes';
				} else {
					this.model.attributes.params.admin_toggled = 'no';
				}

				fusionHistoryState = fusionBuilderText.edited + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element;

				FusionEvents.trigger( 'fusion-content-changed' );
				FusionEvents.trigger( 'fusion-history-save-step', fusionHistoryState );
			},

			scrollHighlight: function() {
				var $trigger = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-one-page-text-link' ),
					$el      = this.$el;

				setTimeout( function() {
					if ( $trigger.length && 'function' === typeof $trigger.fusion_scroll_to_anchor_target ) {
						$trigger.attr( 'href', '#fusion-container-' + this.model.get( 'cid' ) ).fusion_scroll_to_anchor_target( 15 );
					}

					$el.find( '> .fusion-column-wrapper' ).addClass( 'fusion-active-highlight' );
					setTimeout( function() {
						$el.find( '> .fusion-column-wrapper' ).removeClass( 'fusion-active-highlight' );
					}, 6000 );
				}, 10 );
			},

			publish: function( event ) {
				var cid    = jQuery( event.currentTarget ).data( 'cid' ),
					view   = FusionPageBuilderViewManager.getView( cid ),
					params = view.model.get( 'params' );

				FusionApp.confirmationPopup( {
					title: fusionBuilderText.container_publish,
					content: fusionBuilderText.are_you_sure_you_want_to_publish,
					actions: [
						{
							label: fusionBuilderText.no,
							classes: 'no',
							callback: function() {
								FusionApp.confirmationPopup( {
									action: 'hide'
								} );
							}
						},
						{
							label: fusionBuilderText.yes,
							classes: 'yes',
							callback: function() {
								params.status = 'published';
								view.model.set( 'params', params );
								view.$el.find( 'a[data-cid="' + cid + '"].fusion-builder-publish-tooltip' ).remove();

								FusionEvents.trigger( 'fusion-history-turn-on-tracking' );
								FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.container_published );

								FusionEvents.trigger( 'fusion-content-changed' );
								FusionApp.confirmationPopup( {
									action: 'hide'
								} );
							}
						}
					]
				} );
			},

			unglobalize: function( event ) {
				var cid    = jQuery( event.currentTarget ).data( 'cid' ),
					view   = FusionPageBuilderViewManager.getView( cid ),
					params = view.model.get( 'params' );

				event.preventDefault();

				FusionApp.confirmationPopup( {

					title: fusionBuilderText.remove_global,
					content: fusionBuilderText.are_you_sure_you_want_to_remove_global,
					actions: [
						{
							label: fusionBuilderText.no,
							classes: 'no',
							callback: function() {
								FusionApp.confirmationPopup( {
									action: 'hide'
								} );
							}
						},
						{
							label: fusionBuilderText.yes,
							classes: 'yes',
							callback: function() {

								// Remove global attributes.
								delete params.fusion_global;
								view.model.set( 'params', params );
								view.$el.removeClass( 'fusion-global-container fusion-global-column fusion-global-nested-row fusion-global-element fusion-global-parent-element' );
								view.$el.find( 'a[data-cid="' + cid + '"].fusion-builder-unglobal-tooltip' ).remove();
								view.$el.removeAttr( 'fusion-global-layout' );

								FusionEvents.trigger( 'fusion-history-turn-on-tracking' );
								FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.removed_global );

								FusionEvents.trigger( 'fusion-content-changed' );
								FusionApp.confirmationPopup( {
									action: 'hide'
								} );
							}
						}
					]
				} );
			},

			/**
			 * Fires when preview are is resized.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			onPreviewResize: function() {
				if ( ! this.isFlex() ) {
					return;
				}

				if ( this.$el.hasClass( 'fusion-builder-element-edited' ) ) {
					this.updateDragHandles();
				}

			},

			setResponsiveContainerStyles: function() {
				var self   = this,
					extras = jQuery.extend( true, {}, fusionAllElements.fusion_builder_column.extras );

				this.responsiveStyles = '';

				_.each( [ 'large', 'medium', 'small' ], function( size ) {
					var containerStyles = '',
						paddingKey,
						spacingKey;

					_.each( [ 'top', 'right', 'bottom', 'left' ], function( direction ) {

						// Padding.
						paddingKey = 'padding_' + direction + ( 'large' === size ? '' : '_' + size );
						if ( '' !== self.values[ paddingKey ] ) {
							containerStyles += 'padding-' + direction + ' : ' + _.fusionGetValueWithUnit( self.values[ paddingKey ] ) + ' !important;';
						}

						if (  'left' === direction || 'right' === direction ) {
							return;
						}

						// Margin.
						spacingKey = 'margin_' + direction + ( 'large' === size ? '' : '_' + size );
						if ( '' !== self.values[ spacingKey ] ) {
							containerStyles += 'margin-' + direction + ' : ' + _.fusionGetValueWithUnit( self.values[ spacingKey ] ) + ';';
						}

					} );

					if ( '' === containerStyles ) {
						return;
					}

					// Wrap CSS selectors
					if ( '' !== containerStyles ) {
						containerStyles = '.fusion-body:not(.fusion-builder-ui-wireframe) #fusion-container-' + self.model.get( 'cid' ) + ' > .fusion-fullwidth {' + containerStyles + '}';
					}

					// Large styles, no wrapping needed.
					if ( 'large' === size ) {
						self.responsiveStyles += containerStyles;
					} else {
						// Medium and Small size screen styles.
						self.responsiveStyles += '@media only screen and (max-width:' + extras[ 'visibility_' + size ] + 'px) {' + containerStyles + '}';
					}
				} );
			},

			/**
			 * Updates column sizes controls.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			updateDragHandles: function() {
				this.destroyResizable();
				this.marginDrag();
				this.paddingDrag();
			}
		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderApp, FusionPageBuilderViewManager, fusionBuilderText, fusionAllElements, FusionEvents */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Container View
		FusionPageBuilder.ContextMenuView = window.wp.Backbone.View.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-context-menu' ).html() ),
			className: 'fusion-builder-context-menu',
			events: {
				'click [data-action="edit"]': 'editTrigger',
				'click [data-action="save"]': 'saveTrigger',
				'click [data-action="clone"]': 'cloneTrigger',
				'click [data-action="remove"]': 'removeTrigger',
				'click [data-action="copy"]': 'copy',
				'click [data-action="paste-before"]': 'pasteBefore',
				'click [data-action="paste-after"]': 'pasteAfter',
				'click [data-action="paste-start"]': 'pasteStart',
				'click [data-action="paste-end"]': 'pasteEnd'
			},

			/**
			 * Initialize the builder sidebar.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
				this.copyData = {
					data: {
						type: false,
						content: false
					}
				};
				this.getCopy();

				this.elWidth  = 130;
				this.elHeight = 257;
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var leftOffset = this.model.event.pageX,
					topOffset = this.model.event.pageY;

				this.$el.html( this.template( jQuery.extend( true, this.copyData, this.model.parent.attributes ) ) );

				if ( this.model.event.pageX + this.elWidth > jQuery( '#fb-preview' ).width() ) {
					leftOffset = jQuery( '#fb-preview' ).width() - this.elWidth;
				}
				if ( this.model.event.pageY + this.elHeight > jQuery( jQuery( '#fb-preview' )[ 0 ].contentWindow.document ).height() ) {
					topOffset = jQuery( jQuery( '#fb-preview' )[ 0 ].contentWindow.document ).height() - this.elHeight;
				}

				this.$el.css( { top: ( topOffset ) + 'px', left: ( leftOffset ) + 'px' } );

				return this;
			},

			/**
			 * Trigger edit on relavent element.
			 *
			 * @since 2.0.0
			 */
			editTrigger: function( event ) {
				if ( 'fusion_builder_row_inner' === this.model.parent.attributes.element_type ) {
					if ( FusionPageBuilderApp.wireframeActive ) {
						this.model.parentView.editNestedColumn( event );
					} else {
						this.model.parentView.editRow( event );
					}
				} else {
					this.model.parentView.settings( event );
				}
			},

			/**
			 * Trigger save on relavent element.
			 *
			 * @since 2.0.0
			 */
			saveTrigger: function( event ) {
				this.model.parentView.openLibrary( event );
			},

			/**
			 * Trigger clone on relavent element.
			 *
			 * @since 2.0.0
			 */
			cloneTrigger: function( event ) {

				switch ( this.model.parent.attributes.element_type ) {
				case 'fusion_builder_container':
					this.model.parentView.cloneContainer( event );
					break;
				case 'fusion_builder_column_inner':
				case 'fusion_builder_column':
					this.model.parentView.cloneColumn( event );
					break;
				case 'fusion_builder_row_inner':
					this.model.parentView.cloneNestedRow( event );
					break;
				default:
					this.model.parentView.cloneElement( event );
					break;
				}
			},

			/**
			 * Trigger remove on relavent element.
			 *
			 * @since 2.0.0
			 */
			removeTrigger: function( event ) {

				switch ( this.model.parent.attributes.element_type ) {
				case 'fusion_builder_container':
					this.model.parentView.removeContainer( event );
					break;
				case 'fusion_builder_column_inner':
				case 'fusion_builder_column':
					this.model.parentView.removeColumn( event );
					break;
				case 'fusion_builder_row_inner':
					this.model.parentView.removeRow( event );
					break;
				default:
					this.model.parentView.removeElement( event );
					break;
				}
			},

			/**
			 * Copy the element.
			 *
			 * @since 2.0.0
			 */
			copy: function() {
				var type    = this.model.parent.attributes.element_type,
					content = this.model.parentView.getContent(),
					$temp   = jQuery( '<textarea>' ),
					data;

				// Copy to actual clipboard, handy for pasting.
				jQuery( 'body' ).append( $temp );
				$temp.val( content ).select();
				document.execCommand( 'copy' );
				$temp.remove();

				data = {
					type: type,
					content: content
				};

				this.storeCopy( data );
			},

			/**
			 * Stored copy data.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			storeCopy: function( data ) {
				if ( 'undefined' !== typeof Storage ) {
					localStorage.setItem( 'fusionCopyContent', data.content );
					localStorage.setItem( 'fusionCopyType', data.type );
					this.getCopy();
				}
			},

			/**
			 * Get stored data.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getCopy: function() {
				if ( 'undefined' !== typeof Storage ) {
					if ( localStorage.getItem( 'fusionCopyContent' ) ) {
						this.copyData.data.content = localStorage.getItem( 'fusionCopyContent' );
						this.copyData.data.type = localStorage.getItem( 'fusionCopyType' );
					}
				}
			},

			/**
			 * Paste after element.
			 *
			 * @since 2.0.0
			 */
			pasteAfter: function() {
				this.paste( 'after' );
			},

			/**
			 * Paste before element.
			 *
			 * @since 2.0.0
			 */
			pasteBefore: function() {
				this.paste( 'before' );
			},

			/**
			 * Paste child to start.
			 *
			 * @since 2.0.0
			 */
			pasteStart: function() {
				this.paste( 'start' );
			},

			/**
			 * Paste child to end.
			 *
			 * @since 2.0.0
			 */
			pasteEnd: function() {
				this.paste( 'end' );
			},

			/**
			 * Paste after element.
			 *
			 * @since 2.0.0
			 */
			paste: function( position ) {
				var data    = this.copyData.data,
					type    = data.type,
					content = data.content,
					elType  = FusionPageBuilderApp.getElementType( type ),
					target  = false,
					parentId,
					parentView,
					rowView;

				if ( 'after' === position || 'before' === position ) {
					parentId = this.model.parent.attributes.parent;
					target   = this.model.parentView.$el;

					// If container, the parentId is self.
					if ( 'fusion_builder_container' === this.model.parent.attributes.type ) {
						parentId                                = this.model.parent.attributes.cid;
						FusionPageBuilderApp.targetContainerCID = this.model.parent.attributes.cid;
					}
				} else {
					parentId = this.model.parent.attributes.cid;
					target   = false;

					// If this is a container and we are inserting a column, the parent is actually the row.
					if ( 'fusion_builder_container' === this.model.parent.attributes.type ) {
						parentId = this.model.parentView.$el.find( '.fusion-builder-row-container' ).first().data( 'cid' );
					}
				}

				FusionPageBuilderApp.shortcodesToBuilder( content, parentId, false, false, target, position );

				// Save history state
				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.pasted + ' ' + fusionAllElements[ type ].name + ' ' + fusionBuilderText.element );

				FusionEvents.trigger( 'fusion-content-changed' );

				// If its a column, get the parent column and update.
				if ( 'fusion_builder_column' === type || 'fusion_builder_column_inner' === type ) {
					rowView = FusionPageBuilderViewManager.getView( parentId );
					if ( rowView ) {
						rowView.createVirtualRows();
						rowView.updateColumnsPreview();
					}
				}

				// If its a child element, the parent need to re-render.
				if ( 'child_element' === elType ) {
					if ( 'after' === position || 'before' === position ) {
						parentView = FusionPageBuilderViewManager.getView( parentId );
						parentView.render();
					} else {
						this.model.parentView.render();
					}
				}

				// If its an element the column needs rebuilt.
				if ( 'element' === elType || 'parent_element' === elType ) {
					parentView = FusionPageBuilderViewManager.getView( parentId );
					if ( parentView ) {
						parentView._equalHeights( parentView.model.attributes.parent );
					}
				}

				// Handle multiple global elements.
				window.fusionGlobalManager.handleMultiGlobal( {
					currentModel: this.model.parentView.model,
					handleType: 'save',
					attributes: this.model.parentView.model
				} );
			},

			/**
			 * Remove context meny..
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the element removal.
			 * @return {void}
			 */
			removeMenu: function( event ) {

				if ( event ) {
					event.preventDefault();
				}

				// Remove reference in builder app.
				FusionPageBuilderApp.contextMenuView = false;

				this.remove();

			}
		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderApp, fusionAllElements, FusionEvents, fusionBuilderText */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Container View
		FusionPageBuilder.ContextMenuInlineView = window.wp.Backbone.View.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-context-menu-inline' ).html() ),
			className: 'fusion-builder-context-menu fusion-builder-inline-context-menu',
			events: {
				'click [data-action="edit"]': 'editShortcodeInline',
				'click [data-action="remove-node"]': 'removeNode',
				'click [data-action="remove-style"]': 'removeStyle'
			},

			/**
			 * Initialize inline context menu.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {

				this.elWidth  = 105;
				this.elHeight = 36;
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var leftOffset = this.model.event.pageX,
					topOffset = this.model.event.pageY,
					$element  = this.model.$target.find( ' > *' ),
					elementOffset = $element.offset(),
					self = this;

				topOffset  = elementOffset.top - this.elHeight - 20;
				leftOffset = elementOffset.left + ( ( $element.width() - this.elWidth ) / 2 );

				this.$el.html( this.template( this.model.attributes ) );

				this.$el.css( { top: ( topOffset ) + 'px', left: ( leftOffset ) + 'px' } );

				setTimeout( function() {
					self.$el.addClass( 'fusion-builder-inline-context-menu-loaded' );
				}, 50 );

				return this;
			},

			/**
			 * Edit a shortcode within this element content.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the callback.
			 * @return {void}
			 */
			editShortcodeInline: function( event ) {

				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.inlineEditorHelpers.getInlineElementSettings( this.model );
			},

			/**
			 * Remove entire node.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the element removal.
			 * @return {void}
			 */
			removeNode: function( event ) {

				var $editor,
					content,
					param,
					params = this.model.parentView.model.get( 'params' ),
					editorInstance;

				if ( event ) {
					event.preventDefault();
				}

				$editor = this.model.$target.closest( '.fusion-live-editable' );

				this.model.$target.remove();

				editorInstance = FusionPageBuilderApp.inlineEditors.getEditor( $editor.data( 'medium-editor-editor-index' ) );
				if ( 'undefined' !== typeof editorInstance ) {
					content = editorInstance.getContent();
				} else {
					content = $editor.html();
				}

				param   = $editor.data( 'param' ),

				// Fix for inline font family style.
				content = content.replace( /&quot;/g, '\'' );

				// Adds in any inline shortcodes.
				content = FusionPageBuilderApp.htmlToShortcode( content, this.model.parentView.model.get( 'cid' ) );

				params[ param ] = content;
				this.model.parentView.model.set( 'params', params );

				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.deleted + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );
			},

			/**
			 * Remove styling only.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the element removal.
			 * @return {void}
			 */
			removeStyle: function( event ) {

				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.inlineEditorHelpers.removeStyle( this.model );
				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.deleted + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );
			},

			/**
			 * Remove context meny..
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the element removal.
			 * @return {void}
			 */
			removeMenu: function( event ) {

				if ( event ) {
					event.preventDefault();
				}

				// Remove reference in builder app.
				FusionPageBuilderApp.contextMenuView = false;

				this.remove();

			}
		} );
	} );
}( jQuery ) );
;/* global FusionApp, FusionPageBuilderApp, FusionEvents, fusionAllElements, FusionPageBuilderViewManager, fusionGlobalManager, fusionBuilderText, FusionPageBuilderElements */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Element View
		FusionPageBuilder.ElementView = FusionPageBuilder.BaseView.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-element-template' ).html() ),

			className: 'fusion-builder-live-element fusion-builder-data-cid',

			events: {
				'click .fusion-builder-remove': 'removeElement',
				'click .fusion-builder-clone': 'cloneElement',
				'click .fusion-builder-settings': 'settings',
				'click .fusion-builder-container-save': 'openLibrary',
				'click .fusion-builder-element-save': 'openLibrary',
				'click .fusion-builder-element-content a:not(.fusion-lightbox):not(.rs_error_message_button)': 'disableLink',
				'click .fusion-builder-element-drag': 'preventDefault',
				'click .fusion-tb-source': 'openDynamicSourcePO'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
				var elementType,
					inlineElements = [ 'fusion_button', 'fusion_fontawesome', 'fusion_imageframe', 'fusion_text' ];

				this.model.inlineCollection = new FusionPageBuilder.Collection();

				elementType = this.model.get( 'element_type' );

				this.renderedYet = FusionPageBuilderApp.reRenderElements;

				// If triggering a view update.
				this.listenTo( FusionEvents, 'fusion-view-update', this.reRender );
				this.listenTo( FusionEvents, 'fusion-view-update-' + this.model.get( 'cid' ), this.reRender );

				// If there is a template.
				if ( jQuery( '#tmpl-' + this.model.attributes.element_type + '-shortcode' ).length ) {
					this.model.set( 'noTemplate', false );
					this.elementTemplate = FusionPageBuilder.template( jQuery( '#tmpl-' + this.model.attributes.element_type + '-shortcode' ).html() );
				} else {
					this.model.set( 'noTemplate', true );
					this.elementTemplate = FusionPageBuilder.template( jQuery( '#tmpl-fusion_shortcode-shortcode' ).html() );
				}

				this.model.set( 'editLabel', this.getEditLabel() );
				this.elementIsCloning = false;

				this.$el.attr( 'data-cid', this.model.get( 'cid' ) );
				this.$el.attr( 'data-type', elementType );

				if ( -1 !== jQuery.inArray( elementType, inlineElements ) ) {
					this.$el.addClass( 'fusion-builder-live-element-inline' );
				}

				if ( 'undefined' !== typeof this.model.attributes.params && 'undefined' !== typeof this.model.attributes.params.fusion_global ) {
					this.$el.attr( 'fusion-global-layout', this.model.attributes.params.fusion_global );
					this.$el.removeClass( 'fusion-global-element' ).addClass( 'fusion-global-element' );
				}

				// JQuery trigger.
				this._refreshJs       = _.debounce( _.bind( this.refreshJs, this ), 300 );

				// Make sure the ajax callbacks are not repeated.
				this._triggerCallback = _.debounce( _.bind( this.triggerCallback, this ), 200 );

				this._updateResponsiveTypography = _.debounce( _.bind( this.updateResponsiveTypography, this ), 200 );

				// Undo/redo functionality.

				this._triggerColumn = _.debounce( _.bind( this.triggerColumn, this ), 300 );

				this.listenTo( FusionEvents, 'fusion-wireframe-toggle', this.wireFrameToggled );

				// Check if query_data is not set and element has callback.
				this.needsQuery();

				this.baseInit();

				this.onInit();

				// If inlne editing with overrides.
				this.activeInlineEditing = false;
				this.autoSelectEditor    = false;
				this.model.set( 'inlineEditors', [] );
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var self = this;

				FusionPageBuilderApp.disableDocumentWrite();
				this.beforeRender();

				this.$el.html( this.template( this.model.attributes ) );

				this.renderContent();

				if ( this.renderedYet ) {
					this._refreshJs();

					// Update column trigger.
					this.triggerColumn();

					setTimeout( function() {
						jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-typography-reset', self.model.get( 'cid' ) );
						if ( 800 > jQuery( '#fb-preview' ).width() ) {
							self._updateResponsiveTypography();
						}
					}, 100 );
				}

				this.onRender();

				this.needsGoogle();

				this.renderedYet = true;

				FusionPageBuilderApp.enableDocumentWrite();

				setTimeout( function() {
					self.droppableElement();

					if ( ! self.activeInlineEditing ) {
						FusionPageBuilderApp.inlineEditorHelpers.liveEditorEvent( self );
						self.activeInlineEditing = false;
					}
					if ( FusionPageBuilderApp.inlineEditorHelpers.inlineEditorAllowed( self.model.get( 'element_type' ) ) ) {
						self.renderInlineSettings();
					}
				}, 100 );

				return this;
			},

			/**
			 * Re-Renders the view.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the rerender.
			 * @param {string} param - Param being changed if any.
			 * @return {void}
			 */
			reRender: function( event ) {
				var self    = this,
					element = fusionAllElements[ this.model.get( 'element_type' ) ];

				if ( event && 'object' === typeof event ) {
					event.preventDefault();
				}

				// If element has query callback and no data yet, then fire.
				if ( 'undefined' !== typeof element.callback && 'undefined' === typeof this.model.get( 'query_data' ) ) {
					this.triggerQuery( element.callback );
					return;
				}

				// Neither of above, then just patchView.
				this.patchView( event );

				setTimeout( function() {
					self.droppableElement();

					if ( ! self.activeInlineEditing ) {
						FusionPageBuilderApp.inlineEditorHelpers.liveEditorEvent( self );
					}
					self.activeInlineEditing = false;
				}, 100 );
			},

			/**
			 * Determines if the element is part of a flex column or not.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			flexDisplay: function() {
				var container   = FusionPageBuilderApp.getParentContainer( this ),
					column      = FusionPageBuilderApp.getParentColumn( this ),
					params      = {},
					columnBlock = false;

				if ( column ) {
					params      = column.model.get( 'params' );
					columnBlock = 'undefined' !== typeof params.content_layout && 'block' === params.content_layout;
				}

				return container && container.isFlex() && ! columnBlock;
			},

			/**
			 * Triggers extra query when needed.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			needsQuery: function() {
				var element = fusionAllElements[ this.model.get( 'element_type' ) ],
					callbackFunction;

				// Check for callback set.
				if ( 'undefined' !== typeof element.callback && 'undefined' === typeof this.model.get( 'query_data' ) && 'undefined' === typeof this.model.get( 'markup' ) ) {

					callbackFunction = element.callback;
					this.triggerQuery( callbackFunction );
				}

				// Check for element without template and set shortcode for render function.
				if ( this.model.get( 'noTemplate' ) && 'undefined' === typeof this.model.get( 'markup' ) ) {
					this.model.set( 'shortcode', FusionPageBuilderApp.generateElementShortcode( this.$el ) );
				}
			},

			triggerQuery: function( callbackFunction ) {
				callbackFunction.args   = 'undefined' === typeof callbackFunction.args ? '' : callbackFunction.args;
				callbackFunction.ajax   = 'undefined' === typeof callbackFunction.ajax ? false : callbackFunction.ajax;
				callbackFunction.action = 'undefined' === typeof callbackFunction.action ? false : callbackFunction.action;
				callbackFunction.cid    = this.model.get( 'cid' );

				// If ajax trigger via debounce, else do it here and retun data.
				if ( callbackFunction.ajax ) {
					if ( 'generated_element' !== this.model.get( 'type' ) ) {
						FusionPageBuilderApp.shortcodeAjax = true;
					}
					this._triggerCallback( false, callbackFunction );
				}
			},

			/**
			 * Check if element needs a google font loaded.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			needsGoogle: function() {
				var variant = ':regular',
					$fontNodes = this.$el.find( '[data-fusion-google-font]' ),
					script,
					scriptID;

				if ( $fontNodes.length ) {
					$fontNodes.each( function() {
						var family = jQuery( this ).attr( 'data-fusion-google-font' );
						family = family.replace( /"/g, '&quot' );

						script  = family;
						script += ( variant ) ? variant : '';

						scriptID = script.replace( /:/g, '' ).replace( /"/g, '' ).replace( /'/g, '' ).replace( / /g, '' ).replace( /,/, '' );

						if ( ! jQuery( '#fb-preview' ).contents().find( '#' + scriptID ).length ) {
							jQuery( '#fb-preview' ).contents().find( 'head' ).append( '<script id="' + scriptID + '">WebFont.load({google:{families:["' + script + '"]},context:FusionApp.previewWindow,active: function(){ jQuery( window ).trigger( "fusion-font-loaded"); },});</script>' );
						}
					} );
				}
			},

			/**
			 * Triggers for columns.
			 *
			 * @since 2.0.0
			 * @param {Object} parent The parent object.
			 * @return {void}
			 */
			triggerColumn: function( parent ) {
				var parentCid = 'undefined' === typeof parent ? this.model.attributes.parent : parent;
				setTimeout( function() {
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-content-changed', parentCid );
				}, 300 );
			},

			/**
			 * Get template attributes.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getTemplateAtts: function() {
				var element = fusionAllElements[ this.model.get( 'element_type' ) ],
					templateAttributes = jQuery.extend( true, {}, this.model.attributes ),
					params = jQuery.extend( true, {}, this.model.get( 'params' ) ),
					values = {},
					extras = {};

				// Set values & extras
				if ( element && 'undefined' !== typeof element.defaults ) {
					values = jQuery.extend( true, {}, element.defaults, _.fusionCleanParameters( params ) );
					if ( 'undefined' !== typeof element.extras ) {
						extras = jQuery.extend( true, {}, element.extras );
					}
				}

				templateAttributes.values = values;
				templateAttributes.extras = extras;

				templateAttributes = this.getDynamicAtts( templateAttributes );
				templateAttributes = this.filterTemplateAtts( templateAttributes );

				return templateAttributes;
			},

			/**
			 * Render the content.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			renderContent: function() {
				var $elementContent = this.$el.find( '.fusion-builder-element-content' ),
					element         = fusionAllElements[ this.model.get( 'element_type' ) ],
					self            = this,
					markup;

				// Render wireframe template
				self.renderWireframePreview();

				// If needs query add loader and either trigger or check where triggered.
				if ( 'undefined' !== typeof element.callback && 'undefined' === typeof this.model.get( 'query_data' ) && true === element.callback.ajax ) {

					// If this is first render, use markup if it exists.
					if ( ! this.renderedYet && 'undefined' !== typeof this.model.get( 'markup' ) ) {
						markup = this.model.get( 'markup' );
						$elementContent.html( markup.output + '<div class="fusion-clearfix"></div>' );

						return;
					}
					this.addLoadingOverlay();
					this.triggerQuery( element.callback );
					return;
				}

				// Otherwise use element template
				$elementContent.html( self.getTemplate() );
			},

			/**
			 * Removes an element.
			 *
			 * @since 2.0.0
			 * @param {Object} event The event triggering the element removal.
			 * @return {void}
			 */
			removeElement: function( event, isAutomated ) {
				var parentCid   = this.model.get( 'parent' ),
					parentModel = FusionPageBuilderElements.find( function( model ) {
						return model.get( 'cid' ) == parentCid; // jshint ignore: line
					} ),
					colView,
					MultiGlobalArgs;

				if ( event ) {
					event.preventDefault();

					colView = FusionPageBuilderViewManager.getView( parentCid );
					colView.$el.find( '.fusion-builder-module-controls-container a' ).trigger( 'mouseleave' );

					FusionEvents.trigger( 'fusion-content-changed' );
					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.deleted + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );
				}

				// Hook to allow custom actions.
				this.beforeRemove();

				// Removes scripts which have been moved to body.
				FusionApp.deleteScripts( this.model.get( 'cid' ) );

				// Remove live editors.
				FusionPageBuilderApp.inlineEditorHelpers.removeLiveEditors( this );

				// Remove element view
				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				// Destroy element model
				this.model.destroy();

				FusionEvents.trigger( 'fusion-element-removed', this.model.get( 'cid' ) );

				// Update column trigger.
				this.triggerColumn( parentCid );

				this.remove();

				if ( parentModel.children.length && 'undefined' === typeof isAutomated ) {

					// Handle multiple global elements.
					MultiGlobalArgs = {
						currentModel: parentModel.children.models[ 0 ],
						handleType: 'save',
						attributes: parentModel.children.models[ 0 ].attributes
					};
					fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );
				}

			},

			/**
			 * Opens dynamic source PO.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the element removal.
			 * @return {void}
			 *
			 */
			openDynamicSourcePO: function( event ) { // eslint-disable-line no-unused-vars
				if ( 'undefined' !== typeof FusionApp.sidebarView ) {
					FusionApp.sidebarView.openOption( 'dynamic_content_preview_type', 'po' );
				}
			},

			/**
			 * Clones an element.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the element removal.
			 * @return {void}
			 *
			 */
			cloneElement: function( event ) {
				var elementAttributes,
					currentModel,
					MultiGlobalArgs;

				if ( event ) {
					event.preventDefault();
				}

				if ( ( 'undefined' !== typeof this.$el.data( 'type' ) && -1 !== this.$el.data( 'type' ).indexOf( 'fusion_tb_' ) ) || true === this.elementIsCloning ) {
					return;
				}

				this.elementIsCloning = true;

				elementAttributes = jQuery.extend( true, {}, this.model.attributes );
				elementAttributes.created = 'manually';
				elementAttributes.cid = FusionPageBuilderViewManager.generateCid();
				elementAttributes.targetElement = this.$el;
				elementAttributes.at_index = FusionPageBuilderApp.getCollectionIndex( this.$el );

				if ( 'undefined' !== elementAttributes.from ) {
					delete elementAttributes.from;
				}

				currentModel = FusionPageBuilderApp.collection.add( elementAttributes );

				this.elementIsCloning = false;

				// Handle multiple global elements.
				MultiGlobalArgs = {
					currentModel: currentModel,
					handleType: 'save',
					attributes: currentModel.attributes
				};
				fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

				if ( event ) {
					FusionEvents.trigger( 'fusion-content-changed' );

					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.cloned + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );
				}

				// Update column trigger.
				this.triggerColumn();

			},

			/**
			 * Get the content.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getContent: function() {
				return FusionPageBuilderApp.generateElementShortcode( this.$el, false );
			},

			/**
			 * Get the placeholder.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getPlaceholder: function() {
				var label  		= window.fusionAllElements[ this.model.get( 'element_type' ) ].name;
				var icon   		= window.fusionAllElements[ this.model.get( 'element_type' ) ].icon;

				var placeholder = _.template( '<div class="fusion-builder-placeholder-preview"><i class="<%= icon %>" aria-hidden="true"></i> <%= label %></div>' );
				return placeholder( { icon: icon, label: label } );
			},

			/**
			 * Get component placeholder.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getComponentPlaceholder: function() {
				var placeholder = jQuery( this.getPlaceholder() ).append( '<span class="fusion-tb-source-separator"> - </span><a href="#" class="fusion-tb-source">' + fusionBuilderText.dynamic_source + '</a>' );
				return placeholder[ 0 ].outerHTML;
			}

		} );
	} );
}( jQuery ) );
;/* global FusionApp, FusionEvents, FusionPageBuilderApp, fusionGlobalManager, fusionBuilderText, fusionAllElements, FusionPageBuilderViewManager, fusionMultiElements, FusionPageBuilderElements */
/* eslint no-unused-vars: 0 */
/* eslint guard-for-in: 0 */
/* eslint no-undef: 0 */
/* eslint no-empty-function: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Element View
		FusionPageBuilder.ParentElementView = FusionPageBuilder.BaseView.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-element-parent-template' ).html() ),

			className: 'fusion-builder-live-element fusion-builder-data-cid',

			events: {
				'click .fusion-builder-remove': 'removeElement',
				'click .fusion-builder-clone': 'cloneElement',
				'click .fusion-builder-settings': 'settings',
				'click .fusion-builder-add-child': 'addChildElement',
				'click .fusion-builder-element-save': 'openLibrary',
				'click a': 'disableLink',
				'click .fusion-builder-element-drag': 'preventDefault'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {

				this.model.children = new FusionPageBuilder.Collection();

				this.listenTo( this.model.children, 'add', this.addChildView );
				this.emptyPlaceholderText = 'undefined' !== typeof fusionAllElements[ this.model.get( 'element_type' ) ] ? fusionBuilderText.empty_parent.replace( '%s', fusionAllElements[ this.model.get( 'element_type' ) ].name ) : '';

				// If triggering a view update.
				this.listenTo( FusionEvents, 'fusion-view-update', this.reRender );
				this.listenTo( FusionEvents, 'fusion-view-update-' + this.model.get( 'cid' ), this.reRender );
				this.listenTo( FusionEvents, 'fusion-view-update-' + this.model.get( 'element_type' ), this.reRender );

				this._triggerCallback = _.debounce( _.bind( this.triggerCallback, this ), 200 );

				// If there is a template.
				if ( jQuery( '#tmpl-' + this.model.attributes.element_type + '-shortcode' ).length ) {
					this.model.set( 'noTemplate', false );
					this.elementTemplate = FusionPageBuilder.template( jQuery( '#tmpl-' + this.model.attributes.element_type + '-shortcode' ).html() );
				} else {
					this.model.set( 'noTemplate', true );
					this.elementTemplate = FusionPageBuilder.template( jQuery( '#tmpl-fusion_shortcode-shortcode' ).html() );
				}

				this.elementIsCloning = false;
				this.mouseDown = false;

				this.fetchIds = [];

				this.childIds = [];

				this.updateGallery = false;

				this.model.set( 'editLabel', this.getEditLabel() );

				this.$el.attr( 'data-cid', this.model.get( 'cid' ) );
				this.$el.attr( 'data-type', this.model.get( 'element_type' ) );

				if ( 'undefined' !== typeof this.model.attributes.params && 'undefined' !== typeof this.model.attributes.params.fusion_global ) {
					this.$el.attr( 'fusion-global-layout', this.model.attributes.params.fusion_global );
					this.$el.removeClass( 'fusion-global-parent-element' ).addClass( 'fusion-global-parent-element' );
				}

				this.baseInit();

				// JQuery trigger.
				this.renderedYet = FusionPageBuilderApp.reRenderElements;
				this._refreshJs  = _.debounce( _.bind( this.refreshJs, this ), 300 );

				this.listenTo( FusionEvents, 'fusion-wireframe-toggle', this.wireFrameToggled );

				this.model.set( 'sortable', 'undefined' === typeof fusionAllElements[ this.model.get( 'element_type' ) ].sortable ? true : fusionAllElements[ this.model.get( 'element_type' ) ].sortable );

				this.onInit();
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function( event ) {
				var self = this;

				this.$el.html( this.template( this.model.attributes ) );

				this.renderContent();

				// If from ajax, do not regenerate children.
				if ( 'string' !== typeof event && 'ajax' !== event ) {
					this.generateChildElements();
				}

				// If no template, no need for sortable children call.
				if ( ! this.model.get( 'noTemplate' ) ) {
					setTimeout( function() {
						self.sortableChildren();
					}, 100 );
				}

				// Don't refresh on first render.
				if ( this.renderedYet ) {
					this._refreshJs();
				}

				this.onRender();

				this.renderedYet = true;

				setTimeout( function() {
					self.droppableElement();
				}, 100 );

				return this;
			},

			/**
			 * Make children sortable.
			 * This is executed from the render() function.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			sortableChildren: function() {
				var self       = this,
					$container = self.$el.find( '.fusion-child-element' );

				if ( false === this.model.get( 'sortable' ) ) {
					return;
				}

				$container.on( 'mousedown', function( event ) {
					if ( ! jQuery( event.originalEvent.target ).hasClass( 'fusion-live-editable' ) ) {
						self.mouseDown = true;
					}
				} );

				$container.on( 'mousemove', function() {
					if ( self.mouseDown ) {
						$container.css( { overflow: 'auto' } );
					}
				} );

				$container.on( 'mouseup', function() {
					self.mouseDown = false;
					$container.css( { overflow: '' } );
				} );

				this.$el.find( '.fusion-builder-element-content' ).sortable( {

					items: '.fusion-builder-live-child-element',
					tolerance: 'pointer',
					appendTo: $container,
					containment: $container,
					cursor: 'grabbing',
					cancel: '.fusion-live-editable',
					zIndex: 99999999,
					helper: 'clone',
					scroll: false,
					revert: 100,
					start: function() {
						FusionPageBuilderApp.$el.addClass( 'fusion-builder-dragging' );
						$container.addClass( 'fusion-parent-sortable' );
					},
					update: function( event, ui ) {
						var MultiGlobalArgs,
							elementView = FusionPageBuilderViewManager.getView( ui.item.data( 'cid' ) ),
							newIndex    = ui.item.parent().children( '.fusion-builder-live-child-element' ).index( ui.item );

						self.updateElementContent();

						// Update collection
						FusionPageBuilderApp.onDropCollectionUpdate( elementView.model, newIndex, self.model.get( 'cid' ) );

						// Save history state
						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.moved + ' ' + fusionAllElements[ elementView.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );

						// Handle multiple global elements.
						MultiGlobalArgs = {
							currentModel: self.model,
							handleType: 'save',
							attributes: self.model.attributes
						};
						fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

						FusionEvents.trigger( 'fusion-content-changed' );
					},
					stop: function() {
						self.mouseDown = false;
						$container.css( { overflow: '' } );
						$container.removeClass( 'fusion-parent-sortable' );
						FusionPageBuilderApp.$el.removeClass( 'fusion-builder-dragging' );
					}
				} );
			},

			/**
			 * Updates the element contents.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			updateElementContent: function() {
				var content = '',
					children;

				if ( this.model.get( 'noTemplate' ) ) {
					children = FusionPageBuilderViewManager.getChildViews( this.model.get( 'cid' ) );
					_.each( children, function( child ) {
						content += child.getContent();
					} );
				} else {
					this.$el.find( '.fusion-builder-live-child-element' ).each( function() {
						var $thisEl = jQuery( this );
						content += FusionPageBuilderApp.generateElementShortcode( $thisEl, false );
					} );
				}

				this.model.attributes.params.element_content = content;
			},

			/**
			 * Get template attributes.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getTemplateAtts: function() {
				var templateAttributes = jQuery.extend( true, {}, this.model.attributes ),
					params  = jQuery.extend( true, {}, this.model.get( 'params' ) ),
					values  = {},
					extras  = {},
					element = fusionAllElements[ this.model.get( 'element_type' ) ];

				if ( 'undefined' !== typeof this.elementTemplate ) {

					// Get element values.
					if ( element && 'undefined' !== typeof element.defaults ) {
						values = jQuery.extend( true, {}, element.defaults, _.fusionCleanParameters( params ) );

						// Get element extras.
						if ( 'undefined' !== typeof element.extras ) {
							extras = jQuery.extend( true, {}, element.extras );
						}
					}

					templateAttributes.values    = values;
					templateAttributes.extras    = extras;
					templateAttributes.thisModel = this.model;

					templateAttributes = this.getDynamicAtts( templateAttributes );
					templateAttributes = this.filterTemplateAtts( templateAttributes );

					return templateAttributes;
				}
			},

			/**
			 * Renders the content.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			renderContent: function() {

				if ( 'undefined' !== typeof this.elementTemplate ) {
					this.$el.find( '.fusion-builder-element-content' ).html( this.getTemplate() );
				}

				// Render wireframe template
				this.renderWireframePreview();
			},

			/**
			 * Removes children.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			removeChildren: function( event ) {

				var children = FusionPageBuilderViewManager.getChildViews( this.model.get( 'cid' ) );

				if ( event ) {
					event.preventDefault();
				}

				_.each( children, function( child ) {
					child.removeElement( '', 'Automated' );
				} );
			},

			/**
			 * Removes an element.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			removeElement: function( event, isAutomated ) {
				var parentCid   = this.model.get( 'parent' ),
					parentModel = FusionPageBuilderElements.find( function( model ) {
						return model.get( 'cid' ) == parentCid; // jshint ignore: line
					} ),
					MultiGlobalArgs,
					colView;

				if ( event ) {
					event.preventDefault();

					colView = FusionPageBuilderViewManager.getView( parentCid );
					colView.$el.find( '.fusion-builder-module-controls-container a' ).trigger( 'mouseleave' );
				}

				// Hook to allow custom actions.
				this.beforeRemove();

				// Remove children elements
				this.removeChildren();

				// Remove element view
				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				FusionEvents.trigger( 'fusion-element-removed', this.model.get( 'cid' ) );

				// Destroy element model
				this.model.destroy();

				this.remove();

				// If element is removed manually
				if ( event ) {
					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.deleted + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );
				}

				if ( parentModel.children.length && 'undefined' === typeof isAutomated ) {

					// Handle multiple global elements.
					MultiGlobalArgs = {
						currentModel: parentModel.children.models[ 0 ],
						handleType: 'save',
						attributes: parentModel.children.models[ 0 ].attributes
					};
					fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );
				}
			},

			/**
			 * Clones an element.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			cloneElement: function( event ) {
				var elementAttributes,
					currentModel,
					MultiGlobalArgs;

				if ( event ) {
					event.preventDefault();
				}

				if ( true === this.elementIsCloning ) {
					return;
				}
				this.elementIsCloning = true;

				elementAttributes = jQuery.extend( true, {}, this.model.attributes );
				elementAttributes.created = 'manually';
				elementAttributes.cid = FusionPageBuilderViewManager.generateCid();
				elementAttributes.targetElement = this.$el;
				if ( 'undefined' !== elementAttributes.from ) {
					delete elementAttributes.from;
				}

				currentModel = FusionPageBuilderApp.collection.add( elementAttributes );

				// Save history state
				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.cloned + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );

				this.elementIsCloning = false;

				// Handle multiple global elements.
				MultiGlobalArgs = {
					currentModel: currentModel,
					handleType: 'save',
					attributes: currentModel.attributes
				};
				fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

				if ( event ) {
					FusionEvents.trigger( 'fusion-content-changed' );
				}
			},

			noTemplateAjaxUpdate: function() {
				this.updateElementContent();
				FusionApp.callback.fusion_do_shortcode( this.model.get( 'cid' ), this.getContent() );
			},

			/**
			 * Generates the child elements.
			 *
			 * @since 2.0.0
			 * @param {boolean|undefined} fixSettingsLvl - Whether we want to fix the settings levels or not.
			 *                                          Use true (bool) for yes. undefined has the same effect as false.
			 * @return {void}
			 */
			generateChildElements: function( fixSettingsLvl ) {
				var thisEl        = this,
					parentAtts    = this.model.get( 'params' ),
					content       = this.model.attributes.params.element_content,
					shortcodeTags = jQuery.map( fusionMultiElements, function( val, i ) { // jshint ignore: line
						return val;
					} ).join( '|' ),
					regExp      = window.wp.shortcode.regexp( shortcodeTags ),
					innerRegExp = FusionPageBuilderApp.regExpShortcode( shortcodeTags ),
					last        = false,
					matches     = 'undefined' !== typeof content ? content.match( regExp ) : false,
					modules     = {};

				// Make sure we don't just keep adding.
				this.removeChildren();
				thisEl.model.children.reset( null );

				if ( ! content ) {
					return;
				}

				_.each( matches, function( shortcode, index ) {
					var shortcodeElement     = shortcode.match( innerRegExp ),
						shortcodeName        = shortcodeElement[ 2 ],
						shortcodeAttributes  = '' !== shortcodeElement[ 3 ] ? window.wp.shortcode.attrs( shortcodeElement[ 3 ] ) : '',
						shortcodeContent     = shortcodeElement[ 5 ],
						moduleCID            = FusionPageBuilderViewManager.generateCid(), // jshint ignore: line
						prefixedAttributes   = { params: ( {} ) },
						tagName              = 'div',

						// Check if shortcode allows generator
						allowGenerator = 'undefined' !== typeof fusionAllElements[ shortcodeName ].allow_generator ? fusionAllElements[ shortcodeName ].allow_generator : '',
						moduleSettings,
						key,
						prefixedKey,
						dependencyOption,
						dependencyOptionValue,
						moduleContent,
						markupContent;

					if ( 'undefined' !== typeof fusionAllElements[ shortcodeName ].tag_name ) {
						tagName = fusionAllElements[ shortcodeName ].tag_name;
					}

					// If last child.
					last = index + 1 === matches.length;

					moduleSettings = {
						type: 'element',
						element_type: shortcodeName,
						cid: FusionPageBuilderViewManager.generateCid(),
						view: thisEl,
						created: 'auto',
						multi: 'multi_element_child',
						child_element: 'true',
						allow_generator: allowGenerator,
						inline_editor: FusionPageBuilderApp.inlineEditorHelpers.inlineEditorAllowed( shortcodeName ),
						params: {},
						parent: thisEl.model.get( 'cid' ),
						tag_name: tagName,
						last: last
					};

					// Get markup from map if set.  Add further checks here so only necessary elements do this check.
					if ( -1 === shortcodeName.indexOf( 'fusion_builder_' ) ) {
						markupContent = FusionPageBuilderApp.extraShortcodes.byShortcode( shortcodeElement[ 0 ] );
						if ( 'undefined' !== typeof markupContent ) {
							moduleSettings.markup = markupContent;
						} else {
							moduleSettings.shortcode = shortcodeElement[ 0 ];
						}
					}

					if ( _.isObject( shortcodeAttributes.named ) ) {

						for ( key in shortcodeAttributes.named ) {

							prefixedKey = key;

							prefixedAttributes.params[ prefixedKey ] = shortcodeAttributes.named[ key ];
						}

						moduleSettings = _.extend( moduleSettings, prefixedAttributes );
					}

					// TODO: check if needed.  Commented out for FB item 420.
					// if ( ! shortcodesInContent ) {
					moduleSettings.params.element_content = shortcodeContent;

					// }.

					// Checks if map has set selectors. If so needs to be set prior to render.
					if ( 'undefined' !== typeof fusionAllElements[ shortcodeName ].selectors ) {
						moduleSettings.selectors = jQuery.extend( true, {}, fusionAllElements[ shortcodeName ].selectors );
					}

					// Set module settings for modules with dependency options
					if ( 'undefined' !== typeof fusionAllElements[ shortcodeName ].option_dependency ) {

						dependencyOption      = fusionAllElements[ shortcodeName ].option_dependency;
						dependencyOptionValue = prefixedAttributes.params[ dependencyOption ];
						moduleContent         = prefixedAttributes.params.element_content;
						prefixedAttributes.params[ dependencyOptionValue ] = moduleContent;

					}

					// Fix for deprecated 'settings_lvl' attribute
					if ( true === fixSettingsLvl ) {
						if ( 'fusion_content_box' === moduleType ) { // jshint ignore: line

							// Reset values that are inherited from parent
							moduleSettings.params.iconcolor              = '';
							moduleSettings.params.backgroundcolor        = '';
							moduleSettings.params.circlecolor            = '';
							moduleSettings.params.circlebordercolor      = '';
							moduleSettings.params.circlebordersize       = '';
							moduleSettings.params.outercirclebordercolor = '';
							moduleSettings.params.outercirclebordersize  = '';

							// Set values from parent element
							moduleSettings.params.animation_type      = parentAtts.animation_type;
							moduleSettings.params.animation_direction = parentAtts.animation_direction;
							moduleSettings.params.animation_speed     = parentAtts.animation_speed;
							moduleSettings.params.link_target         = parentAtts.link_target;
						}
					}

					modules[ moduleSettings.cid ] = moduleSettings;

				} );

				this.onGenerateChildElements( modules );

				// Add child elements to children collection.
				_.each( modules, function( moduleSettings ) {
					thisEl.model.children.add( [ moduleSettings ] );
				} );
			},

			/**
			 * Extendable function for when child elements get generated.
			 *
			 * @since 2.0.0
			 * @param {Object} modules An object of modules that are not a view yet.
			 * @return {void}
			 */
			onGenerateChildElements: function( modules ) {
			},

			/**
			 * Adds a child element.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addChildElement: function( event ) {

				var params = {},
					defaultParams,
					value,
					moduleSettings,
					allowGenerator,
					childElement,
					newModel,
					MultiGlobalArgs,
					tagName = 'div';

				if ( event ) {
					event.preventDefault();
				}

				childElement = fusionMultiElements[ this.model.get( 'element_type' ) ];

				defaultParams = fusionAllElements[ childElement ].params;

				allowGenerator = ( 'undefined' !== typeof fusionAllElements[ childElement ].allow_generator ) ? fusionAllElements[ childElement ].allow_generator : '';

				// Process default parameters from shortcode
				_.each( defaultParams, function( param )  {
					value = ( _.isObject( param.value ) ) ? param[ 'default' ] : param.value;
					params[ param.param_name ] = value;
				} );

				if ( 'undefined' !== typeof fusionAllElements[ childElement ].tag_name ) {
					tagName = fusionAllElements[ childElement ].tag_name;
				}

				moduleSettings = {
					type: 'element',
					element_type: childElement,
					cid: FusionPageBuilderViewManager.generateCid(),
					view: this,
					created: 'manually',
					multi: 'multi_element_child',
					child_element: 'true',
					params: params,
					allow_generator: allowGenerator,
					inline_editor: FusionPageBuilderApp.inlineEditorHelpers.inlineEditorAllowed( childElement ),
					parent: this.model.get( 'cid' ),
					tag_name: tagName,
					last: true
				};

				// Checks if map has set selectors. If so needs to be set prior to render.
				if ( 'undefined' !== typeof fusionAllElements[ childElement ].selectors ) {
					moduleSettings.selectors = jQuery.extend( true, {}, fusionAllElements[ childElement ].selectors );
				}

				if ( 'undefined' !== typeof event && jQuery( event.currentTarget ).closest( '.fusion-builder-live-child-element' ).length && ! FusionPageBuilderApp.wireframeActive ) {
					moduleSettings.targetElement = jQuery( event.currentTarget ).closest( '.fusion-builder-live-child-element' );
				}

				newModel = this.model.children.add( [ moduleSettings ] );

				if ( this.model.get( 'noTemplate' ) ) {
					this.noTemplateAjaxUpdate();
				}

				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.added + ' ' + fusionAllElements[ childElement ].name + ' ' + fusionBuilderText.element );

				// Handle multiple global elements.
				MultiGlobalArgs = {
					currentModel: newModel[ 0 ],
					handleType: 'changeOption'
				};
				fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );
				FusionEvents.trigger( 'fusion-content-changed' );

				this.childViewAdded();
			},

			afterPatch: function() {
				var self = this;

				this.generateChildElements();

				setTimeout( function() {
					self.droppableElement();
				}, 100 );
			},

			/**
			 * Adds a child view.
			 *
			 * @since 2.0.0
			 * @param {Object} child - The child element's model.
			 * @return {void}
			 */
			addChildView: function( child ) {
				var view,
					viewSettings = {
						model: child,
						collection: FusionPageBuilderElements
					};

				if ( 'undefined' !== typeof FusionPageBuilder[ child.get( 'element_type' ) ] ) {
					view = new FusionPageBuilder[ child.get( 'element_type' ) ]( viewSettings );
				} else {
					view = new FusionPageBuilder.ChildElementView( viewSettings );
				}

				FusionPageBuilderViewManager.addView( child.get( 'cid' ), view );

				if ( 'undefined' !== typeof child.get( 'targetElement' ) ) {
					if ( 'undefined' === typeof child.get( 'targetElementPosition' ) || 'after' === child.get( 'targetElementPosition' ) ) {
						child.get( 'targetElement' ).after( view.render().el );
					} else {
						child.get( 'targetElement' ).before( view.render().el );
					}
				} else if ( 'undefined' === typeof child.get( 'targetElementPosition' ) || 'end' === child.get( 'targetElementPosition' ) ) {
					this.$el.find( '.fusion-child-element' ).append( view.render().el );
				} else {
					this.$el.find( '.fusion-child-element' ).prepend( view.render().el );
				}

				// Check for extra contents and append to correct location.
				this.appendContents( view );

				this.updateElementContent();
			},

			/**
			 * Fired when child view is added.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			childViewAdded: function() {
			},

			/**
			 * Fired when child view is removed.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			childViewRemoved: function() {
			},

			/**
			 * Fired when child view is cloned.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			childViewCloned: function() {
			},

			/**
			 * Appends content to the view.
			 *
			 * @since 2.0.0
			 * @param {Object} view - The view.
			 * @return {void}
			 */
			appendContents: function( view ) {
				var self        = this,
					extraAppend = view.model.get( 'extraAppend' ),
					contents,
					selector,
					existing;

				if ( 'undefined' !== typeof extraAppend ) {
					contents = extraAppend.contents;
					selector = extraAppend.selector;
					existing = extraAppend.existing;
					if ( 'object' === typeof extraAppend.existing ) {
						_.each( extraAppend.existing, function( old, index ) {
							self.$el.find( selector ).remove( old );
							self.$el.find( selector ).append( contents[ index ] );
						} );
						return;
					}
					this.$el.find( selector ).remove( existing );
					this.$el.find( selector ).append( contents );
				}
			},

			/**
			 * Delegates multiple child elements.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			delegateChildEvents: function() {
				var cid,
					view;

				this.model.children.each( function( child ) {
					cid = child.attributes.cid;
					view = FusionPageBuilderViewManager.getView( cid );

					view.delegateEvents();
				} );
			},

			/**
			 * Sets the content and re-renders.
			 *
			 * @since 2.0.0
			 * @param {string} content - The content.
			 * @return {void}
			 */
			setContent: function( content ) {
				this.model.attributes.params.element_content = content;
				this.reRender();
			},

			/**
			 * Gets the content.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getContent: function() {
				return FusionPageBuilderApp.generateElementShortcode( this.$el, false );
			},

			/**
			 * Append children.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			appendChildren: function( target ) {
				var self = this,
					cid,
					view;

				this.model.children.each( function( child ) {

					cid  = child.attributes.cid;
					view = FusionPageBuilderViewManager.getView( cid );

					self.$el.find( target ).append( view.$el );

					view.reRender();
				} );

				this.delegateChildEvents();
			}
		} );
	} );
}( jQuery ) );
;/* global FusionEvents, FusionPageBuilderApp, FusionPageBuilderViewManager, fusionGlobalManager, fusionBuilderText, fusionAllElements, FusionPageBuilderElements */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Element View
		FusionPageBuilder.ChildElementView = FusionPageBuilder.BaseView.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-child-element-template' ).html() ),

			className: 'fusion-builder-live-child-element fusion-builder-data-cid',
			tagName: function() {
				return this.model.get( 'tag_name' );
			},

			events: {
				'click .fusion-builder-remove-child': 'removeElement',
				'click .fusion-builder-clone-child': 'cloneElement',
				'click .fusion-builder-settings-child': 'settings',
				'click a': 'disableLink'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {

				var parent = this.model.get( 'parent' ),
					parentModel = FusionPageBuilderElements.find( function( model ) {
						return model.get( 'cid' ) == parent; // jshint ignore:line
					} );

				this.model.inlineCollection = new FusionPageBuilder.Collection();

				this._triggerCallback = _.debounce( _.bind( this.triggerCallback, this ), 200 );

				// If triggering a view update.
				this.listenTo( FusionEvents, 'fusion-child-view-update', this.reRender );
				this.listenTo( FusionEvents, 'fusion-view-update-' + this.model.get( 'cid' ), this.reRender );
				this.listenTo( FusionEvents, 'fusion-view-update-' + this.model.get( 'element_type' ), this.reRender );

				// If there is a template.
				if ( jQuery( '#tmpl-' + this.model.attributes.element_type + '-shortcode' ).length ) {
					this.model.set( 'noTemplate', false );
					this.elementTemplate = FusionPageBuilder.template( jQuery( '#tmpl-' + this.model.attributes.element_type + '-shortcode' ).html() );
				} else {
					this.model.set( 'noTemplate', true );
					this.elementTemplate = FusionPageBuilder.template( jQuery( '#tmpl-fusion_shortcode-shortcode' ).html() );
				}

				this.elementIsCloning = false;

				this.model.set( 'editLabel', this.getEditLabel() );

				// JQuery trigger.
				this._refreshJs = _.debounce( _.bind( this.refreshJs, this ), 300 );

				this.$el.attr( 'data-cid', this.model.get( 'cid' ) );
				this.$el.attr( 'data-parent-cid', this.model.get( 'parent' ) );
				this.$el.attr( 'data-element-type', this.model.get( 'element_type' ) );

				if ( 'undefined' !== typeof this.model.attributes.params && 'undefined' !== typeof this.model.attributes.params.fusion_global ) {
					this.$el.attr( 'fusion-global-layout', this.model.attributes.params.fusion_global );
					this.$el.removeClass( 'fusion-global-child-element' ).addClass( 'fusion-global-child-element' );
				}

				if ( ! parentModel.get( 'sortable' ) ) {
					this.$el.attr( 'data-fusion-no-dragging', true );
				}
				this.model.set( 'sortable', parentModel.get( 'sortable' ) );

				this.baseInit();

				this.onInit();

				// If inlne editing with overrides.
				this.activeInlineEditing = false;
				this.autoSelectEditor    = false;
				this.model.set( 'inlineEditors', [] );
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var self = this;

				this.$el.html( this.template( this.model.attributes ) );

				this.renderContent();

				if ( 'undefined' !== typeof this.model.attributes.selectors ) {
					this.model.attributes.selectors[ 'class' ] += ' ' + this.className;
					this.setElementAttributes( this.$el, this.model.attributes.selectors );
				}

				if ( 'undefined' !== typeof this.model.attributes.extraAppend ) {
					this.updateExtraContents();
				}

				this.$el.find( '.fusion-builder-module-controls-container' ).on( 'mouseenter mouseleave', _.bind( this.changeParentContainerControlsZindex, this ) );

				this.onRender();

				this._refreshJs();

				setTimeout( function() {
					if ( ! self.activeInlineEditing ) {
						FusionPageBuilderApp.inlineEditorHelpers.liveEditorEvent( self );
						self.activeInlineEditing = false;
					}

					if ( FusionPageBuilderApp.inlineEditorHelpers.inlineEditorAllowed( self.model.get( 'element_type' ) ) ) {
						self.renderInlineSettings();
					}
				}, 100 );

				return this;
			},

			afterPatch: function() {
				this._refreshJs();
			},

			/**
			 * Changes the z-index on the controls wrapper of the parent container.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			changeParentContainerControlsZindex: function( event ) {
				if ( 'mouseenter' === event.type ) {
					this.$el.closest( '.fusion-builder-container' ).find( '.fusion-builder-module-controls-container-wrapper' ).css( 'z-index', '0' );
				} else {
					this.$el.closest( '.fusion-builder-container' ).find( '.fusion-builder-module-controls-container-wrapper' ).removeAttr( 'style' );
				}
			},

			/**
			 * Updates extra elements by replacing their contents.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			updateExtraContents: function() {
				var self        = this,
					extraAppend = this.model.get( 'extraAppend' ),
					contents    = extraAppend.contents,
					existing    = extraAppend.existing;

				if ( 'object' === typeof extraAppend.existing ) {
					_.each( existing, function( old, index ) {
						self.updateSingleExtraContent( old, contents[ index ] );
					} );
				} else {
					this.updateSingleExtraContent( existing, contents );
				}

				if ( 'undefined' !== typeof this.model.attributes.extraAppend.trigger ) {
					this.$el.find( 'a[id="' + this.model.attributes.extraAppend.trigger.replace( '#', '' ) + '"]' ).closest( 'li' ).trigger( 'click' );
				}
			},

			updateSingleExtraContent: function( existing, contents ) {
				if ( this.$el.closest( '.fusion-builder-live-element' ).find( existing ).length ) {
					this.$el.closest( '.fusion-builder-live-element' ).find( existing ).replaceWith( FusionPageBuilderApp.renderContent( contents, this.model.get( 'cid' ), this.model.get( 'parent' ) ) );
				}
			},

			/**
			 * Removes extra elements by removing their contents.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			removeExtraContents: function() {
				var $parentEl = this.$el.closest( '.fusion-builder-live-element' ),
					$existing,
					targetId,
					$sibling;

				// Find and remove extra content.
				if ( 'undefined' !== typeof this.model.attributes.extraAppend && 'undefined' !== typeof this.model.attributes.extraAppend.existing ) {
					$existing = $parentEl.find( this.model.attributes.extraAppend.existing );

					// If tabs element and this tab is active, make another tab active.
					if ( $existing.hasClass( 'active' ) && 'fusion_tab' === this.model.get( 'element_type' ) ) {
						$sibling = $existing.siblings().first();
						if ( $sibling.length ) {
							$sibling.addClass( 'active in' );
							targetId = $sibling.attr( 'id' );
							$parentEl.find( '[href="#' + targetId + '"]' ).closest( '.fusion-builder-live-child-element' ).addClass( 'active' );
						}
					}

					$existing.remove();

				}

			},

			/**
			 * Sets the attributes of an element.
			 *
			 * @since 2.0.0
			 * @param {Object} element - The element we're updating.
			 * @param {Object} attributes - The attributes we're setting/updating.
			 * @return {void}
			 */
			setElementAttributes: function( element, attributes ) {
				var dataVar;
				if ( 'object' === typeof attributes && element.length ) {
					_.each( attributes, function( values, attribute ) {
						if ( 'class' === attribute ) {
							element.attr( 'class', values );
						} else if ( 'id' === attribute ) {
							element.attr( 'id', values );
						} else if ( 'style' === attribute ) {
							element.attr( 'style', values );
						} else if ( -1 !== attribute.indexOf( 'data' ) ) {
							dataVar = attribute.replace( 'data-', '' );
							if ( element.data( dataVar ) ) {
								element = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( element );
								element.data( dataVar, values );
							}
							attribute = attribute.replace( /_/g, '-' );
							element.attr( attribute, values );
						}
					} );
				}
			},

			/**
			 * Renders the content.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getTemplateAtts: function() {
				var templateAttributes = jQuery.extend( true, {}, this.model.attributes ),
					params = jQuery.extend( true, {}, this.model.get( 'params' ) ),
					values = {},
					extras = {},
					element = fusionAllElements[ this.model.get( 'element_type' ) ],
					parent  = this.model.get( 'parent' ),
					parentValues = {},
					parentModel,
					parentElementContent = '';

				// Use appropriate template.
				if ( 'undefined' !== typeof this.elementTemplate ) {

					// Get parent values.
					parentModel = FusionPageBuilderElements.find( function( model ) {
						return model.get( 'cid' ) == parent; // jshint ignore:line
					} );

					if ( parentModel && 'undefined' !== typeof fusionAllElements[ parentModel.get( 'element_type' ) ] ) {
						parentValues = jQuery.extend( true, {}, fusionAllElements[ parentModel.get( 'element_type' ) ].defaults, _.fusionCleanParameters( parentModel.get( 'params' ) ) );
					}

					// Get element values.
					if ( element && 'undefined' !== typeof element.defaults ) {

						// No need to inherit parent's element_content.
						if ( 'undefined' !== typeof parentValues.element_content ) {
							parentElementContent = parentValues.element_content;
							delete parentValues.element_content;
						}

						values = jQuery.extend( true, {}, element.defaults, parentValues, _.fusionCleanParameters( params ) );

						parentValues.element_content = parentElementContent;

						// Get element extras.
						if ( 'undefined' !== typeof element.extras ) {
							extras = jQuery.extend( true, {}, element.extras );
						}
					}

					templateAttributes.parentValues = parentValues;
					templateAttributes.values       = values;
					templateAttributes.extras       = extras;
					templateAttributes.thisModel    = this.model;
					templateAttributes.parentModel  = parentModel;

					templateAttributes = this.getDynamicAtts( templateAttributes );
					templateAttributes = this.filterTemplateAtts( templateAttributes );

					return templateAttributes;
				}
			},

			/**
			 * Renders the content.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			renderContent: function() {

				// Use appropriate template.
				if ( 'undefined' !== typeof this.elementTemplate ) {

					this.$el.find( '.fusion-builder-child-element-content' ).html( this.getTemplate() );
					return;
				}

				// Ajax here
				this.$el.find( '.fusion-builder-child-element-content' ).html( 'no template found' );
			},

			/**
			 * Removes an element.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the element removal.
			 * @return {void}
			 */
			removeElement: function( event, isAutomated ) {
				var parentCid   = this.model.get( 'parent' ),
					parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) ),
					parentModel = FusionPageBuilderElements.find( function( model ) {
						return model.get( 'cid' ) == parentCid; // jshint ignore: line
					} ),
					MultiGlobalArgs;

				if ( event ) {
					event.preventDefault();

					parentView.$el.find( '.fusion-builder-module-controls-container a' ).trigger( 'mouseleave' );
				}

				// Hook to allow custom actions.
				this.beforeRemove();

				// Remove extra content not within view.
				this.removeExtraContents();

				// Remove element view
				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				// Remove live editors.
				FusionPageBuilderApp.inlineEditorHelpers.removeLiveEditors( this );

				// Destroy element model
				this.model.destroy();

				FusionEvents.trigger( 'fusion-element-removed', this.model.get( 'cid' ) );

				this.remove();

				// If element is removed manually
				if ( event ) {
					this.forceUpdateParent();
					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.deleted + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );
				}

				if ( parentModel.children.length && 'undefined' === typeof isAutomated ) {

					// Handle multiple global elements.
					MultiGlobalArgs = {
						currentModel: parentModel.children.models[ 0 ],
						handleType: 'save',
						attributes: parentModel.children.models[ 0 ].attributes
					};
					fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );
				}

				if ( event ) {
					parentView.childViewCloned();
				}
			},

			/**
			 * Force-updates the parent element.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			forceUpdateParent: function() {

				// Used to make sure parent of child is updated on live edit.
				var parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
				if ( 'undefined' !== typeof parentView ) {
					parentView.updateElementContent();
					parentView.refreshJs();
				}

				this.ajaxUpdateParent( parentView );
			},

			ajaxUpdateParent: function( parentView ) {
				parentView = 'undefined' === typeof parentView ? FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) ) : parentView;

				// If no template, use ajax to re-render.
				if ( parentView.model.get( 'noTemplate' ) ) {
					parentView.noTemplateAjaxUpdate();
				}
			},

			/**
			 * Clones an element.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the element cloning.
			 * @return {void}
			 */
			cloneElement: function( event ) {
				var elementAttributes,
					parentModel,
					currentModel,
					MultiGlobalArgs,
					parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) ),
					self       = this;

				// Get element parent
				parentModel = this.collection.find( function( model ) {
					return model.get( 'cid' ) == self.model.get( 'parent' ); // jshint ignore: line
				} );

				if ( event ) {
					event.preventDefault();
				}

				if ( true === this.elementIsCloning ) {
					return;
				}

				this.elementIsCloning = true;

				elementAttributes = jQuery.extend( true, {}, this.model.attributes );
				elementAttributes.created = 'manually';
				elementAttributes.cid = FusionPageBuilderViewManager.generateCid();
				elementAttributes.targetElement = this.$el;
				elementAttributes.at_index = FusionPageBuilderApp.getCollectionIndex( this.$el );

				// Add a clone flag for fusion gallery child.
				if ( 'fusion_gallery_image' === this.model.get( 'element_type' ) ) {
					elementAttributes.cloned = true;
				}

				if ( 'undefined' !== elementAttributes.from ) {
					delete elementAttributes.from;
				}

				FusionPageBuilderApp.addToChildCollection( elementAttributes );

				currentModel = parentModel.children.find( function( model ) {
					return model.get( 'cid' ) == elementAttributes.cid; // jshint ignore:line
				} );

				// Save history state
				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.cloned + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );

				// Handle multiple global elements.
				MultiGlobalArgs = {
					currentModel: currentModel,
					handleType: 'save',
					attributes: currentModel.attributes
				};
				fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

				this.elementIsCloning = false;

				this.forceUpdateParent();

				if ( event ) {
					FusionEvents.trigger( 'fusion-content-changed' );
				}

				parentView.childViewCloned();
			},

			/**
			 * Get the content.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getContent: function() {
				return FusionPageBuilderApp.generateElementShortcode( this.$el, false );
			},

			isFirstChild: function() {
				var self = this,
					index,
					parentModel;

				parentModel = FusionPageBuilderApp.collection.find( function( model ) {
					return model.get( 'cid' ) === self.model.get( 'parent' );
				} );

				index = parentModel.children.indexOf( this.model );

				return 0 === index;
			}
		} );
	} );
}( jQuery ) );
;/* global FusionApp, FusionPageBuilderApp, fusionBuilderText, FusionPageBuilderViewManager, FusionEvents, FusionPageBuilderElements, fusionAllElements, fusionSanitize */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Row View
		FusionPageBuilder.RowView = FusionPageBuilder.BaseRowView.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-row-template' ).html() ),
			className: 'fusion_builder_row',
			events: {
				'click .fusion-builder-insert-column': 'displayColumnsOptions'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {

				this.baseRowInit();
				this.nestedRow = false;

				this.model.set( 'rows', {} );
				this.model.children = new FusionPageBuilder.Collection();
				this.listenTo( this.model.children, 'add', this.addChildView );
				this.listenTo( FusionEvents, 'fusion-builder-loaded', this.updateColumnsPreview );
				this.listenTo( FusionEvents, 'fusion-wireframe-toggle', this.wireFrameToggled );
				this.listenTo( FusionEvents, 'fusion-builder-loaded', this.legacyColumns );
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function( forced ) {
				var self = this;

				forced = 'undefined' === typeof forced ? false : forced;

				this.$el.html( this.template( this.getTemplateAtts() ) );

				this.appendChildren();

				setTimeout( function() {
					self.droppableColumn();
				}, 100 );

				// Show column dialog when adding a new row
				if ( 'manually' !== this.model.get( 'created' ) && ! forced ) {
					this.displayContainerLibrary();
				}

				return this;
			},

			/**
			 * The row attributes.
			 *
			 * @since 3.0
			 * @return {Object}
			 */
			attr: function() {
				var attr 			= {
					style: ''
				},
				parentContainer = FusionPageBuilderApp.getParentContainer( this ),
				isFlex			= parentContainer && parentContainer.isFlex(),
				containerParams,
				width,
				widthValue,
				columnSpacingUnit,
				columnSpacingValue,
				widthUnit;

				if ( ! parentContainer ) {
					return attr;
				}

				containerParams = jQuery.extend( true, {}, fusionAllElements.fusion_builder_container.defaults, _.fusionCleanParameters( parentContainer.model.attributes.params ) ),

				attr[ 'class' ] 	= 'fusion-builder-row-container fusion-builder-row fusion-row';
				attr[ 'data-cid' ] 	= this.model.get( 'cid' );


				if ( isFlex ) {
					attr[ 'class' ]  += ' fusion-flex-align-items-' + containerParams.flex_align_items;
					if ( 'stretch' !== containerParams.align_content ) {
						attr[ 'class' ] += ' fusion-flex-align-content-' + containerParams.align_content;
					}
					if ( 'flex-start' !== containerParams.flex_justify_content ) {
						attr[ 'class' ] += ' fusion-flex-justify-content-' + containerParams.flex_justify_content;
					}
					width             = 'yes' === containerParams.hundred_percent ? '100%' :  fusionAllElements.fusion_builder_row.extras.site_width;
					columnSpacingUnit = fusionSanitize.get_unit( containerParams.flex_column_spacing );

					if ( '%' === columnSpacingUnit ) {
						columnSpacingValue = fusionSanitize.number( containerParams.flex_column_spacing );
						widthValue         = fusionSanitize.number( width );
						widthUnit          = fusionSanitize.get_unit( width );

						width = ( widthValue * ( 1 + ( columnSpacingValue / 100 ) ) ) + widthUnit;
					} else {
						width = 'calc( ' + width + ' + ' + containerParams.flex_column_spacing + ' )';
					}

					if ( 'no' === containerParams.hundred_percent ) {
						attr.style += 'max-width:' + width + ';';
					}
					attr.style += 'margin-left: calc(-' + containerParams.flex_column_spacing + ' / 2 );';
					attr.style += 'margin-right: calc(-' + containerParams.flex_column_spacing + ' / 2 );';
				}

				return attr;
			},

			/**
			 * Get template attributes.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getTemplateAtts: function()  {
				var templateAttributes 	= {
						attr: this.attr()
					};

				return templateAttributes;
			},

			/**
			 * Display the column options.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			displayColumnsOptions: function( event ) {

				var viewSettings,
					view;

				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.parentRowId = this.model.get( 'cid' );

				viewSettings = {
					model: this.model,
					collection: this.collection
				};

				if ( jQuery( event.currentTarget ).closest( '.fusion-builder-column' ).length && ! FusionPageBuilderApp.wireframeActive ) {
					viewSettings.targetElement = jQuery( event.currentTarget ).closest( '.fusion-builder-column' );
				}

				view = new FusionPageBuilder.ColumnLibraryView( viewSettings );

				jQuery( view.render().el ).dialog( {
					title: 'Select Column',
					width: FusionApp.dialog.dialogWidth,
					height: FusionApp.dialog.dialogHeight,
					draggable: false,
					modal: true,
					resizable: false,
					dialogClass: 'fusion-builder-dialog fusion-builder-large-library-dialog fusion-builder-columns-library-dialog',

					open: function() {
						FusionApp.dialog.resizeDialog();
					},

					close: function() {
						view.remove();
					}
				} );
			},

			/**
			 * Display the container library.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			displayContainerLibrary: function( event ) {

				var viewSettings,
					view,
					parentView;

				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.parentRowId = this.model.get( 'cid' );
				parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );

				viewSettings = {
					model: this.model,
					collection: this.collection
				};

				view = new FusionPageBuilder.ContainerLibraryView( viewSettings );

				jQuery( view.render().el ).dialog( {
					title: 'Select Container',
					width: FusionApp.dialog.dialogWidth,
					height: FusionApp.dialog.dialogHeight,
					draggable: false,
					modal: true,
					resizable: false,
					dialogClass: 'fusion-builder-dialog fusion-builder-large-library-dialog fusion-builder-container-library-dialog',
					open: function() {
						FusionApp.dialog.resizeDialog();
					},
					close: function() {
						parentView.removeContainer();
						view.remove();
					}
				} );
			},

			/**
			 * Removes a row.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			removeRow: function( event ) { // jshint ignore: line

				var columns;

				if ( event ) {
					event.preventDefault();
				}

				columns = FusionPageBuilderViewManager.getChildViews( this.model.get( 'cid' ) );

				// Remove all columns
				_.each( columns, function( column ) {
					column.removeColumn();
				} );

				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				this.model.destroy();

				this.remove();

				this.setRowData();

				if ( event ) {
					FusionEvents.trigger( 'fusion-content-changed' );
				}
			},

			/**
			 * Creates drop zone for empty row.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			droppableColumn: function() {
				var $el  = this.$el,
					self = this;

				if ( ! $el ) {
					return;
				}

				$el.find( '.fusion-builder-empty-container .fusion-column-target' ).droppable( {
					tolerance: 'touch',
					hoverClass: 'ui-droppable-active',
					accept: '.fusion-builder-column',
					drop: function( event, ui ) {
						var columnCid      = ui.draggable.data( 'cid' ),
							columnView     = FusionPageBuilderViewManager.getView( columnCid ),
							originalCid    = columnView.model.get( 'parent' ),
							originalView,
							newIndex;

						// Move the actual html.
						$el.find( '.fusion-builder-empty-container' ).after( ui.draggable );

						newIndex = ui.draggable.parent().children( '.fusion-builder-column' ).index( ui.draggable );

						FusionPageBuilderApp.onDropCollectionUpdate( columnView.model, newIndex, self.model.get( 'cid' ) );

						// Update destination row which is this current one.
						self.setRowData();

						// If destination row and original row are different, update original as well.
						if ( self.model.get( 'cid' ) !== originalCid ) {
							originalView = FusionPageBuilderViewManager.getView( originalCid );
							originalView.setRowData();
						}

						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.column + ' order changed' );

						setTimeout( function() {
							// If different container type we re-render so that it corrects for new situation.
							if ( 'object' !== typeof originalView || FusionPageBuilderApp.sameContainerTypes( originalView.get( 'parent' ), self.model.get( 'parent' ) ) ) {
								columnView.droppableColumn();
							} else {
								FusionEvents.trigger( 'fusion-close-settings-' + columnView.model.get( 'cid' ) );
								columnView.reRender();
							}
						}, 300 );
					}
				} );
			},

			/**
			 * Appends children. Calls the delegateEvents function in the view.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			appendChildren: function() {

				var self = this,
					cid,
					view;

				this.model.children.each( function( child ) {

					cid  = child.attributes.cid;
					view = FusionPageBuilderViewManager.getView( cid );

					self.$el.find( '.fusion-builder-row-container' ).append( view.$el );

					view.delegateEvents();
				} );
			},

			/**
			 * Adds a child view.
			 *
			 * @since 2.0.0
			 * @param {Object} element - The element model.
			 * @return {void}
			 */
			addChildView: function( element ) {

				var view,
					viewSettings = {
						model: element,
						collection: FusionPageBuilderElements,
						attributes: {
							'data-cid': element.get( 'cid' )
						}
					};

				viewSettings.className = 'fusion-builder-column fusion-builder-column-outer';

				if ( 'string' === typeof element.attributes.params.type && element.attributes.params.type.includes( '_' ) ) {
					viewSettings.className += ' fusion-builder-column-' + element.attributes.params.type;
				}
				view = new FusionPageBuilder.ColumnView( viewSettings );

				// Calculate virtual rows
				this.createVirtualRows();

				// This column was cloned
				if ( ! _.isUndefined( element.get( 'cloned' ) ) && true === element.get( 'cloned' ) ) {
					element.targetElement = view.$el;
					element.unset( 'cloned' );
				}

				FusionPageBuilderViewManager.addView( element.get( 'cid' ), view );

				if ( ! _.isUndefined( element.get( 'targetElement' ) ) && 'undefined' === typeof element.get( 'from' ) ) {
					if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'after' === element.get( 'targetElementPosition' ) ) {
						element.get( 'targetElement' ).after( view.render().el );
					} else {
						element.get( 'targetElement' ).before( view.render().el );
					}
				} else {
					if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'end' === element.get( 'targetElementPosition' ) ) {
						this.$el.find( '.fusion-builder-row-container' ).append( view.render().el );
					} else {
						this.$el.find( '.fusion-builder-row-container' ).prepend( view.render().el );
					}
					element.unset( 'from' );
				}

				this.updateColumnsPreview();
			},

			/**
			 * Delegates child events.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			delegateChildEvents: function() {

				var cid,
					view;

				this.model.children.each( function( child ) {

					cid  = child.attributes.cid;
					view = FusionPageBuilderViewManager.getView( cid );

					view.delegateEvents();
					view.delegateChildEvents();
					view.droppableColumn();
				} );
			},

			/**
			 * Fired when wireframe mode is toggled.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			wireFrameToggled: function() {
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.enableSortableColumns();
				} else {
					this.disableSortableColumns();
				}
			},

			recalculateMargins: function() {
				var attr = this.attr();

				this.$el.find( '.fusion-builder-row-container' ).first().attr( 'style', attr.style );
			},

			/**
			 * Destroy or disable column sortable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			disableSortableColumns: function() {
				var rowContainer = this.$el.find( '.fusion-builder-row-container' );

				if ( 'undefined' !== typeof rowContainer.sortable( 'instance' ) ) {
					rowContainer.enableSelection();
					rowContainer.sortable( 'disable' );
				}
			},

			/**
			 * Initialize column sortable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			sortableColumns: function() {
				var rowContainer = this.$el.find( '.fusion-builder-row-container' ),
					items = '.fusion-builder-column-outer',
					self = this;

				rowContainer.sortable( {
					cancel: '.fusion-builder-column-settings, .fusion-builder-column-size, .fusion-builder-column-clone, .fusion-builder-column-save, .fusion-builder-column-remove, .fusion-builder-add-element, .column-sizes',
					items: items,
					connectWith: '.fusion-builder-row-container',
					tolerance: 'pointer',
					appendTo: rowContainer.parent(),
					helper: 'clone',

					update: function( event, ui ) {
						self.onSortUpdate( event, ui );
					},

					stop: function( event, ui ) {
						self.onSortStop( event, ui, items );
					}

				} ).disableSelection();
			}

		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderApp */

var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Dynamic Selection.
		FusionPageBuilder.DynamicSelection = window.wp.Backbone.View.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-dynamic-selection' ).html() ),

			className: 'fusion-builder-dynamic-selection option-field',

			events: {
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.1
			 * @return {Object} this
			 */
			render: function() {
				var $option = this.model.get( 'option' ),
					templateData;

				if ( $option.length ) {
					$option.attr( 'data-dynamic-selection', true );
				}

				templateData = {
					params: FusionPageBuilderApp.dynamicValues.getOrderedParams(),
					option: $option.attr( 'data-option-type' )
				};

				this.$el.html( this.template( templateData ) );

				this.initSelect();

				return this;
			},

			initSelect: function() {
				var self               = this,
					parent             = this.model.get( 'parent' ),
					$option            = this.model.get( 'option' ),
					param              = this.model.get( 'param' ),
					$selectField       = this.$el.find( '.fusion-select-field' ),
					$selectPreview     = $selectField.find( '.fusion-select-preview-wrap' ),
					$selectSearchInput = $selectField.find( '.fusion-select-search input' );

				if ( $selectField.hasClass( 'fusion-select-inited' ) ) {
					return;
				}

				$selectField.addClass( 'fusion-select-inited' );

				// Hide empty option groups.
				$selectField.find( '.fusion-select-optiongroup' ).each( function() {
					if ( jQuery( this ).next().hasClass( 'fusion-select-optiongroup' ) || 0 === jQuery( this ).next().length ) {
						jQuery( this ).remove();
					}
				} );

				// Open select dropdown.
				$selectPreview.on( 'click', function( event ) {
					var open = $selectField.hasClass( 'fusion-open' );

					event.preventDefault();

					if ( ! open ) {
						$selectField.addClass( 'fusion-open' );
						if ( $selectSearchInput.length ) {
							$selectSearchInput.focus();
						}
					} else {
						$selectField.removeClass( 'fusion-open' );
						if ( $selectSearchInput.length ) {
							$selectSearchInput.val( '' ).blur();
						}
						$selectField.find( '.fusion-select-label' ).css( 'display', 'block' );
					}
				} );

				// Option is selected.
				$selectField.on( 'click', '.fusion-select-label', function() {
					parent.elementView.dynamicParams.addParam( param, jQuery( this ).data( 'value' ) );
					parent.initEditDynamic( $option.find( '.fusion-dynamic-content' ), true );
					self.removeView();
				} );

				$selectSearchInput.on( 'keyup change paste', function() {
					var val          = jQuery( this ).val(),
						optionInputs = $selectField.find( '.fusion-select-label' );

					// Select option on "Enter" press if only 1 option is visible.
					if ( 'keyup' === event.type && 13 === event.keyCode && 1 === $selectField.find( '.fusion-select-label:visible' ).length ) {
						$selectField.find( '.fusion-select-label:visible' ).trigger( 'click' );
						return;
					}

					_.each( optionInputs, function( optionInput ) {
						if ( -1 === jQuery( optionInput ).html().toLowerCase().indexOf( val.toLowerCase() ) ) {
							jQuery( optionInput ).css( 'display', 'none' );
						} else {
							jQuery( optionInput ).css( 'display', 'block' );
						}
					} );
				} );
			},

			removeView: function() {
				var $option = this.model.get( 'option' ),
					parent  = this.model.get( 'parent' );

				this.$el.remove();

				if ( parent ) {
					parent.dynamicSelection = false;
				}
				if ( $option.length ) {
					$option.attr( 'data-dynamic-selection', false );
				}

				// Destroy element model
				this.model.destroy();

				this.remove();
			}

		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderApp, FusionApp */

var FusionPageBuilder = FusionPageBuilder || {};

FusionPageBuilder.options = FusionPageBuilder.options || {};

FusionPageBuilder.options.fusionDynamicData = {
	optionDynamicData: function( $element ) {
		var self = this;

		$element  = $element || this.$el;

		$element.find( '[data-dynamic="true"] .fusion-dynamic-content' ).each( function() {
			self.initEditDynamic( jQuery( this ) );
		} );
	},

	initEditDynamic: function( $targetEl, open ) {

		var dynamicData = this.elementView.dynamicParams.getAll(),
			self        = this,
			repeater    = FusionPageBuilder.template( jQuery( '#fusion-app-repeater-fields' ).html() ),
			param       = $targetEl.closest( '.fusion-builder-option' ).attr( 'data-option-id' ),
			options     = FusionPageBuilderApp.dynamicValues.getOptions(),
			values      = 'object' === typeof dynamicData && 'object' === typeof dynamicData[ param ] ? dynamicData[ param ] : { data: undefined },
			dynamic     = values && 'object' === typeof options[ values.data ] ? options[ values.data ] : false,
			fields      = dynamic ? dynamic.fields : false,
			label       = dynamic && 'string' === typeof dynamic.label ? dynamic.label : values.data,
			$html       = '',
			$fields     = $targetEl.find( '.dynamic-param-fields' ),
			supported   = jQuery.extend( true, {}, FusionApp.data.dynamicCommon ),
			excludes    = 'object' === typeof dynamic.exclude ? _.values( dynamic.exclude ) : false,
			ajax        = dynamic && 'object' === typeof dynamic.callback && 'undefined' !== typeof dynamic.callback.ajax ? dynamic.callback.ajax : false;

		if ( 'object' !== typeof dynamicData[ param ] ) {
			return;
		}

		if ( excludes && 'object' === typeof supported ) {
			_.each( supported, function( supportField, supportId ) {
				if ( -1 !== _.indexOf( excludes, supportId ) ) {
					delete supported[ supportId ];
				}
			} );
		}

		if ( 'object' === typeof supported && ! _.isEmpty( supported ) ) {
			if ( 'object' === typeof fields ) {
				fields = _.extend( fields, supported );
			} else {
				fields = supported;
			}
		}

		// Update the editable fields.
		$fields.empty();
		if ( fields ) {
			_.each( fields, function( field, id ) {
				var value    = values[ id ],
					attributes = {
						field: field,
						value: value
					};

				$html += jQuery( repeater( attributes ) ).html();
			} );

			$fields.append( $html );
		}

		// Update the title, id and ajax attribute.
		if ( dynamic ) {
			$targetEl.find( '.dynamic-title h3' ).text( label );
			$targetEl.find( '.dynamic-wrapper' ).attr( 'data-id', values.data ).attr( 'data-ajax', ajax );
		}

		// Prevent duplicate listeners.
		$targetEl.off( 'click' );

		// Listener for open and close toggle.
		$targetEl.on( 'click', '.dynamic-title', function() {
			jQuery( this ).parent().find( '.dynamic-param-fields' ).slideToggle( 300 );

			if ( jQuery( this ).find( '.dynamic-toggle-icon' ).hasClass( 'fusiona-pen' ) ) {
				jQuery( this ).find( '.dynamic-toggle-icon' ).removeClass( 'fusiona-pen' ).addClass( 'fusiona-minus' );
			} else {
				jQuery( this ).find( '.dynamic-toggle-icon' ).removeClass( 'fusiona-minus' ).addClass( 'fusiona-pen' );
			}
		} );

		// Listener for removing the dynamic data.
		$targetEl.on( 'click', '.dynamic-remove.fusiona-trash-o', function( event ) {
			event.preventDefault();
			self.removeDynamicData( $targetEl );
		} );

		// Init the editable sub options.
		if ( 'function' === typeof this.initOptions ) {
			this.initOptions( $targetEl );
		}

		// If its a newly added one, lets open it.
		if ( 'undefined' !== typeof open && open ) {
			$targetEl.find( '.dynamic-param-fields' ).show();
			$targetEl.find( '.dynamic-toggle-icon' ).removeClass( 'fusiona-pen' ).addClass( 'fusiona-minus' );
		}
	},

	removeDynamicData: function( $targetEl ) {
		var param = $targetEl.closest( '.fusion-builder-option' ).attr( 'data-option-id' );

		if ( 'undefined' !== typeof this.elementView ) {
			this.elementView.dynamicParams.removeParam( param );
		}
	},

	/**
	 * Sets dynamic data param value.
	 *
	 * @since 2.0.0
	 * @param {Object} $option - jQuery object.
	 * @param {String} param - Parameter ID.
	 * @param {Mixed} value - Value of this option.
	 * @return {void}
	 */
	setDynamicParamValue: function( $option, subParam, value ) {
		var param    = $option.parent().closest( '.fusion-builder-option' ).attr( 'data-option-id' );

		if ( 'undefined' !== typeof this.elementView ) {
			this.elementView.dynamicParams.updateParam( param, subParam, value );
		}
	}
};
;/* global FusionApp, FusionPageBuilderViewManager, FusionEvents, fusionAllElements, FusionPageBuilderApp, fusionBuilderText, fusionGlobalManager, fusionBuilderInsertIntoEditor, openShortcodeGenerator */
/* eslint no-unused-vars: 0 */
/* eslint no-alert: 0 */
/* eslint no-empty-function: 0 */
/* eslint no-shadow: 0 */

var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	FusionPageBuilder.ElementSettingsView = window.wp.Backbone.View.extend( {

		className: 'fusion_builder_module_settings',
		template: FusionPageBuilder.template( jQuery( '#fusion-builder-block-module-settings-template' ).html() ),
		optionHasChanged: false,

		events: {

			'click [id$="fusion_shortcodes_text_mode"]': 'activateSCgenerator',
			'change input': 'optionChange',
			'keyup input:not(.fusion-slider-input)': 'optionChange',
			'change select': 'optionChange',
			'keyup textarea': 'optionChange',
			'change textarea': 'optionChange',
			'paste textarea': 'optionChangePaste',
			'fusion-change input': 'optionChange',
			'click .upload-image-remove': 'removeImage',
			'click .option-preview-toggle': 'previewToggle',
			'click .insert-slider-video': 'addSliderVideo',
			'click .fusion-panel-shortcut:not(.dialog-more-menu-item)': 'defaultPreview',
			'click .fusion-panel-description': 'showHideDescription',
			'click #fusion-close-element-settings': 'saveSettings',
			'click .fusion-builder-go-back': 'openParent',
			'click .option-dynamic-content': 'addDynamicContent',
			'click .option-has-responsive': 'showResponsiveOptions',
			'click .fusion-responsive-options li a': 'changeResponsiveOption',
			'mouseleave .fusion-builder-option': 'hideResponsiveOptions'
		},

		/**
		 * Init.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		initialize: function() {

			// Manupulate model attributes via custom function if provided by the element
			this.onSettingsCallback();

			// Store element view
			this.elementView = FusionPageBuilderViewManager.getView( this.model.get( 'cid' ) );

			this.loadComplete     = false;
			this.codeEditorOption = false;
			this.changesPaused    = false;

			// JQuery trigger.
			this._refreshJs = _.debounce( _.bind( this.refreshJs, this ), 300 );

			// Fetch query_data if not present only. dont save
			if ( 'undefined' !== typeof fusionAllElements[ this.model.get( 'element_type' ) ].has_ajax ) {
				if ( 'undefined' === typeof this.model.get( 'query_data' ) ) {
					this.elementView.triggerAjaxCallbacks( true );
				}
			}

			// When tab is changed we init options.
			this.tabsRendered = {};
			this.initOptions = _.debounce( _.bind( this.debouncedInitOptions, this ), 50 );
			this.listenTo( FusionEvents, 'fusion-tab-changed', this.initOptions );
			this.listenTo( FusionEvents, 'fusion-inline-edited', this.forceChange );

			this.childSortableView = false;

			// Active states selected for element.
			this.activeStates     = {};
			this.$targetEl        = 'undefined' !== typeof this.elementView ? this.elementView.$el : false;
			this._tempStateRemove = _.debounce( _.bind( this.tempStateRemove, this ), 3000 );

			this.parentValues     = this.getParentValues() ? this.getParentValues() : false;

			this.$el.attr( 'data-cid', this.model.get( 'cid' ) );

			this.$el.addClass( this.containerIsFlex() ? 'has-flex' : '' );
			this.$el.addClass( this.columIsBlockLayout() ? 'has-block-column' : '' );

			this.type = 'EO';

			this.onInit();

			this.listenTo( FusionEvents, 'fusion-element-removed', this.removeView );
			this.listenTo( FusionEvents, 'fusion-preview-refreshed', this.saveSettings );
			this.listenTo( FusionEvents, 'fusion-close-settings-' + this.model.get( 'cid' ), this.saveSettings );
			this.listenTo( FusionEvents, 'fusion-param-changed-' + this.model.get( 'cid' ), this.paramChanged );
			this.listenTo( FusionEvents, 'fusion-default-changed-' + this.model.get( 'cid' ), this.defaultChanged );
			this.listenTo( FusionEvents, 'fusion-row-nested-edit', this.saveSettings );

			if ( 'dialog' !== FusionApp.preferencesData.editing_mode && 'generated_element' !== this.model.get( 'type' ) && ! this.$el.hasClass( 'fusion-builder-settings-chart-table-dialog' ) ) {
				this.$el.addClass( 'fusion-builder-custom-tab' );
			}

			if ( 'generated_element' === this.model.get( 'type' ) ) {
				FusionEvents.trigger( 'fusion-history-pause-tracking' );
			}

			this.newElement = false;
			if ( 'undefined' !== typeof this.model.get( 'added' ) ) {
				this.newElement = true;
			}

			// Dynamic content.
			this.listenTo( FusionEvents, 'fusion-dynamic-data-removed', this.removeDynamicStatus );
			this.listenTo( FusionEvents, 'fusion-dynamic-data-added', this.addDynamicStatus );
			this.dynamicSelection = false;

			this.debouncedOptionChanges = {};
		},

		/**
		 * Renders the view.
		 *
		 * @since 2.0.0
		 * @return {Object} this
		 */
		render: function() {

			this.renderOptions();

			this.initOptions();

			this.model.unset( 'added' );

			// Check option dependencies
			this.dependencies = new FusionPageBuilder.Dependencies( fusionAllElements[ this.model.get( 'element_type' ) ].params, this );

			FusionApp.dialog.dialogTabs( this.$el );

			this.loadComplete = true;

			if ( 'undefined' !== this.model.get( 'multi' ) && 'multi_element_parent' === this.model.get( 'multi' ) ) {
				this.appendChildSortables();
			}

			FusionEvents.trigger( 'fusion-settings-modal-open' );

			if (  -1 !== this.model.get( 'element_type' ).indexOf( 'fusion_builder_column' ) ) {
				this.setDirectionAttribute();
			}

			this.onRender();

			this.checkPageTemplate();

			this.inlineHistoryListener();

			return this;

		},

		setDirectionAttribute: function() {
			var $option = this.$el.find( '[data-option-id="content_layout"]' ),
				value   = 'column';

			if ( ! $option.length ) {
				return;
			}

			value = $option.find( '#content_layout' ).val();
			$option.attr( 'data-direction', value );
		},

		containerIsFlex: function() {
			var container = FusionPageBuilderApp.getParentContainer( this.model.get( 'cid' ) );
			return container && container.isFlex();
		},

		columIsBlockLayout: function() {
			var column = FusionPageBuilderApp.getParentColumn( this.model.get( 'cid' ) );

			return column && column.isBlockLayout() && 'fusion_builder_column' !== this.model.get( 'element_type' ) && 'fusion_builder_column_inner' !== this.model.get( 'element_type' );
		},

		addDynamicContent: function( event ) {
			var self         = this,
				$option      = jQuery( event.target ).closest( '.fusion-builder-option' ),
				param        = $option.attr( 'data-option-id' ),
				sameParam    = false,
				viewSettings;

			if ( this.dynamicSelection ) {
				if ( param === this.dynamicSelection.model.get( 'param' ) ) {
					sameParam = true;
				}
				this.dynamicSelection.removeView();
			}

			if ( sameParam ) {
				return;
			}

			viewSettings = {
				model: new FusionPageBuilder.Element( {
					param: param,
					option: $option,
					parent: this
				} )
			};

			// On select or cancel or event we destroy.
			this.dynamicSelection = new FusionPageBuilder.DynamicSelection( viewSettings );
			$option.find( '.fusion-dynamic-selection' ).html( this.dynamicSelection.render().el );
		},

		removeDynamicStatus: function( param ) {
			this.$el.find( '.fusion-builder-option[data-option-id="' + param + '"]' ).attr( 'data-dynamic', false );

			// Needed for dependencies.
			this.$el.find( '#' + param ).trigger( 'fusion-change' );
		},

		addDynamicStatus: function( param ) {
			this.$el.find( '.fusion-builder-option[data-option-id="' + param + '"]' ).attr( 'data-dynamic', true );

			// Needed for dependencies.
			this.$el.find( '#' + param ).trigger( 'fusion-change' );
		},

		onRender: function() {
		},

		reRender: function() {
			var $parentDialog = this.$el.closest( '.ui-dialog' ),
				$dialogTopContainer;

			this.tabsRendered = {};
			this.destroyOptions();
			this.render();

			if ( $parentDialog.length ) {
				$parentDialog.find( '.ui-dialog-titlebar + .fusion-builder-modal-top-container' ).remove();
				$parentDialog.find( '.ui-dialog-titlebar' ).after( this.$el.find( '.fusion-builder-modal-top-container' ) );
			} else {
				FusionPageBuilderApp.SettingsHelpers.renderDialogMoreOptions( this );
			}
		},

		/**
		 * Listens for change in parent and destroys settings view since no longer valid.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		inlineHistoryListener: function() {
			var self = this,
				parentCid;

			if ( this.model.get( 'inlineElement' ) && 'undefined' !== typeof this.model.parentView ) {
				parentCid = this.model.parentView.model.get( 'cid' );

				// Timeout so addition of inline does not trigger.
				setTimeout( function() {
					self.listenTo( FusionEvents, 'fusion-param-changed-' + parentCid, function() {
						self.removeView( parentCid );
					} );
				}, 1000 );
			}
		},

		/**
		 * Simply sets optionHasChanged to true.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		forceChange: function() {
			this.optionHasChanged = true;
		},

		/**
		 * Append child sortables.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		appendChildSortables: function() {
			var viewSettings = {
					model: this.model,
					collection: this.collection,
					attributes: {
						settingsView: this
					}
				},
				view;

			view = new FusionPageBuilder.ElementSettingsParent( viewSettings );
			this.$el.find( '.fusion-child-sortables' ).html( view.render().el );
			this.childSortableView = view;
		},

		/**
		 * Execute Callbacks.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		onSettingsCallback: function() {
			var functionName,
				params,
				processedParams;

			if ( 'undefined' !== typeof fusionAllElements[ this.model.get( 'element_type' ) ].on_settings ) {

				functionName = fusionAllElements[ this.model.get( 'element_type' ) ].on_settings;

				if ( 'function' === typeof FusionPageBuilderApp[ functionName ] ) {
					params          = this.model.get( 'params' );
					processedParams = FusionPageBuilderApp[ functionName ]( params, this );

					this.model.set( 'params', processedParams );
				}
			}
		},

		/**
		 * Trigger optionChange when pasting.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		optionChangePaste: function( event ) {
			var self = this;

			setTimeout( function() {
				self.optionChange( event );
			}, 200 );
		},

		/**
		 * Debounce optionChanged if no template.
		 *
		 * @since 2.0.0
		 * @param {Object} event - The JS event.
		 * @return {void}
		 */
		optionChange: function( event ) {
			var $target          = jQuery( event.target ),
				$option          = $target.closest( '.fusion-builder-option' ),
				paramName        = this.getParamName( $target, $option ),
				$dynamicWrapper  = $option.closest( '.dynamic-wrapper' ),
				ajaxDynamicParam = false,
				debounceTimeout  = 'tinymce' === $option.data( 'option-type' ) ? 300 : 500;

			if ( this.changesPaused ) {
				return;
			}

			// Fix range with default value not triggering properly.
			if ( $target.is( '.fusion-slider-input.fusion-with-default' ) ) {
				return;
			}

			// Check if it is a dynamic param being changed which will result in an ajax request.
			if ( $dynamicWrapper.length && $dynamicWrapper.attr( 'data-ajax' ) && 'before' !== paramName && 'after' !== paramName && 'fallback' !== paramName ) {
				ajaxDynamicParam = $option.closest( '.dynamic-wrapper' ).attr( 'data-ajax' );
			}

			if ( ! jQuery( event.target ).hasClass( 'fusion-skip-debounce' ) && ( this.model.get( 'noTemplate' ) || jQuery( event.target ).hasClass( 'fusion-debounce-change' ) || ajaxDynamicParam || 'tinymce' === $option.data( 'option-type' ) ) ) {
				if ( ! this.debouncedOptionChanges[ paramName ] ) {
					this.debouncedOptionChanges[ paramName ] = _.debounce( _.bind( this.optionChanged, this ), debounceTimeout );
				}

				this.debouncedOptionChanges[ paramName ]( event );
			} else {
				this.optionChanged( event );
			}
		},

		/**
		 * Custom callback on option change.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		customOnChangeCallback: function() {
			var functionName;

			// Manupulate model attributes via custom function if provided by element
			if ( 'undefined' !== typeof fusionAllElements[ this.model.get( 'element_type' ) ].on_change ) {
				functionName = fusionAllElements[ this.model.get( 'element_type' ) ].on_change;
				if ( 'function' === typeof FusionApp.callback[ functionName ] ) {
					this.model.attributes = FusionApp.callback[ functionName ]( jQuery.extend( true, {}, this.model.attributes ), this );
				}
			}
		},

		/**
		 * Get real param name.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		getParamName: function( $target, $option ) {
			var paramName  = $option.data( 'option-id' );

			// Non single dimension fields or font family input.
			if ( $target.closest( '.fusion-builder-option' ).hasClass( 'font_family' ) || ( $target.closest( '.fusion-builder-option.dimension' ).length && ! $target.closest( '.single-builder-dimension' ).length ) ) {
				paramName = $target.attr( 'name' );
			}

			return paramName;
		},

		/**
		 * Get param value.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		getParamValue: function( $target ) {
			var paramValue = $target.val();

			// If code block element then need to use method to get val.
			if ( $target.closest( '.fusion-builder-option.code' ).length ) {
				paramValue = this.codeEditorOption[ $target.closest( '.fusion-builder-option.code' ).attr( 'data-index' ) ].getValue();

				// Base64 encode for Code option type.
				if ( 1 === Number( FusionApp.settings.disable_code_block_encoding ) ) {
					paramValue = FusionPageBuilderApp.base64Encode( paramValue );
				}
			}

			if ( $target.hasClass( 'fusion-builder-raw-textarea' ) ) {
				paramValue = FusionPageBuilderApp.base64Encode( paramValue );
			}

			if ( $target.closest( '.fusion-builder-option' ).hasClass( 'escape_html' ) ) {
				paramValue = _.escape( paramValue );
			}

			if ( $target.hasClass( 'fusion-multi-select-option' ) ) {
				paramValue = [];
				jQuery.each( $target.parent().find( '> .fusion-multi-select-option:checked' ), function( index, elem ) {
					paramValue.push( jQuery( elem ).val() );
				} );

				paramValue = paramValue.join( ',' );
			}

			return paramValue;
		},

		/**
		 * Whether or not option change is valid.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		shouldContinue: function( $target, paramName, paramValue, params ) {
			var tabId      = this.$el.find( '.fusion-tab-content.active' ).length ? this.$el.find( '.fusion-tab-content.active' ).attr( 'id' ) : false,
				rowIndex,
				pricing,
				callbackFunction;

			// Filter value being changed.
			if ( $target.closest( '.fusion-builder-option.subgroup' ).length ) {
				return false;
			}

			// Repeater value being changed.
			if ( $target.closest( '.fusion-builder-option.repeater' ).length && ! $target.hasClass( 'fusion-repeater-value' ) ) {
				rowIndex = $target.closest( '.repeater-row' ).index();
				this.setRepeaterValue( $target.closest( '.fusion-builder-option.repeater' ).find( '.fusion-repeater-value' ), paramName, rowIndex, paramValue );
				return false;
			}

			// Dynamic value being changed.
			if ( $target.closest( '.fusion-dynamic-content' ).length ) {
				this.setDynamicParamValue( $target.closest( '.fusion-builder-option' ), paramName, paramValue );
				return false;
			}

			if ( $target.hasClass( 'fusion-always-update' ) ) {
				return true;
			}

			if ( $target.hasClass( 'fusion-hide-from-atts' ) ) {
				return false;
			}

			// If its a tab and its not fully rendered yet.
			if ( tabId && ( 'undefined' === typeof this.tabsRendered[ tabId ] || true !== this.tabsRendered[ tabId ] ) ) {
				return false;
			}

			// Layout not complete.
			if ( false === this.loadComplete ) {
				return false;
			}

			if ( ! paramName ) {
				return false;
			}

			// If value hasnt changed.
			if ( paramValue === params[ paramName ] || ( '' === paramValue && 'undefined' === typeof params[ paramName ] ) ) {

				if ( 'fusion_pricing_column' !== this.model.get( 'element_type' ) ) {
					return false;
				}

				callbackFunction = FusionPageBuilderApp.getCallbackFunction( this.model.attributes, paramName, paramValue, this.elementView );

				if ( 'fusionPricingTablePrice' !== callbackFunction[ 'function' ] ) {
					return false;
				}

				pricing = this.model.get( 'priceParams' );

				if ( '' === paramValue && 'undefined' === typeof pricing[ paramName ] ) {
					return false;
				}
			}

			// If its a color picker with fusion using default set but the value its trying to use is not empty, then return.
			if ( $target.hasClass( 'fusion-using-default' ) && '' !== paramValue && 'undefined' !== typeof paramValue ) {
				return false;
			}

			return true;
		},

		/**
		 * Things to do, places to go when options change.
		 *
		 * @since 2.0.0
		 * @param {Object} event - The event triggering the option change.
		 * @return {void}
		 */
		optionChanged: function( event ) {

			var $target    = jQuery( event.target ),
				$option    = $target.closest( '.fusion-builder-option' ),
				reRender   = true,
				params     = this.model.get( 'params' ),
				modelData  = jQuery.extend( this.model.attributes, {} ),
				paramName,
				initialVal,
				MultiGlobalArgs,
				paramValue,
				parentView;

			this.customOnChangeCallback();

			paramName  = this.getParamName( $target, $option );
			paramValue = this.getParamValue( $target, paramName, paramValue, params );
			initialVal = 'undefined' === typeof params[ paramName ] ? '' : params[ paramName ];

			if ( ! this.shouldContinue( $target, paramName, paramValue, params ) ) {
				return;
			}

			this.optionHasChanged = true;

			if ( ! this.model.get( 'inlineElement' ) ) {
				if ( 'undefined' !== typeof this.elementView ) {
					reRender = this.elementView.updateParam( paramName, paramValue, event );
				}
			}

			if ( 'undefined' !== typeof this.elementView && 'function' === typeof this.elementView.onOptionChange ) {
				this.elementView.onOptionChange( paramName, paramValue, event );
			}

			// Trigger temporary active state if exists.
			this.triggerTemporaryState( $option );

			if ( 'generated_element' === this.model.get( 'type' ) ) {
				return;
			}

			// Update inline element which has no separate view.
			if ( this.model.get( 'inlineElement' ) ) {
				params[ paramName ] = paramValue;
				this.model.set( 'params', params );
				FusionPageBuilderApp.inlineEditorHelpers.processInlineElement( this.model, paramName );
			}

			// Re render view, right now that is auto done on model change.
			if ( reRender && 'undefined' !== typeof this.elementView && ! $target.hasClass( 'skip-update' ) ) {

				// Re-render if element should.
				if ( -1 === this.model.get( 'element_type' ).indexOf( 'fusion_builder_column' ) || ( 'spacing' !== paramName ) ) {
					this.elementView.reRender();
				}
			}

			// JS trigger for option specific refreshes.
			this._refreshJs( paramName );

			// Trigger active states.
			this.triggerActiveStates();

			// A setting of some kind has been changed.
			this.settingChanged = true;

			if ( this.childSortableView ) {
				this.childSortableView.render();
			}

			// Handle multiple global elements.
			MultiGlobalArgs = {
				currentModel: this.model,
				handleType: 'changeOption',
				Name: paramName,
				Value: paramValue
			};
			fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );
		},

		getParentValues: function() {
			var parentView;

			if ( 'multi_element_child' === this.model.get( 'multi' ) ) {
				parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
				if ( 'undefined' === parentView ) {
					return false;
				}
				return parentView.model.get( 'params' );
			}
			return false;
		},

		/**
		 * Triggers a refresh.
		 *
		 * @since 2.0.0
		 * @return void
		 */
		refreshJs: function( paramName ) {
			jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-option-change-' + paramName, this.model.attributes.cid );
		},

		/**
		 * Destroys the options.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		destroyOptions: function() {
			var self = this;

			// Close colorpickers before saving
			this.$el.find( '.wp-color-picker' ).each( function() {
				if ( jQuery( this ).closest( '.wp-picker-active' ).length ) {
					jQuery( this ).wpColorPicker( 'close' );
				}
			} );

			// Destroy each CodeMirror editor instance
			this.$el.find( '.fusion-builder-code-block' ).each( function( index ) {
				if ( self.codeEditorOption[ index ] ) {
					self.codeEditorOption[ index ].toTextArea();
				}
			} );

			// Remove each instance of tinyMCE editor from this view if it has been init.
			this.$el.find( '.fusion-editor-field' ).each( function() {
				var editorID = jQuery( this ).attr( 'id' );
				if ( jQuery( this ).hasClass( 'fusion-init' ) ) {
					self.fusionBuilderMCEremoveEditor( editorID );
				}
			} );

			this.onDestroyOptions();
		},

		/**
		 * Destroy options callback.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		onDestroyOptions: function() {

		},

		/**
		 * Activate shortcode generator.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		activateSCgenerator: function( event ) {
			openShortcodeGenerator( jQuery( event.target ) );
		},

		/**
		 * Init the view options.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		renderOptions: function() {
			var thisModel      = this.model,
				fixSettingsLvl = false,
				parentAtts,
				attributes = jQuery.extend( true, {}, this.model.attributes );

			// Fix for deprecated 'settings_lvl' attribute
			if ( 'undefined' !== thisModel.attributes.params.settings_lvl && 'parent' === thisModel.attributes.params.settings_lvl ) {
				fixSettingsLvl = true;
				parentAtts     = thisModel.attributes.params;
			}

			if ( 'object' === typeof this.elementView ) {
				attributes.dynamic_params = this.elementView.dynamicParams.getAll();
			}

			// Set correct type param based on TO setting in case 'old' container is edited.
			if ( 'fusion_builder_container' === this.model.get( 'element_type' ) && 'undefined' === typeof attributes.params.type ) {
				attributes.params.type = 1 === parseInt( fusionAllElements.fusion_builder_container.extras.container_legacy_support ) ? 'legacy' : 'flex';
			}

			// We don't allow 'legacy' containers in header layout sections.
			if ( 'fusion_builder_container' === this.model.get( 'element_type' ) && 'undefined' !== typeof FusionApp.data.template_category && 'header' === FusionApp.data.template_category ) {
				attributes.params.type = 'flex';
			}

			if ( 'function' === typeof this.filterAttributes ) {
				attributes = this.filterAttributes( attributes );
			}

			this.$el.html( this.template( { atts: attributes } ) );
		},

		/**
		 * Init the view options.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		debouncedInitOptions: function( $element ) {
			var tabId   = this.$el.find( '.fusion-tab-content.active' ).length ? this.$el.find( '.fusion-tab-content.active' ).attr( 'id' ) : false,
				$baseEl = tabId ? this.$el.find( '.fusion-tab-content.active' ) : this.$el,
				$thisEl = 'undefined' !== typeof $element && $element.length ? $element : $baseEl,
				self    = this;

			// Check if tab has already been init.
			if ( 'undefined' === typeof $element && ( ( tabId && true === this.tabsRendered ) || ( 'undefined' !== typeof this.tabsRendered[ tabId ] && this.tabsRendered[ tabId ] ) || true === this.tabsRendered ) ) {
				return;
			}

			this.optionDynamicData( $thisEl );
			this.textFieldPlaceholder( $thisEl );
			this.optionDateTimePicker( $thisEl );
			this.optionColorpicker( $thisEl );
			this.optionColumnWidth( $thisEl );
			this.optionFormOptions( $thisEl );
			this.optionIconpicker( $thisEl );
			this.optionCodeBlock( $thisEl );
			this.optionDimension( $thisEl );
			this.optionSelect( $thisEl );
			this.optionMultiSelect( $thisEl );
			this.optionUpload( $thisEl );
			this.optionMultiUpload( $thisEl );
			this.optionEditor( $thisEl );
			this.optionCheckboxButtonSet( $thisEl );
			this.optionRadioButtonSet( $thisEl );
			this.optionLinkSelector( $thisEl );
			this.optionRange( $thisEl );
			this.optionSortable( $thisEl );
			this.optionSortableText( $thisEl );
			this.optionConnectedSortable( $thisEl );
			this.optionFontFamily( $thisEl );

			// TODO: fix for WooCommerce element.
			if ( 'fusion_woo_shortcodes' === this.model.get( 'element_type' ) ) {
				if ( true === FusionPageBuilderApp.shortcodeGenerator ) {
					$thisEl.find( '#element_content' ).attr( 'id', 'generator_element_content' );
				}
			}

			// Attachment upload alert.
			$thisEl.find( '.uploadattachment .fusion-builder-upload-button' ).on( 'click', function() {
				alert( fusionBuilderText.to_add_images ); // jshint ignore: line
			} );

			// Fusion Form label update.
			if ( this.model.get( 'element_type' ).includes( 'fusion_form_' ) ) {
				setTimeout( function() {
					var elem = $thisEl.find( 'input[name="label"]' )[ 0 ],
						elemLen,
						oSel;

					if ( elem ) {
						elemLen = elem.value.length;
						// For IE Only
						if ( document.selection ) {
							// Set focus
							elem.focus();
							// Use IE Ranges
							oSel = document.selection.createRange();
							// Reset position to 0 & then set at end
							oSel.moveStart( 'character', -elemLen );
							oSel.moveStart( 'character', elemLen );
							oSel.moveEnd( 'character', 0 );
							oSel.select();
						} else if ( elem.selectionStart || '0' == elem.selectionStart ) {
							// Firefox/Chrome
							elem.selectionStart = elemLen;
							elem.selectionEnd = elemLen;
							elem.focus();
						} // if
					}
				}, 200 );

				$thisEl.on( 'change', '[name="label"]', function( event ) {
					var label = ( event.target && event.target.value ) || '';
					var $name = jQuery( this ).parents().siblings( '[data-option-id="name"]' ).find( 'input' );
					if ( '' === $name.val() && label ) {
						$name.val( _.fusionSanitize( label ) );
						$name.trigger( 'change' );
					}
				} );

				$thisEl.on( 'keydown', '[name="name"], [name$="field_name"]', function( e ) {
					var c = e.which;
					var ascii = {
						'109': '45',
						'173': '45',
						'186': '59',
						'189': '45'
					};
					if ( ascii.hasOwnProperty( c ) ) {
						c = ascii[ c ];
					}
					if ( ( 65 <= c && 90 >= c ) || ( !e.shiftKey && 48 <= c && 57 >= c ) || 45 == c || ( e.shiftKey && 59 == c ) || 8 == c || ( 37 <= c && 40 >= c ) ) {
						return;
					}
					return event.preventDefault();
				} );
			}

			if ( 'undefined' === typeof $element ) {
				this.optionRepeater( 'builder' );
			}

			setTimeout( function() {
				$thisEl.find( 'select, input, textarea, radio' ).filter( ':eq(0)' ).not( '[data-placeholder]' ).focus();
			}, 1 );

			// If rendering a specific tab, save this fact to prevent reinit.
			if ( tabId ) {
				setTimeout( function() {
					self.tabsRendered[ tabId ] = true;
				}, 500 );
			} else {
				this.tabsRendered = true;
			}

		},

		/**
		 * Inserts shortcode from generator.
		 *
		 * @since 2.0.0
		 * @param {Object} event - The event.
		 * @return {void}
		 */
		insertGeneratedShortcode: function( event ) {

			var attributes,
				functionName,
				parentView,
				element;

			if ( event ) {
				event.preventDefault();
			}

			// Remove activee states.
			this.removeActiveStates();

			attributes = this.model.attributes;

			// Escapes &, <, >, ", `, and ' characters
			if ( 'undefined' !== typeof fusionAllElements[ this.model.get( 'element_type' ) ].escape_html && true === fusionAllElements[ this.model.get( 'element_type' ) ].escape_html ) {
				attributes.params.element_content = _.escape( attributes.params.element_content );
			}

			// Manupulate model attributes via custom function if provided by element
			if ( 'undefined' !== typeof fusionAllElements[ this.model.get( 'element_type' ) ].on_save ) {

				functionName = fusionAllElements[ this.model.get( 'element_type' ) ].on_save;

				if ( 'function' === typeof FusionApp.callback[ functionName ] ) {
					attributes = FusionApp.callback[ functionName ]( attributes, this );
				}
			}

			element = FusionPageBuilderApp.generateElementShortcode( this.model, false, true );

			FusionEvents.trigger( 'fusion-history-resume-tracking' );

			this.openGeneratorTarget();

			fusionBuilderInsertIntoEditor( element, FusionPageBuilderApp.shortcodeGeneratorEditorID );

			// Destroy option fields
			this.destroyOptions();

			if ( 'multi_element_child' === this.model.get( 'multi' ) ) {

				// Set element/model attributes
				this.model.set( attributes );

				FusionEvents.trigger( 'fusion-multi-element-edited' );
				FusionEvents.trigger( 'fusion-multi-child-update-preview' );

				parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
				if ( 'undefined' !== typeof parentView ) {
					parentView.updateElementContent();
				}

			} else if ( 'multi_element_parent' === this.model.get( 'multi' ) ) {

				// TODO: this.mode.set( 'params' );
				this.model.set( attributes );
			}

			if ( FusionPageBuilderApp.manuallyAdded ) {
				FusionPageBuilderApp.shortcodeGenerator         = FusionPageBuilderApp.manualGenerator;
				FusionPageBuilderApp.shortcodeGeneratorEditorID = FusionPageBuilderApp.manualEditor;
				FusionPageBuilderApp.manuallyAdded              = false;
			}
			if ( 'undefined' !== typeof this.model && 'undefined' !== typeof this.model.get( 'multi' ) && 'multi_element_child' === this.model.get( 'multi' )  ) {
				FusionEvents.trigger( 'fusion-child-changed' );
			}

			this.remove();

			FusionPageBuilderApp.shortcodeGenerator = '';

			FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

			FusionEvents.trigger( 'fusion-settings-modal-save' );
		},

		removeView: function( cid ) {

			if ( cid !== this.model.get( 'cid' ) && ( 'undefined' === typeof this.model.parentView || ! this.model.parentView || cid !== this.model.parentView.model.get( 'cid' ) ) ) {
				return;
			}

			if ( this.dynamicSelection ) {
				this.dynamicSelection.removeView();
			}

			// Destroy option fields
			this.destroyOptions();

			FusionEvents.trigger( 'fusion-settings-removed', this.model.get( 'cid' ) );

			jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).removeClass( 'fusion-dialog-ui-active' );

			this.remove();
		},

		/**
		 * Saves the settings.
		 *
		 * @since 2.0.0
		 * @param {Object} event - The event.
		 * @return {void}
		 */
		saveSettings: function( event ) {

			var attributes,
				functionName,
				parentView,
				MultiGlobalArgs;

			if ( event ) {
				event.preventDefault();
			}

			// Destroy option fields
			this.destroyOptions();

			// Remove activee states.
			this.removeActiveStates();

			attributes = this.model.attributes;

			// Column and container spacing.
			if ( 'fusion_builder_container' === this.model.get( 'element_type' ) || 'fusion_builder_column' === this.model.get( 'element_type' ) || 'fusion_builder_column_inner' === this.model.get( 'element_type' ) ) {
				this.elementView.destroyResizable();
				this.elementView.$el.removeClass( 'fusion-builder-element-edited' );
			}

			// Escapes &, <, >, ", `, and ' characters
			if ( 'undefined' !== typeof fusionAllElements[ this.model.get( 'element_type' ) ].escape_html && true === fusionAllElements[ this.model.get( 'element_type' ) ].escape_html ) {
				attributes.params.element_content = _.escape( attributes.params.element_content );
			}

			// Manupulate model attributes via custom function if provided by element
			if ( 'undefined' !== typeof fusionAllElements[ this.model.get( 'element_type' ) ].on_save ) {

				functionName = fusionAllElements[ this.model.get( 'element_type' ) ].on_save;

				if ( 'function' === typeof FusionApp.callback[ functionName ] ) {
					attributes = FusionApp.callback[ functionName ]( attributes, this );
				}
			}

			if ( 'multi_element_child' === this.model.get( 'multi' ) ) {

				// Set element/model attributes
				this.model.set( attributes );

				FusionEvents.trigger( 'fusion-multi-element-edited' );
				FusionEvents.trigger( 'fusion-multi-child-update-preview' );

				parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
				if ( 'undefined' !== typeof parentView ) {
					parentView.updateElementContent();

					// Close parent's settings dialog.
					if ( event && 'undefined' !== typeof event.currentTarget && ( jQuery( event.currentTarget ).hasClass( 'fusiona-close-fb' ) || jQuery( event.currentTarget ).hasClass( 'ui-dialog-titlebar-close' ) ) )  {
						FusionEvents.trigger( 'fusion-close-settings-' + this.model.get( 'parent' ) );
					}
				}

				this.remove();

			} else if ( 'multi_element_parent' === this.model.get( 'multi' ) ) {

				// TODO: this.mode.set( 'params' );
				this.model.set( attributes );

				this.remove();

			} else { // Regular element

				this.remove();
			}

			if ( 'undefined' !== typeof this.elementView ) {
				this.elementView.onSettingsClose();
			}

			// Handle multiple global elements.
			MultiGlobalArgs = {
				currentModel: this.model,
				handleType: 'save',
				attributes: this.model.attributes
			};
			fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

			if ( FusionPageBuilderApp.manuallyAdded ) {
				FusionPageBuilderApp.shortcodeGenerator         = FusionPageBuilderApp.manualGenerator;
				FusionPageBuilderApp.shortcodeGeneratorEditorID = FusionPageBuilderApp.manualEditor;
				FusionPageBuilderApp.manuallyAdded              = false;
			}
			if ( 'undefined' !== typeof this.model && 'undefined' !== typeof this.model.get( 'multi' ) && 'multi_element_child' === this.model.get( 'multi' )  ) {
				FusionEvents.trigger( 'fusion-child-changed' );
			}

			FusionEvents.trigger( 'fusion-settings-modal-save', this.model.get( 'cid' ) );
		},

		/**
		 * Saves the child and opens parent settings.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		openParent: function( event ) {
			var parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );

			if ( parentView ) {
				parentView.settings();
			}

			this.saveSettings( event );
		},

		/**
		 * Opens target dialog for generator insert/cancel.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		openGeneratorTarget: function() {
			var targetView = FusionPageBuilderViewManager.getView( this.model.get( 'target' ) );

			if ( targetView && 'dialog' === FusionApp.preferencesData.editing_mode ) {
				targetView.settings();
			}
		},

		/**
		 * Closes the generator modal.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		closeGeneratorModal: function() {

			// Destroy element model
			this.model.destroy();

			FusionEvents.trigger( 'fusion-history-resume-tracking' );

			FusionEvents.trigger( 'fusion-settings-modal-cancel' );

			this.openGeneratorTarget();

			this.remove();
		},

		/**
		 * Remove an MCE Editor.
		 *
		 * @since 2.0.0
		 * @param {string} id - The editor ID.
		 * @return {void}
		 */
		fusionBuilderMCEremoveEditor: function( id ) {

			if ( 'undefined' !== typeof window.tinyMCE ) {
				window.tinyMCE.execCommand( 'mceRemoveEditor', false, id );
				if ( 'undefined' !== typeof window.tinyMCE.get( id ) ) {
					window.tinyMCE.remove( '#' + id );
				}
			}
		},

		/**
		 * Runs before we start processing element settings dependencies.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		beforeProcessDependencies: function() {
			var view      = this,
				thisEl    = view.$el,
				shortcode = view.model.get( 'element_type' ),
				dividerType,
				upAndDown,
				centerOption;

			// Special check for section separator.
			if ( 'undefined' !== typeof shortcode && 'fusion_section_separator' === shortcode ) {
				dividerType  = thisEl.find( '#divider_type' );
				upAndDown    = dividerType.closest( 'ul' ).find( 'li[data-option-id="divider_candy"]' ).find( '.fusion-option-divider_candy' ).find( '.ui-button[data-value="bottom,top"]' );
				centerOption = dividerType.closest( 'ul' ).find( 'li[data-option-id="divider_position"]' ).find( '.fusion-option-divider_position' ).find( '.ui-button[data-value="center"]' );

				if ( 'triangle' !== dividerType.val() ) {
					upAndDown.hide();
				} else {
					upAndDown.show();
				}

				if ( 'bigtriangle' !== dividerType.val() ) {
					centerOption.hide();
				} else {
					centerOption.show();
				}

				dividerType.on( 'change paste keyup', function() {

					if ( 'triangle' !== jQuery( this ).val() ) {
						upAndDown.hide();
					} else {
						upAndDown.show();
					}

					if ( 'bigtriangle' !== jQuery( this ).val() ) {
						centerOption.hide();
						if ( centerOption.hasClass( 'ui-state-active' ) ) {
							centerOption.prev().click();
						}
					} else {
						centerOption.show();
					}
				} );
			}
		},

		addSliderVideo: function( event ) {

			var defaultParams,
				elementType,
				targetCid = this.model.get( 'cid' );

			if ( event ) {
				event.preventDefault();
			}
			FusionPageBuilderApp.manualGenerator            = FusionPageBuilderApp.shortcodeGenerator;
			FusionPageBuilderApp.manualEditor               = FusionPageBuilderApp.shortcodeGeneratorEditorID;
			FusionPageBuilderApp.manuallyAdded              = true;
			FusionPageBuilderApp.shortcodeGenerator         = true;
			FusionPageBuilderApp.shortcodeGeneratorEditorID = 'video';

			elementType = jQuery( event.currentTarget ).data( 'type' );

			// Get default options
			defaultParams = fusionAllElements[ elementType ].defaults;

			this.collection.add( [
				{
					type: 'generated_element',
					added: 'manually',
					element_type: elementType,
					params: defaultParams,
					target: targetCid
				}
			] );
		},

		defaultPreview: function( event ) {
			var $element = jQuery( event.currentTarget );

			if ( event ) {
				event.preventDefault();
			}

			if ( FusionApp.sidebarView ) {
				FusionApp.sidebarView.shortcutClick( $element );
			}
		},

		showHideDescription: function( event ) {
			var $element = jQuery( event.currentTarget );

			$element.closest( '.fusion-builder-option' ).find( '.description' ).first().slideToggle( 250 );
			$element.toggleClass( 'active' );
		},

		showResponsiveOptions: function( event ) {
			var $element = jQuery( event.currentTarget ).parent();

			$element.toggleClass( 'active-item' );
		},

		changeResponsiveOption: function( event ) {
			var $element   = jQuery( event.currentTarget );
			var $parent    = jQuery( event.currentTarget ).closest( 'li.active-item' );

			jQuery( '.fusion-builder-preview-' + $element.data( 'indicator' ) ).trigger( 'click' );
			$parent.removeClass( 'active-item' );

		},

		hideResponsiveOptions: function( event ) {
			var $element   = jQuery( event.currentTarget );

			$element.find( '.fusion-panel-options li.active-item' ).removeClass( 'active-item' );
		},

		checkPageTemplate: function() {
			var option = this.$el.find( 'li[data-option-id="hundred_percent"]' );

			if ( 'fusion_builder_container' === this.model.get( 'element_type' ) ) {
				option.show();

				// Normal post and content override is not active.
				if ( 'fusion_tb_section' !== FusionApp.data.postDetails.post_type && 'object' !== typeof FusionApp.data.template_override.content ) {

					// Check the post type.
					if ( 'post' === FusionApp.data.postDetails.post_type ) {

						// Blog post.
						if ( 'no' === FusionApp.data.postMeta._fusion.blog_width_100 || ( 'default' === FusionApp.data.postMeta._fusion.blog_width_100 && '0' === FusionApp.settings.blog_width_100 ) ) {
							option.hide();
						}

					} else if ( 'avada_portfolio' === FusionApp.data.postDetails.post_type ) {

						// Portfolio post.
						if ( 'no' === FusionApp.data.postMeta._fusion.portfolio_width_100 || ( 'default' === FusionApp.data.postMeta._fusion.portfolio_width_100 && '0' === FusionApp.settings.portfolio_width_100 ) ) {
							option.hide();
						}

					} else if ( '100-width.php' !== FusionApp.data.postMeta._wp_page_template ) {

						// Page with default template.
						option.hide();
					}

				} else if ( 'undefined' !== typeof FusionApp.data.postMeta._fusion.fusion_tb_section_width_100 && 'no' === FusionApp.data.postMeta._fusion.fusion_tb_section_width_100 ) { // Template Builder.
					option.hide();
				}
			}
		},

		onInit: function() {
		},

		onCancel: function() {
		},

		defaultChanged: function( param, value ) {
			var self       = this,
				$option    = 0 < this.$el.find( 'li[data-option-id="' + param + '"]' ).length ? this.$el.find( 'li[data-option-id="' + param + '"]' ) : this.$el.find( '#' + param ).closest( '.fusion-builder-option' ),
				optionType = false,
				oldValue,
				$target,
				values,
				$datePicker,
				$timePicker;

			if ( ! $option.length ) {
				return;
			}

			if ( $option.attr( 'data-option-type' ) ) {
				optionType = $option.attr( 'data-option-type' );
			}

			if ( ! optionType ) {
				optionType = $option.attr( 'class' ).replace( 'fusion-builder-option', '' ).trim();
			}

			switch ( optionType ) {
			case 'colorpicker':
			case 'colorpickeralpha':
				$target = $option.find( '.fusion-builder-color-picker-hex' );
				if ( $target.length ) {
					$target.data( 'default', value ).trigger( 'change' );
					if ( '' === $target.val() ) {
						$target.addClass( 'fusion-default-changed fusion-using-default' );
						if ( $target.hasClass( 'wp-color-picker' ) ) {
							$target.wpColorPicker( 'color', value );
						}
					}
				}
				break;

			case 'range':
				if ( 'object' === typeof self.$rangeSlider && 'undefined' !== typeof self.$rangeSlider[ $option.attr( 'data-index' ) ] ) {
					if ( $option.find( '.fusion-range-default' ).length ) {
						oldValue = $option.find( '.fusion-range-default' ).attr( 'data-default' );
						$option.find( '.fusion-range-default' ).attr( 'data-default', value );
					}
					self.$rangeSlider[ $option.attr( 'data-index' ) ].noUiSlider.options[ 'default' ] = value;
					if ( oldValue === self.$rangeSlider[ $option.attr( 'data-index' ) ].noUiSlider.get() ) {
						$option.find( '.fusion-range-default' ).trigger( 'click' );
					}
				}
				break;
			}
		},

		paramChanged: function( param, value ) {
			var self       = this,
				$option    = 0 < this.$el.find( 'li[data-option-id="' + param + '"]' ).length ? this.$el.find( 'li[data-option-id="' + param + '"]' ) : this.$el.find( '#' + param ).closest( '.fusion-builder-option' ),
				optionType = false,
				$target,
				values,
				$datePicker,
				$timePicker;

			if ( jQuery( '.fusion-table-builder-chart' ).length ) {
				jQuery( '.fusion-table-builder-chart' ).closest( '.ui-dialog-content' ).dialog( 'close' );
			}

			if ( ! $option.length ) {
				return;
			}

			if ( $option.attr( 'data-option-type' ) ) {
				optionType = $option.attr( 'data-option-type' );
			}

			this.changesPaused = true;

			if ( ! optionType ) {
				optionType = $option.attr( 'class' ).replace( 'fusion-builder-option', '' ).trim();
			}

			switch ( optionType ) {
			case 'iconpicker':
				$option.find( '.icon_preview.selected-element' ).removeClass( 'selected-element' );
				if ( value && 2 === value.split( ' ' ).length ) {
					$option.find( '.icon-' + value.split( ' ' )[ 0 ] ).addClass( 'selected-element' );
				}
				$option.find( '#' + param ).val( value ).trigger( 'change' );
				break;
			case 'upload':
				$option.find( '#' + param ).val( value ).trigger( 'change' );
				$option.find( '.fusion-builder-upload-preview img' ).remove();

				if ( value && '' !== value ) {
					$option.find( '.fusion-upload-area:not( .fusion-uploaded-image )' ).addClass( 'fusion-uploaded-image' );
					$option.find( '.fusion-builder-upload-preview' ).prepend( '<img src="' + value + '" />' );
				} else {
					$option.find( '.fusion-upload-area' ).removeClass( 'fusion-uploaded-image' );
				}
				break;
			case 'multiple_select':
				$option.find( '.fusion-select-preview' ).empty();
				$option.find( 'input[type="checkbox"]' ).prop( 'checked', false );

				if ( value && '' !== value ) {
					values = value.split( ',' );
					_.each( values, function( value ) {
						$option.find( 'input[value="' + value + '"]' ).prop( 'checked', true );
						$option.find( '.fusion-select-preview' ).append( '<span class="fusion-preview-selected-value" data-value="' + value + '">' + $option.find( 'input[value="' + value + '"]' ).attr( 'data-label' ) + '<span class="fusion-option-remove">x</span></span>' );
					} );
				}

				if ( 0 === $option.find( '.fusion-select-preview .fusion-preview-selected-value' ).length ) {
					$option.find( '.fusion-select-preview-wrap' ).addClass( 'fusion-select-show-placeholder' );
				} else {
					$option.find( '.fusion-select-preview-wrap' ).removeClass( 'fusion-select-show-placeholder' );
				}

				$option.find( '#' + param ).val( value ).trigger( 'change' );
				break;
			case 'tinymce':
				if ( $option.find( '#child_' + param ).length ) {
					param = 'child_' + param;
				}
				$option.find( '#' + param ).val( value );
				if ( $option.find( '#' + param ).hasClass( 'fusion-editor-field' ) && 'undefined' !== typeof window.tinyMCE && window.tinyMCE.get( param ) && ! window.tinyMCE.get( param ).isHidden() ) {
					if ( window.tinyMCE.get( param ).getParam( 'wpautop', true ) && 'undefined' !== typeof window.switchEditors ) {
						value = window.switchEditors.wpautop( value );
					}
					window.tinyMCE.get( param ).setContent( value, { format: 'html' } );
				}
				break;
			case 'date_time_picker':
				$option.find( '#' + param ).val( value ).trigger( 'change' );
				$datePicker = $option.find( '.fusion-date-picker' );
				$timePicker = $option.find( '.fusion-time-picker' );

				if ( -1 !== value.indexOf( ' ' ) && $datePicker.length && $timePicker.length ) {
					values = value.split( ' ' );
					$datePicker.val( values[ 0 ] );
					$timePicker.val( values[ 1 ] );
				} else if ( $datePicker.length ) {
					$datePicker.val( value );
				} else if ( $timePicker.length ) {
					$timePicker.val( value );
				}
				break;
			case 'raw_textarea':
				try {
					value = FusionPageBuilderApp.base64Decode( value );
					$option.find( '#' + param ).val( value ).trigger( 'change' );
				} catch ( e ) {
					console.warn( 'Something went wrong! Error triggered - ' + e );
				}
				break;
			case 'code':
				if ( 'undefined' !== typeof self.codeEditorOption[ $option.attr( 'data-index' ) ] ) {
					try {
						value = FusionPageBuilderApp.base64Decode( value );
						self.codeEditorOption[ $option.attr( 'data-index' ) ].setValue( value );
					} catch ( e ) {
						console.warn( 'Something went wrong! Error triggered - ' + e );
					}
				}
				break;
			case 'range':
				if ( 'undefined' !== typeof self.$rangeSlider[ $option.attr( 'data-index' ) ] ) {
					if ( 'undefined' === typeof value || '' === value ) {
						value = self.$rangeSlider[ $option.attr( 'data-index' ) ].noUiSlider.options[ 'default' ];
					}
					self.$rangeSlider[ $option.attr( 'data-index' ) ].noUiSlider.set( value );
				}
				break;
			case 'checkbox_button_set':
				$option.find( '.button-set-value' ).val( value ).trigger( 'change' );
				$option.find( '.ui-state-active' ).removeClass( 'ui-state-active' );
				if ( 'string' === typeof value && '' !== value ) {
					values = value.split( ',' );
					_.each( values, function( value ) {
						$option.find( '[data-value="' + value + '"]' ).addClass( 'ui-state-active' );
					} );
				} else if ( 'hide_on_mobile' === param ) {
					$option.find( '.buttonset-item' ).addClass( 'ui-state-active' );
				}
				break;
			case 'select':
				$target = $option.find( '.fusion-select-options .fusion-select-label[data-value="' + value + '"]' );
				if ( $target.length ) {
					$option.find( '.fusion-option-selected' ).removeClass( 'fusion-option-selected' );
					$target.addClass( 'fusion-option-selected' );
					$option.find( '.fusion-select-preview' ).html( $target.html() );
					$option.find( '#' + param ).val( value ).trigger( 'fusion-change' );
				}
				break;
			case 'colorpicker':
			case 'colorpickeralpha':
				$target = $option.find( '.fusion-builder-color-picker-hex' );
				if ( $target.length ) {
					$target.val( value ).trigger( 'change' );
				}
				break;
			case 'radio_button_set':
				$target = $option.find( '.buttonset-item[data-value="' + value + '"]' );
				if ( $target.length ) {
					$option.find( '.ui-state-active' ).removeClass( 'ui-state-active' );
					$target.addClass( 'ui-state-active' );
					$option.find( '#' + param ).val( value ).trigger( 'change' );
				}
				break;
			case 'dimension':
				$target = $option.find( '#' + param );
				if ( $target.length ) {
					$target.val( value ).trigger( 'change' );
				}
				break;
			case 'sortable':
				self.reRender();
				break;
			case 'sortable_text':
				self.reRender();
				break;
			case 'connected_sortable':
				self.reRender();
				break;
			default:
				$option.find( '#' + param ).val( value ).trigger( 'change' );
				break;
			}

			this.changesPaused = false;
		}
	} );

	// Options
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionCodeBlock );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionColorPicker );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionDimensionField );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionIconPicker );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionOptionUpload );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.radioButtonSet );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionRangeField );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionSelectField );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionCheckboxButtonSet );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionDateTimePicker );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionEditor );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionMultiSelect );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionSwitchField );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionTextFieldPlaceholder );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionLinkSelector );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionRepeaterField );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionSortable );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionSortableText );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionConnectedSortable );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionDynamicData );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionTypographyField );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionFontFamilyField );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionColumnWidth );
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.options.fusionFormOptions );

	// Active states.
	_.extend( FusionPageBuilder.ElementSettingsView.prototype, FusionPageBuilder.fusionActiveStates );
}( jQuery ) );
;/* global CodeMirror, fusionAppConfig, fusionAllElements, fusionBuilderConfig */
/* eslint no-shadow: 0 */
/* eslint no-empty: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function( $ ) {
	var widgets, widget, widgetData, widgetDataPromise, widgetDataLoading, widgetDataLoaded, fusionConfig;

	widgets = [];

	/**
	 * Gets all widget HTML forms
	 * @param {Function} callback
	 */
	function getWidgetForms( callback ) {
		if ( widgetDataLoaded ) {
			return callback();
		}
		if ( widgetDataLoading ) {
			widgetDataPromise.success( callback );
		} else {
			widgetDataLoading = true;
			widgetDataPromise = jQuery.ajax( {
				url: fusionConfig.ajaxurl,
				type: 'post',
				dataType: 'json',
				data: {
					action: 'fusion_get_widget_form'
				}
			} ).success( function( response ) {
				widgetDataLoaded 	= true;
				widgetDataLoading 	= false;
				widgetData			= response.data;

				// Fix for the hashed widget php class names
				_.each( widgetData, function( value, key ) {

					if ( 'undefined' === typeof fusionAllElements.fusion_widget.params.type.value[ key ] ) {

						// Try to find a corresponding class name by widget name
						jQuery.map( fusionAllElements.fusion_widget.params.type.value, function( val, i ) {
							if ( val === value.name ) {

								// Add the new class name key
								value.title   = i;
								widgetData[ i ] = value;

								// Delete the old class name key
								widgetData[ key ][ 'delete' ];
							}
						} );
					}
				} );

				return callback && callback();
			} );
		}
	}

	$( document ).ready( function() {
		// Get correct fusion config in both front/backend
		fusionConfig = ( 'undefined' !== typeof FusionApp ) ? fusionAppConfig : fusionBuilderConfig;

		// Check if widget_element is enabled and get corresponding form html
		if ( fusionConfig.widget_element_enabled ) {
			getWidgetForms();
		}

		FusionPageBuilder.BaseWidgetSettingsView = FusionPageBuilder.ElementSettingsView.extend( {

			/**
			 *  Invalid widgets list
			 * 	Different from blacklist, because invalid widgets will force form append rather than use compatibility mode
			 *
			 * 	@since 2.0.0
			 */
			invalidWidgets: [ 'Fusion_Widget_Social_Links' ],

			/**
			 * Creates a formatted widget form field name.
			 *
			 * @since 2.0.0
			 * @param {String} className
			 * @param {String} name
			 */
			createWidgetFieldName: function ( className, name ) {
				var prefix = className.toLowerCase() + '__';

				name = name.toLowerCase();

				try {
					prefix += name.match( /\[(.*?)\]/g ).slice( -1 )[ 0 ].replace( /\[|(\])/g, '' );
				} catch ( e ) {}

				return prefix;
			},

			/**
			 * Parses a widget and registers it to `widgets` variable.
			 *
			 * @since 2.0.0
			 * @param {Object} widget
			 * @param {String} className
			 */
			registerWidget: function( widget, className ) {
				var $form,
					selectors,
					fields,
					getElementAttributes,
					incorrectFields,
					self;

				self   = this;
				fields = {};
				// Make a form and insert widget form contents for easy manipulation
				$form  = $( '<form></form>' ).html( widget.form );
				// HTML selectors we want to retrieve from `$form`
				selectors   = [
					'fieldset',
					'input',
					'select',
					'textarea'
				].join( ',' );

				getElementAttributes = function ( element, keys ) {
					var result = {};
					_.each( keys, function( key ) {
					result[ key ] = element[ key ];
					} );
					return result;
				};

				// Start form parsing
				$form.find( selectors ).not( '[type="button"]' ).each( function() {
					var field, name;

					// The form field attributes
					field = getElementAttributes(
						this,
						[ 'id', 'className', 'name', 'tagName', 'type', 'value', 'placeholder', 'options', 'checked' ]
					);
					// The form field name
					name = self.createWidgetFieldName( className, field.name );

					// Map options for select elements
					field.options = _.map( field.options, function( option ) {
						return getElementAttributes( option, [ 'value', 'text', 'selected' ] );
					} );

					// Match field attributes to fusion form fields by tagName
					switch ( field.tagName ) {
						case 'INPUT': {
							if ( [ 'text', 'number' ].includes( field.type ) ) {
								field.type = 'textfield';
							} else if ( 'checkbox' === field.type ) {
								field.type = 'radio_button_set';
								field.value = {
									'on': 'On',
									'': 'Off'
								};
								// eslint-disable-next-line dot-notation
								field.default = field.checked ? 'on' : '';
							}
							break;
						}
						case 'SELECT': {
							field.type = 'select';
							field.value = _.reduce( field.options, function( options, option ) {
								if ( option.selected ) {
									field[ 'default' ] = option.value;
								}
								options[ option.value ] = option.text;
								return options;
							}, {} );
							break;
						}

						case 'TEXTAREA': {
							field.type = 'textarea';
							break;
						}

						default:
							break;
					}

					// Match field attributes to fusion form fields
					if ( field.id ) {
						// Temporal fix for menu widget typo
						field.id = 'widget-menu-widget--menu_Link_color' === field.id ? field.id.toLowerCase() : field.id;
						field.heading = $form.find( 'label[for="' + field.id + '"]' ).text() || field.placeholder;
					}

					field.param_name 	= name;
					// assing same ajax callback
					field.callback		= {};
					field.callback[ 'function' ] = 'fusion_get_widget_markup';
					field.callback.ajax     = true;

					if ( 'hidden' === field.type ) {
						delete field.dependency;
						field.hidden = true;
					}

					fields[ name ] = field;
				} );

				// Check if there were errors during parsing and add it to incorrect fields array
				incorrectFields = _.find( fields, function ( field ) {
					return ! field.heading || !field.name;
				} );

				widgets[ className ] = {
					className: className,
					fields: fields,
					data: widget,
					isInvalid: incorrectFields || this.invalidWidgets.includes( className ),
					isCoreWidget: [ 'WP_Widget_Text', 'WP_Widget_Media_Audio', 'WP_Widget_Media_Image', 'WP_Widget_Media_Video', 'WP_Widget_Media_Gallery', 'WP_Widget_Custom_HTML' ].includes( className )
				};
			},

			/**
			 * Register all widgets from `widgetData` to `widgets`
			 *
			 * @since 2.0.0
			 * @returns {void}
			 */
			registerWidgets: function () {
				var self = this;

				// Attach a callback to getWidgetForms() in case `widgetData` is not fully loaded
				getWidgetForms( function() {
					self.widgetData = widgetData;
					// Just parse `widgetData` once
					if ( ! widgets.length ) {
						_.each( self.widgetData, self.registerWidget.bind( self ) );
					}
					self.setWidgetFields();

					// HTML and Text widget especial unescape.
					if ( widget ) {
						if ( 'WP_Widget_Custom_HTML' === widget.className ) {
							self.model.attributes.params.wp_widget_custom_html__content = _.unescape( self.model.attributes.params.wp_widget_custom_html__content );
						} else if ( 'WP_Widget_Text' === widget.className ) {
							self.model.attributes.params.wp_widget_text__text = _.unescape( self.model.attributes.params.wp_widget_text__text );
						}
					}
				} );
			},

			/**
			 * Cleans selection of a appended widget form
			 *
			 * @since 2.0.0
			 * @returns {void}
			 */
			clean: function() {
				//NOTE: required for form only
				this.destroyWidgetOptions();
				this.deleteWpModels();
				this.cleanForm();
			},

			/**
			 * Cleans previous appended forms
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			cleanForm: function() {
				this.$el.find( '.fusion-widget-settings-form' ).remove();
			},

			/**
			 * Appends form into settings view
			 *
			 * @since 2.2.0
			 * @return {void}
			 */
			insertForm: function () {
				var container,
					event,
					formSettings,
					widgetData,
					codeElement,
					$el,
					widgetClassName,
					self = this;

				// Create form and append it below the widget selector.
				container    = this.$el.find( '#general .fusion_widget .fusion-builder-option:first ' );
				widgetData   = widget.data;
				widgetClassName = widget.className;
				formSettings = {
					coreWidget: widget.isCoreWidget,
					attributes: {
						id: widgetData.id + '-' + this.cid,
						base: widgetData.id,
						form: widgetData.form,
						type: widgetClassName,
						class: widgetData.classname
					},
					widgetData: this.widgetData
				};

				this.appendedForm = this.formTemplate( formSettings );

				container.after( this.appendedForm );

				// Aditional steps for core widgets.
				if ( formSettings.coreWidget ) {
					$el = this.$el.find( '.widget-inside' ).parent();

					this.setFormValues( widgetClassName );

					// Create the core WP view.
					event = new jQuery.Event( 'widget-added' );

					if ( 'WP_Widget_Text' === widgetClassName ) {
						wp.textWidgets.handleWidgetAdded( event, $el );
					} else if ( 'WP_Widget_Custom_HTML' === widgetClassName ) {
						wp.customHtmlWidgets.handleWidgetAdded( event, $el );
					} else {
						wp.mediaWidgets.handleWidgetAdded( event, $el );
					}

					this.$el.find( '.widget-inside' ).show();

					if ( this.$el.find( '.wp-editor-area' ).length ) {
						setTimeout( function() {
							wp.textWidgets.widgetControls[ 'text-' + self.cid ].initializeEditor();
						}, 200 );
					}

					if ( this.$el.find( '.custom-html-widget-fields .code' ).length ) {
						codeElement = this.$el.find( '.custom-html-widget-fields .code' );
						self.codeBlock = codeElement.next( '.CodeMirror' ).get( 0 ).CodeMirror;

						if ( !self.codeBlock ) {
							self.codeBlock = CodeMirror.fromTextArea( codeElement[ 0 ], {
								lineNumbers: true,
								lineWrapping: true,
								autofocus: true,
								mode: 'htmlmixed'
							} );
						}
						// Refresh editor after initialization
						setTimeout( function() {
							self.codeBlock.refresh();
							self.codeBlock.focus();
						}, 100 );
					}
				} else {
					$el = this.$el.find( '.fusion-widget-settings-form' );

					this.setFormValues( widgetClassName );
					this.$el.find( '.widget-inside' ).show();
				}
			},

			/**
			 * Goes to each form value and set's default values or previously selected ones.
			 *
			 * @since 2.2.0
			 * @return {void}
			 */
			setFormValues: function( widgetClassName ) {
				var self = this;
				// Set form values
				var paramPrefix = widgetClassName.toLowerCase() + '__';

				_.each( this.model.attributes.params, function( value, key ) {
					var $input, selector;

					if ( 'type' !== key && -1 !== key.indexOf( paramPrefix ) ) {
						selector = '[name$="[' + key.replace( paramPrefix, '' ) + ']"]';
						$input   = self.$el.find( selector );
					}

					if ( $input && $input.length ) {
						if ( $input.is( ':checkbox' ) ) {
							if ( 1 === parseInt( value ) || true === value || 'on' === value || 'enabled' === value ) {
								$input.prop( 'checked', true );
							} else {
								$input.prop( 'checked', false );
							}
						} else {
							$input.val( value );
						}
					}
				} );
			},

			/**
			 * Delete the models.
			 *
			 * @since 2.2.0
			 * @returns {void}
			 */
			deleteWpModels: function() {
				if ( 'undefined' !== typeof wp.mediaWidgets.widgetControls && 'undefined' !== typeof wp.mediaWidgets.modelCollection ) {
					wp.mediaWidgets.modelCollection.reset();
					wp.mediaWidgets.widgetControls = {};
				}
				if ( 'undefined' !== typeof wp.textWidgets.widgetControls ) {
					wp.textWidgets.widgetControls = {};
				}

				if ( 'undefined' !== typeof wp.customHtmlWidgets.widgetControls ) {
					wp.customHtmlWidgets.widgetControls = {};
				}
			},

			/**
			 * Handler to destroy specific widget options.
			 *
			 * @since 2.2.0
			 * @returns {void}
			 */
			destroyWidgetOptions: function() {

				// Remove each instance of tinyMCE editor from this view
				this.$el.find( '.wp-editor-area' ).each( function() {
					var editorID = jQuery( this ).attr( 'id' );
					if ( 'undefined' !== typeof window.tinyMCE ) {
						window.tinyMCE.execCommand( 'mceRemoveEditor', false, editorID );
						if ( 'undefined' !== typeof window.tinyMCE.get( editorID ) ) {
							window.tinyMCE.remove( '#' + editorID );
						}
					}
				} );
			},

			/**
			 * Removes all generated options from selected widget
			 *
			 * @since 2.2.0
			 * @returns {void}
			 */
			cleanWidget: function() {
				var self = this;

				if ( ! widget ) {
					return;
				}
				// Clean prev fields
				_.each( widget.fields, function( field, key ) {
					delete fusionAllElements.fusion_widget.params[ key ];
					delete self.model.attributes.params[ key ];
				} );
				widget = null;
			},

			/**
			 * Returns current selected widget
			 *
			 * @since 2.2.0
			 * @returns {void}
			 */
			getWidget: function() {
				return widget;
			},

			/**
			 * Sets the widget
			 * Action get's called when user selects a widget in <select />.
			 *
			 * @since 2.2.0
			 * @returns {void}
			 */
			setWidget: function() {
				var className = this.model.attributes.params.type;
				if ( ! className  || ! widgets[ className ] ) {
					return;
				}

				widget = widgets[ className ];
			},

			/**
			 * Updates settings fields according to the selected widget
			 *
			 * @since 2.2.0
			 * @returns {Void}
			 */
			updateWidget: function() {
				var self = this;

				if ( ! widget || widget.isCoreWidget || widget.isInvalid ) {
					return;
				}

				// Update with widget fields
				fusionAllElements.fusion_widget.params = _.extend(
					{
						type: fusionAllElements.fusion_widget.params.type
					},
					widget.fields,
					fusionAllElements.fusion_widget.params
				);

				// Set default values
				_.each( widget.fields, function( field, key ) {

					// Skip if it already have a default param
					if ( 'undefined' !== typeof self.model.attributes.params[ key ] ) {
						return;
					}

					if ( 'object' === typeof field.value && field.value[ field[ 'default' ] ] ) {
						self.model.attributes.params[ key ] = field[ 'default' ];
					} else if ( 'object' !== typeof field.value && ( field[ 'default' ] || field.value ) ) {
						self.model.attributes.params[ key ] = field[ 'default' ] || field.value;
					}
				} );
			},

			/**
			 * Sets settings fields according to the selected widget
			 *
			 * @since 2.2.0
			 * @returns {Void}
			 */
			setWidgetFields: function () {
				if ( widget && widget.className === this.model.attributes.params.type ) {
					return;
				}
				this.cleanWidget();

				this.setWidget();

				this.updateWidget();
			}

		} );
	} );

}( jQuery ) );
;/* eslint-disable no-mixed-operators */
/* eslint no-useless-concat: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function( $ ) {

	$( document ).ready( function() {

		FusionPageBuilder.BulkAddView = window.wp.Backbone.View.extend( {

			className: FusionPageBuilder.ElementSettingsView.prototype.className + ' fusion-builder-bulk-add-dialog',

			template: FusionPageBuilder.template( $( '#fusion-builder-bulk-add-template' ).html() ),

			events: {
				'click .predefined-choice': 'predefinedChoices'
			},

			getChoices: function() {
				var textarea 	= this.$el.find( 'textarea' ).val(),
					choices 	= [];

				if ( textarea ) {
					_.each( textarea.split( /\n/ ), function( line ) {
						var choice = line.trim();
						if ( choice ) {
							choices.push( choice );
						}
					} );
				}

				return choices;
			},

			predefinedChoices: function( event ) {
				var $element 	= jQuery( event.target ),
					value 		= $element.data( 'value' ),
					choices;

				if ( ! isNaN( value ) ) {
					choices = this.options.choices[ value ].values;
					choices = choices.join( '\n' );
					this.$el.find( 'textarea' ).val( choices );
				}
			}

		} );

	} );

}( jQuery ) );
;/* global FusionPageBuilderViewManager, FusionEvents, FusionPageBuilderApp, fusionGlobalManager */
/* eslint no-unused-vars: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Element View
		FusionPageBuilder.ElementSettingsParent = window.wp.Backbone.View.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-child-sortables' ).html() ),
			events: {
				'click .fusion-builder-add-multi-child': 'addChildElement',
				'click .fusion-builder-multi-setting-remove': 'removeChildElement',
				'click .fusion-builder-multi-setting-clone': 'cloneChildElement',
				'click .fusion-builder-multi-setting-options': 'editChildElement'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
				this.elementView = FusionPageBuilderViewManager.getView( this.model.get( 'cid' ) );
				this.listenTo( FusionEvents, 'fusion-child-changed', this.render );
				this.listenTo( this.model.children, 'add', this.render );
				this.listenTo( this.model.children, 'remove', this.render );
				this.listenTo( this.model.children, 'sort', this.render );
				this.settingsView = this.attributes.settingsView;
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				this.$el.html( this.template( this.model ) );
				this.sortableOptions();

				return this;
			},

			/**
			 * Make sortable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			sortableOptions: function() {
				var self = this;

				this.$el.find( '.fusion-builder-sortable-children' ).sortable( {
					axis: 'y',
					cancel: '.fusion-builder-multi-setting-remove, .fusion-builder-multi-setting-options, .fusion-builder-multi-setting-clone',
					helper: 'clone',

					update: function( event, ui ) {
						var content   = '',
							newIndex    = ui.item.parent().children( '.ui-sortable-handle' ).index( ui.item ),
							elementView = FusionPageBuilderViewManager.getView( ui.item.data( 'cid' ) ),
							childView;

						// Update collection
						FusionPageBuilderApp.onDropCollectionUpdate( elementView.model, newIndex, self.model.get( 'cid' ) );

						self.$el.find( '.fusion-builder-sortable-children li' ).each( function() {
							childView = FusionPageBuilderViewManager.getView( jQuery( this ).data( 'cid' ) );
							content  += FusionPageBuilderApp.generateElementShortcode( childView.$el, false );
						} );

						self.elementView.setContent( content );

						// After sorting of children remove the preview block class, as the mouseleave sometimes isn't triggered.
						if ( ! jQuery( 'body' ).hasClass( 'fusion-sidebar-resizing' ) && jQuery( 'body' ).hasClass( 'fusion-preview-block' ) ) {
							jQuery( 'body' ).removeClass( 'fusion-preview-block' );
						}

						// Save history state
						FusionEvents.trigger( 'fusion-history-save-step', window.fusionBuilderText.moved + ' ' + window.fusionAllElements[ childView.model.get( 'element_type' ) ].name + ' ' + window.fusionBuilderText.element );
					}
				} );
			},

			/**
			 * Adds a child element view and renders it.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addChildElement: function( event ) {

				event.preventDefault();
				this.elementView.addChildElement();
				this.render();

				this.settingsView.optionHasChanged = true;
			},

			/**
			 * Removes a child element view and rerenders.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			removeChildElement: function( event ) {
				var childCid,
					childView,
					MultiGlobalArgs;

				childCid  = jQuery( event.target ).closest( '.fusion-builder-data-cid' ).data( 'cid' );
				childView = FusionPageBuilderViewManager.getView( childCid );

				event.preventDefault();

				childView.removeElement( event );
				this.render();

				// Handle multiple global elements.
				MultiGlobalArgs = {
					currentModel: childView.model,
					handleType: 'changeOption'
				};
				fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

				this.elementView.childViewRemoved();

				this.settingsView.optionHasChanged = true;
			},

			/**
			 * Clones a child element view and rerenders.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			cloneChildElement: function( event ) {
				var childCid,
					childView,
					parentView,
					MultiGlobalArgs;

				childCid   = jQuery( event.target ).closest( '.fusion-builder-data-cid' ).data( 'cid' );
				childView  = FusionPageBuilderViewManager.getView( childCid );
				parentView = FusionPageBuilderViewManager.getView( this.model.get( 'cid' ) );

				event.preventDefault();

				childView.cloneElement();

				this.render();

				// Handle multiple global elements.
				MultiGlobalArgs = {
					currentModel: childView.model,
					handleType: 'changeOption'
				};
				fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

				this.elementView.childViewCloned();

				this.settingsView.optionHasChanged = true;
			},

			/**
			 * Edits a child element view and rerenders.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			editChildElement: function( event ) {
				var childCid  = jQuery( event.target ).closest( '.fusion-builder-data-cid' ).data( 'cid' ),
					childView = FusionPageBuilderViewManager.getView( childCid );

				event.preventDefault();

				childView.settings();
			}
		} );
	} );
}( jQuery ) );
;/* global FusionApp, FusionPageBuilderApp, fusionAppConfig, fusionGlobalManager, fusionBuilderText, FusionEvents, fusionAllElements, FusionPageBuilderViewManager */
/* eslint no-unused-vars: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Elements View
		FusionPageBuilder.ElementLibraryView = window.wp.Backbone.View.extend( {

			className: 'fusion_builder_modal_settings',
			events: {
				'click .fusion-builder-all-modules .fusion-builder-element:not(.fusion-builder-element-generator,.fusion-builder-disabled-element)': 'addModule',
				'click .fusion_builder_custom_elements_load': 'addCustomModule',
				'click .fusion-builder-column-layouts li': 'addNestedColumns'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function( attributes ) {
				this.options = attributes;

				if ( true === FusionPageBuilderApp.shortcodeGenerator ) {
					this.template = FusionPageBuilder.template( jQuery( '#fusion-builder-generator-modules-template' ).html() );
				} else if ( 'fusion_builder_column_inner' === this.model.get( 'element_type' ) ) {
					this.template = FusionPageBuilder.template( jQuery( '#fusion-builder-nested-column-modules-template' ).html() );
				} else {
					this.template = FusionPageBuilder.template( jQuery( '#fusion-builder-modules-template' ).html() );
				}
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				this.$el.html( this.template( FusionPageBuilderApp.elements ) );

				// Load saved elements
				FusionPageBuilderApp.showSavedElements( 'elements', this.$el.find( '#custom-elements' ) );

				FusionApp.elementSearchFilter( this.$el );

				FusionApp.dialog.dialogTabs( this.$el );

				return this;
			},

			/**
			 * Adds a custom element and triggers an ajax call.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addCustomModule: function( event ) {
				var layoutID,
					title,
					self = this,
					isGlobal,
					targetElement;

				if ( event ) {
					event.preventDefault();
				}

				if ( true === FusionApp.layoutIsLoading ) {
					return;
				}

				FusionApp.layoutIsLoading = true;

				layoutID      = jQuery( event.currentTarget ).closest( 'li' ).data( 'layout_id' );
				title         = jQuery( event.currentTarget ).find( '.fusion_module_title' ).text();
				isGlobal      = jQuery( event.currentTarget ).closest( 'li' ).hasClass( 'fusion-global' );

				if ( 'undefined' !== typeof this.options.targetElement ) {
					targetElement = this.options.targetElement;
				}

				jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).css( 'opacity', '0' );
				jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).prev( '#fusion-loader' ).show();

				jQuery.ajax( {
					type: 'POST',
					url: fusionAppConfig.ajaxurl,
					data: {
						action: 'fusion_builder_load_layout',
						fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
						fusion_is_global: isGlobal,
						fusion_layout_id: layoutID
					}
				} )
				.done( function( data ) {
					var dataObj = JSON.parse( data );

					if ( 'undefined' !== typeof targetElement ) {
						FusionPageBuilderApp.shortcodesToBuilder( dataObj.post_content, FusionPageBuilderApp.parentColumnId, false, false, targetElement, 'after' );
					} else {
						FusionPageBuilderApp.shortcodesToBuilder( dataObj.post_content, FusionPageBuilderApp.parentColumnId );
					}

					FusionApp.layoutIsLoading = false;

					jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).css( 'opacity', '1' );
					jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).prev( '#fusion-loader' ).hide();

					if ( isGlobal ) {
						setTimeout( fusionGlobalManager.handleGlobalsFromLibrary, 500, layoutID, FusionPageBuilderApp.parentColumnId );
					}
				} )
				.always( function() {
					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.added_custom_element + title );

					FusionEvents.trigger( 'fusion-content-changed' );
					self.removeView();
				} );
			},

			/**
			 * Adds an element.
			 *
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addModule: function( event ) {
				var $thisEl,
					label,
					params,
					multi,
					type,
					name,
					defaultParams,
					allowGenerator,
					currentModel,
					childUi,
					elementParams,
					MultiGlobalArgs;

				if ( event ) {
					event.preventDefault();
				}

				$thisEl = jQuery( event.currentTarget );
				label   = $thisEl.find( '.fusion_module_label' ).text();

				if ( label in fusionAllElements ) {

					defaultParams  = fusionAllElements[ label ].params;
					multi          = fusionAllElements[ label ].multi;
					type           = fusionAllElements[ label ].shortcode;
					name           = fusionAllElements[ label ].name;
					allowGenerator = fusionAllElements[ label ].allow_generator;
					childUi        = fusionAllElements[ label ].child_ui;

				} else {
					defaultParams = '';
					multi   = '';
					type   = '';
					allowGenerator = '';
				}

				params = {};

				// Process default parameters from shortcode
				_.each( defaultParams, function( param )  {
					params[ param.param_name ] = ( _.isObject( param.value ) ) ? param[ 'default' ] : param.value;
				} );

				elementParams = {
					type: 'element',
					added: 'manually',
					cid: FusionPageBuilderViewManager.generateCid(),
					element_type: type,
					params: params,
					parent: this.attributes[ 'data-parent_cid' ],
					view: this.options.view,
					allow_generator: allowGenerator,
					inline_editor: FusionPageBuilderApp.inlineEditorHelpers.inlineEditorAllowed( type ),
					multi: multi,
					child_ui: childUi,
					at_index: FusionPageBuilderApp.getCollectionIndex( this.options.targetElement )
				};

				if ( 'undefined' !== typeof this.options.targetElement ) {
					elementParams.targetElement = this.options.targetElement;
					elementParams.targetElementPosition = 'after';
				}

				currentModel = this.collection.add( [ elementParams ] );

				this.remove();

				// Handle multiple global elements.
				MultiGlobalArgs = {
					currentModel: currentModel[ 0 ],
					handleType: 'save',
					attributes: currentModel[ 0 ].attributes
				};
				fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.added + ' ' + name + ' ' + fusionBuilderText.element );

				FusionEvents.trigger( 'fusion-content-changed' );

			},

			/**
			 * Adds nested columns.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addNestedColumns: function( event ) {
				var moduleID,
					$layoutEl,
					layout,
					layoutElementsNum,
					innerRow,
					elementParams;

				if ( event ) {
					event.preventDefault();
				}

				moduleID = FusionPageBuilderViewManager.generateCid();

				elementParams = {
					type: 'fusion_builder_row_inner',
					element_type: 'fusion_builder_row_inner',
					added: 'manually',
					cid: moduleID,
					parent: this.model.get( 'cid' ),
					view: this,
					at_index: FusionPageBuilderApp.getCollectionIndex( this.options.targetElement )
				};

				if ( 'undefined' !== typeof this.options.targetElement ) {
					elementParams.targetElement = this.options.targetElement;
					elementParams.targetElementPosition = 'after';
				}

				this.collection.add( [ elementParams ] );

				innerRow = FusionPageBuilderViewManager.getView( moduleID );

				FusionPageBuilderApp.activeModal = 'column';

				$layoutEl         = jQuery( event.target ).is( 'li' ) ? jQuery( event.target ) : jQuery( event.target ).closest( 'li' );
				layout            = $layoutEl.data( 'layout' ).split( ',' );
				layoutElementsNum = _.size( layout );

				_.each( layout, function( element, index ) {
					var updateContent    = layoutElementsNum == ( index + 1 ) ? 'true' : 'false'; // jshint ignore: line
					innerRow.addNestedColumn( element, false );
				} );

				this.remove();

				FusionEvents.trigger( 'fusion-content-changed' );
				innerRow.setRowData();

				// Used to ensure if cancel that the columns are part of initial content.
				innerRow.updateSavedContent();

				if ( event ) {
					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.added_nested_columns );
					FusionEvents.trigger( 'fusion-content-changed' );
				}

				setTimeout( function() {
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-content-changed', innerRow.$el.closest( '.fusion-builder-column-outer' ).data( 'cid' ) );
				}, 300 );
			},

			/**
			 * Removes the view.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			removeView: function() {
				this.remove();
			}
		} );
	} );
}( jQuery ) );
;/* global FusionApp, FusionPageBuilderApp, fusionAppConfig, fusionBuilderText, FusionEvents, fusionAllElements, FusionPageBuilderViewManager, fusionHistoryState */
/* eslint no-unused-vars: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Column Library View
		FusionPageBuilder.ColumnLibraryView = window.wp.Backbone.View.extend( {

			className: 'fusion_builder_modal_settings',
			template: FusionPageBuilder.template( jQuery( '#fusion-builder-column-library-template' ).html() ),
			events: {
				'click .fusion-builder-column-layouts li': 'addColumns',
				'click .fusion_builder_custom_columns_load': 'addCustomColumn'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function( attributes ) {
				this.options = attributes;
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				this.$el.html( this.template( this.model.toJSON() ) );

				FusionPageBuilderApp.showSavedElements( 'columns', this.$el.find( '#custom-columns' ) );

				FusionApp.elementSearchFilter( this.$el );

				FusionApp.dialog.dialogTabs( this.$el );

				return this;
			},

			/**
			 * Adds a custom column.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addCustomColumn: function( event ) {
				var thisModel,
					layoutID,
					title,
					self = this,
					isGlobal;

				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.activeModal = 'column';

				if ( true === FusionPageBuilderApp.layoutIsLoading ) {
					return;
				}
				FusionPageBuilderApp.layoutIsLoading = true;

				thisModel = this.model;
				layoutID  = jQuery( event.currentTarget ).data( 'layout_id' );
				title     = jQuery( event.currentTarget ).find( '.fusion_module_title' ).text();
				isGlobal  = jQuery( event.currentTarget ).closest( 'li' ).hasClass( 'fusion-global' );

				jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).css( 'opacity', '0' );
				jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).prev( '#fusion-loader' ).show();

				jQuery.ajax( {
					type: 'POST',
					url: fusionAppConfig.ajaxurl,
					data: {
						action: 'fusion_builder_load_layout',
						fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
						fusion_is_global: isGlobal,
						fusion_layout_id: layoutID
					}
				} )
				.done( function( data ) {

					var dataObj = JSON.parse( data );

					FusionPageBuilderApp.shortcodesToBuilder( dataObj.post_content, FusionPageBuilderApp.parentRowId );

					FusionPageBuilderApp.layoutIsLoading = false;

					jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).css( 'opacity', '1' );
					jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).prev( '#fusion-loader' ).hide();

					if ( isGlobal ) {
						setTimeout( window.fusionGlobalManager.handleGlobalsFromLibrary, 500, layoutID, FusionPageBuilderApp.parentRowId );
					}

				} )
				.always( function() {

					// Unset 'added' attribute from newly created row model
					thisModel.unset( 'added' );

					// Save history state
					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.added_custom_column + title );

					FusionEvents.trigger( 'fusion-content-changed' );
					self.removeView();
				} );
			},

			/**
			 * Adds columns.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addColumns: function( event ) {

				var that,
					$layoutEl,
					layout,
					layoutElementsNum,
					thisView,
					defaultParams,
					params,
					value,
					rowView,
					updateContent,
					columnAttributes,
					columnCids = [],
					columnCid,
					columnView,
					atIndex,
					targetElement,
					lastCreated;

				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.activeModal = 'column';

				that              = this;
				$layoutEl         = jQuery( event.target ).is( 'li' ) ? jQuery( event.target ) : jQuery( event.target ).closest( 'li' );
				layout            = $layoutEl.data( 'layout' ).split( ',' );
				layoutElementsNum = _.size( layout );
				thisView          = this.options.view,
				targetElement     = ( 'undefined' !== typeof this.options.targetElement ) ? this.options.targetElement : false;

				atIndex = FusionPageBuilderApp.getCollectionIndex( targetElement );

				_.each( layout, function( element, index ) {

					// Get default settings
					defaultParams = fusionAllElements.fusion_builder_column.params;
					params        = {};
					columnCid     = FusionPageBuilderViewManager.generateCid();
					columnCids.push( columnCid );

					// Process default parameters from shortcode
					_.each( defaultParams, function( param )  {
						value = ( _.isObject( param.value ) ) ? param[ 'default' ] : param.value;
						params[ param.param_name ] = value;
					} );

					params.type = element;

					updateContent    = layoutElementsNum == ( index + 1 ) ? 'true' : 'false'; // jshint ignore: line
					columnAttributes = {
						type: 'fusion_builder_column',
						element_type: 'fusion_builder_column',
						cid: columnCid,
						parent: that.model.get( 'cid' ),
						view: thisView,
						params: params,
						at_index: atIndex
					};

					// Append to last created column
					if ( lastCreated ) {
						targetElement = FusionPageBuilderViewManager.getView( lastCreated );
						targetElement = targetElement.$el;
					}

					if ( targetElement ) {
						columnAttributes.targetElement = targetElement;
						columnAttributes.targetElementPosition = 'after';
					}

					FusionPageBuilderApp.collection.add( [ columnAttributes ] );

					lastCreated = columnCid;

					if ( 'new' === atIndex ) {
						atIndex = 1;
					} else {
						atIndex++;
					}
				} );

				// Unset 'added' attribute from newly created row model
				this.model.unset( 'added' );

				// Update view column calculations.
				rowView = FusionPageBuilderViewManager.getView( FusionPageBuilderApp.parentRowId );

				if ( rowView ) {
					rowView.createVirtualRows();
					rowView.updateColumnsPreview();
				}

				FusionEvents.trigger( 'fusion-content-changed' );
				this.removeView();

				if ( event ) {

					_.each( columnCids, function( cid ) {
						columnView = FusionPageBuilderViewManager.getView( cid );
						if ( columnView ) {
							columnView.scrollHighlight( cid === columnCid );
						}
					} );

					// Save history state
					if ( true === FusionPageBuilderApp.newContainerAdded ) {
						window.fusionHistoryState = fusionBuilderText.added_section; // jshint ignore: line
						FusionPageBuilderApp.newContainerAdded = false;
					} else {
						window.fusionHistoryState = fusionBuilderText.added_columns; // jshint ignore: line
					}

					FusionEvents.trigger( 'fusion-history-save-step', window.fusionHistoryState );
				}
			},

			/**
			 * Removes the view.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			removeView: function() {
				this.remove();
			}
		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderViewManager, fusionBuilderText, FusionEvents, FusionApp */
/* eslint no-unused-vars: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Elements View
		FusionPageBuilder.NestedColumnLibraryView = window.wp.Backbone.View.extend( {

			className: 'fusion-builder-modal-settings-container',

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-column-library-template' ).html() ),

			events: {
				'click .fusion-builder-column-layouts li': 'addNestedColumns',
				'click .fusion-builder-modal-close': 'closeModal'
			},

			initialize: function( attributes ) {
				this.options = attributes;
				this.listenTo( FusionEvents, 'fusion-modal-view-removed', this.remove );
			},

			render: function() {
				this.$el.html( this.template( this.options ) );
				this.$el.addClass( 'fusion-add-to-nested' );

				FusionApp.elementSearchFilter( this.$el );

				return this;
			},

			addNestedColumns: function( event ) {
				var $layoutEl,
					layout,
					layoutElementsNum,
					appendAfter,
					innerRow,
					innerColumn,
					targetElement,
					parent = this.attributes[ 'data-parent_cid' ],
					atIndex,
					lastCreatedCid,
					lastCreatedView;

				if ( event ) {
					event.preventDefault();
				}

				innerRow = FusionPageBuilderViewManager.getView( parent );

				if ( 'undefined' !== typeof this.attributes[ 'data-nested_column_cid' ] ) {
					innerColumn = FusionPageBuilderViewManager.getView( this.attributes[ 'data-nested_column_cid' ] );
					appendAfter = innerColumn.$el;
					targetElement = innerColumn.$el;
				} else {
					appendAfter = ( this.$el ).closest( '.fusion-builder-row-content' ).find( '.fusion-builder-row-container-inner' );
				}

				atIndex = window.FusionPageBuilderApp.getCollectionIndex( targetElement );

				$layoutEl         = jQuery( event.target ).is( 'li' ) ? jQuery( event.target ) : jQuery( event.target ).closest( 'li' );
				layout            = $layoutEl.data( 'layout' ).split( ',' );
				layoutElementsNum = _.size( layout );

				_.each( layout, function( element, index ) { // jshint ignore:line
					lastCreatedCid  = innerRow.addNestedColumn( element, appendAfter, targetElement, atIndex );
					lastCreatedView = FusionPageBuilderViewManager.getView( lastCreatedCid );
					targetElement   = lastCreatedView.$el;
					atIndex++;
				} );

				innerRow.createVirtualRows();
				innerRow.updateColumnsPreview();

				this.remove();

				FusionEvents.trigger( 'fusion-columns-added' );

				if ( event ) {

					// Save history state
					FusionEvents.trigger( 'fusion-history-turn-on-tracking' );
					window.fusionHistoryState = fusionBuilderText.added_nested_columns;

					FusionEvents.trigger( 'fusion-content-changed' );
				}
			},

			closeModal: function( event ) {
				event.preventDefault();

				this.remove();
			}
		} );
	} );
}( jQuery ) );
;/* global FusionApp, FusionPageBuilderApp, fusionAllElements, FusionPageBuilderViewManager, FusionEvents, fusionHistoryState, fusionAppConfig, fusionBuilderText, fusionGlobalManager */
/* eslint no-unused-vars: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Column Library View
		FusionPageBuilder.ContainerLibraryView = window.wp.Backbone.View.extend( {

			className: 'fusion_builder_modal_settings',
			template: FusionPageBuilder.template( jQuery( '#fusion-builder-container-library-template' ).html() ),
			events: {
				'click .fusion-builder-column-layouts li': 'addColumns',
				'click .fusion_builder_custom_sections_load': 'addCustomSection',
				'click .fusion-builder-section-next-page': 'addNextPage'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function( attributes ) {
				this.options = attributes;
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				this.$el.html( this.template( this.model.toJSON() ) );

				// Show saved custom sections
				FusionPageBuilderApp.showSavedElements( 'sections', this.$el.find( '#custom-sections' ) );

				FusionApp.elementSearchFilter( this.$el );

				FusionApp.dialog.dialogTabs( this.$el );

				return this;
			},

			/**
			 * Adds columns.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addColumns: function( event ) {

				var that,
					$layoutEl,
					layout,
					layoutElementsNum,
					thisView,
					defaultParams,
					params,
					value,
					rowView,
					updateContent,
					columnAttributes,
					columnCids = [],
					columnCid,
					columnView;

				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.activeModal = 'column';

				that              = this;
				$layoutEl         = jQuery( event.target ).is( 'li' ) ? jQuery( event.target ) : jQuery( event.target ).closest( 'li' );
				layout            = '' !== $layoutEl.data( 'layout' ) ? $layoutEl.data( 'layout' ).split( ',' ) : false;
				layoutElementsNum = _.size( layout );
				thisView          = this.options.view;

				// Create row columns.
				if ( layout ) {
					_.each( layout, function( element, index ) {

						// Get default settings
						defaultParams = fusionAllElements.fusion_builder_column.params;
						params        = {};
						columnCid     = FusionPageBuilderViewManager.generateCid();
						columnCids.push( columnCid );

						// Process default parameters from shortcode
						_.each( defaultParams, function( param )  {
							value = ( _.isObject( param.value ) ) ? param[ 'default' ] : param.value;
							params[ param.param_name ] = value;
						} );

						params.type = element;

						updateContent    = layoutElementsNum == ( index + 1 ) ? 'true' : 'false'; // jshint ignore: line
						columnAttributes = {
							type: 'fusion_builder_column',
							element_type: 'fusion_builder_column',
							cid: columnCid,
							parent: that.model.get( 'cid' ),
							view: thisView,
							params: params
						};

						that.collection.add( [ columnAttributes ] );

					} );
				}

				// Unset 'added' attribute from newly created row model
				this.model.unset( 'added' );

				// Update view column calculations.
				rowView = FusionPageBuilderViewManager.getView( FusionPageBuilderApp.parentRowId );
				rowView.setRowData();

				FusionEvents.trigger( 'fusion-content-changed' );
				this.removeView();

				if ( event ) {

					_.each( columnCids, function( cid ) {
						columnView = FusionPageBuilderViewManager.getView( cid );
						if ( columnView ) {
							columnView.scrollHighlight( cid === columnCid );
						}
					} );

					// Save history state
					if ( true === FusionPageBuilderApp.newContainerAdded ) {
						window.fusionHistoryState = fusionBuilderText.added_section; // jshint ignore: line
						FusionPageBuilderApp.newContainerAdded = false;
					} else {
						window.fusionHistoryState = fusionBuilderText.added_columns; // jshint ignore: line
					}

					FusionEvents.trigger( 'fusion-history-save-step', window.fusionHistoryState );

					jQuery( '.fusion-builder-live' ).removeClass( 'fusion-builder-blank-page-active' );
				}
			},

			/**
			 * Adds a custom section.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addCustomSection: function( event ) {
				var thisModel  = this.model,
					parentID   = this.model.get( 'parent' ),
					parentView = FusionPageBuilderViewManager.getView( parentID ),
					self       = this,
					layoutID,
					title,
					targetContainer,
					isGlobal;

				targetContainer = parentView.$el.prev( '.fusion-builder-container' );
				FusionPageBuilderApp.targetContainerCID = targetContainer.data( 'cid' );

				if ( event ) {
					event.preventDefault();
				}

				if ( 'undefined' !== typeof parentView ) {
					parentView.removeContainer();
				}

				if ( true === FusionPageBuilderApp.layoutIsLoading ) {
					return;
				}

				FusionPageBuilderApp.layoutIsLoading = true;

				layoutID = jQuery( event.currentTarget ).data( 'layout_id' );
				title    = jQuery( event.currentTarget ).find( '.fusion_module_title' ).text();
				isGlobal = jQuery( event.currentTarget ).closest( 'li' ).hasClass( 'fusion-global' );

				jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).css( 'opacity', '0' );
				jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).prev( '#fusion-loader' ).show();

				jQuery.ajax( {
					type: 'POST',
					url: fusionAppConfig.ajaxurl,
					data: {
						action: 'fusion_builder_load_layout',
						fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
						fusion_is_global: isGlobal,
						fusion_layout_id: layoutID
					}
				} )
				.done( function( data ) {
					var dataObj = JSON.parse( data );

					FusionPageBuilderApp.shortcodesToBuilder( dataObj.post_content, FusionPageBuilderApp.parentRowId );

					FusionPageBuilderApp.layoutIsLoading = false;

					jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).css( 'opacity', '1' );
					jQuery( event.currentTarget ).parent( '.fusion-builder-all-modules' ).prev( '#fusion-loader' ).hide();

					if ( isGlobal ) {
						setTimeout( fusionGlobalManager.handleGlobalsFromLibrary, 500, layoutID, FusionPageBuilderApp.parentRowId );
					}

				} )
				.always( function() {

					// Unset 'added' attribute from newly created section model
					thisModel.unset( 'added' );

					// Save history state
					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.added_custom_section + title );

					jQuery( '.fusion-builder-live' ).removeClass( 'fusion-builder-blank-page-active' );

					FusionEvents.trigger( 'fusion-content-changed' );
					self.removeView();
				} );
			},

			/**
			 * Adds the "next page".
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			addNextPage: function( event ) {
				var parentID   = this.model.get( 'parent' ),
					parentView = FusionPageBuilderViewManager.getView( parentID ),
					targetContainer,
					moduleID,
					params = {};

				if ( event ) {
					event.preventDefault();
				}

				targetContainer = parentView.$el.prev( '.fusion-builder-container' );
				FusionPageBuilderApp.targetContainerCID = targetContainer.find( '.fusion-builder-data-cid' ).data( 'cid' );
				moduleID = FusionPageBuilderViewManager.generateCid();

				this.collection.add( [
					{
						type: 'fusion_builder_next_page',
						added: 'manually',
						module_type: 'fusion_builder_next_page',
						cid: moduleID,
						params: params,
						view: parentView,
						appendAfter: targetContainer,
						created: 'auto'
					}
				] );

				if ( 'undefined' !== typeof parentView ) {
					FusionPageBuilderApp.targetContainerCID = '';
					parentView.removeContainer();
				}

				FusionEvents.trigger( 'fusion-content-changed' );

				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.added_nextpage );

				this.removeView();

			},

			/**
			 * Removes the view.
			 *
			 * @since 4.0.0
			 * @return {void}
			 */
			removeView: function() {
				this.remove();
			}
		} );
	} );
}( jQuery ) );
;/* global FusionEvents, FusionPageBuilderViewManager, fusionAllElements, tinyMCE, FusionPageBuilderApp, fusionBuilderInsertIntoEditor, FusionApp */
/* eslint no-unused-vars: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Generator elements library
		FusionPageBuilder.GeneratorElementsView = window.wp.Backbone.View.extend( {

			className: 'fusion_builder_modal_settings',
			template: FusionPageBuilder.template( jQuery( '#fusion-builder-generator-modules-template' ).html() ),

			events: {
				'click .fusion-builder-all-modules .fusion-builder-element': 'addElement',
				'click .fusion-builder-column-layouts .generator-column': 'addColumns',
				'click .fusion-builder-column-layouts .generator-section': 'addContainer'
			},

			initialize: function( attributes ) {
				this.options = attributes;
				this.listenTo( FusionEvents, 'fusion-modal-view-removed', this.remove );
			},

			render: function() {

				this.$el.html( this.template( FusionPageBuilderApp.elements ) );

				FusionApp.elementSearchFilter( this.$el );

				FusionApp.dialog.dialogTabs( this.$el );

				return this;
			},

			addElement: function( event ) {
				var $thisEl,
					title,
					label,
					params,
					multi,
					type,
					selection,
					defaultParams,
					elementSettings;

				if ( event ) {
					event.preventDefault();
				}

				$thisEl = jQuery( event.currentTarget );
				title   = $thisEl.find( '.fusion_module_title' ).text();
				label   = $thisEl.find( '.fusion_module_label' ).text();

				if ( label in fusionAllElements ) {

					multi = fusionAllElements[ label ].multi;
					type  = fusionAllElements[ label ].shortcode;

				} else {

					params = '';
					multi  = '';
					type   = '';
				}

				// Get default settings
				defaultParams = jQuery.extend( true, {}, fusionAllElements[ label ].params );
				params = {};

				// Process default parameters from shortcode
				_.each( defaultParams, function( param )  {
					var value;
					if ( _.isObject( param.value ) ) {
						value = param[ 'default' ];
					} else {
						value = param.value;
					}
					params[ param.param_name ] = value;
				} );

				elementSettings = {
					type: 'generated_element',
					added: 'manually',
					element_type: type,
					params: params,
					view: this.options.view,
					multi: multi,
					target: this.options.targetCid,
					cid: FusionPageBuilderViewManager.generateCid()
				};
				if ( 'undefined' !== params.element_content && 'undefined' !== typeof tinyMCE && 'undefined' !== tinyMCE.activeEditor && 'undefined' === typeof multi && window.tinyMCE.activeEditor ) {

					selection = window.tinyMCE.activeEditor.selection.getContent();

					if ( selection ) {

						elementSettings.params.element_content = selection;

						window.tinyMCE.activeEditor.selection.setContent( '' );
						selection = '';

						delete elementSettings.added;
					}
				}

				this.collection.add( elementSettings );

				// Reset shortcode generator.
				FusionPageBuilderApp.shortcodeGenerator         = '';
				FusionPageBuilderApp.shortcodeGeneratorEditorID = '';

				this.remove();
			},

			addColumns: function( event ) {
				var that,
					$layoutEl,
					layout,
					layoutElementsNum,
					thisView,
					defaultParams,
					params,
					value,
					columnModel,
					generatedShortcode = '[fusion_builder_row_inner]',
					elementType        = 'fusion_builder_column_inner',
					closingTag         = '[/fusion_builder_row_inner]';

				if ( ! FusionPageBuilderApp.builderActive && jQuery( event.target ).closest( '#builder-regular-columns' ).length ) {
					generatedShortcode = '';
					elementType = 'fusion_builder_column';
					closingTag = '';
				}
				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.activeModal = 'column';

				that              = this;
				$layoutEl         = jQuery( event.target ).is( 'li' ) ? jQuery( event.target ) : jQuery( event.target ).closest( 'li' );
				layout            = $layoutEl.data( 'layout' ).split( ',' );
				layoutElementsNum = _.size( layout );
				thisView          = this.options.view;

				// Get default settings
				defaultParams = fusionAllElements[ elementType ].params;
				params = {};

				// Process default parameters from shortcode
				_.each( defaultParams, function( param )  {
					if ( _.isObject( param.value ) ) {
						value = param[ 'default' ];
					} else {
						value = param.value;
					}
					params[ param.param_name ] = value;
				} );

				_.each( layout, function( element, index ) {

					var updateContent,
						columnAttributes;

					params.type = element;

					updateContent    = layoutElementsNum === ( index + 1 ) ? 'true' : 'false';
					columnAttributes = {
						type: 'generated_element',
						added: 'manually',
						element_type: elementType,
						view: thisView,
						params: params
					};

					columnModel = that.collection.add( columnAttributes );

					generatedShortcode += FusionPageBuilderApp.generateElementShortcode( columnModel, false, true );

				} );

				generatedShortcode += closingTag;

				fusionBuilderInsertIntoEditor( generatedShortcode, FusionPageBuilderApp.shortcodeGeneratorEditorID );

				// Reset shortcode generator
				FusionPageBuilderApp.shortcodeGenerator = '';
				FusionPageBuilderApp.shortcodeGeneratorEditorID = '';

				this.remove();
			},

			addContainer: function( event ) {
				var elementID,
					defaultParams,
					params,
					value;

				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.activeModal = 'container';

				elementID     = FusionPageBuilderViewManager.generateCid();
				defaultParams = fusionAllElements.fusion_builder_container.params;
				params        = {};

				// Process default parameters from shortcode
				_.each( defaultParams, function( param ) {
					if ( _.isObject( param.value ) ) {
						value = param[ 'default' ];
					} else {
						value = param.value;
					}
					params[ param.param_name ] = value;
				} );

				this.collection.add( [
					{
						type: 'generated_element',
						added: 'manually',
						element_type: 'fusion_builder_container',
						params: params,
						view: this
					}
				] );
			}

		} );

	} );

}( jQuery ) );
;/* global fusionGlobalManager, fusionBuilderText, fusionAllElements, FusionEvents, FusionPageBuilderViewManager, FusionPageBuilderApp, FusionPageBuilderElements, FusionApp */
/* eslint no-unused-vars: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function( $ ) {

	$( document ).ready( function() {

		// Nested Column View
		FusionPageBuilder.NestedColumnView = FusionPageBuilder.BaseColumnView.extend( {

			template: FusionPageBuilder.template( $( '#fusion-builder-inner-column-template' ).html() ),

			events: {
				'click .fusion-builder-add-element': 'addModule',
				'click .fusion-builder-settings-column': 'settings',
				'click .fusion-builder-column-remove': 'removeColumn',
				'click .fusion-builder-column-clone': 'cloneColumn',
				'click .fusion-builder-column-size': 'sizesShow',
				'click .column-size': 'sizeSelectWirefame',
				'click .fusion-builder-column-drag': 'preventDefault'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
				this.$el.attr( 'data-cid', this.model.get( 'cid' ) );
				this.$el.attr( 'data-column-size', this.model.attributes.params.type );

				if ( 'undefined' !== typeof this.model.attributes.params && 'undefined' !== typeof this.model.attributes.params.fusion_global ) {
					this.$el.attr( 'fusion-global-layout', this.model.attributes.params.fusion_global );
					this.$el.removeClass( 'fusion-global-nested-column' ).addClass( 'fusion-global-nested-column' );
				}

				this.columnSpacer        = false;
				this.forceAppendChildren = false;

				this.listenTo( FusionEvents, 'fusion-view-update-fusion_builder_column_inner', this.reRender );

				this.baseColumnInit();
				this.baseInit();
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var self = this,
					data = this.getTemplateAtts();

				this.$el.html( this.template( data ) );

				if ( 'undefined' !== typeof this.model.attributes.selectors ) {
					this.setElementAttributes( this.$el, this.model.attributes.selectors );
				}

				this.appendChildren();

				setTimeout( function() {
					self.droppableColumn();
					self.sortableElements();
					self.disableSortableElements();
				}, 100 );

				return this;
			},

			droppableColumn: function() {
				var self        = this,
					$el         = this.$el,
					cid         = this.model.get( 'cid' ),
					$droppables = $el.find( '.fusion-nested-column-target' ),
					$body       = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' );

				$el.draggable( {
					appendTo: FusionPageBuilderApp.$el,
					zIndex: 999999,
					delay: 100,
					cursorAt: { top: 15, left: 15 },
					iframeScroll: true,
					containment: $body,
					cancel: '.fusion-builder-live-element',
					helper: function() {
						var $classes = FusionPageBuilderApp.DraggableHelpers.draggableClasses( cid );
						return jQuery( '<div class="fusion-column-helper ' + $classes + '" data-cid="' + cid + '"><span class="fusiona-column"></span></div>' );
					},
					start: function() {
						$body.addClass( 'fusion-nested-column-dragging fusion-active-dragging' );
						$el.addClass( 'fusion-being-dragged' );
					},
					stop: function() {
						setTimeout( function() {
							$body.removeClass( 'fusion-nested-column-dragging fusion-active-dragging' );
						}, 10 );
						$el.removeClass( 'fusion-being-dragged' );
					}
				} );

				$droppables.droppable( {
					tolerance: 'touch',
					hoverClass: 'ui-droppable-active',
					accept: '.fusion-builder-column-inner',
					drop: function( event, ui ) {
						var parentCid,
							destinationRow,
							columnCid      = ui.draggable.data( 'cid' ),
							columnView     = FusionPageBuilderViewManager.getView( columnCid ),
							originalCid    = columnView.model.get( 'parent' ),
							$target        = $el,
							originalView,
							newIndex;

						if ( 'large' !== FusionApp.getPreviewWindowSize() && 'undefined' !== typeof self.isFlex && true === self.isFlex ) {

							// Update columns' order.
							FusionPageBuilderViewManager.getView( self.model.get( 'parent' ) )._updateResponsiveColumnsOrder(
								ui.draggable,
								$target.closest( '.fusion-builder-row' ).children( '.fusion-builder-column-inner' ),
								parseInt( jQuery( event.target ).closest( '.fusion-builder-column-inner' ).data( 'cid' ) ),
								jQuery( event.target ).hasClass( 'target-after' )
							);

							return;
						}

						// Move the actual html.
						if ( jQuery( event.target ).hasClass( 'target-after' ) ) {
							$target.after( ui.draggable );
						} else {
							$el.before( ui.draggable );
						}

						parentCid      = ui.draggable.closest( '.fusion-builder-row-content' ).data( 'cid' );
						destinationRow = FusionPageBuilderViewManager.getView( parentCid );

						newIndex = ui.draggable.parent().children( '.fusion-builder-column-inner' ).index( ui.draggable );
						FusionPageBuilderApp.onDropCollectionUpdate( columnView.model, newIndex, parentCid );

						// Update destination row which is this current one.
						destinationRow.setRowData();

						// If destination row and original row are different, update original as well.
						if ( parentCid !== originalCid ) {
							originalView = FusionPageBuilderViewManager.getView( originalCid );
							originalView.setRowData();
						}

						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.column + ' order changed' );

						setTimeout( function() {
							// If different container type we re-render so that it corrects for new situation.
							if ( 'object' !== typeof originalView || FusionPageBuilderApp.sameContainerTypes( originalView.model.get( 'parent' ), destinationRow.model.get( 'parent' ) ) ) {
								columnView.droppableColumn();
							} else {
								FusionEvents.trigger( 'fusion-close-settings-' + columnView.model.get( 'cid' ) );
								columnView.reRender();
							}
						}, 300 );
					}
				} );

				$el.find( '.fusion-element-target-column' ).droppable( {
					tolerance: 'touch',
					hoverClass: 'ui-droppable-active',
					accept: '.fusion-builder-live-element',
					drop: function( event, ui ) {
						var parentCid   = self.model.get( 'cid' ),
							elementCid  = ui.draggable.data( 'cid' ),
							elementView = FusionPageBuilderViewManager.getView( elementCid ),
							newIndex,
							MultiGlobalArgs;

						// Move the actual html.
						$el.find( '.fusion-nested-column-content' ).append( ui.draggable );

						newIndex = ui.draggable.parent().children( '.fusion-builder-live-element' ).index( ui.draggable );

						FusionPageBuilderApp.onDropCollectionUpdate( elementView.model, newIndex, parentCid );

						// Save history state
						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.moved + ' ' + fusionAllElements[ elementView.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );

						// Handle multiple global elements.
						MultiGlobalArgs = {
							currentModel: elementView.model,
							handleType: 'save',
							attributes: elementView.model.attributes
						};
						fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

						FusionEvents.trigger( 'fusion-content-changed' );

						self._equalHeights();
					}
				} );

				// If we are in wireframe mode, then disable.
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.disableDroppableColumn();
				}
			},

			/**
			 * Destroy the droppable and draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			disableDroppableColumn: function() {
				var $el         = this.$el,
					$droppables = $el.find( '.fusion-column-target' );

				if ( 'undefined' !== typeof $el.draggable( 'instance' ) ) {
					$el.draggable( 'destroy' );
				}

				if ( 'undefined' !== typeof $droppables.droppable( 'instance' ) ) {
					$droppables.droppable( 'destroy' );
				}

				if ( 'undefined' !== typeof $el.find( '.fusion-element-target-column' ).droppable( 'instance' ) ) {
					$el.find( '.fusion-element-target-column' ).droppable( 'destroy' );
				}
			},

			/**
			 * Enable the droppable and draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			enableDroppableColumn: function() {
				this.droppableColumn();
			},

			/**
			 * Triggers a refresh.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			refreshJs: function() {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-element-render-fusion_builder_column_inner', this.model.attributes.cid );
			},

			/**
			 * Sets the attributes of an element.
			 *
			 * @since 2.0.0
			 * @param {Object} element - The element we're updating.
			 * @param {Object} attributes - The attributes we're setting/updating.
			 * @return {void}
			 */
			setElementAttributes: function( element, attributes ) {
				if ( 'object' === typeof attributes && element.length ) {
					_.each( attributes, function( values, attribute ) {
						if ( 'class' === attribute ) {
							element.addClass( values );
						} else if ( 'id' === attribute ) {
							element.attr( 'id', values );
						} else if ( 'style' === attribute ) {
							element.attr( 'style', values );
						} else if ( -1 !== attribute.indexOf( 'data' ) ) {
							attribute = attribute.replace( /_/g, '-' );
							element.attr( attribute, values );
						}
					} );
				}
			},

			/**
			 * Removes a column.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the column removal.
			 * @return {void}
			 */
			removeColumn: function( event ) {
				var modules,
					row = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) ),
					parentCid = this.$el.closest( '.fusion-builder-column-outer' ).data( 'cid' );

				if ( event ) {
					event.preventDefault();
				}

				setTimeout( function() {
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-content-changed', parentCid );
				}, 300 );

				modules = FusionPageBuilderViewManager.getChildViews( this.model.get( 'cid' ) );

				_.each( modules, function( module ) {
					module.removeElement();
				} );

				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				FusionEvents.trigger( 'fusion-element-removed', this.model.get( 'cid' ) );

				this.model.destroy();

				this.remove();

				row.setRowData();

				// If the column is deleted manually
				if ( event ) {
					FusionEvents.trigger( 'fusion-content-changed' );
				}
			},

			/**
			 * Appends children to the columns.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			appendChildren: function() {
				var self = this,
					cid,
					view;

				this.model.children.each( function( child ) {

					cid  = child.attributes.cid;
					view = FusionPageBuilderViewManager.getView( cid );

					self.$el.find( '.fusion-builder-column-content' ).append( view.$el );

					view.delegateEvents();
				} );
			},

			/**
			 * Adds a child view.
			 *
			 * @since 2.0.0
			 * @param {Object} element - The element.
			 * @return {void}
			 */
			addChildView: function( element ) {

				var view,
					viewSettings = {
						model: element,
						collection: FusionPageBuilderElements,
						attributes: {
							'data-cid': element.get( 'cid' )
						}
					};

				if ( 'undefined' !== typeof element.get( 'multi' ) && 'multi_element_parent' === element.get( 'multi' ) ) {

					if ( 'undefined' !== typeof FusionPageBuilder[ element.get( 'element_type' ) ] ) {
						view = new FusionPageBuilder[ element.get( 'element_type' ) ]( viewSettings );
					} else {
						view = new FusionPageBuilder.ParentElementView( viewSettings );
					}

				} else if ( 'undefined' !== typeof FusionPageBuilder[ element.get( 'element_type' ) ] ) {
					view = new FusionPageBuilder[ element.get( 'element_type' ) ]( viewSettings );
				} else {
					view = new FusionPageBuilder.ElementView( viewSettings );
				}

				// Add new view to manager
				FusionPageBuilderViewManager.addView( element.get( 'cid' ), view );

				// Add element builder view to proper column
				if (  'undefined' !== typeof this.model && 'fusion_builder_column_inner' === this.model.get( 'type' ) ) {

					if ( ! _.isUndefined( element.get( 'targetElement' ) ) && 'undefined' === typeof element.get( 'from' ) ) {
						if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'after' === element.get( 'targetElementPosition' ) ) {
							element.get( 'targetElement' ).after( view.render().el );
						} else {
							element.get( 'targetElement' ).before( view.render().el );
						}
					} else if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'end' === element.get( 'targetElementPosition' ) ) {
						this.$el.find( '.fusion-builder-column-content.fusion-nested-column-content' ).append( view.render().el );
					} else {
						this.$el.find( '.fusion-builder-column-content.fusion-nested-column-content' ).find( '.fusion-builder-empty-column' ).after( view.render().el );
					}

				} else if ( ! _.isUndefined( element.get( 'targetElement' ) ) && 'undefined' === typeof element.get( 'from' ) ) {
					if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'after' === element.get( 'targetElementPosition' ) ) {
						element.get( 'targetElement' ).after( view.render().el );
					} else {
						element.get( 'targetElement' ).before( view.render().el );
					}
				} else if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'end' === element.get( 'targetElementPosition' ) ) {
					this.$el.find( '.fusion-builder-column-content.fusion-nested-column-content' ).append( view.render().el );
				} else {
					this.$el.find( '.fusion-builder-column-content.fusion-nested-column-content' ).find( '.fusion-builder-empty-column' ).after( view.render().el );
				}

				// Check if we should open the settings or not.
				if ( 'off' !== FusionApp.preferencesData.open_settings && 'undefined' !== typeof element.get( 'added' ) ) {
					view.settings();
				}
			},

			/**
			 * Clones a column.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			cloneColumn: function( event ) {
				var columnAttributes = jQuery.extend( true, {}, this.model.attributes ),
					row              = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) ),
					$thisColumn;

				if ( event ) {
					event.preventDefault();
				}

				columnAttributes.created       = 'manually';
				columnAttributes.cid           = FusionPageBuilderViewManager.generateCid();
				columnAttributes.targetElement = this.$el;
				columnAttributes.cloned        = true;
				columnAttributes.at_index      = FusionPageBuilderApp.getCollectionIndex( this.$el );

				FusionPageBuilderApp.collection.add( columnAttributes );

				// Parse column elements
				$thisColumn = this.$el;
				$thisColumn.find( '.fusion-builder-live-element' ).each( function() {
					var $thisModule,
						moduleCID,
						module,
						elementAttributes;

					// Standard element
					if ( jQuery( this ).hasClass( 'fusion-builder-live-element' ) ) {
						$thisModule = jQuery( this );
						moduleCID = 'undefined' === typeof $thisModule.data( 'cid' ) ? $thisModule.find( '.fusion-builder-data-cid' ).data( 'cid' ) : $thisModule.data( 'cid' );

						// Get model from collection by cid
						module = FusionPageBuilderElements.find( function( model ) {
							return model.get( 'cid' ) == moduleCID; // jshint ignore: line
						} );

						// Clone model attritubes
						elementAttributes         = jQuery.extend( true, {}, module.attributes );

						elementAttributes.created = 'manually';
						elementAttributes.cid     = FusionPageBuilderViewManager.generateCid();
						elementAttributes.parent  = columnAttributes.cid;
						elementAttributes.from    = 'fusion_builder_column_inner';

						// Don't need target element, position is defined from order.
						delete elementAttributes.targetElementPosition;

						FusionPageBuilderApp.collection.add( elementAttributes );
					}

				} );

				// If column is cloned manually
				if ( event ) {

					// Save history state
					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.cloned + ' ' + fusionBuilderText.column );

					row.createVirtualRows();
					row.updateColumnsPreview();

					FusionEvents.trigger( 'fusion-content-changed' );
				}
				this._refreshJs();
			},

			/**
			 * Changes the column size.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			sizeSelectWirefame: function( event ) {
				var $thisEl = false,

					// Get current column size
					size = this.model.attributes.params.type,

					// New column size.
					newSize = '',

					// New column size text.
					columnNewSizeText = '',

					// New fraction size.
					fractionNewSize = '',

					columnSizeText = this.getColumnSizeText( size ),
					innerColumnsString = '',
					innerRowWrapper = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );

				if ( 'undefined' === typeof event ) {
					return;
				}

				event.preventDefault();

				$thisEl = jQuery( event.currentTarget );
				newSize = $thisEl.attr( 'data-column-size' );

				if ( 'undefined' !== typeof newSize ) {

					fractionNewSize   = newSize.replace( '_', '/' );
					columnNewSizeText = this.getColumnSizeText( newSize ),

					// Set new size.
					this.$el.attr( 'data-column-size', newSize );

					// Change css size class.
					this.$el.removeClass( columnSizeText );
					this.$el.removeClass( size );
					this.$el.removeClass( 'fusion-builder-column-' + size );
					this.$el.removeClass( 'fusion_builder_column_' + size );
					this.$el.removeClass( 'fusion_builder_column_inner_' + size );

					this.$el.addClass( columnNewSizeText );
					this.$el.addClass( newSize );
					this.$el.addClass( 'fusion-builder-column-' + newSize );
					this.$el.addClass( 'fusion_builder_column_' + newSize );

					this.$el.find( '.fusion-builder-resize-inner-column' ).text( fractionNewSize );

					setTimeout( function() {
						innerRowWrapper.$el.find( '.fusion-builder-column-inner' ).each( function() {
							innerColumnsString += jQuery( this ).attr( 'data-column-size' ).replace( '_', '/' ) + ' + ';
						} );

						innerRowWrapper.$el.find( '.fusion-builder-module-preview p' ).html( innerColumnsString.slice( 0, innerColumnsString.length - 3 ) );
					}, 100 );
				}

				this.sizeSelect( event );
			},

			/**
			 * Returns the colum size class name.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			getColumnSizeText: function( size ) {
				var sizeText = '';
				switch ( size ) {
				case '1_1':
					sizeText = 'fusion-one-full';
					break;
				case '1_4':
					sizeText = 'fusion-one-fourth';
					break;
				case '3_4':
					sizeText = 'fusion-three-fourth';
					break;
				case '1_2':
					sizeText = 'fusion-one-half';
					break;
				case '1_3':
					sizeText = 'fusion-one-third';
					break;
				case '2_3':
					sizeText = 'fusion-two-third';
					break;
				case '1_5':
					sizeText = 'fusion-one-fifth';
					break;
				case '2_5':
					sizeText = 'fusion-two-fifth';
					break;
				case '3_5':
					sizeText = 'fusion-three-fifth';
					break;
				case '4_5':
					sizeText = 'fusion-four-fifth';
					break;
				case '5_6':
					sizeText = 'fusion-five-sixth';
					break;
				case '1_6':
					sizeText = 'fusion-one-sixth';
					break;
				}

				return sizeText;
			},

			/**
			 * Things to do, places to go when options change.
			 *
			 * @since 2.0.0
			 * @param {string} paramName - The name of the parameter that changed.
			 * @param {mixed}  paramValue - The value of the option that changed.
			 * @param {Object} event - The event triggering the option change.
			 * @return {void}
			 */
			onOptionChange: function( paramName, paramValue, event ) {
				var rowView,
					parentCID = this.model.get( 'parent' ),
					cid = this.model.get( 'cid' ),
					reInitDraggables = false;

				// Reverted to history step or user entered value manually.
				if ( 'undefined' === typeof event || ( 'undefined' !== typeof event && ( 'change' !== event.type || ( 'change' === event.type && 'undefined' !== typeof event.srcElement ) ) ) ) {
					reInitDraggables = true;
				}

				switch ( paramName ) {

				case 'spacing':
					this.model.attributes.params[ paramName ] = paramValue;

					// Only update preview if it a valid unit.
					if ( this.validColumnSpacing( paramValue ) ) {
						rowView = FusionPageBuilderViewManager.getView( parentCID );
						rowView.setSingleRowData( cid );
					}

					if ( true === reInitDraggables ) {
						if ( 'yes' === paramValue || 'no' === paramValue ) {
							this.destroySpacingResizable();
						} else {
							this.columnSpacer = false;
							this.columnSpacing();
						}
					}

					break;

				case 'margin_top':
				case 'margin_bottom':
					this.model.attributes.params[ paramName ] = paramValue;

					if ( true === reInitDraggables ) {
						this.destroyMarginResizable();
						this.marginDrag();
					}
					break;

				case 'padding_top':
				case 'padding_right':
				case 'padding_bottom':
				case 'padding_left':
					this.model.attributes.params[ paramName ] = paramValue;

					if ( true === reInitDraggables ) {
						this.destroyPaddingResizable();
						this.paddingDrag();
					}
					break;
				}
			},

			/**
			 * Initialize element sortable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			sortableElements: function() {
				var self = this;

				this.$el.find( '.fusion-builder-column-content' ).sortable( {
					items: '.fusion-builder-live-element',
					connectWith: '.fusion-builder-column-inner .fusion-builder-column-content',
					cancel: '.fusion-builder-settings, .fusion-builder-clone, .fusion-builder-remove, .fusion-builder-element-save, .fusion-builder-add-element, .fusion-builder-insert-column, .fusion-builder-save-module-dialog, .fusion-builder-inner-row-close',
					tolerance: 'pointer',
					appendTo: self.$el.find( '.fusion-builder-column-content' ).parent(),
					helper: 'clone',

					over: function( event ) {
						self.onSortOver( event );
					},

					update: function( event, ui ) {
						self.onSortUpdate( event, ui );
					},

					stop: function( event, ui ) {
						self.onSortStop( event, ui );
					}

				} );
			},

			/**
			 * Checks if column layout type is block.
			 *
			 * @since 3.0.0
			 * @return {Boolean}
			 */
			isBlockLayout: function() {
				return this.values && 'block' === this.values.content_layout;
			},

			/**
			 * Gets the column content.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getColumnContent: function() {
				var columnParams   = {},
					shortcode      = '',
					columnAttributesCheck;

				_.each( this.model.get( 'params' ), function( value, name ) {
					columnParams[ name ] = ( 'undefined' === value || 'undefined' === typeof value ) ? '' : value;
				} );

				// Legacy support for new column options
				columnAttributesCheck = {
					min_height: '',
					last: 'no',
					hover_type: 'none',
					link: '',
					border_position: 'all'
				};

				_.each( columnAttributesCheck, function( value, name ) {
					if ( 'undefined' === typeof columnParams[ name ] ) {
						columnParams[ name ] = value;
					}
				} );

				// Build column shortcdoe
				shortcode += '[fusion_builder_column_inner type="' + columnParams.type + '"';

				_.each( columnParams, function( value, name ) {
					shortcode += ' ' + name + '="' + value + '"';
				} );

				shortcode += ']';

				// Find elements in this column
				this.$el.find( '.fusion-builder-live-element' ).each( function() {
					shortcode += FusionPageBuilderApp.generateElementShortcode( jQuery( this ), false );
				} );

				shortcode += '[/fusion_builder_column_inner]';

				return shortcode;
			}
		} );
	} );
}( jQuery ) );
;/* global FusionApp, fusionAllElements, FusionEvents, FusionPageBuilderViewManager, FusionPageBuilderApp, FusionPageBuilderElements, fusionBuilderText, fusionGlobalManager, fusionSanitize */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Inner Row View
		FusionPageBuilder.InnerRowView = FusionPageBuilder.BaseRowView.extend( {

			className: 'fusion_builder_row_inner fusion_builder_column_element fusion-nested-columns fusion-builder-nested-element',

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-row-inner-template' ).html() ),

			defaultZIndex: 10,

			events: {
				'click .fusion-builder-row-remove': 'removeRow',
				'click .fusion-builder-row-save': 'openLibrary',
				'click .fusion-builder-row-clone': 'cloneNestedRow',
				'click .fusion-builder-row-settings': 'editRow',
				'click .fusion-builder-stop-editing': 'stopEdit',
				'click .fusion-builder-cancel-row': 'cancelChanges',
				'click .fusion-builder-row-add-child': 'displayInnerColumn',
				'click .fusion-builder-insert-inner-column': 'displayInnerColumn',
				'click .fusion-builder-settings': 'editNestedColumn',
				'click .fusion-builder-modal-save': 'closeNestedPopupAndSave',
				'click .fusion-builder-inner-row-close': 'closeNestedPopup',
				'click .fusion-builder-modal-close': 'closeNestedPopup',
				'mousedown .fusion-builder-nested-columns-settings-overlay': 'overlayMousedown'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {

				this.baseRowInit();
				this.nestedRow = true;

				this.model.set( 'rows', {} );
				this.$el.attr( 'data-cid', this.model.get( 'cid' ) );

				if ( 'undefined' !== typeof this.model.attributes.params && 'undefined' !== typeof this.model.attributes.params.fusion_global ) {
					this.$el.attr( 'fusion-global-layout', this.model.attributes.params.fusion_global );
					this.$el.removeClass( 'fusion-global-nested-row' ).addClass( 'fusion-global-nested-row' );
				}

				// Close modal view
				this.listenTo( FusionEvents, 'fusion-close-inner-modal', this.hideInnerRowDialog );
				this.model.children = new FusionPageBuilder.Collection();
				this.savedContent   = '';

				this.listenTo( this.model.children, 'add', this.addChildView );
				this.listenTo( FusionEvents, 'fusion-builder-loaded', this.updateColumnsPreview );

				this.listenTo( FusionEvents, 'fusion-wireframe-toggle', this.wireFrameToggled );
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var self = this;

				this.$el.html( this.template( this.getTemplateAtts() ) );

				setTimeout( function() {
					self.droppableColumn();
					self.droppableElement();
					self.updateWireframeUI();
				}, 100 );

				return this;
			},

			updateWireframeUI: function() {
				var innerColumnsWrapper = this.$el,
					innerColumnsString  = '';

				this.$el.find( '.fusion-nested-column-preview-columns' ).remove();

				innerColumnsWrapper.find( '.fusion-builder-column-inner' ).each( function() {
					innerColumnsString += String( jQuery( this ).data( 'column-size' ) ).replace( '_', '/' ) + ' + ';
				} );

				innerColumnsWrapper.find( '.fusion-nested-column-preview-title' ).after( '<p class="fusion-nested-column-preview-columns">' + innerColumnsString.slice( 0, innerColumnsString.length - 3 ) + '</p>' );
			},

			/**
			 * Stop propagation on overlay mousedown.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			overlayMousedown: function( event ) {
				event.stopPropagation();
			},

			/**
			 * The row attributes.
			 *
			 * @since 3.0
			 * @return {Object}
			 */
			attr: function() {
				var attr 			= {
						style: ''
					},
					parentContainer = FusionPageBuilderApp.getParentContainer( this ),
					isFlex			= parentContainer && parentContainer.isFlex(),
					containerParams = jQuery.extend( true, {}, fusionAllElements.fusion_builder_container.defaults, _.fusionCleanParameters( parentContainer.model.attributes.params ) ),
					width,
					widthValue,
					columnSpacingUnit,
					columnSpacingValue,
					widthUnit;

				attr.id 			= 'fusion-builder-row-' + this.model.get( 'cid' );
				attr[ 'class' ] 	= 'fusion-row fusion-builder-row-container-inner fusion-builder-row-inner fusion-builder-row';
				attr[ 'data-cid' ] 	= this.model.get( 'cid' );

				if ( isFlex ) {
					attr[ 'class' ]  += ' fusion-flex-align-items-' + containerParams.flex_align_items;
						if ( 'stretch' !== containerParams.align_content ) {
							attr[ 'class' ] += ' fusion-flex-align-content-' + containerParams.align_content;
						}
						if ( 'flex-start' !== containerParams.flex_justify_content ) {
							attr[ 'class' ] += ' fusion-flex-justify-content-' + containerParams.flex_justify_content;
						}
						width             = '100%';
						columnSpacingUnit = fusionSanitize.get_unit( containerParams.flex_column_spacing );

						if ( '%' === columnSpacingUnit ) {
							columnSpacingValue = fusionSanitize.number( containerParams.flex_column_spacing );
							widthValue         = fusionSanitize.number( width );
							widthUnit          = fusionSanitize.get_unit( width );

							width = ( widthValue * ( 1 + ( columnSpacingValue / 100 ) ) ) + widthUnit;
						} else {
							width = 'calc( ' + width + ' + ' + containerParams.flex_column_spacing + ' )';
						}

						attr.style += 'max-width:' + width + ' !important;';
						attr.style += 'width:' + width + ';';

						attr.style += 'margin-left: calc(-' + containerParams.flex_column_spacing + ' / 2 );';
						attr.style += 'margin-right: calc(-' + containerParams.flex_column_spacing + ' / 2 );';
				}

				return attr;
			},

			/**
			 * Get template attributes.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getTemplateAtts: function()  {
				var templateAttributes 	= {};

				templateAttributes.id		= this.model.get( 'cid' );
				templateAttributes.title 	= fusionAllElements[ this.model.get( 'element_type' ) ].name;
				templateAttributes.params 	= this.model.get( 'params' );
				templateAttributes.attr		= this.attr();

				return templateAttributes;
			},

			/**
			 * Get the content.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getContent: function() {
				return this.getInnerRowContent();
			},

			/**
			 * Creates drop zone for empty nested row.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			droppableColumn: function() {
				var $el  = this.$el;

				$el.find( '.fusion-nested-column-target' ).droppable( {
					tolerance: 'touch',
					hoverClass: 'ui-droppable-active',
					accept: '.fusion-builder-column',
					drop: function( scopedEvent, ui ) {
						var parentCid      = jQuery( scopedEvent.target ).closest( '.fusion-builder-row-content' ).data( 'cid' ),
							destinationRow = FusionPageBuilderViewManager.getView( parentCid ),
							columnCid      = ui.draggable.data( 'cid' ),
							columnView     = FusionPageBuilderViewManager.getView( columnCid ),
							originalCid    = columnView.model.get( 'parent' ),
							originalView,
							newIndex;

						newIndex = ui.draggable.parent().children( '.fusion-builder-column' ).index( ui.draggable );

						FusionPageBuilderApp.onDropCollectionUpdate( columnView.model, newIndex, self.model.get( 'cid' ) );

						// Move the actual html.
						$el.find( '.fusion-builder-row-container-inner' ).append( ui.draggable );

						// Update destination row which is this current one.
						destinationRow.setRowData();

						// If destination row and original row are different, update original as well.
						if ( parentCid !== originalCid ) {
							originalView = FusionPageBuilderViewManager.getView( originalCid );
							originalView.setRowData();
						}

						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.column + ' order changed' );

						setTimeout( function() {
							columnView.droppableColumn();
						}, 300 );
					}
				} );
			},

			/**
			 * Destroy or disable the droppable and draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			disableDroppableElement: function() {
				var $el = this.$el;

				// If its been init, just disable.
				if ( 'undefined' !== typeof $el.draggable( 'instance' ) ) {
					$el.draggable( 'disable' );
				}

				// If its been init, just disable.
				if ( 'undefined' !== typeof $el.find( '> .fusion-element-target' ).droppable( 'instance' ) ) {
					$el.find( '> .fusion-element-target' ).droppable( 'disable' );
				}
			},

			/**
			 * Enable the droppable and draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			enableDroppableElement: function() {
				var $el = this.$el;

				// If they have been init, then just disable.
				if ( 'undefined' !== typeof $el.draggable( 'instance' ) && 'undefined' !== typeof $el.find( '> .fusion-element-target' ).droppable( 'instance' ) ) {
					$el.draggable( 'enable' );
					$el.find( '> .fusion-element-target' ).droppable( 'enable' );
				} else {

					// No sign of init, then need to call it.
					this.droppableElement();
				}
			},

			/**
			 * Creates droppable zone and makes element draggable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			droppableElement: function() {
				var $el   = this.$el,
					cid   = this.model.get( 'cid' ),
					$body = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' );

				$el.draggable( {
					appendTo: FusionPageBuilderApp.$el,
					zIndex: 999999,
					delay: 100,
					cursorAt: { top: 15, left: 15 },
					iframeScroll: true,
					containment: $body,
					cancel: '.fusion-live-editable, .fusion-builder-live-child-element:not( [data-fusion-no-dragging] )',
					helper: function() {
						var $classes = FusionPageBuilderApp.DraggableHelpers.draggableClasses( cid );
						return jQuery( '<div class="fusion-element-helper ' + $classes + '" data-cid="' + cid + '"><span class="fusiona-column"></span></div>' );
					},
					start: function() {
						$body.addClass( 'fusion-element-dragging fusion-active-dragging' );
						$el.addClass( 'fusion-being-dragged' );
						$el.prev( '.fusion-builder-live-element' ).find( '.target-after' ).addClass( 'target-disabled' );
					},
					stop: function() {
						setTimeout( function() {
							$body.removeClass( 'fusion-element-dragging fusion-active-dragging' );
						}, 10 );
						$el.removeClass( 'fusion-being-dragged' );
						FusionPageBuilderApp.$el.find( '.target-disabled' ).removeClass( 'target-disabled' );
					}
				} );

				$el.find( '.fusion-element-target' ).droppable( {
					tolerance: 'touch',
					hoverClass: 'ui-droppable-active',
					accept: '.fusion-builder-live-element, .fusion_builder_row_inner',
					drop: function( event, ui ) {
						var parentCid      = jQuery( event.target ).closest( '.fusion-builder-column' ).data( 'cid' ),
							columnView     = FusionPageBuilderViewManager.getView( parentCid ),
							elementCid     = ui.draggable.data( 'cid' ),
							elementView    = FusionPageBuilderViewManager.getView( elementCid ),
							MultiGlobalArgs,
							newIndex;

						// Move the actual html.
						if ( jQuery( event.target ).hasClass( 'target-after' ) ) {
							$el.after( ui.draggable );
						} else {
							$el.before( ui.draggable );
						}

						newIndex = ui.draggable.parent().children( '.fusion-builder-live-element, .fusion_builder_row_inner' ).index( ui.draggable );

						FusionPageBuilderApp.onDropCollectionUpdate( elementView.model, newIndex, parentCid );

						// Save history state
						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.moved + ' ' + fusionAllElements[ elementView.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element );

						// Handle multiple global elements.
						MultiGlobalArgs = {
							currentModel: elementView.model,
							handleType: 'save',
							attributes: elementView.model.attributes
						};
						fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

						FusionEvents.trigger( 'fusion-content-changed' );

						columnView._equalHeights();
					}
				} );

				// If we are in wireframe mode, then disable.
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.disableDroppableElement();
				}
			},

			/**
			 * Clones a nested row.
			 *
			 * @since 2.0.0
			 * @param {Object}    event - The event.
			 * @param {parentCID} parentCID - The parent element's CID.
			 * @return {void}
			 */
			cloneNestedRow: function( event, parentCID ) {
				var innerRowAttributes,
					thisInnerRow,
					innerColAttributes;

				if ( 'object' === typeof event ) {
					event.preventDefault();
				}

				innerRowAttributes          = jQuery.extend( true, {}, this.model.attributes );
				innerRowAttributes.created  = 'manually';
				innerRowAttributes.cid      = FusionPageBuilderViewManager.generateCid();
				innerRowAttributes.at_index = FusionPageBuilderApp.getCollectionIndex( this.$el );

				if ( 'object' === typeof event ) {
					innerRowAttributes.targetElement         = this.$el;
					innerRowAttributes.targetElementPosition = 'after';
				} else if ( 'clone' === event ) {
					// Don't need target element, position is defined from order.
					delete innerRowAttributes.targetElementPosition;
				}

				if ( parentCID ) {
					innerRowAttributes.parent = parentCID;
				}

				FusionPageBuilderApp.collection.add( innerRowAttributes );

				// Parse inner columns
				thisInnerRow = this.$el;
				thisInnerRow.find( '.fusion-builder-column-inner' ).each( function() {
					var $thisColumnInner  = jQuery( this ),
						columnInnerCID    = $thisColumnInner.data( 'cid' ),
						innerColumnModule = FusionPageBuilderViewManager.getView( columnInnerCID );

					// Clone model attritubes
					innerColAttributes = jQuery.extend( true, {}, innerColumnModule.model.attributes );

					innerColAttributes.created = 'manually';
					innerColAttributes.cid     = FusionPageBuilderViewManager.generateCid();
					innerColAttributes.parent  = innerRowAttributes.cid;

					FusionPageBuilderApp.collection.add( innerColAttributes );

					// Parse elements inside inner col
					$thisColumnInner.find( '.fusion-builder-live-element' ).each( function() {
						var thisModule = jQuery( this ),
							moduleCID  = 'undefined' === typeof thisModule.data( 'cid' ) ? thisModule.find( '.fusion-builder-data-cid' ).data( 'cid' ) : thisModule.data( 'cid' ),

							// Get model from collection by cid
							module = FusionPageBuilderElements.find( function( model ) {
								return model.get( 'cid' ) == moduleCID; // jshint ignore: line
							} ),

							// Clone model attritubes
							innerElementAttributes = jQuery.extend( true, {}, module.attributes );

						innerElementAttributes.created = 'manually';
						innerElementAttributes.cid     = FusionPageBuilderViewManager.generateCid();
						innerElementAttributes.parent  = innerColAttributes.cid;
						innerElementAttributes.from    = 'fusion_builder_row_inner';

						// Don't need target element, position is defined from order.
						delete innerElementAttributes.targetElementPosition;

						FusionPageBuilderApp.collection.add( innerElementAttributes );
					} );
				} );

				if ( ! parentCID ) {

					// Save history state
					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.cloned_nested_columns );

					FusionEvents.trigger( 'fusion-content-changed' );
				}
			},

			/**
			 * Adds the 'editing' and 'nested-ui-active' classes.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			editRow: function( event ) {
				var parentColumn,
					parentRow;

				if ( event ) {
					event.preventDefault();
				}

				// We have opened, means we no longer need added flag.
				this.model.unset( 'added' );

				this.updateSavedContent();

				parentColumn = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
				parentColumn.$el.addClass( 'fusion-builder-editing-child' );
				parentColumn.$el.removeClass( 'active' );
				parentColumn.$el.closest( '.fusion-builder-container' ).removeClass( 'fusion-column-sizer-active' ).addClass( 'fusion-container-editing-child' );

				parentRow = parentColumn.$el.closest( '.fusion-builder-row' );
				parentRow.addClass( 'fusion-builder-row-editing-child' );
				parentRow.parent().closest( '.fusion-builder-row' ).addClass( 'fusion-builder-row-editing-child' );

				this.$el.addClass( 'editing' );
				this.$el.append( '<div class="fusion-row-overlay"></div>' );
				jQuery( 'body' ).addClass( 'nested-ui-active' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).append( '<div class="fusion-row-overlay"></div>' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).addClass( 'nested-ui-active nested-columns-edited' );

				FusionEvents.trigger( 'fusion-row-nested-edit' );
				FusionEvents.trigger( 'fusion-history-pause-tracking' );
			},

			updateSavedContent: function() {
				this.savedContent = this.getInnerRowContent();
			},

			/**
			 * Removes the 'editing' and 'nested-ui-active' classes, saves history step.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			stopEdit: function( event ) {
				if ( event ) {
					event.preventDefault();
				}

				this.removeEditUI();

				// Close children settings.
				this.closeChildrenSettings();

				FusionEvents.trigger( 'fusion-history-resume-tracking' );

				if ( true === this.contentChanged() ) {
					window.fusionHistoryState = fusionBuilderText.edited + ' ' + fusionAllElements[ this.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.element;
					FusionEvents.trigger( 'fusion-history-save-step', window.fusionHistoryState );
				}
			},

			/**
			 * Checks if content changed.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			contentChanged: function() {
				var content = this.getInnerRowContent();

				if ( content !== this.savedContent ) {
					return true;
				}
				return false;
			},

			/**
			 * Removes the 'editing' and 'nested-ui-active' classes.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			removeEditUI: function( event ) {
				var parentColumn;

				if ( event ) {
					event.preventDefault();
				}

				parentColumn = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
				parentColumn.$el.removeClass( 'fusion-builder-editing-child' );
				parentColumn.$el.closest( '.fusion-builder-row' ).removeClass( 'fusion-builder-row-editing-child' );
				parentColumn.$el.closest( '.fusion-container-editing-child' ).removeClass( 'fusion-container-editing-child' );

				this.$el.removeClass( 'editing' );
				this.$el.find( '.fusion-row-overlay' ).remove();
				jQuery( 'body' ).removeClass( 'nested-ui-active' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).find( '.fusion-row-overlay' ).remove();
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).removeClass( 'nested-ui-active nested-columns-edited' );
			},

			/**
			 * Closes children settings.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			closeChildrenSettings: function() {
				_.each( this.collection.models, function( model ) {
					if ( ( 'element' === model.attributes.type || 'fusion_builder_column_inner' === model.attributes.type ) && 0 < jQuery( '.fusion_builder_module_settings[data-cid="' + model.attributes.cid + '"]' ).length ) {
						FusionEvents.trigger( 'fusion-close-settings-' + model.attributes.cid );
					}
				} );
			},

			/**
			 * Gets the contents of the inner row.
			 *
			 * @since 2.0.0
			 * @return {string}
			 */
			getInnerRowContent: function() {
				var shortcode       = '',
					$thisRowInner   = this.$el,
					thisRowInnerCID = $thisRowInner.data( 'cid' ),
					module          = FusionPageBuilderElements.findWhere( { cid: thisRowInnerCID } ); // eslint-disable-line no-unused-vars

				shortcode += '[fusion_builder_row_inner]';

				$thisRowInner.find( '.fusion-builder-column-inner' ).each( function() {
					var $thisColumnInner = jQuery( this ),
						columnCID        = $thisColumnInner.data( 'cid' ),
						columnView       = FusionPageBuilderViewManager.getView( columnCID );

					shortcode += columnView.getColumnContent();
				} );

				shortcode += '[/fusion_builder_row_inner]';

				return shortcode;
			},

			/**
			 * Removes a row.
			 *
			 * @since 2.0.0
			 * @param {Object}         event - The event.
			 * @param {boolean|undefined} force - Should we force-remove the row?
			 * @return {void}
			 */
			removeRow: function( event ) {
				var columns,
					parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );

				if ( event ) {
					event.preventDefault();
				}

				columns = FusionPageBuilderViewManager.getChildViews( this.model.get( 'cid' ) );

				// Remove columns
				_.each( columns, function( column ) {
					column.removeColumn();
				} );

				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				FusionEvents.trigger( 'fusion-element-removed', this.model.get( 'cid' ) );

				this.model.destroy();

				this.remove();

				// If row ( nested columns ) is removed manually
				if ( event ) {

					// Save history state
					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.deleted_nested_columns );

					FusionEvents.trigger( 'fusion-content-changed' );

					parentView.$el.find( '.fusion-builder-module-controls-container a' ).trigger( 'mouseleave' );

					this.removeEditUI();
				}
			},

			/**
			 * Reverts nested column changes.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			cancelChanges: function( event ) {
				if ( event ) {
					event.preventDefault();
				}

				this.removeEditUI();

				// Close children settings.
				this.closeChildrenSettings();

				if ( true === this.contentChanged() ) {
					FusionPageBuilderApp.shortcodesToBuilder( this.savedContent, this.model.get( 'parent' ), 'undefined', 'undefined', this.$el );
					this.removeRow();
				}

				FusionEvents.trigger( 'fusion-history-resume-tracking' );
			},

			addNestedColumn: function( element, appendAfter, targetElement, atIndex ) {
				var that,
					thisView,
					defaultParams,
					params,
					parent,
					value,
					columnAttributes;

				parent   = this.model.get( 'cid' );
				that     = this;
				thisView = this.options.view;

				// Get default options
				defaultParams = fusionAllElements.fusion_builder_column_inner.params;
				params = {};

				// Process default parameters from shortcode
				_.each( defaultParams, function( param )  {
					value = ( _.isObject( param.value ) ) ? param[ 'default' ] : param.value;
					params[ param.param_name ] = value;
				} );

				params.type = element;

				columnAttributes = {
					type: 'fusion_builder_column_inner',
					element_type: 'fusion_builder_column_inner',
					cid: FusionPageBuilderViewManager.generateCid(),
					parent: parent,
					view: thisView,
					params: params,
					targetElement: targetElement,
					at_index: atIndex
				};

				// Make sure not clones
				columnAttributes = jQuery.extend( true, {}, columnAttributes );

				that.collection.add( [ columnAttributes ] );

				return columnAttributes.cid;
			},

			/**
			 * Appends children. Calls the delegateEvents function in the view.
			 *
			 * @since 2.0.0
			 * @param {bool} reRender
			 * @return {void}
			 */
			appendChildren: function( reRender = true ) {

				var self = this,
					cid,
					view;

				this.model.children.each( function( child ) {

					cid  = child.attributes.cid;
					view = FusionPageBuilderViewManager.getView( cid );

					self.$el.find( '.fusion-builder-row-container-inner' ).append( reRender ? view.render().$el : view.$el );

					view.delegateEvents();
				} );
			},

			/**
			 * Adds a child view.
			 *
			 * @since 2.0.0
			 * @param {Object} element - The element model.
			 * @return {void}
			 */
			addChildView: function( element ) {
				var view,
					viewSettings = {
						model: element,
						collection: FusionPageBuilderElements,
						attributes: {
							'data-cid': element.get( 'cid' )
						}
					};

				viewSettings.className = 'fusion-builder-column fusion-builder-column-inner fusion-builder-column-' + element.attributes.params.type;

				// Calculate virtual rows
				this.createVirtualRows();

				view = new FusionPageBuilder.NestedColumnView( viewSettings );

				// This column was cloned
				if ( ! _.isUndefined( element.get( 'cloned' ) ) && true === element.get( 'cloned' ) ) {
					element.targetElement = view.$el;
					element.unset( 'cloned' );
				}

				FusionPageBuilderViewManager.addView( element.get( 'cid' ), view );

				if ( ! _.isUndefined( element.get( 'targetElement' ) ) && 'undefined' === typeof element.get( 'from' ) ) {
					if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'after' === element.get( 'targetElementPosition' ) ) {
						element.get( 'targetElement' ).after( view.render().el );
					} else {
						element.get( 'targetElement' ).before( view.render().el );
					}
				} else {
					if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'end' === element.get( 'targetElementPosition' ) ) {
						this.$el.find( '.fusion-builder-row-container-inner' ).append( view.render().el );
					} else {
						this.$el.find( '.fusion-builder-row-container-inner' ).prepend( view.render().el );
					}
					element.unset( 'from' );
				}

				this.updateColumnsPreview();
			},

			displayInnerColumn: function( event ) {
				var view,
					viewSettings,
					columnCID;

				if ( event ) {
					event.preventDefault();
				}

				columnCID = jQuery( event.currentTarget ).closest( '.fusion-builder-column-inner' ).data( 'cid' );

				FusionPageBuilderApp.parentRowId = this.model.get( 'cid' );

				viewSettings = {
					model: this.model,
					collection: this.collection,
					view: this,
					attributes: {
						'data-modal_view': 'nested_column_library',
						'data-parent_cid': this.model.get( 'cid' ),
						'data-nested_column_cid': columnCID
					},
					nested: true
				};

				view = new FusionPageBuilder.NestedColumnLibraryView( viewSettings );

				jQuery( view.render().el ).dialog( {
					title: 'Select Column',
					width: FusionApp.dialog.dialogWidth,
					height: FusionApp.dialog.dialogHeight,
					draggable: false,
					modal: true,
					resizable: false,
					dialogClass: 'fusion-builder-dialog fusion-builder-element-library-dialog',
					open: function( scopedEvent ) {
						var $dialogContent = jQuery( scopedEvent.target );
						$dialogContent.find( '.fusion-builder-modal-top-container' ).appendTo( '.fusion-builder-element-library-dialog .ui-dialog-titlebar' );
						FusionApp.dialog.resizeDialog();
					},
					close: function() {
						view.remove();
					}
				} );
			},

			/**
			 * Opens nested columns in popup for wireframe mode.
			 *
			 * @since 2.0.0
			 * @param {Object} element - The element model.
			 * @return {void}
			 */
			editNestedColumn: function( event ) {
				var self = this;

				if ( event ) {
					event.preventDefault();
				}

				this.savedContent = this.getInnerRowContent();

				this.$el.find( '.fusion-builder-row-content' ).addClass( 'fusion-builder-row-content-active' );
				self.$el.closest( '.fusion-row' ).addClass( 'fusion-builder-row-active' );
				this.$el.closest( '.fusion-builder-ui-wireframe' ).addClass( 'fusion-builder-nested-cols-dialog-open' );

				// Hides column size popup.
				this.$el.closest( '.fusion-builder-column' ).removeClass( 'active' );
				this.$el.closest( '.fusion-builder-container' ).removeClass( 'fusion-column-sizer-active' );

				FusionEvents.trigger( 'fusion-history-turn-on-tracking' );
				FusionEvents.trigger( 'fusion-history-capture-editor' );
				FusionEvents.trigger( 'fusion-history-turn-off-tracking' );
				FusionEvents.trigger( 'fusion-history-pause-tracking' );
			},

			/**
			 * Closes nested columns in popup for wireframe mode.
			 *
			 * @since 2.0.0
			 * @param {Object} element - The element model.
			 * @return {void}
			 */
			closeNestedPopupAndSave: function( event ) {
				if ( event ) {
					event.preventDefault();
				}

				this.updateWireframeUI();
				this.$el.find( '.fusion-builder-row-content' ).removeClass( 'fusion-builder-row-content-active' );
				this.$el.closest( '.fusion-row' ).removeClass( 'fusion-builder-row-active' );
				this.$el.closest( '.fusion-builder-ui-wireframe' ).removeClass( 'fusion-builder-nested-cols-dialog-open' );
			},

			/**
			 * Closes nested columns in popup for wireframe mode and revert changes.
			 *
			 * @since 2.0.0
			 * @param {Object} element - The element model.
			 * @return {void}
			 */
			closeNestedPopup: function( event ) {
				if ( event ) {
					event.preventDefault();
				}

				this.$el.find( '.fusion-builder-row-content' ).removeClass( 'fusion-builder-row-content-active' );
				this.$el.closest( '.fusion-row' ).removeClass( 'fusion-builder-row-active' );
				this.$el.closest( '.fusion-builder-ui-wireframe' ).removeClass( 'fusion-builder-nested-cols-dialog-open' );

				if ( true === this.contentChanged() ) {
					FusionPageBuilderApp.shortcodesToBuilder( this.savedContent, this.model.get( 'parent' ), 'undefined', 'undefined', this.$el );
					this.removeRow();
				}
				FusionEvents.trigger( 'fusion-history-resume-tracking' );
			},

			/**
			 * Opens the library. Builds the settings for this view
			 * and then calls FusionPageBuilder.LibraryView and renders it.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The js event.
			 * @return {void}
			 */
			openLibrary: function( event ) {
				var view,
					libraryModel = {
						target: jQuery( event.currentTarget ).data( 'target' ),
						focus: jQuery( event.currentTarget ).data( 'focus' ),
						element_cid: this.model.get( 'cid' ),
						element_name: 'undefined' !== typeof this.model.get( 'admin_label' ) && '' !== this.model.get( 'admin_label' ) ? this.model.get( 'admin_label' ) : ''
					},
					viewSettings = {
						model: libraryModel
					};

				if ( event ) {
					event.preventDefault();
					event.stopPropagation();
					FusionPageBuilderApp.sizesHide( event );
				}

				view = new FusionPageBuilder.LibraryView( viewSettings );
				view.render();

				// Make sure to close any context menus which may be open.
				FusionPageBuilderApp.removeContextMenu();
			},

			/**
			 * Fired when wireframe mode is toggled.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			wireFrameToggled: function() {
				if ( FusionPageBuilderApp.wireframeActive ) {

					if ( jQuery( 'body' ).hasClass( 'nested-ui-active' ) ) {
						this.stopEdit();
					}

					this.enableSortableColumns();
					this.disableDroppableElement();
					this.updateWireframeUI();
				} else {
					this.disableSortableColumns();
					this.enableDroppableElement();
				}
			},

			recalculateMargins: function() {
				var attr = this.attr();

				this.$el.find( '.fusion-builder-row-container-inner' ).first().attr( 'style', attr.style );
			},

			/**
			 * Destroy or disable column sortable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			disableSortableColumns: function() {
				var rowContainer = this.$el.find( '.fusion-builder-row-container' );

				rowContainer.sortable( 'disable' );
			},

			/**
			 * Initialize column sortable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			sortableColumns: function() {
				var sortableColumns = this.$el.find( '.fusion-builder-row-container-inner' ),
					items = '.fusion-builder-column-inner',
					self = this;

				sortableColumns.sortable( {
					items: items,
					helper: 'clone',
					cancel: '.fusion-builder-settings-column, .fusion-builder-column-size, .fusion-builder-column-clone, .fusion-builder-column-remove, .fusion-builder-add-element, .fusion-builder-insert-column, .fusion-builder-save-column, .column-sizes, .fusion-builder-modal-save, .fusion-builder-inner-row-close',
					tolerance: 'pointer',

					update: function() {
						self.onSortUpdate();
					},

					stop: function( event, ui ) {
						self.onSortStop( event, ui, items );
					}

				} ).disableSelection();
			}
		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderApp, FusionPageBuilderViewManager, fusionAllElements, FusionApp */
var FusionPageBuilder = FusionPageBuilder || {};

( function( $ ) {

	$( document ).ready( function() {

		// Builder Blank Page View
		FusionPageBuilder.BlankPageView = window.wp.Backbone.View.extend( {

			className: 'fusion-builder-blank-page',

			template: FusionPageBuilder.template( $( '#fusion-builder-blank-page-template' ).html() ),

			events: {
				'click .fusion-builder-new-section-add': 'addContainer',
				'click .fusion-builder-video-button': 'openVideoModal',
				'click #fusion-load-template-dialog': 'openLibrary'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
				this.$el.attr( 'data-cid', this.model.get( 'cid' ) );
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var colorScheme = this.getColorScheme( FusionApp.settings.content_bg_color );

				this.$el.html( this.template( this.model.toJSON() ) );

				this.$el.addClass( 'fusion-builder-scheme-' + colorScheme );

				this.$el.find( '#video-dialog' ).dialog( {
					dialogClass: 'fusion-builder-dialog fusion-video-dialog',
					autoOpen: false,
					modal: true,
					height: 470,
					width: 700
				} );

				return this;
			},

			/**
			 * Calculate color scheme depend on hex color.
			 *
			 * @since 2.0.0
			 * @param {string} hexColor - The hex color code to calculate color scheme against.
			 * @return {string}
			 */
			getColorScheme: function( hexColor ) {
				hexColor = 'string' !== typeof hexColor ? '#ffffff' : hexColor.replace( '#', '' );
				return ( parseInt( hexColor, 16 ) > 0xffffff / 2 ) ? 'light' : 'dark';
			},

			/**
			 * Opens a video modal.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the modal.
			 * @return {void}
			 */
			openVideoModal: function( event ) {
				if ( event ) {
					event.preventDefault();
				}

				jQuery( '#video-dialog' ).dialog( 'open' );
				jQuery( '#video-dialog iframe' ).focus();

				jQuery( '#video-dialog iframe' )[ 0 ].contentWindow.postMessage( '{"event":"command","func":"playVideo","args":""}', '*' );
			},

			/**
			 * Adds a container.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event triggering the container addition.
			 * @return {void}
			 */
			addContainer: function( event ) {

				var elementID,
					defaultParams,
					params,
					value,
					newContainer;

				if ( event ) {
					event.preventDefault();
					FusionPageBuilderApp.newContainerAdded = true;
				}

				elementID     = FusionPageBuilderViewManager.generateCid();
				defaultParams = fusionAllElements.fusion_builder_container.params;
				params        = {};

				// Process default options for shortcode.
				_.each( defaultParams, function( param )  {
					if ( _.isObject( param.value ) ) {
						value = param[ 'default' ];
					} else {
						value = param.value;
					}
					params[ param.param_name ] = value;

					if ( 'dimension' === param.type && _.isObject( param.value ) ) {
						_.each( param.value, function( val, name )  {
							params[ name ] = val;
						} );
					}
				} );

				this.collection.add( [
					{
						type: 'fusion_builder_container',
						added: 'manually',
						element_type: 'fusion_builder_container',
						cid: elementID,
						params: params,
						view: this,
						created: 'auto'
					}
				] );

				// Make sure to add row to new container not current one.
				newContainer = FusionPageBuilderViewManager.getView( elementID );
				newContainer.addRow();

				this.removeBlankPageHelper();
			},

			/**
			 * Opens the library.
			 * Calls the LibraryView and then renders it.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			openLibrary: function( event ) {
				var view,
					libraryModel = {
						target: jQuery( event.currentTarget ).data( 'target' ),
						focus: jQuery( event.currentTarget ).data( 'focus' )
					},
					viewSettings = {
						model: libraryModel
					};

				if ( event ) {
					event.preventDefault();
					event.stopPropagation();
					FusionPageBuilderApp.sizesHide( event );
				}

				view = new FusionPageBuilder.LibraryView( viewSettings );
				view.render();
			},

			/**
			 * Removes the helper for blank pages.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			removeBlankPageHelper: function( event ) {
				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				this.model.destroy();

				if ( jQuery( '#video-dialog' ).length ) {
					jQuery( '#video-dialog' ).dialog( 'destroy' );
				}

				this.remove();
			}

		} );

		jQuery( 'body' ).on( 'click', '.ui-dialog-titlebar-close', function() {
			var dialog = jQuery( this ).closest( '.ui-dialog' );
			if ( dialog.find( '#video-dialog' ).length ) {
				dialog.find( '#video-dialog iframe' )[ 0 ].contentWindow.postMessage( '{"event":"command","func":"pauseVideo","args":""}', '*' );
				dialog.hide();
			}
		} );
	} );
}( jQuery ) );
;/* global FusionApp, fusionAppConfig, FusionEvents */
/* eslint no-empty-function: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Preferences.
		FusionPageBuilder.PreferencesView = window.wp.Backbone.View.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-front-end-preferences' ).html() ),
			events: {
				'click .fusion-panel-description': 'showHideDescription',
				'change .button-set-value': 'optionChanged'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var self = this;

				this.$el.html( this.template() );

				this.$el = this.$el.dialog( {
					title: 'Preferences',
					width: 600,
					height: FusionApp.dialog.dialogHeight,
					draggable: false,
					resizable: false,
					modal: true,
					dialogClass: 'fusion-builder-dialog fusion-builder-settings-dialog fusion-builder-preferences-dialog',

					open: function( event ) {
						var dialogContent = jQuery( event.target );

						FusionPageBuilder.options.radioButtonSet.optionRadioButtonSet( dialogContent );
						FusionApp.dialog.resizeDialog();
					},

					close: function() {
						self.saveChanges();
					}
				} ).closest( '.ui-dialog' );

				return this;
			},

			/**
			 * Trigger live-update when an option changes.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			optionChanged: function() {
				var $preferences = {},
					preferencesChanged = [],
					i;

				this.$el.find( 'input' ).each( function() {
					$preferences[ jQuery( this ).attr( 'id' ) ] = jQuery( this ).val();

					if ( $preferences[ jQuery( this ).attr( 'id' ) ] !== FusionApp.preferencesData[ jQuery( this ).attr( 'id' ) ] ) {
						preferencesChanged.push( jQuery( this ).attr( 'id' ) );
					}
				} );

				FusionApp.preferencesData = $preferences;

				for ( i = 0; i < preferencesChanged.length; i++ ) {
					FusionEvents.trigger( 'fusion-preferences-' + preferencesChanged[ i ] + '-updated' );
				}
			},

			/**
			 * Cancel the changes.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			saveChanges: function() {
				var $preferences = {};

				jQuery( 'li.fusion-builder-preferences' ).css( 'pointer-events', 'none' );
				this.$el.find( 'input' ).each( function() {
					$preferences[ jQuery( this ).attr( 'id' ) ] = jQuery( this ).val();
				} );
				FusionApp.preferencesData = $preferences;

				jQuery.ajax( {
					type: 'POST',
					url: fusionAppConfig.ajaxurl,
					dataType: 'JSON',
					data: {
						action: 'fusion_app_save_builder_preferences',
						fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
						preferences: $preferences
					}
				} )
				.done( function( response ) {
					FusionApp.preferences = response;
					jQuery( 'li.fusion-builder-preferences' ).css( 'pointer-events', 'auto' );
				} );

				this.removeView();
			},

			/**
			 * Removes the view.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			removeView: function() {
				this.$el.find( '.fusion-save-element-fields' ).remove();
				this.$el.find( '.fusion-tabs-menu' ).appendTo( '#fusion-builder-front-end-library' );
				this.remove();
			},

			/**
			 * Show or hide description.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The JS event.
			 * @return {void}
			 */
			showHideDescription: function( event ) {
				var $element = jQuery( event.currentTarget );

				$element.closest( '.fusion-builder-option' ).find( '.description' ).first().slideToggle( 250 );
				$element.toggleClass( 'active' );
			}
		} );
	} );
}( jQuery ) );
;/* global fusionAllElements, FusionApp, fusionDynamicData, fusionAllElements  */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Element Preview View
		FusionPageBuilder.ElementPreviewView = window.wp.Backbone.View.extend( {

			className: 'fusion_module_block_preview ',

			dynamicParams: {},

			// Elements which use element_content for preview.
			contentPreviewElements: [ 'fusion_text', 'fusion_title', 'fusion_alert', 'fusion_button', 'fusion_imageframe', 'fusion_sharing' ],

			globalIconPlaceholder: '#fusion_dynamic_data_icon#',

			initialize: function() {
				this.dynamicParams = this.options.dynamicParams;

				if ( jQuery( '#' + fusionAllElements[ this.model.attributes.element_type ].preview_id ).length ) {
					this.template = FusionPageBuilder.template( jQuery( '#' + fusionAllElements[ this.model.attributes.element_type ].preview_id ).html() );
				} else {
					this.template = FusionPageBuilder.template( jQuery( '#fusion-builder-block-module-default-preview-template' ).html() );
				}
			},

			render: function() {
				var html = this.template( this.getTemplateAttributes() );

				this.$el.html( this.updatePreview( html ) );

				return this;
			},

			/**
			 * Filter template attributes.
			 *
			 * @since 2.1
			 * @return {object}
			 */
			getTemplateAttributes: function() {
				var atts        = jQuery.extend( true, {}, this.model.attributes ),
					dynamicData = this.getDynamicData(),
					label       = '';

				// If element preview could be updated.
				if ( -1 !== this.contentPreviewElements.indexOf( this.model.attributes.element_type ) ) {

					// And there is dynamic content.
					if ( ! _.isEmpty( dynamicData ) && 'undefined' !== typeof dynamicData.element_content ) {

						// Elements which use element_content for preview, for example text element.
						label = '';
						if ( 'undefined' !== typeof FusionApp && 'undefined' !== typeof FusionApp.data.dynamicOptions[ dynamicData.element_content.data ] ) {
							label = FusionApp.data.dynamicOptions[ dynamicData.element_content.data ].label;
						} else if ( 'undefined' !== typeof fusionDynamicData.dynamicOptions[ dynamicData.element_content.data ] ) {
							label = fusionDynamicData.dynamicOptions[ dynamicData.element_content.data ].label;
						}
						atts.params.element_content = this.globalIconPlaceholder + label;
					}

				}

				return atts;
			},

			/**
			 * Updates preview with dynamic data if needed.
			 *
			 * @since 2.1
			 * @param {string} html
			 * @return {string}
			 */
			updatePreview: function( html ) {
				var dynamicData         = this.getDynamicData(),
					elDynamicParams     = [],
					childHasDynamicData = false,
					iconHTML            = '<span class="fusiona-dynamic-data"></span>',
					label               = '',
					childLabel          = '',
					$dynamicPreview;

				// Check if element children use dynamic data.
				if ( 'undefined' !== typeof this.model.attributes.multi && 'multi_element_parent' === this.model.attributes.multi &&
					'undefined' !== typeof this.model.attributes.params.element_content && -1 !== this.model.attributes.params.element_content.indexOf( 'dynamic_params' )
				) {
					childHasDynamicData = true;
				}

				// Update preview if element or it's child uses dynamic data.
				if ( -1 === this.contentPreviewElements.indexOf( this.model.attributes.element_type ) && ( ! _.isEmpty( dynamicData ) || childHasDynamicData ) ) {
					$dynamicPreview = jQuery( '<div />', { html: html } );

					// If children use dynamic content remove their preview.
					if ( childHasDynamicData ) {
						$dynamicPreview.find( 'ul' ).remove();

						// Set child preview.
						if ( 'undefined' !== typeof fusionAllElements[ this.model.attributes.element_type ] && 'undefined' !== typeof fusionAllElements[ fusionAllElements[ this.model.attributes.element_type ].element_child ] ) {
							childLabel = fusionAllElements[ fusionAllElements[ this.model.attributes.element_type ].element_child ].name;
							elDynamicParams.push( childLabel );
						}
					}

					_.each( dynamicData, function( dynamic ) {
						label = '';
						if ( 'undefined' !== typeof FusionApp && 'undefined' !== typeof FusionApp.data.dynamicOptions[ dynamic.data ] ) {
							label = FusionApp.data.dynamicOptions[ dynamic.data ].label;
						} else if ( 'undefined' !== typeof fusionDynamicData.dynamicOptions[ dynamic.data ] ) {
							label = fusionDynamicData.dynamicOptions[ dynamic.data ].label;
						}
						elDynamicParams.push( label );
					} );

					$dynamicPreview.append( '<div class="fusion-builder-dynamic-data-preview fusion-builder-dynamic-data-preview-inline">' + iconHTML + elDynamicParams.join( ', ' ) + '</div>' );

					html = $dynamicPreview.html();
				}

				// Replace placeholders if added during attributes filtering.
				return html.replace( this.globalIconPlaceholder, iconHTML );
			},

			/**
			 * Get element dynamic data.
			 *
			 * @since 2.1
			 * @return {object}
			 */
			getDynamicData: function() {
				var dynamicData = {};

				if ( 'undefined' !== typeof this.dynamicParams ) {

					// Get dynamic data in live editor.
					dynamicData = this.dynamicParams.getAll();
				} else if ( 'undefined' !== typeof this.model.attributes.dynamic_params ) {

					// Get dynamic data in backend editor.
					dynamicData = this.model.attributes.dynamic_params;
				}

				return dynamicData;
			}

		} );
	} );
}( jQuery ) );
;/* global FusionApp, FusionPageBuilderViewManager, FusionEvents, FusionPageBuilderApp, fusionBuilderText */
/* eslint no-shadow: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Next Page View.
		FusionPageBuilder.NextPage = FusionPageBuilder.BaseView.extend( {

			className: 'fusion-builder-next-page',
			template: FusionPageBuilder.template( jQuery( '#fusion-builder-next-page-template' ).html() ),
			events: {
				'click .fusion-builder-delete-next-page': 'removeNextPage',
				'click .fusion-builder-next-page-toggle': 'toggleNextPagePreview',
				'click .fusion-builder-next-page-link': 'changePageTrigger'
			},

			initialize: function() {
				var params = this.model.get( 'params' );

				this.$el.attr( 'data-cid', this.model.get( 'cid' ) );

				if ( FusionApp.data.next_page_elements_count <= FusionPageBuilderViewManager.countElementsByType( 'fusion_builder_next_page' ) ) {
					FusionApp.data.next_page_elements_count += 1;
				}

				if ( params.last ) {
					this.$el.addClass( 'fusion-builder-next-page-last' );
				}

				this.listenTo( FusionEvents, 'fusion-wireframe-toggle', this.wireFrameToggled );
			},

			render: function() {
				var self = this,
					data = this.getTemplateAtts();

				this.$el.html( this.template( data ) );

				this.addPaginationLinks();

				setTimeout( function() {
					self.droppableContainer();
				}, 100 );

				return this;
			},

			/**
						 * Adds drop zones for continers and makes container draggable.
						 *
						 * @since 2.0.0
						 * @return {void}
						 */
			droppableContainer: function() {

				var $el   = this.$el,
					cid   = this.model.get( 'cid' ),
					$body = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' );

				if ( ! $el ) {
					return;
				}

				$el.draggable( {
					appendTo: FusionPageBuilderApp.$el,
					zIndex: 999999,
					delay: 100,
					cursorAt: { top: 15, left: 15 },
					iframeScroll: true,
					containment: $body,
					cancel: '.fusion-builder-column',
					helper: function() {
						var $classes = FusionPageBuilderApp.DraggableHelpers.draggableClasses( cid );
						return jQuery( '<div class="fusion-container-helper ' + $classes + '" data-cid="' + cid + '"><span class="fusiona-container"></span></div>' );
					},
					start: function() {
						$body.addClass( 'fusion-container-dragging fusion-active-dragging' );
						$el.addClass( 'fusion-being-dragged' );

						//  Add a class to hide the unnecessary target after.
						if ( $el.prev( '.fusion-builder-container' ).length ) {
							$el.prev( '.fusion-builder-container' ).addClass( 'hide-target-after' );
						}

						if ( $el.prev( '.fusion-fusion-builder-next-pager' ).length ) {
							$el.prev( '.fusion-fusion-builder-next-page' ).addClass( 'hide-target-after' );
						}
					},
					stop: function() {
						setTimeout( function() {
							$body.removeClass( 'fusion-container-dragging fusion-active-dragging' );
						}, 10 );
						$el.removeClass( 'fusion-being-dragged' );
						FusionPageBuilderApp.$el.find( '.hide-target-after' ).removeClass( 'hide-target-after' );
					}
				} );

				$el.find( '.fusion-container-target' ).droppable( {
					tolerance: 'touch',
					hoverClass: 'ui-droppable-active',
					accept: '.fusion-builder-container, .fusion-builder-next-page',
					drop: function( event, ui ) {

						// Move the actual html.
						if ( jQuery( event.target ).hasClass( 'target-after' ) ) {
							$el.after( ui.draggable );
						} else {
							$el.before( ui.draggable );
						}

						FusionEvents.trigger( 'fusion-content-changed' );

						FusionPageBuilderApp.scrollingContainers();

						FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.nextpage + ' Element order changed' );
					}
				} );

				// If we are in wireframe mode, then disable.
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.disableDroppableContainer();
				}
			},

			/**
						 * Enable the droppable and draggable.
						 *
						 * @since 2.0.0
						 * @return {void}
						 */
			enableDroppableContainer: function() {
				var $el = this.$el;

				if ( 'undefined' !== typeof $el.draggable( 'instance' ) && 'undefined' !== typeof $el.find( '.fusion-container-target' ).droppable( 'instance' ) ) {
					$el.draggable( 'enable' );
					$el.find( '.fusion-container-target' ).droppable( 'enable' );
				} else {

					// No sign of init, then need to call it.
					this.droppableContainer();
				}
			},

			/**
						 * Destroy or disable the droppable and draggable.
						 *
						 * @since 2.0.0
						 * @return {void}
						 */
			disableDroppableContainer: function() {
				var $el = this.$el;

				// If its been init, just disable.
				if ( 'undefined' !== typeof $el.draggable( 'instance' ) ) {
					$el.draggable( 'disable' );
				}

				// If its been init, just disable.
				if ( 'undefined' !== typeof $el.find( '.fusion-container-target' ).droppable( 'instance' ) ) {
					$el.find( '.fusion-container-target' ).droppable( 'disable' );
				}
			},

			/**
						 * Fired when wireframe mode is toggled.
						 *
						 * @since 2.0.0
						 * @return {void}
						 */
			wireFrameToggled: function() {
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.disableDroppableContainer();
				} else {
					this.enableDroppableContainer();
				}
			},

			/**
			 * Get template attributes.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			getTemplateAtts: function() {
				var templateAttributes = {},
					pages = Math.max( FusionApp.data.next_page_elements_count, FusionPageBuilderViewManager.countElementsByType( 'fusion_builder_next_page' ) );

				templateAttributes.pages = pages;

				templateAttributes = this.filterTemplateAtts( templateAttributes );

				return templateAttributes;
			},

			/**
			 * Add the pagination links.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			addPaginationLinks: function() {
				var allNextPageElements = jQuery( '#fb-preview' ).contents().find( '.fusion-builder-next-page' ),
					i,
					additionalClasses = '';

				for ( i = 1; i <= FusionApp.data.next_page_elements_count; i++ ) {
					additionalClasses = ( 1 === i ) ? ' current' : '';

					this.$el.find( '.fusion-builder-next-page-pagination' ).append( '<a class="fusion-builder-next-page-link' + additionalClasses + '" href="#" data-page="' + i + '">' + i + '</a>' );
				}

				if ( allNextPageElements.find( '.fusion-builder-next-page-pagination' ).eq( 0 ).find( '.fusion-builder-next-page-link' ).length < FusionApp.data.next_page_elements_count ) {
					allNextPageElements.each( function() {
						jQuery( this ).find( '.fusion-builder-next-page-pagination' ).append( '<a class="fusion-builder-next-page-link" href="#" data-page="' + FusionApp.data.next_page_elements_count + '">' + ( FusionApp.data.next_page_elements_count ) + '</a>' );
					} );
				}
			},

			removeNextPage: function( event ) {
				var allNextPageElements = jQuery( '#fb-preview' ).contents().find( '.fusion-builder-next-page' ),
					allContainers = jQuery( '#fb-preview' ).contents().find( '.fusion-builder-container' ),
					isLivePreviewActive = this.$el.hasClass( 'live-preview-active' ),
					index = allNextPageElements.index( this.$el );

				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderViewManager.removeView( this.model.get( 'cid' ) );

				this.model.destroy();

				this.remove();

				FusionApp.data.next_page_elements_count -= 1;

				jQuery( '#fb-preview' ).contents().find( '.fusion-builder-next-page' ).each( function() {
					jQuery( this ).find( '.fusion-builder-next-page-link' ).eq( 0 ).remove();

					jQuery( this ).find( '.fusion-builder-next-page-link' ).each( function( index ) {
						jQuery( this ).attr( 'data-page', index + 1 );
						jQuery( this ).html( index + 1 );
					} );
				} );

				if ( isLivePreviewActive ) {
					if ( jQuery( allNextPageElements.get( index ) ).length && 2 < allNextPageElements.length ) {
						this.changePage( index );
					} else {
						allContainers.show();

						if ( 2 === allNextPageElements.length ) {
							this.toggleNextPagePreview();
						}
					}
				}

				FusionEvents.trigger( 'fusion-content-changed' );

				FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.deleted_nextpage );
			},

			toggleNextPagePreview: function( event ) {
				var allNextPageElements = jQuery( '#fb-preview' ).contents().find( '.fusion-builder-next-page' ),
					lastNextPageElement = jQuery( '#fb-preview' ).contents().find( '.fusion-builder-next-page-last' ),
					allContainers = jQuery( '#fb-preview' ).contents().find( '.fusion-builder-container' ),
					index = allNextPageElements.index( this.$el );

				if ( event ) {
					event.preventDefault();
				}

				if ( this.$el.hasClass( 'live-preview-active' ) ) {
					allNextPageElements.show();
					lastNextPageElement.hide();
					allContainers.show();
				} else {
					this.changePage( index );
				}

				allNextPageElements.toggleClass( 'live-preview-active' );
			},

			changePageTrigger: function( event ) {
				var newPage = parseInt( jQuery( event.target ).html(), 10 ) - 1;

				event.preventDefault();

				this.changePage( newPage );
			},

			changePage: function( newPage ) {
				var newNextPageElement = jQuery( '#fb-preview' ).contents().find( '.fusion-builder-next-page' ).eq( newPage ),
					ancestorNextPageElement = jQuery( '#fb-preview' ).contents().find( '.fusion-builder-next-page' ).eq( newPage - 1 ),
					allNextPageElements = jQuery( '#fb-preview' ).contents().find( '.fusion-builder-next-page' ),
					allContainers = jQuery( '#fb-preview' ).contents().find( '.fusion-builder-container' );

				allNextPageElements.removeClass( 'fusion-next-page-active' );
				allNextPageElements.find( '.fusion-builder-next-page-link' ).removeClass( 'current' );
				allNextPageElements.hide();
				allContainers.hide();

				newNextPageElement.addClass( 'fusion-next-page-active' );
				newNextPageElement.show();
				newNextPageElement.find( '.fusion-builder-next-page-link[data-page="' + ( newPage + 1 ) + '"]' ).addClass( 'current' );

				if ( 0 === newPage ) {
					newNextPageElement.prevAll( '.fusion-builder-container' ).show();
				} else {
					newNextPageElement.prevAll( '.fusion-builder-container' ).show();
					ancestorNextPageElement.prevAll( '.fusion-builder-container' ).hide();
				}
			},

			nextPageTriggerEvent: function( event ) {
				FusionEvents.trigger( 'fusion-next-page' );

				if ( event ) {
					event.preventDefault();
					FusionEvents.trigger( 'fusion-next-page' );
				}
			}

		} );

	} );

}( jQuery ) );
;/* global FusionApp */
/* eslint no-empty-function: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Library
		FusionPageBuilder.keyBoardShorCutsView = window.wp.Backbone.View.extend( {

			template: FusionPageBuilder.template( jQuery( '#fusion-builder-front-end-keyboard-shortcuts' ).html() ),

			events: {
				'click .fusion-open-prefernces-panel': 'openPreferencePanel'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var self = this;
				this.$el.html( this.template() );

				this.$el = this.$el.dialog( {
					title: 'Keyboard Shortcuts',
					width: 600,
					height: FusionApp.dialog.dialogHeight,
					draggable: false,
					resizable: false,
					modal: true,
					dialogClass: 'fusion-builder-large-library-dialog fusion-builder-dialog fusion-builder-keyboard-shortcuts-dialog',

					open: function() {
						FusionApp.dialog.resizeDialog();
					},
					close: function() {
						self.removeDialog();
					}
				} ).closest( '.ui-dialog' );

				return this;
			},

			/**
			 * Removes the view.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			removeDialog: function() {
				this.remove();
			},

			/**
			 * Removes this view and open preference panel.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			openPreferencePanel: function() {
				this.remove();
				jQuery( '.fusion-builder-preferences' ).trigger( 'click' );
			}
		} );
	} );
}( jQuery ) );
;/* global FusionApp, FusionPageBuilderViewManager, fusionBuilderText, FusionPageBuilderApp, fusionAppConfig, FusionEvents, fusionGlobalManager */
/* eslint no-undef: 0 */
/* eslint no-alert: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Builder Library
		FusionPageBuilder.LibraryView = window.wp.Backbone.View.extend( {

			el: '#fusion-builder-front-end-library',

			events: {
				'click .fusion-tabs-menu > li > a': 'switchTab',
				'change .fusion-builder-demo-select': 'demoSelect',
				'input .fusion-builder-demo-page-link': 'demoSelectByURL',
				'click .fusion-builder-demo-button-load': 'loadDemoPage',
				'click .fusion-builder-demo-layout-button-load': 'loadDemoLayout',
				'click .ui-dialog-titlebar-close': 'removeView',
				'click .fusion-builder-layout-button-load': 'loadLayout',
				'click .fusion-builder-layout-button-save': 'saveLayout',
				'click .fusion-builder-layout-button-delete': 'deleteLayout',
				'click .fusion-builder-element-button-save': 'saveElement'
			},

			/**
			 * Init.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			initialize: function() {
				var self = this;
				jQuery( document ).on( 'click', '.fusion-builder-library-dialog .fusion-tabs-menu > li > a', function( event ) {
					self.switchTab( event );
				} );

				// Loader animation
				this.listenTo( FusionEvents, 'fusion-show-loader', this.showLoader );
				this.listenTo( FusionEvents, 'fusion-hide-loader', this.hideLoader );
			},

			showLoader: function() {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-builder-live-editor' ).css( 'height', '148px' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-builder-live-editor' ).append( '<div class="fusion-builder-element-content fusion-loader"><span class="fusion-builder-loader"></span></div>' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#fusion_builder_container' ).hide();
			},

			hideLoader: function() {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#fusion_builder_container' ).fadeIn( 'fast' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-builder-live-editor > .fusion-builder-element-content.fusion-loader' ).remove();
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-builder-live-editor' ).removeAttr( 'style' );
			},

			/**
			 * Renders the view.
			 *
			 * @since 2.0.0
			 * @return {Object} this
			 */
			render: function() {
				var self = this;

				this.$el = this.$el.dialog( {
					title: fusionBuilderText.builder_ibrary_title,
					width: FusionApp.dialog.dialogWidth,
					height: FusionApp.dialog.dialogHeight,
					draggable: false,
					resizable: false,
					modal: true,
					dialogClass: 'fusion-builder-large-library-dialog fusion-builder-dialog fusion-builder-library-dialog',

					open: function() {
						FusionApp.dialog.resizeDialog();
					},

					close: function() {
						self.removeView();
					}
				} ).closest( '.ui-dialog' );

				this.appendSave();
				this.targetTab();
				this.focusInput();

				return this;
			},

			/**
			 * Find the target tab and trigger the 'click' event on it.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			targetTab: function() {
				if ( 'undefined' !== typeof this.model.target ) {
					this.$el.find( '.fusion-tabs-menu > li > a[href="' + this.model.target + '"]' ).trigger( 'click' );
				} else {
					this.$el.find( '.fusion-tabs-menu > li:first-child > a' ).trigger( 'click' );
				}
			},

			/**
			 * Focus on an element.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			focusInput: function() {
				var self = this;
				if ( 'undefined' !== typeof this.model.focus ) {
					setTimeout( function() {
						self.$el.find( self.model.target ).find( self.model.focus ).focus();
					}, 200 );
				}
			},

			/**
			 * Appends the HTML that allows users to save an element.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			appendSave: function() {
				var elementView,
					elementSave;

				if ( 'undefined' !== typeof this.model.target && 'undefined' !== typeof this.model.element_cid ) {
					elementView = FusionPageBuilderViewManager.getView( this.model.element_cid );
					elementSave = 'undefined' !== typeof elementView.getSaveLabel ? elementView.getSaveLabel() : fusionBuilderText.save_element;
					jQuery( this.model.target ).find( '.fusion-builder-layouts-header-element-fields' ).append( '<div class="fusion-save-element-fields"><div class="save-as-global"><label><input type="checkbox" id="fusion_save_global" name="fusion_save_global">' + fusionBuilderText.save_global + '</label></div><input type="text" value="' + this.model.element_name + '" id="fusion-builder-save-element-input" class="fusion-builder-save-element-input" placeholder="' + fusionBuilderText.enter_name + '" /><a href="#" class="fusion-builder-save-column fusion-builder-element-button-save" data-element-cid="' + this.model.element_cid + '">' + elementSave + '</a></div>' );
				}
			},

			/**
			 * Switches a tab. Takes care of toggling the 'current' & 'inactive' classes
			 * and also changes the 'display' property of elements to properly make the switch.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			switchTab: function( event ) {
				var $tabLink = jQuery( event.target ),
					tab = $tabLink.attr( 'href' );

				if ( event ) {
					event.preventDefault();
				}

				FusionEvents.trigger( 'fusion-switch-element-option-tabs' );

				$tabLink.parent( 'li' ).addClass( 'current' ).removeClass( 'inactive' );
				$tabLink.parent( 'li' ).siblings().removeClass( 'current' ).addClass( 'inactive' );

				this.$el.find( '.fusion-builder-layouts-tab' ).css( 'display', 'none' );
				this.$el.find( tab ).css( 'display', 'block' );
			},

			/**
			 * Shows/Hides demos on select.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			demoSelect: function( event ) {
				var $selectedDemo = jQuery( event.target ).val();

				jQuery( '#fusion-builder-layouts-demos .fusion-page-layouts' ).addClass( 'hidden' );
				jQuery( '#fusion-builder-demo-url-invalid' ).addClass( 'hidden' );
				jQuery( '.fusion-builder-demo-page-link' ).val( '' );
				jQuery( '#fusion-builder-layouts-demos .demo-' + $selectedDemo ).removeClass( 'hidden' );
			},

			/**
			 * Shows/Hides demos on added URL change.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			demoSelectByURL: function( event ) {
				var demoPageLink = jQuery( event.target ).val(),
					demoPage,
					parentDemo,
					demoSelectorVal;

				demoPageLink = demoPageLink.replace( 'https://', '' ).replace( 'http://', '' );
				if ( '/' !== demoPageLink[ demoPageLink.length - 1 ] && ! _.isEmpty( demoPageLink ) ) {
					demoPageLink += '/';
				}

				demoPage   = jQuery( '#fusion-builder-layouts-demos' ).find( '.fusion-page-layout[data-page-link="' + demoPageLink + '"]' );
				parentDemo = demoPage.closest( '.fusion-page-layouts' );

				jQuery( '#fusion-builder-layouts-demos .fusion-page-layouts' ).addClass( 'hidden' );
				jQuery( '#fusion-builder-demo-url-invalid' ).addClass( 'hidden' );

				if ( _.isEmpty( demoPageLink ) ) {
					demoSelectorVal = jQuery( '.fusion-builder-demo-select' ).val();
					jQuery( '#fusion-builder-layouts-demos .demo-' + demoSelectorVal ).removeClass( 'hidden' );
				} else if ( ! demoPage.length ) {
					jQuery( '#fusion-builder-demo-url-invalid' ).removeClass( 'hidden' );
				} else {
					parentDemo.show();
					parentDemo.find( '.fusion-page-layout' ).hide();
					demoPage.show();
				}
			},

			/**
			 * Loads the demo pages via an ajax call.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			loadDemoPage: function( event ) {
				var pageName,
					demoName,
					postId,
					content,
					self          = this,
					frameDocument = document.getElementById( 'fb-preview' ).contentWindow.document,
					oldWrite      = frameDocument.write; // jshint ignore:line

				// Turn document write off before page request.
				frameDocument.write = function() {}; // eslint-disable-line no-empty-function
				document.write      = function() {}; // eslint-disable-line no-empty-function

				if ( event ) {
					event.preventDefault();
				}

				FusionApp.confirmationPopup( {
					title: fusionBuilderText.import_demo_page,
					content: fusionBuilderText.importing_single_page,
					actions: [
						{
							label: fusionBuilderText.cancel,
							classes: 'no',
							callback: function() {
								FusionApp.confirmationPopup( {
									action: 'hide'
								} );
							}
						},
						{
							label: fusionBuilderText.ok,
							classes: 'yes',
							callback: function() {
								if ( true === FusionPageBuilderApp.layoutIsLoading ) {
									return;
								}
								FusionPageBuilderApp.layoutIsLoading = true;
								FusionPageBuilderApp.loaded          = false;

								pageName = jQuery( event.currentTarget ).data( 'page-name' );
								demoName = jQuery( event.currentTarget ).data( 'demo-name' );
								postId   = jQuery( event.currentTarget ).data( 'post-id' );

								jQuery.ajax( {
									type: 'POST',
									url: fusionAppConfig.ajaxurl,
									data: {
										action: 'fusion_builder_load_demo',
										fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
										page_name: pageName,
										demo_name: demoName,
										post_id: postId
									},

									beforeSend: function() {
										FusionEvents.trigger( 'fusion-show-loader' );

										// Hide confirmation popup.
										FusionApp.confirmationPopup( {
											action: 'hide'
										} );

										// Hide library dialog.
										self.$el.css( 'display', 'none' );
										self.$el.next( '.ui-widget-overlay' ).css( 'display', 'none' );
									}
								} )
								.done( function( data ) {
									var dataObj,
										needsRefresh = false,
										newCustomCss = false;

									// New layout loaded
									FusionPageBuilderApp.layoutLoaded();

									dataObj = JSON.parse( data );
									newCustomCss = 'undefined' !== typeof dataObj.custom_css ? dataObj.custom_css : false;

									content = dataObj.post_content;
									if ( newCustomCss ) {
										FusionApp.data.postMeta._fusion_builder_custom_css = newCustomCss;
									}
									jQuery.each( dataObj.post_meta, function( name, value ) {
										needsRefresh = true;
										FusionApp.data.postMeta[ name ] = value[ 0 ];
									} );

									if ( 'undefined' !== typeof dataObj.page_template && FusionApp.data.postMeta._wp_page_template !== dataObj.page_template ) {
										FusionApp.data.postMeta._wp_page_template = dataObj.page_template;
										needsRefresh = true;
									}

									if ( needsRefresh ) {
										FusionApp.contentChange( 'page', 'page-option' );
									}

									FusionApp.data.postContent = content;
									FusionApp.contentChange( 'page', 'builder-content' );

									if ( newCustomCss && 'undefined' !== typeof avadaPanelIFrame ) {

										// Add the CSS to the page.
										avadaPanelIFrame.liveUpdatePageCustomCSS( newCustomCss );
									}

									// Create new builder layout.
									FusionPageBuilderApp.clearBuilderLayout( false );

									FusionPageBuilderApp.createBuilderLayout( content );

									// Refresh frame if needed.
									if ( needsRefresh ) {
										FusionApp.fullRefresh();
									}

									FusionPageBuilderApp.layoutIsLoading = false;

								} )
								.always( function() {

									// Add success/transition of some kind here.
									FusionEvents.trigger( 'fusion-hide-loader' );

									frameDocument.write = oldWrite;
									document.write      = oldWrite;

									FusionPageBuilderApp.loaded = true;
									FusionEvents.trigger( 'fusion-builder-loaded' );

									self.removeView();
								} );
							}
						}
					]
				} );
			},

			/**
			 * Loads the demo pages via an ajax call.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			loadDemoLayout: function( event ) {
				var postId,
					content,
					self          = this,
					frameDocument = document.getElementById( 'fb-preview' ).contentWindow.document,
					confirmTitle  = fusionBuilderText.import_demo_layout,
					confirmText   = fusionBuilderText.importing_demo_layout,
					oldWrite      = frameDocument.write; // jshint ignore:line

				// Turn document write off before page request.
				frameDocument.write = function() {}; // eslint-disable-line no-empty-function
				document.write      = function() {}; // eslint-disable-line no-empty-function

				if ( event ) {
					event.preventDefault();
				}

				if ( jQuery( event.target ).closest( '.fusion-builder-layouts-tab' ).is( '#fusion-builder-layouts-forms' ) ) {
					confirmText  = fusionBuilderText.importing_demo_form;
					confirmTitle = fusionBuilderText.importing_demo_form_title;
				}

				FusionApp.confirmationPopup( {
					title: confirmTitle,
					content: confirmText,
					actions: [
						{
							label: fusionBuilderText.cancel,
							classes: 'no',
							callback: function() {
								FusionApp.confirmationPopup( {
									action: 'hide'
								} );
							}
						},
						{
							label: fusionBuilderText.ok,
							classes: 'yes',
							callback: function() {
								if ( true === FusionPageBuilderApp.layoutIsLoading ) {
									return;
								}
								FusionPageBuilderApp.layoutIsLoading = true;
								FusionPageBuilderApp.loaded          = false;

								layoutName = jQuery( event.currentTarget ).data( 'layout-name' );
								postId     = jQuery( event.currentTarget ).data( 'post-id' );

								jQuery.ajax( {
									type: 'POST',
									url: fusionAppConfig.ajaxurl,
									data: {
										action: 'fusion_builder_load_demo_layout',
										fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
										layout_name: layoutName,
										post_id: postId
									},

									beforeSend: function() {
										FusionEvents.trigger( 'fusion-show-loader' );

										// Hide confirmation popup.
										FusionApp.confirmationPopup( {
											action: 'hide'
										} );

										// Hide library dialog.
										self.$el.css( 'display', 'none' );
										self.$el.next( '.ui-widget-overlay' ).css( 'display', 'none' );
									}
								} )
								.done( function( data ) {
									// New layout loaded
									FusionPageBuilderApp.layoutLoaded();

									content = data.data.post_content;

									FusionApp.data.postContent = content;
									FusionApp.contentChange( 'page', 'builder-content' );

									// If we have fusion PO data, add that too.
									if ( 'object' == typeof data.data._fusion ) {
										_.each( data.data._fusion, function( value, param ) {
											FusionApp.data.postMeta._fusion[ param ] = value;
										} );

										FusionApp.contentChange( 'page', 'page-option' );
									}

									// Create new builder layout.
									FusionPageBuilderApp.clearBuilderLayout( false );

									FusionPageBuilderApp.createBuilderLayout( content );

									FusionPageBuilderApp.layoutIsLoading = false;

								} )
								.always( function() {

									// Add success/transition of some kind here.
									FusionEvents.trigger( 'fusion-hide-loader' );

									frameDocument.write = oldWrite;
									document.write      = oldWrite;

									FusionPageBuilderApp.loaded = true;
									FusionEvents.trigger( 'fusion-builder-loaded' );

									jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-sticky-header-reinit' );

									self.removeView();
								} );
							}
						}
					]
				} );
			},

			/**
			 * Loads the layout via AJAX.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			loadLayout: function( event ) {
				var $layout,
					contentPlacement,
					content,
					self = this;

				if ( event ) {
					event.preventDefault();
				}

				if ( true === FusionPageBuilderApp.layoutIsLoading ) {
					return;
				}
				FusionPageBuilderApp.layoutIsLoading = true;

				$layout          = jQuery( event.currentTarget ).closest( '.fusion-page-layout' );
				contentPlacement = jQuery( event.currentTarget ).data( 'load-type' );

				// Get correct content.
				FusionPageBuilderApp.builderToShortcodes();
				content = FusionApp.getPost( 'post_content' ); // eslint-disable-line camelcase

				FusionPageBuilderApp.loaded = false;

				jQuery.ajax( {
					type: 'POST',
					url: fusionAppConfig.ajaxurl,
					data: {
						action: 'fusion_builder_load_layout',
						fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
						fusion_layout_id: $layout.data( 'layout_id' )
					},

					beforeSend: function() {
						FusionEvents.trigger( 'fusion-show-loader' );

						// Hide library dialog.
						self.$el.css( 'display', 'none' );
						self.$el.next( '.ui-widget-overlay' ).css( 'display', 'none' );
					}
				} )
				.done( function( data ) {
					var dataObj,
						newCustomCss,
						needsRefresh = false,
						existingCss = 'undefined' !== typeof FusionApp.data.postMeta._fusion_builder_custom_css ? FusionApp.data.postMeta._fusion_builder_custom_css : '';

					// New layout loaded
					FusionPageBuilderApp.layoutLoaded();

					dataObj = JSON.parse( data );
					newCustomCss = 'undefined' !== typeof dataObj.custom_css ? dataObj.custom_css : false;

					if ( 'above' === contentPlacement ) {
						content = dataObj.post_content + content;
						if ( newCustomCss ) {
							FusionApp.data.postMeta._fusion_builder_custom_css = newCustomCss + '\n' + existingCss;
						}

					} else if ( 'below' === contentPlacement ) {
						content = content + dataObj.post_content;
						if ( newCustomCss ) {
							FusionApp.data.postMeta._fusion_builder_custom_css = existingCss + '\n' + newCustomCss;
						}

					} else {
						content = dataObj.post_content;
						if ( newCustomCss ) {
							FusionApp.data.postMeta._fusion_builder_custom_css = newCustomCss;
						}
						jQuery.each( dataObj.post_meta, function( name, value ) {
							needsRefresh = true;
							FusionApp.data.postMeta[ name ] = value[ 0 ];
						} );

						if ( 'undefined' !== typeof dataObj.page_template && FusionApp.data.postMeta._wp_page_template !== dataObj.page_template ) {
							FusionApp.data.postMeta._wp_page_template = dataObj.page_template;
							needsRefresh = true;
						}

						if ( needsRefresh ) {
							FusionApp.contentChange( 'page', 'page-option' );
						}
					}

					FusionApp.setPost( 'post_content', content );
					FusionApp.contentChange( 'page', 'builder-content' );

					if ( needsRefresh ) {

						// Set new content and refresh frame.
						FusionApp.fullRefresh( false, {}, { post_content: content } );
					} else {
						if ( newCustomCss && 'undefined' !== typeof avadaPanelIFrame ) {

							// Add the CSS to the page.
							avadaPanelIFrame.liveUpdatePageCustomCSS( newCustomCss );
						}

						// Create new builder layout.
						FusionPageBuilderApp.clearBuilderLayout( false );
						FusionPageBuilderApp.createBuilderLayout( content );
					}

					FusionPageBuilderApp.layoutIsLoading = false;
				} )
				.always( function() {
					FusionPageBuilderApp.loaded = true;
					FusionEvents.trigger( 'fusion-builder-loaded' );

					FusionEvents.trigger( 'fusion-hide-loader' );

					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-sticky-header-reinit' );

					self.removeView();
				} );
			},

			/**
			 * Saves the layout via AJAX.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			saveLayout: function( event ) {

				var templateContent,
					templateName,
					layoutsContainer,
					currentPostID,
					customCSS,
					pageTemplate;

				if ( event ) {
					event.preventDefault();
				}

				FusionPageBuilderApp.builderToShortcodes();
				templateContent  = FusionApp.getPost( 'post_content' ); // eslint-disable-line camelcase
				templateName     = jQuery( '#new_template_name' ).val();
				layoutsContainer = jQuery( '#fusion-builder-layouts-templates .fusion-page-layouts' );
				currentPostID    = jQuery( '#fusion_builder_main_container' ).data( 'post-id' );

				customCSS    = 'undefined' !== typeof FusionApp.data.postMeta._fusion_builder_custom_css ? FusionApp.data.postMeta._fusion_builder_custom_css : '';
				pageTemplate = 'undefined' !== typeof FusionApp.data.postMeta._wp_page_template ? FusionApp.data.postMeta._wp_page_template : '';

				if ( '' !== templateName ) {

					jQuery.ajax( {
						type: 'POST',
						url: fusionAppConfig.ajaxurl,
						dataType: 'json',
						data: {
							action: 'fusion_builder_save_layout',
							fusion_po_type: 'object',
							fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
							fusion_layout_name: templateName,
							fusion_layout_content: templateContent,
							fusion_layout_post_type: 'fusion_template',
							fusion_current_post_id: currentPostID,
							fusion_custom_css: customCSS,
							fusion_page_template: pageTemplate,
							fusion_options: FusionApp.data.postMeta,
							fusion_front_end: true
						},

						complete: function( data ) {
							layoutsContainer.prepend( data.responseText );
						}
					} );

					jQuery( '#new_template_name' ).val( '' );

				} else {
					alert( fusionBuilderText.please_enter_template_name ); // jshint ignore: line
				}
			},

			/**
			 * Deletes a layout via AJAX.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			deleteLayout: function( event ) {

				var $layout;

				if ( event ) {
					event.preventDefault();

					FusionApp.confirmationPopup( {
						title: fusionBuilderText.are_you_sure,
						content: fusionBuilderText.are_you_sure_you_want_to_delete_this,
						actions: [
							{
								label: fusionBuilderText.cancel,
								classes: 'no',
								callback: function() {
									FusionApp.confirmationPopup( {
										action: 'hide'
									} );
								}
							},
							{
								label: fusionBuilderText.im_sure,
								classes: 'yes',
								callback: function() {

									if ( true === FusionPageBuilderApp.layoutIsDeleting ) {
										return;
									}
									FusionPageBuilderApp.layoutIsDeleting = true;

									$layout = jQuery( event.currentTarget ).closest( '.fusion-page-layout' );

									jQuery.ajax( {
										type: 'POST',
										url: fusionAppConfig.ajaxurl,
										data: {
											action: 'fusion_builder_delete_layout',
											fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
											fusion_layout_id: $layout.data( 'layout_id' )
										}
									} )
									.done( function() {
										$layout.remove();
										FusionPageBuilderApp.layoutIsDeleting = false;
									} );

									FusionApp.confirmationPopup( {
										action: 'hide'
									} );
								}
							}
						]
					} );
				}
			},

			/**
			 * Saves an element via AJAX.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			saveElement: function( event ) {
				var elementName      = jQuery( '#fusion-builder-save-element-input' ).val(),
					layoutsContainer = jQuery( this.model.target ).find( '.fusion-page-layouts' ),
					saveGlobal       = jQuery( this.model.target ).find( '#fusion_save_global' ).is( ':checked' ),
					elementView      = FusionPageBuilderViewManager.getView( this.model.element_cid ),
					elementContent   = elementView.getContent(),
					elementCategory  = 'undefined' !== typeof elementView.getCategory ? elementView.getCategory() : 'elements',
					isDuplicate      = false,
					oldGLobalID      = null,
					wrapperClass     = '',
					params           = {};

				if ( event ) {
					event.preventDefault();
				}

				if ( 'undefined' !== typeof elementView.model.attributes.params && 'undefined' !== typeof elementView.model.attributes.params.fusion_global ) {

					// Make a copy.
					oldGLobalID = elementView.model.attributes.params.fusion_global;
					params      = elementView.model.get( 'params' );

					// Remove temporarily and update model
					delete params.fusion_global;
					elementView.model.set( 'params', params );

					// Get content.
					elementContent   = elementView.getColumnContent();

					// Add it back.
					params.fusion_global = oldGLobalID;
					elementView.model.set( 'params', params );
				}

				switch ( elementCategory ) {
					case 'sections':
						wrapperClass = 'ul.fusion-page-layouts.fusion-layout-sections li';
						break;

					case 'columns':
						wrapperClass = 'ul.fusion-page-layouts.fusion-layout-columns li';
						break;

					case 'elements':
						wrapperClass = 'ul.fusion-page-layouts.fusion-layout-elements li';
						break;
				}

				jQuery.each( jQuery( wrapperClass ), function() {
					var templateName = jQuery( this ).find( 'h4.fusion-page-layout-title' ).html().split( '<div ' )[ 0 ];
					templateName     = templateName.replace( /\u2013|\u2014/g, '-' );

					if ( elementName.toLowerCase().trim() === templateName.toLowerCase().trim() ) {
						alert( fusionBuilderText.duplicate_element_name_error ); // jshint ignore:line
						isDuplicate = true;
						return false;
					}
				} );

				if ( true === FusionPageBuilderApp.layoutIsSaving || true === isDuplicate ) {
					return;
				}
				FusionPageBuilderApp.layoutIsSaving = true;

				if ( '' !== elementName ) {
					jQuery.ajax( {
						type: 'POST',
						url: fusionAppConfig.ajaxurl,
						dataType: 'json',
						data: {
							action: 'fusion_builder_save_layout',
							fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
							fusion_layout_name: elementName,
							fusion_layout_content: elementContent,
							fusion_layout_post_type: 'fusion_element',
							fusion_layout_new_cat: elementCategory,
							fusion_save_global: saveGlobal,
							fusion_front_end: true
						},
						complete: function( data ) {
							var MultiGlobalArgs,
								cid      = elementView.model.get( 'cid' ),
								globalID = jQuery( data.responseText ).attr( 'data-layout_id' );

							FusionPageBuilderApp.layoutIsSaving = false;
							layoutsContainer.prepend( data.responseText );
							jQuery( '.fusion-save-element-fields' ).remove();

							// If global, make it.
							if ( saveGlobal ) {

								// For nested elements.
								if ( 'undefined' === typeof elementView.model.attributes.params ) {
									elementView.model.attributes.params = {};
								}

								elementView.model.attributes.params.fusion_global = globalID;

								if ( 'sections' === elementCategory ) {
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"] .fusion-builder-module-controls-type-container .fusion-builder-module-controls' ).after( '<a href="#" class="fusion-builder-container-global fusion-builder-module-control fusion-builder-unglobal-tooltip" data-cid=' + cid + '><span class="fusiona-globe"></span><span class="fusion-container-tooltip"><span class="fusion-tooltip-text">' + fusionBuilderText.global_container + '</span></span></a>' );
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"] .fusion-builder-wireframe-utility-toolbar' ).first().append( '<a href="#" class="fusion-builder-container-global fusion-builder-module-control fusion-builder-unglobal-tooltip" data-cid=' + cid + '><span class="fusiona-globe"></span><span class="fusion-container-tooltip"><span class="fusion-tooltip-text">' + fusionBuilderText.global_container + '</span></span></a>' );
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"]' ).addClass( 'fusion-global-container' );
								} else if ( 'columns' === elementCategory ) {
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"] .fusion-builder-module-controls-inner.fusion-builder-column-controls-inner' ).after( '<a href="#" class="fusion-builder-column-global fusion-builder-module-control fusion-builder-unglobal-tooltip" data-cid=' + cid + '><span class="fusiona-globe"></span><span class="fusion-column-tooltip"><span class="fusion-tooltip-text">' + fusionBuilderText.global_column + '</span></span></a>' );
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"] .fusion-builder-wireframe-utility-toolbar' ).first().append( '<a href="#" class="fusion-builder-column-global fusion-builder-module-control fusion-builder-unglobal-tooltip" data-cid=' + cid + '><span class="fusiona-globe"></span><span class="fusion-column-tooltip"><span class="fusion-tooltip-text">' + fusionBuilderText.global_column + '</span></span></a>' );
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"]' ).addClass( 'fusion-global-column' );
								} else if ( 'elements' === elementCategory && 'undefined' !== typeof elementView.model.get( 'multi' ) && 'multi_element_parent' === elementView.model.get( 'multi' ) ) {
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"]' ).addClass( 'fusion-global-parent-element' );
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"] .fusion-builder-module-controls-inner' ).after( '<a href="#" class="fusion-builder-element-global fusion-builder-module-control fusion-builder-unglobal-tooltip" data-cid=' + cid + '><span class="fusiona-globe"></span><span class="fusion-element-tooltip"><span class="fusion-tooltip-text">' + fusionBuilderText.global_element + '</span></span></a>' );
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"] .fusion-builder-wireframe-utility-toolbar' ).first().append( '<a href="#" class="fusion-builder-element-global fusion-builder-module-control fusion-builder-unglobal-tooltip" data-cid=' + cid + '><span class="fusiona-globe"></span><span class="fusion-element-tooltip"><span class="fusion-tooltip-text">' + fusionBuilderText.global_element + '</span></span></a>' );
								} else if ( 'elements' === elementCategory && 'fusion_builder_row_inner' === elementView.model.get( 'element_type' )  ) {
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"]' ).addClass( 'fusion-global-nested-row' );
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"] .fusion-builder-module-controls-inner' ).after( '<a href="#" class="fusion-builder-element-global fusion-builder-module-control fusion-builder-unglobal-tooltip" data-cid=' + cid + '><span class="fusiona-globe"></span><span class="fusion-element-tooltip"><span class="fusion-tooltip-text">' + fusionBuilderText.global_element + '</span></span></a>' );
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"] .fusion-builder-wireframe-utility-toolbar' ).last().append( '<a href="#" class="fusion-builder-element-global fusion-builder-module-control fusion-builder-unglobal-tooltip" data-cid=' + cid + '><span class="fusiona-globe"></span><span class="fusion-element-tooltip">' + fusionBuilderText.global_element + '</span></span></a>' );
								} else if ( 'elements' === elementCategory  ) {
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"]' ).addClass( 'fusion-global-element' );
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"] .fusion-builder-module-controls-inner' ).after( '<a href="#" class="fusion-builder-element-global fusion-builder-module-control fusion-builder-unglobal-tooltip" data-cid=' + cid + '><span class="fusiona-globe"></span><span class="fusion-element-tooltip"><span class="fusion-tooltip-text">' + fusionBuilderText.global_element + '</span></span></a>' );
									FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"] .fusion-builder-wireframe-utility-toolbar' ).first().append( '<a href="#" class="fusion-builder-element-global fusion-builder-module-control fusion-builder-unglobal-tooltip" data-cid=' + cid + '><span class="fusiona-globe"></span><span class="fusion-element-tooltip"><span class="fusion-tooltip-text">' + fusionBuilderText.global_element + '</span></span></a>' );
								}

								FusionPageBuilderApp.$el.find( 'div[data-cid="' + cid + '"]' ).attr( 'fusion-global-layout', globalID );
								FusionEvents.trigger( 'fusion-element-added' );
								FusionPageBuilderApp.saveGlobal = true;

								// Check for globals.
								MultiGlobalArgs = {
									currentModel: elementView.model,
									handleType: 'save',
									attributes: elementView.model.attributes
								};
								setTimeout( fusionGlobalManager.handleMultiGlobal, 500, MultiGlobalArgs );

								// Save history
								FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.saved + ' ' + fusionAllElements[ elementView.model.get( 'element_type' ) ].name + ' ' + fusionBuilderText.as_global );

								if ( 'undefined' !== typeof FusionApp.contentChange ) {
									FusionApp.contentChange( 'page', 'builder-content' );
								}
							}
						}
					} );

				} else {
					alert( fusionBuilderText.please_enter_element_name ); // jshint ignore: line
				}
			},

			/**
			 * Removes the view.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			removeView: function() {
				this.$el.find( '.fusion-save-element-fields' ).remove();
				this.$el.find( '.fusion-builder-modal-top-container' ).prependTo( '#fusion-builder-front-end-library' );

				FusionApp.dialogCloseResets( this );

				this.remove();
			}
		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderViewManager, FusionPageBuilderApp */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {
		FusionPageBuilder.Wireframe = Backbone.Model.extend( {

			initialize: function() {
				this.listenTo( window.FusionEvents, 'fusion-preview-update', this.updateWireframe );
				this.listenTo( window.FusionEvents, 'fusion-builder-loaded', this.openWireframeAfterFullRefresh );
				this.listenTo( window.FusionEvents, 'fusion-undo-state', this.setUpWireFrameAfterUndo );
			},

			updateWireframe: function( id, value ) {
				if ( 'site_width' === id ) {
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-builder-ui-wireframe' ).find( '#fusion_builder_container' ).css( 'max-width', value );
				}
			},

			/**
			 * Re-opens Wireframe mode after full refresh.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			openWireframeAfterFullRefresh: function() {
				if ( FusionPageBuilderApp.wireframeActive ) {
					jQuery( 'body' ).removeClass( 'fusion-builder-ui-wireframe' );
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).removeClass( 'fusion-builder-ui-wireframe' );
					this.toggleWireframe();
				}
			},

			/**
			 * Sets Up wireframe after history undo.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			setUpWireFrameAfterUndo: function( event ) {
				var contentWindow                   = jQuery( '#fb-preview' )[ 0 ].contentWindow,
					fusionBuilderContainer          = contentWindow.jQuery( 'body' ).find( '#fusion_builder_container' ),
					fusionBuilderContainerOffsetTop = fusionBuilderContainer.offset().top,
					fusionHeaderWrapper             = contentWindow.jQuery( 'body' ).find( '.fusion-header-wrapper' ),
					fusionHeaderWrapperOffsetBottom = fusionHeaderWrapper.length ? fusionHeaderWrapper.offset().top + fusionHeaderWrapper.outerHeight() : 0;

				if ( event ) {
					event.preventDefault();
				}
				setTimeout( function() {

					if ( contentWindow.jQuery( 'body' ).hasClass( 'fusion-builder-ui-wireframe' ) ) {
						fusionBuilderContainer.css( 'max-width', window.FusionApp.settings.site_width );

						if ( fusionHeaderWrapperOffsetBottom > fusionBuilderContainerOffsetTop ) {
							fusionBuilderContainer.css( 'margin-top', ( fusionHeaderWrapperOffsetBottom + 25 ) + 'px' );
						}
					} else {
						fusionBuilderContainer.css( {
							'margin-top': '',
							'max-width': ''
						} );
					}

					window.FusionEvents.trigger( 'fusion-wireframe-toggle' );
				}, 100 );
			},

			/**
			 * Toggles the 'fusion-builder-ui-wireframe' class.
			 *
			 * @since 2.0.0
			 * @param {Object} event - The event.
			 * @return {void}
			 */
			toggleWireframe: function( event ) {
				var contentWindow                   = jQuery( '#fb-preview' )[ 0 ].contentWindow,
					fusionBuilderContainer          = contentWindow.jQuery( 'body' ).find( '#fusion_builder_container' ),
					fusionBuilderContainerOffsetTop = fusionBuilderContainer.offset().top,
					fusionHeaderWrapper             = contentWindow.jQuery( 'body' ).find( '.fusion-header-wrapper' ),
					fusionHeaderWrapperOffsetBottom = fusionHeaderWrapper.length ? fusionHeaderWrapper.offset().top + fusionHeaderWrapper.outerHeight() : 0;

				if ( event ) {
					event.preventDefault();
				}
				setTimeout( function() {
					jQuery( 'body' ).toggleClass( 'fusion-builder-ui-wireframe' );
					jQuery( '.fusion-builder-wireframe-toggle' ).toggleClass( 'active' );
					contentWindow.jQuery( 'body' ).toggleClass( 'fusion-builder-ui-wireframe' );

					if ( contentWindow.jQuery( 'body' ).hasClass( 'fusion-builder-ui-wireframe' ) ) {
						FusionPageBuilderApp.wireframeActive = true;
						fusionBuilderContainer.css( 'max-width', window.FusionApp.settings.site_width );

						if ( fusionHeaderWrapperOffsetBottom > fusionBuilderContainerOffsetTop ) {
							fusionBuilderContainer.css( 'margin-top', ( fusionHeaderWrapperOffsetBottom + 25 ) + 'px' );
						}

						// Close nested column edit mode if needed.
						if ( contentWindow.jQuery( 'body' ).hasClass( 'nested-columns-edited' ) ) {
							FusionPageBuilderViewManager.getView( contentWindow.jQuery( '.fusion-builder-nested-element.editing' ).data( 'cid' ) ).stopEdit();
						}
					} else {
						FusionPageBuilderApp.wireframeActive = false;
						fusionBuilderContainer.css( {
							'margin-top': '',
							'max-width': ''
						} );
					}

					window.FusionEvents.trigger( 'fusion-wireframe-toggle' );
				}, 100 );
			}

		} );

		// Column sortables
		_.extend( FusionPageBuilder.BaseColumnView.prototype, {

			/**
			 * Destroy or disable element sortable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			disableSortableElements: function() {
				var sortableContainer = this.$el.find( '.fusion-builder-column-content' );

				if ( 'undefined' !== typeof sortableContainer.sortable( 'instance' ) ) {
					sortableContainer.sortable( 'disable' );
				}

				sortableContainer.removeClass( 'ui-sortable' );
				sortableContainer.removeClass( 'ui-sortable-disabled' );
			},

			/**
			 * Initialize or enable the element sortable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			enableSortableElements: function() {
				var sortableContainer = this.$el.find( '.fusion-builder-column-content' ),
					sortables;

				if ( 'fusion_builder_column' === this.model.get( 'element_type' ) ) {
					sortables = 'undefined' !== typeof sortableContainer.sortable( 'instance' ) ? true : false;
				} else {
					sortables = sortableContainer.data( 'sortable' );
				}

				if ( sortables ) {
					sortableContainer.sortable( 'enable' );
					sortableContainer.addClass( 'ui-sortable' );
				} else {
					this.sortableElements();
				}

			},

			/**
			 * Fired when wireframe mode is toggled.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			wireFrameToggled: function() {
				if ( FusionPageBuilderApp.wireframeActive ) {
					this.disableDroppableColumn();
					this.enableSortableElements();
				} else {
					this.enableDroppableColumn();
					this.disableSortableElements();
					this._equalHeights();
				}
			},

			onSortOver: function( event ) {

				// Move sortable palceholder above +Element button for empty columns.
				if ( 1 === jQuery( event.target ).find( '.fusion-builder-live-element, .fusion_builder_row_inner' ).length ) {
					jQuery( event.target ).find( '.fusion-builder-column-content' ).append( '.ui-sortable-placeholder' );
				}
			},

			onSortUpdate: function() {
				this._equalHeights();
			},

			onSortStop: function( event, ui ) {
				var elementView = window.FusionPageBuilderViewManager.getView( ui.item.data( 'cid' ) ),
					newIndex    = ui.item.parent().children( '.fusion-builder-live-element, .fusion_builder_row_inner' ).index( ui.item ),
					MultiGlobalArgs;

				// Update collection
				window.FusionPageBuilderApp.onDropCollectionUpdate( elementView.model, newIndex, ui.item.parent().data( 'cid' ) );

				// Handle multiple global elements.
				MultiGlobalArgs = {
					currentModel: elementView.model,
					handleType: 'save',
					attributes: elementView.model.attributes
				};
				window.fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );

				// Save history
				window.FusionEvents.trigger( 'fusion-history-save-step', window.fusionBuilderText.moved + ' ' + window.fusionAllElements[ elementView.model.get( 'element_type' ) ].name + ' ' + window.fusionBuilderText.element );

				window.FusionEvents.trigger( 'fusion-content-changed' );
			}
		} );

		// Row sortables
		_.extend( FusionPageBuilder.BaseRowView.prototype, {

			/**
			 * Initialize or enable the column sortable.
			 *
			 * @since 2.0.0
			 * @return {void}
			 */
			enableSortableColumns: function() {
				var rowContainer = this.$el.find( '.fusion-builder-row-container' ),
					sortables;

				if ( 'fusion_builder_row' === this.model.get( 'element_type' ) ) {
					sortables = 'undefined' !== typeof rowContainer.sortable( 'instance' ) ? true : false;
				} else {
					sortables = rowContainer.data( 'sortable' );
				}

				if ( sortables ) {
					rowContainer.sortable( 'enable' );
				} else {
					this.sortableColumns();
				}
			},

			onSortUpdate: function() {
				return undefined;
			},

			onSortStop: function( event, ui, items ) {
				var elementCid  = ui.item.data( 'cid' ),
					elementView = window.FusionPageBuilderViewManager.getView( elementCid ),
					originalCid = elementView.model.get( 'parent' ),
					parentCid   = ui.item.parent().data( 'cid' ),
					newIndex    = ui.item.parent().children( items ).index( ui.item ),
					originalView,
					destinationRow;

				// Update collection.
				window.FusionPageBuilderApp.onDropCollectionUpdate( elementView.model, newIndex, parentCid );

				destinationRow = FusionPageBuilderViewManager.getView( parentCid );
				destinationRow.setRowData();

				// If destination row and original row are different, update original as well.
				if ( parentCid !== originalCid ) {
					originalView = FusionPageBuilderViewManager.getView( originalCid );
					originalView.setRowData();
				}

				// History.
				window.FusionEvents.trigger( 'fusion-history-save-step', window.fusionBuilderText.column + ' order changed' );
			}
		} );
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	FusionPageBuilder.SettingsHelpers = Backbone.Model.extend( {

		/**
		 * Init.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		initialize: function( ) {
			this.openSettingsView      = null;
			this.openChildSettingsView = null;

			this.modalDialogMoreView   = null;

			this.listenTo( window.FusionEvents, 'fusion-settings-modal-save', this.removeElementSettingsView );
			this.listenTo( window.FusionEvents, 'fusion-settings-modal-cancel', this.removeElementSettingsView );
			this.listenTo( window.FusionEvents, 'fusion-settings-removed', this.removeElementSettingsView );

			this.listenTo( window.FusionEvents, 'fusion-preferences-editing_mode-updated', this.editingModeChanged );
		},

		/**
		 * Check if element settings panel (dialog) should be rendered or not.
		 *
		 * @since 2.0.0
		 * @param {string} view - Element View.
		 * @return {boolean}
		 */
		shouldRenderSettings: function( view ) {
			var modelParent = view.model.get( 'parent' ),
				isChild     = 'multi_element_child' === view.model.get( 'multi' ),
				modelCid    = view.model.get( 'cid' ),
				generated   = 'generated_element' === view.model.get( 'type' ),
				rendered    = false,
				$editPanel  = 'dialog' === window.FusionApp.preferencesData.editing_mode ? jQuery( '.fusion-builder-dialog.fusion-builder-settings-dialog .ui-dialog-content' ) : window.FusionApp.sidebarView.$el.find( '.fusion-builder-custom-tab' ),
				panelCid,
				$panelWrap;

			if ( generated ) {
				if ( jQuery( '.ui-dialog-content[data-cid="' + modelCid + '"]' ).length ) {
					jQuery( '.ui-dialog-content[data-cid="' + modelCid + '"]' ).closest( '.ui-dialog' ).show();
					return false;
				}
				if ( jQuery( '.ui-dialog-content:not( [data-cid="' + modelCid + '"] )' ).length ) {
					jQuery( '.ui-dialog-content:not( [data-cid="' + modelCid + '"] )' ).closest( '.ui-dialog' ).hide();
				}
				return true;
			}

			if ( $editPanel.length ) {

				// Check if panel is already open, if so do nothing.
				$editPanel.each( function() {
					panelCid   = jQuery( this ).attr( 'data-cid' );
					$panelWrap = 'dialog' === window.FusionApp.preferencesData.editing_mode ? jQuery( this ).closest( '.fusion-builder-dialog.fusion-builder-settings-dialog' ) : jQuery( this );

					if ( parseInt( modelCid, 10 ) === parseInt( panelCid, 10 ) ) {
						$panelWrap.show();
						rendered = true;

						// continue.
						return;
					}

					$panelWrap.hide();
				} );

			}

			// Show panel if it is already rendered.
			if ( rendered ) {

				// If not dialog we have to show correct sidebar tab before exit.
				if ( 'dialog' !== window.FusionApp.preferencesData.editing_mode ) {
					window.FusionApp.sidebarView.openSidebarAndShowEOTab();
				}

				return false;
			}

			// Remove the parent view unless its a direct parent of what we want to edit.
			if ( this.openSettingsView ) {
				if ( isChild && modelParent === this.openSettingsView.model.get( 'cid' ) && 'multi_element_parent' === this.openSettingsView.model.get( 'multi' ) ) {

					if ( 'dialog' === window.FusionApp.preferencesData.editing_mode ) {
						this.openSettingsView.$el.closest( '.fusion-builder-dialog.fusion-builder-settings-dialog' ).hide();
					} else {
						this.openSettingsView.$el.hide();
					}

				} else {
					this.openSettingsView.saveSettings();
				}
			}

			// If we have open child view, remove it.
			if ( this.openChildSettingsView ) {
				this.openChildSettingsView.saveSettings();
			}

			// Set newly opened view to access.
			if ( ! isChild ) {
				this.openSettingsView = view;
			} else {
				this.openChildSettingsView = view;
			}

			return true;
		},

		removeElementSettingsView: function( cid ) {
			if ( this.openSettingsView && cid === this.openSettingsView.model.get( 'cid' ) ) {
				this.openSettingsView  = false;
			}
			if ( this.openChildSettingsView && cid === this.openChildSettingsView.model.get( 'cid' ) ) {
				this.openChildSettingsView = false;
			}
		},

		/**
         * Render dialog more options template.
         *
         * @since 2.0.0
         * @param {Object} view - The view.
         * @param {Object} event - The event.
         * @return {void}
         */
		renderDialogMoreOptions: function( view ) {
			var $wrap = 'dialog' === window.FusionApp.preferencesData.editing_mode ? view.$el.closest( '.ui-dialog' ).find( '.fusion-utility-menu-wrap' ) : view.$el.find( '.fusion-utility-menu-wrap' );

			this.modalDialogMoreView = new FusionPageBuilder.modalDialogMore( { model: this.model } );

			jQuery( this.modalDialogMoreView.render( { view: view } ).el ).appendTo( $wrap );

			// After child modal is closed 'click' is attached again.
			$wrap.find( '.fusion-utility-menu' ).off().on( 'click', function( event ) {
				$wrap = jQuery( this ).closest( '.fusion-utility-menu-wrap' );

				$wrap.toggleClass( 'active' );

				event.stopPropagation();
				window.FusionPageBuilderApp.sizesHide( event );
			} );
		},

		/**
         * Things to be done when editing_mode pregerence is changed.
         */
		editingModeChanged: function() {
			if ( this.openSettingsView ) {
				this.openSettingsView.saveSettings();
			}
			if ( this.openChildSettingsView ) {
				this.openChildSettingsView.saveSettings();
			}
		}

	} );
}( jQuery ) );
;/* global FusionPageBuilderViewManager */
/* eslint no-useless-escape: 0 */
/* eslint max-depth: 0 */
/* eslint no-continue: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

_.mixin( {

	/**
	 * The FusionBuilder::attributes() function from PHP, translated to JS.
	 *
	 * @since 2.0.0
	 * @param {Object|string} attributes - The attributes.
	 * @return {string} Ready to use in templates/HTML.
	 */
	fusionGetAttributes: function( attributes ) {
		var out = '';
		if ( 'string' === typeof attributes ) {
			return 'class="' + attributes + '"';
		}
		_.each( attributes, function( value, name ) {
			if ( 'undefined' !== typeof value ) {
				value = value.toString();

				if ( 'valueless_attribute' === value ) {
					out += ' ' + name;
				} else if ( 0 < value.length ) {
					value = value.replace( /\s\s+/g, ' ' );
					out += ' ' + name + '="' + value + '"';
				}
			}
		} );
		return out;
	},

	/**
	 * Remove empty values from params so when merging with defaults, the defaults are used.
	 *
	 * @since 2.0.0
	 * @param {Object} params - The parameters.
	 * @return {Object} - Returns the params.
	 */
	fusionCleanParameters: function( params ) {
		Object.keys( params ).forEach( function( key ) {
			if ( params[ key ] && 'object' === typeof params[ key ] ) {
				_.fusionCleanParameters( params[ key ] );
			} else if ( null === params[ key ] || '' === params[ key ] ) {
				delete params[ key ];
			}
		} );
		return params;
	},

	/**
	 * Builds section title element.
	 *
	 * @since 2.2
	 * @param {Object} values - The values.
	 * @param {Object} extras - The extras.
	 * @return {string}
	 */
	buildTitleElement: function( values, extras, headingContent ) {
		var contentAlign = jQuery( 'body' ).hasClass( 'rtl' ) ? 'right' : 'left',
			size         = parseInt( values.heading_size ),
			sizeArray  = [
				'one',
				'two',
				'three',
				'four',
				'five',
				'six'
			],
			output = '',
			styles = '',
			headingStyles   = '',
			classes         = '',
			wrapperClasses  = '',
			marginTop       = extras.title_margin.top,
			marginBottom    = extras.title_margin.bottom,
			sepColor        = extras.title_border_color,
			styleType       = extras.title_style_type,
			underlineOrNone = -1 !== styleType.indexOf( 'underline' ) || -1 !== styleType.indexOf( 'none' );

		// Render title.

		_.each( styleType.split( ' ' ), function( className ) {
			classes += ' sep-' + className;
		} );

		wrapperClasses = ' fusion-title fusion-title-size-' + sizeArray[ size - 1 ] + classes;

		if ( marginTop ) {
			styles += 'margin-top:' + _.fusionGetValueWithUnit( marginTop ) + ';';
		}
		if ( marginBottom ) {
			styles += 'margin-bottom:' +  _.fusionGetValueWithUnit( marginBottom ) + ';';
		}

		if ( '' !== marginTop || '' !== marginBottom ) {
			headingStyles += 'margin:0;';
		}

		if ( false !== underlineOrNone ) {

			if ( -1 !== styleType.indexOf( 'underline' ) && sepColor ) {
				styles += 'border-bottom-color:' + sepColor + ';';
			} else if ( -1 !== styleType.indexOf( 'none' ) ) {
				classes += ' fusion-sep-none';
			}
		}

		output += '<div class="' + wrapperClasses + '" style="' + styles + '">';
		if ( false === underlineOrNone && 'right' === contentAlign ) {
			output += '<div class="title-sep-container">';
			output += '<div class="title-sep' + classes + '"></div>';
			output += '</div>';
		}

		output += '<h' + size + ' class="title-heading-' + contentAlign + '" style="' + headingStyles + '">';
		output += headingContent;
		output += '</h' + size + '>';

		if ( false === underlineOrNone && 'left' === contentAlign ) {
			output += '<div class="title-sep-container">';
			output += '<div class="title-sep' + classes + '"></div>';
			output += '</div>';
		}
		output += '</div>';

		return output;
	},

	/**
	 * Copy of our fusion_builder_visibility_atts() function in PHP.
	 *
	 * @since 2.0.0
	 * @param {string}        selection - The selection.
	 * @param {Object|string} attr - The attributes.
	 * @return {Object} The attributes modified to accomodate visibility options from the selection parameter.
	 */
	fusionVisibilityAtts: function( selection, attr ) {

		var allVisibilityValues = [
				'small-visibility',
				'medium-visibility',
				'large-visibility'
			],
			visibilityValues = allVisibilityValues,
			visibilityOptions;

		// If empty, show all.
		if ( '' === selection ) {
			selection = visibilityValues;
		}

		// If no is used, change that to all options selected, as fallback.
		if ( 'no' === selection ) {
			selection = visibilityValues;
		}

		// If yes is used, use all selections with mobile visibility removed.
		if ( 'yes' === selection ) {
			visibilityValues = visibilityValues.filter( function( e ) {
				return 'small-visibility' !== e;
			} );
			selection = visibilityValues;
		}

		// Make sure the selection is an array.
		if ( 'string' === typeof selection ) {
			selection = selection.split( ',' );
			_.each( selection, function( value, key ) {
				selection[ key ] = value.replace( new RegExp( ' ', 'g' ), '' );
			} );
		}

		visibilityOptions = allVisibilityValues;
		_.each( visibilityOptions, function( visibilityOption ) {
			if ( selection && -1 === selection.indexOf( visibilityOption ) ) {
				if ( 'object' === typeof attr ) {
					attr[ 'class' ] += ' fusion-no-' + visibilityOption;
				} else {
					attr += ' fusion-no-' + visibilityOption;
				}
			}
		} );

		return attr;
	},

	/**
	 * Returns the available animation types.
	 *
	 * @since 2.1
	 * @return {Object} Animation types.
	 */
	fusionGetAnimationTypes: function() {
		var animations = [
			'bounce',
			'fadeIn',
			'fadeInUp',
			'fadeInDown',
			'fadeInLeft',
			'fadeInRight',
			'flash',
			'rubberBand',
			'shake',
			'slideIn',
			'slideInUp',
			'slideInDown',
			'slideInLeft',
			'slideInRight',
			'zoomIn',
			'zoomInUp',
			'zoomInDown',
			'zoomInRight',
			'zoomInLeft'
		];

		return animations;
	},

	/**
	 * The FusionBuilder::animations() function from PHP, translated to JS.
	 *
	 * @since 2.0.0
	 * @param {Object}       args - The arguments.
	 * @param {string}       args.type - The animation type.
	 * @param {string}       args.direction - The animation direction.
	 * @param {string|number} args.speed - The animation speed, in seconds.
	 * @param {string}       args.offset - The animation offset.
	 * @return {Object} Animation attributes.
	 */
	fusionGetAnimations: function( args ) {
		var animationAttributes = {},
			directionSuffix,
			offset;

		args = _.defaults( args, {
			type: '',
			direction: 'left',
			speed: '0.1',
			offset: 'bottom-in-view'
		} );

		if ( args.type ) {

			animationAttributes.animation_class = 'fusion-animated';

			if ( 'static' === args.direction ) {
				args.direction = '';
			}

			if ( 'bounce' !== args.type && 'flash' !== args.type && 'shake' !== args.type && 'rubberBand' !== args.type ) {
				directionSuffix = 'In' + args.direction.charAt( 0 ).toUpperCase() + args.direction.slice( 1 );
				args.type += directionSuffix;
			}

			animationAttributes[ 'data-animationType' ] = args.type;

			if ( args.speed ) {
				animationAttributes[ 'data-animationDuration' ] = args.speed;
			}
		}

		if ( args.offset ) {
			offset = args.offset;
			if ( 'top-into-view' === args.offset ) {
				offset = '100%';
			} else if ( 'top-mid-of-view' === args.offset ) {
				offset = '50%';
			}
			animationAttributes[ 'data-animationOffset' ] = offset;
		}

		return animationAttributes;

	},

	/**
	 * The FusionBuilder::font_awesome_name_handler() function from PHP, translated to JS.
	 *
	 * @since 2.0.0
	 * @param {string} icon - The icon we want.
	 * @return {string} - Returns the icon.
	 */
	fusionFontAwesome: function( icon ) {
		var oldIcons = {
				arrow: 'angle-right',
				asterik: 'asterisk',
				cross: 'times',
				'ban-circle': 'ban',
				'bar-chart': 'bar-chart-o',
				beaker: 'flask',
				bell: 'bell-o',
				'bell-alt': 'bell',
				'bitbucket-sign': 'bitbucket-square',
				'bookmark-empty': 'bookmark-o',
				building: 'building-o',
				'calendar-empty': 'calendar-o',
				'check-empty': 'square-o',
				'check-minus': 'minus-square-o',
				'check-sign': 'check-square',
				check: 'check-square-o',
				'chevron-sign-down': 'chevron-circle-down',
				'chevron-sign-left': 'chevron-circle-left',
				'chevron-sign-right': 'chevron-circle-right',
				'chevron-sign-up': 'chevron-circle-up',
				'circle-arrow-down': 'arrow-circle-down',
				'circle-arrow-left': 'arrow-circle-left',
				'circle-arrow-right': 'arrow-circle-right',
				'circle-arrow-up': 'arrow-circle-up',
				'circle-blank': 'circle-o',
				cny: 'rub',
				'collapse-alt': 'minus-square-o',
				'collapse-top': 'caret-square-o-up',
				collapse: 'caret-square-o-down',
				'comment-alt': 'comment-o',
				'comments-alt': 'comments-o',
				copy: 'files-o',
				cut: 'scissors',
				dashboard: 'tachometer',
				'double-angle-down': 'angle-double-down',
				'double-angle-left': 'angle-double-left',
				'double-angle-right': 'angle-double-right',
				'double-angle-up': 'angle-double-up',
				download: 'arrow-circle-o-down',
				'download-alt': 'download',
				'edit-sign': 'pencil-square',
				edit: 'pencil-square-o',
				'ellipsis-horizontal': 'ellipsis-h',
				'ellipsis-vertical': 'ellipsis-v',
				'envelope-alt': 'envelope-o',
				'exclamation-sign': 'exclamation-circle',
				'expand-alt': 'plus-square-o',
				expand: 'caret-square-o-right',
				'external-link-sign': 'external-link-square',
				'eye-close': 'eye-slash',
				'eye-open': 'eye',
				'facebook-sign': 'facebook-square',
				'facetime-video': 'video-camera',
				'file-alt': 'file-o',
				'file-text-alt': 'file-text-o',
				'flag-alt': 'flag-o',
				'folder-close-alt': 'folder-o',
				'folder-close': 'folder',
				'folder-open-alt': 'folder-open-o',
				food: 'cutlery',
				frown: 'frown-o',
				fullscreen: 'arrows-alt',
				'github-sign': 'github-square',
				group: 'users',
				'h-sign': 'h-square',
				'hand-down': 'hand-o-down',
				'hand-left': 'hand-o-left',
				'hand-right': 'hand-o-right',
				'hand-up': 'hand-o-up',
				hdd: 'hdd-o',
				'heart-empty': 'heart-o',
				hospital: 'hospital-o',
				'indent-left': 'outdent',
				'indent-right': 'indent',
				'info-sign': 'info-circle',
				keyboard: 'keyboard-o',
				legal: 'gavel',
				lemon: 'lemon-o',
				lightbulb: 'lightbulb-o',
				'linkedin-sign': 'linkedin-square',
				meh: 'meh-o',
				'microphone-off': 'microphone-slash',
				'minus-sign-alt': 'minus-square',
				'minus-sign': 'minus-circle',
				'mobile-phone': 'mobile',
				moon: 'moon-o',
				move: 'arrows',
				off: 'power-off',
				'ok-circle': 'check-circle-o',
				'ok-sign': 'check-circle',
				ok: 'check',
				'paper-clip': 'paperclip',
				paste: 'clipboard',
				'phone-sign': 'phone-square',
				picture: 'picture-o',
				'pinterest-sign': 'pinterest-square',
				'play-circle': 'play-circle-o',
				'play-sign': 'play-circle',
				'plus-sign-alt': 'plus-square',
				'plus-sign': 'plus-circle',
				pushpin: 'thumb-tack',
				'question-sign': 'question-circle',
				'remove-circle': 'times-circle-o',
				'remove-sign': 'times-circle',
				remove: 'times',
				reorder: 'bars',
				'resize-full': 'expand',
				'resize-horizontal': 'arrows-h',
				'resize-small': 'compress',
				'resize-vertical': 'arrows-v',
				'rss-sign': 'rss-square',
				save: 'floppy-o',
				screenshot: 'crosshairs',
				'share-alt': 'share',
				'share-sign': 'share-square',
				share: 'share-square-o',
				'sign-blank': 'square',
				signin: 'sign-in',
				signout: 'sign-out',
				smile: 'smile-o',
				'sort-by-alphabet-alt': 'sort-alpha-desc',
				'sort-by-alphabet': 'sort-alpha-asc',
				'sort-by-attributes-alt': 'sort-amount-desc',
				'sort-by-attributes': 'sort-amount-asc',
				'sort-by-order-alt': 'sort-numeric-desc',
				'sort-by-order': 'sort-numeric-asc',
				'sort-down': 'sort-asc',
				'sort-up': 'sort-desc',
				stackexchange: 'stack-overflow',
				'star-empty': 'star-o',
				'star-half-empty': 'star-half-o',
				sun: 'sun-o',
				'thumbs-down-alt': 'thumbs-o-down',
				'thumbs-up-alt': 'thumbs-o-up',
				time: 'clock-o',
				trash: 'trash-o',
				'tumblr-sign': 'tumblr-square',
				'twitter-sign': 'twitter-square',
				unlink: 'chain-broken',
				upload: 'arrow-circle-o-up',
				'upload-alt': 'upload',
				'warning-sign': 'exclamation-triangle',
				'xing-sign': 'xing-square',
				'youtube-sign': 'youtube-square',
				'zoom-in': 'search-plus',
				'zoom-out': 'search-minus'
			},
			faIcon = icon;

		if ( '' !== icon ) {

			// Custom icon is used so we need to remove our prefix.
			if ( 'fusion-prefix-' === icon.substr( 0, 14 ) ) {
				return icon.replace( 'fusion-prefix-', '' );
			}

			// FA icon, but we need to handle BC.
			if ( 'icon-' === icon.substr( 0, 5 ) || 'fa-' !== icon.substr( 0, 3 ) ) {
				icon = icon.replace( 'icon-', 'fa-' );

				if ( 'undefined' !== typeof oldIcons[ icon.replace( 'fa-', '' ) ] ) {
					faIcon = 'fa-' + oldIcons[ icon.replace( 'fa-', '' ) ];
				} else if ( 'fa-' !== icon.substr( 0, 3 ) ) {
					faIcon = 'fa-' + icon;
				}
			}

			if ( -1 === icon.trim().indexOf( ' ' ) ) {
				faIcon = 'fa ' + icon;
			}
		}

		return faIcon;
	},

	/**
	 * The FusionBuilder::validate_shortcode_attr_value() function from PHP, translated to JS.
	 *
	 * @since 2.0.0
	 * @param {string} value - The value.
	 * @param {string} acceptedUnit - The unit we're accepting.
	 * @param {boolean}   bcSupport - Should we add backwards-compatibility support?
	 * @return {string|false} - Returns the validated value.
	 */
	fusionValidateAttrValue: function( value, acceptedUnit, bcSupport ) {
		var validatedValue = '',
			numericValue,
			unit;

		bcSupport = 'undefined' !== typeof bcSupport ? bcSupport : true;
		value = String( value );
		if ( '' !== value ) {
			value        = value.trim();
			numericValue = parseFloat( value );
			unit         = value.replace( numericValue, '' );

			if ( 'undefined' === typeof acceptedUnit || '' === acceptedUnit ) {
				validatedValue = numericValue;

			} else if ( '' === unit ) {

				// Add unit if it's required.
				validatedValue = numericValue + acceptedUnit;
			} else if ( bcSupport || unit === acceptedUnit ) {

				// If unit was found use original value. BC support.
				validatedValue = value;
			} else {
				validatedValue = false;
			}
		}

		return validatedValue;
	},

	/**
	 * Clone of fusion_builder_get_video_provider.
	 *
	 * @since 2.0.0
	 * @param {string} videoString - The URL of the video.
	 * @return {Object} - Returns an object formatted {type: (string) The video-type, id: (string) The video ID }.
	 */
	fusionGetVideoProvider: function( videoString ) {

		var videoId,
			match;

		videoString = videoString.trim();

		// Check for YouTube.
		videoId = false;

		if ( match = videoString.match( /youtube\.com\/watch\?v=([^\&\?\/]+)/ ) ) { // eslint-disable-line no-cond-assign
			if ( 'undefined' !== typeof match[ 1 ] ) {
				videoId =  match[ 1 ];
			}
		} else if ( match = videoString.match( /youtube\.com\/embed\/([^\&\?\/]+)/ ) ) { // eslint-disable-line no-cond-assign
			if ( 'undefined' !== typeof match[ 1 ] ) {
				videoId =  match[ 1 ];
			}
		} else if ( match = videoString.match( /youtube\.com\/v\/([^\&\?\/]+)/ ) ) { // eslint-disable-line no-cond-assign
			if ( 'undefined' !== typeof match[ 1 ] ) {
				videoId =  match[ 1 ];
			}
		} else if ( match = videoString.match( /youtu\.be\/([^\&\?\/]+)/ ) ) { // eslint-disable-line no-cond-assign
			if ( 'undefined' !== typeof match[ 1 ] ) {
				videoId =  match[ 1 ];
			}
		}

		if ( false !== videoId ) {
			return {
				type: 'youtube',
				id: videoId
			};
		}

		// Check for Vimeo.
		if ( match = videoString.match( /vimeo\.com\/(\w*\/)*(\d+)/ ) ) { // eslint-disable-line no-cond-assign
			if ( 1 < match.length ) {
				return {
					type: 'vimeo',
					id: match[ match.length - 1 ]
				};
			}
		}
		if ( match = videoString.match( /^\d+$/ ) ) { // eslint-disable-line no-cond-assign
			if ( 'undefined' !== typeof match[ 0 ] ) {
				return {
					type: 'vimeo',
					id: match[ 0 ]
				};
			}
		}

		return {
			type: 'youtube',
			id: videoString
		};
	},

	/**
	 * JS clone of fusion_builder_check_value.
	 * If value is not in pixels or percent, appends 'px'.
	 *
	 * @since 2.0.0
	 * @param {string} value - The value.
	 * @return {string} - Returns the value.
	 */
	fusionCheckValue: function( value ) {
		if ( -1 === value.indexOf( '%' ) && -1 === value.indexOf( 'px' ) ) {
			value = value + 'px';
		}
		return value;
	},

	/**
	 * JS clone of get_value_with_unit.
	 *
	 * @param {string|number} value - The value.
	 * @param {string}           unit - The unit.
	 * @param {string}           unitHandling - Can be 'add'(default) or 'force_replace'.
	 * @return {string} - Returns the value with units.
	 */
	fusionGetValueWithUnit: function( value, unit, unitHandling ) {

		var rawValues,
			rawValue,
			values;

		unit         = 'undefined' !== typeof unit ? unit : 'px';
		unitHandling = 'undefined' !== typeof unitHandling ? unitHandling : 'add';

		rawValues = [];

		// Trim the value.
		value = 'undefined' === typeof value ? '' : value;
		value = value.trim();
		if ( -1 !== jQuery.inArray( value, [ 'auto', 'inherit', 'initial' ] ) ) {
			return value;
		}

		// Return empty if there are no numbers in the value.
		// Prevents some CSS errors.
		if ( ! ( /\d/ ).test( value ) ) {
			return;
		}

		// Explode if has multiple values.
		values = value.split( ' ' );
		if ( 1 < values.length ) {
			_.each( values, function( val ) {
				rawValue = parseFloat( val );

				if ( ! isNaN( rawValue ) ) {
					// Only == here deliberately.
					if ( val == rawValue ) {
						val = rawValue + unit;
					} else if ( 'force_replace' === unitHandling ) {
						val = rawValue + unit;
					}
				}
				rawValues.push( val );
			} );

			return rawValues.join( ' ' );

		}
		rawValue = parseFloat( value );

		// Only == here deliberately.
		if ( value == rawValue ) {
			return rawValue + unit;
		}
		if ( 'force_replace' === unitHandling ) {
			return rawValue + unit;
		}

		return value;
	},

	/**
	 * Returns a single side dimension.
	 *
	 * Copy of the PHP fusion_builder_single_dimension function.
	 *
	 * @param {Object} dimensions - The dimensions object{top:'',buttom:'',left:'',right:''}.
	 * @param {string} direction - Which one do we want? left/right/top/bottom.
	 * @return {string} - Returns a single dimension from the array.
	 */
	fusionSingleDimension: function( dimensions, direction ) {
		dimensions = dimensions.split( ' ' );

		if ( 4 === dimensions.length ) {
			if ( 'top' === direction ) {
				return dimensions[ 0 ];
			} else if ( 'right' === direction ) {
				return dimensions[ 1 ];
			} else if ( 'bottom' === direction ) {
				return dimensions[ 2 ];
			} else if ( 'left' === direction ) {
				return dimensions[ 3 ];
			}
		} else if ( 3 === dimensions.length ) {
			if ( 'top' === direction ) {
				return dimensions[ 0 ];
			} else if ( 'right' === direction || 'left' === direction ) {
				return dimensions[ 1 ];
			} else if ( 'bottom' === direction ) {
				return dimensions[ 2 ];
			}
		} else if ( 2 === dimensions.length ) {
			if ( 'top' === direction || 'bottom' === direction ) {
				return dimensions[ 0 ];
			} else if ( 'right' === direction || 'left' === direction ) {
				return dimensions[ 1 ];
			}
		}
		return dimensions[ 0 ];
	},

	/**
	 * Get the attributes for masonry.
	 *
	 * @since 2.0.0
	 * @param {Object}       data - The data.
	 * @param {string|number} data.blog_grid_column_spacing - Column spacing in pixels.
	 * @param {string}       data.element_orientation_class - The orientation class (fusion-element-portrain, fusion-element-landscape etc).
	 * @param {string}       data.timeline_color - The timeline color.
	 * @param {string}       data.masonry_attribute_style - Masonry styles.
	 * @return {Object} - Returns the masonry attributes.
	 */
	fusionGetMasonryAttribute: function( data ) {
		var masonryColumnOffset,
			masonryColumnSpacing,
			masonryAttributes = {};

		masonryColumnOffset = ' - ' + ( parseFloat( data.blog_grid_column_spacing ) / 2 ) + 'px';
		if ( 'string' === typeof data.element_orientation_class && -1 !== data.element_orientation_class.indexOf( 'fusion-element-portrait' ) ) {
			masonryColumnOffset = '';
		}

		masonryColumnSpacing = ( parseFloat( data.blog_grid_column_spacing ) ) + 'px';

		// Calculate the correct size of the image wrapper container, based on orientation and column spacing.
		if ( 'transparent' !== data.timeline_color && 0 !== jQuery.Color( data.timeline_color ).alpha() ) {

			masonryColumnOffset = ' - ' + ( parseFloat( data.blog_grid_column_spacing ) / 2 ) + 'px';
			if ( 'string' === typeof data.element_orientation_class && -1 !== data.element_orientation_class.indexOf( 'fusion-element-portrait' ) ) {
				masonryColumnOffset = ' + 4px';
			}

			masonryColumnSpacing = ( parseFloat( data.blog_grid_column_spacing ) - 2 ) + 'px';
			if ( 'string' === typeof data.element_orientation_class && -1 !== data.element_orientation_class.indexOf( 'fusion-element-landscape' ) ) {
				masonryColumnSpacing = ( parseFloat( data.blog_grid_column_spacing ) - 6 ) + 'px';
			}
		}

		// Calculate the correct size of the image wrapper container, based on orientation and column spacing.
		masonryAttributes[ 'class' ] = 'fusion-masonry-element-container';
		masonryAttributes.style = data.masonry_attribute_style + 'padding-top:calc((100% + ' + masonryColumnSpacing + ') * ' + data.element_base_padding + masonryColumnOffset + ');';

		return masonryAttributes;
	},

	/**
	 * Combination of first featured image and rollover.
	 *
	 * @since 2.0.0
	 * @param {Object}         data - The data.
	 * @param {string}         data.layout - The layout.
	 * @param {string}         data.masonry_data - The masonry data.
	 * @param {string|boolean} data.enable_rollover - Should we enable the rollover?
	 * @param {string}         data.display_rollover - Should we display the rollover? (yes|no|force_yes).
	 * @param {Object}         data.featured_images - The featured images.
	 * @param {string}         data.image_rollover_icons - no|zoom|link|linkzoom.
	 * @param {string}         data.post_type - The post-type.
	 * @param {string|number}  data.post_id - The post-ID.
	 * @param {string}         data.icon_permalink - URL.
	 * @param {string}         data.link_target - Leave empty or use target="_blank".
	 * @param {string}         data.icon_permalink_title - The icon permalink title.
	 * @param {string}         data.full_image - URL.
	 * @param {string}         data.data_rel - Used in data-rel="".
	 * @param {string}         data.data_title - Used in data-title="".
	 * @param {string}         data.data_caption - Used in data-caption="".
	 * @param {string}         data.lightbox_content - The contents of the lightbox.
	 * @param {string|boolean} data.display_post_title - Should we display the post-title?
	 * @param {string}         data.permalink - URL.
	 * @param {string}         data.title - The title.
	 * @param {string|boolean} data.display_post_categories - Should we display the post categories?
	 * @param {string}         data.terms - The post category terms (HTML).
	 * @param {boolean}        data.display_woo_rating - SHould we display Woo rating?
	 * @param {string}         data.rating - The rating (HTML).
	 * @param {boolean}        data.display_woo_price - Should we display Woo Prices?
	 * @param {string}         data.price - The price (HTML).
	 * @param {boolean}        data.display_woo_buttons - Should we display the Woo buttons?
	 * @param {string}         data.buttons - The buttons (HTML).
	 * @return {string} - Returns the template.
	 */
	fusionFeaturedImage: function( data ) {
		var featuredImageTemplate = FusionPageBuilder.template( jQuery( '#tmpl-featured-image' ).html() ),
			attributes = {};

		if ( 'object' !== typeof data || 'undefined' === typeof data.featured_images ) {
			return '';
		}
		attributes.data = data;
		return featuredImageTemplate( attributes );
	},

	/**
	 * Get element orientation class based on image dimensions and ratio and widthDouble params.
	 *
	 * @since 2.0.0
	 * @param {Object} attachment - Image object.
	 * @param {number} attachment.imageWidth - Image width.
	 * @param {number} attachment.imageHeight - Image height.
	 * @param {number} ratio - Height / Width ratio. Portrait images have larger height / width ratio.
	 * @param {number} widthDouble - Wider images are considered as 2x2.
	 * @return {string} - Returns the element class.
	 */
	fusionGetElementOrientationClass: function( attachment, ratio, widthDouble ) {
		var elementClass = 'fusion-element-grid',
			fallbackRatio = 0.8,
			lowerLimit,
			upperLimit;

		if ( 'undefined' !== typeof attachment.imageWidth && 'undefined' !== typeof attachment.imageHeight ) {

			// Fallback to legacy calcs of Avada 5.4.2 or earlier.
			if ( '1.0' === ratio ) {
				lowerLimit = ( fallbackRatio / 2 ) + ( fallbackRatio / 4 );
				upperLimit = ( fallbackRatio * 2 ) - ( fallbackRatio / 2 );

				if ( lowerLimit > attachment.imageHeight / attachment.imageWidth ) {

					// Landscape image.
					elementClass = 'fusion-element-landscape';
				} else if ( upperLimit < attachment.imageHeight / attachment.imageWidth ) {

					// Portrait image.
					elementClass = 'fusion-element-portrait';
				} else if ( attachment.imageWidth > widthDouble ) {

					// 2x2 image.
					elementClass = 'fusion-element-landscape fusion-element-portrait';
				}
			} else if ( ratio < attachment.imageWidth / attachment.imageHeight ) {

				// Landscape image.
				elementClass = 'fusion-element-landscape';

			} else if ( ratio < attachment.imageHeight / attachment.imageWidth ) {

				// Portrait image.
				elementClass = 'fusion-element-portrait';
			} else if ( attachment.imageWidth > widthDouble ) {

				// 2x2 image.
				elementClass = 'fusion-element-landscape fusion-element-portrait';
			}
		}

		return elementClass;
	},

	/**
	 * Get base element padding based on orientation CSS class.
	 *
	 * @since 2.0.0
	 * @param {string} elementOrientationClass - CSS class
	 * @return {number} - Returns the padding.
	 */
	fusionGetElementBasePadding: function( elementOrientationClass ) {
		var fusionElementGridPadding = 0.8,
			masonryElementPadding = {
				'fusion-element-grid': fusionElementGridPadding,
				'fusion-element-landscape': fusionElementGridPadding / 2,
				'fusion-element-portrait': fusionElementGridPadding * 2
			};

		if ( 'undefined' !== typeof masonryElementPadding[ elementOrientationClass ] ) {
			fusionElementGridPadding = masonryElementPadding[ elementOrientationClass ];
		}

		return fusionElementGridPadding;
	},

	/**
	 * JS copy of fusion_builder_render_post_metadata.
	 *
	 * @since 2.0.0
	 * @param {string}         layout - The layout.
	 * @param {Object}         settings - The settings.
	 * @param {boolean|string} settings.post_meta - Should we display the post-meta?
	 * @param {boolean|string} settings.post_meta_author - Should we display the author?
	 * @param {boolean|string} settings.post_meta_date - Should we display the date?
	 * @param {boolean|string} settings.post_meta_cats - Should we display the categories?
	 * @param {boolean|string} settings.post_meta_tags - Should we display the tags?
	 * @param {boolean|string} settings.post_meta_comments - Should we display comments?
	 * @param {boolean|string} settings.disable_date_rich_snippet_pages - Should we disable the date rich snippet?
	 * @param {Object}         data - The data.
	 * @param {string}         data.post_meta - yes|no.
	 * @param {string}         data.author_post_link - The link to the post-author (HTML, not just URL).
	 * @param {string}         data.formatted_date - Formatted date (HTML).
	 * @param {string}         data.categories - The categories (HTML).
	 * @param {string}         data.tags - The Tags (HTML)
	 * @param {string}         data.comments - The comments (HTML)
	 * @param {string}         data.disable_date_rich_snippet_pages - Disable date rich snippets?
	 * @return {string} - Returns HTML.
	 */
	fusionRenderPostMetadata: function( layout, settings, data ) {

		var metadata = '',
			author   = '',
			date     = '',
			output   = '',
			dateMarkup;

		// Check if meta data is enabled.
		if ( 'undefined' === typeof data ) {
			return;
		}

		if ( ( settings.post_meta && 'no' !== data.post_meta ) || ( ! settings.post_meta && 'yes' === data.post_meta ) ) {

			// For alternate, grid and timeline layouts return empty single-line-meta if all meta data for that position is disabled.
			if ( -1 !== jQuery.inArray( layout, [ 'alternate', 'grid_timeline' ] ) && ! settings.post_meta_author && ! settings.post_meta_date && ! settings.post_meta_cats && ! settings.post_meta_tags && ! settings.post_meta_comments ) {
				return '';
			}

			// Render author meta data.
			if ( settings.post_meta_author ) {

				// Check if rich snippets are enabled.
				if ( ! settings.disable_date_rich_snippet_pages ) {
					metadata += 'By <span>' + data.author_post_link + '</span>';
				} else {
					metadata += 'By <span class="vcard"><span class="fn">' + data.author_post_link + '</span></span>';
				}
				metadata += '<span class="fusion-inline-sep">|</span>';
			}

			// Render the updated meta data or at least the rich snippet if enabled.
			if ( settings.post_meta_date ) {
				metadata  += _.fusionRenderRichSnippets( data, false, false, true );
				dateMarkup = '<span>' + data.formatted_date + '</span><span class="fusion-inline-sep">|</span>';
				metadata  += dateMarkup;
			}

			// Render rest of meta data.
			// Render categories.
			if ( settings.post_meta_cats ) {

				if ( data.categories ) {
					metadata += ( settings.post_meta_tags ) ? 'Categories: ' + data.categories : data.categories;
					metadata += '<span class="fusion-inline-sep">|</span>';
				}
			}

			// Render tags.
			if ( settings.post_meta_tags ) {

				if ( data.tags ) {
					metadata += '<span class="meta-tags">' + window.fusionBuilderText.tags.replace( '%s', data.tags ) + '</span><span class="fusion-inline-sep">|</span>';
				}
			}

			// Render comments.
			if ( settings.post_meta_comments && 'grid_timeline' !== layout ) {
				metadata += '<span class="fusion-comments">' + data.comments + '</span>';
			}

			// Render the HTML wrappers for the different layouts.
			if ( metadata ) {
				metadata = author + date + metadata;

				if ( 'single' === layout ) {
					output += '<div class="fusion-meta-info"><div class="fusion-meta-info-wrapper">' + metadata + '</div></div>';
				} else if ( -1 !== jQuery.inArray( layout, [ 'alternate', 'grid_timeline' ] ) ) {
					output += '<p class="fusion-single-line-meta">' + metadata + '</p>';
				} else if ( 'recent_posts' === layout ) {
					output += metadata;
				} else {
					output += '<div class="fusion-alignleft">' + metadata + '</div>';
				}
			} else {
				output += author + date;
			}
		} else if ( data.disable_date_rich_snippet_pages ) {

			// Render author and updated rich snippets for grid and timeline layouts.
			output += _.fusionRenderRichSnippets( data, false );
		}

		return output;
	},

	/**
	 * JS Copy of fusion_builder_render_rich_snippets_for_pages.
	 *
	 * @since 2.0.0
	 * @param {Object}  data - The data.
	 * @param {boolean} data.disable_date_rich_snippet_pages Should we display the rich snippets?
	 * @param {string}  data.title - The title.
	 * @param {string}  data.the_author_posts_link The link to the author (HTML, not just the URL).
	 * @param {string}  data.get_the_modified_time - The modified timestamp.
	 * @return {string} - Returns the output.
	 */
	fusionRenderRichSnippets: function( data ) {
		var output = '';

		if ( 'undefined' === typeof data ) {
			return;
		}
		if ( data.disable_date_rich_snippet_pages ) {
			output = '';
		}
		return output;
	},

	/**
	 * JS copy of new-slideshow-blog-shortcode.
	 *
	 * @since 2.0.0
	 * @param {Object} data - The data.
	 * @param {string} data.layout - The layout.
	 * @param {string} data.featured_image_width - The featured image width.
	 * @param {string} data.id - The ID.
	 * @param {string} data.featured_image_height - The featured image height.
	 * @param {string} data.thumbnail - The thumbnail.
	 * @param {string} data.video - The video
	 * @param {Object} data.image_data - The image data.
	 * @param {Object} data.multiple_featured - Multiple featured images data.
	 * @param {string} data.permalink - The permalink (URL).
	 * @param {string} data.title - The title.
	 * @param {string} data.image_size - The image size.
	 * @return {string}
	 */
	fusionGetBlogSlideshow: function( data ) {
		var slideshowTemplate = FusionPageBuilder.template( jQuery( '#tmpl-new-slideshow-blog-shortcode' ).html() ),
			attributes        = {};

		if ( 'object' !== typeof data ) {
			return '';
		}
		attributes.data = data;
		return slideshowTemplate( attributes );
	},

	/**
	 * Ability to change length of content and display correct contents.
	 *
	 * @since 2.0.0
	 * @param {Object}  data - The data.
	 * @param {string}  data.read_more - The read more text.
	 * @param {string}  data.full_content - The full content.
	 * @param {string}  data.excerpt - The excerpt.
	 * @param {string}  data.excerpt_stripped - Stripped excerpt.
	 * @param {string}  data.excerpt_base - Defaults to 'characters'.
	 * @param {string}  excerpt - Do we want excerpt (yes/no)?
	 * @param {number} excerptLength - How long?
	 * @param {boolean} stripHtml - Should we strip HTML?
	 * @return {string}
	 */
	fusionGetFixedContent: function( data, excerpt, excerptLength, stripHtml ) {
		var content,
			readMoreContent = '';

		excerpt        = 'undefined' !== typeof excerpt ? excerpt : 'no';
		excerptLength  = 'undefined' !== typeof excerptLength ? excerptLength : 55;
		stripHtml      = 'undefined' !== typeof stripHtml ? stripHtml : false;
		stripHtml      = ( 'yes' === stripHtml || stripHtml || '1' == stripHtml );
		data.read_more = data.hasOwnProperty( 'read_more' ) ? data.read_more : '';

		// Return full contents.
		if ( 'no' === excerpt ) {
			return data.full_content;
		}

		// Set correct stripped data.
		content = ( stripHtml ) ? data.excerpt_stripped : data.excerpt;

		// It has a read more, remove it.
		content = content
			.replace( /\[/g, '&#91;' )
			.replace( /\]/g, '&#93;' )
			.replace( /\.\.\./g, '&#8230;' );

		readMoreContent = ' ' + data.read_more
			.replace( /\[/g, '&#91;' )
			.replace( /\]/g, '&#93;' )
			.replace( /\.\.\./g, '&#8230;' )
			.trim();

		if ( -1 !== content.indexOf( readMoreContent ) ) {
			content  = content.replace( readMoreContent, '' );
		}

		if ( 'characters' === data.excerpt_base.toLowerCase() ) {
			if ( excerptLength < content.length ) {
				content = content.substring( 0, excerptLength );
			}
		} else {
			content = content.split( ' ' ).splice( 0, excerptLength ).join( ' ' );
		}

		// Add read more.
		content += readMoreContent;

		return _.fusionFixHtml( content );
	},

	/**
	 * Helper method used in getFixedContent.
	 *
	 * @since 2.0.0
	 * @param {string} html - The html string.
	 * @return {string}
	 */
	fusionFixHtml: function( html ) {
		var div = document.createElement( 'div' );
		div.innerHTML = html;
		return ( div.innerHTML );
	},

	/**
	 * Capitalize the 1st letter.
	 *
	 * @since 2.0.0
	 * @param {string} string - The string we want to modify.
	 * @return {string}
	 */
	fusionUcFirst: function( string ) {
		return string.charAt( 0 ).toUpperCase() + string.slice( 1 );
	},

	/**
	 * JS port of PHP's rawurlencode function.
	 *
	 * @since 2.0.0
	 * @param {string} string - The URL.
	 * @return {string}
	 */
	fusionRawUrlEncode: function( string ) {
		string = ( string + '' );

		return encodeURIComponent( string )
			.replace( /!/g, '%21' )
			.replace( /'/g, '%27' )
			.replace( /\(/g, '%28' )
			.replace( /\)/g, '%29' )
			.replace( /\*/g, '%2A' );
	},

	/**
	 * Auto calculate accent color.
	 * copy of fusion_auto_calculate_accent_color from PHP.
	 *
	 * @since 2.0.0
	 * @param {string} color - The color.
	 * @return {string}
	 */
	fusionAutoCalculateAccentColor: function( color ) {
		var colorObj  = jQuery.Color( color ),
			lightness = parseInt( colorObj.lightness() * 100, 10 );

		if ( 0 < lightness ) { // Not black.
			if ( 50 <= lightness ) {
				return colorObj.lightness( lightness / 200 ).toRgbaString();
			}
			return colorObj.lightness( lightness / 50 ).toRgbaString();
		}
		return colorObj.lightness( 70 ).toRgbaString();
	},

	/**
	 * JS copy of fusion_builder_build_social_links.
	 *
	 * @since 2.0.0
	 * @param {Array|Object} socialNetworks - The social networks array.
	 * @param {string}       functionName - Callable function-name.
	 * @param {Object}       params - The parameters.
	 * @param {number}      i - Not used?
	 * @return {string}
	 */
	fusionBuildSocialLinks: function( socialNetworks, functionName, params, i ) {

		var useBrandColors    = false,
			icons             = '',
			shortcodeDefaults = {},
			boxColors,
			iconColors,
			numOfIconColors,
			numOfBoxColors,
			socialNetworksCount,
			k = 0;

		socialNetworks = ! _.isUndefined( socialNetworks ) ? socialNetworks : '';
		i              = ! _.isUndefined( i ) ? i : 0;

		if ( ! _.isUndefined( params.social_icon_boxed ) ) {
			params.icons_boxed = params.social_icon_boxed;
		}

		if ( '' != socialNetworks && jQuery.isArray( socialNetworks ) ) {

			// Add compatibility for different key names in shortcodes.
			_.each( params, function( value, key ) {
				key = ( 'social_icon_boxed'        === key ) ? 'icons_boxed' : key;
				key = ( 'social_icon_colors'       === key ) ? 'icon_colors' : key;
				key = ( 'social_icon_boxed_colors' === key ) ? 'box_colors'  : key;
				key = ( 'social_icon_color_type'   === key ) ? 'color_type'  : key;

				shortcodeDefaults[ key ] = value;
			} );

			// Check for icon color type.
			if ( 'brand' === shortcodeDefaults.color_type ) {
				useBrandColors = true;

				boxColors = _.fusionSocialIcons( true, true );

				// Backwards compatibility for old social network names.
				boxColors.mail = {
					label: 'Email Address',
					color: '#000000'
				};
				iconColors = {};

			} else {

				// Custom social icon colors.
				iconColors = ( 'undefined' !== typeof shortcodeDefaults.icon_colors ) ? shortcodeDefaults.icon_colors.split( '|' ) : '';
				boxColors  = ( 'undefined' !== typeof shortcodeDefaults.box_colors ) ? shortcodeDefaults.box_colors.split( '|' ) : '';

				numOfIconColors = iconColors.length;
				numOfBoxColors  = boxColors.length;

				socialNetworksCount = socialNetworks.length;

				for ( k = 0; k < socialNetworksCount; k++ ) {
					if ( 1 === numOfIconColors ) {
						iconColors[ k ] = iconColors[ 0 ];
					}
					if ( 1 === numOfBoxColors ) {
						boxColors[ k ] = boxColors[ 0 ];
					}
				}
			}

			// Process social networks.
			_.each( socialNetworks, function( value ) {

				_.each( value, function( link, network ) {
					var iconOptions;

					if ( 'custom' === network && link ) {

						_.each( link, function( url, customKey ) {
							var customIconBoxColor = '',
								socialMediaIcons,
								width,
								height;

							if ( 'yes' === params.icons_boxed ) {

								customIconBoxColor = i < boxColors.length ? boxColors[ i ] : '';
								if ( true === useBrandColors ) {
									customIconBoxColor = ( boxColors[ network ].color ) ? boxColors[ network ].color : '';
								}
							}

							socialMediaIcons = params.social_media_icons;

							if ( ! _.isObject( socialMediaIcons ) ) {
								socialMediaIcons = {};
							}
							if ( _.isUndefined( socialMediaIcons.custom_title ) ) {
								socialMediaIcons.custom_title = {};
							}
							if ( _.isUndefined( socialMediaIcons.custom_source ) ) {
								socialMediaIcons.custom_source = {};
							}
							if ( _.isUndefined( socialMediaIcons.custom_title[ customKey ] ) ) {
								socialMediaIcons.custom_title[ customKey ] = '';
							}
							if ( _.isUndefined( socialMediaIcons.custom_source[ customKey ] ) ) {
								socialMediaIcons.custom_source[ customKey ] = '';
							}

							iconOptions = {
								social_network: socialMediaIcons.custom_title[ customKey ],
								social_link: url,
								icon_color: i < iconColors.length ? iconColors[ i ] : '',
								box_color: customIconBoxColor
							};
							if ( _.isFunction( functionName ) ) {
								iconOptions = functionName( iconOptions, params );
							}
							icons += '<a ' + _.fusionGetAttributes( iconOptions ) + '>';
							icons += '<img';

							if ( ! _.isUndefined( socialMediaIcons.custom_source[ customKey ].url ) ) {
								icons += ' src="' + socialMediaIcons.custom_source[ customKey ].url + '"';
							}
							if ( ! _.isUndefined( socialMediaIcons.custom_title[ customKey ] ) && '' != socialMediaIcons.custom_title[ customKey ] ) {
								icons += ' alt="' + socialMediaIcons.custom_title[ customKey ] + '"';
							}
							if ( ! _.isUndefined( socialMediaIcons.custom_source[ customKey ].width ) && socialMediaIcons.custom_source[ customKey ].width ) {
								width = parseInt( socialMediaIcons.custom_source[ customKey ].width, 10 );
								icons += ' width="' + width + '"';
							}
							if ( 'undefined' !== socialMediaIcons.custom_source[ customKey ].height && socialMediaIcons.custom_source[ customKey ].height ) {
								height = parseInt( socialMediaIcons.custom_source[ customKey ].height, 10 );
								icons += ' height="' + height + '"';
							}
							icons += ' /></a>';
						} );
					} else {
						if ( true == useBrandColors ) {
							iconOptions = {
								social_network: network,
								social_link: link,
								icon_color: ( 'yes' === params.icons_boxed ) ? '#ffffff' : boxColors[ network ].color,
								box_color: ( 'yes' === params.icons_boxed ) ? boxColors[ network ].color : ''
							};

						} else {
							iconOptions = {
								social_network: network,
								social_link: link,
								icon_color: i < iconColors.length ? iconColors[ i ] : '',
								box_color: i < boxColors.length ? boxColors[ i ] : ''
							};
						}
						if ( _.isFunction( functionName ) ) {
							iconOptions = functionName( iconOptions, params );
						}
						icons += '<a ' + _.fusionGetAttributes( iconOptions ) + '></a>';
					}
					i++;
				} );
			} );
		}

		return icons;
	},

	/**
	 * JS copy of Fusion_Data::fusion_social_icons
	 *
	 * @since 2.0.0
	 * @param {boolean} custom - Do we want the custom network?
	 * @param {boolean} colors - Do we want the colors?
	 * @return {Object}
	 */
	fusionSocialIcons: function( custom, colors ) {

		var networks,
			simpleNetworks;

		custom = ! _.isUndefined( custom ) ? custom : true;
		colors = ! _.isUndefined( colors ) ? colors : false;

		networks = {
			blogger: {
				label: 'Blogger',
				color: '#f57d00'
			},
			deviantart: {
				label: 'Deviantart',
				color: '#4dc47d'
			},
			discord: {
				label: 'Discord',
				color: '#26262B'
			},
			digg: {
				label: 'Digg',
				color: '#000000'
			},
			dribbble: {
				label: 'Dribbble',
				color: '#ea4c89'
			},
			dropbox: {
				label: 'Dropbox',
				color: '#007ee5'
			},
			facebook: {
				label: 'Facebook',
				color: '#3b5998'
			},
			flickr: {
				label: 'Flickr',
				color: '#0063dc'
			},
			forrst: {
				label: 'Forrst',
				color: '#5b9a68'
			},
			instagram: {
				label: 'Instagram',
				color: '#3f729b'
			},
			linkedin: {
				label: 'LinkedIn',
				color: '#0077b5'
			},
			mixer: {
				label: 'Mixer',
				color: '#1FBAED'
			},
			myspace: {
				label: 'Myspace',
				color: '#000000'
			},
			paypal: {
				label: 'Paypal',
				color: '#003087'
			},
			pinterest: {
				label: 'Pinterest',
				color: '#bd081c'
			},
			reddit: {
				label: 'Reddit',
				color: '#ff4500'
			},
			rss: {
				label: 'RSS',
				color: '#f26522'
			},
			skype: {
				label: 'Skype',
				color: '#00aff0'
			},
			soundcloud: {
				label: 'Soundcloud',
				color: '#ff8800'
			},
			spotify: {
				label: 'Spotify',
				color: '#2ebd59'
			},
			tiktok: {
				label: 'Tiktok',
				color: '#010101'
			},
			tumblr: {
				label: 'Tumblr',
				color: '#35465c'
			},
			twitch: {
				label: 'Twitch',
				color: '#6441a5'
			},
			twitter: {
				label: 'Twitter',
				color: '#55acee'
			},
			vimeo: {
				label: 'Vimeo',
				color: '#1ab7ea'
			},
			vk: {
				label: 'VK',
				color: '#45668e'
			},
			wechat: {
				label: 'WeChat',
				color: '#7bb22e'
			},
			whatsapp: {
				label: 'WhatsApp',
				color: '#77e878'
			},
			xing: {
				label: 'Xing',
				color: '#026466'
			},
			yahoo: {
				label: 'Yahoo',
				color: '#410093'
			},
			yelp: {
				label: 'Yelp',
				color: '#af0606'
			},
			youtube: {
				label: 'Youtube',
				color: '#cd201f'
			},
			email: {
				label: 'Email Address',
				color: '#000000'
			},
			phone: {
				label: 'Phone',
				color: '#000000'
			}
		};

		// Add a "custom" entry.
		if ( custom ) {
			networks.custom = {
				label: 'Custom',
				color: ''
			};
		}

		if ( ! colors ) {
			simpleNetworks = {};
			_.each( networks, function( networkArgs ) {
				simpleNetworks.network_id = networkArgs.label;
			} );
			networks = simpleNetworks;
		}

		return networks;

	},

	/**
	 * JS copy of fusion_builder_sort_social_networks.
	 *
	 * @param {Object} socialNetworksOriginal - The original object.
	 * @param {Object} params - Any parameters we want to pass.
	 * @return {Object}
	 */
	fusionSortSocialNetworks: function( socialNetworksOriginal, params ) {

		var socialNetworks = [],
			iconOrder      = '',
			newNetwork,
			newCustom;

		// Get social networks order from theme options.
		if ( params.social_media_icons_icon && jQuery.isArray( params.social_media_icons_icon ) ) {
			iconOrder = params.social_media_icons_icon.join( '|' );
		}

		if ( ! jQuery.isArray( iconOrder ) ) {
			iconOrder = iconOrder.split( '|' );
		}

		if ( jQuery.isArray( iconOrder ) ) {

			// First put the icons that exist in the theme options,
			// and order them using tha same order as in theme options.
			_.each( iconOrder, function( value, key ) {
				var newKey;

				// Backwards compatibility for old social network names.
				newKey = ( 'email' === value ) ? 'mail' : value;

				// Check if social network from TO exists in element.
				if ( ! _.isUndefined( socialNetworksOriginal[ value ] ) ) {
					newNetwork = {};
					if ( 'custom' === value ) {
						if ( socialNetworksOriginal[ value ] ) {
							newNetwork[ key ]  = socialNetworksOriginal[ value ][ key ];
							newCustom          = {};
							newCustom[ value ] = newNetwork;
							socialNetworks.push( newCustom );
						}
					} else {
						newNetwork[ newKey ] = socialNetworksOriginal[ value ];
						socialNetworks.push( newNetwork );
						delete socialNetworksOriginal[ value ];
					}
				}
			} );

			// Put any remaining icons after the ones from the theme options.
			_.each( socialNetworksOriginal, function( networkurl, name ) {
				if ( 'custom' !== name ) {
					newNetwork         = {};
					newNetwork[ name ] = networkurl;
					socialNetworks.push( newNetwork );
				}
			} );
		} else {
			console.warn( 'OUT' );
		}

		return socialNetworks;
	},

	/**
	 * JS copy of fusion_builder_get_social_networks.
	 * Gets the social networks.
	 *
	 * @since 2.0.0
	 * @param {Object} params - The parameters.
	 * @return {Object}
	 */
	fusionGetSocialNetworks: function( params ) {

		var socialLinksArray = {},
			socialLinks      = {
				facebook: 'facebook',
				tiktok: 'tiktok',
				twitch: 'twitch',
				twitter: 'twitter',
				instagram: 'instagram',
				linkedin: 'linkedin',
				discord: 'discord',
				dribbble: 'dribbble',
				rss: 'rss',
				youtube: 'youtube',
				pinterest: 'pinterest',
				flickr: 'flickr',
				vimeo: 'vimeo',
				tumblr: 'tumblr',
				digg: 'digg',
				blogger: 'blogger',
				skype: 'skype',
				mixer: 'mixer',
				myspace: 'myspace',
				deviantart: 'deviantart',
				yahoo: 'yahoo',
				reddit: 'reddit',
				forrst: 'forrst',
				paypal: 'paypal',
				dropbox: 'dropbox',
				soundcloud: 'soundcloud',
				vk: 'vk',
				wechat: 'wechat',
				whatsapp: 'whatsapp',
				xing: 'xing',
				yelp: 'yelp',
				spotify: 'spotify',
				email: 'mail',
				phone: 'phone'
			};

		_.each( socialLinks, function( val, key ) {
			if ( 'undefined' !== typeof params[ key ] && '' !== params[ key ] ) {
				socialLinksArray[ val ] = params[ key ];
			}
		} );

		if ( params.show_custom && 'yes' === params.show_custom ) {
			socialLinksArray.custom = {};

			if ( jQuery.isArray( params.social_media_icons_icon ) ) {
				_.each( params.social_media_icons_icon, function( icon, key ) {

					if ( 'custom' === icon && jQuery.isArray( params.social_media_icons_url ) && ! _.isUndefined( params.social_media_icons_url[ key ] ) && '' !== params.social_media_icons_url[ key ] ) {

						// Check if there is a default set for this, if so use that rather than TO link.
						if ( params[ 'custom_' + key ] && '' !== params[ 'custom_' + key ] ) {
							socialLinksArray.custom[ key ] = params[ 'custom_' + key ];
						} else {
							socialLinksArray.custom[ key ] = params.social_media_icons_url[ key ];
						}
					}
				} );
			}
		}

		return socialLinksArray;
	},

	// WIP: If padding (combined all 4) is not set in params, then use individual variables.
	fusionGetPadding: function( values ) {
		values.padding_top    = 'undefined' !== typeof values.padding_top ? _.fusionGetValueWithUnit( values.padding_top ) : '0px';
		values.padding_right  = 'undefined' !== typeof values.padding_right ? _.fusionGetValueWithUnit( values.padding_right ) : '0px';
		values.padding_bottom = 'undefined' !== typeof values.padding_bottom ? _.fusionGetValueWithUnit( values.padding_bottom ) : '0px';
		values.padding_left   = 'undefined' !== typeof values.padding_left ? _.fusionGetValueWithUnit( values.padding_left ) : '0px';
		values.padding = values.padding_top + ' ' + values.padding_right + ' ' + values.padding_bottom + ' ' + values.padding_left;

		return values;
	},

	fusionGetMargin: function( values ) {
		if ( '' !== values.margin_bottom ) {
			values.margin_bottom = _.fusionGetValueWithUnit( values.margin_bottom );
		}
		if ( '' !== values.margin_top ) {
			values.margin_top = _.fusionGetValueWithUnit( values.margin_top );
		}

		return values;
	},

	fusionAnimations: function( values, attributes ) {
		var animations = false;

		if ( values && 'undefined' !== typeof values.animation_type && '' !== values.animation_type ) {
			animations = _.fusionGetAnimations( {
				type: values.animation_type,
				direction: values.animation_direction,
				speed: values.animation_speed,
				offset: values.animation_offset
			} );

			attributes = jQuery.extend( attributes, animations );

			// Class to mark as editor.
			if ( 'undefined' !== typeof attributes[ 'class' ] ) {
				attributes[ 'class' ] += ' ' + attributes.animation_class;
			} else {
				attributes[ 'class' ] = attributes.animation_class;
			}

			delete attributes.animation_class;
		}

		return attributes;
	},

	fusionPagination: function( maxPages, currentPage, range, pagination, globalPagination, globalStartEndRange ) {
		var paginationCode = '',
			i,
			globalStartRange,
			globalEndRange,
			start,
			end;

		globalStartEndRange = ( 'undefined' !== typeof globalStartEndRange ) ? parseInt( globalStartEndRange, 10 ) : 2;
		currentPage         = ( 'undefined' !== typeof currentPage ) ? parseInt( currentPage, 10 ) : 1;
		range               = parseInt( range, 10 );
		maxPages            = parseInt( maxPages, 10 );

		globalStartRange = globalStartEndRange;
		globalEndRange   = globalStartEndRange;

		if ( 1 !== maxPages ) {

			if ( ( 'pagination' !== pagination && 'pagination' !== globalPagination.toLowerCase() ) ) {
				paginationCode += '<div class="fusion-infinite-scroll-trigger"></div>';
				paginationCode += '<div class="pagination infinite-scroll clearfix">';
			} else {
				paginationCode += '<div class="pagination clearfix">';
			}

			start = currentPage - range;
			end   = currentPage + range;
			if ( 0 >= start ) {
				start = ( 0 < currentPage - 1 ) ? currentPage - 1 : 1;
			}

			if ( maxPages < end ) {
				end = maxPages;
			}

			if ( 'pagination' === pagination ) {
				if ( 1 < currentPage ) {
					paginationCode += '<a class="pagination-prev" href="#"><span class="page-prev"></span><span class="page-text">Previous</span></a>';

					if ( 0 < globalStartRange ) {
						if ( globalStartRange >= start ) {
							globalStartRange = start - 1;
						}

						for ( i = 1; i <= globalStartRange; i++ ) {
							paginationCode += '<a href="#" class="inactive">' + i + '</a>';
						}

						if ( 0 < globalStartRange && globalStartRange < start - 1 ) {
							paginationCode += '<span class="pagination-dots paginations-dots-start">&middot;&middot;&middot;</span>';
						}
					}
				}

				for ( i = start; i <= end; i++ ) {
					if ( currentPage == i ) {
						paginationCode += '<span class="current">' + i + '</span>';
					} else {
						paginationCode += '<a href="#" class="inactive">' + i + '</a>';
					}
				}

				if ( currentPage < maxPages ) {

					if ( 0 < globalEndRange ) {

						if ( maxPages - globalEndRange <= end ) {
							globalEndRange = maxPages - end;
						}

						globalEndRange--;

						if ( end + 1 < maxPages - globalEndRange ) {
							paginationCode += '<span class="pagination-dots paginations-dots-end">&middot;&middot;&middot;</span>';
						}

						for ( i = maxPages - globalEndRange; i <= maxPages; i++ ) {
							paginationCode += '<a href="#" class="inactive">' + i + '</a>';
						}
					}

					paginationCode += '<a class="pagination-next" href="#"><span class="page-text">Next</span><span class="page-next"></span></a>';
				}
			}

			paginationCode += '</div>';
			paginationCode += '<div class="fusion-clearfix"></div>';
		}

		return paginationCode;
	},

	fusionInlineEditor: function( args, attributes ) {
		var defaults = {
				cid: false,
				param: 'element_content',
				encoding: false,
				'disable-return': false,
				'disable-extra-spaces': false,
				toolbar: 'full',
				overrides: false
			},
			config = _.extend( defaults, args ),
			view   = FusionPageBuilderViewManager.getView( config.cid );

		// If cid is not a number then this is a nested render and do not use live editor.
		if ( 'number' !== typeof config.cid ) {
			return attributes;
		}

		attributes[ 'data-inline-parent-cid' ] = config.cid;

		// Class to mark as editor.
		if ( 'undefined' !== typeof attributes[ 'class' ] ) {
			attributes[ 'class' ] += ' fusion-live-editable';
		} else {
			attributes[ 'class' ] = 'fusion-live-editable';
		}

		if ( config[ 'disable-return' ] ) {
			attributes[ 'data-disable-return' ] = 'true';
		}

		if ( config[ 'disable-extra-spaces' ] ) {
			attributes[ 'data-disable-extra-spaces' ] = 'true';
		}

		if ( config.encoding ) {
			attributes[ 'data-encoding' ] = 'true';
		}

		if ( 'object' === typeof config.overrides ) {
			_.each( config.overrides, function( elementParam, inlineParam ) {
				attributes[ 'data-inline-override-' + inlineParam ] = elementParam;
			} );
		}
		attributes[ 'data-toolbar' ] = config.toolbar.toString();
		attributes[ 'data-param' ]   = config.param;

		if ( 'object' === typeof view && 'object' === typeof view.dynamicParams ) {
			if ( view.dynamicParams.hasDynamicParam( config.param ) ) {
				attributes[ 'data-dynamic-content-overriding' ] = 'true';
			}
		}

		return attributes;
	},

	/**
	 * JS copy of fusion_section_deprecated_args.
	 * Maps the dprecated container args.
	 *
	 * @since 2.0.0
	 * @param {Object} args - The parameters.
	 * @return {Object}
	 */
	fusionContainerMapDeprecatedArgs: function( args ) {
		var paramMapping = {
			backgroundposition: 'background_position',
			backgroundattachment: 'background_parallax',
			background_attachment: 'background_parallax',
			bordersize: 'border_size',
			bordercolor: 'border_color',
			borderstyle: 'border_style',
			paddingtop: 'padding_top',
			paddingbottom: 'padding_bottom',
			paddingleft: 'padding_left',
			paddingright: 'padding_right',
			backgroundcolor: 'background_color',
			backgroundimage: 'background_image',
			backgroundrepeat: 'background_repeat',
			paddingBottom: 'padding_bottom',
			paddingTop: 'padding_top'
		};

		if ( ( 'undefined' !== typeof args.backgroundattachment  && 'scroll' === args.backgroundattachment ) || ( 'undefined' !== typeof args.background_attachment && 'scroll' === args.background_attachment ) ) {
			args.backgroundattachment  = 'none';
			args.background_attachment = 'none';
		}

		_.each( paramMapping, function( newName, oldName ) {
			if ( 'undefined' === typeof args[ newName ] && 'undefined' !== typeof args[ oldName ] ) {
				args[ newName ] = args[ oldName ];
				delete args[ oldName ];
			}
		} );

		return args;
	},

	/**
	 * Replaces double line-breaks with paragraph elements.
	 *
	 * JS version of the wpautop() PHP function and based on the portation
	 * for the Gutenberg block editor.
	 *
	 * @since 2.0.0
	 * @param  {string}    text The text which has to be formatted.
	 * @param  {boolean}   br   Optional. If set, will convert all remaining line-
	 *                          breaks after paragraphing. Default true.
	 * @return {string}         Text which has been converted into paragraph tags.
	 */
	autop: function( text, br ) {
		var preTags = [],
			textParts,
			lastText,
			i,
			textPart,
			start,
			name,
			allBlocks,
			texts;

		if ( 'undefined' === typeof text || '' === text.trim() ) {
			return '';
		}

		br = ( 'undefined' === typeof br ) ? true : br;

		// Just to make things a little easier, pad the end.
		text = text + '\n';

		/*
		 * Pre tags shouldn't be touched by autop.
		 * Replace pre tags with placeholders and bring them back after autop.
		 */
		if ( -1 !== text.indexOf( '<pre' ) ) {
			textParts = text.split( '</pre>' );
			lastText = textParts.pop();
			text = '';

			for ( i = 0; i < textParts.length; i++ ) {
				textPart = textParts[ i ];
				start = textPart.indexOf( '<pre' );

				// Malformed html?
				if ( -1 === start ) {
					text += textPart;
					continue;
				}

				name = '<pre wp-pre-tag-' + i + '></pre>';
				preTags.push( [ name, textPart.substr( start ) + '</pre>' ] );

				text += textPart.substr( 0, start ) + name;
			}

			text += lastText;
		}

		// Change multiple <br>s into two line breaks, which will turn into paragraphs.
		text = text.replace( /<br\s*\/?>\s*<br\s*\/?>/g, '\n\n' );

		allBlocks = '(?:table|thead|tfoot|caption|col|colgroup|tbody|tr|td|th|div|dl|dd|dt|ul|ol|li|pre|form|map|area|blockquote|address|math|style|p|h[1-6]|hr|fieldset|legend|section|article|aside|hgroup|header|footer|nav|figure|figcaption|details|menu|summary)';

		// Add a double line break above block-level opening tags.
		text = text.replace( new RegExp( '(<' + allBlocks + '[\\s\/>])', 'g' ), '\n\n$1' );

		// Add a double line break below block-level closing tags.
		text = text.replace( new RegExp( '(<\/' + allBlocks + '>)', 'g' ), '$1\n\n' );

		// Standardize newline characters to "\n".
		text = text.replace( /\r\n|\r/g, '\n' );

		// Find newlines in all elements and add placeholders.
		text = this.replaceInHtmlTags( text, { '\n': ' <!-- wpnl --> ' } );

		// Collapse line breaks before and after <option> elements so they don't get autop'd.
		if ( -1 !== text.indexOf( '<option' ) ) {
			text = text.replace( /\s*<option/g, '<option' );
			text = text.replace( /<\/option>\s*/g, '</option>' );
		}

		/*
		 * Collapse line breaks inside <object> elements, before <param> and <embed> elements
		 * so they don't get autop'd.
		 */
		if ( -1 !== text.indexOf( '</object>' ) ) {
			text = text.replace( /(<object[^>]*>)\s*/g, '$1' );
			text = text.replace( /\s*<\/object>/g, '</object>' );
			text = text.replace( /\s*(<\/?(?:param|embed)[^>]*>)\s*/g, '$1' );
		}

		/*
		 * Collapse line breaks inside <audio> and <video> elements,
		 * before and after <source> and <track> elements.
		 */
		if ( -1 !== text.indexOf( '<source' ) || -1 !== text.indexOf( '<track' ) ) {
			text = text.replace( /([<\[](?:audio|video)[^>\]]*[>\]])\s*/g, '$1' );
			text = text.replace( /\s*([<\[]\/(?:audio|video)[>\]])/g, '$1' );
			text = text.replace( /\s*(<(?:source|track)[^>]*>)\s*/g, '$1' );
		}

		// Collapse line breaks before and after <figcaption> elements.
		if ( -1 !== text.indexOf( '<figcaption' ) ) {
			text = text.replace( /\s*(<figcaption[^>]*>)/, '$1' );
			text = text.replace( /<\/figcaption>\s*/, '</figcaption>' );
		}

		// Remove more than two contiguous line breaks.
		text = text.replace( /\n\n+/g, '\n\n' );

		// Split up the contents into an array of strings, separated by double line breaks.
		texts = text.split( /\n\s*\n/ ).filter( Boolean );

		// Reset text prior to rebuilding.
		text = '';

		// Rebuild the content as a string, wrapping every bit with a <p>.
		texts.forEach( function( textPiece ) {
			text += '<p>' + textPiece.replace( /^\n*|\n*$/g, '' ) + '</p>\n';
		} );

		// Under certain strange conditions it could create a P of entirely whitespace.
		text = text.replace( /<p>\s*<\/p>/g, '' );

		// Add a closing <p> inside <div>, <address>, or <form> tag if missing.
		text = text.replace( /<p>([^<]+)<\/(div|address|form)>/g, '<p>$1</p></$2>' );

		// If an opening or closing block element tag is wrapped in a <p>, unwrap it.
		text = text.replace( new RegExp( '<p>\\s*(<\/?' + allBlocks + '[^>]*>)\\s*<\/p>', 'g' ), '$1' );

		// In some cases <li> may get wrapped in <p>, fix them.
		text = text.replace( /<p>(<li.+?)<\/p>/g, '$1' );

		// If a <blockquote> is wrapped with a <p>, move it inside the <blockquote>.
		text = text.replace( /<p><blockquote([^>]*)>/gi, '<blockquote$1><p>' );
		text = text.replace( /<\/blockquote><\/p>/g, '</p></blockquote>' );

		// If an opening or closing block element tag is preceded by an opening <p> tag, remove it.
		text = text.replace( new RegExp( '<p>\\s*(<\/?' + allBlocks + '[^>]*>)', 'g' ), '$1' );

		// If an opening or closing block element tag is followed by a closing <p> tag, remove it.
		text = text.replace( new RegExp( '(<\/?' + allBlocks + '[^>]*>)\\s*<\/p>', 'g' ), '$1' );

		// Optionally insert line breaks.
		if ( br ) {

			// Replace newlines that shouldn't be touched with a placeholder.
			text = text.replace( /<(script|style).*?<\/\\1>/g, function( match ) {
				return match[ 0 ].replace( /\n/g, '<WPPreserveNewline />' );
			} );

			// Normalize <br>
			text = text.replace( /<br>|<br\/>/g, '<br />' );

			// Replace any new line characters that aren't preceded by a <br /> with a <br />.
			text = text.replace( /(<br \/>)?\s*\n/g, function( a, b ) {
				return b ? a : '<br />\n';
			} );

			// Replace newline placeholders with newlines.
			text = text.replace( /<WPPreserveNewline \/>/g, '\n' );
		}

		// If a <br /> tag is after an opening or closing block tag, remove it.
		text = text.replace( new RegExp( '(<\/?' + allBlocks + '[^>]*>)\\s*<br \/>', 'g' ), '$1' );

		// If a <br /> tag is before a subset of opening or closing block tags, remove it.
		text = text.replace( /<br \/>(\s*<\/?(?:p|li|div|dl|dd|dt|th|pre|td|ul|ol)[^>]*>)/g, '$1' );
		text = text.replace( /\n<\/p>$/g, '</p>' );

		// Replace placeholder <pre> tags with their original content.
		if ( Object.keys( preTags ).length ) {
			text = text.replace( new RegExp( Object.keys( preTags ).join( '|' ), 'gi' ), function( matched ) {
				return preTags[ matched ];
			} );
		}

		// Restore newlines in all elements.
		if ( -1 !== text.indexOf( '<!-- wpnl -->' ) ) {
			text = text.replace( /\s?<!-- wpnl -->\s?/g, '\n' );
		}

		return text;
	},

	/**
	 * Separate HTML elements and comments from the text.
	 *
	 * JS version of the html_split() PHP function and based on the portation
	 * for the Gutenberg block editor.
	 *
	 * @since 2.0
	 * @param  {string} input The text which has to be formatted.
	 * @return {Array}        The formatted text.
	 */
	htmlSplit: function( input ) {
		var parts = [],
			workingInput = input,
			match,
			htmlSplitRegex = ( function() {

				/* eslint-disable no-multi-spaces */
				var comments =
					'!' +           // Start of comment, after the <.
					'(?:' +         // Unroll the loop: Consume everything until --> is found.
						'-(?!->)' + // Dash not followed by end of comment.
						'[^\\-]*' + // Consume non-dashes.
					')*' +          // Loop possessively.
					'(?:-->)?',     // End of comment. If not found, match all input.

					cdata =
					'!\\[CDATA\\[' + // Start of comment, after the <.
					'[^\\]]*' +      // Consume non-].
					'(?:' +          // Unroll the loop: Consume everything until ]]> is found.
						'](?!]>)' +  // One ] not followed by end of comment.
						'[^\\]]*' +  // Consume non-].
					')*?' +          // Loop possessively.
					'(?:]]>)?',      // End of comment. If not found, match all input.

					escaped =
					'(?=' +              // Is the element escaped?
						'!--' +
					'|' +
						'!\\[CDATA\\[' +
					')' +
					'((?=!-)' +          // If yes, which type?
						comments +
					'|' +
						cdata +
					')',

					regex =
					'(' +               // Capture the entire match.
						'<' +           // Find start of element.
						'(' +           // Conditional expression follows.
							escaped +   // Find end of escaped element.
						'|' +           // ... else ...
							'[^>]*>?' + // Find end of normal element.
						')' +
					')';

				return new RegExp( regex );
				/* eslint-enable no-multi-spaces */
			}() );

		while ( ( match = workingInput.match( htmlSplitRegex ) ) ) {
			parts.push( workingInput.slice( 0, match.index ) );
			parts.push( match[ 0 ] );
			workingInput = workingInput.slice( match.index + match[ 0 ].length );
		}

		if ( workingInput.length ) {
			parts.push( workingInput );
		}

		return parts;
	},

	/**
	 * Replace characters or phrases within HTML elements only.
	 *
	 * JS version of the replace_html_tags() PHP function and based on the portation
	 * for the Gutenberg block editor.
	 *
	 * @since 2.0
	 * @param  {string} haystack     The text which has to be formatted.
	 * @param  {Object} replacePairs In the form {from: 'to', ...}.
	 * @return {string}              The formatted text.
	 */
	replaceInHtmlTags: function( haystack, replacePairs ) {

		// Find all elements.
		var textArr = this.htmlSplit( haystack ),
			changed = false,
			needles = Object.keys( replacePairs ), // Extract all needles.
			i, j,
			needle;

		// Loop through delimiters (elements) only.
		for ( i = 1; i < textArr.length; i += 2 ) {
			for ( j = 0; j < needles.length; j++ ) {
				needle = needles[ j ];

				if ( -1 !== textArr[ i ].indexOf( needle ) ) {
					textArr[ i ] = textArr[ i ].replace( new RegExp( needle, 'g' ), replacePairs[ needle ] );
					changed = true;

					// After one strtr() break out of the foreach loop and look at next element.
					break;
				}
			}
		}

		if ( changed ) {
			haystack = textArr.join( '' );
		}

		return haystack;
	},

	/**
	 * Generates filter CSS.
	 *
	 * @since 2.1
	 * @param {Object} values - The values.
	 * @return {String}
	 */
	fusionGetFilterStyle: function( values, state ) {
		var filters = {
			filter_hue: { property: 'hue-rotate', unit: 'deg', default: '0' },
			filter_saturation: { property: 'saturate', unit: '%', default: '100' },
			filter_brightness: { property: 'brightness', unit: '%', default: '100' },
			filter_contrast: { property: 'contrast', unit: '%', default: '100' },
			filter_invert: { property: 'invert', unit: '%', default: '0' },
			filter_sepia: { property: 'sepia', unit: '%', default: '0' },
			filter_opacity: { property: 'opacity', unit: '%', default: '100' },
			filter_blur: { property: 'blur', unit: 'px', default: '0' }
		},
		stateSuffix        = 'regular' === state ? '' : '_hover',
		otherStateSuffix   = 'regular' === state ? '_hover' : '',
		filter_id_state = '',
		filter_id_other = '',
		filter_style    = '';

		_.each( filters, function( filter, filter_id ) {
			filter_id_state = filter_id + stateSuffix;
			filter_id_other = filter_id + otherStateSuffix;
			if ( filter[ 'default' ] !== values[ filter_id_state ] || filter[ 'default' ] !== values[ filter_id_other ] ) {
				filter_style += filter.property + '(' + values[ filter_id_state ] + filter.unit + ') ';
			}
		} );

		return filter_style.trim();
	},

	/**
	 * Generates filter style element.
	 *
	 * @since 2.1
	 * @param {Object} values - The values.
	 * @param {string|object} selector - Element selector.
	 * @param {integer} cid - Element cid.
	 * @return {String}
	 */
	fusionGetFilterStyleElem: function( values, selector, cid ) {
		var filter_style       = '',
			filter_style_hover = '',
			regularSelector    = 'body:not(.fusion-builder-ui-wireframe):not(.fusion-disable-element-filters) ',
			hoverSelector      = 'body:not(.fusion-builder-ui-wireframe):not(.fusion-disable-element-filters) ';

		if ( 'object' === typeof selector ) {
			regularSelector += selector.regular;
			hoverSelector   += selector.hover;
		} else {
			regularSelector += selector;
			hoverSelector   += selector + ':hover';
		}

		// Get filter CSS.
		filter_style = this.fusionGetFilterStyle( values, 'regular' );
		if ( '' !== filter_style ) {
			filter_style = regularSelector + '{filter: ' + filter_style + ';}';
		}

		filter_style_hover = this.fusionGetFilterStyle( values, 'hover' );
		if ( '' !== filter_style_hover ) {

			// Add transition.
			filter_style = filter_style.replace( '}', 'transition: filter 0.3s ease-in-out;}' );

			// Hover state.
			filter_style += hoverSelector + '{filter: ' + filter_style_hover + ';}';
		}

		// We need empty style element as well.
		return '<style id="fusion-filter-' + cid + '-style">' + filter_style + '</style>';
	},

	/**
	 * Generates gradient string for provided options.
	 *
	 * @since 2.1
	 * @param {Object} values - Element params.
	 * @param {string} type - Required gradient string type.
	 * @return {string} - Generated string.
	 */
	getGradientString: function( values, type ) {
		var gradientString          = '',
			alphaGradientStartColor = jQuery.Color( values.gradient_start_color ).alpha(),
			alphaGradientEndColor   = jQuery.Color( values.gradient_end_color ).alpha(),
			isGradientColor         = ( ! _.isEmpty( values.gradient_start_color ) && 0 !== alphaGradientStartColor ) || ( ! _.isEmpty( values.gradient_end_color ) && 0 !== alphaGradientEndColor ) ? true : false;

		if ( isGradientColor ) {
			if ( 'linear' === values.gradient_type ) {
				gradientString += 'linear-gradient(' + values.linear_angle + 'deg,';
			} else if ( 'radial' === values.gradient_type ) {
				gradientString += 'radial-gradient(circle at ' + values.radial_direction + ', ';
			}

			gradientString += values.gradient_start_color + ' ' + values.gradient_start_position + '%,';
			gradientString += values.gradient_end_color + ' ' + values.gradient_end_position + '%)';

			switch ( type ) {

			case 'main_bg':
			case 'parallax':
				if ( '' !== values.background_image && 'yes' !== values.fade ) {
					gradientString += ',url(\'' + values.background_image + '\')';
				}
				break;
			case 'fade':
			case 'column':
				if ( '' !== values.background_image ) {
					gradientString += ',url(\'' + values.background_image + '\')';
				}
				break;
			}
		}

		return gradientString;
	},

	/**
	 * Generates box-shadow style for provided options.
	 *
	 * @since 2.1
	 * @param {Object} values - The values.
	 * @return {string} - The generated CSS.
	 */
	fusionGetBoxShadowStyle: function( values ) {
		var style = '';

		style += _.fusionGetValueWithUnit( values.box_shadow_horizontal );
		style += ' ' + _.fusionGetValueWithUnit( values.box_shadow_vertical );
		style += ' ' + _.fusionGetValueWithUnit( values.box_shadow_blur );
		style += ' ' + _.fusionGetValueWithUnit( values.box_shadow_spread );
		style += ' ' + values.box_shadow_color;

		if ( 'undefined' !== typeof values.box_shadow_style && '' !== values.box_shadow_style ) {
			style += ' ' + values.box_shadow_style;
		}

		style += ';';

		return style;
	},

	/**
	 * Generates text-shadow style for provided options.
	 *
	 * @since 2.1
	 * @param {Object} values - The values.
	 * @return {string} - The generated CSS.
	 */
	fusionGetTextShadowStyle: function( values ) {
		var style = '';

		style += _.fusionGetValueWithUnit( values.text_shadow_horizontal );
		style += ' ' + _.fusionGetValueWithUnit( values.text_shadow_vertical );
		style += ' ' + _.fusionGetValueWithUnit( values.text_shadow_blur );
		style += ' ' + values.text_shadow_color;
		style += ';';

		return style;
	},

	/**
	 * Get font family styling.
	 *
	 * @since 2.1
	 * @param {Object} values - The values.
	 * @return {String} - The generated styling.
	 */
	fusionGetFontStyle: function( param_id, values ) {
		var style  = '',
			weight = '';

		if ( '' !== values[ 'fusion_font_family_' + param_id ] ) {
			if ( values[ 'fusion_font_family_' + param_id ].includes( '\'' ) ) {
				style += 'font-family:' + values[ 'fusion_font_family_' + param_id ] + ';';
			} else {
				style += 'font-family:\'' + values[ 'fusion_font_family_' + param_id ] + '\';';
			}

			if ( '' !== values[ 'fusion_font_variant_' + param_id ] ) {
				weight = values[ 'fusion_font_variant_' + param_id ].replace( 'italic', '' );
				if ( weight !== values[ 'fusion_font_variant_' + param_id ] ) {
					style += 'font-style: italic;';
				}
				if ( '' !== weight ) {
					style += 'font-weight:' + weight + ';';
				}
			}
		}

		return style;
	},

	/**
	 * Checks if valid JSON or not.
	 *
	 * @since 3.0
	 * @param {String} value - The value to check.
	 * @return {Bolean}
	 */
	FusionIsValidJSON: function( value ) {
		try {
			JSON.parse( value );
		} catch ( e ) {
			return false;
		}
		return true;
	},

	/**
	 * Returns sticky class string.
	 *
	 * @since 3.0
	 * @param {String} value - The value to check.
	 * @return {String}
	 */
	fusionGetStickyClass: function( value ) {
		return '' !== value && ! value.includes( ',' ) ? ' fusion-display-' + value + '-only' : '';
	},

	fusionSanitize: function( str ) {

		var map = {
				'À': 'A',
				'Á': 'A',
				'Â': 'A',
				'Ã': 'A',
				'Ä': 'A',
				'Å': 'A',
				'Æ': 'AE',
				'Ç': 'C',
				'È': 'E',
				'É': 'E',
				'Ê': 'E',
				'Ë': 'E',
				'Ì': 'I',
				'Í': 'I',
				'Î': 'I',
				'Ï': 'I',
				'Ð': 'D',
				'Ñ': 'N',
				'Ò': 'O',
				'Ó': 'O',
				'Ô': 'O',
				'Õ': 'O',
				'Ö': 'O',
				'Ø': 'O',
				'Ù': 'U',
				'Ú': 'U',
				'Û': 'U',
				'Ü': 'U',
				'Ý': 'Y',
				'ß': 's',
				'à': 'a',
				'á': 'a',
				'â': 'a',
				'ã': 'a',
				'ä': 'a',
				'å': 'a',
				'æ': 'ae',
				'ç': 'c',
				'è': 'e',
				'é': 'e',
				'ê': 'e',
				'ë': 'e',
				'ì': 'i',
				'í': 'i',
				'î': 'i',
				'ï': 'i',
				'ñ': 'n',
				'ò': 'o',
				'ó': 'o',
				'ô': 'o',
				'õ': 'o',
				'ö': 'o',
				'ø': 'o',
				'ù': 'u',
				'ú': 'u',
				'û': 'u',
				'ü': 'u',
				'ý': 'y',
				'ÿ': 'y',
				'Ā': 'A',
				'ā': 'a',
				'Ă': 'A',
				'ă': 'a',
				'Ą': 'A',
				'ą': 'a',
				'Ć': 'C',
				'ć': 'c',
				'Ĉ': 'C',
				'ĉ': 'c',
				'Ċ': 'C',
				'ċ': 'c',
				'Č': 'C',
				'č': 'c',
				'Ď': 'D',
				'ď': 'd',
				'Đ': 'D',
				'đ': 'd',
				'Ē': 'E',
				'ē': 'e',
				'Ĕ': 'E',
				'ĕ': 'e',
				'Ė': 'E',
				'ė': 'e',
				'Ę': 'E',
				'ę': 'e',
				'Ě': 'E',
				'ě': 'e',
				'Ĝ': 'G',
				'ĝ': 'g',
				'Ğ': 'G',
				'ğ': 'g',
				'Ġ': 'G',
				'ġ': 'g',
				'Ģ': 'G',
				'ģ': 'g',
				'Ĥ': 'H',
				'ĥ': 'h',
				'Ħ': 'H',
				'ħ': 'h',
				'Ĩ': 'I',
				'ĩ': 'i',
				'Ī': 'I',
				'ī': 'i',
				'Ĭ': 'I',
				'ĭ': 'i',
				'Į': 'I',
				'į': 'i',
				'İ': 'I',
				'ı': 'i',
				'Ĳ': 'IJ',
				'ĳ': 'ij',
				'Ĵ': 'J',
				'ĵ': 'j',
				'Ķ': 'K',
				'ķ': 'k',
				'Ĺ': 'L',
				'ĺ': 'l',
				'Ļ': 'L',
				'ļ': 'l',
				'Ľ': 'L',
				'ľ': 'l',
				'Ŀ': 'L',
				'ŀ': 'l',
				'Ł': 'l',
				'ł': 'l',
				'Ń': 'N',
				'ń': 'n',
				'Ņ': 'N',
				'ņ': 'n',
				'Ň': 'N',
				'ň': 'n',
				'ŉ': 'n',
				'Ō': 'O',
				'ō': 'o',
				'Ŏ': 'O',
				'ŏ': 'o',
				'Ő': 'O',
				'ő': 'o',
				'Œ': 'OE',
				'œ': 'oe',
				'Ŕ': 'R',
				'ŕ': 'r',
				'Ŗ': 'R',
				'ŗ': 'r',
				'Ř': 'R',
				'ř': 'r',
				'Ś': 'S',
				'ś': 's',
				'Ŝ': 'S',
				'ŝ': 's',
				'Ş': 'S',
				'ş': 's',
				'Š': 'S',
				'š': 's',
				'Ţ': 'T',
				'ţ': 't',
				'Ť': 'T',
				'ť': 't',
				'Ŧ': 'T',
				'ŧ': 't',
				'Ũ': 'U',
				'ũ': 'u',
				'Ū': 'U',
				'ū': 'u',
				'Ŭ': 'U',
				'ŭ': 'u',
				'Ů': 'U',
				'ů': 'u',
				'Ű': 'U',
				'ű': 'u',
				'Ų': 'U',
				'ų': 'u',
				'Ŵ': 'W',
				'ŵ': 'w',
				'Ŷ': 'Y',
				'ŷ': 'y',
				'Ÿ': 'Y',
				'Ź': 'Z',
				'ź': 'z',
				'Ż': 'Z',
				'ż': 'z',
				'Ž': 'Z',
				'ž': 'z',
				'ſ': 's',
				'ƒ': 'f',
				'Ơ': 'O',
				'ơ': 'o',
				'Ư': 'U',
				'ư': 'u',
				'Ǎ': 'A',
				'ǎ': 'a',
				'Ǐ': 'I',
				'ǐ': 'i',
				'Ǒ': 'O',
				'ǒ': 'o',
				'Ǔ': 'U',
				'ǔ': 'u',
				'Ǖ': 'U',
				'ǖ': 'u',
				'Ǘ': 'U',
				'ǘ': 'u',
				'Ǚ': 'U',
				'ǚ': 'u',
				'Ǜ': 'U',
				'ǜ': 'u',
				'Ǻ': 'A',
				'ǻ': 'a',
				'Ǽ': 'AE',
				'ǽ': 'ae',
				'Ǿ': 'O',
				'ǿ': 'o',
				'α': 'a',
				'Α': 'A',
				'β': 'v',
				'Β': 'V',
				'γ': 'g',
				'Γ': 'G',
				'δ': 'd',
				'Δ': 'D',
				'ε': 'e',
				'Ε': 'E',
				'ζ': 'z',
				'Ζ': 'Z',
				'η': 'i',
				'Η': 'I',
				'θ': 'th',
				'Θ': 'TH',
				'ι': 'i',
				'Ι': 'I',
				'κ': 'k',
				'Κ': 'K',
				'λ': 'l',
				'Λ': 'L',
				'μ': 'm',
				'Μ': 'M',
				'ν': 'n',
				'Ν': 'N',
				'ξ': 'ks',
				'Ξ': 'KS',
				'ο': 'o',
				'Ο': 'O',
				'π': 'p',
				'Π': 'P',
				'ρ': 'r',
				'Ρ': 'R',
				'σ': 's',
				'Σ': 'S',
				'ς': 's',
				'τ': 't',
				'Τ': 'T',
				'υ': 'y',
				'Υ': 'Y',
				'φ': 'f',
				'Φ': 'F',
				'χ': 'x',
				'Χ': 'X',
				'ψ': 'ps',
				'Ψ': 'PS',
				'ω': 'o',
				'Ω': 'O',
				' ': '_',
				'\'': '',
				'?': '',
				'/': '',
				'\\': '',
				'.': '',
				',': '',
				'`': '',
				'>': '',
				'<': '',
				'"': '',
				'[': '',
				']': '',
				'|': '',
				'{': '',
				'}': '',
				'(': '',
				')': ''
			},
			nonWord = /\W/g,
			mapping = function ( c ) {
				return ( map[ c ] !== undefined ) ? map[ c ] : c;
			};
		return str.replace( nonWord, mapping ).toLowerCase();
	}
} );
;/* global MediumEditor, FusionPageBuilderApp */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	FusionPageBuilder.InlineEditorHelpers = Backbone.Model.extend( {
		initialize: function() {
			this._reRenderElement = _.debounce( _.bind( this.reRenderElement, this ), 300 );
			this._logChangeEvent  = _.debounce( _.bind( this.logChangeEvent, this ), 500 );
			this.initialValue     = null;
		},

		logChangeEvent: function( param, value, tempModel, paramName ) {
			var label = paramName,
				state = {
					type: 'param',
					param: param,
					newValue: value,
					cid: tempModel.parentView.model.get( 'cid' )
				},
				elementMap = window.fusionAllElements[ tempModel.get( 'element_type' ) ],
				paramTitle = 'object' === typeof elementMap.params[ label ] ? elementMap.params[ label ].heading : param;

			state.oldValue    = this.initialValue;
			this.initialValue = null;

			window.FusionEvents.trigger( 'fusion-history-save-step', window.fusionBuilderText.edited + ' ' + elementMap.name + ' - ' + paramTitle, state );
		},

		updateInlineShortcode: function( oldShortcode, newShortcode, tempModel, paramName ) {
			var oldContent = tempModel.parentView.model.attributes.params.element_content,
				newContent = oldContent.replace( oldShortcode, newShortcode );

			tempModel.parentView.model.attributes.params.element_content = newContent;
			tempModel.set( 'inlineElement', newShortcode );

			if ( null === this.initialValue ) {
				this.initialValue = oldContent;
			}
			this._logChangeEvent( 'element_content', newContent, tempModel, paramName );
		},

		processInlineElement: function( model, paramName ) {
			var newViewOutput,
				tooltipElements = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( model.parentView.$el ).find( '[data-id="' + model.get( 'cid' ) + '"]' ).find( '[data-toggle="tooltip"]' );

			if ( tooltipElements.length ) {
				tooltipElements.tooltip( 'destroy' );
			}

			// Update shortcode
			this.updateInlineShortcode( model.get( 'inlineElement' ), FusionPageBuilderApp.generateElementShortcode( model, false, true ), model, paramName );

			// Get markup
			newViewOutput = this.getInlineElementMarkup( model );

			// Append html
			model.parentView.$el.find( '[data-id="' + model.get( 'cid' ) + '"]:not(.fusion-inline-ajax)' ).html( '' ).append( newViewOutput );

			// Trigger js
			jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-element-render-fusion_text', model.parentView.model.attributes.cid );
		},

		getInlineElementMarkup: function( model ) {
			var viewSettings = {
					model: model
				},
				newView,
				newViewOutput;

			if ( 'undefined' !== typeof FusionPageBuilder[ model.get( 'element_type' ) ] ) {
				newView = new FusionPageBuilder[ model.get( 'element_type' ) ]( viewSettings );
			} else {
				newView = new FusionPageBuilder.ElementView( viewSettings );
			}

			newViewOutput = newView.getTemplate();

			return newViewOutput;
		},

		getInlineElementSettings: function( model ) {
			var viewSettings = {
					model: model
				},
				modalView    = new FusionPageBuilder.ElementSettingsView( viewSettings );

			// No need to render if it already is.
			if ( ! FusionPageBuilderApp.SettingsHelpers.shouldRenderSettings( modalView ) ) {
				return;
			}

			// If we want dialog.
			if ( 'dialog' === window.FusionApp.preferencesData.editing_mode ) {
				jQuery( modalView.render().el ).dialog( {
					title: window.fusionAllElements[ model.get( 'element_type' ) ].name,
					width: window.FusionApp.dialog.dialogData.width,
					height: window.FusionApp.dialog.dialogData.height,
					position: window.FusionApp.dialog.dialogData.position,
					dialogClass: 'fusion-builder-dialog fusion-builder-settings-dialog',

					dragStop: function( event, ui ) {
						window.FusionApp.dialog.saveDialogPosition( ui.offset );
					},

					resizeStop: function( event, ui ) {
						window.FusionApp.dialog.saveDialogSize( ui.size );
					},

					open: function( event ) {
						var $dialogContent = jQuery( event.target ),
							$tabMenu = $dialogContent.find( '.fusion-builder-modal-top-container' );

						$dialogContent.closest( '.ui-dialog' ).find( '.ui-dialog-titlebar' ).append( $tabMenu );
						FusionPageBuilderApp.$el.addClass( 'fusion-builder-no-ui' );
					},
					dragStart: function( event ) {

						// Used to close any open drop-downs in TinyMce.
						jQuery( event.target ).trigger( 'click' );
					},

					beforeClose: function() {
						modalView.saveSettings();
						window.FusionEvents.trigger( 'fusion-content-changed' );
						FusionPageBuilderApp.$el.removeClass( 'fusion-builder-no-ui' );
					}

				} );
			} else {

				// Adding into sidebar view instead.
				modalView.model.set( 'title', window.fusionAllElements[ model.get( 'element_type' ) ].name );
				modalView.model.set( 'display', 'sidebar' );
				window.FusionApp.sidebarView.renderElementSettings( modalView );
			}
		},

		removeStyle: function( model ) {
			var $editor,
				content,
				param,
				params = model.parentView.model.get( 'params' ),
				editorInstance;

			$editor = model.$target.closest( '.fusion-live-editable' );

			model.$target.replaceWith( model.attributes.params.element_content );

			editorInstance = FusionPageBuilderApp.inlineEditors.getEditor( $editor.data( 'medium-editor-editor-index' ) );
			if ( 'undefined' !== typeof editorInstance ) {
				content = editorInstance.getContent();
			} else {
				content = $editor.html();
			}

			param   = $editor.data( 'param' ),

			// Fix for inline font family style.
			content = content.replace( /&quot;/g, '\'' );

			// Adds in any inline shortcodes.
			content = FusionPageBuilderApp.htmlToShortcode( content, model.parentView.model.get( 'cid' ) );

			params[ param ] = content;
			model.parentView.model.set( 'params', params );
		},

		/**
		 * Init the Medium Editor for elements that can be live-edited.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		liveEditor: function( view ) {
			var liveElements = view.$el.find( '.fusion-live-editable:not([data-medium-editor-element="true"])' );

			if ( liveElements.length ) {
				liveElements.each( function() {
					FusionPageBuilderApp.inlineEditors.addEditorInstance( jQuery( this ), view );
				} );
			}
		},

		/**
		 * Destroys each instance of live editor.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		removeLiveEditors: function( view ) {
			var liveElements = view.$el.find( '[data-medium-editor-element="true"]' ),
				viewEditors  = view.model.get( 'inlineEditors' );

			// First remove IDs stored on view.
			if ( 'undefined' !== typeof viewEditors && viewEditors.length ) {
				_.each( viewEditors, function( inlineEditor ) {
					FusionPageBuilderApp.inlineEditors.destroyEditor( inlineEditor );
				} );
			}

			// Check if there are still more IDs in DOM.
			if ( liveElements.length ) {
				liveElements.each( function() {
					FusionPageBuilderApp.inlineEditors.destroyEditor( jQuery( this ).data( 'medium-editor-editor-index' ) );
				} );
			}

			view.model.set( 'inlineEditors', [] );
		},

		liveEditorEvent: function( view ) {
			var self     = this,
				$editors = view.$el.find( '.fusion-live-editable' );

			// Remove any we already have, to prevent duplicates.
			self.removeLiveEditors( view );

			if ( true === view.model.get( 'inline_editor' ) && view.$el ) {
				if ( 1 === $editors.length && view.autoSelectEditor ) {
					FusionPageBuilderApp.inlineEditors.addEditorInstance( $editors, view, true );
				} else {
					$editors.on( 'mouseenter.inline-editor', function() {
						self.liveEditor( view );
					} );
				}
				view.autoSelectEditor = false;
			}
		},

		getInlineHTML: function( content, id ) {
			var $newContent;

			if ( '' === content || 'undefined' === typeof content ) {
				return '';
			}

			try {
				$newContent = jQuery( content );
			} catch ( error ) {
				console.log( error ); // jshint ignore:line

				return content;
			}

			// If no length, meaning no wrapping tag in this case then we wrap.
			if ( 0 === $newContent.length ) {
				$newContent = jQuery( '<span />' ).html( content );
			} else if ( 1 < $newContent.length ) {
				$newContent = jQuery( '<div />' ).html( content );
			}

			$newContent.addClass( 'fusion-disable-editing fusion-inline-ajax' ).attr( 'contenteditable', 'false' ).attr( 'data-id', id );

			// Span is added for content which is just a string and used as a selector #2609.
			return $newContent[ 0 ].outerHTML;
		},

		/**
		 * Checks whether the inline editor is enabled.
		 *
		 * @since 2.0.0
		 * @param {string} shortcodeTag - Shortcode tag.
		 * @return {boolean}
		 */
		inlineEditorAllowed: function( shortcodeTag ) {
			var inlineEditor = 'undefined' !== typeof window.fusionAllElements[ shortcodeTag ] && 'undefined' !== typeof window.fusionAllElements[ shortcodeTag ].inline_editor ? window.fusionAllElements[ shortcodeTag ].inline_editor : false;

			return inlineEditor;
		},

		/**
		 * Used to update model param if exists as override.
		 *
		 * @since 2.0.0
		 * @param {string} cid - The element cid.
		 * @param {string} param - The parameter name.
		 * @param {string} value - The new parameter value.
		 * @param {boolean} debounced - To debounce update or not.
		 * @return {void}
		 */
		updateParentElementParam: function( cid, param, value, debounced ) {
			var view      = window.FusionPageBuilderViewManager.getView( cid ),
				params    = 'undefined' !== typeof view ? view.model.get( 'params' ) : false;

			debounced = 'undefined' !== typeof debounced ? debounced : false;

			if ( 'undefined' === typeof cid || 'undefined' === typeof param || 'undefined' === typeof value || ! params ) {
				return false;
			}

			if ( ! param ) {
				return false;
			}

			if ( value === params[ param ] ) {
				return true;
			}

			view.activeInlineEditing = true;

			if ( debounced ) {
				this._reRenderElement( view, param, value );
			} else {
				this.reRenderElement( view, param, value );
			}
			return true;
		},

		reRenderElement: function( view, param, value  ) {
			var reRender = true;

			if ( view ) {
				reRender = view.updateParam( param, value );

				if ( reRender ) {
					view.reRender();
				}
			}
		},

		setOverrideParams: function( control, option ) {
			var selectionHtml  = MediumEditor.selection.getSelectionHtml( control.document ),
				el             = MediumEditor.selection.getSelectionElement( control.document ),
				innerHTML      = el ? el.innerHTML.trim() : '',
				overrideObject = {};

			// Default for not full content or overwritable.
			control.parentCid = false;
			control.override  = false;

			// Element has not override for option.
			if ( ! el || ! el.classList.contains( 'fusion-live-editable' ) ) {
				return;
			}

			if ( 'string' === typeof option ) {

				// Selection is not full.
				if ( ! el.getAttribute( 'data-inline-override-' + option ) || ( selectionHtml.trim() !== innerHTML && jQuery( '<div>' + selectionHtml + '</div>' ).text().trim() !== jQuery( '<div>' + innerHTML + '</div>' ).text().trim() ) ) {
					return;
				}
				control.override  = el.getAttribute( 'data-inline-override-' + option );
				control.parentCid = el.getAttribute( 'data-inline-parent-cid' );

			} else if ( 'object' == typeof option ) {
				_.each( option, function( scopedOption ) {
					if ( ! el.getAttribute( 'data-inline-override-' + scopedOption ) || ( selectionHtml.trim() !== innerHTML && jQuery( '<div>' + selectionHtml + '</div>' ).text().trim() !== jQuery( '<div>' + innerHTML + '</div>' ).text().trim() ) ) {
						overrideObject[ scopedOption ] = false;
					} else {
						overrideObject[ scopedOption ] = el.getAttribute( 'data-inline-override-' + scopedOption );
						control.parentCid        = el.getAttribute( 'data-inline-parent-cid' );
					}
					control.override = overrideObject;
				} );
			}
		}

	} );

}( jQuery ) );
;/* global fusionOptionName, FusionApp, FusionPageBuilderElements, fusionAppConfig, FusionPageBuilderApp, FusionPageBuilderViewManager */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	_.extend( FusionPageBuilder.Callback.prototype, {
		fusion_preview: function( name, value, args, view ) {
			var property = args.property,
				element  = window.fusionAllElements[ view.model.get( 'element_type' ) ],
				$theEl;

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			if ( ! value && '' !== value ) {
				return;
			}

			if ( '' === value && 'undefined' !== typeof element && 'undefined' !== typeof element.defaults && 'undefined' !== typeof element.defaults[ name ] ) {
				value = element.defaults[ name ];
			}
			if ( 'undefined' !== typeof args.dimension ) {
				property = ( 'undefined' !== typeof args.property[ name ] ) ? args.property[ name ] : name.replace( /_/g, '-' );
			}
			if ( 'undefined' !== typeof args.unit ) {
				value = _.fusionGetValueWithUnit( value, args.unit );
			}
			$theEl = ( 'undefined' === typeof args.selector ) ? view.$el : view.$el.find( args.selector );
			if ( 'string' === typeof property ) {
				$theEl.css( property, value );
			}
			if ( 'object' === typeof property ) {
				_.each( args.property, function( singleProperty ) {
					$theEl.css( singleProperty, value );
				} );
			}

			return {
				render: false
			};
		},

		fusion_update_flex_elements: function( name, value, args, view ) {
			var params   = view.model.get( 'params' ),
				oldValue = 'undefined' !== typeof params.content_layout ? params.content_layout : 'column';

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			// If we are switching between flex and block then we need to re-render inline elements.
			if ( ( 'block' === oldValue && 'block' !== value ) || ( 'block' === value && 'block' !== oldValue ) ) {
				view.model.children.each( function( child ) {
					var cid         = child.attributes.cid,
						elementView = FusionPageBuilderViewManager.getView( cid ),
						elementType;

					if ( elementView ) {
						elementType = elementView.model.get( 'element_type' );
						if ( 'fusion_title' === elementType || 'fusion_button' === elementType || 'fusion_text' === elementType || 'fusion_imageframe' === elementType ) {
							elementView.reRender();
						}
					}
				} );
			}

			// Add attribute to the option.
			jQuery( '[data-option-id="content_layout"]' ).attr( 'data-direction', value );

			return {
				render: true
			};
		},

		fusion_container_padding: function( name, value, args, view ) {
			if ( 'function' !== typeof view.isFlex || ! view.isFlex() ) {
				return this.fusion_preview( name, value, args, view );
			}
			if ( ! args.skip ) {
				view.changeParam( name, value );
			}
			view.setValues();
			view.setResponsiveContainerStyles();
			view.$el.find( '.fusion-container-responsive-styles' ).first().html( view.responsiveStyles );

			return {
				render: false
			};
		},

		fusion_container_margin: function( name, value, args, view ) {
			return this.fusion_container_padding( name, value, args, view );
		},

		fusion_column_margin: function( name, value, args, view ) {
			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			if ( view.values.flex ) {
				view.values = {};
				view.setArgs();
				view.validateArgs();
				view.setExtraArgs();
				view.setColumnMapData();
				view.setResponsiveColumnStyles();

				view.$el.find( '.fusion-column-responsive-styles' ).last().html( view.responsiveStyles );
			} else {
				view.$el.css( name.replace( '_', '-' ), value );
				view.values[ name ] = value;
			}
			return {
				render: false
			};
		},

		fusion_column_padding: function( name, value, args, view ) {
			return this.fusion_column_margin( name, value, args, view );
		},

		fusion_add_id: function( name, value, args, view ) {
			var $theEl;

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			$theEl = ( 'undefined' === typeof args.selector ) ? view.$el : view.$el.find( args.selector );

			$theEl.attr( 'id', value );

			return {
				render: false
			};
		},

		fusion_add_class: function( name, value, args, view ) {
			var $theEl,
				existingValue = view.model.attributes.params[ name ];

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			$theEl = ( 'undefined' === typeof args.selector ) ? view.$el : view.$el.find( args.selector );

			$theEl.removeClass( existingValue );
			$theEl.addClass( value );

			return {
				render: false
			};
		},

		fusion_toggle_class: function( name, value, args, view ) {
			var $theEl;

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			$theEl = ( 'undefined' === typeof args.selector ) ? view.$el : view.$el.find( args.selector );

			if ( 'object' === typeof args.classes ) {
				_.each( args.classes, function( optionClass, optionValue ) {
					$theEl.removeClass( optionClass );
					if ( value === optionValue ) {
						$theEl.addClass( optionClass );
					}
				} );
			}

			return {
				render: false
			};
		},

		fusion_ajax: function( name, value, modelData, args, cid, action, model, elementView ) {

			var params   = jQuery.extend( true, {}, modelData.params ),
				ajaxData = {};

			if ( 'undefined' !== typeof name && ! args.skip ) {
				params[ name ] = value;
			}
			ajaxData.params = jQuery.extend( true, {}, window.fusionAllElements[ modelData.element_type ].defaults, _.fusionCleanParameters( params ) );

			jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'post',
				dataType: 'json',
				data: {
					action: action,
					model: ajaxData,
					option_name: 'string' === typeof fusionOptionName ? fusionOptionName : false,
					fusion_options: 'undefined' !== typeof FusionApp && 'object' === typeof FusionApp.settings ? jQuery.param( FusionApp.settings ) : false,
					fusion_meta: 'undefined' !== typeof FusionApp && 'object' === typeof FusionApp.data.postMeta ? jQuery.param( FusionApp.data.postMeta ) : false,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				if ( 'undefined' === typeof model ) {
					model = FusionPageBuilderElements.find( function( scopedModel ) {
						return scopedModel.get( 'cid' ) == cid; // jshint ignore: line
					} );
				}

				// This changes actual model.
				if ( 'undefined' !== typeof name && ! args.skip ) {
					elementView.changeParam( name, value );
				}

				if ( 'image_id' === name && 'undefined' !== typeof response.image_data && 'undefined' !== typeof response.image_data.url && ! args.skip ) {
					elementView.changeParam( 'image', response.image_data.url );
				}

				model.set( 'query_data', response );

				if ( 'generated_element' !== model.get( 'type' ) ) {
					if ( 'undefined' == typeof elementView ) {
						elementView = FusionPageBuilderViewManager.getView( cid );
					}

					if ( 'undefined' !== typeof elementView && ! args.skip ) {
						elementView.reRender();
					}
				}
			} );
		},

		fusion_do_shortcode: function( cid, content, parent, ajaxShortcodes ) {

			jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'post',
				dataType: 'json',
				data: {
					action: 'get_shortcode_render',
					content: content,
					shortcodes: 'undefined' !== typeof ajaxShortcodes ? ajaxShortcodes : '',
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					cid: cid,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				var markup = {},
					modelcid = cid,
					model,
					view;

				if ( 'undefined' !== typeof parent && parent ) {
					modelcid = parent;
				}

				model = FusionPageBuilderElements.find( function( scopedModel ) {
					return scopedModel.get( 'cid' ) == modelcid; // jshint ignore: line
				} );

				view = FusionPageBuilderViewManager.getView( modelcid );

				markup.output = FusionPageBuilderApp.addPlaceholder( content, response.content );

				if ( view && 'function' === typeof view.filterOutput ) {
					markup.output = view.filterOutput( markup.output );
				}

				markup.shortcode = content;

				if ( model ) {
					model.set( 'markup', markup );
				}

				// If multi shortcodes, add each.
				if ( 'object' === typeof response.shortcodes ) {
					_.each( response.shortcodes, function( output, shortcode ) {
						FusionPageBuilderApp.extraShortcodes.addShortcode( shortcode, FusionPageBuilderApp.addPlaceholder( shortcode, output ) );
					} );
				}

				if ( 'undefined' !== typeof view ) {
					view.reRender( 'ajax' );
				}

				if ( FusionPageBuilderApp.viewsToRerender ) {
					_.each( FusionPageBuilderApp.viewsToRerender, function( scopedCID ) {
						FusionPageBuilderViewManager.getView( scopedCID ).reRender( 'ajax' );
					} );

					FusionPageBuilderApp.viewsToRerender = [];
				}
			} );
		},

		fusion_code_mirror: function( name, value, args, view ) {

			// Save encoded value.
			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			if ( FusionPageBuilderApp.base64Encode( FusionPageBuilderApp.base64Decode( value ) ) === value ) {
				value = FusionPageBuilderApp.base64Decode( value );
			}

			// Update with decoded value.
			view.syntaxHighlighter.getDoc().setValue( value );

			return {
				render: false
			};
		},

		dynamic_shortcode: function( args ) {
			if ( 'undefined' === typeof args.shortcode || '' === args.shortcode ) {
				return '';
			}

			return jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'post',
				dataType: 'json',
				data: {
					action: 'get_shortcode_render',
					content: args.shortcode,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					cid: false,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				FusionPageBuilderApp.dynamicValues.setValue( args, response.content );
			} );
		},

		post_featured_image: function( args ) {
			var ID     = '',
				postMeta = FusionApp.getDynamicPost( 'post_meta' ),
				postName = FusionApp.getPost( 'post_type_name' ).toLowerCase();

			postMeta._fusion = postMeta._fusion || {};

			if ( 'undefined' !== typeof args.type && 'main' !== args.type ) {
				ID = postMeta._fusion[ 'kd_' + args.type + '_' + postName + '_id' ];
			} else {
				ID = postMeta._thumbnail_id;
			}

			if ( 'undefined' === typeof ID || '' === ID ) {
				return ID;
			}

			return wp.media.attachment( ID ).fetch().then( function() {
				FusionPageBuilderApp.dynamicValues.setValue( args, wp.media.attachment( ID ).get( 'url' ) );
			} );
		},

		fusion_get_object_title: function() {
			return 'undefined' !== typeof FusionApp.data ? FusionApp.getDynamicPost( 'post_title' ) : '';
		},

		fusion_get_post_id: function() {
			return 'undefined' !== typeof FusionApp.data ? FusionApp.getDynamicPost( 'post_id' ) : '';
		},

		fusion_get_object_excerpt: function() {
			return 'undefined' !== typeof FusionApp.data ? FusionApp.getDynamicPost( 'post_excerpt' ) : '';
		},

		fusion_get_post_date: function( args ) {

			if ( 'undefined' === typeof FusionApp.data ) {
				return '';
			}

			if ( 'undefined' === args.format || '' === args.format ) {
				return 'undefined' !== typeof args.type && 'modified' === args.type ? FusionApp.getDynamicPost( 'post_modified' ) : FusionApp.getDynamicPost( 'post_date' );
			}

			return jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'get',
				dataType: 'json',
				data: {
					action: 'ajax_dynamic_data_default_callback',
					callback: FusionApp.data.dynamicOptions[ args.data ].callback[ 'function' ],
					args: args,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				FusionPageBuilderApp.dynamicValues.setValue( args, response.content );
			} );
		},

		fusion_get_post_time: function( args ) {

			if ( 'undefined' === typeof FusionApp.data ) {
				return '';
			}

			return jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'get',
				dataType: 'json',
				data: {
					action: 'ajax_dynamic_data_default_callback',
					callback: FusionApp.data.dynamicOptions[ args.data ].callback[ 'function' ],
					args: args,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				FusionPageBuilderApp.dynamicValues.setValue( args, response.content );
			} );
		},

		fusion_get_post_terms: function( args ) {

			if ( 'undefined' === typeof FusionApp.data ) {
				return '';
			}

			return jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'get',
				dataType: 'json',
				data: {
					action: 'ajax_dynamic_data_default_callback',
					callback: FusionApp.data.dynamicOptions[ args.data ].callback[ 'function' ],
					args: args,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				FusionPageBuilderApp.dynamicValues.setValue( args, response.content );
			} );
		},

		fusion_get_post_custom_field: function( args ) {
			var postMeta = FusionApp.getDynamicPost( 'post_meta' );
			postMeta._fusion = postMeta._fusion || {};
			return 'undefined' !== typeof postMeta[ args.key ] ? postMeta[ args.key ] : '';
		},

		fusion_get_page_option: function( args ) {
			var postMeta = FusionApp.getDynamicPost( 'post_meta' );
			postMeta._fusion = postMeta._fusion || {};
			return 'undefined' !== typeof postMeta._fusion[ args.data ] ? postMeta._fusion[ args.data ] : '';
		},

		fusion_get_site_title: function() {
			return 'undefined' !== typeof FusionApp.data ? FusionApp.data.site_title : '';
		},

		fusion_get_site_tagline: function() {
			return 'undefined' !== typeof FusionApp.data ? FusionApp.data.site_tagline : '';
		},

		fusion_get_site_url: function() {
			return 'undefined' !== typeof FusionApp.data ? FusionApp.data.site_url : '';
		},

		fusion_get_site_logo: function( args ) {
			var type = 'undefined' !== typeof args.type ? args.type : false,
				data = {};

			if ( ! type ) {
				return '';
			}

			switch ( type ) {
				case 'default_normal':
					return FusionApp.settings.logo.url;

				case 'default_retina':
					return FusionApp.settings.logo_retina.url;

				case 'sticky_normal':
					return FusionApp.settings.sticky_header_logo.url;

				case 'sticky_retina':
					return FusionApp.settings.sticky_header_logo_retina.url;

				case 'mobile_normal':
					return FusionApp.settings.mobile_logo.url;

				case 'mobile_retina':
					return FusionApp.settings.mobile_logo_retina.url;

				case 'all':
					data[ 'default' ] = {
						'normal': FusionApp.settings.logo,
						'retina': FusionApp.settings.logo_retina
					};
					data.mobile = {
						'normal': FusionApp.settings.mobile_logo,
						'retina': FusionApp.settings.mobile_logo_retina
					};
					data.sticky = {
						'normal': FusionApp.settings.sticky_header_logo,
						'retina': FusionApp.settings.sticky_header_logo_retina
					};

					return JSON.stringify( data );
				}
			return '';
		},

		fusion_menu: function( name, value, args, view ) {
			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			const attrs = view.getTemplateAtts();

			view.$el.find( 'style' ).first().replaceWith( attrs.inlineStyles );

			// If the ajax markup is still there from initial load then data-count is wrong.
			view.$el.find( 'nav' ).attr( 'data-count', view.model.get( 'cid' ) );

			return {
				render: false
			};
		},

		woo_get_price: function( args ) {

			return jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'get',
				dataType: 'json',
				data: {
					action: 'ajax_dynamic_data_default_callback',
					callback: FusionApp.data.dynamicOptions[ args.data ].callback[ 'function' ],
					args: args,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				FusionPageBuilderApp.dynamicValues.setValue( args, response.content );
			} );
		},

		woo_get_sku: function( args ) {

			return jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'get',
				dataType: 'json',
				data: {
					action: 'ajax_dynamic_data_default_callback',
					callback: FusionApp.data.dynamicOptions[ args.data ].callback[ 'function' ],
					args: args,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				FusionPageBuilderApp.dynamicValues.setValue( args, response.content );
			} );
		},

		defaultDynamicCallback: function( args ) {
			return jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'get',
				dataType: 'json',
				data: {
					action: 'ajax_dynamic_data_default_callback',
					callback: FusionApp.data.dynamicOptions[ args.data ].callback[ 'function' ],
					args: args,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				FusionPageBuilderApp.dynamicValues.setValue( args, response.content );
			} );
		},

		woo_get_stock: function( args ) {

			return jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'get',
				dataType: 'json',
				data: {
					action: 'ajax_dynamic_data_default_callback',
					callback: FusionApp.data.dynamicOptions[ args.data ].callback[ 'function' ],
					args: args,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				FusionPageBuilderApp.dynamicValues.setValue( args, response.content );
			} );
		},

		woo_get_rating: function( args ) {

			return jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'get',
				dataType: 'json',
				data: {
					action: 'ajax_dynamic_data_default_callback',
					callback: FusionApp.data.dynamicOptions[ args.data ].callback[ 'function' ],
					args: args,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					post_id: FusionApp.getDynamicPost( 'post_id' )
				}
			} )
			.done( function( response ) {
				FusionPageBuilderApp.dynamicValues.setValue( args, response.content );
			} );
		},

		/**
		 * Updates selector element with CSS filter style.
		 *
		 * @param {*} name Param name.
		 * @param {*} value Param value.
		 * @param {*} args Args defined.
		 * @param {*} view Element view.
		 */
		fusion_update_filter_style: function( name, value, args, view ) {
			var newStyle = '',
				cid      = view.model.get( 'cid' ),
				$styleEl = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#fusion-filter-' + cid + '-style' );

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			newStyle = _.fusionGetFilterStyleElem( view.getValues(), '.' + args.selector_base + cid, cid );

			// Update filter style block.
			if ( 0 < $styleEl.length ) {
				$styleEl.replaceWith( newStyle );
			}

			return {
				render: false
			};
		},

		/**
		 * Updates gradient styles for selector element.
		 *
		 * @param  {String} name  Param name.
		 * @param  {String} value Param value.
		 * @param  {Object} args  Args defined.
		 * @param  {Object} view  Element view.
		 * @return {Object}
		 */
		fusion_update_gradient_style: function( name, value, args, view ) {
			var $theEl,
				mainBGStyles         = '',
				parallaxStyles       = '',
				overlayStyles        = '',
				fadedStyles          = '',
				alphaBackgroundColor = '',
				videoBg              = false,
				elementType          = view.model.get( 'element_type' ),
				values               = {};

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			values = view.getValues();

			$theEl = ( 'undefined' === typeof args.selector ) ? view.$el : view.$el.find( args.selector ).first();

			switch ( elementType ) {
				case 'fusion_builder_container':
					mainBGStyles         = _.getGradientString( values, 'main_bg' );
					parallaxStyles       = _.getGradientString( values, 'parallax' );
					fadedStyles          = _.getGradientString( values, 'fade' );
					overlayStyles        = _.getGradientString( values );
					alphaBackgroundColor = jQuery.Color( values.background_color ).alpha();

					if ( '' === mainBGStyles && '' !== values.background_image && 'yes' !== values.fade ) {
						mainBGStyles = 'url(\'' + values.background_image + '\')';
					}

					$theEl.css( 'background-image', mainBGStyles );
					$theEl.find( '.parallax-inner' ).css( 'background-image', parallaxStyles );
					$theEl.find( '.fullwidth-overlay' ).css( 'background-image', overlayStyles );
					$theEl.find( '.fullwidth-faded' ).css( 'background-image', fadedStyles );

					if ( ( 'undefined' !== typeof values.video_mp4 && '' !== values.video_mp4 ) ||
					( 'undefined' !== typeof values.video_webm && '' !== values.video_webm ) ||
					( 'undefined' !== typeof values.video_ogv && '' !== values.video_ogv ) ||
					( 'undefined' !== typeof values.video_url && '' !== values.video_url ) ) {
						videoBg   = true;
					}

					if ( 1 > alphaBackgroundColor && 0 !== alphaBackgroundColor && 'none' === values.background_blend_mode && '' === overlayStyles && ( ! _.isEmpty( values.background_image ) || ! videoBg ) ) {
						$theEl.addClass( 'fusion-blend-mode' );
					} else {
						$theEl.removeClass( 'fusion-blend-mode' );
					}

					break;

				case 'fusion_builder_column':
				case 'fusion_builder_column_inner':
					mainBGStyles         = _.getGradientString( values, 'column' );
					alphaBackgroundColor = jQuery.Color( values.background_color ).alpha();

					if ( '' === mainBGStyles && '' !== values.background_image ) {
						mainBGStyles = 'url(\'' + values.background_image + '\')';
					}
					$theEl.css( 'background-image', mainBGStyles );

					if ( 1 > alphaBackgroundColor && 0 !== alphaBackgroundColor && 'none' === values.background_blend_mode && '' === _.getGradientString( values ) && _.isEmpty( values.background_image ) && ! _.isEmpty( values.background_color ) ) {
						$theEl.closest( '.fusion-layout-column' ).addClass( 'fusion-blend-mode' );
					} else {
						$theEl.closest( '.fusion-layout-column' ).removeClass( 'fusion-blend-mode' );
					}

					break;
			}

			return {
				render: false
			};
		},

		/**
		 * Updates separator for selector element.
		 *
		 * @param  {String} name  Param name.
		 * @param  {String} value Param value.
		 * @param  {Object} args  Args defined.
		 * @param  {Object} view  Element view.
		 * @return {Object}
		 */
		fusion_update_breadcrumbs_separator: function( name, value, args, view ) {
			var $theEl,
				markup     = {},
				query_data = {};

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			if ( FusionApp.data.is_home || FusionApp.data.is_front_page ) {
				return;
			}

			$theEl = ( 'undefined' === typeof args.selector ) ? view.$el : view.$el.find( args.selector );

			if ( '' !== value ) {
				$theEl.find( '.fusion-breadcrumb-sep' ).html( value );
			} else if ( 'undefined' !== typeof FusionApp && 'object' === typeof FusionApp.settings ) {
				$theEl.find( '.fusion-breadcrumb-sep' ).html( FusionApp.settings.breadcrumb_separator );
			}

			markup.output          = $theEl.html();
			query_data.breadcrumbs = $theEl.html();

			view.model.set( 'markup', markup );
			view.model.set( 'query_data', query_data );

			return {
				render: false
			};
		},

		/**
		 * Updates separator for selector element.
		 *
		 * @param  {String} name  Param name.
		 * @param  {String} value Param value.
		 * @param  {Object} args  Args defined.
		 * @param  {Object} view  Element view.
		 * @return {Object}
		 */
		fusion_update_tb_meta_separator: function( name, value, args, view ) {
			var $theEl,
				markup     = {},
				query_data = {};

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			$theEl = ( 'undefined' === typeof args.selector ) ? view.$el : view.$el.find( args.selector );

			$theEl.find( '.fusion-meta-tb-sep' ).html( value );

			markup.output   = $theEl.html();
			query_data.meta = $theEl.html();

			view.model.set( 'markup', markup );
			view.model.set( 'query_data', query_data );

			return {
				render: false
			};
		},

		/**
		 * Updates prefix for selector element.
		 *
		 * @param  {String} name  Param name.
		 * @param  {String} value Param value.
		 * @param  {Object} args  Args defined.
		 * @param  {Object} view  Element view.
		 * @return {Object}
		 */
		fusion_update_breadcrumbs_prefix: function( name, value, args, view ) {
			var $theEl,
				markup     = {},
				query_data = {};

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			if ( FusionApp.data.is_home || FusionApp.data.is_front_page ) {
				return;
			}

			$theEl = ( 'undefined' === typeof args.selector ) ? view.$el : view.$el.find( args.selector );

			$theEl.find( '.fusion-breadcrumb-prefix' ).remove();

			if ( '' !== value ) {
				$theEl.prepend( '<span class="fusion-breadcrumb-prefix"><span class="fusion-breadcrumb-item"><span>' + value + '</span></span>:</span>' );
			} else if ( 'undefined' !== typeof FusionApp && 'object' === typeof FusionApp.settings && '' !== FusionApp.settings.breacrumb_prefix ) {
				$theEl.prepend( '<span class="fusion-breadcrumb-prefix"><span class="fusion-breadcrumb-item"><span>' + FusionApp.settings.breacrumb_prefix + '</span></span>:</span>' );
			}

			markup.output          = $theEl.html();
			query_data.breadcrumbs = $theEl.html();

			view.model.set( 'markup', markup );
			view.model.set( 'query_data', query_data );

			return {
				render: false
			};
		},

		/**
		 * Updates container flex attributes.
		 *
		 * @param  {String} name  Param name.
		 * @param  {String} value Param value.
		 * @param  {Object} args  Args defined.
		 * @param  {Object} view  Element view.
		 * @return {Object}
		 */
		fusion_update_flex_container: function( name, value, args, view ) {
			var $theEl;

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			$theEl = ( 'undefined' === typeof args.selector ) ? view.$el : view.$el.find( args.selector );

			switch ( name ) {
				case 'flex_align_items':
					$theEl.find( '.fusion-builder-row' ).removeClass( function ( index, className ) {
						return ( className.match( /(^|\s)fusion-flex-align-items-\S+/g ) || [] ).join( ' ' );
					} );

					$theEl.find( '.fusion-builder-row' ).addClass( 'fusion-flex-align-items-' + value );

					return {
						render: false
					};
				case 'flex_justify_content':
					$theEl.find( '.fusion-builder-row' ).removeClass( function ( index, className ) {
						return ( className.match( /(^|\s)fusion-flex-justify-content-\S+/g ) || [] ).join( ' ' );
					} );

					$theEl.find( '.fusion-builder-row' ).addClass( 'fusion-flex-justify-content-' + value );

					return {
						render: false
					};
				case 'align_content':
					$theEl.removeClass( function ( index, className ) {
						return ( className.match( /(^|\s)fusion-flex-align-content-\S+/g ) || [] ).join( ' ' );
					} );

					$theEl.find( '.fusion-builder-row' ).removeClass( function ( index, className ) {
						return ( className.match( /(^|\s)fusion-flex-align-content-\S+/g ) || [] ).join( ' ' );
					} );

					if ( 'stretch' !== value ) {
						$theEl.find( '.fusion-builder-row' ).addClass( 'fusion-flex-align-content-' + value );
						$theEl.addClass( 'fusion-flex-align-content-' + value );
					}

					return {
						render: false
					};
				}
		},

		/**
		 * Updates column flex attributes.
		 *
		 * @param  {String} name  Param name.
		 * @param  {String} value Param value.
		 * @param  {Object} args  Args defined.
		 * @param  {Object} view  Element view.
		 * @return {Object}
		 */
		fusion_update_flex_column: function( name, value, args, view ) {
			var $theEl = view.$el;

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			switch ( name ) {
				case 'align_self':

					$theEl.removeClass( function ( index, className ) {
						return ( className.match( /(^|\s)fusion-flex-align-self-\S+/g ) || [] ).join( ' ' );
					} );

					if ( 'auto' !== value ) {
						$theEl.addClass( 'fusion-flex-align-self-' + value );
					}

					return {
						render: false
					};

				case 'content_wrap':

					$theEl.find( '.fusion-column-wrapper' ).removeClass( 'fusion-content-nowrap' );

					if ( 'wrap' !== value ) {
						$theEl.find( '.fusion-column-wrapper' ).addClass( 'fusion-content-nowrap' );
					}

					return {
						render: false
					};

				case 'align_content':

					$theEl.find( '.fusion-column-wrapper' ).eq( 0 ).removeClass( function ( index, className ) {
						return ( className.match( /(^|\s)fusion-flex-justify-content-\S+/g ) || [] ).join( ' ' );
					} );
					$theEl.find( '.fusion-column-wrapper' ).eq( 0 ).addClass( 'fusion-flex-justify-content-' + value );

					return {
						render: false
					};
				}
		},

		/**
		 * Updates menu transition class.
		 *
		 * @param  {String} name  Param name.
		 * @param  {String} value Param value.
		 * @param  {Object} args  Args defined.
		 * @param  {Object} view  Element view.
		 * @return {Object}
		 */
		fusion_update_menu_transition: function( name, value, args, view ) {
			var oldValue  = view.model.get( 'params' )[ name ],
				queryData = view.model.get( 'query_data' ),
				searchRegex;

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			// Replace class in actual HTML.
			view.$el.find( '.transition-' + oldValue ).removeClass( 'transition-' + oldValue ).addClass( 'transition-' + value );

			// Replace class in the stored markup in case they change another option.
			if ( 'undefined' !== typeof queryData && 'undefined' !== typeof queryData.menu_markup ) {
				searchRegex = new RegExp( 'transition-' + oldValue, 'g' );
				queryData.menu_markup = queryData.menu_markup.replace( searchRegex, 'transition-' + value );
				view.model.set( 'query_data', queryData );
			}

			return {
				render: false
			};
		},

		/**
		 * Updates box shadow.
		 *
		 * @param  {String} name  Param name.
		 * @param  {String} value Param value.
		 * @param  {Object} args  Args defined.
		 * @param  {Object} view  Element view.
		 * @return {Object}
		 */
		fusion_update_box_shadow: function( name, value, args, view ) {
			var $theEl = view.$el;

			if ( ! args.skip ) {
				view.changeParam( name, value );
			}

			$theEl = ( 'undefined' === typeof args.selector ) ? view.$el : view.$el.find( args.selector );

			$theEl[ 0 ].style.removeProperty( 'box-shadow' );

			if ( 'yes' === view.model.attributes.params.box_shadow ) {
				$theEl[ 0 ].style.setProperty( 'box-shadow', _.fusionGetBoxShadowStyle( view.model.attributes.params ).replace( ';', '' ), 'important' );
			}

			return {
				render: false
			};

		},

		acf_get_field: function( args, image ) {
			if ( 'undefined' === typeof args.field || '' === args.field ) {
				return '';
			}

			return jQuery.ajax( {
				url: fusionAppConfig.ajaxurl,
				type: 'post',
				dataType: 'json',
				data: {
					action: 'ajax_acf_get_field',
					field: args.field,
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					post_id: FusionApp.data.postDetails.post_id,
					image: 'undefined' !== typeof image ? image : false,
					cid: false
				}
			} )
			.done( function( response ) {
				FusionPageBuilderApp.dynamicValues.setValue( args, response.content );
			} );
		},

		acf_get_image_field: function( args ) {
			return this.acf_get_field( args, true );
		}
	} );
}( jQuery ) );
;/* global FusionPageBuilderApp, FusionPageBuilderViewManager, fusionAppConfig, FusionEvents, FusionPageBuilderElements, fusionGlobalManager */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	FusionPageBuilder.Globals = Backbone.Model.extend( {

		/**
		 * Init.
		 *
		 * @since 2.0.0
		 * @param {Object} data - The data.
		 * @return {void}
		 */
		initialize: function( ) { // eslint-disable-line no-empty-function
		},

		/**
		 * Handles multiple global elements.
		 *
		 * @since 2.0.0
		 * @param {Object} args - The Arguments.
		 * @param {Object} args.currentModel - The current model on which method is called.
		 * @param {Object} data.attributes - The changed attributes of a model.
		 * @param {string} data.handleType - The action type.
		 * @param {string} data.Name - The changed attribute param name.
		 * @param {string} data.Value - The changed attribute param value.
		 * @return {void}
		 */
		handleMultiGlobal: function( args ) {
			var globalID,
				globalCount,
				currentCID,
				currentView;

			// Handle multiple global elements.
			if ( 'undefined' !== typeof args.currentModel.attributes.params && 'undefined' !== typeof args.currentModel.attributes.params.fusion_global ) {
				globalID         = args.currentModel.attributes.params.fusion_global;
				globalCount      = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '[fusion-global-layout="' + globalID + '"]' ).length;
				currentCID       = args.currentModel.get( 'cid' );
				currentView      = FusionPageBuilderViewManager.getView( currentCID );

				if ( 1 < globalCount ) {
					jQuery.each( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '[fusion-global-layout="' + globalID + '"]' ), function() {
						var modelCID,
							view,
							model,
							originalParams,
							originalMarkup,
							oldContent;

						if ( currentCID !== jQuery( this ).data( 'cid' ) ) {
							modelCID = jQuery( this ).data( 'cid' );
							view     = FusionPageBuilderViewManager.getView( modelCID );

							model    = FusionPageBuilderElements.find( function( scopedModel ) {
								return scopedModel.get( 'cid' ) == modelCID; // jshint ignore: line
							} );

							if ( 'close' === args.handleType ) {
								originalParams = jQuery.extend( true, {}, args.currentModel.get( 'params' ) );
								originalMarkup = jQuery.extend( true, {}, args.currentModel.get( 'markup' ) );

								// Restore original params / cancel changes
								model.set( 'params', originalParams );

								// Restore original markup.
								model.set( 'markup', originalMarkup );

								// Reload element view
								if ( 'undefined' !== typeof view && 'undefined' !== typeof view.reRender ) {
									view.reRender();
								}
							} else if ( 'save' === args.handleType ) {
								model.set( args.attributes );
								model.set( 'cid', modelCID );
								fusionGlobalManager.updateGlobalLayout( globalID, currentView.getContent() );

								if ( 'undefined' !== typeof view && 'undefined' !== typeof view.reRender ) {
									view.reRender();
								}
							} else if ( 'changeView' === args.handleType ) {
								view.beforePatch();
								oldContent = view.getElementContent();
								FusionPageBuilderApp._diffdom.apply( oldContent[ 0 ], args.difference );
								view.afterPatch();
							} else if ( 'changeOption' === args.handleType ) {
								model.attributes.params[ args.Name ] = args.Value;
								if ( 'undefined' !== typeof view && 'undefined' !== typeof view.reRender ) {
									view.reRender();
								}
							}
						}
					} );
				}
			} else if ( 'undefined' !== typeof args.currentModel.attributes.parent && 'changeView' !== args.handleType ) {

				// Check for parent globals.
				setTimeout( fusionGlobalManager.handleGlobalParents, 500, args );
			}
		},

		/**
		 * Handles multiple parent global elements.
		 *
 		 * @since 2.0.0
 		 * @param {Object} args - The Arguments.
 		 * @param {Object} args.currentModel - The current model on which method is called.
 		 * @param {Object} data.attributes - The changed attributes of a model.
 		 * @param {string} data.handleType - The action type.
 		 * @param {string} data.Name - The changed attribute param name.
 		 * @param {string} data.Value - The changed attribute param value.
 		 * @return {void}
 		 */
		handleGlobalParents: function( args ) {

			var mainContainer = jQuery( '#fb-preview' )[ 0 ].contentWindow,
				parentCID     = args.currentModel.attributes.parent,
				parentView    = FusionPageBuilderViewManager.getView( parentCID ),
				currentView   = {},
				parentModel   = {},
				module;

			module = FusionPageBuilderElements.find( function( model ) {
				return model.get( 'cid' ) == parentCID; // jshint ignore: line
			} );

			if ( 'undefined' === typeof module ) {
				return;
			}

			if ( 'undefined' !== typeof module.attributes.params && 'undefined' !== typeof module.attributes.params.fusion_global && 1 < mainContainer.jQuery( '[fusion-global-layout="' + module.attributes.params.fusion_global + '"]' ).length ) {
				jQuery.each( mainContainer.jQuery( '[fusion-global-layout="' + module.attributes.params.fusion_global + '"]' ), function() {
					var currentCID;

					if ( parentCID !== jQuery( this ).data( 'cid' ) ) {
						currentCID  = jQuery( this ).data( 'cid' );
						currentView = FusionPageBuilderViewManager.getView( currentCID );

						if ( 'undefined' !== typeof module.get( 'multi' ) && 'multi_element_parent' === module.get( 'multi' ) ) {
							fusionGlobalManager.updateMultiElementParent();
						}

						if ( 'undefined' !== typeof module.get( 'element_type' ) && ( 'fusion_builder_column' === module.get( 'element_type' ) || 'fusion_builder_row_inner' === module.get( 'element_type' ) || 'fusion_builder_container' === module.get( 'element_type' ) ) ) {
							fusionGlobalManager.removeChildElements( mainContainer, currentCID, module.get( 'element_type' ) );
						}

						if ( 'undefined' !== typeof module.get( 'element_type' ) && 'fusion_builder_column' === module.get( 'element_type' ) ) {
							fusionGlobalManager.updateColumnElements( parentView.$el, currentCID );
						}

						if ( 'undefined' !== typeof module.get( 'element_type' ) && 'fusion_builder_row_inner' === module.get( 'element_type' ) ) {
							fusionGlobalManager.updateNestedColumnElements( parentView.$el, currentView );
						}
						if ( 'undefined' !== typeof module.get( 'element_type' ) && 'fusion_builder_container' === module.get( 'element_type' ) ) {
							fusionGlobalManager.updateContainerElements( parentView.$el, currentView );
						}
					}
				} );

				if ( 'save' === args.handleType ) {
					fusionGlobalManager.updateGlobalLayout( module.attributes.params.fusion_global, currentView.getContent() );
				}
			}

			if ( 'undefined' !== typeof module.attributes.params && 'undefined' !== typeof module.attributes.parent ) {
				parentModel = FusionPageBuilderElements.find( function( model ) {
					return model.get( 'cid' ) == parentCID; // jshint ignore: line
				} );
				args.currentModel = parentModel;
				fusionGlobalManager.handleGlobalParents( args );
			}
		},

		/**
		 * Updates element_content of model and then generates child elements.
		 *
		 * @since 2.0.0
		 * @param {Object} currentModel - The current model on which method is called.
		 * @param {Object} module - The changed model.
		 * @param {Object} currentView - View obj of current element.
		 * @return {void}
		 */
		updateMultiElementParent: function( currentModel, module, currentView  ) {
			currentModel.attributes.params.element_content = module.attributes.params.element_content;
			currentView.generateChildElements();
		},

		/**
		 * Removes child elements from nested column, column and container.
		 *
		 * @since 2.0.0
		 * @param {Object} mainContainer - The reference to main frame container.
		 * @param {string} currentCID - The unique CID of current model.
		 * @return {void}
		 */
		removeChildElements: function( mainContainer, currentCID, elementType  ) {
			var findString = ( 'fusion_builder_container' === elementType ) ? '.fusion-builder-remove, .fusion-builder-column-remove' : '.fusion-builder-remove';

			// Remove child elements.
			jQuery.each( mainContainer.jQuery( '[data-cid="' + currentCID + '"] .fusion-builder-module-controls' ), function() {
				jQuery( this ).find( findString ).trigger( 'click', [ 'automated' ] );
			} );
		},

		/**
		 * Updates column elements.
		 *
		 * @since 2.0.0
		 * @param {Object} thisColumn - The reference to current column.
		 * @param {string} currentCID - The unique CID of current model.
		 * @return {void}
		 */
		updateColumnElements: function( thisColumn, currentCID ) {
			var container = {},
				currentModel = {};
			thisColumn.find( '.fusion-builder-live-element:not(.fusion-builder-column-inner .fusion-builder-live-element), .fusion-builder-nested-element' ).each( function() {
				var $thisModule,
					moduleCID,
					elementModule,
					elementAttributes,
					$thisInnerRow,
					innerRowCID,
					innerRowView;

				// Standard element
				if ( jQuery( this ).hasClass( 'fusion-builder-live-element' ) ) {
					$thisModule = jQuery( this );
					moduleCID = 'undefined' === typeof $thisModule.data( 'cid' ) ? $thisModule.find( '.fusion-builder-data-cid' ).data( 'cid' ) : $thisModule.data( 'cid' );

					// Get model from collection by cid
					elementModule = FusionPageBuilderElements.find( function( model ) {
						return model.get( 'cid' ) == moduleCID; // jshint ignore: line
					} );

					// Clone model attritubes
					elementAttributes         = jQuery.extend( true, {}, elementModule.attributes );

					elementAttributes.created = 'manually';
					elementAttributes.cid     = FusionPageBuilderViewManager.generateCid();
					elementAttributes.parent  = currentCID;
					elementAttributes.from    = 'fusion_builder_column';

					// Don't need target element, position is defined from order.
					delete elementAttributes.targetElementPosition;

					FusionPageBuilderApp.collection.add( elementAttributes );

				// Inner row/nested element
				} else if ( jQuery( this ).hasClass( 'fusion_builder_row_inner' ) ) {
					$thisInnerRow = jQuery( this );
					innerRowCID = 'undefined' === typeof $thisInnerRow.data( 'cid' ) ? $thisInnerRow.find( '.fusion-builder-data-cid' ).data( 'cid' ) : $thisInnerRow.data( 'cid' );

					innerRowView = FusionPageBuilderViewManager.getView( innerRowCID );

					// Clone inner row
					if ( 'undefined' !== typeof innerRowView ) {
						innerRowView.cloneNestedRow( '', currentCID );
					}
				}

			} );

			currentModel = FusionPageBuilderElements.find( function( model ) {
				return model.get( 'cid' ) == currentCID; // jshint ignore: line
			} );

			container = FusionPageBuilderViewManager.getView( currentModel.get( 'parent' ) );

			container.createVirtualRows();
			container.updateColumnsPreview();

			FusionEvents.trigger( 'fusion-content-changed' );
		},

		/**
		 * Updates nested column elements.
		 *
		 * @since 2.0.0
		 * @param {Object} thisColumnInner - The reference to current nested column.
		 * @param {string} currentCID - The unique CID of current model.
		 * @return {void}
		 */
		updateNestedColumnElements: function( thisColumnInner, currentView ) {
			thisColumnInner.find( '.fusion-builder-live-element' ).each( function() {
				var innerElementAttributes = {};
				var thisModule = jQuery( this ),
					moduleCID  = 'undefined' === typeof thisModule.data( 'cid' ) ? thisModule.find( '.fusion-builder-data-cid' ).data( 'cid' ) : thisModule.data( 'cid' ),

					// Get model from collection by cid
					innerModule = FusionPageBuilderElements.find( function( model ) {
						return model.get( 'cid' ) == moduleCID; // jshint ignore: line
					} );

				// Clone model attritubes
				innerElementAttributes = jQuery.extend( true, {}, innerModule.attributes );

				innerElementAttributes.created = 'manually';
				innerElementAttributes.cid     = FusionPageBuilderViewManager.generateCid();
				innerElementAttributes.parent  = currentView.$el.find( '.fusion-builder-column-inner' ).data( 'cid' );
				innerElementAttributes.from    = 'fusion_builder_row_inner';

				// Don't need target element, position is defined from order.
				delete innerElementAttributes.targetElementPosition;

				FusionPageBuilderApp.collection.add( innerElementAttributes );
			} );
		},

		/**
		 * Updates container elements.
		 *
		 * @since 2.0.0
		 * @param {Object} thisContainer - The reference to current container.
		 * @param {Object} currentView - View obj of current element.
		 * @return {void}
		 */
		updateContainerElements: function( thisContainer, currentView ) {
			thisContainer.find( '.fusion-builder-column-outer' ).each( function() {

				// Parse column elements
				var thisColumn = jQuery( this ),
					$columnCID = thisColumn.data( 'cid' ),

					// Get model from collection by cid
					column = FusionPageBuilderElements.find( function( model ) {
						return model.get( 'cid' ) == $columnCID; // jshint ignore: line
					} ),

					// Clone column
					columnAttributes = jQuery.extend( true, {}, column.attributes );

				columnAttributes.created = 'manually';
				columnAttributes.cid     = FusionPageBuilderViewManager.generateCid();
				columnAttributes.parent  = currentView.$el.find( '.fusion-builder-row-container' ).data( 'cid' );
				columnAttributes.from    = 'fusion_builder_container';
				columnAttributes.cloned  = true;

				FusionPageBuilderApp.collection.add( columnAttributes );

				// Find column elements
				thisColumn.find( '.fusion-builder-column-content:not( .fusion-nested-column-content )' ).children( '.fusion-builder-live-element, .fusion_builder_row_inner' ).each( function() {

					var thisElement,
						elementCID,
						element,
						elementAttributes,
						thisInnerRow,
						InnerRowCID,
						innerRowView;

					// Regular element
					if ( jQuery( this ).hasClass( 'fusion-builder-live-element' ) ) {

						thisElement = jQuery( this );
						elementCID = thisElement.data( 'cid' );

						// Get model from collection by cid
						element = FusionPageBuilderElements.find( function( model ) {
							return model.get( 'cid' ) == elementCID; // jshint ignore: line
						} );

						// Clone model attritubes
						elementAttributes = jQuery.extend( true, {}, element.attributes );
						elementAttributes.created = 'manually';
						elementAttributes.cid = FusionPageBuilderViewManager.generateCid();
						elementAttributes.parent = columnAttributes.cid;
						elementAttributes.from    = 'fusion_builder_container';

						// Don't need target element, position is defined from order.
						delete elementAttributes.targetElementPosition;

						FusionPageBuilderApp.collection.add( elementAttributes );

						// Inner row element
					} else if ( jQuery( this ).hasClass( 'fusion_builder_row_inner' ) ) {

						thisInnerRow = jQuery( this );
						InnerRowCID = thisInnerRow.data( 'cid' );

						innerRowView = FusionPageBuilderViewManager.getView( InnerRowCID );

						// Clone inner row
						if ( 'undefined' !== typeof innerRowView ) {
							innerRowView.cloneNestedRow( '', columnAttributes.cid );
						}
					}
				} );
			} );
		},

		/**
		 * Update global layout in the DB.
		 *
		 * @since 2.0.0
		 * @param {string} layoutID - The ID of current layout.
		 * @param {string} shortcode - The short-code of current layout.
		 * @return {void}
		 */
		updateGlobalLayout: function( layoutID, shortcode ) {

			// Update layout in DB.
			jQuery.ajax( {
				type: 'POST',
				url: fusionAppConfig.ajaxurl,
				dataType: 'json',
				data: {
					action: 'fusion_builder_update_layout',
					fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
					fusion_layout_id: layoutID,
					fusion_layout_content: shortcode
				},
				complete: function() {

					// Do Stuff.
				}
			} );
		},

		/**
		 * Handle globals which are added from library.
		 *
		 * @since 2.0.0
		 * @param {string} layoutID - The ID of global element.
		 * @return {void}
		 */
		handleGlobalsFromLibrary: function( layoutID, parentID ) {

			var currentCID     = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '[data-cid="' + parentID + '"] [fusion-global-layout="' + layoutID + '"]' ).last().data( 'cid' ),
				module         =  {},
				MultiGlobalArgs = {};

			if ( 'undefined' === typeof currentCID ) {
				currentCID = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '[fusion-global-layout="' + layoutID + '"]' ).last().data( 'cid' );
			}

			module = FusionPageBuilderElements.find( function( model ) {
				return model.get( 'cid' ) == currentCID; // jshint ignore: line
			} );

			if ( 'undefined' !== typeof module ) {
				MultiGlobalArgs = {
					currentModel: module,
					handleType: 'save',
					attributes: module.attributes
				};
				fusionGlobalManager.handleMultiGlobal( MultiGlobalArgs );
			}

		}
	} );
}( jQuery ) );
;/* global FusionPageBuilderApp, FusionPageBuilderElements */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	FusionPageBuilder.DraggableHelpers = Backbone.Model.extend( {

		/**
		 * Init.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		initialize: function() {}, // eslint-disable-line no-empty-function

		/**
		 * Get dragable classes.
		 *
		 * @since 2.0.0
		 * @param {string} cid - ID of model.
		 * @return {string}
		 */
		draggableClasses: function( cid ) {
			var $element, $classes, $values, $parentCID, $parentElement;

			$element = FusionPageBuilderElements.find( function( model ) {
				return model.get( 'cid' ) == cid; // jshint ignore: line
			} );

			$values  = _.fusionCleanParameters( jQuery.extend( true, {}, $element.get( 'params' ) ) );
			$parentCID  = $element.get( 'parent' );

			switch ( $element.get( 'type' ) ) {

			case 'fusion_builder_container':

				if ( 'undefined' !== typeof $values.fusion_global ) {
					$classes = ' container-global-helper';
				}

				if ( 'yes' === $values.hundred_percent_height_scroll && 'yes' === $values.hundred_percent_height ) {
					$classes = ' container-scrolling-helper';
				}
				break;

			case 'fusion_builder_column':

				if ( FusionPageBuilderApp.DraggableHelpers.isHeightScroll( $parentCID ) ) {
					$classes = ' column-scrolling-helper';
				}

				if ( 'undefined' !== typeof $values.fusion_global || FusionPageBuilderApp.DraggableHelpers.isGlobalParent( $parentCID ) ) {
					$classes = ' column-global-helper';
				}
				break;

			case 'fusion_builder_row_inner':

				$classes = ' row-inner-nested-helper';
				if ( FusionPageBuilderApp.DraggableHelpers.isHeightScroll( $parentCID ) ) {
					$classes = ' row-inner-scrolling-helper';
				}

				if ( 'undefined' !== typeof $values.fusion_global || FusionPageBuilderApp.DraggableHelpers.isGlobalParent( $parentCID ) ) {
					$classes = ' row-inner-global-helper';
				}
				break;

			case 'fusion_builder_column_inner':

				$classes = ' column-inner-nested-helper';
				if ( FusionPageBuilderApp.DraggableHelpers.isHeightScroll( $parentCID ) ) {
					$classes = ' column-inner-scrolling-helper';
				}

				if ( 'undefined' !== typeof $values.fusion_global || FusionPageBuilderApp.DraggableHelpers.isGlobalParent( $parentCID ) ) {
					$classes = ' column-inner-global-helper';
				}
				break;

			case 'element':
				$parentElement = FusionPageBuilderElements.find( function( model ) {
					return model.get( 'cid' ) == $parentCID; // jshint ignore: line
				} );

				if ( 'fusion_builder_column_inner' === $parentElement.get( 'type' ) ) {
					$classes = ' element-nested-helper';
				}

				if ( FusionPageBuilderApp.DraggableHelpers.isHeightScroll( $parentCID ) ) {
					$classes = ' element-scrolling-helper';
				}

				if ( 'undefined' !== typeof $values.fusion_global || FusionPageBuilderApp.DraggableHelpers.isGlobalParent( $parentCID ) ) {
					$classes = ' element-global-helper';
				}
				break;
			}

			return $classes;
		},

		/**
		 * Check if element has got global parent.
		 *
		 * @since 2.0.0
		 * @param {string} cid - The ID of parent model.
		 * @return {boolean}
		 */
		isGlobalParent: function( parentCID ) {
			var $element, $values;

			$element = FusionPageBuilderElements.find( function( model ) {
				return model.get( 'cid' ) == parentCID; // jshint ignore: line
			} );

			if ( 'undefined' === typeof $element ) {
				return false;
			}

			$values  = _.fusionCleanParameters( jQuery.extend( true, {}, $element.get( 'params' ) ) );

			if ( 'undefined' !== typeof $values.fusion_global ) {
				return true;
			}

			if ( 'undefined' !== typeof $element.get( 'parent' ) ) {
				return FusionPageBuilderApp.DraggableHelpers.isGlobalParent( $element.get( 'parent' ) );
			}
			return false;
		},

		/**
		 * Check if element is inside 100% scrolling height.
		 *
		 * @since 2.0.0
		 * @param {string} cid - The ID of parent model.
		 * @return {boolean}
		 */
		isHeightScroll: function( parentCID ) {
			var $element, $values;

			$element = FusionPageBuilderElements.find( function( model ) {
				return model.get( 'cid' ) == parentCID; // jshint ignore: line
			} );

			if ( 'undefined' === typeof $element ) {
				return false;
			}

			$values  = _.fusionCleanParameters( jQuery.extend( true, {}, $element.get( 'params' ) ) );

			if ( 'fusion_builder_container' === $element.get( 'type' ) && 'yes' === $values.hundred_percent_height_scroll && 'yes' === $values.hundred_percent_height ) {
				return true;
			}

			if ( 'undefined' !== typeof $element.get( 'parent' ) ) {
				return FusionPageBuilderApp.DraggableHelpers.isHeightScroll( $element.get( 'parent' ) );
			}
			return false;
		}
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	FusionPageBuilder.IsotopeManager = Backbone.Model.extend( {
		defaults: {
			selector: '',
			container: '',
			itemSelector: '',
			layoutMode: 'packery',
			isOriginLeft: jQuery( 'body.rtl' ).length ? false : true,
			resizable: true,
			initLayout: true,
			view: false
		},

		initialize: function() {
			this.listenTo( window.FusionEvents, 'fusion-frame-size-changed', this.updateLayout );
			this.listenTo( window.FusionEvents, 'fusion-column-resized', this.updateLayout );
		},

		init: function() {
			var self      = this,
				container = self.get( 'view' ).$el.find( self.get( 'selector' ) );

			self.set( 'container', container );

			if ( ! container.data( 'isotope' ) ) {
				container.isotope( {
					layoutMode: self.get( 'layoutMode' ),
					itemSelector: self.get( 'itemSelector' ),
					isOriginLeft: jQuery( 'body.rtl' ).length ? false : true,
					resizable: true,
					initLayout: true
				} );
			}
		},

		reInit: function( delay ) {
			var self = this;

			if ( 'undefined' === typeof delay ) {
				delay = 300;
			}

			self.destroyIsotope();

			setTimeout( function() {
				self.init();
			}, delay );
		},

		destroyIsotope: function() {
			if ( '' !== this.get( 'container' ) && this.get( 'container' ).data( 'isotope' ) ) {
				this.get( 'container' ).isotope( 'destroy' );
				this.get( 'container' ).removeData( 'isotope' );
			}
		},

		append: function( content ) {
			if ( '' !== this.get( 'container' ) && this.get( 'container' ).data( 'isotope' ) ) {
				this.get( 'container' ).isotope( 'appended', content ).isotope( 'layout' );
			}
		},

		remove: function( content ) {
			if ( '' !== this.get( 'container' ) && this.get( 'container' ).data( 'isotope' ) ) {
				this.get( 'container' ).isotope( 'remove', content ).isotope( 'layout' );
			}
		},

		reloadItems: function() {
			if ( '' !== this.get( 'container' ) && this.get( 'container' ).data( 'isotope' ) ) {
				this.get( 'container' ).isotope( 'reloadItems' ).isotope( 'layout' );
			}
		},

		updateLayout: function() {
			if ( '' !== this.get( 'container' ) && this.get( 'container' ).data( 'isotope' ) ) {
				this.get( 'container' ).isotope( 'layout' );
			}
		}

	} );
}( jQuery ) );
;/* global FusionApp, fusionAllElements, FusionPageBuilderViewManager, FusionPageBuilderElements, FusionEvents, fusionMultiElements, FusionPageBuilderApp, fusionBuilderText, diffDOM, tinyMCE, fusionGetPercentPaddingHorizontalNegativeMargin, fusionGetPercentPaddingHorizontalNegativeMarginIfSiteWidthPercent, fusionTriggerEvent, fusionVendorShortcodes, fusionSanitize */
/* eslint no-useless-escape: 0 */
/* eslint no-shadow: 0 */
/* eslint max-depth: 0 */
/* eslint no-unused-vars: 0 */
/* eslint guard-for-in: 0 */
/* eslint no-continue: 0 */
/* eslint no-bitwise: 0 */
/* eslint no-mixed-operators: 0 */
/* eslint no-empty-function: 0 */

var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	var fusionElements          = [],
		fusionGeneratorElements = [],
		fusionComponents        = [],
		fusionFormComponents    = [],
		sortedElements;

	jQuery.fn.outerHTML = function() {
		return ( ! this.length ) ? this : ( this[ 0 ].outerHTML || ( function( el ) {
			var div = document.createElement( 'div' ),
				contents;

			div.appendChild( el.cloneNode( true ) );
			contents = div.innerHTML;
			div = null;
			return contents;
		}( this[ 0 ] ) ) );
	};

	// Loop over all available elements and add them to Avada Builder.
	sortedElements = _.sortBy( fusionAllElements, function( element ) {
		return element.name.toLowerCase();
	} );

	_.each( sortedElements, function( element ) {
		var newElement,
			targetObject = fusionGeneratorElements;

		if ( 'undefined' === typeof element.hide_from_builder ) {

			newElement = {
				title: element.name,
				label: element.shortcode
			};

			if ( 'undefined' !== typeof element.component && element.component ) {
				targetObject = fusionComponents;
			}
			if ( 'undefined' === typeof element.generator_only && 'undefined' === typeof element.form_component ) {
				fusionElements.push( newElement );
			}

			if ( ( 'undefined' !== typeof element.form_component && element.form_component ) || ( 'undefined' !== typeof element.allow_in_form && element.allow_in_form ) ) {
				fusionFormComponents.push( newElement );
				return;
			}

			targetObject.push(
				Object.assign(
					{},
					newElement,
					{
						generator_only: 'undefined' !== typeof element.generator_only ? true : element.generator_only,
						templates: 'undefined' !== typeof element.templates ? element.templates : false,
						components_per_template: 'undefined' !== typeof element.components_per_template ? element.components_per_template : false
					}
				)
			);
		}
	} );

	window.FusionPageBuilderViewManager = jQuery.extend( true, {}, new FusionPageBuilder.ViewManager() );

	// Avada Builder App View
	FusionPageBuilder.AppView = Backbone.View.extend( {

		model: FusionPageBuilder.Element,

		collection: FusionPageBuilderElements,

		elements: {
			modules: fusionElements,
			generator_elements: fusionGeneratorElements,
			components: fusionComponents,
			componentsCounter: 0,
			usedComponents: [],
			form_components: fusionFormComponents
		},

		events: {
			contextmenu: 'contextMenu'
		},

		template: FusionPageBuilder.template( jQuery( '#fusion-builder-front-end-template' ).html() ),

		/**
		 * Init.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		initialize: function() {
			this.extraShortcodes     = new FusionPageBuilder.ExtraShortcodes();
			this.inlineEditors       = new FusionPageBuilder.InlineEditorManager();
			this.inlineEditorHelpers = new FusionPageBuilder.InlineEditorHelpers();
			this.DraggableHelpers    = new FusionPageBuilder.DraggableHelpers();
			this.SettingsHelpers     = new FusionPageBuilder.SettingsHelpers();
			this.wireframe           = new FusionPageBuilder.Wireframe();
			this.dynamicValues       = new FusionPageBuilder.DynamicValues();
			this.formStyles          = false;

			// Post contents
			this.postContent = false;

			// Post Id
			this.postID = false;

			// Listen for new elements
			this.listenTo( this.collection, 'add', this.addBuilderElement );

			// Listen for data update
			this.listenTo( FusionEvents, 'fusion-data-updated', this.updateData );

			// Listen for preview toggle.
			this.listenTo( FusionEvents, 'fusion-preview-toggle', this.previewToggle );
			this.previewMode = false;

			// Listen for preview update to set some global styles.
			this.listenTo( FusionEvents, 'fusion-preview-update', this.setGlobalStyles );

			// Listen for wireframe mode toggle click.
			this.listenTo( FusionEvents, 'fusion-wireframe-toggle', this.wireFrameToggled );

			// Listen for frame resizes and sets helper class for CSS.
			this.listenTo( FusionEvents, 'fusion-preview-resize', this.setStackedContentClass );
			this.listenTo( FusionEvents, 'fusion-to-content_break_point-changed', this.setStackedContentClass );

			// Listen for header_position option change.
			this.listenTo( FusionEvents, 'fusion-to-header_position-changed', this.reInitScrollingSections );

			this.listenTo( window.FusionEvents, 'fusion-preferences-droppables_visible-updated', this.toggleDroppablesVisibility );
			this.listenTo( window.FusionEvents, 'fusion-preferences-sticky_header-updated', this.toggleStickyHeader );
			this.listenTo( window.FusionEvents, 'fusion-preferences-tooltips-updated', this.toggleTooltips );
			this.listenTo( window.FusionEvents, 'fusion-preferences-element_filters-updated', this.toggleElementFilters );
			this.listenTo( window.FusionEvents, 'fusion-preferences-transparent_header-updated', this.toggleTransparentHeader );

			// Listen to the fusion-content-changed event and re-trigger sticky header resize.
			this.listenTo( FusionEvents, 'fusion-content-changed', function() {
				fusionTriggerEvent( 'fusion-resize-stickyheader' );
			} );

			this.listenTo( FusionEvents, 'fusion-builder-loaded', this.fusionLibraryUI );

			// Base64 encode/decode.
			this._keyStr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';

			// Make sure to delay ajax requests to prevent duplicates.
			this._fusion_do_shortcode = _.debounce( _.bind( FusionApp.callback.fusion_do_shortcode, this ), 300 );

			// Debounced event for wireframe mode.
			this._wireframeToggle = _.debounce( _.bind( this.wireframeToggle, this ), 200 );

			this.blankPage = false;

			this.render();

			this.reRenderElements = false;

			this.contextMenuView = false;
			this.clipboard = {};

			// Stored latest shortcode content to avoid unnecessary ajax.
			this.lastAjaxCid         = false;
			this.ajaxContentRequests = [];

			// DiffDOM
			this._diffdom = new diffDOM( { valueDiffing: false } );

			jQuery( jQuery( '#fb-preview' )[ 0 ].contentWindow ).on( 'resize', function() {
				FusionEvents.trigger( 'fusion-preview-resize' );
			} );

			jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).on( 'click', function( event ) {
				FusionPageBuilderApp.sizesHide( event );
			} );

			this.correctTooltipPosition();

			this.loaded            = false;
			this.shortcodeAjax     = false;

			this.inlineElements = [ 'fusion_highlight', 'fusion_tooltip', 'fusion_dropcap', 'fusion_popover', 'fusion_one_page_text_link', 'fusion_modal_text_link' ];

			this.documentWrite        = false;
			this.previewDocumentWrite = false;

			this.wireframeActive      = false;

			this.viewsToRerender  = [];

			this.listenTo( FusionEvents, 'fusion-data-updated', this.resetRenderVariable );
		},

		resetRenderVariable: function() {
			this.reRenderElements = false;
		},

		/**
		 * Gets callback function for option change.
		 *
		 * @since 2.0.0
		 * @param {Object} modelData - The model data.
		 * @param {string} paramName - Parameter name.
		 * @param {mixed} paramValue - The value of the defined parameter.
		 * @param {Object} view - The view object.
		 * @param {boolean} skip - If set to true we bypass changing the parameter in this view.
		 * @return {void}
		 */
		getCallbackFunction: function( modelData, paramName, paramValue, view, skip ) {
			var element    = fusionAllElements[ view.model.get( 'element_type' ) ],
				option     = element.params[ paramName ],
				callbackFunction,
				thisView;

			// Check if it is subfield.
			if ( 'undefined' === typeof option && 'undefined' !== typeof element.subparam_map && 'undefined' !== typeof element.subparam_map[ paramName ] ) {
				option = element.params[ element.subparam_map[ paramName ] ];
			}

			if ( 'undefined' !== typeof modelData.noTemplate && modelData.noTemplate ) {

				// No template, we need to use fusion_do_shortcode.
				callbackFunction          = {};
				callbackFunction.ajax     = true;
				callbackFunction[ 'function' ] = 'fusion_do_shortcode';
				skip                      = 'undefined' === typeof skip ? false : skip;
				thisView                  = FusionPageBuilderViewManager.getView( modelData.cid );

				if ( ! skip ) {
					thisView.changeParam( paramName, paramValue );
				}

				if ( 'undefined' !== typeof modelData.multi && false !== modelData.multi ) {

					// Parent or child element, get the parent total content.
					callbackFunction.parent  = this.getParentElementCid( modelData );
					callbackFunction.content = this.getParentElementContent( modelData, view );
				} else {

					// Regular element, just get element content.
					callbackFunction.parent  = false;
					callbackFunction.content = FusionPageBuilderApp.generateElementShortcode( thisView.$el );
				}

			} else {
				callbackFunction = this.CheckIfCallback( element, option, view.model );
			}

			return callbackFunction;
		},

		getParentElementCid: function( modelData ) {
			if ( 'multi_element_child' === modelData.multi ) {

				// Child, return parent value.
				return modelData.parent;
			}

			// Parent, return cid.
			return modelData.cid;
		},

		getParentElementContent: function( modelData, view ) {
			var parentView;

			if ( 'multi_element_child' === modelData.multi ) {

				// Child, update parent and get total content.
				parentView = FusionPageBuilderViewManager.getView( modelData.parent );
				parentView.updateElementContent();
				return parentView.getContent();
			}

			// Already on parent, get full content.
			return view.getContent();
		},

		/**
		 * Check if the element has a callback.
		 *
		 * @since 2.0.0
		 * @param {Object} element - The element.
		 * @param {Object} option - The option.
		 * @param {Object} model - The model.
		 * @return {Object|false} - Returns the callback, or false if none is defined.
		 */
		CheckIfCallback: function( element, option, model ) {

			// First check if the option has a callback
			if ( 'undefined' !== typeof option && 'undefined' !== typeof option.callback ) {
				return option.callback;
			}

			// Check if the element itself has a callback and query_data is empty.
			if ( 'undefined' !== typeof element && 'undefined' !== typeof element.callback && 'undefined' === typeof model.attributes.query_data ) {
				return element.callback;
			}
			return false;
		},

		/**
		 * Set some global styles in a style tag added to body.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		setGlobalStyles: function( id, setAll ) {
			var styles = '',
				setAllStyles = false,
				margin = 0;

			if ( 'undefined' !== typeof setAll ) {
				setAllStyles = setAll;
			} else if ( 'undefined' === typeof id ) {
				setAllStyles = true;
			}

			// Container outline and controls positioning.
			if ( 'hundredp_padding' === id || setAllStyles ) {
				margin = fusionGetPercentPaddingHorizontalNegativeMargin();
				margin = fusionGetPercentPaddingHorizontalNegativeMarginIfSiteWidthPercent( 0, margin );

				// If we are editing content nested inside a layout section, then no negative margins on containers.
				if ( 'object' === typeof FusionApp.data.template_override && 'object' === typeof FusionApp.data.template_override.content && 'fusion_tb_section' !== FusionApp.data.postDetails.post_type ) {
					margin = 0;
				}
				styles += 'body:not(.has-sidebar) .width-100 .fusion-builder-container:before,';
				styles += 'body:not(.has-sidebar) .width-100 .fusion-builder-container:after,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container:hover > .fusion-builder-module-controls-container-wrapper,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-container-spacing.fusion-container-margin-top,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-container-spacing.fusion-container-margin-bottom,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-container-spacing.fusion-container-padding-top,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-container-spacing.fusion-container-padding-bottom,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-container-spacing.fusion-container-padding-right';
				styles += '{margin-left:' + margin + ';margin-right:' + margin + '}';

				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-container-spacing.fusion-container-padding-left{margin-left:' + margin + ';}';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-container-spacing.fusion-container-padding-right{margin-right:' + margin + ';}';


				// Flex
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-flex-container .fusion-container-spacing.fusion-container-padding-left{margin-left:0;}';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-flex-container .fusion-container-spacing.fusion-container-padding-right{margin-right:0;}';

				styles += 'body:not(.has-sidebar) .width-100 .fusion-builder-container:before,';
				styles += 'body:not(.has-sidebar) .width-100 .fusion-builder-container:after,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container:hover > .fusion-builder-module-controls-container-wrapper,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-flex-container .fusion-container-spacing.fusion-container-margin-top,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-flex-container .fusion-container-spacing.fusion-container-margin-bottom,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-flex-container .fusion-container-spacing.fusion-container-padding-top,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-flex-container .fusion-container-spacing.fusion-container-padding-bottom,';
				styles += '.fusion-builder-live .width-100 .fusion-builder-container .fusion-flex-container .fusion-container-spacing.fusion-container-padding-right';
				styles += '{margin-left:' + 0 + ';margin-right:' + 0 + '}';
			}

			if ( styles ) {
				if ( ! this.$el.children( 'style' ).length ) {
					this.$el.prepend( '<style></style>' );
				}

				this.$el.children( 'style' ).html( styles );
			}
		},

		/**
		 * Corrects the position of tooltips that would overflow the viewport.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		correctTooltipPosition: function() {
			var self = this;

			this.$el.on( 'mouseenter', '.fusion-builder-module-controls-type-container a, .fusion-builder-column-controls a, .fusion-builder-module-controls a, a.fusion-builder-add-element', function() {
				var anchorWidth = jQuery( this ).outerWidth(),
					tooltip = jQuery( this ).children( '.fusion-container-tooltip, .fusion-column-tooltip, .fusion-element-tooltip' ),
					tooltipWidth,
					tooltipOffset,
					tooltipOffsetLeft,
					tooltipOffsetRight,
					referenceWrapper,
					referenceWrapperOffsetLeft,
					referenceWrapperOffsetRight;

				if ( ! tooltip.length ) {
					return;
				}

				tooltip.children( '.fusion-tooltip-text' ).removeAttr( 'style' );

				tooltipWidth                = tooltip.outerWidth();
				tooltipOffset               = tooltip.offset();
				tooltipOffsetLeft           = tooltipOffset.left;
				tooltipOffsetRight          = tooltipOffsetLeft + tooltipWidth;
				referenceWrapperOffsetLeft  = 0;
				referenceWrapperOffsetRight = self.$el.width();

				jQuery( this ).closest( '.fusion-fullwidth:not(.video-background) .fusion-row' ).css( 'z-index', 'auto' );
				jQuery( this ).closest( '.fusion-fullwidth:not(.video-background)' ).children( '.fullwidth-faded' ).css( 'z-index', 'auto' );

				if ( ! jQuery( this ).closest( '.fusion-element-alignment-left' ).length && ! jQuery( this ).closest( '.fusion-element-alignment-right' ).length ) {
					jQuery( this ).closest( '.fusion-builder-container' ).css( 'z-index', 'auto' );
				}

				// Carousels need different positioning.
				referenceWrapper = tooltip.closest( '.fusion-carousel-wrapper' );
				if ( referenceWrapper.length ) {
					referenceWrapperOffsetLeft  = referenceWrapper.offset().left;
					referenceWrapperOffsetRight = referenceWrapperOffsetLeft + referenceWrapper.outerWidth();
				}

				if ( tooltipOffsetLeft < referenceWrapperOffsetLeft ) {
					tooltip.children( '.fusion-tooltip-text' ).css( 'margin-left', ( ( tooltipWidth / 2 ) + anchorWidth ) + 'px' );
				} else if ( tooltipOffsetRight > referenceWrapperOffsetRight ) {
					tooltip.children( '.fusion-tooltip-text' ).css( 'margin-left', 'calc(' + anchorWidth + 'px - ' + tooltipWidth + 'px)' );
				}

				if ( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).length ) {
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#main' ).css( 'z-index', 'auto' );

					if ( 'fixed' === jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).css( 'position' ) ) {
						jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).css( 'z-index', '-1' );

						if ( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#sliders-container' ).find( '.tfs-slider[data-parallax="1"]' ).length ) {
							jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#sliders-container' ).css( 'z-index', 'auto' );
						}
					}

				}
			} );

			this.$el.on( 'mouseleave', '.fusion-builder-module-controls-container a', function() {
				var parentElement = jQuery( this ).closest( '.fusion-builder-module-controls-container' ).parent( '.fusion-builder-live-element' );

				if ( ! parentElement.length || ! parentElement.find( '.fusion-modal.in' ).length ) {
					jQuery( this ).closest( '.fusion-row' ).css( 'z-index', '' );
					jQuery( this ).closest( '.fusion-builder-container' ).css( 'z-index', '' );
				}
				if ( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).length ) {
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#main' ).css( 'z-index', '' );
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).css( 'z-index', '' );
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#sliders-container' ).css( 'z-index', '' );
				}
			} );
		},

		/**
		 * Renders the view.
		 *
		 * @since 2.0.0
		 * @return {Object} this
		 */
		render: function() {
			this.$el.find( '.fusion-builder-live-editor' ).html( this.template() );

			// Make sure context menu is available.
			this.delegateEvents();

			this.setStackedContentClass();

			return this;
		},

		/**
		 * Store shortcode data.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		updateData: function() {
			var self = this;

			this.elements.components.forEach( function( component, index ) {
				var re = new RegExp( '\\[' + component.label, 'g' );

				if ( 'string' === typeof FusionApp.data.template_category && ( 'object' !== typeof component.templates || component.templates.includes( FusionApp.data.template_category ) ) ) {
					self.elements.componentsCounter++;
				}
			} );

			this.extraShortcodes.addData( FusionApp.data.shortcodeMap );
			this.dynamicValues.addData( FusionApp.initialData.dynamicValues, FusionApp.data.dynamicOptions );
		},

		convertGalleryElement: function( content ) {
			var regExp      = window.wp.shortcode.regexp( 'fusion_gallery' ),
				innerRegExp = this.regExpShortcode( 'fusion_gallery' ),
				matches     = content.match( regExp ),
				newContent  = content,
				fetchIds    = [];

			_.each( matches, function( shortcode ) {
				var shortcodeElement    = shortcode.match( innerRegExp ),
					shortcodeAttributes = '' !== shortcodeElement[ 3 ] ? window.wp.shortcode.attrs( shortcodeElement[ 3 ] ) : '',
					children     = '',
					newShortcode = '',
					ids;

				// Check for the old format shortcode
				if ( 'undefined' !== typeof shortcodeAttributes.named.image_ids ) {
					ids = shortcodeAttributes.named.image_ids.split( ',' );

					// Add new children shortcodes
					_.each( ids, function( id ) {
						children += '[fusion_gallery_image image="" image_id="' + id + '" /]';
						fetchIds.push( id );
					} );

					// Add children shortcodes, remove image_ids attribute.
					newShortcode = shortcode.replace( '/]', ']' + children + '[/fusion_gallery]' ).replace( 'image_ids="' + shortcodeAttributes.named.image_ids + '" ', '' );

					// Replace the old shortcode with the new one
					newContent = newContent.replace( shortcode, newShortcode );
				}
			} );

			// Fetch attachment data
			wp.media.query( { post__in: fetchIds, posts_per_page: fetchIds.length } ).more();

			return newContent;
		},

		/**
		 * Converts the shortcodes to builder elements.
		 *
		 * @since 2.0.0
		 * @param {string} content - The content.
		 * @return {void}
		 */
		createBuilderLayout: function( content ) {
			var self = this;

			if ( FusionApp.data.is_fusion_element ) {
				content = self.validateLibraryContent( content );
			}

			content = this.convertGalleryElement( content );

			this.shortcodesToBuilder( content );

			this.builderToShortcodes();

			setTimeout( function() {
				self.scrollingContainers();
				self.maybeFormStyles();
			}, 100 );
		},

		/**
		 * Validate library content.
		 *
		 * @since 2.0.0
		 * @param {string} content - The content.
		 * @return {string}
		 */
		validateLibraryContent: function( content ) {
			var contentIsEmpty = '' === content,
				openContainer  = '[fusion_builder_container hundred_percent="no" equal_height_columns="no" menu_anchor="" hide_on_mobile="small-visibility,medium-visibility,large-visibility" class="" id="" background_color="" background_image="" background_position="center center" background_repeat="no-repeat" fade="no" background_parallax="none" parallax_speed="0.3" video_mp4="" video_webm="" video_ogv="" video_url="" video_aspect_ratio="16:9" video_loop="yes" video_mute="yes" overlay_color="" overlay_opacity="0.5" video_preview_image="" border_size="" border_color="" border_style="solid" padding_top="" padding_bottom="" padding_left="" padding_right=""][fusion_builder_row]',
				closeContainer = '[/fusion_builder_row][/fusion_builder_container]',
				openColumn     = '[fusion_builder_column type="1_1" background_position="left top" background_color="" border_size="" border_color="" border_style="solid" border_position="all" spacing="yes" background_image="" background_repeat="no-repeat" padding="" margin_top="0px" margin_bottom="0px" class="" id="" animation_type="" animation_speed="0.3" animation_direction="left" hide_on_mobile="small-visibility,medium-visibility,large-visibility" center_content="no" last="no" min_height="" hover_type="none" link=""]',
				closeColumn    = '[/fusion_builder_column]';

			if ( ! contentIsEmpty ) {
				// Editing element
				if ( 'elements' === FusionApp.data.fusion_element_type ) {
					content = openContainer + openColumn + content + closeColumn + closeContainer;
				} else if ( 'columns' === FusionApp.data.fusion_element_type ) {
					content = openContainer + content + closeContainer;
				}
			}

			// If library element is blank
			if ( '' === content && 'elements' === FusionApp.data.fusion_element_type ) {
				content = openContainer + openColumn + closeColumn + closeContainer;
			}

			function replaceDollars() {
				return '$$';
			}

			content = content.replace( /&#36;&#36;/g, replaceDollars );

			return content;
		},

		/**
		 * Convert library content to shortcodes.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		libraryBuilderToShortcodes: function() {
			var shortcode = '',
				cid,
				view,
				element;

			// Editing an element.
			if ( 'elements' === FusionApp.data.fusion_element_type ) {
				// Inner row.
				element = this.$el.find( '.fusion-builder-column-outer .fusion_builder_row_inner' );

				if ( element.length ) {
					cid       = element.data( 'cid' );
					view      = FusionPageBuilderViewManager.getView( cid );
					shortcode = view.getInnerRowContent();

				// Regular element.
				} else if ( this.$el.find( '.fusion-builder-live-element' ).length ) {
					element = this.$el.find( '.fusion-builder-live-element' );
					shortcode = FusionPageBuilderApp.generateElementShortcode( this.$el.find( '.fusion-builder-live-element' ), false );
				}
				if ( element.length ) {
					this.$el.find( '.fusion-builder-column .fusion-builder-add-element' ).hide();
				}

			// Editing a column.
			} else if ( 'columns' === FusionApp.data.fusion_element_type ) {
				element = this.$el.find( '.fusion-builder-column-outer' );

				if ( element.length ) {
					cid       = element.data( 'cid' );
					view      = FusionPageBuilderViewManager.getView( cid );
					shortcode = view.getColumnContent();
				}

			// Editing a container.
			} else if ( 'sections' === FusionApp.data.fusion_element_type ) {
				element = this.$el.find( '.fusion-builder-container' );

				if ( element.length ) {
					cid       = element.data( 'cid' );
					view      = FusionPageBuilderViewManager.getView( cid );
					shortcode = view.getContent();
				}
			}

			FusionApp.setPost( 'post_content', shortcode );
		},

		/**
		 * Build the initial layout for the builder.
		 *
		 * @since 2.0.0
		 * @param {Object} data - The data.
		 * @param {Object} data.fusionGlobalManager - The FusionPageBuilder.Global object.
		 * @param {string} data.postContent - The post-content.
		 * @return {void}
		 */
		initialBuilderLayout: function( data ) {
			var self = this;

			// Clear all views
			FusionPageBuilderViewManager.removeViews();

			console.log( data ); // jshint ignore: line

			this.postContent = data.postDetails.post_content;
			this.postID      = data.postDetails.post_id;

			// Add data for exta shortcodes.
			self.updateData( data );

			setTimeout( function() {

				var content            = self.postContent,
					contentErrorMarkup = '',
					contentErrorTitle  = '',
					moreDetails        = fusionBuilderText.unknown_error_link;

				try {
					self.setGlobalStyles( '', true );

					content = self.convertGalleryElement( content );

					if ( ! FusionApp.data.is_fusion_element ) {
						content = self.validateContent( content );
					} else {
						content = self.validateLibraryContent( content );
					}

					self.shortcodesToBuilder( content );

					// Add data for exta shortcodes.
					self.updateData( data );

					setTimeout( function() {
						self.scrollingContainers();
						self.reRenderElements = true;
						self.maybeFormStyles();

						if ( 0 < FusionPageBuilderViewManager.countElementsByType( 'fusion_builder_next_page' ) ) {
							FusionEvents.trigger( 'fusion-next-page' );
						}

						self.loaded = true;
						FusionEvents.trigger( 'fusion-builder-loaded' );

					}, 100 );

				} catch ( error ) {
					console.log( error ); // jshint ignore:line

					if ( 'undefined' !== error.name && 'ContentException' === error.name ) {
						contentErrorTitle  = fusionBuilderText.content_error_title;
						contentErrorMarkup = jQuery( '<div>' + fusionBuilderText.content_error_description + '</div>' );
					} else {
						contentErrorTitle  = fusionBuilderText.unknown_error_title;

						// If we have full stack use that rather than external link.
						if ( 'string' === typeof error.stack ) {
							moreDetails = '<a href="#" class="copy-full-description">' + fusionBuilderText.unknown_error_copy + '</a>';
						}
						contentErrorMarkup = jQuery( '<div>' + error + '<p>' + moreDetails + '</p></div>' );
					}

					contentErrorMarkup.dialog( {
						title: '<span class="icon type-warning"><i class="fusiona-exclamation" aria-hidden="true"></i></span>' + contentErrorTitle,
						dialogClass: 'fusion-builder-dialog fusion-builder-error-dialog fusion-builder-settings-dialog',
						autoOpen: true,
						modal: true,
						width: 400,
						open: function() {
							if ( jQuery( this ).find( '.copy-full-description' ).length ) {
								jQuery( this ).find( '.copy-full-description' ).on( 'click', function( event ) {
									var $temp     = jQuery( '<textarea>' ),
										errorText = '';

									if ( 'string' === typeof error.message ) {
										errorText += error.message + '\n';
									}

									if ( 'string' === typeof error.stack ) {
										errorText += error.stack;
									}
									event.preventDefault();

									jQuery( this ).after( $temp );
									$temp.val( errorText ).focus().select();
									document.execCommand( 'copy' );
									$temp.remove();

									jQuery( this ).html( '<i class="fusiona-check" aria-hidden="true"></i> ' + fusionBuilderText.unknown_error_copied );
								} );
							}
						},
						close: function() {} // eslint-disable-line no-empty-function
					} );

					// Remove all views.
					self.fusionBuilderReset();
				}

			}, 50 );

			// TODO - are the checks here necessary?  I don't see any data.fusionGlobalManager.
			window.fusionGlobalManager = 'undefined' !== typeof data.fusionGlobalManager && false !== data.fusionGlobalManager ? data.fusionGlobalManager : new FusionPageBuilder.Globals( ); // jshint ignore: line
		},

		FBException: function( message, name ) {
			this.message = message;
			this.name = name;
		},

		validateContent: function( content ) {
			var contentIsEmpty = '' === content,
				textNodes      = '',
				columns        = [],
				containers     = [],
				shortcodeTags,
				columnwrapped,
				insertionFlag;

			// Content clean up.
			content = content.replace( /\r?\n/g, '\r\n' );
			content = content.replace( /<p>\[/g, '[' );
			content = content.replace( /\]<\/p>/g, ']' );
			if ( 'undefined' !== typeof content ) {
				content = content.trim();
			}

			// Throw exception with the fullwidth shortcode.
			if ( -1 !== content.indexOf( '[fullwidth' ) ) {
				throw new this.FBException( 'Avada 4.0.3 or earlier fullwidth container used!', 'ContentException' );
			}

			if ( ! contentIsEmpty ) {

				// Fixes [fusion_text /] instances, which were created in 5.0.1 for empty text blocks.
				content = content.replace( /\[fusion\_text \/\]/g, '[fusion_text][/fusion_text]' ).replace(  /\[\/fusion\_text\]\[\/fusion\_text\]/g, '[/fusion_text]' );

				content = content.replace( /\$\$/g, '&#36;&#36;' );
				textNodes = content;

				// Add container if missing.
				textNodes = wp.shortcode.replace( 'fusion_builder_container', textNodes, function() {
					return '@|@';
				} );
				textNodes = wp.shortcode.replace( 'fusion_builder_next_page', textNodes, function() {
					return '@|@';
				} );
				textNodes = textNodes.trim().split( '@|@' );

				_.each( textNodes, function( textNodes ) {
					if ( '' !== textNodes.trim() ) {
						content = content.replace( textNodes, '[fusion_builder_container hundred_percent="no" equal_height_columns="no" menu_anchor="" hide_on_mobile="small-visibility,medium-visibility,large-visibility" class="" id="" background_color="" background_image="" background_position="center center" background_repeat="no-repeat" fade="no" background_parallax="none" parallax_speed="0.3" video_mp4="" video_webm="" video_ogv="" video_url="" video_aspect_ratio="16:9" video_loop="yes" video_mute="yes" overlay_color="" overlay_opacity="0.5" video_preview_image="" border_size="" border_color="" border_style="solid" padding_top="" padding_bottom="" padding_left="" padding_right=""][fusion_builder_row]' + textNodes + '[/fusion_builder_row][/fusion_builder_container]' );
					}
				} );

				textNodes = wp.shortcode.replace( 'fusion_builder_container', content, function( tag ) {
					containers.push( tag.content );
				} );

				_.each( containers, function( textNodes ) {

					// Add column if missing.
					textNodes = wp.shortcode.replace( 'fusion_builder_row', textNodes, function( tag ) {
						return tag.content;
					} );

					textNodes = wp.shortcode.replace( 'fusion_builder_column', textNodes, function() {
						return '@|@';
					} );

					textNodes = textNodes.trim().split( '@|@' );
					_.each( textNodes, function( textNodes ) {
						if ( '' !== textNodes.trim() && '[fusion_builder_row][/fusion_builder_row]' !== textNodes.trim() ) {
							columnwrapped = '[fusion_builder_column type="1_1" background_position="left top" background_color="" border_size="" border_color="" border_style="solid" border_position="all" spacing="yes" background_image="" background_repeat="no-repeat" padding="" margin_top="0px" margin_bottom="0px" class="" id="" animation_type="" animation_speed="0.3" animation_direction="left" hide_on_mobile="small-visibility,medium-visibility,large-visibility" center_content="no" last="no" min_height="" hover_type="none" link=""]' + textNodes + '[/fusion_builder_column]';
							content = content.replace( textNodes, columnwrapped );

						}
					} );
				} );

				textNodes = wp.shortcode.replace( 'fusion_builder_column_inner', content, function( tag ) {
					columns.push( tag.content );
				} );
				textNodes = wp.shortcode.replace( 'fusion_builder_column', content, function( tag ) {
					columns.push( tag.content );
				} );
				_.each( columns, function( textNodes ) {

					// Wrap non fusion elements.
					shortcodeTags = fusionAllElements;
					_.each( shortcodeTags, function( shortcode ) {
						if ( 'undefined' === typeof shortcode.generator_only ) {
							textNodes = wp.shortcode.replace( shortcode.shortcode, textNodes, function() {
								return '@|@';
							} );
						}
					} );

					textNodes = textNodes.trim().split( '@|@' );
					_.each( textNodes, function( textNodes ) {
						if ( '' !== textNodes.trim() ) {
							insertionFlag = '@=%~@';
							if ( '@' === textNodes.slice( -1 ) ) {
								insertionFlag = '#=%~#';
							}
							content = content.replace( textNodes, '[fusion_text]' + textNodes.slice( 0, -1 ) + insertionFlag + textNodes.slice( -1 ) + '[/fusion_text]' );
						}
					} );
				} );
				content = content.replace( /@=%~@/g, '' ).replace( /#=%~#/g, '' );

				// Check for once deactivated elements in text blocks that are active again.
				content = wp.shortcode.replace( 'fusion_text', content, function( tag ) {
					shortcodeTags = fusionAllElements;
					textNodes = tag.content;
					_.each( shortcodeTags, function( shortcode ) {
						if ( 'undefined' === typeof shortcode.generator_only ) {
							textNodes = wp.shortcode.replace( shortcode.shortcode, textNodes, function() {
								return '|';
							} );
						}
					} );
					if ( ! textNodes.replace( /\|/g, '' ).length ) {
						return tag.content;
					}
				} );
			}

			function replaceDollars() {
				return '$$';
			}

			content = content.replace( /&#36;&#36;/g, replaceDollars );

			return content;
		},

		/**
		 * Regex for shortcodes
		 *
		 * @since 2.0.0
		 * @param {string} tag - The element.
		 * @returns {mixed}
		 */
		regExpShortcode: _.memoize( function( tag ) {
			return new RegExp( '\\[(\\[?)(' + tag + ')(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*(?:\\[(?!\\/\\2\\])[^\\[]*)*)(\\[\\/\\2\\]))?)(\\]?)' );
		} ),

		findShortcodeMatches: function( content, match ) {

			var shortcodeMatches,
				shortcodeRegExp;

			if ( _.isObject( content ) ) {
				content = content.value;
			}

			shortcodeMatches     = '';
			content              = 'undefined' !== typeof content ? content : '';
			shortcodeRegExp      = window.wp.shortcode.regexp( match );

			if ( 'undefined' !== typeof content && '' !== content ) {
				shortcodeMatches = content.match( shortcodeRegExp );
			}

			return shortcodeMatches;
		},

		/**
		 * Reset the builder.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		fusionBuilderReset: function() {

			// Clear all models and views
			FusionPageBuilderElements.reset( {} );
			this.collection.reset( {} );
			FusionPageBuilderViewManager.clear();

			// Clear layout
			this.$el.find( '#fusion_builder_container' ).html( '' );

			FusionEvents.trigger( 'fusion-builder-reset' );

		},

		/**
		 * Clears the layout.
		 *
		 * @since 2.0.0
		 * @param {Object} event - The jQuery event.
		 * @return {void}
		 */
		clearLayout: function( event ) {
			if ( event ) {
				event.preventDefault();
			}

			if ( '[fusion_builder_blank_page][/fusion_builder_blank_page]' !== this.postContent ) {
				this.blankPage = true;
				this.clearBuilderLayout( true );
			}
		},

		/**
		 * Trigger context menu.
		 *
		 * @since 2.0.0
		 * @param {Object} event - The jQuery event.
		 * @return {void}
		 */
		contextMenu: function( event ) {
			var self          = this,
				$clickTarget  = jQuery( event.target ),
				$target       = $clickTarget.closest( '[data-cid]' ),
				inlineElement = $clickTarget.hasClass( 'fusion-disable-editing' ) || $clickTarget.parents( '.fusion-disable-editing' ).length,
				shortcodeId,
				view,
				viewSettings,
				model,
				elementType;

			// Remove any existing.
			this.removeContextMenu();

			// Disable on blank template element.
			if ( $clickTarget.hasClass( 'fusion-builder-blank-page' ) || $clickTarget.parents( '.fusion-builder-blank-page' ).length ) {
				return;
			}

			// Disable on row.
			if ( $clickTarget.hasClass( 'fusion-builder-row-container' ) ) {
				$clickTarget = $clickTarget.closest( '.fusion-builder-container:not( .fusion-builder-row-container )' );
				$target      = $clickTarget;
			}

			// Disable context menu if right clicking on text block.
			if ( ! $target.length || ( 'fusion_text' === $target.data( 'type' ) && ! this.wireframeActive && ! $clickTarget.parents( '.fusion-builder-module-controls-container' ).length && ! inlineElement ) ) {
				return;
			}

			// If we are not editing nested columns element, but clicking on a child, only use the nested columns element.
			if ( ! jQuery( 'body' ).hasClass( 'nested-ui-active' ) && ! this.$el.hasClass( 'fusion-builder-nested-cols-dialog-open' ) && $clickTarget.closest( '.fusion_builder_row_inner' ).length ) {
				$target = $clickTarget.closest( '.fusion_builder_row_inner' );
			}


			view = FusionPageBuilderViewManager.getView( $target.data( 'cid' ) );

			elementType = this.getElementType( view.model.attributes.element_type );

			switch ( FusionApp.data.fusion_element_type ) {

				case 'elements':
					if ( 'child_element' !== elementType && 'parent_element' !== elementType && 'element' !== elementType ) {
						return;
					}

					break;

				case 'columns':
					if ( 'fusion_builder_container' === elementType ) {
						return;
					}

					break;
			}

			if ( ! inlineElement ) {

				// This is not an inline element, things are simple.
				event.preventDefault();

				viewSettings = {
					model: {
						parent: view.model,
						event: event,
						parentView: view
					}
				};

				this.contextMenuView = new FusionPageBuilder.ContextMenuView( viewSettings );

			} else {

				// This is an inline element, so we have to create the data and so checks.
				$target     = $clickTarget.hasClass( 'fusion-disable-editing' ) ? $clickTarget : $clickTarget.parents( '.fusion-disable-editing' ).first();

				// Disable on inline ajax shortcodes.
				if ( $target.hasClass( 'fusion-inline-ajax' ) ) {
					return;
				}

				shortcodeId = $target.data( 'id' );
				model       = view.model.inlineCollection.find( function( model ) {
					return model.get( 'cid' ) == shortcodeId; // jshint ignore: line
				} );

				if ( 'undefined' !== typeof model ) {
					event.preventDefault();

					model.event      = event;
					model.$target    = $target;
					model.parentView = view;

					viewSettings = {
						model: model
					};

					this.contextMenuView = new FusionPageBuilder.ContextMenuInlineView( viewSettings );
				}
			}

			// Check context menu is not undefined and is not false.
			if ( 'undefined' !== typeof this.contextMenuView && this.contextMenuView ) {

				// Add context menu to builder.
				this.$el.append( this.contextMenuView.render().el );

				// Add listener to remove.
				this.$el.one( 'click', function() {
					self.removeContextMenu();
				} );
			}
		},

		/**
		 * Remove any contextMenu.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		removeContextMenu: function() {
			if ( this.contextMenuView && 'function' === typeof this.contextMenuView.removeMenu ) {
				this.contextMenuView.removeMenu();
			}
		},

		/**
		 * Shows saved elements.
		 *
		 * @since 2.0.0
		 * @param {string} elementType - The element-type.
		 * @param {Object} container - The jQuery element of the container.
		 * @return {void}
		 */
		showSavedElements: function( elementType, container ) {

			var data    = jQuery( '#fusion-builder-layouts-' + elementType ).find( '.fusion-page-layouts' ).clone(),
				spacers = '<li class="spacer fusion-builder-element"></li><li class="spacer fusion-builder-element"></li><li class="spacer fusion-builder-element"></li><li class="spacer fusion-builder-element"></li>',
				postId;

			data.find( 'li' ).each( function() {
				postId = jQuery( this ).find( '.fusion-builder-demo-button-load' ).attr( 'data-post-id' );
				jQuery( this ).find( '.fusion-layout-buttons' ).remove();
				jQuery( this ).find( 'h4' ).attr( 'class', 'fusion_module_title' );
				jQuery( this ).attr( 'data-layout_id', postId );
				jQuery( this ).addClass( 'fusion_builder_custom_' + elementType + '_load' );
				if ( '' !== jQuery( this ).attr( 'data-layout_type' ) ) {
					jQuery( this ).addClass( 'fusion-element-type-' + jQuery( this ).attr( 'data-layout_type' ) );
				}
			} );

			container.append( '<div id="fusion-loader"><span class="fusion-builder-loader"></span></div>' );
			container.append( '<ul class="fusion-builder-all-modules fusion-builder-library-list fusion-builder-library-list-' + elementType + '">' + data.html() + spacers + '</div>' );
		},

		/**
		 * Renders the content, converting all shortcodes and loading their templates.
		 *
		 * @since 2.0.0
		 * @param {string}  content - The content we want to convert & render.
		 * @param {number} cid - A Unique ID.
		 * @return {string} The content.
		 */
		renderContent: function( content, cid, parent ) {
			var shortcodes,
				self = this,
				elParent = 'undefined' === typeof parent ? false : parent,
				ajaxShortcodes = [],
				insideInlineEditor,
				hasFusionClients = false;

			parent = FusionPageBuilderViewManager.getView( cid );

			if ( parent && 'function' === typeof parent.filterRenderContent ) {
				content = parent.filterRenderContent( content );
			}

			// If no signs of a shortcode return early, avoid any unnecessary checks.
			if ( 'undefined' === typeof content ) {
				return '';
			}
			if ( -1 === content.indexOf( '[' ) ) {
				return content;
			}

			if ( 'undefined' !== typeof parent ) {
				// Reset inlines collection
				parent.model.inlineCollection.reset();

				// Check if shortcode allows generator
				insideInlineEditor = this.inlineEditorHelpers.inlineEditorAllowed( parent.model.get( 'element_type' ) );
			}

			shortcodes = this.shortcodesToBuilder( content, false, false, true );

			_.each( shortcodes, function( shortcode ) {
				var markupContent,
					newModel,
					newViewOutput;

				// Check for deprecated shortcode
				if ( 'fusion_clients' === shortcode.settings.element_type ) {
					hasFusionClients = true;
				}

				if ( -1 !== jQuery.inArray( shortcode.settings.element_type, FusionPageBuilderApp.inlineElements ) ) {

					// Create new model
					shortcode.settings.cid           = FusionPageBuilderViewManager.generateCid();
					shortcode.settings.parent        = cid;
					shortcode.settings.inlineElement = shortcode.content;
					newModel                         = new FusionPageBuilder.Element( shortcode.settings );
					parent.model.inlineCollection.add( newModel );

					newViewOutput = self.inlineEditorHelpers.getInlineElementMarkup( newModel );

					if ( insideInlineEditor ) {
						content = content.replace( shortcode.content, '<span class="fusion-disable-editing fusion-inline-element" contenteditable="false" data-id="' + shortcode.settings.cid + '">' + newViewOutput + '</span>' );
					} else {
						content = content.replace( shortcode.content, newViewOutput );
					}

				} else {
					markupContent = FusionPageBuilderApp.extraShortcodes.byShortcode( shortcode.content );

					if ( 'undefined' === typeof markupContent ) {
						ajaxShortcodes.push( shortcode.content );
					} else if ( insideInlineEditor ) {
						content = content.replace( shortcode.content, self.inlineEditorHelpers.getInlineHTML( markupContent.output, markupContent.id ) );
					} else {
						content = content.replace( shortcode.content, markupContent.output );
					}
				}

			} );

			if ( ajaxShortcodes.length ) {
				content = self.ajaxRenderShortcode( cid, content, elParent, ajaxShortcodes );
			}

			content = FusionApp.removeScripts( content, cid );

			setTimeout( function() {
				FusionApp.injectScripts( cid );

				if ( hasFusionClients ) {
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-element-render-fusion_images', cid );
				}
			}, 200 );

			if ( 'undefined' !== content ) {
				return content;
			}
			return '<div id="fusion-loader"><span class="fusion-builder-loader"></span></div>';
		},

		ajaxRenderShortcode: function( cid, content, elParent, ajaxShortcodes ) {
			var model, modelcid, markup;

			// If content is identical to another request we do not want to loop ajax.
			if ( -1 !== this.ajaxContentRequests.indexOf( content ) ) {
				modelcid = 'undefined' !== typeof elParent && elParent ? elParent : cid;
				model    = FusionPageBuilderElements.find( function( model ) {
					return model.get( 'cid' ) == modelcid; // jshint ignore: line
				} );
				markup  = 'undefined' !== typeof model ? model.get( 'markup' ) : false;

				// Collect views that need to be re-rendered
				this.viewsToRerender.push( cid );

				// Check for model markup being set.
				if ( markup ) {
					return markup.output;
				}

				// Just return unchanged.
				return content;
			}

			// If cid is the same debounce, otherwise do not.
			if ( cid === this.lastAjaxCid ) {
				this._fusion_do_shortcode( cid, content, elParent, ajaxShortcodes );
			} else {
				FusionApp.callback.fusion_do_shortcode( cid, content, elParent, ajaxShortcodes );
			}

			this.ajaxContentRequests.push( content );
			this.lastAjaxCid = cid;
		},

		addPlaceholder: function( content, output ) {
			var atts,
				notice;

			// Add placeholder if no option is selected.
			if ( -1 !== content.indexOf( 'rev_slider' ) ) {
				atts = content.match( /\[rev_slider .*?alias\=\"(.*?)\".*?\]/ );
				notice = fusionBuilderText.slider_placeholder;
			} else if ( -1 !== content.indexOf( 'layerslider' ) ) {
				atts = content.match( /\[layerslider .*?id\=\"(.*?)\".*?\]/ );
				notice = fusionBuilderText.slider_placeholder;
			} else if ( -1 !== content.indexOf( 'contact-form-7' ) ) {
				atts = content.match( /\[contact-form-7 .*?id\=\"(.*?)\".*?\]/ );
				notice = fusionBuilderText.form_placeholder;
			} else if ( -1 !== content.indexOf( 'gravityform' ) ) {
				atts = content.match( /\[gravityform .*?id\=\"(.*?)\".*?\]/ );
				notice = fusionBuilderText.form_placeholder;
			}

			if ( 'undefined' !== typeof atts && atts && ( '0' === atts[ 1 ] || '' === atts[ 1 ] ) ) {
				output    = '<div class="fusion-builder-placeholder">' + notice + '</div>';
			}

			return output;
		},

		/**
		 * Get the shortcode structure from HTML.
		 *
		 * @since 2.0.0
		 * @param {string}  content - The content we want to convert & render.
		 * @param {number} cid - A Unique ID.
		 * @return {string} The content.
		 */
		htmlToShortcode: function( content, cid ) { // jshint ignore:line
			var $content = jQuery( '<div>' + content + '</div>' ),
				self = this;

			$content.find( '.fusion-disable-editing' ).each( function() {
				var shortcodeId = jQuery( this ).data( 'id' ),
					shortcodeContent,
					shortCode,
					parent,
					model;

				if ( jQuery( this ).hasClass( 'fusion-inline-ajax' ) ) {
					shortcodeContent = FusionPageBuilderApp.extraShortcodes.byId( shortcodeId );
					shortCode = shortcodeContent.shortcode;
				} else {
					parent = FusionPageBuilderViewManager.getView( cid );
					model = parent.model.inlineCollection.find( function( model ) {
						return model.get( 'cid' ) == shortcodeId; // jshint ignore: line
					} );
					shortCode = model.get( 'inlineElement' );
				}

				if ( 'undefined' === typeof shortCode ) {
					alert( 'Problem encountered. This content cannot be live edited.' ); // eslint-disable-line no-alert
				} else {
					jQuery( this ).replaceWith( shortCode );
				}
			} );

			$content.find( '[data-inline-shortcode]' ).each( function() {
				var shortcodeType    = jQuery( this ).data( 'element' ),
					shortcodeContent = jQuery( this ).html(),
					defaultParams,
					multi,
					type,
					params,
					elementSettings,
					elementModel,
					elementShortcode;

				if ( shortcodeType in fusionAllElements ) {

					defaultParams  = fusionAllElements[ shortcodeType ].params;
					multi          = fusionAllElements[ shortcodeType ].multi;
					type           = fusionAllElements[ shortcodeType ].shortcode;

				} else {
					defaultParams = '';
					multi   = '';
					type   = '';
				}

				params = {};

				// Process default parameters from shortcode
				_.each( defaultParams, function( param )  {
					params[ param.param_name ] = ( _.isObject( param.value ) ) ? param[ 'default' ] : param.value;
				} );

				// Used as a flag for opening on first render.
				params.open_settings   = 'true';

				params.element_content = shortcodeContent;

				elementSettings = {
					type: 'element',
					added: 'manually',
					element_type: type,
					params: params,
					parent: cid,
					multi: multi
				};

				elementModel = new FusionPageBuilder.Element( elementSettings );

				elementShortcode = self.generateElementShortcode( elementModel, false, true );

				jQuery( this ).replaceWith( elementShortcode );
			} );
			return $content.html();
		},

		/**
		 * Convert shortcodes for the builder.
		 *
		 * @since 2.0.0
		 * @param {string}  content - The content.
		 * @param {number} parentCID - The parent CID.
		 * @param {string}  childShortcode - The shortcode.
		 * @param {boolean} noCollection - To collect or not collect.
		 * @param {string} targetEl - If we want to add in relation to a specific element.
		 * @param {string} targetPosition - Whether we want to be before or after specific element.
		 * @return {string|null}
		 */
		shortcodesToBuilder: function( content, parentCID, childShortcode, noCollection, targetEl, targetPosition ) {
			var thisEl,
				regExp,
				innerRegExp,
				matches,
				shortcodeTags,
				renderElements = [];

			noCollection = ( 'undefined' !== typeof noCollection && true === noCollection );

			// Show blank page layout
			if ( '' === content && ! this.$el.find( '.fusion-builder-blank-page-content' ).length ) {
				this.blankPage = true;
				// TODO: add fix for new blank library element
				this.createBuilderLayout( '[fusion_builder_blank_page][/fusion_builder_blank_page]' );
				jQuery( '.fusion-builder-live' ).addClass( 'fusion-builder-blank-page-active' );

				if ( false === FusionApp.initialData.samePage && 'undefined' !== typeof FusionApp.sidebarView.openOption ) {
					FusionApp.sidebarView.openOption( 'post_title', 'po' );
				}

				return;
			}
			jQuery( '.fusion-builder-live' ).removeClass( 'fusion-builder-blank-page-active' );

			thisEl        = this;
			shortcodeTags = _.keys( fusionAllElements ).join( '|' );

			// TEMP.  Example of non FB shortcode, used for the renderContent function.
			// TODO:  Add a new function for finding shortcodes instead of hijacking shortcodesToBuilder.
			if ( noCollection && 'undefined' !== typeof fusionVendorShortcodes ) {
				shortcodeTags += '|' + _.keys( fusionVendorShortcodes ).join( '|' );
			}
			regExp      = window.wp.shortcode.regexp( shortcodeTags );
			innerRegExp = this.regExpShortcode( shortcodeTags );
			matches     = content.match( regExp );

			_.each( matches, function( shortcode ) {

				var shortcodeElement    = shortcode.match( innerRegExp ),
					shortcodeName       = shortcodeElement[ 2 ],
					shortcodeAttributes = '' !== shortcodeElement[ 3 ] ? window.wp.shortcode.attrs( shortcodeElement[ 3 ] ) : '',
					shortcodeContent    = 'undefined' !== typeof shortcodeElement[ 5 ] ? shortcodeElement[ 5 ] : '',
					elementCID          = ( ! noCollection ) ? FusionPageBuilderViewManager.generateCid() : '',
					prefixedAttributes  = { params: ( {} ) },
					elementSettings,
					key,
					prefixedKey,
					dependencyOption,
					dependencyOptionValue,
					elementContent,
					alpha,
					paging,
					markupContent,
					values,
					atIndex,
					buttonPrefix,
					textType,
					fontFamily,
					fontVariant,

					// Check for shortcodes inside shortcode content
					shortcodesInContent = 'undefined' !== typeof shortcodeContent && '' !== shortcodeContent && shortcodeContent.match( regExp ),

					// Check if shortcode allows generator
					allowGenerator = 'undefined' !== typeof fusionAllElements[ shortcodeName ] && 'undefined' !== typeof fusionAllElements[ shortcodeName ].allow_generator ? fusionAllElements[ shortcodeName ].allow_generator : '';

				elementSettings = {
					type: shortcodeName,
					element_type: shortcodeName,
					cid: elementCID,
					created: 'manually',
					multi: '',
					params: {},
					container: false,
					allow_generator: allowGenerator,
					inline_editor: thisEl.inlineEditorHelpers.inlineEditorAllowed( shortcodeName )
				};

				// Get markup from map if set.  Add further checks here so only necessary elements do this check.
				if ( -1 === shortcodeName.indexOf( 'fusion_builder_' ) ) {
					markupContent = FusionPageBuilderApp.extraShortcodes.byShortcode( shortcodeElement[ 0 ] );
					if ( 'undefined' !== typeof markupContent ) {
						elementSettings.markup = markupContent;
					} else {
						elementSettings.shortcode = shortcodeElement[ 0 ];
					}
				}
				if ( 'fusion_builder_container' === shortcodeName || 'fusion_builder_row' === shortcodeName || 'fusion_builder_row_inner' === shortcodeName || 'fusion_builder_column' === shortcodeName || 'fusion_builder_column_inner' === shortcodeName || 'fusion_builder_inline' === shortcodeName ) {
					elementSettings.container = true;
				}

				if ( 'fusion_builder_container' !== shortcodeName || 'fusion_builder_next_page' !== shortcodeName ) {
					elementSettings.parent = parentCID;
				}

				if ( 'undefined' !== typeof targetEl && targetEl ) {
					atIndex = FusionPageBuilderApp.getCollectionIndex( targetEl );

					if ( 'undefined' !== typeof targetPosition && 'before' === targetPosition ) {
						atIndex = atIndex - 1;
					}
					elementSettings.targetElement = targetEl;
					elementSettings.at_index = atIndex;
				}
				if ( 'undefined' !== typeof targetPosition && targetPosition ) {
					elementSettings.targetElementPosition = targetPosition;
				}
				if ( false === elementSettings.container && 'fusion_builder_next_page' !== shortcodeName ) {

					if ( -1 !== shortcodeName.indexOf( 'fusion_' ) ||
						-1 !== shortcodeName.indexOf( 'layerslider' ) ||
						-1 !== shortcodeName.indexOf( 'rev_slider' ) ||
						'undefined' !== typeof fusionAllElements[ shortcodeName ] ) {
						elementSettings.type = 'element';
					}
				}

				if ( 'fusion_builder_blank_page' === shortcodeName ) {
					elementSettings.type = 'fusion_builder_blank_page';
				}
				if ( _.isObject( shortcodeAttributes.named ) ) {
					for ( key in shortcodeAttributes.named ) {

						prefixedKey = key;

						prefixedAttributes.params[ prefixedKey ] = shortcodeAttributes.named[ key ];
						if ( 'fusion_products_slider' === shortcodeName && 'cat_slug' === key ) {
							prefixedAttributes.params.cat_slug = shortcodeAttributes.named[ key ].replace( /\|/g, ',' );
						}
						if ( 'gradient_colors' === key ) {
							delete prefixedAttributes.params[ prefixedKey ];
							if ( -1 !== shortcodeAttributes.named[ key ].indexOf( '|' ) ) {
								prefixedAttributes.params.button_gradient_top_color    = shortcodeAttributes.named[ key ].split( '|' )[ 0 ].replace( 'transparent', 'rgba(255,255,255,0)' );
								prefixedAttributes.params.button_gradient_bottom_color = shortcodeAttributes.named[ key ].split( '|' )[ 1 ] ? shortcodeAttributes.named[ key ].split( '|' )[ 1 ].replace( 'transparent', 'rgba(255,255,255,0)' ) : shortcodeAttributes.named[ key ].split( '|' )[ 0 ].replace( 'transparent', 'rgba(255,255,255,0)' );
							} else {
								prefixedAttributes.params.button_gradient_bottom_color = shortcodeAttributes.named[ key ].replace( 'transparent', 'rgba(255,255,255,0)' );
								prefixedAttributes.params.button_gradient_top_color    = prefixedAttributes.params.button_gradient_bottom_color;
							}
						}
						if ( 'gradient_hover_colors' === key ) {
							delete prefixedAttributes.params[ prefixedKey ];
							if ( -1 !== shortcodeAttributes.named[ key ].indexOf( '|' ) ) {
								prefixedAttributes.params.button_gradient_top_color_hover    = shortcodeAttributes.named[ key ].split( '|' )[ 0 ].replace( 'transparent', 'rgba(255,255,255,0)' );
								prefixedAttributes.params.button_gradient_bottom_color_hover = shortcodeAttributes.named[ key ].split( '|' )[ 1 ] ? shortcodeAttributes.named[ key ].split( '|' )[ 1 ].replace( 'transparent', 'rgba(255,255,255,0)' ) : shortcodeAttributes.named[ key ].split( '|' )[ 0 ].replace( 'transparent', 'rgba(255,255,255,0)' );
							} else {
								prefixedAttributes.params.button_gradient_bottom_color_hover = shortcodeAttributes.named[ key ].replace( 'transparent', 'rgba(255,255,255,0)' );
								prefixedAttributes.params.button_gradient_top_color_hover    = prefixedAttributes.params.button_gradient_bottom_color_hover;
							}
						}
						if ( 'overlay_color' === key && '' !== shortcodeAttributes.named[ key ] && 'fusion_builder_container' === shortcodeName ) {
							delete prefixedAttributes.params[ prefixedKey ];
							alpha = ( 'undefined' !== typeof shortcodeAttributes.named.overlay_opacity ) ? shortcodeAttributes.named.overlay_opacity : 1;
							prefixedAttributes.params.background_color = jQuery.Color( shortcodeAttributes.named[ key ] ).alpha( alpha ).toRgbaString();
						}
						if ( 'overlay_opacity' === key ) {
							delete prefixedAttributes.params[ prefixedKey ];
						}
						if ( 'scrolling' === key && 'fusion_blog' === shortcodeName ) {
							delete prefixedAttributes.params.paging;
							paging = ( 'undefined' !== typeof shortcodeAttributes.named.paging ) ? shortcodeAttributes.named.paging : '';
							if ( 'no' === paging && 'pagination' === shortcodeAttributes.named.scrolling ) {
								prefixedAttributes.params.scrolling = 'no';
							}
						}

						// The grid-with-text layout was removed in Avada 5.2, so layout has to
						// be converted to grid. And boxed_layout was replaced by new text_layout.
						if ( 'fusion_portfolio' === shortcodeName ) {
							if ( 'layout' === key ) {
								if ( 'grid' === shortcodeAttributes.named[ key ] && shortcodeAttributes.named.hasOwnProperty( 'boxed_text' ) ) {
									shortcodeAttributes.named.boxed_text = 'no_text';
								} else if ( 'grid-with-text' === shortcodeAttributes.named[ key ] ) {
									prefixedAttributes.params[ key ] = 'grid';
								}
							}

							if ( 'boxed_text' === key ) {
								prefixedAttributes.params.text_layout = shortcodeAttributes.named[ key ];
								delete prefixedAttributes.params[ key ];
							}

							if ( 'content_length' === key && 'full-content' === shortcodeAttributes.named[ key ] ) {
								prefixedAttributes.params[ key ] = 'full_content';
							}

						}

						// Make sure the background hover color is set to border color, if it does not exist already.
						if ( 'fusion_pricing_table' === shortcodeName ) {
							if ( 'backgroundcolor' === key && ! shortcodeAttributes.named.hasOwnProperty( 'background_color_hover' ) ) {
								prefixedAttributes.params.background_color_hover = shortcodeAttributes.named.bordercolor;
							}
						}

						if ( 'padding' === key && ( 'fusion_widget_area' === shortcodeName || 'fusion_builder_column' === shortcodeName || 'fusion_builder_column_inner' === shortcodeName ) ) {
							values = shortcodeAttributes.named[ key ].split( ' ' );

							if ( 1 === values.length ) {
								prefixedAttributes.params.padding_top = values[ 0 ];
								prefixedAttributes.params.padding_right = values[ 0 ];
								prefixedAttributes.params.padding_bottom = values[ 0 ];
								prefixedAttributes.params.padding_left = values[ 0 ];
							}

							if ( 2 === values.length ) {
								prefixedAttributes.params.padding_top = values[ 0 ];
								prefixedAttributes.params.padding_right = values[ 1 ];
								prefixedAttributes.params.padding_bottom = values[ 0 ];
								prefixedAttributes.params.padding_left = values[ 1 ];
							}

							if ( 3 === values.length ) {
								prefixedAttributes.params.padding_top = values[ 0 ];
								prefixedAttributes.params.padding_right = values[ 1 ];
								prefixedAttributes.params.padding_bottom = values[ 2 ];
								prefixedAttributes.params.padding_left = values[ 1 ];
							}

							if ( 4 === values.length ) {
								prefixedAttributes.params.padding_top = values[ 0 ];
								prefixedAttributes.params.padding_right = values[ 1 ];
								prefixedAttributes.params.padding_bottom = values[ 2 ];
								prefixedAttributes.params.padding_left = values[ 3 ];
							}

							delete prefixedAttributes.params[ key ];
						}
					}

					// Fix old values of image_width in content boxes and flip boxes and children.
					if ( 'fusion_content_boxes' === shortcodeName || 'fusion_flip_boxes' === shortcodeName ) {
						if ( 'undefined' !== typeof shortcodeAttributes.named.image_width ) {
							prefixedAttributes.params.image_max_width = shortcodeAttributes.named.image_width;
						}

						shortcodeContent = shortcodeContent.replace( /image_width/g, 'image_max_width' );
					}
					if ( 'fusion_button' === shortcodeName || 'fusion_tagline_box' === shortcodeName ) {
						buttonPrefix = 'fusion_tagline_box' === shortcodeName ? 'button_' : '';

						// Ensures backwards compatibility for button shape.
						if ( 'undefined' !== typeof shortcodeAttributes.named[ buttonPrefix + 'shape' ] ) {
							if ( 'square' === shortcodeAttributes.named[ buttonPrefix + 'shape' ] ) {
								prefixedAttributes.params[ buttonPrefix + 'border_radius' ] = '0';
							} else if ( 'round' === shortcodeAttributes.named[ buttonPrefix + 'shape' ] ) {
								prefixedAttributes.params[ buttonPrefix + 'border_radius' ] = '2';

								if ( '3d' === shortcodeAttributes.named.type ) {
									prefixedAttributes.params[ buttonPrefix + 'border_radius' ] = '4';
								}
							} else if ( 'pill' === shortcodeAttributes.named[ buttonPrefix + 'shape' ] ) {
								prefixedAttributes.params[ buttonPrefix + 'border_radius' ] = '25';
							} else if ( '' === shortcodeAttributes.named[ buttonPrefix + 'shape' ] ) {
								prefixedAttributes.params[ buttonPrefix + 'border_radius' ] = '';
							}

							delete prefixedAttributes.params[ buttonPrefix + 'shape' ];
						}
					}

					if ( 'fusion_button' === shortcodeName ) {
						// Ensures backwards compatibility for button border color.
						if ( 'undefined' === typeof shortcodeAttributes.named.border_color && 'undefined' !== typeof shortcodeAttributes.named.accent_color && '' !== shortcodeAttributes.named.accent_color ) {
							prefixedAttributes.params.border_color = shortcodeAttributes.named.accent_color;
						}

						if ( 'undefined' === typeof shortcodeAttributes.named.border_hover_color && 'undefined' !== typeof shortcodeAttributes.named.accent_hover_color && '' !== shortcodeAttributes.named.accent_hover_color ) {
							prefixedAttributes.params.border_hover_color = shortcodeAttributes.named.accent_hover_color;
						}
					}

					elementSettings = _.extend( elementSettings, prefixedAttributes );
				}

				if ( ! shortcodesInContent ) {
					elementSettings.params.element_content = shortcodeContent;
				}

				// Add contents to row element_content.  Used for working out data.
				if ( 'fusion_builder_row' === shortcodeName || 'fusion_builder_row_inner' === shortcodeName || 'fusion_builder_inline' === shortcodeName ) {
					elementSettings.element_content = shortcodeContent;
				}
				if ( 'fusion_builder_column' === shortcodeName || 'fusion_builder_column_inner' === shortcodeName ) {
					elementSettings.column_shortcode = shortcodeElement[ 0 ];
				}

				// Compare shortcode name to multi elements object / array
				if ( shortcodeName in fusionMultiElements ) {
					elementSettings.multi = 'multi_element_parent';

					thisEl.checkChildUI( shortcodeName, elementSettings );
				}

				// Set content for elements with dependency options
				if ( 'undefined' !== typeof fusionAllElements[ shortcodeName ] &&  'undefined' !== typeof fusionAllElements[ shortcodeName ].option_dependency ) {

					dependencyOption      = fusionAllElements[ shortcodeName ].option_dependency;
					dependencyOptionValue = prefixedAttributes.params[ dependencyOption ];
					elementContent        = prefixedAttributes.params.element_content;
					prefixedAttributes.params[ dependencyOptionValue ] = elementContent;
				}

				if ( shortcodesInContent ) {
					if ( false === elementSettings.container && 'fusion_builder_next_page' !== shortcodeName ) {
						elementSettings.params.element_content = shortcodeContent;
					}
				}

				// Check if child element.
				if ( 'undefined' !== typeof childShortcode && shortcodeName === childShortcode ) {
					elementSettings.multi = 'multi_element_child';

					// Checks if map has set selectors. If so needs to be set prior to render.
					if ( 'undefined' !== typeof fusionAllElements[ shortcodeName ].selectors ) {
						elementSettings.selectors = jQuery.extend( true, {}, fusionAllElements[ shortcodeName ].selectors );
					}
				}

				// Legacy checklist integration.
				if ( 'fusion_checklist' === shortcodeName && 'undefined' !== typeof elementSettings.params.element_content && -1 !== elementSettings.params.element_content.indexOf( '<li>' ) && -1 === elementSettings.params.element_content.indexOf( '[fusion_li_item' ) ) {
					elementSettings.params.element_content = elementSettings.params.element_content.replace( /<ul>/g, '' );
					elementSettings.params.element_content = elementSettings.params.element_content.replace( /<\/ul>/g, '' );
					elementSettings.params.element_content = elementSettings.params.element_content.replace( /<li>/g, '[fusion_li_item]' );
					elementSettings.params.element_content = elementSettings.params.element_content.replace( /<\/li>/, '[/fusion_li_item]' );
				}

				if ( ! noCollection ) {
					if ( 'multi_element_child' !== elementSettings.multi ) {
						thisEl.collection.add( [ elementSettings ] );
					}
				} else {
					renderElements.push( {
						content: shortcodeElement[ 0 ],
						settings: elementSettings
					} );
				}

				if ( true === FusionApp.layoutIsLoading && FusionPageBuilder.options.fusionTypographyField ) {
					textType	= 'fusion_title' === elementSettings.element_type ? 'title' : 'text';
					fontFamily	= elementSettings.params[ 'fusion_font_family_' + textType + '_font' ];
					fontVariant	= elementSettings.params[ 'fusion_font_variant_' + textType + '_font' ];

					if ( fontFamily ) {
						// If webfonts are not defined, init them and re-run this method.
						if ( ! FusionApp.assets.webfonts ) {
							jQuery.when( FusionApp.assets.getWebFonts() ).done( function() {
								FusionPageBuilder.options.fusionTypographyField.webFontLoad( fontFamily, fontVariant, false );
							} );
							return this;
						}
						FusionPageBuilder.options.fusionTypographyField.webFontLoad( fontFamily, fontVariant, false );
					}
				}

				if ( shortcodesInContent ) {

					if ( shortcodeName in fusionMultiElements ) {

						// If this is a parent element, we pass this on to make sure children are proper children for that element.
						thisEl.shortcodesToBuilder( shortcodeContent, elementCID, fusionMultiElements[ shortcodeName ] );
					} else if ( true === elementSettings.container ) {
						if ( ( 'fusion_builder_row_inner' === shortcodeName || 'fusion_builder_column_inner' === shortcodeName || 'fusion_builder_inline' === shortcodeName ) && ! elementSettings.parent ) {
							thisEl.shortcodesToBuilder( shortcodeContent, false, false, true );
						} else {
							thisEl.shortcodesToBuilder( shortcodeContent, elementCID );
						}
					}
				}

			} );
			if ( noCollection ) {
				return renderElements;
			}
		},

		/**
		 * Checks if map has set child_ui. If so child UI shows on parent element settings.
		 *
		 * @since 2.0.0
		 * @param {string} shortcodeName - Shortcode tag.
		 * @param {Object} attributes - Element model attributes.
		 * @return {void}
		 */
		checkChildUI: function( shortcodeName, attributes ) {
			if ( 'undefined' !== typeof fusionAllElements[ shortcodeName ].child_ui ) {
				attributes.child_ui = fusionAllElements[ shortcodeName ].child_ui;
			}
		},

		/**
		 * Add an element.
		 *
		 * @since 2.0.0
		 * @param {Object} element - The element we're adding.
		 * @return {void}
		 */
		addBuilderElement: function( element ) {

			var view,
				self         = this,
				viewSettings = {
					model: element,
					collection: FusionPageBuilderElements
				},
				generatedView,
				generatedViewSettings,
				parentModel;

			switch ( element.get( 'type' ) ) {

			case 'fusion_builder_blank_page':

				if ( 'undefined' !== typeof FusionApp.data.postDetails.post_type && 'fusion_form' === FusionApp.data.postDetails.post_type ) {
					viewSettings.className = 'fusion-builder-blank-page';
					view = new FusionPageBuilder.BlankFormView( viewSettings );
				} else {
					view = new FusionPageBuilder.BlankPageView( viewSettings );
				}

				FusionPageBuilderViewManager.addView( element.get( 'cid' ), view );

				if ( ! _.isUndefined( element.get( 'view' ) ) ) {
					element.get( 'view' ).$el.after( view.render().el );

				} else {
					this.$el.find( '#fusion_builder_container' ).append( view.render().el );
				}

				break;

			case 'fusion_builder_container':

				// Check custom container position
				if ( '' !== FusionPageBuilderApp.targetContainerCID ) {
					element.attributes.view = FusionPageBuilderViewManager.getView( FusionPageBuilderApp.targetContainerCID );

					FusionPageBuilderApp.targetContainerCID = '';
				}

				view = new FusionPageBuilder.ContainerView( viewSettings );

				FusionPageBuilderViewManager.addView( element.get( 'cid' ), view );

				if ( ! _.isUndefined( element.get( 'view' ) ) ) {
					if ( 'undefined' === typeof element.get( 'targetElementPosition' ) || 'after' === element.get( 'targetElementPosition' ) ) {
						element.get( 'view' ).$el.after( view.render().el );
					} else {
						element.get( 'view' ).$el.before( view.render().el );
					}

				} else {
					this.$el.find( '#fusion_builder_container' ).append( view.render().el );
					this.$el.find( '.fusion-builder-blank-page' ).remove();
				}

				break;

			case 'element':
			case 'fusion_builder_column':
			case 'fusion_builder_column_inner':
			case 'fusion_builder_row_inner':
				self.addToChildCollection( element );

				// TODO: check
				if ( 'fusion_builder_row_inner' === element.get( 'type' ) ) {
					if ( 'manually' === element.get( 'created' ) && 'row_inner' === element.get( 'element_type' ) ) {
						element.set( 'view', FusionPageBuilderViewManager.getView( element.get( 'parent' ) ), { silent: true } );
					}
				}

				break;

			case 'fusion_builder_row':

				// Get element parent
				parentModel = this.collection.find( function( model ) {
					return model.get( 'cid' ) == element.get( 'parent' ); // jshint ignore:line
				} );

				// Add child element to column's children collection
				parentModel.children.add( [ element ] );

				break;

			case 'generated_element':

				// Ignore modals for columns inserted with generator
				if ( 'fusion_builder_column_inner' !== element.get( 'element_type' ) && 'fusion_builder_column' !== element.get( 'element_type' ) ) {

					viewSettings.attributes = {
						'data-modal_view': 'element_settings'
					};

					generatedViewSettings = {
						model: element,
						collection: FusionPageBuilderElements,
						attributes: {
							'data-cid': element.get( 'cid' )
						}
					};

					if ( 'undefined' !== typeof element.get( 'multi' ) && 'multi_element_parent' === element.get( 'multi' ) ) {

						if ( 'undefined' !== typeof FusionPageBuilder[ element.get( 'element_type' ) ] ) {

							self.checkChildUI( element.get( 'element_type' ), generatedViewSettings.model.attributes );

							generatedView = new FusionPageBuilder[ element.get( 'element_type' ) ]( generatedViewSettings );

						} else {

							self.checkChildUI( element.get( 'element_type' ), generatedViewSettings.model.attributes );

							generatedView = new FusionPageBuilder.ParentElementView( generatedViewSettings );
						}

					} else if ( 'undefined' !== typeof FusionPageBuilder[ element.get( 'element_type' ) ] ) {
						generatedView = new FusionPageBuilder[ element.get( 'element_type' ) ]( generatedViewSettings );
					} else if ( 'fusion_builder_row_inner' === element.get( 'element_type' ) ) {
						generatedView = new FusionPageBuilder.InnerRowView( generatedViewSettings );
					} else {
						generatedView = new FusionPageBuilder.ElementView( generatedViewSettings );
					}

					// Add new view to manager
					FusionPageBuilderViewManager.addView( element.get( 'cid' ), generatedView );

					generatedView.render().el;

					view = fusionAllElements[ element.get( 'element_type' ) ].custom_settings_view_name;

					if ( 'undefined' !== typeof view && '' !== view ) {
						view = new FusionPageBuilder[ view ]( viewSettings );
					} else {
						view = new FusionPageBuilder.ElementSettingsView( viewSettings );
					}

					this.generateElementSettings( view );
				}

				break;

			case 'fusion_builder_next_page':
				view = new FusionPageBuilder.NextPage( viewSettings );

				FusionPageBuilderViewManager.addView( element.get( 'cid' ), view );

				if ( ! _.isUndefined( element.get( 'appendAfter' ) ) ) {

					if ( ! element.get( 'appendAfter' ).next().next().hasClass( 'fusion-builder-next-page' ) ) {
						element.get( 'appendAfter' ).after( view.render().el );
					}
				} else {
					this.$el.find( '.fusion-builder-container:last-child' ).after( view.render().el );
				}

				break;
			}

			// Unset target element if it exists.
			if ( ! _.isUndefined( element.get( 'targetElement' ) ) ) {
				element.unset( 'targetElement' );
			}
		},

		/**
		 * Add a child to it's parent collection.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		addToChildCollection: function( child ) {
			var parentModel,
				atIndex;

			if ( child instanceof Backbone.Model ) {
				parentModel = this.collection.find( function( model ) {
					return model.get( 'cid' ) == child.get( 'parent' ); // jshint ignore:line
				} );
				atIndex = child.get( 'at_index' );
				child.unset( 'at_index' );
			} else {
				parentModel = this.collection.find( function( model ) {
					return model.get( 'cid' ) == child.parent; // jshint ignore:line
				} );
				atIndex = child.at_index;
				delete child.at_index;
			}
			if ( 'new' !== atIndex && 'undefined' !== typeof atIndex && ! isNaN( atIndex ) ) {
				parentModel.children.add( [ child ], { at: atIndex } );
			} else {
				parentModel.children.add( [ child ] );
			}
		},

		/**
		 * Calculate collection index.
		 *
		 * @since 2.0.0
		 * @param {Object} element view.
		 * @return {string}
		 */
		getCollectionIndex: function( targetView ) {
			var index = 'new',
				targetModel,
				parentModel,
				targetIndex;

			if ( 'undefined' !== typeof targetView && false !== targetView ) {

				// Child element
				if ( 'undefined' !== typeof targetView.data( 'parent-cid' ) ) {
					parentModel = FusionPageBuilderApp.collection.find( function( model ) {
						return model.get( 'cid' ) === targetView.data( 'parent-cid' );
					} );

					targetModel = parentModel.children.find( function( model ) {
						return model.get( 'cid' ) === targetView.data( 'cid' );
					} );

				// Regular element
				} else {
					targetModel = FusionPageBuilderApp.collection.find( function( model ) {
						return model.get( 'cid' ) === targetView.data( 'cid' );
					} );

					if ( 'undefined' !== typeof targetModel.get( 'parent' ) && targetModel.get( 'parent' ) ) {
						parentModel = FusionPageBuilderApp.collection.find( function( model ) {
							return model.get( 'cid' ) === targetModel.get( 'parent' );
						} );
					}
				}

				if ( parentModel ) {
					targetIndex = parentModel.children.indexOf( targetModel );
					index = targetIndex + 1;
				}
			}

			return index;
		},

		onDropCollectionUpdate: function( model, index, senderCid ) {
			var parentView = FusionPageBuilderViewManager.getView( model.get( 'parent' ) ),
				senderView;

			// Remove model from the old collection
			parentView.model.children.remove( model, { silent: true } );

			// Add model to the new collection
			if ( senderCid !== model.get( 'parent' ) ) {
				model.set( 'parent', senderCid );
				senderView = FusionPageBuilderViewManager.getView( senderCid );
				senderView.model.children.add( model, { at: index, silent: true } );
			} else {
				parentView.model.children.add( model, { at: index, silent: true } );
			}
			parentView.model.children.trigger( 'sort' );
		},

		generateElementSettings: function( view ) {

			// No need to render if it already is.
			if ( ! FusionPageBuilderApp.SettingsHelpers.shouldRenderSettings( view ) ) {
				return;
			}

			// If we want dialog.
			jQuery( view.render().el ).dialog( {
				title: fusionAllElements[ view.model.get( 'element_type' ) ].name,
				width: FusionApp.dialog.dialogData.width,
				height: FusionApp.dialog.dialogData.height,
				position: FusionApp.dialog.dialogData.position,
				dialogClass: 'fusion-builder-dialog fusion-builder-settings-dialog',
				minWidth: 360,

				dragStop: function( event, ui ) {
					FusionApp.dialog.saveDialogPosition( ui.offset );
				},

				resizeStop: function( event, ui ) {
					FusionApp.dialog.saveDialogSize( ui.size );
				},

				open: function( event, ui ) { // jshint ignore: line
					var $dialogContent = jQuery( event.target ),
						$dialog        = $dialogContent.closest( '.ui-dialog' );

					if ( view.$el.find( '.has-group-options' ).length ) {
						$dialog.addClass( 'fusion-builder-group-options' );
					}
				},
				dragStart: function( event, ui ) { // jshint ignore: line

					// Used to close any open drop-downs in TinyMce.
					jQuery( event.target ).trigger( 'click' );
				},

				beforeClose: function( event, ui ) { // jshint ignore: line
					view.closeGeneratorModal();
				},

				buttons: {
					Insert: function() {
						view.insertGeneratedShortcode();
					},
					Cancel: function() {
						view.closeGeneratorModal();
					}
				}
			} );
		},

		/**
		 * Convert builder to shortcodes.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		builderToShortcodes: function() {
			var shortcode = '',
				thisEl    = this;

			if ( FusionApp.data.is_fusion_element ) {
				this.libraryBuilderToShortcodes();
			} else {
				this.$el.find( '.fusion-builder-container' ).each( function() {
					var $thisContainer = jQuery( this ).find( '.fusion-builder-container-content' );

					shortcode += thisEl.generateElementShortcode( jQuery( this ), true );

					$thisContainer.find( '.fusion_builder_row' ).each( function() {
						var $thisRow = jQuery( this );

						shortcode += '[fusion_builder_row]';

						$thisRow.find( '.fusion-builder-column-outer' ).each( function() {
							var $thisColumn = jQuery( this ),
								columnCID   = $thisColumn.data( 'cid' ),
								columnView  = FusionPageBuilderViewManager.getView( columnCID );

							shortcode += columnView.getColumnContent();
						} );
						shortcode += '[/fusion_builder_row]';
					} );

					shortcode += '[/fusion_builder_container]';

					// Check for next page shortcode
					if ( jQuery( this ).next().hasClass( 'fusion-builder-next-page' ) ) {
						shortcode += '[fusion_builder_next_page]';
					}
				} );

				FusionApp.setPost( 'post_content', shortcode );
			}
		},

		/**
		 * Generate the shortcode for an element.
		 *
		 * @since 2.0.0
		 * @param {Object}  $element - The jQuery object of the element.
		 * @param {boolean} openTagOnly - Should we only include an opening tag? Or a closing tag as well?
		 * @param {boolean} generator - Generate?
		 * @return {string}
		 */
		generateElementShortcode: function( $element, openTagOnly, generator ) {
			var attributes = '',
				content    = '',
				element,
				$thisElement,
				elementCID,
				elementType,
				elementSettings = '',
				shortcode,
				ignoredAtts,
				optionDependency,
				optionDependencyValue,
				key,
				setting,
				settingName,
				settingValue,
				param,
				keyName,
				optionValue,
				ignored,
				paramDependency,
				paramDependencyElement,
				paramDependencyValue,
				parentModel,
				parentCID,
				elementView;

			// Check if added from Shortcode Generator
			if ( true === generator ) {
				element = $element;
			} else {
				$thisElement = $element;

				// Get cid from html element
				elementCID = 'undefined' === typeof $thisElement.data( 'cid' ) ? $thisElement.find( '.fusion-builder-data-cid' ).data( 'cid' ) : $thisElement.data( 'cid' );

				if ( $thisElement.hasClass( 'fusion-builder-live-child-element' ) ) {

					parentCID = 'undefined' === typeof $thisElement.data( 'parent-cid' ) ? $thisElement.find( '.fusion-builder-data-cid' ).data( 'parent-cid' ) : $thisElement.data( 'parent-cid' );

					// Get parent model
					parentModel = FusionPageBuilderElements.find( function( model ) {
						return model.get( 'cid' ) == parentCID; // jshint ignore:line
					} );

					// Get model from parent collection
					element = parentModel.children.find( function( model ) {
						return model.get( 'cid' ) == elementCID; // jshint ignore:line
					} );

				} else {

					// Get model by cid
					element = FusionPageBuilderElements.find( function( model ) {
						return model.get( 'cid' ) == elementCID; // jshint ignore: line
					} );
				}
			}

			// Useful function can be utilized to change save data.
			elementView = FusionPageBuilderViewManager.getView( elementCID );
			if ( 'undefined' !== typeof elementView && 'function' === typeof elementView.beforeGenerateShortcode ) {
				elementView.beforeGenerateShortcode();
			}

			elementType     = 'undefined' !== typeof element ? element.get( 'element_type' ) : 'undefined';
			elementSettings = '';
			shortcode       = '';
			elementSettings = element.attributes;

			// Ignored shortcode attributes
			ignoredAtts = 'undefined' !== typeof fusionAllElements[ elementType ].remove_from_atts ? fusionAllElements[ elementType ].remove_from_atts : [];
			ignoredAtts.push( 'undefined' );

			// Option dependency
			optionDependency = 'undefined' !== typeof fusionAllElements[ elementType ].option_dependency ? fusionAllElements[ elementType ].option_dependency : '';

			if ( 'params' in elementSettings ) {
				settingName = 'params';
				settingValue = 'undefined' !== typeof element.get( settingName ) ? element.get( settingName ) : '';

				// Loop over params
				for ( param in settingValue ) {

					keyName = param;

					if ( 'element_content' === keyName ) {

						optionValue = 'undefined' !== typeof settingValue[ param ] ? settingValue[ param ] : '';

						content = optionValue;

						if ( 'undefined' !== typeof settingValue[ optionDependency ] ) {
							optionDependency = fusionAllElements[ elementType ].option_dependency;
							optionDependencyValue = 'undefined' !== typeof settingValue[ optionDependency ] ? settingValue[ optionDependency ] : '';

							// Set content
							content = 'undefined' !== typeof settingValue[ optionDependencyValue ] ? settingValue[ optionDependencyValue ] : '';
						}

					} else {

						ignored = '';

						if ( '' !== optionDependency ) {

							setting = keyName;

							// Get option dependency value ( value for type )
							optionDependencyValue = ( 'undefined' !== typeof settingValue[ optionDependency ] ) ? settingValue[ optionDependency ] : '';

							// Check for old fusion_map array structure
							if ( 'undefined' !== typeof fusionAllElements[ elementType ].params[ setting ] ) {

								// Dependency exists
								if ( 'undefined' !== typeof fusionAllElements[ elementType ].params[ setting ].dependency ) {

									paramDependency = fusionAllElements[ elementType ].params[ setting ].dependency;

									paramDependencyElement = ( 'undefined' !== typeof paramDependency.element ) ? paramDependency.element : '';

									paramDependencyValue = ( 'undefined' !== typeof paramDependency.value ) ? paramDependency.value : '';

									if ( paramDependencyElement === optionDependency ) {

										if ( paramDependencyValue !== optionDependencyValue ) {

											ignored = '';
											ignored = setting;

										}
									}
								}
							}
						}

						// Ignore shortcode attributes tagged with "remove_from_atts"
						if ( -1 < jQuery.inArray( param, ignoredAtts ) || ignored === param ) {

							// This attribute should be ignored from the shortcode

						} else {

							optionValue = 'undefined' !== typeof settingValue[ param ] ? settingValue[ param ] : '';

							// Check if attribute value is null
							if ( null === optionValue ) {
								optionValue = '';
							}

							// Sanitizes values before saving it in the shortcode.
							if ( 'undefined' !== typeof elementView && 'function' === typeof elementView.sanitizeValue ) {
								optionValue = elementView.sanitizeValue( param, optionValue );
							}

							attributes += ' ' + param + '="' + optionValue + '"';
						}
					}
				}
			}

			shortcode = '[' + elementType + attributes;

			if ( '' === content && 'fusion_text' !== elementType && 'fusion_code' !== elementType && ( 'undefined' !== typeof elementSettings.type && 'element' === elementSettings.type ) ) {
				openTagOnly = true;
				shortcode += ' /]';
			} else {
				shortcode += ']';
			}

			if ( ! openTagOnly ) {
				shortcode += content + '[/' + elementType + ']';
			}

			return shortcode;
		},

		/**
		 * Define the layout as loaded.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		layoutLoaded: function() {
			FusionEvents.trigger( 'fusion-history-clear' );
			this.reRenderElements = true;
		},

		/**
		 * Get element type, split up element.
		 *
		 * @since 2.0.0
		 * @param {string} elementType - The element type/name.
		 * @return {void}
		 */
		getElementType: function( elementType ) {
			var childElements;

			if ( 'fusion_builder_container' === elementType || 'fusion_builder_column' === elementType || 'fusion_builder_column_inner' === elementType ) {
				return elementType;
			}

			// First check if its a parent.
			if ( elementType in fusionMultiElements ) {
				return 'parent_element';
			}

			// Check if its a child.
			childElements = _.values( fusionMultiElements );
			if ( -1 !== childElements.indexOf( elementType ) ) {
				return 'child_element';
			}

			if ( 'fusion_builder_row_inner' === elementType ) {
				return 'fusion_builder_row_inner';
			}

			// Made it this far it must be regular.
			return 'element';
		},

		/**
		 * Clears the builder layout.
		 *
		 * @since 2.0.0
		 * @param {boolean} blankPageLayout - Should we use the blankPageLayout?
		 * @return {void}
		 */
		clearBuilderLayout: function( blankPageLayout ) {

			// Remove blank page layout.
			this.$el.find( '.fusion-builder-blank-page' ).each( function() {
				var $that    = jQuery( this ),
					thisView = FusionPageBuilderViewManager.getView( $that.data( 'cid' ) );

				if ( 'undefined' !== typeof thisView ) {
					thisView.removeBlankPageHelper();
				}
			} );

			// Remove all containers.
			this.$el.find( '.fusion-builder-container' ).each( function() {
				var $that    = jQuery( this ),
					thisView = FusionPageBuilderViewManager.getView( $that.data( 'cid' ) );

				if ( 'undefined' !== typeof thisView ) {
					thisView.removeContainer( false, true );
				}
			} );

			// Remove all next page elements.
			this.$el.find( '.fusion-builder-next-page' ).each( function() {
				var thisView = FusionPageBuilderViewManager.getView( jQuery( this ).data( 'cid' ) );

				if ( 'undefined' !== typeof thisView ) {
					thisView.removeNextPage();
				}
			} );

			// Create blank page layout.
			if ( blankPageLayout ) {

				if ( true === this.blankPage ) {
					if ( ! this.$el.find( '.fusion-builder-blank-page' ).length ) {
						this.createBuilderLayout( '[fusion_builder_blank_page][/fusion_builder_blank_page]' );
						jQuery( '.fusion-builder-live' ).addClass( 'fusion-builder-blank-page-active' );
					}
					this.blankPage = false;
				}
			}
		},

		/**
		 * Encodes data using Base64.
		 *
		 * @since 2.0.0
		 * @param {string} data - The data to encode.
		 * @return {string}
		 */
		base64Encode: function( data ) {
			var b64 = this._keyStr,
				o1,
				o2,
				o3,
				h1,
				h2,
				h3,
				h4,
				bits,
				i      = 0,
				ac     = 0,
				enc    = '',
				tmpArr = [],
				r;

			if ( ! data ) {
				return data;
			}

			data = unescape( encodeURIComponent( data ) );

			do {

				// Pack three octets into four hexets
				o1 = data.charCodeAt( i++ );
				o2 = data.charCodeAt( i++ );
				o3 = data.charCodeAt( i++ );

				bits = o1 << 16 | o2 << 8 | o3;

				h1 = bits >> 18 & 0x3f;
				h2 = bits >> 12 & 0x3f;
				h3 = bits >> 6 & 0x3f;
				h4 = bits & 0x3f;

				// Use hexets to index into b64, and append result to encoded string.
				tmpArr[ ac++ ] = b64.charAt( h1 ) + b64.charAt( h2 ) + b64.charAt( h3 ) + b64.charAt( h4 );
			} while ( i < data.length );

			enc = tmpArr.join( '' );
			r   = data.length % 3;

			return ( r ? enc.slice( 0, r - 3 ) : enc ) + '==='.slice( r || 3 );
		},

		/**
		 * Decodes data using Base64.
		 *
		 * @since 2.0.0
		 * @param {string} data - The data to decode.
		 * @return {string}
		 */
		base64Decode: function( input ) {
			var output = '',
				chr1,
				chr2,
				chr3,
				enc1,
				enc2,
				enc3,
				enc4,
				i = 0;

			if ( 'undefined' === typeof input || ! input || '' === input ) {
				return input;
			}

			input = input.replace( /[^A-Za-z0-9\+\/\=]/g, '' );

			while ( i < input.length ) {

				enc1 = this._keyStr.indexOf( input.charAt( i++ ) );
				enc2 = this._keyStr.indexOf( input.charAt( i++ ) );
				enc3 = this._keyStr.indexOf( input.charAt( i++ ) );
				enc4 = this._keyStr.indexOf( input.charAt( i++ ) );

				chr1 = ( enc1 << 2 ) | ( enc2 >> 4 );
				chr2 = ( ( enc2 & 15 ) << 4 ) | ( enc3 >> 2 );
				chr3 = ( ( enc3 & 3 ) << 6 ) | enc4;

				output = output + String.fromCharCode( chr1 );

				if ( 64 != enc3 ) { // jshint ignore: line
					output = output + String.fromCharCode( chr2 );
				}
				if ( 64 != enc4 ) { // jshint ignore: line
					output = output + String.fromCharCode( chr3 );
				}

			}

			output = this.utf8Decode( output );

			return output;
		},

		/**
		 * Decodes data using utf8.
		 *
		 * @since 2.0.0
		 * @param {string} utftext - The data to decode.
		 * @return {string}
		 */
		utf8Decode: function( utftext ) {
			var string = '',
				i  = 0,
				c  = 0,
				c1 = 0, // jshint ignore: line
				c2 = 0,
				c3;

			while ( i < utftext.length ) {

				c = utftext.charCodeAt( i );

				if ( 128 > c ) {
					string += String.fromCharCode( c );
					i++;
				} else if ( ( 191 < c ) && ( 224 > c ) ) {
					c2 = utftext.charCodeAt( i + 1 );
					string += String.fromCharCode( ( ( c & 31 ) << 6 ) | ( c2 & 63 ) );
					i += 2;
				} else {
					c2 = utftext.charCodeAt( i + 1 );
					c3 = utftext.charCodeAt( i + 2 );
					string += String.fromCharCode( ( ( c & 15 ) << 12 ) | ( ( c2 & 63 ) << 6 ) | ( c3 & 63 ) );
					i += 3;
				}

			}

			return string;
		},

		setContent: function( textareaID, content ) {
			if ( 'undefined' !== typeof window.tinyMCE && window.tinyMCE.get( textareaID ) && ! window.tinyMCE.get( textareaID ).isHidden() ) {

				if ( window.tinyMCE.get( textareaID ).getParam( 'wpautop', true ) && 'undefined' !== typeof window.switchEditors ) {
					content = window.switchEditors.wpautop( content );
				}

				window.tinyMCE.get( textareaID ).setContent( content, { format: 'html' } );

			}

			// In both cases, update the textarea as well.
			jQuery( '#' + textareaID + ':visible' ).val( content ).trigger( 'change' );
		},

		isTinyMceActive: function() {
			var isActive = ( 'undefined' !== typeof tinyMCE ) && tinyMCE.activeEditor && ! tinyMCE.activeEditor.isHidden();

			return isActive;
		},

		previewToggle: function() {
			var $body = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ),
				self  = this;

			this.previewMode = $body.hasClass( 'fusion-builder-preview-mode' );

			if ( this.$el.find( '.fusion-scrolling-section-edit' ).length ) {
				this.toggleScrollingSections();
			}

			// Toggle nice scroll if already available, otherwise wait for iframe loaded event.
			if ( 'undefined' !== typeof jQuery( '#fb-preview' )[ 0 ].contentWindow.avadaNiceScrollVars ) {
				this.toggleNiceScroll();
			} else {
				FusionEvents.once( 'fusion-iframe-loaded', function() {
					self.toggleNiceScroll();
				} );
			}
		},

		/**
		 * Simplified version of avada-nicescroll.js script.
		 * If there is need add resize event as well.
		 */
		toggleNiceScroll: function() {
			if ( '1' === jQuery( '#fb-preview' )[ 0 ].contentWindow.avadaNiceScrollVars.smooth_scrolling || 1 === jQuery( '#fb-preview' )[ 0 ].contentWindow.avadaNiceScrollVars.smooth_scrolling || true === jQuery( '#fb-preview' )[ 0 ].contentWindow.avadaNiceScrollVars.smooth_scrolling ) {
				if ( this.previewMode ) {

					// Init nicescroll.
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'html' ).niceScroll( {
						background: '#555',
						scrollspeed: 60,
						mousescrollstep: 40,
						cursorwidth: 9,
						cursorborder: '0px',
						cursorcolor: '#303030',
						cursorborderradius: 8,
						preservenativescrolling: true,
						cursoropacitymax: 1,
						cursoropacitymin: 1,
						autohidemode: false,
						zindex: 999999,
						horizrailenabled: false
					} );

					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'html' ).addClass( 'no-overflow-y' );

				} else if ( ! this.previewMode ) {

					// Destroy nice scroll.
					if ( 'undefined' !== typeof jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'html' ).getNiceScroll ) {
						jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'html' ).getNiceScroll().remove();
					}
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'html' ).removeClass( 'no-overflow-y' );
				}
			}
		},

		toggleScrollingSections: function() {
			if ( this.previewMode ) {
				this.createScrollingSections();
			} else {
				this.destroyScrollingSections();
			}
		},

		reInitScrollingSections: function() {
			this.destroyScrollingSections();
			this.createScrollingSections();
		},

		scrollingContainers: function() {
			var $containers              = this.$el.find( '.fusion-builder-container ' ),
				scrollingSections        = {},
				scrollingActive          = false,
				scrollingIndex           = 0;

			if ( ! this.$el.find( '.fusion-scrolling-section-edit' ).length ) {
				return;
			}

			$containers.each( function() {
				if ( jQuery( this ).find( '.fusion-scrolling-section-edit' ).length ) {
					scrollingActive = true;
					if ( 'undefined' === typeof scrollingSections[ scrollingIndex ] ) {
						scrollingSections[ scrollingIndex ] = [];
					}
					scrollingSections[ scrollingIndex ].push( jQuery( this ) );
				} else if ( scrollingActive ) {
					scrollingIndex++;
					scrollingActive = false;
				}
			} );

			_.each( scrollingSections, function( $scrollingContainers ) {
				var navigation = '',
					i;

				for ( i = $scrollingContainers.length; 0 < i; i-- ) {
					navigation += '<li><a href="#" class="fusion-scroll-section-link"><span class="fusion-scroll-section-link-bullet"></span></a></li>';
				}

				_.each( $scrollingContainers, function( $scrollingContainer ) {
					$scrollingContainer.find( '.fusion-scroll-section-nav ul' ).html( navigation );
				} );
			} );
		},

		createScrollingSections: function() {
			var $containers              = this.$el.find( '.fusion-builder-container ' ),
				scrollNavigationPosition = ( 'right' === FusionApp.settings.header_position.toLowerCase() || jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).hasClass( 'rtl' ) ) ? 'scroll-navigation-left' : 'scroll-navigation-right',
				scrollingSections        = {},
				scrollingActive          = false,
				scrollingIndex           = 0;

			$containers.each( function() {
				if ( jQuery( this ).find( '.fusion-scrolling-section-edit' ).length ) {
					scrollingActive = true;
					if ( 'undefined' === typeof scrollingSections[ scrollingIndex ] ) {
						scrollingSections[ scrollingIndex ] = [];
					}
					scrollingSections[ scrollingIndex ].push( jQuery( this ) );
				} else if ( scrollingActive ) {
					scrollingIndex++;
					scrollingActive = false;
				}
			} );

			_.each( scrollingSections, function( $scrollingContainers, sectionIndex ) {
				var $scrollSectionContainer  = '<div id="fusion-scroll-section-' + sectionIndex + '" class="fusion-scroll-section" data-section="' + sectionIndex + '">',
					$scrollingNav            = '<nav id="fusion-scroll-section-nav-' + sectionIndex + '" class="fusion-scroll-section-nav ' + scrollNavigationPosition + '" data-section="' + sectionIndex + '"><ul>',
					$targetContainer         = false;

				_.each( $scrollingContainers, function( $scrollingContainer, containerIndex ) {
					var active,
						$parent,
						$clone,
						adminLabel,
						containerId,
						$containerLink;

					containerIndex = containerIndex + 1;
					active         = 1 === containerIndex ? ' active' : '';
					$parent        = $scrollingContainer;
					$clone         = $scrollingContainer.find( '.fusion-scrolling-section-edit' ).clone();
					adminLabel     = $parent.find( '.fusion-builder-section-name' ).val();
					containerId    = 'fusion-scroll-section-element-' + sectionIndex + '-' + containerIndex;
					$containerLink = '<li><a href="#' + containerId + '" class="fusion-scroll-section-link" data-name="' + adminLabel + '" data-element="' + containerIndex + '"><span class="fusion-scroll-section-link-bullet"></span></a></li>';

					if ( 1 === containerIndex ) {
						$targetContainer = $parent;
					}
					$clone.find( '.fusion-scroll-section-nav, .fusion-builder-insert-column, .fusion-builder-container-add' ).remove();
					$clone.find( '.hundred-percent-height' ).removeClass( 'hundred-percent-height' ).css( { height: '', 'min-height': '' } );
					$clone.addClass( 'hundred-percent-height-scrolling hundred-percent-height' );

					$scrollingNav           += $containerLink;
					$scrollSectionContainer += '<div class="fusion-scroll-section-element' + active + '" data-section="' + sectionIndex + '" data-element="' + containerIndex +  '">' + $clone.outerHTML() + '</div>';

					$parent.addClass( 'fusion-temp-hidden-container' );
					$parent.hide();
				} );

				$scrollingNav += '</ul></nav>';

				$scrollSectionContainer += $scrollingNav;
				$scrollSectionContainer += '</div>';

				if ( $targetContainer  ) {
					$targetContainer.before( $scrollSectionContainer );
				}
			} );

			jQuery( '#fb-preview' )[ 0 ].contentWindow.initScrollingSections();
			jQuery( '#fb-preview' ).contents().scrollTop( 0 );
		},

		destroyScrollingSections: function() {
			this.$el.find( '.fusion-scroll-section' ).remove();
			this.$el.find( '.fusion-temp-hidden-container' ).show().removeClass( 'fusion-temp-hidden-container' );
		},

		/**
		 * Toggles visibility of droppable areas on hover.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		toggleDroppablesVisibility: function() {

			// Droppables.
			if ( 'undefined' !== typeof FusionApp && 'on' === FusionApp.preferencesData.droppables_visible ) {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).removeClass( 'fusion-hide-droppables' );
			} else {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).addClass( 'fusion-hide-droppables' );
			}
		},

		/**
		 * Toggles tooltips.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		toggleStickyHeader: function() {

			// Sticky header.
			if ( 'undefined' !== typeof FusionApp && 'off' === FusionApp.preferencesData.sticky_header ) {
				fusionTriggerEvent( 'fusion-disable-sticky-header' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).addClass( 'fusion-disable-sticky' );
			} else  {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).removeClass( 'fusion-disable-sticky' );
				if ( 1 === Number( FusionApp.settings.header_sticky ) ) {
					fusionTriggerEvent( 'fusion-init-sticky-header' );
				}
			}

			jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-sticky-header-reinit' );
		},

		/**
		 * Toggles visibility of droppable areas on hover.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		toggleTooltips: function() {

			// Tooltips.
			if ( 'undefined' !== typeof FusionApp && 'off' === FusionApp.preferencesData.tooltips ) {
				jQuery( 'body' ).addClass( 'fusion-hide-all-tooltips' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).addClass( 'fusion-hide-all-tooltips' );
			} else {
				jQuery( 'body' ).removeClass( 'fusion-hide-all-tooltips' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).removeClass( 'fusion-hide-all-tooltips' );
			}
		},

		/**
		 * Toggles element filter options preview.
		 *
		 * @since 2.2
		 * @return {void}
		 */
		toggleElementFilters: function() {
			if ( 'undefined' !== typeof FusionApp && 'off' === FusionApp.preferencesData.element_filters ) {
				jQuery( 'body' ).addClass( 'fusion-disable-element-filters' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).addClass( 'fusion-disable-element-filters' );
			} else {
				jQuery( 'body' ).removeClass( 'fusion-disable-element-filters' );
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).removeClass( 'fusion-disable-element-filters' );
			}
		},

		/**
		 * Toggles transparent header and absolute containers.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		toggleTransparentHeader: function() {
			var HeaderBGColor = '' === fusionSanitize.getPageOption( 'header_bg_color' ) ? FusionApp.settings.header_bg_color : fusionSanitize.getPageOption( 'header_bg_color' ),
				$html         = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'html' ),
				$body         = $html.find( 'body' );

			// Transparent Header.
			if ( 'undefined' !== typeof FusionApp && 'off' === FusionApp.preferencesData.transparent_header ) {
				$html.removeClass( 'avada-header-color-not-opaque' );
			} else if ( 1 > jQuery.Color( HeaderBGColor ).alpha() ) {
				$html.addClass( 'avada-header-color-not-opaque' );
			}

			// Absolute containers.
			if ( 'undefined' !== typeof FusionApp && 'off' === FusionApp.preferencesData.transparent_header ) {
				$body.addClass( 'fusion-no-absolute-containers' );
			} else {
				$html.removeClass( 'fusion-no-absolute-containers' );
			}
		},

		/**
		 * Hides extra open sizes panels.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		sizesHide: function( event ) {
			var $targetClass = jQuery( event.target ).parent().attr( 'class' );
			if ( 'fusion-builder-column-size' !== $targetClass ) {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body .column-sizes:visible' ).each( function() {
					jQuery( this ).parent().find( '.fusion-builder-column-size' ).trigger( 'click' );
				} );
			}
		},

		/**
		 * Fired when wireframe mode is toggled.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		wireFrameToggled: function() {
			this._wireframeToggle();

			if ( this.wireframeActive ) {
				this.enableSortableContainers();
			} else {
				this.disableSortableContainers();
			}
		},

		/**
		 * Trigger event on body for other page elements.
		 *
		 * @since 3.0
		 * @return {void}
		 */
		wireframeToggle: function() {
			jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-wireframe-toggle' );
		},

		/**
		 * Initialize or enable the container sortable.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		enableSortableContainers: function() {
			if ( 'undefined' !== typeof this.$el.sortable( 'instance' ) ) {
				this.$el.sortable( 'enable' );
			} else {
				this.sortableContainers();
			}
		},

		/**
		 * Destroy or disable container sortable.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		disableSortableContainers: function() {
			if ( 'undefined' !== typeof this.$el.sortable( 'instance' ) ) {
				this.$el.sortable( 'disable' );
			}
		},

		/**
		 * Enable sortable for wireframe mode.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		sortableContainers: function() {
			this.$el.sortable( {
				handle: '.fusion-builder-section-header',
				items: '.fusion-builder-container, .fusion-builder-next-page',
				cancel: '.fusion-builder-section-name, .fusion-builder-settings, .fusion-builder-clone, .fusion-builder-remove, .fusion-builder-section-add, .fusion-builder-add-element, .fusion-builder-insert-column, #fusion_builder_controls, .fusion-builder-save-element',
				cursor: 'move',
				update: function() {
					FusionEvents.trigger( 'fusion-content-changed' );

					FusionPageBuilderApp.scrollingContainers();

					FusionEvents.trigger( 'fusion-history-save-step', fusionBuilderText.full_width_section + ' order changed' );
				}
			} );
		},

		setStackedContentClass: function() {
			if ( 'undefined' !== typeof FusionApp.settings && this.$el.width() < FusionApp.settings.content_break_point ) {
				this.$el.addClass( 'fusion-stacked-content' );
			} else {
				this.$el.removeClass( 'fusion-stacked-content' );
			}
		},

		disableDocumentWrite: function() {
			if ( false === this.previewDocumentWrite ) {
				this.previewDocumentWrite = document.getElementById( 'fb-preview' ).contentWindow.document.write;
				document.getElementById( 'fb-preview' ).contentWindow.document.write = function() {};
			}
			if ( false === this.documentWrite ) {
				this.documentWrite = document.write;
				document.write     = function() {};
			}
		},

		enableDocumentWrite: function() {
			var self = this;

			setTimeout( function() {
				if ( false !== self.documentWrite ) {
					document.write = self.documentWrite;
				}
				if ( false !== self.previewDocumentWrite ) {
					document.getElementById( 'fb-preview' ).contentWindow.document.write = self.previewDocumentWrite;
				}

				self.documentWrite        = false;
				self.previewDocumentWrite = false;
			}, 500 );
		},

		fusionLibraryUI: function() {
			if ( 'elements' === FusionApp.data.fusion_element_type ) {
				if ( this.$el.find( '.fusion-builder-column-outer .fusion_builder_row_inner, .fusion-builder-live-element' ).length ) {
					this.$el.find( '.fusion-builder-column .fusion-builder-add-element' ).hide();
				}
			}
		},

		sameContainerTypes: function( original, target ) {

			if ( original === target ) {
				return true;
			}

			if ( 'object' !== typeof original ) {
				original = FusionPageBuilderViewManager.getView( original );
			}
			if ( 'object' !== typeof target ) {
				target = FusionPageBuilderViewManager.getView( target );
			}

			// Don't have problem views, so we can't tell.
			if ( 'object' !== typeof original || 'object' !== typeof target || 'function' !== typeof original.isFlex || 'function' !== typeof target.isFlex ) {
				return false;
			}
			return original.isFlex() === target.isFlex();
		},

		getParentContainer: function( target ) {
			var view = target;

			// Not passing view directly, get it assuming cid is passed.
			if ( 'object' !== typeof target ) {
				view = FusionPageBuilderViewManager.getView( target );
			}

			// No view, return false.
			if ( ! view ) {
				return false;
			}

			// View found and is container, return that.
			if ( 'fusion_builder_container' === view.model.get( 'element_type' ) ) {
				return view;
			}

			// Not container but parent cid exists, try that.
			if ( view.model.get( 'parent' ) ) {
				return this.getParentContainer( view.model.get( 'parent' ) );
			}

			// Got here, that means no parent, no match, return false.
			return false;
		},

		getParentColumn: function( target ) {
			var view = target;

			// Not passing view directly, get it assuming cid is passed.
			if ( 'object' !== typeof target ) {
				view = FusionPageBuilderViewManager.getView( target );
			}

			// No view, return false.
			if ( ! view ) {
				return false;
			}

			// View found and is column, return that.
			if ( 'fusion_builder_column' === view.model.get( 'element_type' ) || 'fusion_builder_column_inner' === view.model.get( 'element_type' ) ) {
				return view;
			}

			// Not column but parent cid exists, try that.
			if ( view.model.get( 'parent' ) ) {
				return this.getParentColumn( view.model.get( 'parent' ) );
			}

			// Got here, that means no parent, no match, return false.
			return false;
		},

		/**
		 * If appropriate builds styles for form being edited.
		 *
		 * @since 2.0.0
		 * @return {void}
		 */
		maybeFormStyles: function() {

			// Not editing a form then skip.
			if ( 'fusion_form' !== FusionApp.getPost( 'post_type' ) ) {
				return;
			}

			if ( false === this.formStyles ) {
				this.formStyles = new FusionPageBuilder.FormStyles();
				return;
			}

			this.formStyles.buildStyles();
		}

	} );

}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Counter circle child View
		FusionPageBuilder.fusion_counter_circle = FusionPageBuilder.ChildElementView.extend( {

			/**
			 * Runs during render() call.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			onRender: function() {

				if ( 'undefined' !== typeof this.model.attributes.selectors ) {
					this.model.attributes.selectors[ 'class' ] += ' ' + this.className;
					this.setElementAttributes( this.$el, this.model.attributes.selectors );
				}

				if ( 'undefined' !== typeof this.model.attributes.childSelectors ) {

					this.model.attributes.childSelectors[ 'class' ] += ' fusion-builder-child-element-content';

					this.setElementAttributes( this.$el.find( '.fusion-builder-child-element-content' ), this.model.attributes.childSelectors );
				}
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {

				if ( 'undefined' !== typeof this.model.attributes.selectors ) {
					this.model.attributes.selectors[ 'class' ] += ' ' + this.className;
					this.setElementAttributes( this.$el, this.model.attributes.selectors );
				}

				if ( 'undefined' !== typeof this.model.attributes.childSelectors ) {

					this.model.attributes.childSelectors[ 'class' ] += ' fusion-builder-child-element-content';

					this.setElementAttributes( this.$el.find( '.fusion-builder-child-element-content' ), this.model.attributes.childSelectors );
				}

				// Using non debounced version for smoothness.
				this.refreshJs();
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				this.computeAtts( atts.values );

				attributes.cid    = this.model.get( 'cid' );
				attributes.parent = this.model.get( 'parent' );
				attributes.output = atts.values.element_content;

				return attributes;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {void}
			 */
			computeAtts: function( values ) {
				var scales                        = '',
					countdown                     = '',
					counterCircleWrapperShortcode = '',
					counterCircleShortcode        = {
						class: 'fusion-counter-circle counter-circle counter-circle-content'
					},
					multiplicator,
					strokeSize,
					fontSize;

				values.size = _.fusionValidateAttrValue( values.size, '' );

				if ( 'yes' === values.scales ) {
					scales = true;
				}

				if ( 'yes' === values.countdown ) {
					countdown = true;
				}

				if ( '' !== values[ 'class' ] ) {
					counterCircleShortcode[ 'class' ] += ' ' + values[ 'class' ];
				}

				if ( '' !== values.id ) {
					counterCircleShortcode.id = values.id;
				}

				values.size = parseFloat( values.size );

				multiplicator = values.size / 220;
				strokeSize    = 11 * multiplicator;
				fontSize      = 50 * multiplicator;

				counterCircleShortcode[ 'data-percent' ]       = values.value;
				counterCircleShortcode[ 'data-countdown' ]     = countdown;
				counterCircleShortcode[ 'data-filledcolor' ]   = values.filledcolor;
				counterCircleShortcode[ 'data-unfilledcolor' ] = values.unfilledcolor;
				counterCircleShortcode[ 'data-scale' ]         = scales;
				counterCircleShortcode[ 'data-size' ]          = values.size.toString();
				counterCircleShortcode[ 'data-speed' ]         = values.speed.toString();
				counterCircleShortcode[ 'data-strokesize' ]    = strokeSize.toString();

				counterCircleShortcode.style = 'font-size:' + fontSize + 'px;height:' + values.size + 'px;width:' + values.size + 'px;';

				// counterCircleWrapperShortcode Attributes.
				counterCircleWrapperShortcode = {
					class: 'counter-circle-wrapper',
					style: 'height:' + values.size + 'px;width:' + values.size + 'px;'
				};

				counterCircleWrapperShortcode[ 'data-originalsize' ] = values.size.toString();

				this.model.set( 'selectors', counterCircleWrapperShortcode );
				this.model.set( 'childSelectors', counterCircleShortcode );
			}

		} );
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Counter circles parent View
		FusionPageBuilder.fusion_counters_circle = FusionPageBuilder.ParentElementView.extend( {

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {
				this.appendChildren( '.fusion-counters-circle' );

				this._refreshJs();
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var countersCircleAtts = this.computeAtts( atts.values );

				atts = {};
				atts.countersCircleAtts = countersCircleAtts;

				return atts;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			computeAtts: function( values ) {
				var countersCircleAtts = _.fusionVisibilityAtts( values.hide_on_mobile, {
					class: 'fusion-counters-circle counters-circle'
				} );

				if ( '' !== values[ 'class' ] ) {
					countersCircleAtts[ 'class' ] += ' ' + values[ 'class' ];
				}

				if ( '' !== values.id ) {
					countersCircleAtts.id += ' ' + values.id;
				}

				countersCircleAtts[ 'class' ] += ' fusion-child-element';

				countersCircleAtts[ 'data-empty' ] = this.emptyPlaceholderText;

				return countersCircleAtts;
			}

		} );
	} );
}( jQuery ) );
;/* global fusionAppConfig, FusionPageBuilderViewManager, imagesLoaded */
/* jshint -W098 */
/* eslint no-unused-vars: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Gallery View.
		FusionPageBuilder.fusion_gallery = FusionPageBuilder.ParentElementView.extend( {

			/**
			 * Image map of child element images and thumbs.
			 *
			 * @since 2.0
			 */
			imageMap: {
				images: {}
			},

			onInit: function() {
				this.fusionIsotope = new FusionPageBuilder.IsotopeManager( {
					selector: '.fusion-gallery-layout-grid, .fusion-gallery-layout-masonry',
					layoutMode: 'packery',
					itemSelector: '.fusion-gallery-column',
					isOriginLeft: jQuery( 'body.rtl' ).length ? false : true,
					resizable: true,
					initLayout: true,
					view: this
				} );
			},

			onRender: function() {
				var galleryElements = this.$el.find( '.fusion-gallery-column' ),
					self = this;

				imagesLoaded( galleryElements, function() {
					self.fusionIsotope.updateLayout();

					self.setOutlineControlsPosition();
				} );
			},

			/**
			 * Sets position of outlines and controls for the child elements to match column spacing..
			 *
			 * @since 2.0
			 * @return {void}
			 */
			setOutlineControlsPosition: function() {
				var cid = this.model.get( 'cid' ),
					params = this.model.get( 'params' ),
					halfColumnSpacing = ( parseFloat( params.column_spacing ) / 2 ) + 'px',
					css = '';

				this.$el.children( 'style' ).remove();

				css += '<style type="text/css">';
				css += '.fusion-builder-live:not(.fusion-builder-ui-wireframe) div[data-cid="' + cid + '"] .fusion-builder-live-child-element:hover:after{ margin:' + halfColumnSpacing + ';}';
				css += '.fusion-builder-live:not(.fusion-builder-ui-wireframe) div[data-cid="' + cid + '"] .fusion-builder-live-child-element:hover .fusion-builder-module-controls-container{ bottom: ' + halfColumnSpacing + '; right:' + halfColumnSpacing + ';}';
				css += '</style>';

				this.$el.prepend( css );
			},

			/**
			 * Extendable function for when child elements get generated.
			 *
			 * @since 2.0.0
			 * @param {Object} modules An object of modules that are not a view yet.
			 * @return {void}
			 */
			onGenerateChildElements: function( modules ) {
				var i = 1;

				this.fusionIsotope.init();
				this.addImagesToImageMap( modules, false, false );

				// Set child counter. Used for grid layout clearfix.
				_.each( this.model.children, function( child ) {
					child.set( 'counter', i );
					i++;
				} );
			},

			/**
			 * Add images to the view's image map.
			 *
			 * @since 2.0
			 * @param {Object} childrenData - The children for which images need added to the map.
			 * @param bool async - Determines if the AJAX call should be async.
			 * @param bool async - Determines if the view should be re-rendered.
			 * @return void
			 */
			addImagesToImageMap: function( childrenData, async, reRender, forceQuery ) {
				var view      = this,
					queryData = {};

				async    = ( 'undefined' === typeof async ) ? true : async;
				reRender = ( 'undefined' === typeof reRender ) ?  true : reRender;

				_.each( childrenData, function( child ) {
					var params = ( 'undefined' !== typeof child.get ) ? child.get( 'params' ) : child.params,
						cid    = ( 'undefined' !== typeof child.get ) ? child.get( 'cid' ) : child.cid,
						image  = params.image;

					if ( 'undefined' === typeof view.imageMap.images[ params.image_id ] || forceQuery ) {
						queryData[ params.image_id ] = params;
					}
				} );

				// Send this data with ajax or rest.
				if ( ! _.isEmpty( queryData ) ) {
					jQuery.ajax( {
						async: async,
						url: fusionAppConfig.ajaxurl,
						type: 'post',
						dataType: 'json',
						data: {
							action: 'get_fusion_gallery',
							children: queryData,
							fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
							gallery: view.model.get( 'params' )
						}
					} )
					.done( function( response ) {
						view.updateImageMap( response, forceQuery );
						view.model.set( 'query_data', response );

						if ( reRender ) {
							view.reRender();
						}
					} );
				}
			},

			/**
			 * Update the view's image map.
			 *
			 * @since 2.0
			 * @param {Object} images - The images object to inject.
			 * @return void
			 */
			updateImageMap: function( images, forceUpdate ) {
				var imageMap = this.imageMap;

				_.each( images.images, function( image, imageId ) {
					if ( 'undefined' === typeof imageMap.images[ imageId ] || forceUpdate ) {
						imageMap.images[ imageId ] = image;
					}
				} );

				// TODO: needed ?
				this.imageMap = imageMap;
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {
				this.appendChildren( '.fusion-gallery-container' );
				this.fusionIsotope.reInit();
				this.checkVerticalImages();

				this.setOutlineControlsPosition();
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Validate values.
				this.validateValues( atts.values );

				attributes.values     = atts.values;
				attributes.query_data = atts.query_data;

				// // Create attribute objects.
				attributes.attr       = this.buildAttr( atts.values );

				return attributes;
			},

			checkVerticalImages: function() {
				var container = this.$el.find( '.fusion-gallery-layout-grid, .fusion-gallery-layout-masonry' );

				if ( container.hasClass( 'fusion-gallery-layout-masonry' ) && 0 < container.find( '.fusion-grid-column:not(.fusion-grid-sizer)' ).not( '.fusion-element-landscape' ).length ) {
					container.addClass( 'fusion-masonry-has-vertical' );
				} else {
					container.removeClass( 'fusion-masonry-has-vertical' );
				}
			},

			/**
			 * Modifies the values.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {void}
			 */
			validateValues: function( values ) {
				values.column_spacing = ( parseFloat( values.column_spacing ) / 2 ) + 'px';
				values.bordersize     = _.fusionValidateAttrValue( values.bordersize, 'px' );
				values.border_radius  = _.fusionValidateAttrValue( values.border_radius, 'px' );

				if ( 'round' === values.border_radius ) {
					values.border_radius = '50%';
				}
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildAttr: function( values ) {
				var totalNumOfColumns = this.model.children.length,
					attr              = _.fusionVisibilityAtts( values.hide_on_mobile, {
						class: 'fusion-gallery fusion-gallery-container fusion-child-element fusion-grid-' + values.columns + ' fusion-columns-total-' + totalNumOfColumns + ' fusion-gallery-layout-' + values.layout
					} ),
					margin;

				if ( values.column_spacing ) {
					margin = ( -1 ) * parseFloat( values.column_spacing );
					attr.style = 'margin:' + margin + 'px;';
				}

				attr[ 'data-empty' ] = this.emptyPlaceholderText;

				return attr;
			}

		} );

		// Fetch image_date for single image
		_.extend( FusionPageBuilder.Callback.prototype, {
			fusion_gallery_image: function( name, value, modelData, args, cid, action, model, elementView ) {
				var queryData  = {},
					reRender   = true,
					async      = true,
					parentView = FusionPageBuilderViewManager.getView( model.attributes.parent ),
					params     = jQuery.extend( true, {}, model.attributes.params ),
					imageId;

				params[ name ] = value;
				imageId        = params.image_id;

				if ( 'undefined' === typeof parentView.imageMap.images[ imageId ] && 'undefined' !== typeof value && '' !== value ) {
					queryData[ imageId ] = params;
				}

				// Send this data with ajax or rest.
				if ( ! _.isEmpty( queryData ) ) {
					jQuery.ajax( {
						async: async,
						url: fusionAppConfig.ajaxurl,
						type: 'post',
						dataType: 'json',
						data: {
							action: 'get_fusion_gallery',
							children: queryData,
							fusion_load_nonce: fusionAppConfig.fusion_load_nonce,
							gallery: parentView.model.get( 'params' )
						}
					} )
					.done( function( response ) {
						parentView.updateImageMap( response );

						if ( 'undefined' !== typeof response.images[ value ] ) {
							if ( 'undefined' !== typeof response.images[ value ].image_data && 'image_id' === name && 'undefined' !== typeof response.images[ value ].image_data.url ) {
								if ( ! args.skip ) {
									elementView.changeParam( 'image', response.images[ value ].image_data.url );
								}
							}
						}

						elementView.changeParam( name, value );

						if ( reRender ) {
							elementView.reRender();
						}
					} );
				} else {
					if ( ! args.skip && 'undefined' !== typeof name ) {
						elementView.changeParam( name, value );
					}
					if ( reRender ) {
						elementView.reRender();
					}
				}
			}
		} );

		_.extend( FusionPageBuilder.Callback.prototype, {
			fusion_gallery_images: function( name, value, modelData, args, cid, action, model, view ) {
				view.model.attributes.params[ name ] = value;
				view.addImagesToImageMap( view.model.children.models, true, true, true );
			}
		} );

	} );
}( jQuery ) );
;/* global FusionPageBuilderViewManager */
/* jshint -W098 */
/* eslint no-empty-function: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Gallery View.
		FusionPageBuilder.fusion_gallery_image = FusionPageBuilder.ChildElementView.extend( {

			/**
			 * Runs after initial render.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			onRender: function() {
				var self = this,
					parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );

				if ( 'undefined' !== typeof this.model.attributes.selectors ) {
					this.model.attributes.selectors[ 'class' ] += ' ' + this.className;
					this.setElementAttributes( this.$el, this.model.attributes.selectors );
				}

				// Re-render the parent view if the child was cloned
				if ( 'undefined' !== typeof self.model.attributes.cloned && true === self.model.attributes.cloned ) {
					delete self.model.attributes.cloned;
					parentView.reRender();
					parentView.fusionIsotope.reloadItems();
				}

				// Update isotope layout
				setTimeout( function() {
					parentView.fusionIsotope.append( self.$el );
					parentView.checkVerticalImages();
				}, 50 );

				this.initLightbox();
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			beforePatch: function() {
			},

			/**
			 * (Re-)Inits the lightbox.
			 *
			 * @since 2.0.3
			 * @return {void}
			 */
			initLightbox: function() {
				var link = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( this.$el.find( '.fusion-lightbox' ) );

				if ( 'object' === typeof jQuery( '#fb-preview' )[ 0 ].contentWindow.avadaLightBox ) {
					if ( 'undefined' !== typeof this.iLightbox ) {
						this.iLightbox.destroy();
					}

					if ( link.length && ! link.find( '.fusion-builder-placeholder' ).length ) {
						this.iLightbox = link.iLightBox( jQuery( '#fb-preview' )[ 0 ].contentWindow.avadaLightBox.prepare_options( 'single' ) );
					}
				}
			},

			/**
			 * Runs before view is removed.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			beforeRemove: function() {
				var parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );
				parentView.fusionIsotope.remove( self.$el );
				parentView.checkVerticalImages();

				setTimeout( function() {
					parentView.fusionIsotope.reloadItems();
				}, 100 );
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {
				var parentCid = this.model.get( 'parent' ),
					parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) );

				if ( 'undefined' !== typeof this.model.attributes.selectors ) {
					this.model.attributes.selectors[ 'class' ] += ' ' + this.className;
					this.setElementAttributes( this.$el, this.model.attributes.selectors );
				}

				this.initLightbox();

				// Force re-render for child option changes.
				setTimeout( function() {
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-element-render-fusion_gallery', parentCid );
					parentView.fusionIsotope.updateLayout();
				}, 100 );
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object} - Returns the attributes.
			 */
			filterTemplateAtts: function( atts ) {
				var attributes   = {},
					parentView   = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) ),
					imageData    = parentView.imageMap.images[ this.model.attributes.params.image_id ],
					parentValues = atts.parentValues,
					orientation  = '';

				// Validate values.
				this.validateValues( atts.values );
				this.validateValues( atts.parentValues );

				attributes.values     = atts.values;

				// Added
				attributes.imageData        = imageData;
				attributes.galleryLayout    = parentValues.layout;
				attributes.galleryLightbox  = parentValues.lightbox;
				attributes.galleryColumns   = parentValues.columns;
				attributes.imageWrapperAttr = this.buildImageWrapperAttr( parentValues );
				attributes.counter          = this.model.get( 'counter' );

				// Create attribute objects.
				attributes.imagesAttr = this.buildImagesAttr( atts.values );

				if ( 'undefined' !== typeof imageData && 'undefined' !== typeof imageData.element_orientation_class && false !== imageData.element_orientation_class ) {
					orientation = imageData.element_orientation_class;
				} else {
					this.$el.removeClass( 'fusion-element-landscape' );
				}

				this.$el.addClass( 'fusion-grid-column fusion-gallery-column ' + orientation );

				return attributes;
			},

			/**
			 * Modifies the values.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {void}
			 */
			validateValues: function( values ) {
				values.column_spacing = ( parseFloat( values.column_spacing ) / 2 ) + 'px';
				values.bordersize     = _.fusionValidateAttrValue( values.bordersize, 'px' );
				values.border_radius  = _.fusionValidateAttrValue( values.border_radius, 'px' );

				if ( 'round' === values.border_radius ) {
					values.border_radius = '50%';
				}
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object} - Returns the attributes.
			 */
			buildAttr: function( values ) {
				var imageIds          = values.image_ids.split( ',' ),
					totalNumOfColumns = imageIds.length,
					attr              = _.fusionVisibilityAtts( values.hide_on_mobile, {
						class: 'fusion-gallery fusion-gallery-container fusion-grid-' + values.columns + ' fusion-columns-total-' + totalNumOfColumns + ' fusion-gallery-layout-' + values.layout
					} ),
					margin;

				if ( values.column_spacing ) {
					margin = ( -1 ) * parseFloat( values.column_spacing );
					attr.style = 'margin:' + margin + 'px;';
				}

				return attr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object} - Returns the attributes for the image wrapper.
			 */
			buildImageWrapperAttr: function( values ) {
				var imageWrapperAttr = {
					class: 'fusion-gallery-image',
					style: ''
				};

				if ( '' !== values.bordersize && 0 !== values.bordersize ) {
					imageWrapperAttr.style += 'border:' + values.bordersize + ' solid ' + values.bordercolor + ';';

					if ( '0' != values.border_radius && '0px' !== values.border_radius && 'px' !== values.border_radius ) {
						imageWrapperAttr.style += '-webkit-border-radius:' + values.border_radius + ';border-radius:' + values.border_radius + ';';

						if ( '50%' === values.border_radius || 100 < parseInt( values.border_radius, 10 ) ) {
							imageWrapperAttr.style += '-webkit-mask-image:-webkit-radial-gradient(circle, white, black);';
						}
					}
				}

				if ( 'liftup' === values.hover_type ) {
					imageWrapperAttr[ 'class' ] = ' fusion-gallery-image-liftup';
				}

				return imageWrapperAttr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @param {Object} queryData - The query data.
			 * @return {Object} - Returns the image attributes.
			 */
			buildImagesAttr: function( values ) {
				var imagesAttr = {},
					cid        = this.model.get( 'cid' ),
					imageId    = this.model.attributes.params.image_id,
					parentView = FusionPageBuilderViewManager.getView( this.model.get( 'parent' ) ),
					image      = parentView.imageMap.images[ imageId ],
					columnSpacing,
					isPortrait,
					isLandscape,
					borderColor;

				if ( 'undefined' === typeof image ) {
					image = {};
				}

				columnSpacing = 0;
				isPortrait    = false;
				isLandscape   = false;
				borderColor   = jQuery.Color( values.bordercolor );

				imagesAttr = {};

				if ( 'masonry' === values.layout ) {
					imagesAttr.masonryWrapper = {
						style: '',
						class: 'fusion-masonry-element-container'
					};

					if ( image.url ) {
						imagesAttr.masonryWrapper.style += 'background-image:url(' + image.url + ');';
					}

					if ( 'undefined' !== typeof image.image_data && true !== image.image_data.specific_element_orientation_class ) {
						image.element_orientation_class = _.fusionGetElementOrientationClass( { imageWidth: image.image_data.width, imageHeight: image.image_data.height }, values.gallery_masonry_grid_ratio, values.gallery_masonry_width_double );
					}
					image.element_base_padding = _.fusionGetElementBasePadding( image.element_orientation_class );

					if ( image.element_base_padding ) {
						columnSpacing = 0;

						if ( 'undefined' !== typeof image.element_orientation_class && false !== image.element_orientation_class ) {
							isLandscape   = -1 !== image.element_orientation_class.indexOf( 'fusion-element-landscape' );
							isPortrait    = -1 !== image.element_orientation_class.indexOf( 'fusion-element-portrait' );
						}

						if ( isLandscape || isPortrait ) {
							columnSpacing = 2 * parseFloat( values.column_spacing );
						}

						// Calculate the correct size of the image wrapper container, based on orientation and column spacing.
						if ( values.bordersize && 'transparent' !== values.bordercolor && 0 !== borderColor.alpha() ) {
							if ( isLandscape || isPortrait ) {
								columnSpacing += 2 * parseFloat( values.bordersize );
							}
						}

						if ( isLandscape && isPortrait ) {
							imagesAttr.masonryWrapper.style += 'padding-top:calc((100% - ' + columnSpacing + 'px) * ' + image.element_base_padding + ' + ' + columnSpacing + 'px);';
						} else if ( isLandscape ) {
							imagesAttr.masonryWrapper.style += 'padding-top:calc((100% - ' + columnSpacing + 'px) * ' + image.element_base_padding + ');';
						} else if ( isPortrait ) {
							imagesAttr.masonryWrapper.style += 'padding-top:calc(100%  * ' + image.element_base_padding + ' + ' + columnSpacing + 'px);';
						} else {
							imagesAttr.masonryWrapper.style += 'padding-top:calc(100%  * ' + image.element_base_padding + ');';
						}
					}
				}

				imagesAttr.images = {
					style: '',
					class: ''
				};

				if ( 'liftup' !== values.hover_type ) {
					imagesAttr.images[ 'class' ] += ' hover-type-' + values.hover_type;
				}

				if ( '' !== values.column_spacing ) {
					imagesAttr.images.style = 'padding:' + values.column_spacing + ';';
				}

				if ( values.lightbox && 'no' !== values.lightbox ) {
					imagesAttr.link = {
						href: image.pic_link,
						class: 'fusion-lightbox'
					};

					imagesAttr.link[ 'data-rel' ] = 'iLightbox[gallery-' + cid + ']';

					// TODO: fix
					// if ( 'undefined' !== typeof image.image_data ) {

					// 	if ( -1 !== values.lightbox_content.indexOf( 'title' ) ) {
					// 		imagesAttr.link['data-title'] = image.image_data.title;
					// 		imagesAttr.link.title         = image.image_data.title;
					// 	}
					// 	if ( -1 !== values.lightbox_content.indexOf( 'caption' ) ) {
					// 		imagesAttr.link['data-caption'] = image.image_data.caption;
					// 	}
					// }
				}

				return imagesAttr;
			}
		} );
	} );
}( jQuery ) );
;/* global fusionAllElements */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Separator View.
		FusionPageBuilder.fusion_separator = FusionPageBuilder.ElementView.extend( {

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			onRender: function() {
				this.afterPatch();
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {
				var params = this.model.get( 'params' );

				if ( params.flex_grow ) {
					jQuery( this.$el ).closest( '.fusion-builder-live-element' ).css( 'flex-grow', params.flex_grow );
				} else {
					jQuery( this.$el ).closest( '.fusion-builder-live-element' ).css( 'flex-grow', '' );
				}

			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Validate values.
				this.validateValues( atts.values );

				attributes.values = atts.values;

				// Create attribute objects
				attributes.attr            = this.buildAttr( atts.values );
				attributes.borderParts     = this.buildBorderPartsAttr( atts.values );
				attributes.iconWrapperAttr = this.buildIconWrapperAttr( atts.values );
				attributes.iconAttr        = this.buildIconAttr( atts.values );

				return attributes;
			},

			/**
			 * Modifies the values.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {void}
			 */
			validateValues: function( values ) {
				values.border_size   = _.fusionValidateAttrValue( values.border_size, 'px' );
				values.width         = _.fusionValidateAttrValue( values.width, 'px' );
				values.top_margin    = _.fusionValidateAttrValue( values.top_margin, 'px' );
				values.bottom_margin = _.fusionValidateAttrValue( values.bottom_margin, 'px' );

				if ( '0' === values.icon_circle ) {
					values.icon_circle = 'no';
				}

				if ( '' !== values.style ) {
					values.style_type = values.style;
				} else if ( 'default' === values.style_type ) {
					values.style_type = fusionAllElements.fusion_separator.defaults.style_type;
				}

				values.style_type = values.style_type.replace( / /g, '|' );

				if ( '' !== values.bottom ) {
					values.bottom_margin = _.fusionValidateAttrValue( values.bottom, 'px' );
				}

				if ( '' !== values.color ) {
					values.sep_color = values.color;
				}

				// Fallback, in case TO is unset, which was need for installs before 7.0.
				if ( '' === values.icon_color ) {
					values.icon_color = values.sep_color;
				}

				if ( '' !== values.top ) {
					values.top_margin = _.fusionValidateAttrValue( values.top, 'px' );

					if ( '' === values.bottom && 'none' !== values.style ) {
						values.bottom_margin = _.fusionValidateAttrValue( values.top, 'px' );
					}
				}
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildAttr: function( values ) {
				var attr = _.fusionVisibilityAtts( values.hide_on_mobile, {
						class: 'fusion-separator ' + values[ 'class' ],
						style: '',
						'aria-hidden': 'true'
					} );

				attr[ 'class' ] += _.fusionGetStickyClass( values.sticky_display );

				if ( '' !== values.icon && 'none' !== values.style_type ) {
					attr[ 'class' ] += ' fusion-has-icon';
				}

				if ( 'center' === values.alignment ) {
					attr.style += 'margin-left: auto;margin-right: auto;';
				} else {
					attr.style += 'float:' + values.alignment + ';';
					attr[ 'class' ] += ' fusion-clearfix';
				}

				if ( values.flex_grow ) {
					attr.style += 'flex-grow:' + values.flex_grow + ';';
				}

				if ( '' !== values.top_margin ) {
					attr.style += 'margin-top:' + values.top_margin + ';';
				}

				if ( '' !== values.bottom_margin ) {
					attr.style += 'margin-bottom:' + values.bottom_margin + ';';
				}

				if ( '' !== values.width ) {
					attr.style += 'width:100%;max-width:' + values.width + ';';
				}

				attr.id = values.id;

				return attr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 3.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildBorderPartsAttr: function( values ) {
				var attr = {
						class: 'fusion-separator-border',
						style: ''
					},
					styles,
					shadow;

				if ( '' === values.width || '100%' === values.width ) {
					attr[ 'class' ] += ' fusion-full-width-sep';
				}

				styles = values.style_type.split( '|' );

				if ( -1 === jQuery.inArray( 'none', styles ) && -1 === jQuery.inArray( 'single', styles ) && -1 === jQuery.inArray( 'double', styles ) && -1 === jQuery.inArray( 'shadow', styles ) ) {
					styles.push( 'single' );
				}
				jQuery.each( styles, function( key, style ) {
					attr[ 'class' ] += ' sep-' + style;
				} );

				if ( values.sep_color ) {
					if ( 'shadow' === values.style_type ) {
						shadow = 'background:radial-gradient(ellipse at 50% -50% , ' + values.sep_color + ' 0px, rgba(255, 255, 255, 0) 80%) repeat scroll 0 0 rgba(0, 0, 0, 0);';

						attr.style  = shadow;
						attr.style += shadow.replace( 'radial-gradient', '-webkit-radial-gradient' );
						attr.style += shadow.replace( 'radial-gradient', '-moz-radial-gradient' );
						attr.style += shadow.replace( 'radial-gradient', '-o-radial-gradient' );
					} else if ( 'none' !== values.style_type ) {
						attr.style = 'border-color:' + values.sep_color + ';';
					}
				}

				if ( -1 !== jQuery.inArray( 'single', styles ) ) {
					attr.style += 'border-top-width:' + values.border_size + ';';
				}

				if ( -1 !== jQuery.inArray( 'double', styles )  ) {
					attr.style += 'border-top-width:' + values.border_size + ';border-bottom-width:' + values.border_size + ';';
				}

				return attr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildIconWrapperAttr: function( values ) {
				var circleColor,
					marginTop,
					styles = values.style_type.split( '|' ),
					iconWrapperAttr = {
						class: 'icon-wrapper'
					};

				circleColor = ( 'no' === values.icon_circle ) ? 'transparent' : values.sep_color;

				iconWrapperAttr.style = 'border-color:' + circleColor + ';';

				if ( values.icon_circle_color && 'no' !== values.icon_circle ) {
					iconWrapperAttr.style += 'background-color:' + values.icon_circle_color + ';';
				}

				if ( values.icon_size ) {
					iconWrapperAttr.style += 'font-size:' + values.icon_size + 'px;';
					iconWrapperAttr.style += 'width: 1.75em;';
					iconWrapperAttr.style += 'height: 1.75em;';
				}

				if ( values.border_size ) {
					iconWrapperAttr.style += 'border-width:' + values.border_size + ';';
					iconWrapperAttr.style += 'padding:' + values.border_size + ';';
				}

				if ( -1 !== jQuery.inArray( 'single', styles ) ) {
					marginTop = parseInt( values.border_size, 10 ) / 2;
					iconWrapperAttr.style += 'margin-top:-' + marginTop + 'px;';
				}

				return iconWrapperAttr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildIconAttr: function( values ) {
				var iconAttr = {
					class: _.fusionFontAwesome( values.icon ),
					style: 'font-size:inherit;'
				};

				if ( '' !== values.icon_color ) {
					iconAttr.style += 'color:' + values.icon_color + ';';
				}

				return iconAttr;
			}
		} );
	} );
}( jQuery ) );
;/* global fusionAllElements */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Title View
		FusionPageBuilder.fusion_title = FusionPageBuilder.ElementView.extend( {

			/**
			 * Runs when element is first init.
			 *
			 * @since 3.0
			 * @return {void}
			 */
			onInit: function() {
				var params = this.model.get( 'params' );

				// Check for newer hover params.  If unset but regular is, copy from there.
				if ( 'object' === typeof params ) {
					if ( 'undefined' === typeof params.margin_top_small && 'string' === typeof params.margin_top_mobile ) {
						params.margin_top_small = params.margin_top_mobile;
					}
					if ( 'undefined' === typeof params.margin_bottom_small && 'string' === typeof params.margin_bottom_mobile ) {
						params.margin_bottom_small = params.margin_bottom_mobile;
					}
					this.model.set( 'params', params );
				}
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Validate values.
				this.validateValues( atts.values );

				// Create attribute objects
				attributes.attr          			= this.buildAttr( atts.values );
				attributes.headingAttr   			= this.buildHeadingAttr( atts.values );
				attributes.animatedAttr  			= this.buildAnimatedAttr( atts.values );
				attributes.rotatedAttr   			= this.buildRotatedAttr( atts.values );
				attributes.separatorAttr 			= this.builderSeparatorAttr( atts.values );
				attributes.style         			= this.buildStyleBlock( atts.values, atts.extras );

				// Any extras that need passed on.
				attributes.cid            			= this.model.get( 'cid' );
				attributes.output         			= atts.values.element_content;
				attributes.style_type     			= atts.values.style_type;
				attributes.size           			= atts.values.size;
				attributes.content_align  			= atts.values.content_align;
				attributes.title_type     			= atts.values.title_type;
				attributes.before_text    			= atts.values.before_text;
				attributes.highlight_text 			= atts.values.highlight_text;
				attributes.after_text     			= atts.values.after_text;
				attributes.rotation_text  			= atts.values.rotation_text;
				attributes.title_tag      			= 'div' === atts.values.size ? 'div' : 'h' + atts.values.size;
				attributes.isFlex		  			= this.flexDisplay();
				attributes.content_align_sizes		= {
					large: atts.values.content_align,
					medium: atts.values.content_align_medium || atts.values.content_align,
					small: atts.values.content_align_small || atts.values.content_align
				};

				return attributes;
			},

			/**
			 * Modifies the values.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {void}
			 */
			validateValues: function( values ) {
				values.margin_top           = _.fusionValidateAttrValue( values.margin_top, 'px' );
				values.margin_bottom        = _.fusionValidateAttrValue( values.margin_bottom, 'px' );
				values.margin_top_mobile    = _.fusionValidateAttrValue( values.margin_top_mobile, 'px' );
				values.margin_bottom_mobile = _.fusionValidateAttrValue( values.margin_bottom_mobile, 'px' );

				if ( 'rotating' === values.title_type && '' !== values.rotation_text ) {
					values.rotation_text = values.rotation_text.split( '|' );
				} else {
					values.rotation_text = [];
				}

				if ( 'text' !== values.title_type ) {
					values.style_type = 'none';
				}

				if ( 'default' === values.style_type ) {
					values.style_type = fusionAllElements.fusion_title.defaults.style_type;
				}

				if ( 1 === values.style_type.split( ' ' ).length ) {
					values.style_type += ' solid';
				}

				// Make sure the title text is not wrapped with an unattributed p tag.
				if ( 'undefined' !== typeof values.element_content ) {
					values.element_content = values.element_content.trim();
					values.element_content = values.element_content.replace( /(<p[^>]+?>|<p>|<\/p>)/img, '' );
				}

				if ( 'undefined' !== typeof values.font_size && '' !== values.font_size ) {
					values.font_size = _.fusionGetValueWithUnit( values.font_size );
				}

				if ( 'undefined' !== typeof values.letter_spacing && '' !== values.letter_spacing ) {
					values.letter_spacing = _.fusionGetValueWithUnit( values.letter_spacing );
				}

				if ( 'yes' === values.text_shadow ) {
					values.text_shadow = _.fusionGetTextShadowStyle( values ).trim();
				}
			},

			buildStyleBlock: function( values, extras ) {
				var style = '<style type="text/css">',
					bottomHighlights = [ 'underline', 'double_underline', 'underline_zigzag', 'underline_zigzag', 'curly' ];

				if ( 'highlight' === values.title_type && '' !== values.highlight_color ) {
					style += '.fusion-title.fusion-title-cid' + this.model.get( 'cid' ) + ' svg path{stroke:' + values.highlight_color + '!important}';
				}

				if ( 'highlight' === values.title_type && '' !== values.highlight_top_margin && bottomHighlights.includes( values.highlight_effect ) ) {
					style += '.fusion-title.fusion-title-cid' + this.model.get( 'cid' ) + ' svg{margin-top:' + values.highlight_top_margin + 'px!important}';
				}

				if ( 'highlight' === values.title_type && '' !== values.highlight_width ) {
					style += '.fusion-title.fusion-title-cid' + this.model.get( 'cid' ) + ' svg path{stroke-width:' + values.highlight_width + '!important}';
				}

				if ( 'rotating' === values.title_type && '' !== values.text_color && ( 'clipIn' === values.rotation_effect || 'typeIn' === values.rotation_effect ) ) {
					style += '.fusion-title.fusion-title-cid' + this.model.get( 'cid' ) + ' .fusion-animated-texts-wrapper::before{background-color:' + values.text_color + '!important}';
				}

				if ( ! ( '' === values.margin_top_mobile && '' === values.margin_bottom_mobile ) && ! ( '0px' === values.margin_top_mobile && '20px' === values.margin_bottom_mobile ) && ( '0px' === values.margin_top_small && '20px' === values.margin_bottom_small ) ) {
					style += '@media only screen and (max-width:' + extras.content_break_point + 'px) {';
					style += '.fusion-body .fusion-title.fusion-title-cid' + this.model.get( 'cid' ) + '{margin-top:' + values.margin_top_mobile + '!important;margin-bottom:' + values.margin_bottom_mobile + '!important;}';
					style += '}';
				}

				// If medium element values are set, use them.
				if ( ! ( '' === values.margin_top_medium && '' === values.margin_bottom_medium ) ) {
					style += '@media only screen and (max-width:' + extras.visibility_medium + 'px) {';
					style += '.fusion-body .fusion-title.fusion-title-cid' + this.model.get( 'cid' ) + '{margin-top:' + values.margin_top_medium + '!important;margin-bottom:' + values.margin_bottom_medium + '!important;}';
					style += '}';
				} else if ( ! ( '' === values.margin_top && '' === values.margin_bottom ) ) {
					// If no medium element values are set, inherit large ones to make sure that not the content breakpoint media query takes over with mobile values.
					style += '@media only screen and (max-width:' + extras.visibility_medium + 'px) {';
					style += '.fusion-body .fusion-title.fusion-title-cid' + this.model.get( 'cid' ) + '{margin-top:' + values.margin_top + '!important;margin-bottom:' + values.margin_bottom + '!important;}';
					style += '}';
				}

				if ( ! ( '' === values.margin_top_small && '' === values.margin_bottom_small ) ) {
					style += '@media only screen and (max-width:' + extras.visibility_small + 'px) {';
					style += '.fusion-body .fusion-title.fusion-title-cid' + this.model.get( 'cid' ) + '{margin-top:' + values.margin_top_small + '!important;margin-bottom:' + values.margin_bottom_small + '!important;}';
					style += '}';
				}

				style += '</style>';

				return style;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildAttr: function( values ) {
				var styles,
					titleSize = 'two',
					attr      = _.fusionVisibilityAtts( values.hide_on_mobile, {
						class: 'fusion-title title fusion-title-cid' + this.model.get( 'cid' ),
						style: ''
					} );

				attr[ 'class' ] += _.fusionGetStickyClass( values.sticky_display );

				if ( -1 !== values.style_type.indexOf( 'underline' ) ) {
					styles = values.style_type.split( ' ' );

					_.each( styles, function( style ) {
						attr[ 'class' ] += ' sep-' + style;
					} );

					if ( values.sep_color ) {
						attr.style = 'border-bottom-color:' + values.sep_color + ';';
					}
				} else if ( -1 !== values.style_type.indexOf( 'none' ) || 'text' !== values.title_type ) {
					attr[ 'class' ] += ' fusion-sep-none';
				}

				if ( 'center' === values.content_align ) {
					attr[ 'class' ] += ' fusion-title-center';
				}

				if ( '' !== values.title_type ) {
					attr[ 'class' ] += ' fusion-title-' + values.title_type;
				}

				if ( 'text' !== values.title_type && '' !== values.loop_animation ) {
					attr[ 'class' ] += ' fusion-loop-' + values.loop_animation;
				}

				if ( '' !== values.rotation_effect ) {
					attr[ 'class' ] += ' fusion-title-' + values.rotation_effect;
				}

				if ( 'highlight' === values.title_type && '' !== values.highlight_effect ) {
					attr[ 'data-highlight' ] = values.highlight_effect;
					attr[ 'class' ]         += ' fusion-highlight-' + values.highlight_effect;
				}

				if ( '1' == values.size ) {
					titleSize = 'one';
				} else if ( '2' == values.size ) {
					titleSize = 'two';
				} else if ( '3' == values.size ) {
					titleSize = 'three';
				} else if ( '4' == values.size ) {
					titleSize = 'four';
				} else if ( '5' == values.size ) {
					titleSize = 'five';
				} else if ( '6' == values.size ) {
					titleSize = 'six';
				}

				attr[ 'class' ] += ' fusion-title-size-' + titleSize;

				if ( 'undefined' !== typeof values.font_size && '' !== values.font_size ) {
					attr.style += 'font-size:' + values.font_size + ';';
				}

				// Text shadow.
				if ( 'no' !== values.text_shadow ) {
					attr.style += 'text-shadow:' + values.text_shadow + ';';
				}

				if ( '' !== values.margin_top ) {
					attr.style += 'margin-top:' + values.margin_top + ';';
				}

				if ( '' !== values.margin_bottom ) {
					attr.style += 'margin-bottom:' + values.margin_bottom + ';';
				}

				if ( '' === values.margin_top && '' === values.margin_bottom ) {
					attr.style += ' margin-top:0px; margin-bottom:0px';
					attr[ 'class' ] += ' fusion-title-default-margin';
				}

				attr = _.fusionAnimations( values, attr );

				if ( '' !== values[ 'class' ] ) {
					attr[ 'class' ] += ' ' + values[ 'class' ];
				}

				if ( '' !== values.id ) {
					attr.id = values.id;
				}

				return attr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildHeadingAttr: function( values ) {
				var self        = this,
					headingAttr = {
						class: 'title-heading-' + values.content_align,
						style: ''
					};

				if ( 'div' === values.size ) {
					headingAttr[ 'class' ] += ' title-heading-tag';
				}

				headingAttr.style += _.fusionGetFontStyle( 'title_font', values );

				if ( this.flexDisplay() ) {
					if ( values.content_align_medium && values.content_align !== values.content_align_medium ) {
						headingAttr[ 'class' ] += ' md-text-align-' + values.content_align_medium;
					}
					if ( values.content_align_small && values.content_align !== values.content_align_small ) {
						headingAttr[ 'class' ] += ' sm-text-align-' + values.content_align_small;
					}
				}

				if ( '' !== values.margin_top || '' !== values.margin_bottom ) {
					headingAttr.style += 'margin:0;';
				}

				if ( '' !== values.font_size ) {
					headingAttr.style += 'font-size:1em;';
				}

				if ( 'undefined' !== typeof values.line_height && '' !== values.line_height ) {
					headingAttr.style += 'line-height:' + values.line_height + ';';
				}

				if ( 'undefined' !== typeof values.letter_spacing && '' !== values.letter_spacing ) {
					headingAttr.style += 'letter-spacing:' + values.letter_spacing + ';';
				}

				if ( 'undefined' !== typeof values.text_color && '' !== values.text_color ) {
					headingAttr.style += 'color:' + values.text_color + ';';
				}

				if ( '' !== values.style_tag ) {
					headingAttr.style += values.style_tag;
				}

				if ( 'text' === values.title_type ) {
					headingAttr = _.fusionInlineEditor( {
						cid: self.model.get( 'cid' ),
						overrides: {
							color: 'text_color',
							'font-size': 'font_size',
							'line-height': 'line_height',
							'letter-spacing': 'letter_spacing',
							tag: 'size'
						}
					}, headingAttr );
				}

				return headingAttr;
			},

			/**
			 * Builds animation attributes.
			 *
			 * @since 2.1
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildAnimatedAttr: function( values ) {
				var animationAttr = {
						class: 'fusion-animated-texts-wrapper',
						style: ''
					};

				if ( '' !== values.animated_text_color ) {
					animationAttr.style += 'color:' + values.animated_text_color + ';';
				}

				if ( values.animated_font_size ) {
					animationAttr.style += 'font-size:' + values.animated_font_size + ';';
				}

				if ( 'highlight' === values.title_type ) {
					animationAttr[ 'class' ] = 'fusion-highlighted-text';
				}

				if ( 'rotating' === values.title_type ) {
					animationAttr[ 'data-length' ] = this.getAnimationLength( values.rotation_effect );

					if ( '' !== values.display_time ) {
						animationAttr[ 'data-minDisplayTime' ] = values.display_time;
					}

					if ( '' !== values.after_text || ( '' === values.before_text && '' === values.after_text ) ) {
						animationAttr.style += 'text-align: center;';
					}
				}

				return animationAttr;

			},

			/**
			 * Get Animation length.
			 *
			 * @since 2.1
			 * @param {String} effect - The animation effect.
			 * @return {String}
			 */
			getAnimationLength: function ( effect ) {
				var animationLength = '';

				switch ( effect ) {

					case 'flipInX':
					case 'bounceIn':
					case 'zoomIn':
					case 'slideInDown':
					case 'clipIn':
						animationLength = 'line';
						break;

					case 'lightSpeedIn':
						animationLength = 'word';
						break;

					case 'rollIn':
					case 'typeIn':
					case 'fadeIn':
						animationLength = 'char';
						break;
				}

				return animationLength;
			},

			/**
			 * Builds rotated text attributes.
			 *
			 * @since 2.1
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildRotatedAttr: function( values ) {
				var effect    = values.rotation_effect,
					rotatedAttr = {
						class: 'fusion-animated-text',
						style: ''
					};

				rotatedAttr[ 'data-in-effect' ]   = effect;
				rotatedAttr[ 'data-in-sequence' ] = 'true';
				rotatedAttr[ 'data-out-reverse' ] = 'true';

				effect = effect.replace( 'In', 'Out' );
				effect = effect.replace( 'Down', 'Up' );

				rotatedAttr[ 'data-out-effect' ] = effect;

				return rotatedAttr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			builderSeparatorAttr: function( values ) {
				var separatorAttr = {
						class: 'title-sep'
					},
					styles        = values.style_type.split( ' ' );

				_.each( styles, function( style ) {
					separatorAttr[ 'class' ] += ' sep-' + style;
				} );

				if ( values.sep_color ) {
					separatorAttr.style = 'border-color:' + values.sep_color + ';';
				}

				return separatorAttr;
			},

			onCancel: function() {
				this.resetTypography();
			},

			afterPatch: function() {
				this.resetTypography();
				this.refreshJs();
			},

			refreshJs: function() {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-element-render-fusion_title', this.model.attributes.cid );
			},

			resetTypography: function() {
				jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'fusion-typography-reset', this.model.get( 'cid' ) );

				if ( 800 > jQuery( '#fb-preview' ).width() ) {
					setTimeout( function() {
						jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( 'body' ).trigger( 'resize' );
					}, 50 );
				}
			}
		} );
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Testimonials parent View.
		FusionPageBuilder.fusion_testimonials = FusionPageBuilder.ParentElementView.extend( {

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {

				// TODO: save DOM and apply instead of generating
				this.generateChildElements();

				this._refreshJs();
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				this.validateValues( atts.values );

				attributes.styles         = this.buildStyles( atts.values );
				attributes.attr           = this.buildAttr( atts.values );
				attributes.paginationAttr = this.buildPaginationAttr( atts.values );
				attributes.navigation     = atts.values.navigation;

				return attributes;
			},

			/**
			 * Modifies the values.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {void}
			 */
			validateValues: function( values ) {
				values.random = ( 'yes' === values.random || '1' === values.random ) ? 1 : 0;

				if ( 'clean' === values.design && '' === values.navigation ) {
					values.navigation = 'yes';
				} else if ( 'classic' === values.design && '' === values.navigation ) {
					values.navigation = 'no';
				}
			},

			buildStyles: function( values ) {
				var styles = '',
					cid = this.model.get( 'cid' );

				styles += '#fusion-testimonials-cid' + cid + ' a{border-color:' + values.textcolor + ';}';
				styles += '#fusion-testimonials-cid' + cid + ' a:hover, #fusion-testimonials-cid' + cid + ' .activeSlide{background-color: ' + values.textcolor + ';}';
				styles += '.fusion-testimonials.' + values.design + '.fusion-testimonials-cid' + cid + ' .author:after{border-top-color:' + values.backgroundcolor + ' !important;}';

				return styles;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildAttr: function( values ) {
				var attr = _.fusionVisibilityAtts( values.hide_on_mobile, {
					class: 'fusion-testimonials ' + values.design + ' fusion-testimonials-cid' + this.model.get( 'cid' ) + ' ' + values[ 'class' ]
				} );

				attr[ 'data-random' ] = values.random;
				attr[ 'data-speed' ]  = values.speed;

				attr.id = values.id;

				return attr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @return {Object}
			 */
			buildPaginationAttr: function() {
				var paginationAttr = {
					class: 'testimonial-pagination',
					id: 'fusion-testimonials-cid' + this.model.get( 'cid' )
				};
				return paginationAttr;
			}

		} );
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Counter circle child View.
		FusionPageBuilder.fusion_testimonial = FusionPageBuilder.ChildElementView.extend( {

			/**
			 * Runs during render() call.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			onRender: function() {
				if ( 'undefined' !== typeof this.model.attributes.selectors ) {
					this.model.attributes.selectors[ 'class' ] += ' ' + this.className;
					this.setElementAttributes( this.$el, this.model.attributes.selectors );
				}
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {

				if ( 'undefined' !== typeof this.model.attributes.selectors ) {
					this.model.attributes.selectors[ 'class' ] += ' ' + this.className;
					this.setElementAttributes( this.$el, this.model.attributes.selectors );
				}

				this._refreshJs();
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				this.validateValues( atts.values );
				this.buildReviewAttr( atts.values );

				attributes.values = atts.values;
				attributes.parentValues = atts.parentValues;

				attributes.imageAttr      = this.buildImageAttr( atts.values );
				attributes.thumbnailAttr  = this.buildThumbnailAttr( atts );
				attributes.blockquoteAttr = this.buildBlockquoteAttr( atts );
				attributes.quoteAttr      = this.buildQuoteAttr( atts );
				attributes.authorAttr     = this.buildAuthorAttr( atts );

				attributes.cid     = this.model.get( 'cid' );
				attributes.parent  = this.model.get( 'parent' );
				attributes.content = atts.values.element_content;

				return attributes;
			},

			/**
			 * Modifies the values.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {void}
			 */
			validateValues: function( values ) {

				if ( 'round' === values.image_border_radius ) {
					values.image_border_radius = '50%';
				} else {
					values.image_border_radius = _.fusionValidateAttrValue( values.image_border_radius, 'px' );
				}

				// Check for deprecated.
				if ( 'undefined' !== typeof values.gender && '' !== values.gender ) {
					values.avatar = values.gender;
				}

				if ( 'image' === values.avatar && ! values.image ) {
					values.avatar = 'none';
				}
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildReviewAttr: function( values ) {
				var reviewAttr = {
					class: 'review '
				};

				if ( 'none' === values.avatar ) {
					reviewAttr[ 'class' ] += 'no-avatar';
				} else if ( 'image' === values.avatar ) {
					reviewAttr[ 'class' ] += 'avatar-image';
				} else {
					reviewAttr[ 'class' ] += values.avatar;
				}

				this.model.set( 'selectors', reviewAttr );
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildImageAttr: function( values ) {
				var imageAttr = {
					class: 'testimonial-image',
					src: values.image,
					alt: ''
				};

				if ( 'image' === values.avatar ) {
					imageAttr.style = '-webkit-border-radius: ' + values.image_border_radius + ';-moz-border-radius: ' + values.image_border_radius + ';border-radius: ' + values.image_border_radius + ';';
				}

				return imageAttr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			buildThumbnailAttr: function( atts ) {
				var values = atts.values,
					parentValues = atts.parentValues,
					thumbnailAttr = {
						class: 'testimonial-thumbnail'
					};

				if ( 'image' !== values.avatar ) {
					thumbnailAttr[ 'class' ] += ' doe';
					thumbnailAttr.style = 'color:' + parentValues.textcolor + ';';
				}

				return thumbnailAttr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			buildBlockquoteAttr: function( atts ) {
				var parentValues = atts.parentValues,
					blockquoteAttr = {
						style: 'background-color:' + parentValues.backgroundcolor + ';'
					};

				if ( 'clean' === parentValues.design && ( 'transparent' === parentValues.backgroundcolor || 0 === jQuery.Color( parentValues.backgroundcolor ).alpha() ) ) {
					blockquoteAttr.style += 'margin: -25px;';
				}

				return blockquoteAttr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			buildQuoteAttr: function( atts ) {
				var parentValues = atts.parentValues,
					quoteAttr = {
						style: 'background-color:' + parentValues.backgroundcolor + ';color:' + parentValues.textcolor + ';'
					};

				return quoteAttr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			buildAuthorAttr: function( atts ) {
				var parentValues = atts.parentValues,
					authorAttr = {
						class: 'author',
						style: 'color:' + parentValues.textcolor + ';'
					};

				return authorAttr;
			}
		} );
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Tooltip View.
		FusionPageBuilder.fusion_tooltip = FusionPageBuilder.ElementView.extend( {

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {
				this._refreshJs();
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Create attribute objects.
				attributes.attr = this.buildAttr( atts.values );

				// Any extras that need passed on.
				attributes.cid     = this.model.get( 'cid' );
				attributes.content = atts.values.element_content;

				return attributes;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object} - Returns the attributes.
			 */
			buildAttr: function( values ) {
				var attr = {
					class: 'fusion-tooltip tooltip-shortcode ' + values[ 'class' ]
				};

				attr.id = values.id;

				attr[ 'data-animation' ] = values.animation;
				attr[ 'data-delay' ]     = values.delay;
				attr[ 'data-placement' ] = values.placement;
				attr.title             = values.title;
				attr[ 'data-title' ]     = values.title;
				attr[ 'data-toggle' ]    = 'tooltip';
				attr[ 'data-trigger' ]   = values.trigger;

				return attr;
			}
		} );
	} );
}( jQuery ) );
;/* global cssua */
/* jshint -W107 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Sharing Box View.
		FusionPageBuilder.fusion_sharing = FusionPageBuilder.ElementView.extend( {

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			beforePatch: function() {
				var tooltips = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( this.$el ).find( '.fusion-social-networks [data-toggle="tooltip"]' );

				tooltips.tooltip( 'destroy' );
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {
				var tooltips = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( this.$el ).find( '.fusion-social-networks [data-toggle="tooltip"]' );

				setTimeout( function() {
					tooltips.tooltip( {
						container: 'body'
					} );
				}, 150 );

			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Validate values and extras.
				this.validateValuesExtras( atts.values, atts.extras );

				// Create attribute objects.
				attributes.shortcodeAttr      = this.buildShortcodeAttr( atts.values );
				attributes.socialNetworksAttr = this.buildSocialNetworksAttr( atts.values );
				attributes.taglineAttr        = this.buildTaglineAttr( atts.values );
				attributes.icons              = this.buildIcons( atts.values );
				attributes.tagline            = atts.values.tagline;

				return attributes;
			},

			/**
			 * Modifies the values.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @param {Object} extras - Extra args.
			 * @return {void}
			 */
			validateValuesExtras: function( values, extras ) {
				extras.linktarget         = extras.linktarget ? '_blank' : '_self';
				values.icons_boxed_radius = _.fusionValidateAttrValue( values.icons_boxed_radius, 'px' );
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildShortcodeAttr: function( values ) {
				var sharingboxShortcode = _.fusionVisibilityAtts( values.hide_on_mobile, {
					class: 'share-box fusion-sharing-box'
				} );

				sharingboxShortcode[ 'class' ] += _.fusionGetStickyClass( values.sticky_display );

				if ( 'yes' === values.icons_boxed ) {
					sharingboxShortcode[ 'class' ] += ' boxed-icons';
				}

				if ( '' !== values.backgroundcolor ) {
					sharingboxShortcode.style = 'background-color:' + values.backgroundcolor + ';';

					if ( 'transparent' === values.backgroundcolor || 0 === jQuery.Color( values.backgroundcolor ).alpha() ) {
						sharingboxShortcode.style += 'padding:0;';
					}
				}

				if ( '' !== values[ 'class' ] ) {
					sharingboxShortcode[ 'class' ] += ' ' + values[ 'class' ];
				}

				if ( '' !== values.id ) {
					sharingboxShortcode[ 'class' ] += ' ' + values.id;
				}

				sharingboxShortcode[ 'data-title' ]       = values.title;
				sharingboxShortcode[ 'data-description' ] = values.description;
				sharingboxShortcode[ 'data-link' ]        = values.link;
				sharingboxShortcode[ 'data-image' ]       = values.pinterest_image;

				return sharingboxShortcode;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildSocialNetworksAttr: function( values ) {
				var sharingboxShortcodeSocialNetworks = {
					class: 'fusion-social-networks'
				};

				if ( 'yes' === values.icons_boxed ) {
					sharingboxShortcodeSocialNetworks[ 'class' ] += ' boxed-icons';
				}

				if ( '' === values.tagline ) {
					sharingboxShortcodeSocialNetworks.style = 'text-align: inherit;';
				}

				return sharingboxShortcodeSocialNetworks;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildTaglineAttr: function( values ) {
				var sharingboxShortcodeTagline = {
						class: 'tagline'
					},
					that = this;

				if ( '' !== values.tagline_color ) {
					sharingboxShortcodeTagline.style = 'color:' + values.tagline_color + ';';
				}

				sharingboxShortcodeTagline = _.fusionInlineEditor( {
					param: 'tagline',
					cid: that.model.get( 'cid' ),
					toolbar: false
				}, sharingboxShortcodeTagline );

				return sharingboxShortcodeTagline;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildIconAttr: function( values ) {
				var sharingboxShortcodeTagline = {
					class: 'tagline'
				};

				if ( '' !== values.tagline_color ) {
					sharingboxShortcodeTagline.style = 'color:' + values.tagline_color + ';';
				}

				return sharingboxShortcodeTagline;
			},

			/**
			 * Builds HTML for the icons.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @param {Object} extras - Extra args.
			 * @return {string}
			 */
			buildIcons: function( values ) {
				var icons            = '',
					iconColors       = values.icon_colors,
					boxColors        = values.box_colors,
					useBrandColors   = false,
					numOfIconColors,
					numOfBoxColors,
					socialNetworks,
					socialNetworksCount,
					i,
					description,
					link,
					title,
					image,
					socialLink,
					sharingboxShortcodeIcon,
					iconOptions,
					socialIconBoxedColors,
					network,
					tooltip;

				if ( 'brand' === values.color_type ) {
					useBrandColors = true;

					// Get a list of all the available social networks.
					socialIconBoxedColors = _.fusionSocialIcons( false, true );
					socialIconBoxedColors.mail = {
						label: 'Email Address',
						color: '#000000'
					};

				}

				iconColors = iconColors.split( '|' );
				boxColors  = boxColors.split( '|' );

				numOfIconColors     = iconColors.length;
				numOfBoxColors      = boxColors.length;
				socialNetworks      = values.social_networks.split( '|' );
				socialNetworksCount = socialNetworks.length;

				for ( i = 0; i < socialNetworksCount; i++ ) {
					network = socialNetworks[ i ];

					if ( true === useBrandColors ) {
						iconOptions = {
							social_network: network,
							icon_color: ( 'yes' === values.icons_boxed ) ? '#ffffff' : socialIconBoxedColors[ network ].color,
							box_color: ( 'yes' === values.icons_boxed ) ? socialIconBoxedColors[ network ].color : ''
						};

					} else {
						iconOptions = {
							social_network: network,
							icon_color: i < iconColors.length ? iconColors[ i ] : '',
							box_color: i < boxColors.length ? boxColors[ i ] : ''
						};

						if ( 1 === numOfIconColors ) {
							iconOptions.icon_color = iconColors[ 0 ];
						}
						if ( 1 === numOfBoxColors ) {
							iconOptions.box_color = boxColors[ 0 ];
						}
					}

					// sharingboxShortcodeIcon attributes
					description = values.description;
					link        = values.link;
					title       = values.title;
					image       = _.fusionRawUrlEncode( values.pinterest_image );

					sharingboxShortcodeIcon = {
						class: 'fusion-social-network-icon fusion-tooltip fusion-' + iconOptions.social_network + ' fusion-icon-' + iconOptions.social_network
					};

					socialLink = '';
					switch ( iconOptions.social_network ) {
					case 'facebook':
						socialLink = 'https://m.facebook.com/sharer.php?u=' + link;
						if ( cssua.ua.mobile ) {
							socialLink = 'http://www.facebook.com/sharer.php?m2w&s=100&p&#91;url&#93;=' + link + '&p&#91;images&#93;&#91;title&#93;=' + _.fusionRawUrlEncode( title );
						}
						break;
					case 'twitter':
						socialLink = 'https://twitter.com/share?text=' + _.fusionRawUrlEncode( title ) + '&url=' + _.fusionRawUrlEncode( link );
						break;
					case 'linkedin':
						socialLink = 'https://www.linkedin.com/shareArticle?mini=true&url=' + _.fusionRawUrlEncode( link ) + '&amp;title=' + _.fusionRawUrlEncode( title ) + '&amp;summary=' + _.fusionRawUrlEncode( description );
						break;
					case 'reddit':
						socialLink = 'http://reddit.com/submit?url=' + link + '&amp;title=' + title;
						break;
					case 'tumblr':
						socialLink = 'http://www.tumblr.com/share/link?url=' + _.fusionRawUrlEncode( link ) + '&amp;name=' + _.fusionRawUrlEncode( title ) + '&amp;description=' + _.fusionRawUrlEncode( description );
						break;
					case 'pinterest':
						socialLink = 'http://pinterest.com/pin/create/button/?url=' + _.fusionRawUrlEncode( link ) + '&amp;description=' + _.fusionRawUrlEncode( description ) + '&amp;media=' + image;
						break;
					case 'vk':
						socialLink = 'http://vkontakte.ru/share.php?url=' + _.fusionRawUrlEncode( link ) + '&amp;title=' + _.fusionRawUrlEncode( title ) + '&amp;description=' + _.fusionRawUrlEncode( description );
						break;
					case 'mail':
						socialLink = 'mailto:?subject=' + _.fusionRawUrlEncode( title ) + '&body=' + _.fusionRawUrlEncode( link );
						break;
					}

					sharingboxShortcodeIcon.href   = socialLink;
					sharingboxShortcodeIcon.target = ( values.linktarget && 'mail' !== iconOptions.social_network ) ? '_blank' : '_self';

					if ( '_blank' === sharingboxShortcodeIcon.target ) {
						sharingboxShortcodeIcon.rel = 'noopener noreferrer';
					}

					sharingboxShortcodeIcon.style = ( iconOptions.icon_color ) ? 'color:' + iconOptions.icon_color + ';' : '';

					if ( values.icons_boxed && 'yes' === values.icons_boxed && iconOptions.box_color ) {
						sharingboxShortcodeIcon.style += 'background-color:' + iconOptions.box_color + ';border-color:' + iconOptions.box_color + ';';
					}

					if ( ( 'yes' === values.icons_boxed && values.icons_boxed_radius ) || '0' === values.icons_boxed_radius ) {
						if ( 'round' === values.icons_boxed_radius ) {
							values.icons_boxed_radius = '50%';
						}
						sharingboxShortcodeIcon.style += 'border-radius:' + values.icons_boxed_radius + ';';
					}

					sharingboxShortcodeIcon[ 'data-placement' ] = values.tooltip_placement;
					tooltip = iconOptions.social_network;

					sharingboxShortcodeIcon[ 'data-title' ] = _.fusionUcFirst( tooltip );
					sharingboxShortcodeIcon.title         = _.fusionUcFirst( tooltip );
					sharingboxShortcodeIcon[ 'aria-label' ] = _.fusionUcFirst( tooltip );

					if ( 'none' !== values.tooltip_placement ) {
						sharingboxShortcodeIcon[ 'data-toggle' ] = 'tooltip';
					}
					icons += '<a ' + _.fusionGetAttributes( sharingboxShortcodeIcon ) + '></a>';
				}

				return icons;
			}

		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderApp, fusionAllElements */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Section separator view.
		FusionPageBuilder.fusion_section_separator = FusionPageBuilder.ElementView.extend( {

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			onRender: function() {
				this.afterPatch();
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() { // eslint-disable-line no-empty-function
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Validate values.
				this.validateValues( atts.values );

				this.extras = atts.extras;

				// Create attribute objects
				attributes.attr             = this.buildAtts( atts.values );
				attributes.attrSvgWrapper   = this.buildSvgWrapperAtts( atts.values );
				attributes.attrSpacer       = this.buildSpacerAtts( atts.values );
				attributes.attrSpacerHeight = this.buildSpacerHeightAtts( atts.values );
				attributes.attrCandyArrow   = this.buildCandyArrowAtts( atts.values );
				attributes.attrCandy        = this.buildCandyAtts( atts.values );
				attributes.attrSVG          = this.buildSVGAtts( atts.values );
				attributes.attrButton       = this.buildButtonAtts( atts.values );
				attributes.attrRoundedSplit = this.buildRoundedSplitAtts( atts.values );
				attributes.values           = atts.values;

				return attributes;
			},

			/**
			 * Modifies the values.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {void}
			 */
			validateValues: function( values ) {
				if ( ! isNaN( values.bordersize ) ) {
					values.bordersize = _.fusionGetValueWithUnit( values.bordersize );
				}

				values.borderSizeWithoutUnits = parseInt( values.bordersize.match( /\d+/ ), 10 );

				if ( 'horizon' === values.divider_type ) {
					values.yMin = 'top' === values.divider_candy ? '-0.5' : '0';
				} else if ( 'hills_opacity' === values.divider_type ) {
					values.yMin = 'top' === values.divider_candy ? '-0.5' : '0';
				} else if ( 'waves' === values.divider_type ) {
					values.yMin = 'top' === values.divider_candy ? '54' : '1';
				} else if ( 'waves_opacity' === values.divider_type ) {
					values.yMin = 'top' === values.divider_candy ? '0' : '1';
				}
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildAtts: function( values ) {
				var attr = _.fusionVisibilityAtts( values.hide_on_mobile, {
						class: 'fusion-section-separator section-separator ' + values.divider_type + ' fusion-section-separator-' + this.model.get( 'cid' ),
						style: ''
					} );

				if ( 'rounded-split' === values.divider_type ) {
					attr[ 'class' ] += ' rounded-split-separator';
				}

				if ( '' !== values[ 'class' ] ) {
					attr[ 'class' ] += ' ' + values[ 'class' ];
				}

				if ( '' !== values.id ) {
					attr.id = values.id;
				}

				return attr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 3.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildSvgWrapperAtts: function( values ) {
				var attr = {
						class: 'fusion-section-separator-svg'
					},
					parentContainernView  = FusionPageBuilderApp.getParentContainer( this ),
					parentContainerValues = 'undefined' !== typeof parentContainernView.values ? parentContainernView.values : {},
					parentColumnView      = FusionPageBuilderApp.getParentColumn( this ),
					parentColumnValues    = 'undefined' !== typeof parentColumnView.values ? parentColumnView.values : {},
					extras                = jQuery.extend( true, {}, fusionAllElements.fusion_section_separator.extras ),
					self                  = this,
					paddingValueLeft      = '',
					paddingValueRight     = '',
					columnOuterWidth      = jQuery( parentColumnView.$el ).width(),
					columnWidth           = jQuery( parentColumnView.$el ).children( '.fusion-column-wrapper' ).width();

					if ( 'triangle' === values.divider_type ) {
						if ( '' !== values.bordercolor ) {
							if ( 'bottom' === values.divider_candy ) {
								attr.style = 'border-bottom:' + values.bordersize + ' solid ' + values.bordercolor + ';';
							} else if ( 'top' === values.divider_candy ) {
								attr.style = 'border-top:' + values.bordersize + ' solid ' + values.bordercolor + ';';
							} else if ( -1 !== values.divider_candy.indexOf( 'top' ) && -1 !== values.divider_candy.indexOf( 'bottom' ) ) {
								attr.style = 'border:' + values.bordersize + ' solid ' + values.bordercolor + ';';
							}
						}
					} else if ( 'bigtriangle' === values.divider_type || 'slant' === values.divider_type || 'big-half-circle' === values.divider_type || 'clouds' === values.divider_type || 'curved' === values.divider_type ) {
						attr.style = 'padding:0;';
					} else if ( 'horizon' === values.divider_type || 'waves' === values.divider_type || 'waves_opacity' === values.divider_type || 'hills' === values.divider_type || 'hills_opacity' === values.divider_type ) {
						attr.style = 'font-size:0;line-height:0;';
					}

					values.additional_styles = '';

					if ( _.isObject( parentColumnValues ) ) {
						if ( FusionPageBuilderApp.$el.find( '#main' ).hasClass( 'width-100' ) && '1_1' === parentColumnValues.type ) {
							if ( 'boxed' === extras.layout && _.isObject( parentContainerValues ) ) {
								_.each( [ 'large', 'medium', 'small' ], function( size ) {
									if ( 'large' === size ) {
										values.additional_styles += '.fusion-section-separator-' + self.model.get( 'cid' ) + ' .fusion-section-separator-svg {';
										values.additional_styles += 'position: relative;';
										values.additional_styles += 'margin-left:-' + parentContainerValues.padding_left + ';';
										values.additional_styles += 'margin-right:-' + parentContainerValues.padding_right + ';';
										values.additional_styles += '}';
									} else if ( ( 'undefined' !== typeof parentContainerValues[ 'padding_left_' + size ] && ! _.isEmpty( parentContainerValues[ 'padding_left_' + size ] ) ) || ( 'undefined' !== typeof parentContainerValues[ 'padding_right_' + size ] && ! _.isEmpty( parentContainerValues[ 'padding_right_' + size ] ) ) ) {
										// Medium and Small size screen styles.
										values.additional_styles += '@media only screen and (max-width:' + extras[ 'visibility_' + size ] + 'px) {';
										values.additional_styles += '.fusion-section-separator-' + self.model.get( 'cid' ) + ' .fusion-section-separator-svg {';
										values.additional_styles += 'margin-left:-' + parentContainerValues[ 'padding_left_' + size ] + ';';
										values.additional_styles += 'margin-right:-' + parentContainerValues[ 'padding_right_' + size ] + ';';
										values.additional_styles += '}';
										values.additional_styles += '}';
									}
								} );

							} else {
								attr[ 'class' ] += ' fusion-section-separator-fullwidth';
							}
						}
						if ( ! ( FusionPageBuilderApp.$el.find( '#main' ).hasClass( 'width-100' ) && 'boxed' === extras.layout ) ) {
							if ( '1_1' === parentColumnValues.type ) {
								if ( 'undefined' !== typeof parentColumnValues.upsized_spacing_left && 'undefined' !== typeof parentColumnValues.upsized_spacing_left_medium && 'undefined' !== typeof parentColumnValues.upsized_spacing_left_small ) {
									_.each( [ 'large', 'medium', 'small' ], function( size ) {
										if ( 'large' === size ) {
											if ( ! _.isEmpty( parentColumnValues.upsized_spacing_left ) ) {
												values.additional_styles += '.fusion-section-separator-' + self.model.get( 'cid' ) + ' .fusion-section-separator-svg {';
												values.additional_styles += 'margin-left:-' + parentColumnValues.upsized_spacing_left + ';';
												values.additional_styles += 'margin-right:-' + parentColumnValues.upsized_spacing_right + ';';
												values.additional_styles += '}';
											}
										} else if ( ! _.isEmpty( parentColumnValues[ 'upsized_spacing_left_' + size ] ) ) {
											// Medium and Small size screen styles.
											values.additional_styles += '@media only screen and (max-width:' + extras[ 'visibility_' + size ] + 'px) {';
											values.additional_styles += '.fusion-section-separator-' + self.model.get( 'cid' ) + ' .fusion-section-separator-svg {';
											values.additional_styles += 'margin-left:-' + parentColumnValues[ 'upsized_spacing_left_' + size ] + ' !important;';
											values.additional_styles += 'margin-right:-' + parentColumnValues[ 'upsized_spacing_right_' + size ] +  ' !important;';
											values.additional_styles += '}';
											values.additional_styles += '}';
										}
									} );
								}
							} else {
								_.each( [ 'large', 'medium', 'small' ], function( size ) {
									if ( 'large' === size ) {
										if ( ! _.isEmpty( parentColumnValues.padding_left ) ) {
											paddingValueLeft = parentColumnValues.padding_left;
											if ( -1 !== paddingValueLeft.indexOf( '%' ) ) {
												paddingValueLeft = ( parseFloat( paddingValueLeft.replace( '%', '' ) ) / ( columnWidth / columnOuterWidth ) ) + '%';
											}

											paddingValueRight = parentColumnValues.padding_right;
											if ( -1 !== paddingValueRight.indexOf( '%' ) ) {
												paddingValueRight = ( parseFloat( paddingValueRight.replace( '%', '' ) ) / ( columnWidth / columnOuterWidth ) ) + '%';
											}

											values.additional_styles += '.fusion-section-separator-' + self.model.get( 'cid' ) + ' .fusion-section-separator-svg {';
											values.additional_styles += 'margin-left:-' + paddingValueLeft + ';';
											values.additional_styles += 'margin-right:-' + paddingValueRight + ';';
											values.additional_styles += '}';
										}
									} else if ( ! _.isEmpty( parentColumnValues[ 'padding_left_' + size ] ) ) {
										// Medium and Small size screen styles.

										paddingValueLeft = parentColumnValues[ 'padding_left_' + size ];
										if ( -1 !== paddingValueLeft.indexOf( '%' ) ) {
											paddingValueLeft = ( parseFloat( paddingValueLeft.replace( '%', '' ) ) / ( columnWidth / columnOuterWidth ) ) + '%';
										}

										paddingValueRight = parentColumnValues[ 'padding_right_' + size ];
										if ( -1 !== paddingValueRight.indexOf( '%' ) ) {
											paddingValueRight = ( parseFloat( paddingValueRight.replace( '%', '' ) ) / ( columnWidth / columnOuterWidth ) ) + '%';
										}

										values.additional_styles += '@media only screen and (max-width:' + extras[ 'visibility_' + size ] + 'px) {';
										values.additional_styles += '.fusion-section-separator-' + self.model.get( 'cid' ) + ' .fusion-section-separator-svg {';
										values.additional_styles += 'margin-left:-' + paddingValueLeft + ' !important;';
										values.additional_styles += 'margin-right:-' + paddingValueRight +  ' !important;';
										values.additional_styles += '}';
										values.additional_styles += '}';
									}
								} );
							}
						}
					}

				return attr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 3.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildSpacerAtts: function( values ) { // eslint-disable-line no-unused-vars
				var attrSpacer = {
						class: 'fusion-section-separator-spacer'
					},
					parentColumnView   = FusionPageBuilderApp.getParentColumn( this ),
					parentColumnValues = 'undefined' !== typeof parentColumnView.values ? parentColumnView.values : {},
					extras             = jQuery.extend( true, {}, fusionAllElements.fusion_section_separator.extras );

				// 100% width template && 1/1 column.
				if ( FusionPageBuilderApp.$el.find( '#main' ).hasClass( 'width-100' ) && 'undefined' !== typeof parentColumnValues.type && '1_1' === parentColumnValues.type ) {
					if ( 'wide' === extras.layout ) {
						attrSpacer[ 'class' ] += ' fusion-section-separator-fullwidth';
					} else {
						attrSpacer.style = 'display: none;';
					}
				}

				return attrSpacer;

			},

			/**
			 * Builds attributes.
			 *
			 * @since 3.0
			 * @param {Object} v//alues - The values.
			 * @return {Object}//
			 */
			buildSpacerHeightAtts: function( values ) {
				var attrSpacerHeight = {
						class: 'fusion-section-separator-spacer-height'
					},
					hundredPxSeparators = [ 'slant', 'bigtriangle', 'curved', 'big-half-circle', 'clouds' ];

				if ( -1 !== jQuery.inArray( values.divider_type, hundredPxSeparators ) ) {
					attrSpacerHeight.style = 'height:99px;';
				} else if ( 'triangle' === values.divider_type ) {
					if ( values.bordercolor ) {
						if ( 'bottom' === values.divider_candy || 'top' === values.divider_candy ) {
							attrSpacerHeight.style = 'height:' + values.bordersize + ';';
						} else if ( -1 !== values.divider_candy.indexOf( 'top' ) && -1 !== values.divider_candy.indexOf( 'bottom' ) ) {
							attrSpacerHeight.style = 'height:calc( ' + values.bordersize + ' * 2 );';
						}
					}
				} else if ( 'rounded-split' === values.divider_type ) {
					attrSpacerHeight.style = 'height:71px;';
				} else if ( 'hills_opacity' === values.divider_type ) {
					attrSpacerHeight.style = 'padding-top:' + ( 182 / 1024 * 100 ) + '%;';
				} else if ( 'hills' === values.divider_type ) {
					attrSpacerHeight.style = 'padding-top:' + ( 107 / 1024 * 100 ) + '%;';
				} else if ( 'horizon' === values.divider_type ) {
					attrSpacerHeight.style = 'padding-top:' + ( 178 / 1024 * 100 ) + '%;';
				} else if ( 'waves_opacity' === values.divider_type ) {
					attrSpacerHeight.style = 'padding-top:' + ( 216 / 1024 * 100 ) + '%;';
				} else if ( 'waves' === values.divider_type ) {
					attrSpacerHeight.style = 'padding-top:' + ( 162 / 1024 * 100 ) + '%;';
				}
				return attrSpacerHeight;

			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} v//alues - The values.
			 * @return {Object}//
			 */
			buildCandyAtts: function( values ) {
				var attrCandy = {
					class: 'divider-candy'
				};

				if ( 'bottom' === values.divider_candy ) {
					attrCandy[ 'class' ] += ' bottom';
					attrCandy.style = 'bottom:-' + ( values.borderSizeWithoutUnits + 20 ) + 'px;border-bottom:1px solid ' + values.bordercolor + ';border-left:1px solid ' + values.bordercolor + ';';
				} else if ( 'top' === values.divider_candy ) {
					attrCandy[ 'class' ] += ' top';
					attrCandy.style = 'top:-' + ( values.borderSizeWithoutUnits + 20 ) + 'px;border-bottom:1px solid ' + values.bordercolor + ';border-left:1px solid ' + values.bordercolor + ';';

					// Modern setup, that won't work in IE8.
				} else if ( -1 !== values.divider_candy.indexOf( 'top' ) && -1 !== values.divider_candy.indexOf( 'bottom' ) ) {
					attrCandy[ 'class' ] += ' both';
					attrCandy.style = 'background-color:' + values.backgroundcolor + ';border:1px solid ' + values.bordercolor + ';';
				}

				if ( -1 !== values.divider_candy.indexOf( 'top' ) && -1 !== values.divider_candy.indexOf( 'bottom' ) ) {
					attrCandy[ 'class' ] += ' triangle';
				}
				return attrCandy;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildCandyArrowAtts: function( values ) {
				var attrCandyArrow = {
					class: 'divider-candy-arrow'
				};

				// For borders of size 1, we need to hide the border line on the arrow, thus we set it to 0.
				var arrowPosition = values.borderSizeWithoutUnits;
				if ( 1 === arrowPosition ) {
					arrowPosition = 0;
				}

				if ( 'bottom' === values.divider_candy ) {
					attrCandyArrow[ 'class' ] += ' bottom';
					attrCandyArrow.style  = 'top:' + arrowPosition + 'px;border-top-color: ' + values.backgroundcolor + ';';
				} else if ( 'top' === values.divider_candy ) {
					attrCandyArrow[ 'class' ] += ' top';
					attrCandyArrow.style  = 'bottom:' + arrowPosition + 'px;border-bottom-color: ' + values.backgroundcolor + ';';
				}

				return attrCandyArrow;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildSVGAtts: function( values ) {
				var attrSVG = {
					display: 'block'
				};

				if ( 'bigtriangle' === values.divider_type || 'slant' === values.divider_type || 'big-half-circle' === values.divider_type || 'clouds' === values.divider_type || 'curved' === values.divider_type ) {
					attrSVG.style = 'fill:' + values.backgroundcolor + ';padding:0;';
				}
				if ( 'slant' === values.divider_type && 'bottom' === values.divider_candy ) {
					attrSVG.style = 'fill:' + values.backgroundcolor + ';padding:0;margin-bottom:-3px;display:block';
				}

				if ( 'horizon' === values.divider_type || 'hills' === values.divider_type || 'hills_opacity' === values.divider_type || 'waves' === values.divider_type || 'waves_opacity' === values.divider_type ) {
					attrSVG.style = 'fill:' + values.backgroundcolor;
				}

				return attrSVG;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildButtonAtts: function( values ) {
				var attrButton = {};

				if ( '' !== values.icon ) {
					attrButton = {
						class: 'section-separator-icon icon ' + _.fusionFontAwesome( values.icon ),
						style: 'color:' + values.icon_color + ';'
					};

					if ( ! values.icon_color ) {
						values.icon_color = values.bordercolor;
					}

					if ( 1 < values.borderSizeWithoutUnits ) {
						if ( 'bottom' === values.divider_candy ) {
							attrButton.style += 'bottom:-' + ( values.borderSizeWithoutUnits + 10 ) + 'px;top:auto;';
						} else if ( 'top' === values.divider_candy ) {
							attrButton.style += 'top:-' + ( values.borderSizeWithoutUnits + 10 ) + 'px;';
						}
					}
				}

				return attrButton;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildRoundedSplitAtts: function( values ) {
				var attrRoundedSplit = {};

				if ( 'rounded-split' === values.divider_type ) {
					attrRoundedSplit = {
						class: 'rounded-split ' + values.divider_candy,
						style: 'background-color:' + values.backgroundcolor + ';'
					};
				}

				return attrRoundedSplit;
			}

		} );
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Modal view.
		FusionPageBuilder.fusion_modal = FusionPageBuilder.ElementView.extend( {

			/**
			 * Runs during initialize() call.
			 *
			 * @since 2.0.0
			 * @return null
			 */
			onInit: function() {
				var $modal = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( this.$el );

				$modal.on( 'shown.bs.modal', function() {
					jQuery( 'body' ).addClass( 'fusion-builder-no-ui fusion-dialog-ui-active' );
					$modal.closest( '.fusion-builder-column' ).css( 'z-index', 'auto' ); // Because of animated items getting z-index 2000.
					$modal.closest( '#main' ).css( 'z-index', 'auto' );
					$modal.closest( '.fusion-row' ).css( 'z-index', 'auto' );
					$modal.closest( '.fusion-builder-container' ).css( 'z-index', 'auto' );
				} );

				$modal.on( 'hide.bs.modal', function() {
					jQuery( 'body' ).removeClass( 'fusion-builder-no-ui fusion-dialog-ui-active' );
					$modal.closest( '.fusion-builder-column' ).css( 'z-index', '' );
					$modal.closest( '#main' ).css( 'z-index', '' );
					$modal.closest( '.fusion-row' ).css( 'z-index', '' );
					$modal.closest( '.fusion-builder-container' ).css( 'z-index', '' );
				} );

			},

			/**
			 * Open actual modal.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			onSettingsOpen: function() {
				var self   = this,
					$modal = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( this.$el.find( '.fusion-modal' ) );

				this.disableDroppableElement();
				jQuery( this.$el ).closest( '.fusion-builder-live-element' ).css( 'cursor', 'default' );
				jQuery( this.$el ).closest( '.fusion-builder-column' ).css( 'z-index', 'auto' ); // Because of animated items getting z-index 2000.
				jQuery( this.$el ).closest( '.fusion-row' ).css( 'z-index', 'auto' );
				jQuery( this.$el ).closest( '.fusion-builder-container' ).css( 'z-index', 'auto' );

				setTimeout( function() {
					if ( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).length ) {
						jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#main' ).css( 'z-index', 'auto' );

						if ( 'fixed' === jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).css( 'position' ) ) {
							jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).css( 'z-index', '-1' );

							if ( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#sliders-container' ).find( '.tfs-slider[data-parallax="1"]' ).length ) {
								jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#sliders-container' ).css( 'z-index', 'auto' );
							}
						}

					}
				}, 100 );

				$modal.addClass( 'in' ).show();

				$modal.find( 'button[data-dismiss="modal"], .fusion-button[data-dismiss="modal"]' ).one( 'click', function() {
					window.FusionEvents.trigger( 'fusion-close-settings-' + self.model.get( 'cid' ) );
				} );
			},

			/**
			 * Close the modal.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			onSettingsClose: function() {
				var $modal = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( this.$el.find( '.fusion-modal' ) );

				$modal.find( 'button[data-dismiss="modal"], .fusion-button[data-dismiss="modal"]' ).off( 'click' );

				this.enableDroppableElement();
				jQuery( this.$el ).closest( '.fusion-builder-live-element' ).css( 'cursor', '' );
				jQuery( this.$el ).closest( '.fusion-builder-column' ).css( 'z-index', '' );
				jQuery( this.$el ).closest( '.fusion-row' ).css( 'z-index', '' );
				jQuery( this.$el ).closest( '.fusion-builder-container' ).css( 'z-index', '' );

				if ( jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).length ) {
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#main' ).css( 'z-index', '' );
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '.fusion-footer-parallax' ).css( 'z-index', '' );
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( '#sliders-container' ).css( 'z-index', '' );
				}

				$modal.removeClass( 'in' ).hide();
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {
				var $modal = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( this.$el.find( '.fusion-modal' ) );

				if ( jQuery( '.fusion-builder-module-settings[data-element-cid="' + this.model.get( 'cid' ) + '"]' ).length ) {
					$modal.addClass( 'in' ).show();
					$modal.find( '.full-video, .video-shortcode, .wooslider .slide-content' ).fitVids();
				}
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Create attribute objects
				attributes.attrModal        = this.buildModalAttr( atts.values );
				attributes.attrDialog       = this.buildDialogAttr( atts.values );
				attributes.attrContent      = this.buildContentAttr( atts.values );
				attributes.attrButton       = this.buildButtonAttr( atts.values );
				attributes.attrHeading      = this.buildHeadingAttr( atts.values );
				attributes.attrFooterButton = this.buildHFooterButtonAttr( atts.values );
				attributes.attrBody         = this.buildBodyAttr( atts.values );
				attributes.borderColor      = atts.values.border_color;
				attributes.title            = atts.values.title;
				attributes.showFooter       = atts.values.show_footer;
				attributes.closeText        = atts.extras.close_text;
				attributes.elementContent   = atts.values.element_content;
				attributes.name             = atts.values.name;
				attributes.label            = window.fusionAllElements[ this.model.get( 'element_type' ) ].name;
				attributes.icon             = window.fusionAllElements[ this.model.get( 'element_type' ) ].icon;

				// Any extras that need passed on.
				attributes.cid = this.model.get( 'cid' );

				return attributes;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildModalAttr: function( values ) {
				var attrModal = {
					class: 'fusion-modal modal fade modal-' + this.model.get( 'cid' ),
					tabindex: '-1',
					role: 'dialog',
					style: 'z-index: 9999999; background: rgba(0,0,0,0.5);',
					'aria-labelledby': 'modal-heading-' + this.model.get( 'cid' ),
					'aria-hidden': 'true'
				};

				if ( '' !== values.name ) {
					attrModal[ 'class' ] += ' ' + values.name;
				}

				if ( '' !== values[ 'class' ] ) {
					attrModal[ 'class' ] += ' ' + values[ 'class' ];
				}

				if ( '' !== values.id ) {
					attrModal.id = values.id;
				}

				return attrModal;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildDialogAttr: function( values ) {
				var attrDialog = {
					class: 'modal-dialog'
				};
				attrDialog[ 'class' ] += ( 'small' === values.size ) ? ' modal-sm' : ' modal-lg';

				return attrDialog;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values.
			 * @return {Object}
			 */
			buildContentAttr: function( values ) {
				var attrContent = {
					class: 'modal-content fusion-modal-content'
				};
				if ( '' !== values.background ) {
					attrContent.style = 'background-color:' + values.background;
				}

				return attrContent;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @return {Object} - Body attributes.
			 */
			buildBodyAttr: function() {
				var attrBody = {
					class: 'modal-body'
				};

				attrBody = _.fusionInlineEditor( {
					cid: this.model.get( 'cid' )
				}, attrBody );

				return attrBody;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @return {Object}
			 */
			buildButtonAttr: function() {
				var attrButton = {
					class: 'close',
					type: 'button',
					'data-dismiss': 'modal',
					'aria-hidden': 'true'
				};

				return attrButton;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @return {Object}
			 */
			buildHeadingAttr: function() {
				var attrHeading = {
					class: 'modal-title',
					id: 'modal-heading-' + this.model.get( 'cid' ),
					'data-dismiss': 'modal',
					'aria-hidden': 'true'
				};

				attrHeading = _.fusionInlineEditor( {
					cid: this.model.get( 'cid' ),
					param: 'title',
					'disable-return': true,
					'disable-extra-spaces': true,
					toolbar: false
				}, attrHeading );

				return attrHeading;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @return {Object}
			 */
			buildHFooterButtonAttr: function() {
				var attrFooterButton = {
					class: 'fusion-button button-default button-medium button default medium',
					'data-dismiss': 'modal'
				};

				return attrFooterButton;
			}

		} );
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Code block view.
		FusionPageBuilder.fusion_code = FusionPageBuilder.ElementView.extend( {

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Create attribute objects
				attributes.content = atts.params.element_content;
				attributes.label   = window.fusionAllElements[ this.model.get( 'element_type' ) ].name;
				attributes.icon    = window.fusionAllElements[ this.model.get( 'element_type' ) ].icon;

				// Any extras that need passed on.
				attributes.cid = this.model.get( 'cid' );

				return attributes;
			}

		} );
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Alert Element View.
		FusionPageBuilder.fusion_alert = FusionPageBuilder.ElementView.extend( {

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes object.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Validate values.
				this.validateValues( atts.values );

				// Create attribute objects
				attributes.attr           = this.buildAttr( atts.values );
				attributes.buttonStyles   = this.buildButtonStyles( atts.values );
				attributes.contentAttr    = this.buildContentAttr( atts.values );
				attributes.contentStyles  = this.buildContentStyles( atts.values );

				// Any extras that need passed on.
				attributes.cid    = this.model.get( 'cid' );
				attributes.values = atts.values;

				return attributes;
			},

			/**
			 * Modify the values.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {void}
			 */
			validateValues: function( values ) {
				values.alert_class = 'info';

				values.margin_bottom = _.fusionValidateAttrValue( values.margin_bottom, 'px' );
				values.margin_left   = _.fusionValidateAttrValue( values.margin_left, 'px' );
				values.margin_right  = _.fusionValidateAttrValue( values.margin_right, 'px' );
				values.margin_top    = _.fusionValidateAttrValue( values.margin_top, 'px' );

				switch ( values.type ) {
				case 'general':
					values.alert_class = 'info';
					if ( ! values.icon || 'none' !== values.icon ) {
						values.icon = 'fa-info-circle';
					}
					break;
				case 'error':
					values.alert_class = 'danger';
					if ( ! values.icon || 'none' !== values.icon ) {
						values.icon = 'fa-exclamation-triangle';
					}
					break;
				case 'success':
					values.alert_class = 'success';
					if ( ! values.icon || 'none' !== values.icon ) {
						values.icon = 'fa-check-circle';
					}
					break;
				case 'notice':
					values.alert_class = 'warning';
					if ( ! values.icon || 'none' !== values.icon ) {
						values.icon = 'fa-lg fa-cog';
					}
					break;
				case 'blank':
					values.alert_class = 'blank';
					break;
				case 'custom':
					values.alert_class = 'custom';
					break;
				}

				// Make sure the title text is not wrapped with an unattributed p tag.
				if ( 'undefined' !== typeof values.element_content ) {
					values.element_content = values.element_content.trim();
					values.element_content = values.element_content.replace( /(<p[^>]+?>|<p>|<\/p>)/img, '' );
				}
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildAttr: function( values ) {
				var attr         = _.fusionVisibilityAtts( values.hide_on_mobile, {
						class: 'fusion-alert alert fusion-live-alert fusion-alert-cid' + this.model.get( 'cid' ),
						style: ''
					} ),
					alertClass   = values.alert_class;

				attr[ 'class' ] += _.fusionGetStickyClass( values.sticky_display );

				if ( 'capitalize' === values.text_transform ) {
					alertClass += ' fusion-alert-capitalize';
				}

				if ( 'yes' === values.dismissable ) {
					alertClass += ' alert-dismissable';
				}

				attr[ 'class' ] += ' alert-' + alertClass;
				attr[ 'class' ] += ' fusion-alert-' + values.text_align;
				attr[ 'class' ] += ' ' + values.type;

				if ( 'yes' === values.box_shadow ) {
					attr[ 'class' ] += ' alert-shadow';
				}

				if ( '' !== values[ 'class' ] ) {
					attr[ 'class' ] += ' ' + values[ 'class' ];
				}

				if ( '' !== values.id ) {
					attr.id = values.id;
				}

				if ( '' !== values.margin_top ) {
					attr.style += 'margin-top:' + values.margin_top + ';';
				}

				if ( '' !== values.margin_right ) {
					attr.style += 'margin-right:' + values.margin_right + ';';
				}

				if ( '' !== values.margin_bottom ) {
					attr.style += 'margin-bottom:' + values.margin_bottom + ';';
				}

				if ( '' !== values.margin_left ) {
					attr.style += 'margin-left:' + values.margin_left + ';';
				}

				attr = _.fusionAnimations( values, attr );

				return attr;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildContentStyles: function( values ) {
				var alertClass   = values.alert_class,
					args         = {},
					styles       = '',
					cid          = this.model.get( 'cid' ),
					backgroundColor,
					accentColor;

				if ( 'custom' === alertClass ) {
					values.border_size    = parseFloat( values.border_size ) + 'px';
					args.background_color = values.background_color;
					args.accent_color     = values.accent_color;
					args.border_size      = values.border_size;
				} else {
					backgroundColor       = 'var(--' + alertClass + '_bg_color)';
					accentColor           = 'var(--' + alertClass + '_accent_color)';
					args.background_color = backgroundColor;
					args.accent_color     = accentColor;
					args.border_size      = parseFloat( window.fusionAllElements.fusion_alert.defaults.border_size ) + 'px';
				}

				styles = '<style type="text/css">';
				styles += '.fusion-alert.alert.fusion-alert-cid' + cid + '{';
				styles += 'background-color:' + args.background_color + ';';
				styles += 'color:' + args.accent_color + ';';
				styles += 'border-color:' + args.accent_color + ';';
				styles += 'border-width:' + args.border_size + ';';
				styles += '}';
				styles += '</style>';

				return styles;
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.0
			 * @return {Object}
			 */
			buildContentAttr: function() {
				var contentAttr = _.fusionInlineEditor( {
					cid: this.model.get( 'cid' ),
					'disable-return': true,
					'disable-extra-spaces': true,
					toolbar: 'simple'
				}, {
					class: 'fusion-alert-content'
				} );
				return contentAttr;
			},

			/**
			 * Builds the styles.
			 *
			 * @since 2.0
			 * @param {Object} values - The values object.
			 * @return {string}
			 */
			buildButtonStyles: function( values ) {
				if ( 'custom' === values.alert_class ) {
					return 'color:' + values.accent_color + ';border-color:' + values.accent_color + ';';
				}
				return '';
			}
		} );
	} );
}( jQuery ) );
;var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Alert Element View.
		FusionPageBuilder.fusion_audio = FusionPageBuilder.ElementView.extend( {

			/**
			 * Modify template attributes.
			 *
			 * @since 2.1
			 * @param {Object} atts - The attributes object.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {};

				// Validate values.
				this.validateValues( atts.values );

				// Create attribute objects
				attributes.attr = this.buildAttr( atts.values );

				// Any extras that need passed on.
				attributes.cid    = this.model.get( 'cid' );
				attributes.values = atts.values;

				return attributes;
			},

			/**
			 * Modify values.
			 *
			 * @since 2.1
			 * @param {Object} values - The values.
			 * @return {void}
			 */
			validateValues: function( values ) {
				var corners = [
					'top_left',
					'top_right',
					'bottom_right',
					'bottom_left'
				];

				_.each( corners, function( corner ) {
					if ( 'undefined' !== typeof values[ 'border_radius_' + corner ] && '' !== values[ 'border_radius_' + corner ] ) {
						values[ 'border_radius_' + corner ] = _.fusionGetValueWithUnit( values[ 'border_radius_' + corner ] );
					} else {
						values[ 'border_radius_' + corner ] = '0px';
					}
				} );
			},

			/**
			 * Builds attributes.
			 *
			 * @since 2.1
			 * @param {Object} values - The values object.
			 * @return {Object}
			 */
			buildAttr: function( values ) {
				var style,
					attr = _.fusionVisibilityAtts( values.hide_on_mobile, {
						class: 'fusion-audio',
						style: ''
					} ),
					corners = [
						'top_left',
						'top_right',
						'bottom_right',
						'bottom_left'
					];

				if ( values.progress_color ) {
					style  = '--fusion-audio-accent-color:' + values.progress_color + ';';
				}
				if ( values.border_size ) {
					style += '--fusion-audio-border-size:' + values.border_size + ';';
				}
				if ( values.border_color ) {
					style += '--fusion-audio-border-color:' + values.border_color + ';';
				}

				_.each( corners, function( corner ) {
					if ( values[ 'border_radius_' + corner ] ) {
						style += '--fusion-audio-border-' + corner.replace( '_', '-' ) + '-radius:' + values[ 'border_radius_' + corner ] + ';';
					}
				} );

				if ( values.background_color ) {
					style += '--fusion-audio-background-color:' + values.background_color + ';';
				}
				if ( values.max_width ) {
					style += '--fusion-audio-max-width:' + values.max_width + ';';
				}

				// Box shadow.
				if ( 'yes' === values.box_shadow ) {
					style += '--fusion-audio-box-shadow:' + _.fusionGetBoxShadowStyle( values ) + ';';
				}

				attr.style = style;

				if ( 'dark' === values.controls_color_scheme ) {
					attr[ 'class' ] += ' dark-controls';
				}

				if ( '' !== values[ 'class' ] ) {
					attr[ 'class' ] += ' ' + values[ 'class' ];
				}

				if ( '' !== values.id ) {
					attr.id = values.id;
				}

				attr = _.fusionAnimations( values, attr );

				attr.values = values;

				return attr;
			}
		} );
	} );
}( jQuery ) );
;/* global FusionPageBuilderApp */
/* eslint no-shadow: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

( function() {

	jQuery( document ).ready( function() {

		// Google Map View.
		FusionPageBuilder.fusion_map = FusionPageBuilder.ElementView.extend( {

			jsVars: {},

			/**
			 * Makes JS init call.
			 *
			 */
			initMap: function() {
				var $thisEl = this.$el;

				if ( 'undefined' !== typeof $thisEl && ! _.isEmpty( this.jsVars ) && ! _.isEmpty( this.jsVars.json_addresses ) ) {
					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( $thisEl.find( '#map_' + this.model.get( 'cid' ) ) ).fusion_maps( {
						addresses: this.jsVars.json_addresses,
						animations: this.jsVars.animation,
						infobox_background_color: this.jsVars.infobox_background_color,
						infobox_styling: this.jsVars.infobox,
						infobox_text_color: this.jsVars.infobox_text_color,
						map_style: this.jsVars.map_style,
						map_type: this.jsVars.type,
						marker_icon: this.jsVars.icon,
						overlay_color: this.jsVars.overlay_color,
						overlay_color_hsl: this.jsVars.overlay_color_hsl,
						pan_control: this.jsVars.zoom_pancontrol,
						show_address: this.jsVars.popup,
						scale_control: this.jsVars.scale,
						scrollwheel: this.jsVars.scrollwheel,
						zoom: parseInt( this.jsVars.zoom, 10 ),
						zoom_control: this.jsVars.zoom_pancontrol
					} );

				}
			},

			/**
			 * Runs during render() call.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			onRender: function() {
				var self = this;

				jQuery( '#fb-preview' ).on( 'load', function() {
					self.initMap();
				} );
			},

			/**
			 * Runs after view DOM is patched.
			 *
			 * @since 2.0
			 * @return {void}
			 */
			afterPatch: function() {
				var mapCopy,
					parent;

				if ( ! _.isEmpty( this.jsVars ) && ! _.isEmpty( this.jsVars.json_addresses ) ) {
					mapCopy = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( this.$el.find( '#map_' + this.model.get( 'cid' ) ) )[ 0 ].cloneNode();
					parent = jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( this.$el.find( '.fusion-builder-element-content' ) );

					jQuery( '#fb-preview' )[ 0 ].contentWindow.jQuery( this.$el.find( '#map_' + this.model.get( 'cid' ) ) ).remove();
					jQuery( parent ).append( mapCopy );

					this.initMap();
				}
			},

			/**
			 * Modify template attributes.
			 *
			 * @since 2.0
			 * @param {Object} atts - The attributes.
			 * @return {Object}
			 */
			filterTemplateAtts: function( atts ) {
				var attributes = {},
					html,
					jsVars;

				// Validate values.
				this.validateValues( atts.values );

				//