<?php

$course_ids = get_posts( [
	'post_type' => 'cac_course',
	'nopaging'  => true,
	'fields'    => 'ids',
] );

foreach ( $course_ids as $course_id ) {
	$course = new \CAC\Courses\Course( $course_id );

	$has_public_group_or_site = false;
	foreach ( $course->get_site_ids() as $site_id ) {
		$blog_public = (int) get_blog_option( $site_id, 'blog_public' );
		if ( 1 === $blog_public || 0 === $blog_public ) {
			$has_public_group_or_site = true;
			break;
		}
	}

	if ( ! $has_public_group_or_site ) {
		foreach ( $course->get_group_ids() as $group_id ) {
			$group = groups_get_group( $group_id );
			if ( 'public' === $group->status ) {
				$has_public_group_or_site = true;
				break;
			}
		}
	}

	if ( $has_public_group_or_site ) {
		update_post_meta( $course_id, 'has-public-group-or-site', 1 );
	} else {
		delete_post_meta( $course_id, 'has-public-group-or-site' );
	}
}

