<?php

/**
 * Copy one group's library to another.
 */

if ( empty( $args ) || count( $args ) < 2 ) {
	WP_CLI::error( 'Usage: wp eval-file cac-group-library-copy.php [fromGroup] [toGroup]' );
}

$source_group_id = $args[0];
$dest_group_id   = $args[1];

$source_group = groups_get_group( $source_group_id );
if ( ! $source_group->id ) {
	WP_CLI::error( 'Source group cannot be found.' );
}

$dest_group = groups_get_group( $dest_group_id );
if ( ! $dest_group->id ) {
	WP_CLI::error( 'Destination group cannot be found.' );
}

$source_items = \CAC\GroupLibrary\LibraryItem\Query::get( [ 'group_id' => $source_group_id ] );
$items_count  = count( $source_items );
$progress_bar = WP_CLI\Utils\make_progress_bar( "Copying $items_count library items", $items_count );

$dest_bp_group_documents_dir = bp_core_avatar_upload_path() . '/group-documents/' . $dest_group_id;

add_filter( 'ass_block_group_activity_types', '__return_false' );

foreach ( $source_items as $source_item ) {
	$progress_bar->tick();

	foreach ( $source_item->get_folders() as $folder_name ) {
		// Will create if it doesn't exist.
		$folder_id = \CAC\GroupLibrary\Folder::get_group_folder_by_name( $dest_group_id, $folder_name );
	}

	switch ( $source_item->get_item_type() ) {
		case 'bp_group_document' :
			$source_doc = new BP_Group_Documents( $source_item->get_source_item_id() );

			if ( empty( $source_doc->file ) ) {
				continue 2;
			}

			$params = [
				'user_id'        => $source_doc->user_id,
				'group_id'       => $dest_group_id,
				'created_ts'     => $source_doc->created_ts,
				'modified_ts'    => $source_doc->modified_ts,
				'file'           => $source_doc->file,
				'name'           => $source_doc->name,
				'description'    => $source_doc->description,
				'featured'       => $source_doc->featured,
				'download_count' => $source_doc->download_count,
			];

			$dest_doc = new BP_Group_Documents();
			foreach ( $params as $key => $value ) {
				$dest_doc->{$key} = $value;
			}

			$dest_doc->save( false );

			// Move the file itself.
			$source_path = $source_doc->get_path( 0, 0 );
			$dest_path   = $dest_doc->get_path( 0, 1 );
			copy( $source_path, $dest_path );

		break;

		case 'bp_doc' :
			$query = new BP_Docs_Query();

			$source_doc_id = $source_item->get_source_item_id();
			$source_doc    = get_post( $source_item_doc_id );

			$doc_args = [
				'title'     => $source_doc->post_title,
				'content'   => $source_doc->post_content,
				'author_id' => $source_doc->post_author,
				'group_id'  => bp_docs_get_associated_group_id( $source_doc_id ),
				'settings'  => bp_docs_get_doc_settings( $source_doc_id ),
			];

			$query->save( $doc_args );

		break;

		default :

			$dest_item = new \CAC\GroupLibrary\LibraryItem\Item();
			$dest_item->set_group_id( $dest_group_id );
			$dest_item->set_source_item_id( $source_item->get_source_item_id() );
			$dest_item->set_item_type( $source_item->get_item_type() );
			$dest_item->set_file_type( $source_item->get_file_type() );
			$dest_item->set_user_id( $source_item->get_user_id() );
			$dest_item->set_title( $source_item->get_title() );
			$dest_item->set_date_modified( $source_item->get_date_modified() );
			$dest_item->set_description( $source_item->get_description() );
			$dest_item->set_url( $source_item->get_url() );
			$dest_item->set_folders( $source_item->get_folders() );

			$dest_item->save();

		break;
	}
	continue;
}

remove_filter( 'ass_block_group_activity_types', '__return_false' );

$progress_bar->finish();
