<?php

global $wpdb;

$themes = wp_get_themes();

$data = [];

$allowed_themes = (array) get_site_option( 'allowedthemes' );

foreach ( $themes as $theme_slug => $theme_data ) {
	$count = $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM wp_network_themes WHERE stylesheet = %s", $theme_slug ) );

	$is_allowed = in_array( $theme_slug, $allowed_themes, true );

	$data[] = [
		0 => $theme_slug,
		1 => $theme_data->name,
		2 => $count,
		3 => (int) $is_allowed,
	];
}

$now = date( 'Y-m-d' );
$csv = ABSPATH . '/theme-usage-' . $now . '.csv';

$h = fopen( $csv, 'w' );

fputcsv(
	$h,
	array(
		'Slug',
		'Name',
		'Site Count',
		'Enabled?',
	)
);

foreach ( $data as $theme_stats ) {
	fputcsv( $h, $theme_stats );
}

fclose( $h );

print_r( $data );
