<?php

global $wpdb;

$doc_ids = $wpdb->get_col( "SELECT ID FROM {$wpdb->posts} WHERE post_type = 'bp_doc'" );

$default_settings = [
	'read'          => 'anyone',
	'edit'          => 'creator',
	'read_comments' => 'anyone',
	'post_comments' => 'loggedin',
	'view_history'  => 'anyone',
];

foreach ( $doc_ids as $doc_id ) {
	$associated_group_id = bp_docs_get_associated_group_id( $doc_id );
	if ( $associated_group_id ) {
		continue;
	}

	$doc_settings = get_post_meta( $doc_id, 'bp_docs_settings', true );
	if ( 1 == $doc_settings ) {
		$doc_settings = get_post_meta( $doc_id, '_bp_docs_settings_bak', true );
	}

	//update_post_meta( $doc_id, '_bp_docs_settings_bak', $doc_settings );

	if ( ! $doc_settings ) {
		$doc_settings = $default_settings;
	} else {
		$doc_settings['edit'] = 'creator';
	}

	update_post_meta( $doc_id, 'bp_docs_settings', $doc_settings );
}
