#!/bin/bash

# Array of site IDs.
declare -a sites=(8732 9470 13045 14452 17904 21293 23444 8321 11990 13226 1185)

# MySQL credentials
database="commons_wp"

# Loop through the array of site IDs and fetch tables like 'wp_{site_id}_'.
for i in "${sites[@]}"
do
	 # Fetch the table names and remove the first line, which contains the title "Tables_in_databaseName"
	 tables=$(mysql  -D "$database" -e "SHOW TABLES LIKE 'wp\_${i}\_%';" | sed 1d)
	 
	 # If there are no tables for this site ID, skip the mysqldump
	 if [ -z "$tables" ]; then
	 	echo "No tables found for site ID $i"
	 	continue
	 fi

	 # Convert the newline-separated table names to a space-separated string
	 tables_string=$(echo $tables | tr '\n' ' ')

	 echo "Exporting site ${i}"

	 # Use mysqldump to export the tables
#	 echo "${tables_string}"
	 mysqldump "$database" $tables_string > "site_${i}_backup.sql"
done

