<?php
/**
 * Custom Child Theme Functions
 *
 * This file's parent directory can be moved to the wp-content/themes directory 
 * to allow this Child theme to be activated in the Appearance - Themes section of the WP-Admin.
 *
 * Included is a basic theme setup that will add support for custom header images and custom 
 * backgrounds. There are also a set of commented theme supports that can be uncommented if you need
 * them for backwards compatibility. If you are starting a new theme, these legacy functionality can be deleted.  
 *
 * More ideas can be found in the community documentation for Thematic
 * @link http://docs.thematictheme.com
 *
 * @package ThematicSampleChildTheme
 * @subpackage ThemeInit
 */


/* The Following add_theme_support functions 
 * will enable legacy Thematic Features
 * if uncommented.
 */
 
// add_theme_support( 'thematic_legacy_feedlinks' );
// add_theme_support( 'thematic_legacy_body_class' );
// add_theme_support( 'thematic_legacy_post_class' );
// add_theme_support( 'thematic_legacy_comment_form' );
// add_theme_support( 'thematic_legacy_comment_handling' );

/**
 * Define theme setup
 */
function childtheme_setup() {
	
	/*
	 * Add support for custom background
	 * 
	 * Allow users to specify a custom background image or color.
	 * Requires at least WordPress 3.4
	 * 
	 * @link http://codex.wordpress.org/Custom_Backgrounds Custom Backgrounds
	 */
	add_theme_support( 'custom-background' );
	
	
	/**
	 * Add support for custom headers
	 * 
	 * Customize to match your child theme layout and style.
	 * Requires at least WordPress 3.4
	 * 
	 * @link http://codex.wordpress.org/Custom_Headers Custom Headers
	 */
	add_theme_support( 'custom-header', array(
		// Header image default
		'default-image' => '',
		// Header text display default
		'header-text' => true,
		// Header text color default
		'default-text-color' => '000',
		// Header image width (in pixels)
		'width'	=> '940',
		// Header image height (in pixels)
		'height' => '235',
		// Header image random rotation default
		'random-default' => false,
		// Template header style callback
		'wp-head-callback' => 'childtheme_header_style',
		// Admin header style callback
		'admin-head-callback' => 'childtheme_admin_header_style'
		) 
	);
	
}
add_action('thematic_child_init', 'childtheme_setup');


/**
 * Custom Image Header Front-End Callback
 *
 * Defines the front-end style definitions for 
 * the custom image header.
 * This style declaration will be output in the <head> of the
 * document just before the closing </head> tag.
 * Inline Syles and !important declarations 
 * can be used to override these styles.
 *
 * @link http://codex.wordpress.org/Function_Reference/get_header_image get_header_image()
 * @link http://codex.wordpress.org/Function_Reference/get_header_textcolor get_header_textcolor()
 */
function childtheme_header_style() {
	?>	
	<style type="text/css">
	<?php
	/* Declares the header image from the settings
	 * saved in WP-Admin > Appearance > Header
	 * as the background-image for div#branding.
	 */
	if ( get_header_image() && HEADER_IMAGE != get_header_image() ) {
		?>
		#branding {
			background:url('<?php header_image(); ?>') no-repeat 0 100%;
			margin-bottom:28px;
    		padding:44px 0 <?php echo HEADER_IMAGE_HEIGHT; ?>px 0; /* Bottom padding is the same height as the image */
    		overflow: visible;
}
		}
		<?php if ( 'blank' != get_header_textcolor() ) { ?>
		#blog-title, #blog-title a {
			color:#000;
		}
		#blog-description {	
			padding-bottom: 22px;
		}
		<?php
		}
		
	}
	?>
	<?php
	/* This delcares text color for the Blog title and Description
	 * from the settings saved in WP-Admin > Appearance > Header\
	 * If not set the deafault color is set to #000 
	 */
	if ( get_header_textcolor() ) {
		?>
		#blog-title, #blog-title a, #blog-description {
			color:#<?php header_textcolor(); ?>;
		}
		<?php
	}
	/* Removes header text if the
	 * "Do not diplay header text…" setting is saved
	 * in WP-Admin > Appearance > Header
	 */
	if ( ! display_header_text() ) {
		?>
		#branding {
			background-position: center bottom;
			background-repeat: no-repeat;
			margin-top: 32px;
		}
		#blog-title, #blog-title a, #blog-description {
			display:none;
		}
		#branding { 
			height:<?php echo HEADER_IMAGE_HEIGHT; ?>px; 
			width:940px;
			padding:0; 
		}
		<?php
	}
	?>
	</style>
	<?php
}


/**
 * Custom Image Header Admin Callback
 *
 * Callback to defines the admin (back-end) style
 * definitions for the custom image header.
 * Customize the css to match your theme defaults.
 * The !important declarations override inline admin styles
 * to better represent a WYSIWYG of the front-end styling
 * that this child theme is currently designed to display.
 */
function childtheme_admin_header_style() {
	?>
	<style type="text/css">
	#headimg {
		background-position: left bottom; 
		background-repeat:no-repeat;
		border:0 !important;   
		height:auto !important;
		padding:0 0 <?php echo HEADER_IMAGE_HEIGHT + 22; /* change the added integer (22) to match your desired top padding */?>px 0;
		margin:0 0 28px 0;
	}
	
	#headimg h1 {
	    font-family:Arial,sans-serif;
	    font-size:34px;
	    font-weight:bold;
	    line-height:40px;
		margin:0;
	}
	#headimg a {
		color: #000;
		text-decoration: none;
	}
	#desc{
		font-family: Georgia;
    	font-size: 13px;
    	font-style: italic;
    }
	</style>
	<?php
}

//Change search box text
function childtheme_search_value() {
return " ";
}
add_filter('search_field_value', 'childtheme_search_value');

/**----Changes to content on posts----
*/

function the_post_thumbnail_caption() {
  global $post;

  $thumbnail_id    = get_post_thumbnail_id($post->ID);
  $thumbnail_image = get_posts(array('p' => $thumbnail_id, 'post_type' => 'attachment'));

  if ($thumbnail_image && isset($thumbnail_image[0])) {
    echo '<span>'.$thumbnail_image[0]->post_excerpt.'</span>';
  }
}

function childtheme_override_postheader_posttitle() {
	global $page, $numpages, $multipage, $more, $pagenow;
	
	$posttitle = "\n\n\t\t\t\t\t";
	
	
	if (! is_page()) {
		if ( $page == 1) {
			if (is_single() || is_page()) {
				?>
				<div id="post-image">
				<?php	
				if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
					$thumb_link = '<a href="' . wp_get_attachment_url( get_post_thumbnail_id( $post->ID ) ) . '">';
				  	echo $thumb_link;
					the_post_thumbnail('medium');
					echo '</a>';
				}?>
				<?php the_post_thumbnail_caption(); ?>
				</div><!---End Featured Image--> 
			<?php
			}
			$postcategory = "\n\n\t\t\t\t\t\t" . '<span class="cat-links">';
		    if (is_single()) {
				/* translators: %s is postfooter categories */
		        $postcategory .= sprintf( get_the_category_list(', ') );
		        $postcategory .= '</span>';
		        $posttags = get_the_tags();

//		    } elseif ( is_category() && $cats_meow = thematic_cats_meow(', ') ) { /* Returns categories other than the one queried */
				/* translators: %s is postfooter categories */
//		        $postcategory .= sprintf( __('Also posted in %s', 'thematic'), $cats_meow );
//		        $postcategory .= '</span>' . "\n\n\t\t\t\t\t\t" . '<span class="meta-sep meta-sep-tag-links">|</span> ';
//		    } else {
//				/* translators: %s is postfooter categories */
//		        $postcategory .= sprintf( __('Posted in %s', 'thematic'), get_the_category_list(', ') );
//		        $postcategory .= '</span>' . "\n\n\t\t\t\t\t\t" . '<span class="meta-sep meta-sep-tag-links">|</span> ';
		    }
			?>

			<div id="post-category"><?php echo $postcategory?></div><!---End Post Categories--> 

			<?php
		} 
	}
	
	if ( $page == 1) {
		if ( !$title_content = get_the_title() )  
			$title_content = '<a href="' . get_permalink() . '">' . _x('(Untitled)', 'Default title for untitled posts', 'thematic') . '</a>';
   
	    if (is_single() || is_page()) {
	        $posttitle .= '<h1 class="entry-title">' . $title_content . "</h1>\n";
	    } elseif (is_404()) {    
	        $posttitle .= '<h1 class="entry-title">' . __('Not Found', 'thematic') . "</h1>\n";
	    } else {
	        $posttitle .= '<h2 class="entry-title">';
	        $posttitle .= sprintf('<a href="%s" title="%s" rel="bookmark">%s</a>',
	        						apply_filters('the_permalink', get_permalink()),
									sprintf( esc_attr__('Permalink to %s', 'thematic'), the_title_attribute( 'echo=0' ) ),
	        						$title_content
	        						);   
	        $posttitle .= "</h2>\n";
	    }
	} else {
		if ( !$title_content = get_the_title() )  
			$title_content = '<a href="' . get_permalink() . '">' . _x('(Untitled)', 'Default title for untitled posts', 'thematic') . '</a>';
   
	    if (is_single() || is_page()) {
	        $posttitle .= '<h1 class="entry-title-more">' . $title_content . "</h1>\n";
	    } elseif (is_404()) {    
	        $posttitle .= '<h1 class="entry-title-more">' . __('Not Found', 'thematic') . "</h1>\n";
	    } else {
	        $posttitle .= '<h2 class="entry-title-more">';
	        $posttitle .= sprintf('<a href="%s" title="%s" rel="bookmark">%s</a>',
	        						apply_filters('the_permalink', get_permalink()),
									sprintf( esc_attr__('Permalink to %s', 'thematic'), the_title_attribute( 'echo=0' ) ),
	        						$title_content
	        						);   
	        $posttitle .= "</h2>\n";
	    }
	}
	
    return apply_filters('thematic_postheader_posttitle',$posttitle); 

}

function childtheme_override_postheader_postmeta() {
  	global $post, $page, $numpages, $multipage, $more, $pagenow;

	$key_value = get_post_meta( $post->ID, 'author', true ); 
	
	if ( $page == 1) {
		if( ! empty( $key_value ) ) {
	  		$author_value = $key_value;
		}
	
		$postmeta  = "\n\t\t\t\t\t";
		if (is_single() || is_page()) {
	    	$postmeta .= '<div class="article-author">' . "\n\n";
		} else {
			$postmeta .= '<div class="article-author-list">' . "\n\n";
		}
		$postmeta .= $author_value;         
	    $postmeta .= '</div><!-- End .article-author -->' . "\n";
		
	} else {
		$postmeta  = "\n\t\t\t\t\t";
	    $postmeta .= '<div class="page-of">' . "\n\n";
	    $postmeta .= 'page ' .$page .' of ' .$numpages; 
	    $postmeta .= '</div><!-- End .page-of -->' . "\n";
	}
		
    return apply_filters('thematic_postheader_postmeta',$postmeta);
	
}

/**
 * The formatted output of a list of pages.
 *
 * Displays page links for paginated posts (i.e. includes the "nextpage".
 * Quicktag one or more times). This tag must be within The Loop.
 *
 * The defaults for overwriting are:
 * 'next_or_number' - Default is 'number' (string). Indicates whether page
 *      numbers should be used. Valid values are number and next.
 * 'nextpagelink' - Default is 'Next Page' (string). Text for link to next page.
 *      of the bookmark.
 * 'previouspagelink' - Default is 'Previous Page' (string). Text for link to
 *      previous page, if available.
 * 'pagelink' - Default is '%' (String).Format string for page numbers. The % in
 *      the parameter string will be replaced with the page number, so Page %
 *      generates "Page 1", "Page 2", etc. Defaults to %, just the page number.
 * 'before' - Default is '<p id="post-pagination"> Pages:' (string). The html 
 *      or text to prepend to each bookmarks.
 * 'after' - Default is '</p>' (string). The html or text to append to each
 *      bookmarks.
 * 'text_before' - Default is '' (string). The text to prepend to each Pages link
 *      inside the <a> tag. Also prepended to the current item, which is not linked.
 * 'text_after' - Default is '' (string). The text to append to each Pages link
 *      inside the <a> tag. Also appended to the current item, which is not linked.
 *
 * @param string|array $args Optional. Overwrite the defaults.
 * @return string Formatted output in HTML.
 */
function custom_wp_link_pages( $args = '' ) {
	$defaults = array(
		'before' => '<div id="post-pagination">', 
		'after' => '</div>',
		'text_before' => '',
		'text_after' => '',
		'next_or_number' => 'number', 
		'nextpagelink' => __( 'next' ),
		'previouspagelink' => __( 'previous' ),
		'pagelink' => '%',
		'echo' => 1
	);

	$r = wp_parse_args( $args, $defaults );
	$r = apply_filters( 'wp_link_pages_args', $r );
	extract( $r, EXTR_SKIP );

	global $page, $numpages, $multipage, $more, $pagenow;

	$output = '';
	if ( $multipage ) {
			$output .= $before;
			for ( $i = 1; $i < ( $numpages + 1 ); $i = $i + 1 ) {
				$j = str_replace( '%', $i, $pagelink );
				$output .= ' ';
				if ( $i != $page || ( ( ! $more ) && ( $page == 1 ) ) )
					$output .= _wp_link_page( $i );
				else
					$output .= '<span class="current-post-page">';

				$output .= $text_before . $j . $text_after;
				if ( $i != $page || ( ( ! $more ) && ( $page == 1 ) ) )
					$output .= '</a>';
				else
					$output .= '</span>';
			}
			$i = $page - 1;
			if ( $i && $more ) {
				$output .= _wp_link_page( $i );
				$output .= '<span class="prev-next">' . $previouspagelink . '</span>' . '</a>';
			}
			$i = $page + 1;
			if ( $i <= $numpages && $more ) {
				$output .= _wp_link_page( $i );
				$output .= '<span class="prev-next">' . $nextpagelink . '</span>' . '</a>';
			}
			$output .= $after;
	}

	if ( $echo )
		echo $output;

	return $output;
}


function childtheme_override_single_post(){
		// action hook for insterting content above #post
		thematic_abovepost();
		?>
	
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?> > 

		<?php

        	// creating the post header
        	thematic_postheader();
        ?>
			
			<div class="entry-content">
			
				<?php thematic_content(); ?>

				<?php custom_wp_link_pages(); ?>
				
			</div><!-- .entry-content -->
			
		</div><!-- #post -->
<?php
	// action hook for insterting content below #post
	thematic_belowpost();
}


function ES_issue_contents() {
	global $post;
	
	$current = get_cat_ID( 'Current Issue');
	
	$args = array(
		'category'	=>	$current
	);
	
	$myposts = get_posts( $args );
	$numposts = 0;
	
	foreach( $myposts as $post ) : $numposts = $numposts+1;
	endforeach;
		
	$postspercolumn = ($numposts/3);
	$postspercolumn = ceil($postspercolumn);

	$args = array(
		'category'	=>	$current,
		'meta_key' => 'issue-order',
	  	'orderby' => 'meta_value',
		'order'		=> 'ASC',
		'posts_per_page' => $postspercolumn
	);
	
			
	$myposts = get_posts( $args );
	?>
	
	<div id="home-column-1">

	<?php
		home_column($myposts)
	?>
	</div><!---End Home Column 1--> 
	
	<?php
	$args = array(
		'category'	=>	$current,
		'meta_key' => 'issue-order',
	  	'orderby' => 'meta_value',
		'order'		=> 'ASC',
		'posts_per_page' => $postspercolumn, 
		'offset'	=> $postspercolumn
	);
	
	$myposts = get_posts( $args );
	?>
	
	<div id="home-column-2">
		<?php
			home_column($myposts)
		?>
	</div>	<!---End Home Column 2--> 
	
	<?php	
	$args = array(
		'category'	=>	$current,
		'meta_key' => 'issue-order',
	  	'orderby' => 'meta_value',
		'order'		=> 'ASC',
		'posts_per_page' => $postspercolumn, 
		'offset' 	=> $postspercolumn*2
	);
	
	$myposts = get_posts( $args );
	?>
	
	<div id="home-column-3">
		<?php
			home_column($myposts)
		?>
	</div>	<!---End Home Column 3--> 
	
	<?php
}

function home_column($myposts){
	foreach( $myposts as $post ) : {
		$title_content = '<a href="' . get_permalink($post->ID) . '">' . get_the_title($post->ID) . '</a>';
		$posttitle = '<h1 class="entry-title-home">' . $title_content . "</h1>\n";
		
		$author_value = get_post_meta( $post->ID, 'author', true ); 
		$postmeta = '<div class="article-author-home">' . "\n\n" . $author_value . '</div><!-- End .article-author-home -->' . "\n";
		echo $posttitle; 
		echo $postmeta;
	}
	endforeach;

}