<?php
/**
 * Customized Month view for MESTC theme
 *
 * Month View Template
 * The wrapper template for month view. 
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/month.php
 *
 * @package TribeEventsCalendar
 * @since  3.0
 * @author Modern Tribe Inc.
 *
 */

if ( !defined('ABSPATH') ) { die('-1'); } ?>

<?php do_action( 'tribe_events_before_template' ) ?>

<!-- Main Events Content -->

<h2 class="tribe-events-cal-title">Calendar of Events</h2>

<div id="tribe-events-calendar-header">
	<span class='tribe-events-calendar-buttons'> 
		<a class='tribe-events-button-off' href='<?php echo tribe_get_listview_link(); ?>'><?php _e('Event List', 'tribe-events-calendar')?></a>
		<a class='tribe-events-button-on' href='<?php echo tribe_get_gridview_link(); ?>'><?php _e('Calendar', 'tribe-events-calendar')?></a>
	</span>

</div><!--tribe-events-calendar-header-->

<div id="tribe-events-content" class="upcoming">

	
	
<?php tribe_get_template_part('month/content'); ?>

<?php do_action( 'tribe_events_after_template' ) ?>
