<?php 
/**
 * Customized look for Event List Widget for MESTC Theme
 * 
 * This is the template for the output of the events list widget. 
 * All the items are turned on and off through the widget admin.
 * There is currently no default styling, which is highly needed.
 *
 * You can customize this view by putting a replacement file of the same name (events-list-load-widget-display.php) in the events/ directory of your theme.
 *
 * @return string
 *
 * @package TribeEventsCalendar
 * @since  2.1
 * @author Modern Tribe Inc.
 *
 */

$key="short-title";
$postID= get_the_ID();
?>

<li class="tribe-events-list-widget-events">
	<div class="when">
		<?php
			$space = false;
			$output = '';
			echo tribe_get_start_date( $post->ID, false );

			if($event->AllDay) {
				echo ' <small>('.__('All Day','tribe-events-calendar').')</small>';
         }
      ?> 
	</div>
	<!-- Event Time -->
	<?php
	if (is_page('index')){?>
		<h4 class="entry-title summary <?php 
			//  grab the categories and print them out with a space seperating them
			$tribe_categories = tribe_get_event_cat_slugs();
				foreach ( $tribe_categories as $tribe_category ) {
					echo $tribe_category;
					echo " ";
				}
			?>">
				<a href="<?php echo tribe_get_event_link(); ?>" rel="bookmark"><?php the_title(); ?></a>
		</h4><?}
	else {?>
		<h4 class="entry-title summary <?php 
			//  grab the categories and print them out with a space seperating them
			$tribe_categories = tribe_get_event_cat_slugs();
				foreach ( $tribe_categories as $tribe_category ) {
					echo $tribe_category;
					echo " ";
				}
			?>">
				<a href="<?php echo tribe_get_event_link(); ?>" rel="bookmark"><?php echo get_post_meta($postID, $key, true); ?></a>
		</h4>
	<?}?>	
	<!-- Event Title -->
</li>
