/*
 * A time picker for jQuery
 *
 * Dual licensed under the MIT and GPL licenses.
 * Copyright (c) 2009 Anders Fajerson and 2013 Dennis Burke
 * @name     timePicker
 * @author   Anders Fajerson (http://perifer.se)
 * @example  $("#mytime").timePicker();
 * @example  $("#mytime").timePicker({step:30, startTime:"15:00", endTime:"18:00"});
 *
 * Based on timePicker by Sam Collet (http://www.texotela.co.uk/code/jquery/timepicker/)
 *
 * Options:
 *   step: # of minutes to step the time by
 *   startTime: beginning of the range of acceptable times
 *   endTime: end of the range of acceptable times
 *   separator: separator string to use between hours and minutes (e.g. ':')
 *   show24Hours: use a 24-hour scheme
 */
(function(e){"use strict";function n(t,n,r){t.value=e(n).text();e(t).change();t.focus();r.hide()}function r(e,t){var n=e.getHours();var r=t.show24Hours?n:(n+11)%12+1;var s=e.getMinutes();return i(r)+t.separator+i(s)+(t.show24Hours?"":n<12?" am":" pm")}function i(e){return(e<10?"0":"")+e}function s(e,t){return typeof e==="object"?u(e):o(e,t)}function o(e,t){if(e){e=a(e,t);var n=e.split(t.separator);var r=parseFloat(n[0]);var i=parseFloat(n[1]);if(!t.show24Hours){if(r===12&&e.indexOf("am")!==-1){r=0}else if(r!==12&&e.indexOf("pm")!==-1){r+=12}}var s=new Date(0,0,0,r,i,0);return u(s)}return null}function u(e){e.setFullYear(2001);e.setMonth(0);e.setDate(0);return e}function a(e,t){var n,r,i,s,o,u;if(t.show24Hours){return e}if(e){r=e.toLowerCase().replace(/\s*/g,"");if(n=/^(\d{1,2})(a|p)m*$/.exec(r)){if(parseInt(n[1],10)<12){return""+n[1]+":00"+n[2]+"m"}}else if(i=/^(\d{1,2}):(\d{1,2})(a|p)m*$/.exec(r)){s=parseInt(i[1],10);o=parseInt(i[2],10);u=i[3]+"m";if(s<12||o<59){return""+s+":"+(o>=10?o:o+"0")+u}}else if(i=/^(\d{1,2}):(\d{1,2})$/.exec(r)){s=parseInt(i[1],10);o=parseInt(i[2],10);u="am";if(s<=24&&o<=59){if(s>=12){s=s-12;u="pm"}if(s===0){s=12}return s+":"+o+u}}}}var t={init:function(t){var n=e.extend({},e.fn.timePicker.defaults,t);return this.each(function(){e.timePicker(this,n)})},destroy:function(){return this.each(function(){if(this.timePicker){var t=e(this).data("timepickerdiv");e(this).data("timepickerdiv","");e("#"+t).remove();delete this.timePicker}})}};e.timePicker=function(t,n){try{var r=e(t)[0];return r.timePicker||(r.timePicker=new e._timePicker(r,n))}catch(i){throw"timepicker must be called on an element"}};e.timePicker.version="0.4.0";e._timePicker=function(t,i){var f=false;var l=false;var c=s(i.startTime,i);var h=s(i.endTime,i);var p=i.defaultSelected?s(i.defaultSelected,i):c;var d="selected";var v="li."+d;var m="tp"+(new Date).getTime();e(t).attr("autocomplete","off");e(t).data("timepickerdiv",m);var g=[];var y=new Date(c);while(y<=h){g[g.length]=r(y,i);y=new Date(y.setMinutes(y.getMinutes()+i.step))}var b=e('<div id="'+m+'" class="time-picker'+(i.show24Hours?"":" time-picker-12hours")+'"></div>');var w=e("<ul></ul>");for(var E=0;E<g.length;E+=1){w.append("<li>"+g[E]+"</li>")}b.append(w);b.appendTo("body").hide();b.mouseover(function(){f=true}).mouseout(function(){f=false});e("li",w).mouseover(function(){if(!l){e(v,b).removeClass(d);e(this).addClass(d)}}).mousedown(function(){f=true}).click(function(){n(t,this,b,i);f=false});var S=function(){if(b.is(":visible")){return false}e("li",b).removeClass(d);var n=e(t).offset();b.css({top:n.top+t.offsetHeight,left:n.left});b.show();var s=t.value?o(t.value,i):p;var a=c.getHours()*60+c.getMinutes();var f=s.getHours()*60+s.getMinutes()-a;var l=Math.round(f/i.step);var v=u(new Date(0,0,0,0,l*i.step+a,0));v=c<v&&v<=h?v:c;var m=e("li:contains("+r(v,i)+")",b);if(m.length){m.addClass(d);b[0].scrollTop=m[0].offsetTop}return true};e(t).focus(S).click(S);e(t).blur(function(){if(!f){b.hide()}e(this).val(a(e(this).val(),i))});e(t).keydown(function(r){var s;l=true;var o=b[0].scrollTop;switch(r.which){case 38:if(S()){break}s=e(v,w);var u=s.prev().addClass(d)[0];if(u){s.removeClass(d);if(u.offsetTop<o){b[0].scrollTop=o-u.offsetHeight}}else{s.removeClass(d);u=e("li:last",w).addClass(d)[0];b[0].scrollTop=u.offsetTop-u.offsetHeight}break;case 40:if(S()){break}s=e(v,w);var a=s.next().addClass(d)[0];if(a){s.removeClass(d);if(a.offsetTop+a.offsetHeight>o+b[0].offsetHeight){b[0].scrollTop=o+a.offsetHeight}}else{s.removeClass(d);a=e("li:first",w).addClass(d)[0];b[0].scrollTop=0}break;case 13:if(b.is(":visible")){var f=e(v,w)[0];n(t,f,b,i);r.preventDefault()}break;case 27:b.hide();break}});e(t).keyup(function(){l=false});this.getTime=function(){return o(t.value,i)};this.setTime=function(n){t.value=r(s(n,i),i);e(t).change()}};e.fn.timePicker=function(n){if(t[n]){return t[n].apply(this,Array.prototype.slice.call(arguments,1))}else if(typeof n==="object"||!n){return t.init.apply(this,arguments)}else{e.error("Method "+n+" does not exist on jQuery.tooltip")}};e.fn.timePicker.defaults={step:30,startTime:new Date(0,0,0,0,0,0),endTime:new Date(0,0,0,23,30,0),defaultSelected:null,separator:":",show24Hours:true}})(jQuery)