<?php
/**
 * Template Name: JADT Home Page
 *
 * This is a custom Page template for displaying the JADT home page.
 * It will display in blocks the titles and authors of the articles from the last two issues.
 *
 * @package Thematic
 * @subpackage Templates
 *
 */

	// calling the header.php
	get_header();

	// action hook for placing content above #container
	thematic_abovecontainer();
?>

		<div id="container" class="home">

			<?php

				// filter for manipulating the element that wraps the content 
				echo apply_filters( 'thematic_open_id_content', '<div id="content">' . "\n\n" );

				// calling the widget area 'page-top'
            	get_sidebar('page-top');

				// start the loop to get the page content
				the_post();

			?>

				<div id="post-<?php the_ID(); ?>" <?php post_class(); ?> > 

					<div class="entry-content">

	                    <?php 
	                    	// displays the "Page" content 
	                    	the_content();

	                    ?>

					</div><!-- .entry-content -->

				</div><!-- #post -->

	        <?php

	       		// action hook for placing contentbelow #post
	       		thematic_belowpost();

       			// action hook for calling the comments_template
       			thematic_comments_template();
	        ?>

			</div><!-- #content -->

			<?php 
				// action hook for placing content below #content
				thematic_belowcontent();
			?> 

		</div><!-- #container -->

<?php 
	// action hook for placing content below #container
	thematic_belowcontainer();

	// calling the standard sidebar 
	thematic_sidebar();

	// calling footer.php
	get_footer();
?>