<?php
/**
 * Template Name: Prelude 14 Splash Page
 *
 * This page is specifically designed for the splash page of Prelude.14
 * 
 * @package Thematic
 * @subpackage Templates
 */

	// Create doctype
	thematic_create_doctype();
	echo " ";
	language_attributes();
	echo ">\n";

	// Opens the head tag 
	thematic_head_profile();

	// Create the meta content type
	thematic_create_contenttype();

	// Create the title tag 
	thematic_doctitle();

	// Create the meta description
	thematic_show_description();

	// Create the tag <meta name="robots"  
	thematic_show_robots();

	// Legacy feedlink handling
	if ( current_theme_supports( 'thematic_legacy_feedlinks' ) ) {    
		// Creating the internal RSS links
		thematic_show_rss();

		// Create comments RSS links
		thematic_show_commentsrss();
	}

	// Create pingback adress
	thematic_show_pingback();

	/* The function wp_head() loads Thematic's stylesheet and scripts.
	 * Calling wp_head() is required to provide plugins and child themes
	 * the ability to insert markup within the <head> tag.
	 */
	wp_head();
	
	
	$PRELUDEimagedir = get_stylesheet_directory_uri();
	$PRELUDEimagedir .= '/library/images/';
	
	$PRELUDEstyledir = get_stylesheet_directory_uri();
	$PRELUDEstyledir .= '/library/styles/';
?>

	<script type="text/javascript" src="//use.typekit.net/ymt8xot.js"></script>
	<script type="text/javascript">try{Typekit.load();}catch(e){}</script>
</head>

<?php 
	// Create the body element and dynamic body classes
	thematic_body();

?>
	
<div id="splash-main">
	<div id="logo-scroll">
 		<div id="logo">
			<img src="<? echo $PRELUDEimagedir.'/Prelude-14-logo.jpg'?>">
		</div>
		<div id="scroll">
			<p class="scroll">SCROLL
        	<p>&#9661;	
		</div>
	</div>
	
	<?php the_content(); ?>
	
		<div id="photo-credit">
			<p>Artist: Chris Tyler Photographer: Julieta Cervantes.
		</div>
	</div>
</div>
