<?php
/**
 * Template Name: MESTC Events Page
 *
 * Special features include auto populating side calendar and upcoming event under each category
 * …
 * Based on page.php from THEMATIC Template
 * 
 * @package MESTC
 * @subpackage Templates
 */
 
    // calling the header.php
    get_header();

    // action hook for placing content above #container
    thematic_abovecontainer();
?>

		<div id="container">
		
			<?php
				// action hook for placing content above #content
				thematic_abovecontent();

				// filter for manipulating the element that wraps the content 
				echo apply_filters( 'thematic_open_id_content', '<div id="content">' . "\n" );
		
	            // start the loop
	            while ( have_posts() ) : the_post();

				// action hook for placing content above #post
	            thematic_abovepost();
	        ?>
    	        
				<?php
					echo '<div id="post-' . get_the_ID() . '" ';
					// Checking for defined constant to enable Thematic's post classes
					if ( ! ( THEMATIC_COMPATIBLE_POST_CLASS ) ) {
						post_class();
						echo '>';
					} else {
						echo 'class="';
						thematic_post_class();
						echo '">';
					}
	                
	                // creating the post header
	                thematic_postheader();
				?>
	                
					<div class="entry-content">
	
						<?php
						    
	                    	the_content();
							
							?>

							<?php if(have_rows('event_category_listing')): ?>
								<?php while (have_rows('event_category_listing')) : the_row();?>
									<?php $catSlug = get_sub_field('event_category_selection'); ?>
									<div class="event-block">
										<div class="event-image-left"><a href="<?php echo get_site_url(); ?>/events-list/category/<?php echo $catSlug->slug; ?>/"><img src="<?php the_sub_field('event_image'); ?>" align="alignleft" width="175" height="115" title="US Theatre"/></a><br/><?php the_sub_field('image_caption'); ?></div>
                            
			                            <div class="event-text"><a style="color:<?php the_sub_field('title_color_hex_code'); ?>" class="<?php echo $catSlug->slug; ?>" href="<?php echo get_site_url(); ?>/events-list/category/<?php echo $catSlug->slug; ?>/"><?php the_sub_field('event_title'); ?></a></div>
			                            	<?php the_sub_field('event_description'); ?>
			                            <?php $theSlug = $catSlug->slug; ?>
			                            <?php return_upcoming_category_event($theSlug);?>
									</div>
								<?php endwhile; 
							else : endif; ?>

							
                            <?php
	                    
	                    	wp_link_pages( "\t\t\t\t\t<div class='page-link'>" . __( 'Pages: ', 'thematic' ), "</div>\n", 'number' );
	                    
	                    	edit_post_link( __( 'Edit', 'thematic' ), "\n\t\t\t\t\t\t" . '<span class="edit-link">' , '</span>' . "\n" );
	                    ?>

					</div><!-- .entry-content -->
					
				</div><!-- #post -->
	
			<?php
				// action hook for inserting content below #post
	        	thematic_belowpost();
	        		        
       			// action hook for calling the comments_template
       			thematic_comments_template();
        		
	        	// end loop
        		endwhile;
	        ?>
	
			</div><!-- #content -->
			
			<?php 
				// action hook for placing content below #content
				thematic_belowcontent(); 
			?> 
			
		</div><!-- #container -->

<?php 
    // action hook for placing content below #container
    thematic_belowcontainer();

    // calling the standard sidebar 
    thematic_sidebar();
    
    // calling footer.php
    get_footer();
?>