<?php
/**
 * MESTC Child Theme Functions
 *
 * This file supplements the functions defined in THEMATIC to allow for specific MESTC functionality.
 *
 * @link http://docs.thematictheme.com
 *
 * @package MESTC
 * @subpackage ThemeInit
 */


/**
 * Unleash the power of Thematic's dynamic classes, comment form and feedlinks.
 *
 * These constants were removed in Themeatic v1.0.3.1, introducing a bug that broke the MESTC site.
 * add_theme_support() was added to fix the bug. On 11/9/12 I (Dom) upgraded Themeatic to v1.0.3.3-beta:
 * https://github.com/ThematicTheme/Thematic/archive/1.0.3.3-beta.zip
 *
 * For additional information about this bug and fix please see this forum topic:
 * http://thematictheme.com/forums/topic/upgrading-to-v-1-0-3-1-and-body_class-in-functions-php/page/2/#post-2488
 */
// define('THEMATIC_COMPATIBLE_BODY_CLASS', true);
// define('THEMATIC_COMPATIBLE_POST_CLASS', true);
add_theme_support('thematic_legacy_body_class');
add_theme_support('thematic_legacy_post_class');

// define('THEMATIC_COMPATIBLE_COMMENT_FORM', true);
add_theme_support( 'thematic_legacy_comment_form' );

// define('THEMATIC_COMPATIBLE_FEEDLINKS', true);
add_theme_support( 'thematic_legacy_feedlinks' );


global $page;
global $post;

//Add Favicon

function childtheme_favicon() { 
	$MESTCimagedir = get_stylesheet_directory_uri();
	$MESTCimagedir .= '/library/images/';?>
    <link rel="shortcut icon" href="<?php echo $MESTCimagedir ?>favicon.ico">
<?php }

add_action('wp_head', 'childtheme_favicon');


	
// Replace Blog Title with MESTC logo

function childtheme_override_blogtitle(){
		$MESTCimagedir = get_stylesheet_directory_uri();
		$MESTCimagedir .= '/library/images/';
		if (is_page('index')){
		?>
	  	<div id="MESTC-image"><span><a href="<?php echo home_url() ?>/" title="Martin E. Segal Theatre Center" rel="home"><img
src="<?php echo $MESTCimagedir ?>MESTCBig.jpg" height="175px" width="225px"></a></span></div><?php		
		}
		else {
	    ?>
    	<div id="MESTC-image"><span><a href="<?php echo home_url() ?>/" title="Martin E. Segal Theatre Center" rel="home"><img
src="<?php echo $MESTCimagedir ?>MESTC.jpg" height="134px" width="170px"></a></span></div>  
    <?php 
	}
}

add_action('thematic_header','thematic_blogtitle',3);    



// Register the new menus
function register_my_menus() {
	register_nav_menus(
		array(
			'primary-menu' => __( 'Primary Menu' ),
			'home-menu' => __( 'Home Menu' ),
			'events-menu' => __( 'Events Menu' ),
	        'publications-menu' => __( 'Publications Menu' ),
		)
	);
}
add_action( 'init', 'register_my_menus' );



//Conditional Assignment of Secondary Menu Based on Category
function secondary_header_menu() {
	if (tribe_is_event()) {
         wp_nav_menu( array( 'theme_location' => 'events-menu',
				'container_id'=>'secondary-header-menu',
				'container_class' => 'clearfix ',
                'menu_class' => 'sf-menu', // we assign the sf-menu class to the menu ul so that superfish works on this menu too       
				) );
	}			
	elseif (is_single() OR is_archive()) {
		  wp_nav_menu( array( 'theme_location' => 'home-menu',
				'container_id'=>'secondary-header-menu',
				'container_class' => 'clearfix ',
              'menu_class' => 'sf-menu', // we assign the sf-menu class to the menu ul so that superfish works on this menu too
              ) );
	}
	elseif (in_category('events')) {
         wp_nav_menu( array( 'theme_location' => 'events-menu',
				'container_id'=>'secondary-header-menu',
				'container_class' => 'clearfix ',
                'menu_class' => 'sf-menu', // we assign the sf-menu class to the menu ul so that superfish works on this menu too       
				) );
	}
	elseif (in_category('publications' )) {
         wp_nav_menu( array( 'theme_location' => 'publications-menu',
				'container_id'=>'secondary-header-menu',
				'container_class' => 'clearfix ',
                'menu_class' => 'sf-menu', // we assign the sf-menu class to the menu ul so that superfish works on this menu too
                ) );
	}
	else {
		  wp_nav_menu( array( 'theme_location' => 'home-menu',
				'container_id'=>'secondary-header-menu',
				'container_class' => 'clearfix ',
                'menu_class' => 'sf-menu', // we assign the sf-menu class to the menu ul so that superfish works on this menu too
                ) );
	}	
}

add_action('thematic_header','secondary_header_menu');



// Assign Background image to Headers and Add Secondary Header Menu
function childtheme_override_access(){ 
	$MESTCimagedir = get_stylesheet_directory_uri();
	$MESTCimagedir .= '/library/images/';
	if (is_page('index')) { ?>
	<div id="access"> <?php
    } 	
    else { 
		if (in_category('events')) {
            $headerimage = 'MESTCEventHeader.jpg';
        }
        elseif (in_category('publications')) {
            $headerimage = 'MESTCPubHeader.jpg';
        }
        elseif (in_category('home')) {
            $headerimage = 'MESTCHomeHeader.jpg';
		}
		elseif (tribe_is_event() OR tribe_is_month() OR tribe_is_list_view()) {
            $headerimage = 'MESTCEventHeader.jpg';
		}
		elseif (is_single() OR is_archive()) {
            $headerimage = 'MESTCHomeHeader.jpg';
		}
        else {
            $headerimage = 'MESTCEventHeader.jpg';
        }
	    ?>
        <div id="access" style="background: url('<?php echo $MESTCimagedir.$headerimage ?>') no-repeat"> <?php
    }
	if ( ( function_exists("has_nav_menu") ) && ( has_nav_menu( apply_filters('thematic_primary_menu_id', 'primary-menu') ) ) ) {
    	    echo  wp_nav_menu(thematic_nav_menu_args());
    	} else {
    	    echo  thematic_add_menuclass(wp_page_menu(thematic_page_menu_args()));	
    	}
    if (!is_page('index')){
		secondary_header_menu();}?>
    </div><!-- #access -->
    <?php 
}
add_action('thematic_header','thematic_access',9);



/* IMPORTANT !
* This function registers the same custom post type as the The Events Calendar plugin
* http://wordpress.org/extend/plugins/the-events-calendar/
* This also registers WordPress' native categories and tags while associating them with the Events Calendar Plugin
*/
add_action( 'init', 'add_calendar_taxonomy', 0 );

function add_calendar_taxonomy() {

register_post_type('tribe_events',array( // Registers Events Calendar Custom Post Type

'taxonomies' => array('category') // This registers the native WordPress taxonomies with The Events Calendar

));

}



// Randomizes background of Index page and adds caption and photo credits

function randomize_index_background () {
	if (is_page('index')){
	$background_images[0] = 'MESTCBG1.jpg';
	$background_images[1] = 'MESTCBG2.jpg';
	$background_images[2] = 'MESTCBG3.jpg';
	$background_images[3] = 'MESTCBG4.jpg';
	$background_images[4] = 'MESTCBG5.jpg';
	$background_images[5] = 'MESTCBG6.jpg';
	$background_images[6] = 'MESTCBG7.jpg';
	$background_images[7] = 'MESTCBG8.jpg';
	$background_images[8] = 'MESTCBG9.jpg';

	$captions[0] = 'captionbg01.png';
	$captions[1] = 'captionbg02.png';
	$captions[2] = 'captionbg03.png';
	$captions[3] = 'captionbg04.png';
	$captions[4] = 'captionbg05.png';
	$captions[5] = 'captionbg06.png';
	$captions[6] = 'captionbg07.png';
	$captions[7] = 'captionbg08.png';	
	$captions[8] = 'captionbg09.png';

	$credits[0] = 'photo: Rachel Roberts/MESTC Archive';
	$credits[1] = 'photo: Rachel Roberts/MESTC Archive';
	$credits[2] = 'photo: Rachel Roberts/MESTC Archive';
	$credits[3] = 'photo: Julien Jourdes/MESTC Archive';
	$credits[4] = 'photo: courtesy of Carl Hancock Rux';
	$credits[5] = 'photo: Rachel Roberts/MESTC Archive';
	$credits[6] = 'photo: Julien Jourdes/MESTC Archive';
	$credits[7] = 'photo: Jared Asato';
	$credits[8] = 'photo: Rachel Roberts/MESTC Archive';

	$randomnum = rand(0, 8);
	
	$MESTCimagedir = get_stylesheet_directory_uri();
	$MESTCimagedir .= '/library/images/bgs/';
	
    ?><div id="bgpic">
		<img border="0" width="100%" src="<?php echo $MESTCimagedir.$background_images[$randomnum]?>">
		
        <div id="caption">
			<img border="0" src="<?php echo $MESTCimagedir.$captions[$randomnum]?>">
		</div>	

	</div>
	
    <div id="credits">
		<span class="credits"><?php echo $credits[$randomnum]?></span>
	</div>
	<?php
	}
}

add_action ('thematic_before', 'randomize_index_background', 1);
	
	
	


	
// Add Events List and Calendar Button to Events Page

function add_calendar_buttons() {
	if (is_page('events')){
		?><div id="tribe-events-calendar-header" class="clearfix">
			<span class="tribe-events-calendar-buttons"><a class="tribe-events-button-off" href="<?php echo get_site_url(); ?>/events-list/upcoming/">Event List</a>
			<a class="tribe-events-button-off" href="<?php echo get_site_url(); ?>/events-list/month/">Calendar</a>
			</span>
		</div><?php
	}
}
add_action ('thematic_abovecontent', 'add_calendar_buttons', 1);


// This returns the upcoming event for each category on the Events page

function return_upcoming_category_event($upcomingcategory){
	$all_events = tribe_get_events(
        array(
            'eventDisplay'=>'upcoming',
            'posts_per_page'=>1,
            'tax_query'=> array(
                array(
                    'taxonomy' => 'tribe_events_cat',
                    'field' => 'slug',
                    'terms' => $upcomingcategory
                )
            )
    )
    );

    foreach($all_events as $post) {
    setup_postdata($post);
    $space = false; 
	$output = '';
	$key="short-title"; 
	?>
	<hr class="next-event">
    <dl class="upcoming-event"> 
		<dt class="when-event <?php echo $class ?> "><b>Next Event:</b> <?php echo tribe_get_start_date($post->ID, false ); ?>&nbsp;-&nbsp;</dt>
		<dd class="what-event"><a href="<?php echo get_permalink($post->ID)?>" class="<?php echo $upcomingcategory ?>"><?php echo get_post_meta($post->ID, $key, true); ?></a></dd>
	</dl>
    <?php } //endforeach ?>
        <?php wp_reset_query(); 
}


// This generates the season Calendar-at-a-Glance for the Events page

function events_page_side_calendar () {
	$key="short-title";

	if (is_page('events') OR tribe_is_event($post->ID)){
		$get_posts = tribe_get_events(
	        array(
	            'eventDisplay'=>'upcoming',
	            'tax_query'=> array(
	                array(
	                    'taxonomy' => 'tribe_events_cat',
	                    'field' => 'slug',
	                    'terms' => 'current-season'
	                )
	            )
	    )
	    );
?>
	<div id="events-at-a-glance">
	<?php if (!empty($get_posts)){ ?>
	<h2 class="events-sidecal-subheader">Upcoming Events:</h2>
	<dl class="events-sidecal-event">
	<?php

	$month = date('F');
	$showmonth = false;
	$monthcount = 0;

	foreach($get_posts as $eventpost) { 
		setup_postdata($eventpost);
		
	   	if (has_term('us-theatre','tribe_events_cat',$eventpost)) {
			$eventcal = 'us-theatre';
		}
		elseif (has_term('international-theatre','tribe_events_cat',$eventpost))  {
			$eventcal = 'international-theatre';
		}
		elseif (has_term('publication-theatre','tribe_events_cat',$eventpost))  {
			$eventcal = 'publication-theatre';
		}
		elseif (has_term('conferences','tribe_events_cat',$eventpost)) {
			$eventcal = 'conferences';
		}
		elseif (has_term('screenings','tribe_events_cat',$eventpost)) {
			$eventcal = 'screenings';
		}//endif
		
		$eventmonth = tribe_get_start_date( $eventpost->ID, false, 'F' );
		
		if ($eventmonth != $month){
			$month = $eventmonth;
			$showmonth = true;

		} //end if
	
		if ($monthcount == 0 || $showmonth == true){
			$monthheader = '<h2 class="events-sidecal-month">';
			$monthheader .= $month;
			$monthheader .= '</h2>';
			echo $monthheader;				
		} // endif
		
		$showmonth = false;
		$monthcount = 1;
		$event_id = $eventpost->ID;
		?>
		
        <dt class="event-short-date"><?php echo tribe_get_start_date( $eventpost->ID, false, 'M j' );?></dt>
        <dd class="event-short-title"><div class="<?php echo $eventcal;?>"><a href="<?php echo get_permalink($eventpost->ID); ?>" id="post-<?php echo $eventpost->ID ?>"><?php echo get_post_meta($eventpost->ID, $key, true); ?></a></div>
		</dd>
<?php } //endforeach ?>

    </dl>
    <?php 
	}
		$get_oldposts = tribe_get_events(
	        array(
	            'eventDisplay'=>'past',
	            'tax_query'=> array(
	                array(
	                    'taxonomy' => 'tribe_events_cat',
	                    'field' => 'slug',
	                    'terms' => 'current-season'
	                )
	            )
	    )
	    );
	
		
	$get_oldposts = array_reverse($get_oldposts);
	
	if (!empty($get_oldposts)){
	?>

		<h2 class="events-sidecal-subheader2">Past Events:</h2>
		<dl class="events-sidecal-event"><?php
		
		$month = 'none';	
		$showmonth = false;
		
		foreach($get_oldposts as $eventpost) { 
			setup_postdata($eventpost); 
			
			$current_date = date('j');
			$event_date = tribe_get_start_date( $eventpost->ID, false, 'j' );

			if ($current_date!=$event_date){

			   	if (has_term('us-theatre','tribe_events_cat',$eventpost)) {
					$eventcal = 'us-theatre';
				}
				elseif (has_term('international-theatre','tribe_events_cat',$eventpost))  {
					$eventcal = 'international-theatre';
				}
				elseif (has_term('publication-theatre','tribe_events_cat',$eventpost))  {
					$eventcal = 'publication-theatre';
				}
				elseif (has_term('conferences','tribe_events_cat',$eventpost)) {
					$eventcal = 'conferences';
				}
				elseif (has_term('screenings','tribe_events_cat',$eventpost)) {
					$eventcal = 'screenings';
				}//endif
			
				$eventmonth = tribe_get_start_date( $eventpost->ID, false, 'F' );
				
				if ($eventmonth != $month){
					$month = $eventmonth;
					$showmonth = true;
				} //end if
		
				if ($showmonth == true){
					$monthheader = '<h2 class="events-sidecal-month">';
					$monthheader .= $month;
					$monthheader .= '</h2>';
					echo $monthheader;				
				} // endif
			
				$showmonth = false;
				$eventclass = 'us-theatre';
				
				?>
			
				<dt class="event-short-date"><?php echo tribe_get_start_date( $eventpost->ID, false, 'M j' );?></dt>
		        <dd class="event-short-title"><div class="<?php echo $eventcal;?>"><a href="<?php echo get_permalink($eventpost->ID); ?>" id="post-<?php echo $eventpost->ID ?>"><?php echo get_post_meta($eventpost->ID, $key, true); ?></a></div>
				</dd>
					<?php
			}
			
 		} //endforeach ?>

	    </dl>
	    
	<?php
	}
	?>
	</div>
	<?php wp_reset_query();
}
}

add_action('thematic_belowmainasides', 'events_page_side_calendar', 1);