<?php 
/**
 * Customized look for Event List Widget for MESTC Theme
 * 
 * This is the template for the output of the events list widget. 
 * All the items are turned on and off through the widget admin.
 * There is currently no default styling, which is highly needed.
 *
 * You can customize this view by putting a replacement file of the same name (events-list-load-widget-display.php) in the events/ directory of your theme.
 *
 * @return string
 *
 * @package TribeEventsCalendar
 * @since  2.1
 * @author Modern Tribe Inc.
 *
 */

$key="short-title";
$postID= get_the_ID();
	$get_posts = tribe_get_events(
        array(
            'eventDisplay'=>'upcoming',
            'tax_query'=> array(
                array(
                    'taxonomy' => 'tribe_events_cat',
                    'field' => 'slug',
                    'terms' => 'current-season'
                )
            )
    	)
    );
?>
<?php if (!empty($get_posts)){
	foreach($get_posts as $eventpost) { ?>
		<?php setup_postdata($eventpost); ?>
		<li class="tribe-events-list-widget-events">
			<div class="when">
				<?php echo tribe_get_start_date( $eventpost->ID, false, 'F j, Y'); ?> 
			</div>
			<!-- Event Time -->

				<h4 class="entry-title summary <?php 
					//  grab the categories and print them out with a space seperating them
					$tribe_categories = tribe_get_event_cat_slugs();
						foreach ( $tribe_categories as $tribe_category ) {
							echo $tribe_category;
							echo " ";
						}
					?>">
						<a href="<?php echo get_permalink($eventpost->ID); ?>" id="post-<?php echo $eventpost->ID ?>"><?php echo get_post_meta($eventpost->ID, $key, true); ?></a>
				</h4>

			<!-- Event Title -->
		</li>
	<?php } //endforeach ?>
	<?php wp_reset_query(); ?>
<?php } ?>
