<?php
/*
 * Plugin Name: Simp Modal Window
 * Plugin URI: http://www.webstudio55.com/plugins/simp-modal/
 * Description: This plugin provides unlimited completely customizable modal windows (welcome popups), each modal window have their own styles, content, settings, popup can be display on page load or can be trigger by clicking on specefied link id.
 * Version: 1.6
 * Text Domain: simp-modal
 * Author: Shahzad Anjum
 * Author URI: http://www.webstudio55.com/
*/
	
	// define common constants
	define( 'SMP_VER', 1.6 );
	define( 'SMP_NAME', 'simp-modal' );
	define( 'SMP_FULL_NAME', 'SIMP Modal Window' );
	define( 'SMP_URL', WP_PLUGIN_URL .'/' .str_replace(basename( __FILE__), '', plugin_basename(__FILE__) ) );
	define( 'SMP_DIR', WP_PLUGIN_DIR .'/' .str_replace(basename( __FILE__), '', plugin_basename(__FILE__) ) );
	
	// register activation hook
	register_activation_hook( __FILE__, 'simp_modal_window_activate' );
	// register activation hook
	register_deactivation_hook( __FILE__, 'simp_modal_window_deactivate' );
	
	// get ready for localization
	add_action('plugins_loaded', 'smp_localization_init');
	
	function smp_localization_init() {
		load_plugin_textdomain( SMP_NAME, 'wp-content/plugins/simp-modal-window/langs', SMP_DIR .'/langs' ); 
	}
	
	// include simp modal window post type
	include(SMP_DIR .'/inc/simp-post.php');
	
	// include simp modal window output
	include(SMP_DIR .'/inc/simp-output.php');
	
	// include simp modal duplicator
	include(SMP_DIR .'/inc/simp-clone.php');
	
	// include simp modal update checker
	include(SMP_DIR .'/inc/simp-update.php');
	
	// add menu page
	add_action('admin_menu', 'register_simp_modal_menu_page');

	function register_simp_modal_menu_page() {
		add_submenu_page('edit.php?post_type=popups', 'Simp Modal Window Settings', 'Settings', 'manage_options', 'simp_modal_settings', 'build_simp_modal_settings');
	}

	// add an option on activation
	function simp_modal_window_activate() {
		// get option insatlled
		update_option('smp_installed', true);
	}

	// change option value on deactivation
	function simp_modal_window_deactivate() {
		// update option insatlled
		update_option('smp_installed', false);
	}
	
	// build simp modal misc settings page
	function build_simp_modal_settings() { ?>
		<div class="icon32">
			<img src="<?php echo SMP_URL ?>images/icon-32.png">
		</div>
		<h2><?php _e('Simp Modal Misc Settings', SMP_NAME); ?></h2>
		<?php // get values from form inputs
			if ($_POST['submit']) {
				$values = array(
					'jquery' => $_POST['jquery-dst']
				);
				update_option('simp_settings', $values);
			}
			$settings = get_option('simp_settings');
			$jquery = $settings['jquery'];
		?>
		<div class="wrap">
			<style type="text/css">
			span.desc {display:block; color:#999; font-size:11px;}
			.text, .p-select {width:360px;}
			#popupScreen td {padding:12px 10px 10px;}
			</style>
			<form id="popupScreen" action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
				<table class="widefat fixed" style="width:800px; margin-bottom:20px;">
					<thead>
						<tr>
							<th width="240px" scope="col"><?php _e('Settings', SMP_NAME); ?></th>
							<th scope="col"> </th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td><label><?php _e('Load jQuery', SMP_NAME); ?></label></td>
							<td class="forminp">
								<select class="p-select" name="jquery-dst">
									<option value="no"<?php if ($jquery == 'no') echo ' selected="selected"'; ?>><?php _e('Don\'t Load', SMP_NAME); ?></option>
									<option value="yes"<?php if ($jquery == 'yes') echo ' selected="selected"'; ?>><?php _e('Load from Local', SMP_NAME); ?></option>
									<option value="cdn"<?php if ($jquery == 'cdn') echo ' selected="selected"'; ?>><?php _e('Load from Google CDN', SMP_NAME); ?></option>
								</select>
								<span class="desc"><?php _e('If your theme not loading jquery, you can load a copy of jquery from selected source', SMP_NAME); ?>.</span>
							</td>
						</tr>
						<tr>
							<td></td>
							<td class="forminp">
								<input class="button-primary" id="submit" type="submit" name="submit" value="Save Settings" />
							</td>
						</tr>
					</tbody>
				</table>
			</form>
		</div>
		<?php
	}
?>