<?php if (!defined('SMP_VER')) exit('restricted access');
/*
 * @package WordPress
 * @subpackage Simp Modal Window
 */
	// clone modal post
	// Get the post type
	$post_type = isset($_GET['post_type']) ? $_GET['post_type'] : null;
	
	if ($post_type == 'popups') {
		// add clone post link in post row
		add_filter( 'post_row_actions', 'simp_clone_post_row_link', 10, 2 );
		
		function simp_clone_post_row_link($actions, $post) {
			$post_id = $post->ID;
			
			if (!current_user_can( 'edit_post', $post_id ))
			return $post_id;
			
			// Create a nonce & add an action
			$nonce = wp_create_nonce( 'simp_clone_nonce' ); 
			$actions['clone_modal'] = '<a class="clone-this" href="#" data-code="' .$nonce .'" data-id="' .$post_id .'">' .__('Clone Modal', SMP_NAME) .'</a>';
			
			return $actions;
		}
		
		// add action to admin_enqueue_script 
		add_action( 'admin_enqueue_scripts', 'simp_clone_modal_script' );
		
		function simp_clone_modal_script($hook_suffix) {
			if( $hook_suffix == 'edit.php' ) {
				// enqueue post duplictor script
				wp_enqueue_script( 'modal-clone', SMP_URL .'js/smp-clone.js', array('jquery'), SMP_VER );
			}
		}
	}
	
	// add clone modal ajax action
	add_action( 'wp_ajax_clone_modal', 'simp_clone_modal_post' );
	
	function simp_clone_modal_post() {
		$id = $_POST['id'];
		$nonce = $_POST['code'];
		
		//if (!wp_verify_nonce( $nonce, 'simp_clone_nonce' )) die('Security check');
		
		$post = get_post($id);
		
		$clone = array(
			'post_author' => $post->post_author,
			'post_status' => 'draft',
			'post_type' => $post->post_type,
			'post_date' => $post->post_date,
			'post_date_gmt' => $post->post_date_gmt,
			'post_title' => 'Cloned - ' .$post->post_title,
			'post_content' => $post->post_content
		);
		
		$cloned = wp_insert_post($clone, $wp_error);
		
		if ($cloned) {
			// get post meta values from original modal
			$design_data = get_post_meta( $id, 'popup_design_meta', true );
			$settings = get_post_meta( $id, 'popup_set_meta', true );
			
			if ($design_data) {
				// update design meta data
				update_post_meta( $cloned, 'popup_design_meta', $design_data );
			}
			
			if ($settings) {
				// update settings meta data
				update_post_meta( $cloned, 'popup_set_meta', $settings );
			}
			echo true;
		}
		exit;
	}
?>