<?php // get all pages
	$pages = get_pages('sort_column=ID');
	$pg_options = array(
		'index-page' => __('Posts Index Page', SMP_NAME),
		'all-pages' => __('All Pages', SMP_NAME),
		'all-posts' => __('All Posts', SMP_NAME),
		'pages-posts' => __('All Pages and Posts', SMP_NAME),
		'archive' => __('On Archive Pages', SMP_NAME),
		'search' => __('On Search Pages', SMP_NAME),
		'only-specific' => __('Show on Specific IDs', SMP_NAME),
		'exc-specific' => __('Hide on Specific IDs', SMP_NAME),
	);
	
	foreach ( $pages as $page ) {
		$pg_options[$page->ID] = $page->post_title;
	}

// simp input fields array
$simp_fields = array(
	// design tab
	'design' => array(
		'title' => __('Modal Design', SMP_NAME),
		'key' => 'popup_design_meta',
		'subs' => array(
			// layout
			'layout' => array(
				'title' => __('Modal Layout', SMP_NAME),
				'fields' => array(
					'width' => array(
						'type' => 'text',
						'desc' => __('Modal max-width in pixels e.g(380px)', SMP_NAME)
					),
					'height' => array(
						'type' => 'text',
						'desc' => __('Modal max-height in pixels e.g(240px)', SMP_NAME)
					),
					'padding' => array(
						'type' => 'text',
						'desc' => __('Modal padding in pixels e.g(10px)', SMP_NAME)
					),
					'border_radius' => array(
						'type' => 'text',
						'desc' => __('Modal border radius e.g(5px)', SMP_NAME)
					),
					'background' => array(
						'type' => 'color',
						'desc' => __('Modal background color', SMP_NAME)
					)
				)
			),
			// border
			'border' => array(
				'title' => __('Modal Border', SMP_NAME),
				'fields' => array(
					'border' => array(
						'type' => 'select',
						'id' => 'br-select',
						'options' => array('no' => __('No', SMP_NAME), '1px' => '1 Pixel', '2px' => '2 Pixels', '3px' => '3 Pixels', '4px' => '4 Pixels', '5px' => '5 Pixels', '6px' => '6 Pixels', '7px' => '7 Pixels', '8px' => '8 Pixels', '9px' => '9 Pixels', '10px' => '10 Pixels', '12px' => '12 Pixels', '15px' => '15 Pixels', '20px' => '20 Pixels'),
						'desc' => __('Modal border thickness', SMP_NAME)
					),
					'border_style' => array(
						'type' => 'select',
						'id' => 'br-st',
						'options' => array('solid' => __('Solid', SMP_NAME), 'dotted' => __('Dotted', SMP_NAME), 'dashed' => __('Dashed', SMP_NAME)),
						'desc' => __('Modal border style', SMP_NAME)
					),
					'border_color' => array(
						'type' => 'color',
						'id' => 'br-cp',
						'desc' => __('Modal border color', SMP_NAME)
					)
				),
			),
			// box shadow
			'shadow' => array(
				'title' => __('Modal Box Shadow', SMP_NAME),
				'fields' => array(
					'shadow' => array(
						'type' => 'select',
						'id' => 'bs-select',
						'options' => array('no' => __('No', SMP_NAME), '5px' => __('5 Pixels', SMP_NAME), '10px' => __('10 Pixels', SMP_NAME), '15px' => __('15 Pixels', SMP_NAME), '20px' => __('20 Pixels', SMP_NAME), '30px' => __('30 Pixels', SMP_NAME)),
						'desc' => __('Modal box shadow', SMP_NAME)
					),
					'shadow_opacity' => array(
						'type' => 'select',
						'id' => 'bs-op',
						'options' => array('.1' => '10%', '.15' => '15%', '.2' => '20%',  '.25' => '25%', '.3' => '30%', '.35' => '35%', '.4' => '40%', '.5' => '50%', '.6' => '60%', '.7' => '70%', '.8' => '80%', '.9' => '90%', '1.0' => '100%'),
						'desc' => __('Modal box shadow opacity)', SMP_NAME)
					),
					'shadow_color' => array(
						'type' => 'color',
						'id' => 'bs-cp',
						'desc' => __('Modal box shadow color', SMP_NAME)
					)
				)
			),
			// overlay
			'overlay' => array(
				'title' => __('Background Overlay', SMP_NAME),
				'fields' => array(
					'overlay_opacity' => array(
						'type' => 'select',
						'options' => array('.1' => '10%', '.2' => '20%', '.3' => '30%', '.4' => '40%', '.5' => '50%', '.6' => '60%', '.7' => '70%', '.8' => '80%', '.9' => '90%', '1.0' => '100%'),
						'desc' => __('Modal background overly opacity', SMP_NAME)
					),
					'overlay_color' => array(
						'type' => 'color',
						'desc' => __('Modal background overly color', SMP_NAME)
					)
				)
			),
			// close icon
			'icon' => array(
				'title' => __('Modal Close Icon', SMP_NAME),
				'fields' => array(
					'close' => array(
						'type' => 'select',
						'id' => 'cl-select',
						'options' => array('yes' => __('Show Close Icon', SMP_NAME), 'no' => __('Hide Close Icon', SMP_NAME)),
						'desc' => __('Modal close icon', SMP_NAME)
					),
					'close_position' => array(
						'type' => 'select',
						'id' => 'cl-ps',
						'options' => array('tl' => __('Top Left', SMP_NAME), 'tr' => __('Top Right', SMP_NAME), 'bl' => __('Bottom Left', SMP_NAME), 'br' => __('Bottom Right', SMP_NAME)),
						'desc' => __('Modal close position', SMP_NAME)
					),
					'close_icon' => array(
						'type' => 'icon',
						'id' => 'cl-ic',
						'options' => array('close1', 'close2', 'close3', 'close4', 'close5', 'close6'),
						'desc' => __('Modal close icon, click to select', SMP_NAME)
					)
				)
			),
			// custom css style
			'styles' => array(
				'title' => __('Custom CSS Styles', SMP_NAME),
				'fields' => array(
					'custom_css' => array(
						'type' => 'textarea',
						'desc' => __('add your Custom CSS Styles for popup contents', SMP_NAME)
					)
				)
			)
		)
	),
	
	// settings tab
	'settings' => array(
		'title' => __('Modal Settings', SMP_NAME),
		'key' => 'popup_set_meta',
		'subs' => array(
			// display
			'display' => array(
				'title' => __('Modal Display', SMP_NAME),
				'fields' => array(
					'display' => array(
						'type' => 'select',
						'id' => 'dm-select',
						'options' => array('no' => __('Disable', SMP_NAME), 'click' => __('Display On Click', SMP_NAME), 'load' => __('Display On Page Load', SMP_NAME), 'unload' => __('Display On Close Window', SMP_NAME), 'loadxs' => __('Display After X Seconds', SMP_NAME), 'hash' => __('Display on Hashed URL', SMP_NAME)),
						'desc' => __('Modal display method', SMP_NAME)
					),
					'display_button' => array(
						'type' => 'text',
						'id' => 'dm-db',
						'desc' => __('Element id/class/hash, trigger open popup.', SMP_NAME)
					),
					'display_time' => array(
						'type' => 'text',
						'id' => 'dm-dt',
						'desc' => __('Seconds to wait for display e.g(30).', SMP_NAME)
					),
					'close_msg' => array(
						'type' => 'textarea',
						'id' => 'dm-cm',
						'desc' => __('alert message, if on close window selected', SMP_NAME)
					),
					'display_on' => array(
						'type' => 'select',
						'id' => 'do-select',
						'options' => $pg_options,
						'desc' => __('Select where to display popup', SMP_NAME)
					),
					'display_ids' => array(
						'type' => 'textarea',
						'id' => 'do-di',
						'desc' => __('comma-separated page, post IDs', SMP_NAME)
					)
				)
			),
			// border
			'auto' => array(
				'title' => __('Auto Close', SMP_NAME),
				'fields' => array(
					'auto' => array(
						'type' => 'select',
						'id' => 'at-select',
						'options' => array('no' => __('No', SMP_NAME), 'yes' => __('Yes', SMP_NAME)),
						'desc' => __('Auto close modal', SMP_NAME)
					),
					'after' => array(
						'type' => 'text',
						'id' => 'ct-xs',
						'desc' => __('Auto close after X seconds', SMP_NAME)
					),
					'counter' => array(
						'type' => 'select',
						'id' => 'ct-st',
						'options' => array('no' => __('No', SMP_NAME), 'tl' => __('Top Left', SMP_NAME), 'tr' => __('Top Right', SMP_NAME), 'bl' => __('Bottom Left', SMP_NAME), 'br' => __('Bottom Right', SMP_NAME)),
						'desc' => __('Auto close counter display', SMP_NAME)
					),
					'counter_c' => array(
						'type' => 'color',
						'id' => 'ct-cp',
						'desc' => __('Select counter color', SMP_NAME)
					)
				)
			),
			// cookie
			'cookie' => array(
				'title' => __('Set Cookie', SMP_NAME),
				'fields' => array(
					'cookie' => array(
						'type' => 'select',
						'id' => 'ck-select',
						'options' => array('no' => __('No', SMP_NAME), 'yes' => __('Yes', SMP_NAME)),
						'desc' => __('Set cookie in user\'s browser', SMP_NAME)
					),
					'cookie_dur' => array(
						'type' => 'text',
						'id' => 'ck-xs',
						'desc' => __('Enter cookie expiry value in seconds', SMP_NAME)
					)
				)
			),
			// animations
			'animation' => array(
				'title' => __('Modal Animation', SMP_NAME),
				'fields' => array(
					'opening' => array(
						'type' => 'select',
						'options' => array('fadeIn' => 'Fade In', 'fromTop' => 'From Top', 'fromBottom' => 'From Bottom', 'fromLeft' => 'From Left', 'fromRight' => 'From Right', 'scaleUp' => 'Scale Up', 'scaleDown' => 'Scale Down'),
						'desc' => __('Modal opening animation', SMP_NAME)
					),
					'open_speed' => array(
						'type' => 'select',
						'options' => array('100' => '100 MS', '200' => '200 MS', '300' => '300 MS', '400' => '400 MS', '500' => '500 MS', '600' => '600 MS', '700' => '700 MS', '800' => '800 MS', '1000' => '1000 MS'),
						'desc' => __('Opening animation duration)', SMP_NAME)
					),
					'hide_click' => array(
						'type' => 'select',
						'options' => array('true' => 'Yes', 'false' => 'No'),
						'desc' => __('Close modal on overlay click', SMP_NAME)
					),
					'closing' => array(
						'type' => 'select',
						'options' => array('fadeOut' => 'Fade Out', 'toTop' => 'To Top', 'toBottom' => 'To Bottom', 'toLeft' => 'To Left', 'toRight' => 'To Right', 'scaleUp' => 'Scale Up', 'scaleDown' => 'Scale Down'),
						'desc' => __('Modal closing animation', SMP_NAME)
					),
					'close_speed' => array(
						'type' => 'select',
						'options' => array('100' => '100 MS', '200' => '200 MS', '300' => '300 MS', '400' => '400 MS', '500' => '500 MS', '600' => '600 MS', '700' => '700 MS', '800' => '800 MS', '1000' => '1000 MS'),
						'desc' => __('Closing animation duration', SMP_NAME)
					)
				)
			)
		)
	)
);