<?php if (!defined('SMP_VER')) exit('restricted access');
/*
 * @package WordPress
 * @subpackage Simp Modal Window
*/
	/* load jquery js if user want to load, if theme has not loaded jquery
	* else if theme has an instance of jquery already loaded, select "No" from seetings */
	
	if (!is_admin()) {
		// add jquery script init
		add_action('wp_enqueue_scripts', 'simp_enqueue_scripts');

		function simp_enqueue_scripts() {
			// get plugin settings
			$settings = get_option('simp_settings');
			
			// load jquery loacl copy
			if ($settings['jquery'] == 'yes') {
				
				// enqueue jquery script
				wp_enqueue_script( 'jquery' );
				
			} elseif ($settings['jquery'] == 'cdn') {
				
				// load jquery from google CDN
				wp_enqueue_script( 'jquery-cdn', '//ajax.googleapis.com/ajax/libs/jquery/1/jquery.min.js', '', '1.11.1' );
			}
			
			wp_enqueue_script( 'modal-js', SMP_URL .'js/smp-modal-min.js', array('jquery'), '1.6' );
		}
	}
	
	// get cookie data from settings
	function smp_get_cookie_values($id) {
		
		// get values from modal post meta array
		$set = smp_get_modal_settings($id);
		$cookie = $set['cookie'];
		$cookie_dur = $set['cookie_dur'];
		
		if (smp_can_display_modal($id)) {
			$return = true;
			
			// check if cookie enabled
			if ($cookie == 'yes') {
			
				// get current time
				$time = time();
				$exp = $cookie_dur + $time;
				
				// get old cookie if present
				$cookie_name = 'visited' .$id;
				$old_cookie = $_COOKIE[$cookie_name];
				
				// set a new cookie based on settings
				if (!isset($old_cookie)) {
					// new cookie array
					$return = array(
						'id' => $cookie_name,
						'exp' => $exp
					);
				} else {
					$return = false;
				}
			}
			return $return;
		}
	}
	
	// add popup css styles into wp_head
	add_action('wp_head', 'add_simp_styles_head', 99);
	
	function add_simp_styles_head() {
		
		// get design data
		$modals = smp_get_settings_data();
		
		if (is_array($modals)) {
			// init $out var
			$out = '';
			
			foreach ($modals as $modal) {
				
				if ($modal != '') {
					
					// generate css styles based on user inputs
					$design = smp_get_modal_design($modal);
					extract($design);
					
					// get settings
					$settings = smp_get_modal_settings($modal);
					extract($settings);
					
					// print css styles
					$overlay_rgba = simp_hex2rgb($overlay_color) .',' .$overlay_opacity;
					$out .= '#smp-overlay' .$modal .' {background:rgba(' .$overlay_rgba .');} ';
					$out .= '#smp-overlay' .$modal .' .smp-modal {max-width:' .$width .'; max-height:' .$height .'; background:' .$background .';';
					
					// check if border radius value entered
					if ($border_radius != '') {
						$out .= ' -moz-border-radius:' .$border_radius .'; -webkit-border-radius:' .$border_radius .'; border-radius:' .$border_radius .';';
					}
					
					// check if box shadow values entered
					if ($shadow != 'no') {
						$shadow_rgba = simp_hex2rgb($shadow_color) .',' .$shadow_opacity;
						$out .= ' box-shadow:0 0 ' .$shadow .' rgba(' .$shadow_rgba .'); -webkit-box-shadow:0 0 ' .$shadow .' rgba(' .$shadow_rgba .'); -moz-box-shadow:0 0 ' .$shadow .' rgba(' .$shadow_rgba .');';
					}
					
					// check if border values entered
					if ($border != 'no') {
						$out .= ' border:' .$border .' ' .$border_style .' ' .$border_color .';';
					}
					
					// check if modal has padding
					if ($padding != '') {
						$out .= ' padding:' .$padding .';';
					}
					$out .= '} ';
					
					// check if close icon is enabled
					if ($close == 'yes') {
						$out .= '#smp-overlay' .$modal .' .smp-close { ';
						if ($close_position == 'tl') {
							$out .= 'top:-8px; left:-8px;';
						} elseif ($close_position == 'tr') {
							$out .= 'top:-8px; right:-8px;';
						} elseif ($close_position == 'bl') {
							$out .= 'bottom:-8px; left:-8px;';
						} elseif ($close_position == 'br') {
							$out .= 'bottom:-8px; right:-8px;';
						}
						$out .= ' background:url(' .SMP_URL .'images/' .$close_icon .'.png) 0 0 no-repeat;} ';
					} else {
						// if close icon not enabled
						$out .= '#smp-overlay' .$modal .' .smp-close {display:none;} ';
					}
					
					// if auto close enabled
					if ($auto != 'no' && $counter != 'no') {
						$out .= '#smp-overlay' .$modal .' .smp-counter {';
						// if counter display top left
						if ($counter == 'tl') {
							$out .= 'top:2px; left:3px;';
						}
						// if counter display top right
						if ($counter == 'tr') {
							$out .= 'top:2px; right:3px;';
						}
						// if counter display bottom left
						if ($counter == 'bl') {
							$out .= 'bottom:2px; left:3px;';
						}
						// if counter display bottom right
						if ($counter == 'br') {
							$out .= 'bottom:2px; right:3px;';
						}
						// counter text color
						$out .= ' color:' .$counter_c .';} ';
					}
					
					// modal content styles
					$out .= $custom_css;
				}
			}
		}
		
		$out_s = '<style type="text/css">';
		// common styles
		$out_s .= '.smp-overlay {width:100%; height:100%; position:fixed; top:0; left:0; text-align:center; z-index:9998; display:none;} .smp-overlay * {box-sizing:border-box; -moz-box-sizing:border-box; -webkit-box-sizing:border-box;} ';
		$out_s .= '.smp-modal {display:inline-block; margin:1em; position:relative; text-align:left; vertical-align:middle; opacity:0; z-index:9999; cursor:auto;} ';
		$out_s .= '.smp-close {height:24px; width:24px; position:absolute; cursor:pointer;} ';
		$out_s .= '.smp-counter {position:absolute; font-size:10px;} .smp-modal iframe {border:none;} ';
		$out_s .= '.simp-scaleUp, .simp-scaleDown {transition:all .5s ease; -moz-transition:all .5s ease; -webkit-transition:all .5s ease; -ms-transition:all .5s ease;} ';
		$out_s .= '.simp-scaleUp {transform:scale(.1); -moz-transform:scale(.1); -webkit-transform:scale(.1); -ms-transform:scale(.1);} ';
		$out_s .= '.simp-scaleDown {transform:scale(2);  -moz-transform:scale(2); -webkit-transform:scale(2); -ms-transform:scale(2);} ';
		$out_s .= '.simp-noScale {transform:scale(1); -moz-transform:scale(1); -webkit-transform:scale(1); -ms-transform:scale(1);}';
		
		// end styles
		$out_e = '</style>' ."\r\n";
		
		// print css styles
		echo $out_s .$out .$out_e; 
	}

	// add output into wp_footer
	add_action('wp_footer', 'add_simp_wp_footer', 99);

	function add_simp_wp_footer() {
		
		$modals = smp_get_settings_data();
		
		if (is_array($modals)) {
			$output = "<!-- SIMP MODAL --> \r\n";
			foreach ($modals as $modal) {
				// get cookie settings
				$set_cookie = smp_get_cookie_values($modal);
				
				if ($modal != '' && $set_cookie != false) {
					
					// get modal data
					$settings = smp_get_modal_settings($modal);
					extract($settings);
					
					// display method
					if ($display == 'click' || $display == 'hash') {
						$track = $display_button;
					} elseif ($display == 'load') {
						$track = true;
					} elseif ($display == 'unload') {
						$track = $close_msg;
					} elseif ($display == 'loadxs') {
						$track = $display_time * 1000;
					}
					
					// get modal content
					$post = get_post($modal);
					$output .= '<div class="smp-overlay" id="smp-overlay' .$modal .'">';
					$output .= '<div class="smp-modal" data-id="' .$modal .'" data-method="' .$display .'" data-track="' .$track .'" data-opening="' .$opening .'" data-closing="' .$closing .'" data-openspeed="' .$open_speed .'" data-closespeed="' .$close_speed .'" data-bgclose="' .$hide_click .'" data-cookie="' .$set_cookie['exp'] .'">';
					$output .= do_shortcode($post->post_content);
					$output .= '<span class="smp-close"></span>';
					
					// if auto clse and counter is enabled
					if ($auto != 'no') {
						$output .= '<span class="smp-counter" data-count="' .$after .'" data-show="' .($counter != 'no' ? 'true' : 'false') .'"></span>';
					}
					$output .= '</div></div>' ."\r\n";
					
					
				}
			}
			
			// print initilize script
			$script = '<script type="text/javascript">' ."\r\n";
			$script .= '(function($) { $(".smp-modal").each(function() { ';
			$script .= 'var modal = $(this), method = modal.data("method"), track = modal.data("track"), hash = window.location.hash; ';
			$script .= '$(document).ready(function() { if (method == "click") { $(track).on("click", function(e) { modal.simpModal(); e.preventDefault(); }); } ';
			$script .= 'if (method == "loadxs" && track > 0) { var delayTime = setTimeout(function() { modal.simpModal(); clearTimeout(delayTime); }, track); } }); ';
			$script .= 'if (method == "load") { $(window).on("load", modal.simpModal()); } ';
			$script .= 'if (method == "hash" && hash == track) { $(window).on("load", modal.simpModal()); } ';
			$script .= 'if (method == "unload") { var visited = 0; $(window).on("beforeunload", function(ue) { if (visited == 0) { ue.preventDefault(); ue.stopPropagation(); ue.stopImmediatePropagation(); modal.simpModal(); visited++; return track; } }); } }); ';
			$script .= '})(jQuery);' ."\r\n" .'</script>';
		}
		
		// if output, print it
		if ($output) {
			// print output
			echo $output ."\r\n";
		}
		
		// if script, print it
		if ($script) {
			// print script
			echo $script ."\r\n";
		}
	}

	// check modal window is enabled for current post
	function smp_get_settings_data() {
		global $post;
		
		// reset posts query
		wp_reset_query();
		
		// get post id
		$postID = $post->ID;
		
		// get all modal windows
		$modal_query = new WP_Query(
			array(
				'post_type' => 'popups',
				'posts_per_page' => -1
			)
		);
		
		$modals = array();
		
		// start modal windows loop
		if ($modal_query->have_posts()) :
			while ($modal_query->have_posts()) :
				$modal_query->the_post();
				
				// check if modal enabled for current page/post
				if (smp_can_display_modal($post->ID)) {
					$modals[] = $post->ID;
				}
				
			endwhile;
		endif;
		
		// reset posts query
		wp_reset_postdata();
		
		// check modal stats
		$return = array();
		foreach ($modals as $modal) {
			$return[] = smp_get_modal_stats($modal, $postID);
		}
		// return modal settings
		return $return;
	}
	
	// get modal stats by post id
	function smp_get_modal_stats($modID, $postID) {
		// get modal settings from post meta
		$settings = smp_get_modal_settings($modID);
		$display_on = $settings['display_on'];
		$display_ids = $settings['display_ids'];
		$display_ids = explode(',', $display_ids);
		
		// check if current post has modal window
		$modal = false;
		
		// check if modal display on all pages
		if ($display_on == 'all-pages') {
			if (!is_search() && is_page($postID)) $modal = $modID;
			
			// check if modal display on all posts
		} elseif ($display_on == 'index-page') {
			if (!is_search() && is_home()) $modal = $modID;
			
			// check if modal display on all pages and posts
		}  elseif ($display_on == 'all-posts') {
			if (!is_search() && is_single($postID)) $modal = $modID;
			
			// check if modal display on all pages and posts
		} elseif ($display_on == 'pages-posts') {
			$modal = $modID;
			
			// check if modal display on archives
		} elseif ($display_on == 'archive') {
			if (is_archive()) $modal = $modID;
			
			// check if modal display only on search pages
		} elseif ($display_on == 'search') {
			if (is_search() && !is_page()) $modal = $modID;
			
			// check if modal display only on specific posts/pages
		} elseif ($display_on == 'only-specific') {
			if (in_array($postID, $display_ids)) $modal = $modID;
			
			// check if modal don't display on specific pages/posts
		} elseif ($display_on == 'exc-specific') {
			if (!in_array($postID, $display_ids)) $modal = $modID;
		} else {
			if (!is_search() && $display_on == $postID) $modal = $modID;
		}
		
		return $modal;
	}
	
	// get modal settings from post meta
	function smp_get_modal_settings($id) {
		return ($data = get_post_meta( $id, 'popup_set_meta', true )) ? $data : null;
	}
	
	// get modal design from post meta
	function smp_get_modal_design($id) {
		return ($data = get_post_meta( $id, 'popup_design_meta', true )) ? $data : null;
	}
	
	// check if popup need to show
	function smp_can_display_modal($id) {
		// get modal settings
		$settings = smp_get_modal_settings($id);
		$display = $settings['display'];
		
		// make an array of available methods
		$methods = array('click', 'load', 'unload', 'loadxs', 'hash');
		
		if (in_array($display, $methods)) {
			return true;
		} else {
			return false;
		}
	}
	
	// convert hex color to rgb
	function simp_hex2rgb($hex) {
		$hex = str_replace('#', '', $hex);

		$r = hexdec(substr($hex,0,2));
		$g = hexdec(substr($hex,2,2));
		$b = hexdec(substr($hex,4,2));
		$rgb = array($r, $g, $b);
		// returns the rgb values separated by commas
		return implode(',', $rgb);
	}