<?php if (!defined('SMP_VER')) exit('restricted access');
/*
 * @package WordPress
 * @subpackage Simp Modal Window
*/
	// add action register our post type popups
	add_action( 'init', 'register_cpt_simp_modal' );

	// Register our Custom Post type as popups
	function register_cpt_simp_modal() {
		
		// labels text for our post type popups
		$labels = array(
			// post type general name
			'name' => __( 'Simp Popups', SMP_NAME ),
			// post type singular name
			'singular_name' => __( 'Simp Popup', SMP_NAME ),
			'add_new' => __( 'Add New Popup', SMP_NAME ),
			'add_new_item' => __( 'Add New Popup', SMP_NAME ),
			'edit_item' => __( 'Edit Popup', SMP_NAME ),
			'new_item' => __( 'New Popup', SMP_NAME ),
			'view_item' => __( 'View Popup', SMP_NAME ),
			'search_items' => __( 'Search Popups', SMP_NAME ),
			'not_found' =>  __( 'No Popups found', SMP_NAME ),
			'not_found_in_trash' => __( 'No Popups found in Trash', SMP_NAME ),
			'parent_item_colon' => '',
			'menu_name' => 'Simp Popups'
		);
		
		$args = array(
			'labels' => $labels,
			'public' => true,
			'publicly_queryable' => true,
			'show_ui' => true,
			'query_var' => true,
			'show_in_nav_menus' => false,
			'exclude_from_search' => true,
			'menu_icon' => SMP_URL .'/images/icon.png',
			'capability_type' => 'post',
			'hierarchical' => false,
			'has_archive' => false,
			'menu_position' => 6,
			'supports' => array( 'title', 'editor', 'revisions' ),
			'rewrite' => true
		);	
		register_post_type( 'popups' , $args );
	}
	
	// add action for customize simp_modal columns layout
	add_filter( 'manage_edit-popups_columns', 'simp_modal_edit_columns' );
	add_action( 'manage_posts_custom_column',  'simp_modal_custom_columns' );

	function simp_modal_edit_columns( $columns ) {
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'title' => 'Title',
			'type' => 'Display',
			'animation' => 'Animation',
			'cookie' => 'Cookie',
			'date' => 'Date'
		);
		return $columns;
	}
	
	// edit default columns add our custom columns
	function simp_modal_custom_columns( $column ) {
		global $post, $post_ID;
		
		$set = get_post_meta( $post->ID, 'popup_set_meta', true );
		
		switch ( $column ) {
			case 'type' :
				$display = $set['display'];
				switch ($display) {
					// disabled
					case 'no' : echo 'Disabled'; break;
					// display onclick
					case 'click' : echo 'On Click'; break;
					// display on page load
					case 'load' : echo 'On Page Load'; break;
					// display on page unload
					case 'unload' : echo 'On Close Window'; break;
					// timout 5 seconds
					case 'loadxs' : echo 'Display after ' .$set['display_time'] .' seconds'; break;
				}
			break;
			
			case 'animation' :
				echo 'Open:' .$set['opening'] .', Close:' .$set['closing'];
			break;
			
			case 'cookie' :
				$cookie = $set['cookie'];
				$cookie_dur = $set['cookie_dur'];
				
				// check if cookie enabled
				if ($cookie == 'yes') {
					echo $cookie_dur .' seconds';
				} else {
					echo 'Disabled';
				}
			break;
		}
	}

	// popups meta box hook into WordPress
	add_action( 'admin_init', 'add_simp_modal_metabox' );

	// Add meta box
	function add_simp_modal_metabox() {
		add_meta_box( 'simp_modal_meta_box', __( 'Modal Window Settings', SMP_NAME ), 'create_simp_modal_settings', 'popups', 'normal', 'core' );
	}

	function create_simp_modal_settings() {
		global $post, $post_ID;
		
		// include simp input fields
		include(SMP_DIR .'/inc/simp-fields.php');
		
		// generate HTML for our meta box ?>
		<div class="admin-inside-box clearfix">
			<input type="hidden" name="popups_nonce" value="<?php echo wp_create_nonce( basename(__FILE__) ); ?>" />
			<ul class="smp-tabs">
				<li class="active">
					<a href="#tab-design">
						<h4 class="tab-title"><?php _e('Modal Design', SMP_NAME); ?></h4>
					</a>
				</li>
				<li>
					<a href="#tab-settings">
						<h4 class="tab-title"><?php _e('Modal Settings', SMP_NAME); ?></h4>
					</a>
				</li>
			</ul>
			<div class="tab-container">
				<?php foreach ($simp_fields as $tab_key => $tab_group) : ?>
					<ul id="tab-<?php echo $tab_key; ?>" class="tab-content">
						<?php // get saved metadata
						$data = ($d = get_post_meta( $post->ID, $tab_group['key'], true )) ? $d : array();
						foreach ($tab_group['subs'] as $section) { ?>
							<li>
								<div class="smp-label"><label><?php echo $section['title']; ?></label></div>
								<div class="smp-fieldset">
									<?php foreach ($section['fields'] as $field_key => $field) { ;
										// get save field value
										$value = (isset($data[$field_key])) ? $data[$field_key] : '';
										$field_name = $tab_key .'[' .$field_key .']';
										// switch input types
										switch ($field['type']) {
											case 'text': ?>
												<div class="smp-1"<?php echo (isset($field['id']) ? 'id="' .$field['id'] .'"' : ''); ?>>
													<input type="text" class="text" name="<?php echo $field_name; ?>" value="<?php echo $value ?>" />
													<span class="desc"><?php echo $field['desc']; ?>.</span>
												</div>
											<?php break;
											case 'select': ?>
												<div class="smp-1"<?php echo (isset($field['id']) ? 'id="' .$field['id'] .'"' : ''); ?>>
													<select class="p-select" name="<?php echo $field_name; ?>">
														<?php foreach ($field['options'] as $option_key => $option_val) { ?>
															<option value="<?php echo $option_key; ?>"<?php if ($option_key == $value) echo ' selected="selected"'; ?>><?php echo $option_val; ?></option>
														<?php } ?>
													</select>
													<span class="desc"><?php echo $field['desc']; ?>.</span>
												</div>
											<?php break;
											case 'icon': ?>
												<div class="smp-1"<?php echo (isset($field['id']) ? 'id="' .$field['id'] .'"' : ''); ?>>
													<?php foreach ($field['options'] as $option) { ?>
														<span class="icon-select">
															<img class="close-icon<?php if ($option == $value) echo ' selected'; ?>" src="<?php echo SMP_URL ?>images/<?php echo $option; ?>.png" alt="close icon" />
															<input type="radio" class="p-radio" name="<?php echo $field_name; ?>" value="<?php echo $option; ?>"<?php if ($option == $value) echo ' checked="checked"'; ?> />
														</span>
													<?php } ?>
													<span class="desc"><?php echo $field['desc']; ?>.</span>
												</div>
											<?php break;
											case 'color': ?>
												<div class="smp-1"<?php echo (isset($field['id']) ? 'id="' .$field['id'] .'"' : ''); ?>>
													<input type="text" class="color-pick" name="<?php echo $field_name; ?>" value="<?php echo $value ?>" />
													<span class="desc"><?php echo $field['desc']; ?>.</span>
												</div>
											<?php break;
											case 'textarea': ?>
												<div class="smp-<?php echo (($field_key == 'custom_css') ? '2' : '1'); ?>"<?php echo (isset($field['id']) ? 'id="' .$field['id'] .'"' : ''); ?>>
													<textarea class="text" name="<?php echo $field_name; ?>" style="height:100px;"><?php echo $value ?></textarea>
													<span class="desc"><?php echo $field['desc']; ?>.</span>
												</div>
											<?php break;
										}
									} ?>
								</div>
							</li>
						<?php } ?>
					</ul>
				<?php endforeach; ?>
			</div>
			<!-- END tab-container -->
		</div><?php
	}
	
	// Process the popups metabox fields
	add_action( 'save_post', 'save_simp_modal_settings' );

	function save_simp_modal_settings( $post_id ) {
		global $post, $post_ID;
		
		$post_id = (isset($_POST['post_ID'])) ? $_POST['post_ID'] : null;
		
		// check if current user can edit post
		if ( $_POST['post_type'] == 'popups' ) {
			
			// verify nonce
			if ( !wp_verify_nonce($_POST['popups_nonce'], basename(__FILE__)) )
			return $post_id;
			
			if ( !current_user_can( 'edit_post', $post_id ) )
			return $post_id;
			
			$design_data = (isset($_POST['design'])) ? $_POST['design'] : array();
			$settings_data = (isset($_POST['settings'])) ? $_POST['settings'] : array();
			
			// create an array of our input values
			$design = array();
			foreach($design_data as $key => $value) {
				$design[$key] = $value;
			}
			
			// create an array of our input values
			$settings = array();
			foreach($settings_data as $key => $value) {
				$settings[$key] = $value;
			}
			
			// save all data into a single posts meta key
			update_post_meta( $post_id, 'popup_design_meta', $design );
			update_post_meta( $post_id, 'popup_set_meta', $settings );
		}
	}
	
	// add action to print simp modal scripts and styles in post editing
	add_action( 'admin_print_scripts-post-new.php', 'add_simp_modal_scripts', 11 );
	add_action( 'admin_print_scripts-post.php', 'add_simp_modal_scripts', 11 );	
	
	// enqueue simp modal backend scripts and styles
	function add_simp_modal_scripts() {
		global $post;
		
		if ( $post->post_type == 'popups' ) {
			
			// enqueue new wp color picker css
			wp_enqueue_style( 'wp-color-picker' );
			// enqueue new wp color picker script
			wp_enqueue_script( 'wp-color-picker' );
			
			// enqueue simp modal custom css
			wp_enqueue_style( 'simp-style', SMP_URL .'css/smp-post.css' );
			// enqueue simp modal custom script
			wp_enqueue_script( 'simp-script', SMP_URL .'js/smp-post.js' );
		}
	}