<?php if (!defined('SMP_VER')) exit('restricted access');
/*
 * @package WordPress
 * @subpackage Simp Modal Window
 */
	// plugin update notification
	
	// add an update notification to the WordPress Dashboard menu
	add_action('admin_menu', 'smp_update_notifier_menu');

	function smp_update_notifier_menu() {  
		
		// get latest version
		$latest = get_latest_smp_version();
		
		// Compare current plugin version
		if ($latest > SMP_VER) {
			add_dashboard_page( SMP_FULL_NAME .' Plugin Updates', SMP_FULL_NAME .' <span class="update-plugins count-1"><span class="update-count">1</span></span>', 'administrator', 'smp-update-notifier', 'smp_update_notifier');
		}	
	}
	
	// add an update notification to the WordPress 3.1+ Admin Bar
	add_action( 'admin_bar_menu', 'smp_update_notifier_bar_menu', 1000 );

	function smp_update_notifier_bar_menu() {
		global $wp_admin_bar, $wpdb;
		
		// display notification if current user is an administrator
		if ( is_super_admin() || is_admin_bar_showing() ) {
			
			// get latest version
			$latest = get_latest_smp_version();
			if ( is_admin() ) {
				
				// Compare current plugin version
				if ($latest > SMP_VER) {
					$wp_admin_bar->add_menu( array( 'id' => 'plugin_update_notifier', 'title' => '<span>' .SMP_FULL_NAME .' <span id="ab-updates">New Updates</span></span>', 'href' => get_admin_url() .'index.php?page=smp-update-notifier' ) );
				}
			}
		}
	}
	
	// get latest version info
	function get_latest_smp_version() {
		$latest = get_option('smp_latest_version');
		return $latest;
	}
	
	// build update notifier page
	function smp_update_notifier() { ?>
		<style>
			.update-nag { display: none; }
			#instructions {max-width: 800px;}
			h3.title {margin: 30px 0 0; padding: 30px 0 10px; border-top: 1px solid #ddd;}
		</style>

		<div class="wrap">
			
			<div id="icon-tools" class="icon32"></div>
			<h2>Simp Modal Plugin Updates</h2>
			<div id="message" class="updated below-h2"><p><strong>There is a new version of the Simp Modal Window plugin available.</strong> You have version <?php echo SMP_VER; ?> installed. Update to version <?php echo get_latest_smp_version(); ?></p></div>
			
			<div id="instructions">
				<h3>Download and Update Instructions</h3>
				<p><strong>Please note:</strong> make a <strong>backup</strong> of the Plugin inside your WordPress installation folder <strong>/wp-content/plugins/simp-modal-window/</strong></p>
				<p>To update the plugin, login to <a href="http://www.codecanyon.net/">CodeCanyon</a>, head over to your <strong>downloads</strong> section and re-download the plugin like you did when you bought it.</p>
				<p>Extract the zip's contents, look for the extracted plugin folder, and after you have all the new files upload them using FTP to the <strong>/wp-content/plugins/simp-modal-window/</strong> directory overwriting the old ones (this is why it's important to backup any changes you've made to the plugin files).</p>
				<p>If you didn't make any changes to the plugin files, you are free to overwrite them with the new ones without the risk of losing any plugins settings, and backwards compatibility is guaranteed.</p>
			</div>
			
			<h3 class="title">Changelog</h3>
			<?php echo get_option('smp_latest_changes'); ?>
		</div>
		<?php
	}
	
	// hook into smp_version_check
	add_action('smp_version_check', 'get_latest_smp_version_remote');

	// get latest version info from remote server
	function get_latest_smp_version_remote() {
		
		$data = wp_remote_get( 'http://www.webstudio55.com/smp-update.json' );
		$data = wp_remote_retrieve_body( $data );
		
		if ($data) {
			$update = json_decode($data, true);
			$version = $update['version'];
			$changes = $update['changelog'];
			
			// save updates info in options
			update_option('smp_latest_version', $version);
			update_option('smp_latest_changes', $changes);
		}
	}

	// add 6hrs interval in wp cron
	add_filter('cron_schedules', 'cron_add_6hours');

	function cron_add_6hours($schedules) {
		// Add Every 6 hours to the existing schedules.
		$schedules['hours6'] = array(
		'interval' => 21600,
		'display' => __( 'Every 6 Hours' )
		);
		return $schedules;
	}

	// check for updates after each 6 hours
	add_action('wp', 'run_smp_updates_cron');
	
	function run_smp_updates_cron() {
		if (!wp_next_scheduled('smp_version_check')) {
			wp_schedule_event(time(), 'hours6', 'smp_version_check');
		}
	}
?>