/*
 * jQuery Simp Modal Plugin
 * www.webstudio55.com
 * Copyright 2011-2014, WebStudio55
*/
(function($) {
    $.fn.simpModal = function(settings) {
        
		locked = false;
		var modal = $(this),
		modalId = modal.data("id"),
		overlay = modal.parent(),
		counter = modal.find(".smp-counter"),
		countdown = counter.data("count"),
		closebtn = modal.find(".smp-close"),
		cookieval = modal.data("cookie");
		
		// get data attributes as default settings
		var defaults = {
			opening: modal.data("opening"),
	    	closing: modal.data("closing"),
		    openSpeed: modal.data("openspeed"),
		    closeSpeed: modal.data("closespeed"),
		    bgclose: modal.data("bgclose")
		};
		
		var settings = $.extend({}, defaults, settings);
		
		// open modal function
		modal.on("simpOpen", function() {
			overlay.fadeIn(settings.openSpeed).off("click.modalEvent");
			closebtn.off("click.modalEvent");
			
			// get window and modal width, height
			modalWidth = modal.outerWidth();
			modalHeight = modal.outerHeight();
			winWidth = $(window).width();
			winHeight = $(window).height();
			positionY = (winHeight - modalHeight) / 2;
			
			// enable overlay scrolling
			if (modalHeight > winHeight) {
				overlay.css("overflow-y", "scroll");
				positionY = 0;
			}
			
			if (modalWidth > winWidth) {
				overlay.css("overflow-x", "scroll");
			}
			
			if (!locked) {
				lockModal();
				// open animations
				switch (settings.opening) {
					// animation fadeIn
					case "fadeIn":
						modal.css("top", positionY);
						modal.delay(settings.openSpeed/2).animate({"opacity": 1}, settings.openSpeed, unlockModal());
					break;
					// animation fromTop
					case "fromTop":
						modal.css({"top": "-" + modalHeight + "px"});
						modal.delay(settings.openSpeed/2).animate({"opacity": 1, "top": positionY}, settings.openSpeed, unlockModal());
					break;
					// animation fromBottom
					case "fromBottom":
						modal.css({"top": winHeight});
						modal.delay(settings.openSpeed/2).animate({"opacity": 1, "top": positionY}, settings.openSpeed, unlockModal());
					break;
					// animation fromLeft
					case "fromLeft":
						modal.css({"top": positionY, "margin-left": "-" + winWidth + "px"});
						modal.delay(settings.openSpeed/2).animate({"opacity": 1, "margin-left": "1em"}, settings.openSpeed, unlockModal());
					break;
					// animation fromRight
					case "fromRight":
						modal.css({"top": positionY, "margin-left": winWidth});
						modal.delay(settings.openSpeed/2).animate({"opacity": 1, "margin-left": "1em"}, settings.openSpeed, unlockModal());
					break;
					// animation scaleDown
					case "scaleDown":
						modal.removeClass("simp-noScale").addClass("simp-scaleDown").css({"top": positionY, "margin-left": "1em"});
						modal.delay(settings.openSpeed).animate({"opacity": 1}, settings.openSpeed, function() {
							modal.addClass("simp-noScale");
							unlockModal();
						});
					break;
					// animation scaleUp
					case "scaleUp":
						modal.removeClass("simp-noScale").addClass("simp-scaleUp").css({"top": positionY, "margin-left": "1em"});
						modal.delay(settings.openSpeed).animate({"opacity": 1}, settings.openSpeed, function() {
							modal.addClass("simp-noScale");
							unlockModal();
						});
					break;
				}
				
				// if countdown timer
				if (countdown > 0) {
					simpCounter(modal, counter, countdown);
				}
			}
			
			// set cookies
			if (cookieval > 0) {
				var expDate = new Date(cookieval * 1000);
				cookie("visited" + modalId, 1, {expires:expDate, path:"/"});
			}
			modal.off("simpOpen");
		});
		
		// close modal function
		modal.on("simpClose", function() {
			if (!locked) {
				lockModal();
				
				// close animations
				switch (settings.closing) {
					// animation fadeOut
					case "fadeOut":
						modal.animate({"opacity": 0}, settings.closeSpeed);
					break;
					// animation toTop
					case "toTop":
						modal.animate({"opacity": 0, "top": "-" + winHeight}, settings.closeSpeed);
					break;
					// animation toBottom
					case "toBottom":
						modal.animate({"opacity": 0, "top": winHeight}, settings.closeSpeed);
					break;
					// animation toLeft
					case "toLeft":
						modal.animate({"opacity": 0, "top": positionY, "margin-left": "-" + winWidth + "px"}, settings.closeSpeed);
					break;
					// animation toRight
					case "toRight":
						modal.animate({"opacity": 0, "top": positionY, "margin-left": winWidth}, settings.closeSpeed);
					break;
					// animation scaleUp
					case "scaleUp":
						modal.removeClass("simp-noScale simp-scaleUp").addClass("simp-scaleDown");
						modal.animate({"opacity": 0}, settings.closeSpeed, function() {
							modal.removeClass("simp-scaleDown");
						});
					break;
					// animation scaleDown
					case "scaleDown":
						modal.removeClass("simp-noScale simp-scaleDown").addClass("simp-scaleUp");
						modal.animate({"opacity": 0}, settings.closeSpeed, function() {
							modal.removeClass("simp-scaleUp");
						});
					break;
				}
				// fadeOut overlay
				overlay.delay(settings.closeSpeed).fadeOut(settings.closeSpeed, function() {
					unlockModal();
				});
			}
			modal.off("simpClose");
		});
		
		modal.trigger("simpOpen");
		
		//Close Modal Listeners
		var closeButton = closebtn.on("click.modalEvent", function() {
			modal.trigger("simpClose");
		});
		
		if (settings.bgclose) {
			overlay.css("cursor", "pointer")
			overlay.on("click.modalEvent", function (e) {
				if (e.target !== this) return;
				modal.trigger("simpClose");
			});
		}
		
		// close modal on escape key
		$("body").keyup(function(e) {
			if (e.which===27){
				modal.trigger("simpClose");
			}
		});
		
		// Animations Locks
		function unlockModal() {
			locked = false;
		}
		
		function lockModal() {
			locked = true;
		}
		
		// on resize window
		$(window).on("load resize", function() {
			var modalWidth = modal.outerWidth(),
			modalHeight = modal.outerHeight(),
			winWidth = $(window).width(),
			winHeight = $(window).height(),
			positionY = (winHeight - modalHeight) / 2;
			
			if (modalHeight > winHeight) {
				overlay.css("overflow-y", "scroll");
			} else {
				overlay.css("overflow-y", "hidden");
				modal.animate({"top": positionY}, settings.openSpeed/2);
			}
			
			if (modalWidth > winWidth) {
				overlay.css("overflow-x", "scroll");
			} else {
				overlay.css("overflow-x", "hidden");
			}
		});
		
		// countdown timer
		function simpCountDown(nums) {
			var result = "",
			minutes = Math.floor(nums / 60),
			seconds = nums % 60;
			
			if (minutes > 9) {
				result = minutes.toString() + ":";
			} else {
				result = "0" + minutes.toString() + ":";
			}
			if (seconds > 9) {
				result = result + seconds.toString();
			} else {
				result = result + "0" + seconds.toString();
			}
			return result;
		}
		
		// display counter and close popup
		function simpCounter(modal, counter, countdown) {
			var interval = setInterval(function() {
				if (countdown == 0) {
					modal.trigger("simpClose");
					clearInterval(interval);
				} else {
					if (counter.data("show") == true) {
						counter.html(simpCountDown(countdown));
					}
					countdown = countdown - 1;
				}
			}, 1000);
		}
		
		// jquery cookie
		function cookie(name, value, options) {
			var expires = '',
			date,
			match;
			if (typeof value != 'undefined') { // name and value given, set cookie
				options || (options = {});
				if (!value) {
					value = '';
					options.expires = -1;
				}
				if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
					date = new Date;
					if (typeof options.expires == 'number') {
						date.setTime(+new Date() + (options.expires * 864e5)); // 86,400,000s = 1 day
					} else {
						date = options.expires;
					}
					expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
				}
				document.cookie = [
				name,
				'=',
				encodeURIComponent(value),
				expires,
				options.path ? '; path=' + options.path : '',
				options.domain ? '; domain=' + options.domain : '', 
				options.secure ? '; secure' : ''
				].join('');
			} else { // only name given, get cookie
				match = document.cookie.match(new RegExp('(?:^|;)\\s?' + name.replace(/([.*+?^=!:${}()|[\]\/\\])/g, '\\$1') + '=(.*?)(?:;|$)', 'i'));
				return match && unescape(match[1]);
			}
		}
    }
})(jQuery);