<?php

/*
 * wpml multi site config file
 * needs to be loaded before the framework
 */

require_once( 'config-wpml/config.php' );

##################################################################
# AVIA FRAMEWORK by Kriesi

# this include calls a file that automatically includes all
# the files within the folder framework and therefore makes
# all functions and classes available for later use


require_once( 'framework/avia_framework.php' );

##################################################################


//register additional image thumbnail sizes that should be generated when user uploads an image:
global $avia_config;

$avia_config['imgSize']['widget'] 		= array('width'=>36,  'height'=>36 );		// small preview pics eg sidebar news
$avia_config['imgSize']['related'] 		= array('width'=>136, 'height'=>114);		// small images for related items
$avia_config['imgSize']['portfolio'] 	= array('width'=>210, 'height'=>150);		// small preview pic for default portfolio (4 columns )
$avia_config['imgSize']['portfolio2'] 	= array('width'=>450, 'height'=>300);		// medium preview pic for 2 column portfolio and small 3d slider
$avia_config['imgSize']['portfolio3'] 	= array('width'=>290, 'height'=>200);		// medium preview pic for 3 column portfolio
$avia_config['imgSize']['page'] 		= array('width'=>690, 'height'=>200);		// image for pages and one column portfolio
$avia_config['imgSize']['featured'] 	= array('width'=>930, 'height'=>390);		// big images for fullsize pages and fullsize 2D & 3D slider
$avia_config['imgSize']['kenburns'] 	= array('width'=>1300, 'height'=>1300);		// big images for ken burns slider

/*preview images for special column sizes of the dynamic template. you can remove those if you dont use them, it will save performance while uploading images and will also save ftp storage*/
$avia_config['imgSize']['grid6'] 		= array('width'=>450, 'height'=>150); 		// half sized images when using 4 columns
$avia_config['imgSize']['grid8'] 		= array('width'=>610, 'height'=>220);		// two/third image
$avia_config['imgSize']['grid9'] 		= array('width'=>690, 'height'=>150);		// three/fourth image
$avia_config['imgSize']['grid_fifth1'] 	= array('width'=>162, 'height'=>136);		// one fifth
$avia_config['imgSize']['grid_fifth2'] 	= array('width'=>364, 'height'=>136);		// two fifth
$avia_config['imgSize']['grid_fifth3'] 	= array('width'=>556, 'height'=>136);		// three fifth
$avia_config['imgSize']['grid_fifth4'] 	= array('width'=>748, 'height'=>136);	    // four fifth
///////



avia_backend_add_thumbnail_size($avia_config);






##################################################################
# Frontend Stuff necessary for the theme:
##################################################################


$lang = TEMPLATEPATH . '/lang';
load_theme_textdomain('avia_framework', $lang);


/* Register frontend javascripts: */
if(!is_admin()){
	add_action('init', 'avia_frontend_js');
}


if(!function_exists('avia_frontend_js'))
{
	function avia_frontend_js()
	{
		wp_register_script( 'avia-default', AVIA_BASE_URL.'js/avia.js', array('jquery','avia-html5-video'), 1, false );
		wp_register_script( 'avia-prettyPhoto',  AVIA_BASE_URL.'js/prettyPhoto/js/jquery.prettyPhoto.js', 'jquery', "3.0.1", false);
		wp_register_script( 'avia-html5-video',  AVIA_BASE_URL.'js/projekktor/projekktor.min.js', 'jquery', "1", false);
		wp_register_script( 'avia-slider',  AVIA_BASE_URL.'js/aviaslider.js', 'jquery', "2.5.2", false);
		wp_register_script( 'aviation-slider',  AVIA_BASE_URL.'js/aviationslider.js', 'jquery', "1.0.0", false);
	}
}





/* Activate native wordpress navigation menu and register a menu location */

add_theme_support('nav_menus');
register_nav_menu('avia', THEMENAME.' Main Menu');



//load some frontend functions in folder include:

require_once( 'includes/admin/register-widget-area.php' );		// register sidebar widgets for the sidebar and footer
require_once( 'includes/admin/register-portfolio.php' );		// register custom post types for portfolio entries
require_once( 'includes/admin/register-styles.php' );			// register the styles for dynamic frontend styling
require_once( 'includes/admin/register-shortcodes.php' );		// register wordpress shortcodes
require_once( 'includes/loop-comments.php' );					// necessary to display the comments properly
require_once( 'includes/helper-slideshow.php' ); 				// holds the class that generates the 2d & 3d slideshows, as well as feature images
require_once( 'includes/helper-templates.php' ); 				// holds some helper functions necessary for dynamic templates
require_once( 'includes/admin/compat.php' );					// compatibility functions for 3rd party plugins

//activate framework widgets

register_widget( 'avia_newsbox' );
register_widget( 'avia_portfoliobox' );
register_widget( 'avia_socialcount' );
register_widget( 'avia_combo_widget' );
//register_widget( 'avia_partner_widget' );

//call functions for the theme
add_filter('the_content_more_link', 'avia_remove_more_jump_link');
add_post_type_support('page', 'excerpt');


//allow mp4, webm and ogv file uploads
add_filter('upload_mimes','avia_upload_mimes');
function avia_upload_mimes($mimes){ return array_merge($mimes, array ('mp4' => 'video/mp4', 'ogv' => 'video/ogg', 'webm' => 'video/webm')); }



//small helper functions:

function avia_display_heading($force = false, $title = false, $subheading = false, $teaser_text = false, $heading_style = false)
{
	$output = "";
	$paddingClass = "";
	$teaserClass = "";
	$heading_style_bool = false;
	$id = avia_get_the_ID();

	if($heading_style  === false)
	{
		$heading_style = avia_post_meta($id, 'heading_style');
		$heading_style_bool = strpos($heading_style, 'special');
	}


	if($heading_style_bool !== false || $force){

	if($title  === false) 		$title = get_the_title($id);
	if($subheading === false) 	$subheading = avia_post_meta($id, 'subheading');
	if($teaser_text === false) 	$teaser_text = avia_post_meta($id, 'teaser_text');
	if( !$subheading && !$teaser_text )  $paddingClass = 'mediumPadding';
	if( $subheading && !$teaser_text )  $paddingClass = 'lessPadding';
	if( !$title  && !$subheading )  $teaserClass = 'teaserlessPadding';

	$output .= "<div class='special_heading_container ".$paddingClass." class_".$heading_style."_heading'>";
		if($title)  $output .= "<h1 class='special_heading no_cufon'>".$title."</h1>";
		if($subheading)  $output .= "<h3 class='subheading no_cufon'>".$subheading."</h3>";
		if($teaser_text) $output .= "<h4 class='teaser_text ".$teaserClass."'>".nl2br($teaser_text)."</h4>";
	$output .= "</div>";

	}

	return $output;
}



//remove post thumbnails from pages, posts and various custom post types
if(!function_exists('avia_remove_post_thumbnails'))
{
	add_theme_support( 'post-thumbnails' );

	add_action('posts_selection', 'avia_remove_post_thumbnails');
	add_action('init', 'avia_remove_post_thumbnails');
	add_filter('post_updated_messages','avia_remove_post_thumbnails');
	function avia_remove_post_thumbnails($msg)
	{
		global $post_type;
		$remove_when = array('post','page','portfolio');

		if(is_admin())
		{
			foreach($remove_when as $remove)
			{
				if($post_type == $remove || (isset($_GET['post_type']) && $_GET['post_type'] == $remove)) { remove_theme_support( 'post-thumbnails' ); };
			}
		}

		return $msg;
	}
}





/*wordpress 3.4 changed 404 check -  this is the mod for the avia framework to operate*/
function avia_disable_404( $query = false ) {

	global $avia_config, $wp_query;

	if(!isset($avia_config['first_query_run']) && is_front_page() && is_paged())
	{
		$wp_query->is_paged = false;
		$avia_config['first_query_run'] = true;
		add_action( 'wp', 'avia_enable_404' );
	}
}

function avia_enable_404() {

	global $wp_query;
	$wp_query->is_paged = true;

}

add_action( 'pre_get_posts', 'avia_disable_404' ,1 ,10000);

// deactivate default theme seo if third party plugin is used. Currently supported plugins: Yoast WP SEO and All in One SEO
if(defined('WPSEO_VERSION') || class_exists('All_in_One_SEO_Pack')) $avia_config['deactivate_seo'] = true;