/* this prevents dom flickering, needs to be outside of dom.ready event: */
document.documentElement.className += ' js_active ';
/*end dom flickering =) */

//global path: avia_framework_globals.installedAt

jQuery.noConflict();
jQuery(document).ready(function(){

	//activates the prettyphoto lightbox
	if(jQuery.fn.avia_activate_lightbox)		
	jQuery('body').avia_activate_lightbox();
	
	//activates the hover effect for image links
	if(jQuery.fn.avia_activate_hover_effect)		
	jQuery('#main').avia_activate_hover_effect();

	// enhances contact form with ajax capabilities
	if(jQuery.fn.kriesi_ajax_form)
	jQuery('.ajax_form').kriesi_ajax_form();
	
	//smooth scrooling
	if(jQuery.fn.avia_smoothscroll)
	jQuery('a[href*=#]').avia_smoothscroll();
	
	//activates the shortcode content slider
	if(jQuery.fn.avia_sc_slider)								
	jQuery(".content_slider").avia_sc_slider({appendControlls:{}});
	
	//activates the toggle shortcode
	if(jQuery.fn.avia_sc_toggle)
	jQuery('.togglecontainer').avia_sc_toggle();
	
	//activates the tabs shortcode
	if(jQuery.fn.avia_sc_tabs)
	jQuery('.tabcontainer').avia_sc_tabs();
	
	//activate html5 flare video player
	if(jQuery.fn.avia_video_activation)
	jQuery(".avia_video").avia_video_activation({ratio:'16:9'});
	
	//activate html5 flare video player
	if(jQuery.fn.avia_mini_mega)
	jQuery(".main_menu .menu").avia_mini_mega();
	
	//activate equal height for boxed portfolio items
	if(jQuery.fn.avia_portfolio_equal_height)
	jQuery(".template-portfolio-overview .post-entry").not('.post-entry-first').avia_portfolio_equal_height({el:'.post-entry'});
	
	avia_cufon_helper();
	
	
	
	// aviaslider initialisation: multiple small slider
	if(jQuery.fn.aviaSlider)
	jQuery(".aviaslider .slideshow").each(function(){
		jQuery(this).aviaSlider({captionReplacement:'.slideshow_caption'});
	});
		

	// aviaslider initialisation: large aviaslider
	if(jQuery.fn.aviaSlider)
	jQuery(".aviaslider_full .slideshow").each(function(){
	
	jQuery(this).aviaSlider({
			animationSpeed:500,										// animation duration
			autorotation: true,										// autorotation true or false?
			autorotationSpeed:8,									// duration between autorotation switch in Seconds
			transition: 'fade',
			blockSize: {height: 'full', width:'full'},				// heigth and width of the blocks'
			betweenBlockDelay:50,									// delay between each block change
			transitionOrder: ['diagonaltop', 'diagonalbottom','topleft', 'bottomright', 'random'],
			showText: true,											// wether description text should be shown or not 
			display: 'all', 										// showing up blocks: random, topleft, bottomright, diagonaltop, diagonalbottom, all
			switchMovement: false,									// if display is set "topleft" it will switch to "br" every 2nd transition
			slideControlls: 'items',								// which controlls should the be displayed for the user: none, items
			slides: '.featured',									// wich element inside the container should serve as slide
			captionReplacement:'.slideshow_caption'
			});
			
	});	
	
	if(jQuery.fn.aviaSlider_externalControlls)
	jQuery('.aviaslider_full_thumbnails .slidecontrolls').aviaSlider_externalControlls();
	
	// aviaslider initialisation: ken burns slider
	if(jQuery.fn.aviationSlider)
	jQuery(".ken_burns .slideshow").aviationSlider();
	
	
	// improves comment forms
	if(jQuery.fn.kriesi_empty_input)
	jQuery('input:text').kriesi_empty_input();	
	
	avia_iframe_fix();
	
});

function avia_iframe_fix()
{
	var iframe 	= jQuery('.slideshow iframe'),
		youtubeEmbed = jQuery('.slideshow object, .slideshow embed').attr('wmode','opaque');
		
		iframe.each(function()
		{
			var current = jQuery(this),
				src 	= current.attr('src');
			
			if(src)
			{
				if(src.indexOf('?') !== -1)
				{
					src += "&wmode=opaque";
				}
				else
				{
					src += "?wmode=opaque";
				}
				
				current.attr('src', src);
			}
		});
}

	
// -------------------------------------------------------------------------------------------
// input field improvements
// -------------------------------------------------------------------------------------------

(function($)
{
	$.fn.kriesi_empty_input = function(options) 
	{
		return this.each(function()
		{
			var currentField = $(this);
			currentField.methods = 
			{
				startingValue:  currentField.val(),
				
				resetValue: function()
				{	
					var currentValue = currentField.val();
					if(currentField.methods.startingValue == currentValue) currentField.val('');
				},
				
				restoreValue: function()
				{	
					var currentValue = currentField.val();
					if(currentValue == '') currentField.val(currentField.methods.startingValue);
				}
			};
			
			currentField.bind('focus',currentField.methods.resetValue);
			currentField.bind('blur',currentField.methods.restoreValue);
		});
	};
})(jQuery);	

// -------------------------------------------------------------------------------------------
// Avia Mini mega Menu
// -------------------------------------------------------------------------------------------
(function($)
{
	$.fn.avia_mini_mega = function(variables) 
	{
		return this.each(function()
		{
			var container = $(this),
				menuItems = $('li', this),
				allSubLists = menuItems.find(">ul ul"),
				dropdowns 	= allSubLists.css('display','block').parent();
			
				
			dropdowns.each(function()
			{
				var current 		= $(this), 
					sublist 		= current.find(">ul"), 
					childlist 		= sublist.find('ul').css({display:'none'}),
					originHeight 	= sublist.height();
				
				childlist.css({display:'block'});
				
				current.hover(function()
				{
					sublist.stop().animate({height:originHeight}, 500, 'easeOutQuint', function()
					{
						sublist.css({overflow:'visible', height:'auto'});
					});
				},
				function()
				{
					sublist.css({overflow:'hidden'}).stop().animate({height:0}, 500,'easeOutQuint',  function()
					{
						
					});
				}
			);
			});
			
			
			//hide all lists
			allSubLists.css({display:'block', height:'0px', overflow:'hidden'});
			
				
		});
	}
})(jQuery);	


// -------------------------------------------------------------------------------------------
// Portfolio & Column Boxed equal height
// -------------------------------------------------------------------------------------------
(function($)
{
	$.fn.avia_portfolio_equal_height = function(options) 
	{
		var tallest = 0,
			subset = $(),
			defaults = 
			{
				el: '.post-entry'
			};
		
		var options = $.extend(defaults, options);
	
		return this.each(function(i)
		{
			var el = $(this),
				elHeight = el.height(),
				nextEl = el.next(),
				next_is_same_group = nextEl.is(options.el);
				
			subset = subset.add(el);
				
			if(elHeight > tallest) tallest = elHeight;
			
			if(!next_is_same_group)
			{
				subset.css('min-height',tallest);
				subset = $();
				tallest = 0;
			}
			
		});
	};
})(jQuery);


// -------------------------------------------------------------------------------------------
// HTML 5 // Flash self hosted video
// -------------------------------------------------------------------------------------------
(function($)
{
	$.fn.avia_video_activation = function(options) 
	{
		var defaults = 
		{
			ratio: '16:9'
		};
		
		var options = $.extend(defaults, options);
	
		return this.each(function()
		{
			var fv = $(this),
		      	fv_parent = fv.parents('.slideshow:eq(0)'),
		      	fv_height = fv_parent.height(),
		      	fv_width = fv_parent.width();
		      	
		      	
		    var id_to_apply = '#' + $(this).attr('id'),
		      	posterImg = fv.attr('poster');
		      		
		    fv.height(fv_height);
		    fv.width(fv_width);
		    
		    		    
		     projekktor(id_to_apply, {
				 plugins: ['Startbutton', 'Controlbar', 'Bufferingicon'],
				 debug: false, //'console',
				 controls: true,
				 playerFlashMP4: avia_framework_globals.installedAt + 'js/projekktor/jarisplayer.swf',
				 height: fv_height,
				 width: fv_width,
				 poster: posterImg
			});

		});
	};
})(jQuery);
//.ppfsenter, .ppfsexit


// -------------------------------------------------------------------------------------------
// Tab shortcode javascript
// -------------------------------------------------------------------------------------------
(function($)
{
	$.fn.avia_sc_tabs= function(options) 
	{
		var defaults = 
		{
			heading: '.tab',
			content:'.tab_content'
		};
		
		var options = $.extend(defaults, options);
	
		return this.each(function()
		{
			var container = $(this),
				tabs = $(options.heading, container),
				content = $(options.content, container),
				initialOpen = 1;
			
			// sort tabs
			
			if(tabs.length < 2) return;
			
			if(container.is('.tab_initial_open'))
			{
				var myRegexp = /tab_initial_open__(\d+)/;
				var match = myRegexp.exec(container[0].className);
				
				if(match != null && parseInt(match[1]) > 0)
				{
					initialOpen = parseInt(match[1]);
				}
			}
			
			if(!initialOpen || initialOpen > tabs.length) initialOpen = 1;
			
			tabs.prependTo(container).each(function(i)
			{
				var tab = $(this);
				
				//set default tab to open
					if(initialOpen == (i+1))
					{
						tab.addClass('active_tab');
						content.filter(':eq('+i+')').addClass('active_tab_content');
					}
			
				tab.bind('click', function()
				{
					if(!tab.is('.active_tab'))
					{
						$('.active_tab', container).removeClass('active_tab');
						$('.active_tab_content', container).removeClass('active_tab_content');
						
						tab.addClass('active_tab');
						content.filter(':eq('+i+')').addClass('active_tab_content');
					}
					return false;
				});
			});
		
		});
	};
})(jQuery);


// -------------------------------------------------------------------------------------------
// Toggle shortcode javascript
// -------------------------------------------------------------------------------------------
(function($)
{
	$.fn.avia_sc_toggle = function(options) 
	{
		var defaults = 
		{
			heading: '.toggler',
			content: '.toggle_wrap'
		};
		
		var options = $.extend(defaults, options);
	
		return this.each(function()
		{
			var container = $(this),
				heading   = $(options.heading, container),
				allContent = $(options.content, container),
				initialOpen = '';
			
			//check if the container has the class toggle initial open. 
			// if thats the case extract the number from the following class and open that toggle	
			if(container.is('.toggle_initial_open'))
			{
				var myRegexp = /toggle_initial_open__(\d+)/;
				var match = myRegexp.exec(container[0].className);
				
				if(match != null && parseInt(match[1]) > 0)
				{
					initialOpen = parseInt(match[1]);
				}
			}	
			
			heading.each(function(i)
			{
				var thisheading =  $(this),
					content = thisheading.next(options.content, container);
				
				if(initialOpen == (i+1)) { content.css({display:'block'}); }
				
					
				if(content.is(':visible'))
				{
					thisheading.addClass('activeTitle');
				}
				
				thisheading.bind('click', function()
				{	
					if(content.is(':visible'))
					{
						content.slideUp(300);
						thisheading.removeClass('activeTitle');
					}
					else
					{
						if(container.is('.toggle_close_all'))
						{
							allContent.slideUp(300);
							heading.removeClass('activeTitle');
						}
						content.slideDown(300);
						thisheading.addClass('activeTitle');
					}
				});
			});
		});
	};
})(jQuery); 



function avia_cufon_helper()
{
	var elString = '.entry-content h1, .entry-content h2, .teaser_text, .date-container, .comment-container';
	var els = jQuery(elString).not('.no_cufon');
	if(jQuery.browser.msie && jQuery.browser.version < 9)
	{
		els = els.not('.slideshow_caption h1');
	} 
	
	
	
	if(typeof avia_cufon_size_mod == 'string' && avia_cufon_size_mod != "1")
	{
		avia_cufon_size_mod = parseFloat(avia_cufon_size_mod);
		els.each(function()
		{
			$size = parseInt(jQuery(this).css('fontSize'));	
			jQuery(this).css('fontSize', $size * avia_cufon_size_mod)
		});
	}
	
	
	els.addClass('cufon_headings');
}




// -------------------------------------------------------------------------------------------
// Smooth scrooling when clicking on anchor links
// -------------------------------------------------------------------------------------------

(function($)
{
	$.fn.avia_smoothscroll = function(variables) 
	{
		return this.each(function()
		{
			$(this).click(function() {
		
			   var newHash=this.hash;
			   
			   if(newHash != '' && newHash != '#' && !$(this).is('.comment-reply-link, #cancel-comment-reply-link'))
			   {
				   var container = $(this.hash);
				   
				   if(container.length)
				   {
					   var target = container.offset().top,
						   oldLocation=window.location.href.replace(window.location.hash, ''),
						   newLocation=this,
						   duration=800,
						   easing='easeOutQuint';
			
					   // make sure it's the same location      
					   if(oldLocation+newHash==newLocation)
					   {
					      // animate to target and set the hash to the window.location after the animation
					      $('html:not(:animated),body:not(:animated)').animate({ scrollTop: target }, duration, easing, function() {
					
					         // add new hash to the browser location
					         window.location.href=newLocation;
					      });
					
					      // cancel default click action
					      return false;
					   }
					}
				}
			});
		});
	};
})(jQuery);	


// -------------------------------------------------------------------------------------------
// Ligthbox activation
// -------------------------------------------------------------------------------------------

(function($)
{
	$.fn.avia_activate_lightbox = function(variables) 
	{
		var defaults = 
		{
			autolinkElements: 'a[rel^="prettyPhoto"], a[rel^="lightbox"], a[href$=jpg], a[href$=png], a[href$=gif], a[href$=jpeg], a[href$=".mov"] , a[href$=".swf"] , a[href*="vimeo.com"] , a[href*="youtube.com"] , a[href*="screenr.com"]'
		};
		
		var options = $.extend(defaults, variables);
		
		return this.each(function()
		{
			var elements = $(options.autolinkElements, this).not('.noLightbox, .noLightbox a'),
				lastParent = "",
				counter = 0;
		
			elements.each(function()
			{
				var el = $(this),
					parentPost = el.parents('.post-entry:eq(0)'),
					group = 'auto_group';
				
				if(parentPost.get(0) != lastParent)
				{
					lastParent = parentPost.get(0);
					counter ++;
				}
					
				if((el.attr('rel') == undefined || el.attr('rel') == '') && !el.hasClass('noLightbox')) 
				{ 
					el.attr('rel','lightbox['+group+counter+']'); 
					
					//manipulate the link in case we got a screenr video
					if(el.is('a[href*="screenr.com"]'))
					{
						var currentlink = el.attr('href');
						
						if(currentlink.indexOf('embed') !== -1)
						{
							el.attr('href', currentlink + '?iframe=true&width=650&height=396');
						}
						else
						{
							var append =  currentlink.substring(currentlink.lastIndexOf('/') + 1,currentlink.length);
							el.attr('href', 'http://www.screenr.com/embed/' + append + '?iframe=true&width=650&height=396');
						}
					}
				}
			});
			
			if($.fn.prettyPhoto)
			elements.prettyPhoto({ "theme": 'premium_photo', 'slideshow': 5000 }); /* facebook /light_rounded / dark_rounded / light_square / dark_square */								
		});
	};
})(jQuery);	




// -------------------------------------------------------------------------------------------
// Hover effect activation
// -------------------------------------------------------------------------------------------


(function($)
{
	$.fn.avia_activate_hover_effect = function(variables) 
	{
		var defaults = 
		{
			autolinkElements: 'a[rel^="prettyPhoto"], a[rel^="lightbox"], a[href$=jpg], a[href$=png], a[href$=gif], a[href$=jpeg], a[href$=".mov"] , a[href$=".swf"] , a[href*="vimeo.com"] , a[href*="youtube.com"]'
		};
		
		var options = $.extend(defaults, variables);
		
		return this.each(function()
		{
			$(options.autolinkElements, this).contents('img').each(function()
			{
				var img = $(this),
					a = img.parent(),
					preload = img.parents('.preloading'),
					$newclass = 'lightbox_video',
					applied= false;
					
				if(a.attr('href').match(/(jpg|gif|jpeg|png|tif)/)) 
				{ 
					$newclass = 'lightbox_image'; 
				}
				if(a.is('a'))
				{
					if(img.css('float')) {a.css({float:img.css('float')})}
					if(!a.css('position') || a.css('position') == 'static') { a.css({position:'relative', display:'inline-block'}); }
					if(img.is('.aligncenter')) a.css({display:'block'}); 
				}
				
				var bg = $("<span class='image_overlay_effect'></span>").appendTo(a);
					bg.css({display:'block', zIndex:5, opacity:0});
				
				bg.hover(function()
				{	
					if(applied == false && img.css('opacity') > 0.5)
					{
						bg.addClass($newclass);
						applied = true;
					}	
					
					bg.stop().animate({opacity:0.6},400);
				},
				function()
				{
					bg.stop().animate({opacity:0},400);
				});
				
				
				
			});						
		});
	};
})(jQuery);














// -------------------------------------------------------------------------------------------
// content slider
// -------------------------------------------------------------------------------------------

(function($)
{
	$.fn.avia_sc_slider = function(variables, callback) 
	{
		var defaults = 
		{
			slidePadding: 40,
			appendControlls: {'h1':'pos_h1', 'h2':'pos_h2', 'h3':'pos_h3', 'h4':'pos_h4', 'h5':'pos_h5', 'h6':'pos_h6'},
			controllContainerClass: 'contentSlideControlls',
			transitionDuration: 800,								//how fast should images crossfade
			autorotation: true,										//autorotation true or false? (this setting gets overwritten by the class autoslide_true and autoslide_false if applied to the container. easier for shortcode management)
			autorotationInterval: 3000,								//interval between transition if autorotation is active ()also gets overwritten by autoslidedelay__(number)
			transitionEasing: 'easeOutQuint'
		};
		
		var options = $.extend(defaults, variables);
				
		return this.each(function()
		{
			var container = $(this),
				slides = $('.single_slide', container),
				slideCount = slides.length,
				firstSlide = slides.filter(':eq(0)'),
				followslides = $('.single_slide:not(:first)', container),
				innerContainer = "",
				innerContainerWidth = (container.width() * slideCount) + (options.slidePadding * slideCount),
				i = 0,
				interval = "",
				controlls = $();
				
			container.methods = 
			{
				preload: function()
				{
					followslides.css({display:"none"});
										
					
					if(!slideCount)
					{
						container.methods.init();
					}
					else
					{
						container.aviaImagePreloader(container.methods.init);
					}
				},
				
				init: function()
				{
					if(slideCount > 1)
					{
						//set container height to match the first slide
						container.height(firstSlide.height());
						
						//wrap additional container arround slides and align slides within that container
						slides.wrapAll('<div class="inner_slide_container" />').css({float:'left', 
																					 width:container.width(), 
																					 display:'block', 
																					 paddingRight:options.slidePadding
																					 });
																					 
						innerContainer = $('.inner_slide_container', container).width(innerContainerWidth);
						
						//attach controll elements
						container.methods.appenControlls();
						
						//start autoslide
						container.methods.autoRotation();
					}
				},
				
				change: function()
				{
					//move inner container
					var moveTo = ((-i * container.width()) - (i * options.slidePadding));
					innerContainer.stop().animate({left: moveTo}, options.transitionDuration, options.transitionEasing);
					
					//change height of outer container
					var nextSlideHeight = slides.filter(':eq('+i+')').height();
					container.stop().animate({height: nextSlideHeight}, options.transitionDuration, options.transitionEasing);
					
					//change active state of controlls
					var controllLinks = $('a', controlls);
					controllLinks.removeClass('activeItem');
					controllLinks.filter(':eq('+i+')').addClass('activeItem');
				},
				
				setSlideNumber: function(event)
				{
				
					var stop = false;
					
					if(event)
					{ 
						clearInterval(interval);
						
						if(event.data.show == 'next') i++;
						if(event.data.show == 'prev') i--;
						if(typeof(event.data.show) == 'number') 
						{
							//check if next slide is the same as current slide
							if(i != event.data.show) 
							{
								i = event.data.show;
							}
							else
							{
								stop = true;
							}
						}
					}
					else
					{
						i++;
					}
					
					if(i+1 > slideCount) { i = 0; } else
					if(i < 0) {i = slideCount-1; }
					
					if(!stop) // prevents transition if the next slide and the current slide are the same
					{
					    container.methods.change();
					}

					
					
					return false;
				},
				
				appenControlls: function()
				{
					//if controlls should be added by javascript and we got more than 1 slide 
					if(options.appendControlls && slideCount > 1)
					{	
						//check where to position the controll element, depending on the first element within the slide
						var positioningClass = '';
						
						for (var key in options.appendControlls)
						{
							if(!positioningClass)
							{
								if($(':first', firstSlide).is(key))
								{
									positioningClass = options.appendControlls[key];
								}
								
							}
						}
						
						
						//append the controlls
						var firstClass = 'class="activeItem"';
						
						controlls = $('<div></div>').addClass(options.controllContainerClass)
													.addClass(positioningClass)
													.css({visibility:'hidden', opacity:0});
														
							if(positioningClass)
							{
								controlls.appendTo(container);
							}							
							else
							{
								controlls.insertAfter(container);
							}
														
						slides.each(function(i)
						{ 
							var link = $('<a '+firstClass+' href="#">'+(i+1)+'</a>').appendTo(controlls); firstClass = ""; 
								link.bind('click', {show: i}, container.methods.setSlideNumber);
						});
						
						controlls.css({visibility:'visible', opacity:0}).animate({opacity:1},400);
					}
				},
				
				autoRotation: function()
				{
					if(container.is('.autoslide_true'))
					{
						options.autorotation = true;
						
					var myRegexp = /autoslidedelay__(\d+)/g;
					var match = myRegexp.exec(container[0].className);
					
					if(parseInt(match[1]) > 0)
					{
						options.autorotationInterval = parseInt(match[1]) * 1000;
					}
					

						
					}
					else if(container.is('.autoslide_false'))
					{
						options.autorotation = false;
					}
				
				
					if(options.autorotation)
					{
						interval = setInterval(function()
						{ 	
							container.methods.setSlideNumber();
						},
						options.autorotationInterval);
					}
				}
			};
			
			
			container.methods.preload();
		});
	};
})(jQuery);

		
		
// -------------------------------------------------------------------------------------------
// Main Slideshow
// -------------------------------------------------------------------------------------------		

(function($)
{
	$.fn.avia_fade_slider = function(variables) 
	{
		var defaults = 
		{
			slides:'.featured',										//which elements should serve as slide
			transitionDuration: 800,								//how fast should images crossfade
			transitionEasing: 'easeOutQuint',						//easing for the container movement if images got different sizes
			firstFadeInOfElements: 800,								// after preloading how fast should elements be displayed
			appendControlls: true,									//attach controlls via javascript (set to false if JS should not add them)
			appendAutoSlideshowControlls: 'autoslidecontrolls',		//attach play pause fwd and back bitton for the dia show (set to false if you dont want to add them)
			controllContainerClass:'slidecontrolls',				//container class for slidecontrolls. <a> tags within this container serve as slide controll
			appendCaption: 'slideshow_caption',						//caption div class name. change to false if you dont want to display caption
			convertAttributes: false								// should the image title and alt tag be converted into caption and headlines?		
		},
		
		options = $.extend(defaults, variables);
		
		return this.each(function()
		{
			var container = $(this),
				slideshow_container = $('.slideshow', this),
				slides = $(options.slides, container).css({display:'relative'}),
				currentSlide = slides.filter(':eq(0)'),
				slideCount = slides.length,
				interval = "",
				i = 0,
				animating = false,
				captions = $(),
				controlls = $(),
				slideControlls = $()
				nextSlide = $();			
			
			
			//helper contains functions that need to be done over and over again
			var helper = 
			{ 				
				autoRotation: function()
				{
					if(options.autorotation && slideCount > 1)
					{
						interval = setInterval(function()
						{ 	
							helper.setSlideNumber();
						},
						options.autorotationInterval);
					}
				},
				
				toggleAutoRotation: function(deactivate)
				{
					var button = $('.ctrl_play, .ctrl_pause', slideControlls);
					if (button.is('.ctrl_play') || deactivate == 'deactivate')
					{
						clearInterval(interval);
						button.removeClass('ctrl_play');
					}
					else
					{
						options.autorotation = true;
						helper.setSlideNumber();
						helper.autoRotation();
						button.addClass('ctrl_play');
					}
					return false;
				},
				
				newChangePossible: function()
				{
					animating = false;
				},
			
				setSlideNumber: function(event)
				{
					//stop in case of hidden portfolio items
					if(container.is(':hidden')) return false;
				
					var stop = false;
					if(event) helper.toggleAutoRotation('deactivate');
					
					if(!animating) //prevents transition if slides are already changing
					{
						var restore = i;
						
						if(event)
						{ 
							if(event.data.show == 'next') i++;
							if(event.data.show == 'prev') i--;
							if(typeof(event.data.show) == 'number') 
							{
								//check if next slide is the same as current slide
								if(i != event.data.show) 
								{
									i = event.data.show;
								}
								else
								{
									stop = true;
								}
							}
						}
						else
						{
							i++;
						}
						
						if(i+1 > slideCount) { i = 0; } else
						if(i < 0) {i = slideCount-1};
						
						//check if next Slide is animating, if so stop and reset i
						if(slides.filter(':eq('+(i)+')').is(':animated')) { stop = true; i = restore;}
			
											
						if(!stop) // prevents transition if the next slide and the current slide are the same
						{
							animating = true;
							animatingTimeout = setTimeout(helper.newChangePossible, (options.transitionDuration + 100)/(slideCount-1));
							
							helper.change();
						}
					}
					return false;
				},
				
				change: function()
				{	
					//set controll status
					var activeControll = controlls.find('a:eq('+(i)+')'),
						newHeight = currentSlide.height();
							
					$('.activeItem', controlls).removeClass('activeItem');
					activeControll.addClass('activeItem');
					
					
					//prepare container
					slideshow_container.height(newHeight);
					nextSlide = slides.filter(':eq('+(i)+')');
					
					//check for video content
					var videoContentCurrent = currentSlide.find('object, embed, iframe, video, .avia_video'),
						videoContentNext = nextSlide.find('object, embed, iframe, video, .avia_video'),
						video_slide_helper = $("<li class='video_slide_helper'></li>").css({opacity:0});
						
					if(videoContentCurrent.length || videoContentNext.length)
					{
						//todo: nice transition for video content
						video_slide_helper.appendTo(slideshow_container).animate({opacity:1}, function()
						{
							currentSlide.css('display','none');
							nextSlide.css({display:"block", zIndex:2, position:'absolute', top:'0px'});
							currentSlide = nextSlide;
							
							
							helper.adjust_size(currentSlide, function()
							{
								video_slide_helper.fadeOut(options.transitionDuration, function()
								{
									video_slide_helper.remove();
								});
							});
						});
					}
					else
					{
						//prepare slides
						currentSlide.css({display:"block", position:'absolute', zIndex:3});
						nextSlide.css({display:"block", zIndex:2, position:'absolute', top:'0px'});
					
					
						currentSlide.fadeOut( options.transitionDuration );
						currentSlide = nextSlide;
						helper.adjust_size(currentSlide);
					}

				},
				
				adjust_size: function(element, callback)
				{	
					var newHeight = element.height();
					
					
					slideshow_container.animate({height:newHeight}, options.transitionDuration, function()
					{
						element.css('position','relative');
						slideshow_container.css('height', 'auto');
						
						if (callback  instanceof Function) { callback.call(this);  }
					});
				}

			};
			
			
			//methods holds one time executions
			var methods = 
			{
				preload : function(container)
				{
					if($.fn.aviaImagePreloader) 
					{ 
						container.aviaImagePreloader({fadeInSpeed: options.firstFadeInOfElements}, methods.init);
					}
					else
					{
						methods.init();
					}
				},
				
				init: function()
				{
					//adjust the height of the first slide
					helper.adjust_size(slides.filter(':eq(0)'));
					
					//get settings for autorotation
					methods.set_autorotation();
					
					//append slidecontrolls
					methods.appendControlls();
					
					//check and add slideshow Captions
					methods.appendCaption();
						
					//show appended elemens
					methods.showAppended();
					
					//init autorotation
					helper.autoRotation();
				},
				
				set_autorotation: function()
				{
					if(container.is('.autoslide_true'))
					{
						options.autorotation = true;
						
						var myRegexp = /autoslidedelay__(\d+)/g;
						var match = myRegexp.exec(container[0].className);
						
						if(match != null && parseInt(match[1]) > 0)
						{
							options.autorotationInterval = parseInt(match[1]) * 1000;
						}
					}
					else
					{
						options.autorotation = false;
					}
				},
				
				appendControlls: function()
				{
					//if controlls should be added by javascript and we got more than 1 slide 
					if(slideCount > 1)
					{ 
						var firstClass = 'class="activeItem"';
						
						controlls = $('<div></div>').appendTo(container)
													.addClass(options.controllContainerClass)
													.css({visibility:'hidden', opacity:0});
												
						slides.each(function(i){ $('<a '+firstClass+' href="#"></a>').appendTo(controlls); firstClass = ""; });
					}
					
					if(!options.appendControlls)
					{
						controlls.css({display:'none'});
					}
					
					//if we got controlls (either added by js above, or already available within the html source code add the click behaviour:
					if(options.controllContainerClass)
					{
						var links = $('.'+options.controllContainerClass, container).find('a');							
						links.each(function(i)
						{
							$(this).bind('click', {show: i}, helper.setSlideNumber);
						});
					}
					
					//slideshow controll buttons
					if(options.appendAutoSlideshowControlls && options.appendControlls && slideCount > 1)
					{
						slideControlls = $('<div></div>').appendTo(container)
														 .addClass(options.appendAutoSlideshowControlls)
														 .css({visibility:'hidden', opacity:0});
						var	status = 'ctrl_pause';
						
						if(options.autorotation) status += ' ctrl_play';
						
						slideControlls.html('<a class="ctrl_fwd" href=""></a><a class="'+status+'" href=""></a><a class="ctrl_back" href=""></a>');
						
						$('.ctrl_back', slideControlls).bind('click', {show: 'prev'}, methods.setSlideNumber);
						$('.ctrl_fwd', slideControlls).bind('click', {show: 'next'}, methods.setSlideNumber);
						$('.ctrl_pause, .ctrl_play', slideControlls).bind('click', methods.toggleAutoRotation);
					}
					
				},
				
				appendCaption: function()
				{
					if(options.appendCaption && jQuery.fn.aviaConvertAttribute2HTML)
					{
						if(options.convertAttributes) // if we want to use the image data convert it, otherwise check if there is already a caption available and hide it 
						{
							slides.aviaConvertAttribute2HTML({newContainerClass: options.appendCaption});
						}
						captions = $('.'+options.appendCaption).css({visibility:'hidden', opacity:0});
					}
				},
				
				showAppended: function()
					{
						var opa = 1;
						if($.browser.msie && $.browser.version < 9) opa = 0.8;
					
						$('.'+options.appendCaption+', .'+ options.appendAutoSlideshowControlls+ ', .'+options.controllContainerClass).css('visibility','visible').animate({opacity:opa}, options.firstFadeInOfElements );
					}
					
					
			}; // end methods
			
			
			methods.preload(container);
			

		});
	
	}
	
})(jQuery);


// -------------------------------------------------------------------------------------------
// Slideshow supporting function that adds captions
// -------------------------------------------------------------------------------------------

(function($)
{
	$.fn.aviaConvertAttribute2HTML = function(variables) 
	{
		var defaults = 
		{
			elements: 'img',
			newContainer:'div',
			newContainerClass: 'slideshow_caption',
			sets: {title: 'h1', alt: 'p'},
			split: '::',
			splitWrap: 'h1'
		};
		
		var options = $.extend(defaults, variables);
		
		return this.each(function()
		{
			var container = $(this),
				elements = $(options.elements, container);
				
			elements.each(function()
			{
				var element = $(this),
					newContainer = $('<'+options.newContainer+'>').addClass(options.newContainerClass).appendTo(container);
			
				for (var key in options.sets)
				{
					var description = "";
					
					//check if the attribute got a value
					if(element.attr(key))
					{
						description = element.attr(key);
					}
					
					//if value is set and wrapping element is defined
					if(options.sets[key] && description)
					{
						description = '<'+options.sets[key]+'>'+description+'</'+options.sets[key]+'>';
					}
					
					//split option
					var splitdesc = description.split(options.split);
							
					if(splitdesc[0] != "" )
					{
						if(splitdesc[1] != undefined )
						{
							description = "<"+options.splitWrap+">"+splitdesc[0] +"</"+options.splitWrap+">"+splitdesc[1]; 
						}
						else
						{
							description = splitdesc[0];
						}
					}
					
					newContainer.html(newContainer.html() + description);
				}
				
			});	
			
		});
		
	};
	
})(jQuery);	


// -------------------------------------------------------------------------------------------
// input field improvements
// -------------------------------------------------------------------------------------------

(function($)
{
	$.fn.kriesi_empty_input = function(options) 
	{
		return this.each(function()
		{
			var currentField = $(this);
			currentField.methods = 
			{
				startingValue:  currentField.val(),
				
				resetValue: function()
				{	
					var currentValue = currentField.val();
					if(currentField.methods.startingValue == currentValue) currentField.val('');
				},
				
				restoreValue: function()
				{	
					var currentValue = currentField.val();
					if(currentValue == '') currentField.val(currentField.methods.startingValue);
				}
			};
			
			currentField.bind('focus',currentField.methods.resetValue);
			currentField.bind('blur',currentField.methods.restoreValue);
		});
	};
})(jQuery);	

// -------------------------------------------------------------------------------------------
// contact form ajax improvements
// -------------------------------------------------------------------------------------------

(function($)
{
	$.fn.kriesi_ajax_form = function(variables) 
	{
		var defaults = 
		{
			sendPath: 'send.php',
			responseContainer: '#ajaxresponse'
		};
		
		var options = $.extend(defaults, variables);
		
		return this.each(function()
		{
			var form = $(this),
				form_sent = false,
				send = 
				{
					formElements: form.find('textarea, select, input[type=text], input[type=hidden]'),
					validationError:false,
					button : form.find('input:submit'),
					dataObj : {}
				};
			
			responseContainer = $(options.responseContainer+":eq(0)");
			
			send.button.bind('click', checkElements);
			
			function send_ajax_form()
			{
				if(form_sent){ return false; }
				
				form_sent = true;
				send.button.fadeOut(300);	
				
				responseContainer.load(form.attr('action')+' '+options.responseContainer, send.dataObj, function()
				{
					responseContainer.find('.hidden').css({display:"block"});
					form.slideUp(400, function(){responseContainer.slideDown(400); send.formElements.val('');});
				});
									
				
			}
			
			function checkElements()
			{	
				// reset validation var and send data
				send.validationError = false;
				send.datastring = 'ajax=true';
				
				send.formElements.each(function(i)
				{
					var currentElement = $(this),
						surroundingElement = currentElement.parent(),
						value = currentElement.val(),
						name = currentElement.attr('name'),
					 	classes = currentElement.attr('class'),
					 	nomatch = true;
					 	
					 	send.dataObj[name] = encodeURIComponent(value);
					 	
					 	if(classes && classes.match(/is_empty/))
						{
							if(value == '')
							{
								surroundingElement.attr("class","").addClass("error");
								send.validationError = true;
							}
							else
							{
								surroundingElement.attr("class","").addClass("valid");
							}
							nomatch = false;
						}
						
						if(classes && classes.match(/is_email/))
						{
							if(!value.match(/^\w[\w|\.|\-]+@\w[\w|\.|\-]+\.[a-zA-Z]{2,4}$/))
							{
								surroundingElement.attr("class","").addClass("error");
								send.validationError = true;
							}
							else
							{
								surroundingElement.attr("class","").addClass("valid");
							}	
							nomatch = false;
						}
						
						if(nomatch && value != '')
						{
							surroundingElement.attr("class","").addClass("valid");
						}
				});
				
				if(send.validationError == false)
				{
					send_ajax_form();
				}
				return false;
			}
		});
	};
})(jQuery);






jQuery.easing['jswing'] = jQuery.easing['swing'];

jQuery.extend( jQuery.easing,
{
	def: 'easeOutQuad',
	swing: function (x, t, b, c, d) {
		//alert(jQuery.easing.default);
		return jQuery.easing[jQuery.easing.def](x, t, b, c, d);
	},
	easeInQuad: function (x, t, b, c, d) {
		return c*(t/=d)*t + b;
	},
	easeOutQuad: function (x, t, b, c, d) {
		return -c *(t/=d)*(t-2) + b;
	},
	easeInOutQuad: function (x, t, b, c, d) {
		if ((t/=d/2) < 1) return c/2*t*t + b;
		return -c/2 * ((--t)*(t-2) - 1) + b;
	},
	easeInCubic: function (x, t, b, c, d) {
		return c*(t/=d)*t*t + b;
	},
	easeOutCubic: function (x, t, b, c, d) {
		return c*((t=t/d-1)*t*t + 1) + b;
	},
	easeInOutCubic: function (x, t, b, c, d) {
		if ((t/=d/2) < 1) return c/2*t*t*t + b;
		return c/2*((t-=2)*t*t + 2) + b;
	},
	easeInQuart: function (x, t, b, c, d) {
		return c*(t/=d)*t*t*t + b;
	},
	easeOutQuart: function (x, t, b, c, d) {
		return -c * ((t=t/d-1)*t*t*t - 1) + b;
	},
	easeInOutQuart: function (x, t, b, c, d) {
		if ((t/=d/2) < 1) return c/2*t*t*t*t + b;
		return -c/2 * ((t-=2)*t*t*t - 2) + b;
	},
	easeInQuint: function (x, t, b, c, d) {
		return c*(t/=d)*t*t*t*t + b;
	},
	easeOutQuint: function (x, t, b, c, d) {
		return c*((t=t/d-1)*t*t*t*t + 1) + b;
	},
	easeInOutQuint: function (x, t, b, c, d) {
		if ((t/=d/2) < 1) return c/2*t*t*t*t*t + b;
		return c/2*((t-=2)*t*t*t*t + 2) + b;
	},
	easeInSine: function (x, t, b, c, d) {
		return -c * Math.cos(t/d * (Math.PI/2)) + c + b;
	},
	easeOutSine: function (x, t, b, c, d) {
		return c * Math.sin(t/d * (Math.PI/2)) + b;
	},
	easeInOutSine: function (x, t, b, c, d) {
		return -c/2 * (Math.cos(Math.PI*t/d) - 1) + b;
	},
	easeInExpo: function (x, t, b, c, d) {
		return (t==0) ? b : c * Math.pow(2, 10 * (t/d - 1)) + b;
	},
	easeOutExpo: function (x, t, b, c, d) {
		return (t==d) ? b+c : c * (-Math.pow(2, -10 * t/d) + 1) + b;
	},
	easeInOutExpo: function (x, t, b, c, d) {
		if (t==0) return b;
		if (t==d) return b+c;
		if ((t/=d/2) < 1) return c/2 * Math.pow(2, 10 * (t - 1)) + b;
		return c/2 * (-Math.pow(2, -10 * --t) + 2) + b;
	},
	easeInCirc: function (x, t, b, c, d) {
		return -c * (Math.sqrt(1 - (t/=d)*t) - 1) + b;
	},
	easeOutCirc: function (x, t, b, c, d) {
		return c * Math.sqrt(1 - (t=t/d-1)*t) + b;
	},
	easeInOutCirc: function (x, t, b, c, d) {
		if ((t/=d/2) < 1) return -c/2 * (Math.sqrt(1 - t*t) - 1) + b;
		return c/2 * (Math.sqrt(1 - (t-=2)*t) + 1) + b;
	},
	easeInElastic: function (x, t, b, c, d) {
		var s=1.70158;var p=0;var a=c;
		if (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;
		if (a < Math.abs(c)) { a=c; var s=p/4; }
		else var s = p/(2*Math.PI) * Math.asin (c/a);
		return -(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;
	},
	easeOutElastic: function (x, t, b, c, d) {
		var s=1.70158;var p=0;var a=c;
		if (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;
		if (a < Math.abs(c)) { a=c; var s=p/4; }
		else var s = p/(2*Math.PI) * Math.asin (c/a);
		return a*Math.pow(2,-10*t) * Math.sin( (t*d-s)*(2*Math.PI)/p ) + c + b;
	},
	easeInOutElastic: function (x, t, b, c, d) {
		var s=1.70158;var p=0;var a=c;
		if (t==0) return b;  if ((t/=d/2)==2) return b+c;  if (!p) p=d*(.3*1.5);
		if (a < Math.abs(c)) { a=c; var s=p/4; }
		else var s = p/(2*Math.PI) * Math.asin (c/a);
		if (t < 1) return -.5*(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;
		return a*Math.pow(2,-10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )*.5 + c + b;
	},
	easeInBack: function (x, t, b, c, d, s) {
		if (s == undefined) s = 1.70158;
		return c*(t/=d)*t*((s+1)*t - s) + b;
	},
	easeOutBack: function (x, t, b, c, d, s) {
		if (s == undefined) s = 1.70158;
		return c*((t=t/d-1)*t*((s+1)*t + s) + 1) + b;
	},
	easeInOutBack: function (x, t, b, c, d, s) {
		if (s == undefined) s = 1.70158; 
		if ((t/=d/2) < 1) return c/2*(t*t*(((s*=(1.525))+1)*t - s)) + b;
		return c/2*((t-=2)*t*(((s*=(1.525))+1)*t + s) + 2) + b;
	},
	easeInBounce: function (x, t, b, c, d) {
		return c - jQuery.easing.easeOutBounce (x, d-t, 0, c, d) + b;
	},
	easeOutBounce: function (x, t, b, c, d) {
		if ((t/=d) < (1/2.75)) {
			return c*(7.5625*t*t) + b;
		} else if (t < (2/2.75)) {
			return c*(7.5625*(t-=(1.5/2.75))*t + .75) + b;
		} else if (t < (2.5/2.75)) {
			return c*(7.5625*(t-=(2.25/2.75))*t + .9375) + b;
		} else {
			return c*(7.5625*(t-=(2.625/2.75))*t + .984375) + b;
		}
	},
	easeInOutBounce: function (x, t, b, c, d) {
		if (t < d/2) return jQuery.easing.easeInBounce (x, t*2, 0, c, d) * .5 + b;
		return jQuery.easing.easeOutBounce (x, t*2-d, 0, c, d) * .5 + c*.5 + b;
	}
});


function avia_console(text) {
  ((window.console && console.log) ||
   (window.opera && opera.postError) ||
   window.alert).call(this, text);
}





