<?php
/**
 * Template Name: ES Home Page
 *
 * This is a custom Page template for displaying the ES home page.
 * It will display a slider of selected images and titles and authors of current articles.
 *
 * @package Thematic
 * @subpackage Templates
 *
 */

	// calling the header.php
	get_header();

	// action hook for placing content above #container
	thematic_abovecontainer();
?>

		<div id="container" class="home">

			<?php

				// filter for manipulating the element that wraps the content 
				echo apply_filters( 'thematic_open_id_content', '<div id="content">' . "\n\n" );

				// calling the widget area 'page-top'
            	get_sidebar('page-top');

				// start the loop to get the page content
				the_post();

			?>

				<div id="post-<?php the_ID(); ?>" <?php post_class(); ?> > 

					<div class="entry-content">
						<?php
						$images = get_field('image_gallery');
						if( $images ):
							$numberOfImages = count($images);
							$galleryWidth = $numberOfImages*100;
							$itemWidth = 100/$numberOfImages;
							?>
							<div class="theWholeGallery">
								<ul class="imageGallery" style="width:<?php echo $galleryWidth; ?>%;">
									<?php foreach( $images as $image ): ?>
										<li style="width:<?php echo $itemWidth; ?>%" id="image<?php echo $image['id']; ?>">
											<a href="<?php echo $image['description'];?>">
												<img src="<?php echo $image['url']; ?>">
											</a>
											<div clas="erHomeText">
												<div id="erHomeTitle" class="erdynamicText">
													<a href="<?php echo $image['description'];?>"><?php echo $image['title'];?></a>
												</div>
												<div id="erHomeDesc" class="erdynamicText">
													<?php echo $image['caption'];?>
												</div>
											</div>
										</li>
									<?php endforeach; ?>
									<br clear="all">
								</ul>
								<div class="theDots">
									<ul>
										<?php foreach( $images as $image ): ?>
											<li id="image<?php echo $image['id']; ?>"></li>
										<?php endforeach; ?>
									</ul>
									<br clear="all">
								</div>
							</div>
						<?php endif; ?>
	                    <?php 
	                    	// displays the "Page" content 
	                    	the_content();
	
							// action hook for issue table of contents
							ES_issue_contents();

	                    ?>

					</div><!-- .entry-content -->

				</div><!-- #post -->

	        <?php
					
	       		// action hook for placing contentbelow #post
	       		thematic_belowpost();

       			// action hook for calling the comments_template
       			thematic_comments_template();
	        ?>

			</div><!-- #content -->

			<?php 
				// action hook for placing content below #content
				thematic_belowcontent();
			?> 

		</div><!-- #container -->

<?php 
	// action hook for placing content below #container
	thematic_belowcontainer();

	// calling the standard sidebar 
	thematic_sidebar();

	// calling footer.php
	get_footer();
?>