<?php
// register custom post type to work with
function wpmudev_create_post_type() {
// set up labels
$labels = array(
'name' => 'Course Evaluations',
'singular_name' => 'Evaluation',
'add_new' => 'Add Evaluation',
'add_new_item' => 'Add New Course Evaluation',
'edit_item' => 'Edit Evaluation',
'new_item' => 'New Evaluation',
'all_items' => 'All Evaluations',
'view_item' => 'View Evaluation',
'search_items' => 'Search Evaluations',
'not_found' => 'No Evaluations Found',
'not_found_in_trash' => 'No Evaluations found in Trash',
'parent_item_colon' => '',
'menu_name' => 'Course Evaluations',
);
//register post type
register_post_type( 'evaluation', array(
'labels' => $labels,
'has_archive' => true,
'public' => true,
'supports' => array( 'title', 'editor', 'thumbnail'),
'taxonomies' => array( 'Professor', 'Semester'),
'exclude_from_search' => false,
'capability_type' => 'post',
'rewrite' => array( 'slug' => 'evaluation' ),
)
);
}
add_action( 'init', 'wpmudev_create_post_type' );

// hook into the init action and call CourseEvaluation_taxonomies when it fires
add_action( 'init', 'create_CourseEvaluation_taxonomies', 0 );

// create two taxonomies, Professor and Semester for the post type "Course Evaluations"
function create_courseevaluation_taxonomies() {
	// Add new taxonomy, make it hierarchical (like categories)
	$labels = array(
		'name'              => _x( 'Professor', 'taxonomy general name' ),
		'singular_name'     => _x( 'Professor', 'taxonomy singular name' ),
		'search_items'      => __( 'Search Professors' ),
		'all_items'         => __( 'All Professors' ),
		'parent_item'       => __( 'Parent Professor name' ),
		'parent_item_colon' => __( 'Parent Professor name:' ),
		'edit_item'         => __( 'Edit Professor name' ),
		'update_item'       => __( 'Update Professor name' ),
		'add_new_item'      => __( 'Add New Professor' ),
		'new_item_name'     => __( 'New Professor ' ),
		'menu_name'         => __( 'Professor' ),
	);

	$args = array(
		'hierarchical'      => false,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'Professor' ),
	);

	register_taxonomy( 'Professor', array( 'CourseEvaluation' ), $args );

	$labels = array(
		'name'                       => _x( 'Semester', 'taxonomy general name' ),
		'singular_name'              => _x( 'Semester', 'taxonomy singular name' ),
		'search_items'               => __( 'Search Semesters' ),
		'all_items'                  => __( 'All Semesters' ),
		'parent_item'       	     => __( 'Parent Semester name' ),
		'parent_item_colon'          => __( 'Parent Semester name:' ),
		'edit_item'                  => __( 'Edit Semester' ),
		'update_item'                => __( 'Update Semester' ),
		'add_new_item'               => __( 'Add New Semester' ),
		'new_item_name'              => __( 'New Semester' ),
		'menu_name'                  => __( 'Semester' ),
	);

	$args = array(
		'hierarchical'      => false,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'Semester' ),
	);

	register_taxonomy( 'Semester', 'CourseEvaluation', $args );
}
?>