<!DOCTYPE html>
<html>
<head>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta charset='UTF-8'>
	<link rel="icon" href="<?php echo get_stylesheet_directory_uri(); ?>/favicon.ico" />
	<title><?php wp_title('&raquo;','true','right'); ?><?php bloginfo('name'); ?></title>
	<?php wp_head(); ?>
</head>
<body>
	<?php if(is_page('splash')){ ?>
		<div class="backgrounds">
			<?php
			$images = get_field('background_images');
			if($images):
				foreach($images as $image): ?>
					<div class="backgroundImage" style="background-image: url(<?php echo $image['url']; ?>)">
						<div class="backgroundImageCaption">
							<?php echo $image['caption']; ?>
						</div>
					</div>
				<?php endforeach; ?>
			<?php endif; ?>
		</div>
		<div class="container splash">

			<?php
			$top = get_field('top_splash');
			if($top): ?>
				<div class="top">
					<?php the_field('top_splash');?>
				</div>
			<?php endif; ?>

			<div class="thelogo">
				<?php 
				$link_on = get_field('turn_on_logo_link');
				if($link_on == 'true'){ ?>
					<a href="<?php the_field('logo_links_to'); ?>"><img src="<?php the_field('splash_logo'); ?>"></a>
				<?php } else { ?>
					<img src="<?php the_field('splash_logo'); ?>">
				<?php }; ?>
				
			</div>

			<?php
			$bottom = get_field('bottom_splash');
			if($bottom): ?>
				<div class="bottom">
					<?php the_field('bottom_splash');?>
				</div>
			<?php endif; ?>

		</div>

	<?php } else { ?>
		<div class="container">
			<div id="masthead">
				<div id="header">
					<div id="left_and_right">
						<div class="left_header">
							<?php the_field('segal_presents', 'options'); ?>
							<br />
							<div class="logo">
								<?php 

								$image = get_field('prelude_logo', 'options');

								if( !empty($image) ): ?>
									<?php $url = home_url( '/' ); ?>
									<a href="<?php echo $url; ?>">
									<img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" /></a>

								<?php endif; ?>
							</div>
						</div>
						<div class="right_header">
							<div class="dates_img">
								<?php 

								$image = get_field('dates_image', 'options');

								if( !empty($image) ): ?>

									<img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" />

								<?php endif; ?>
							</div>
							<div class="admission_image">
								<?php 

								$image = get_field('admission_image', 'options');

								if( !empty($image) ): ?>

									<img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" />

								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
				<div id="nav">
					<?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>
				</div>
				<div id="banner_image">
					<?php 

					$post_type = get_post_type();
					if($post_type == 'performance' || $post_type == 'exhibition' || $post_type == 'panel'){ ?>
						<?php $schedule = get_page_by_path('schedule', OBJECT, 'page');
						$image = get_field('sections_banner_image', $schedule->ID);
						if( !empty($image) ): ?>
							<img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" />
						<?php endif; ?>
					<?php } elseif($post_type == 'artist') { ?>
						<?php $artist = get_page_by_path('artists', OBJECT, 'page');
						$image = get_field('sections_banner_image', $artist->ID);
						if( !empty($image) ): ?>
							<img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" />
						<?php endif; ?>
					<?php } else { ?>
						<?php
						$parent = array_reverse(get_post_ancestors($post->ID));
						$first_parent = get_page($parent[0]);
						$parent_id = $first_parent->ID;
						$image = get_field('sections_banner_image', $parent_id);
						if( !empty($image) ): ?>
							<img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" />
						<?php endif; ?>
					<?php }; ?>
				</div>
			</div>
			<div id="content_container">

				<?php
				$parent = array_reverse(get_post_ancestors($post->ID));
				$first_parent = get_page($parent[0]);
				$parent_id = $first_parent->ID;
				$parent_title = get_the_title($parent_id);
				if($parent_title == 'About'){
					wp_nav_menu( array(
						'menu' => 'About Menu',
						'container_class' => 'page_navigation'
					));
				} elseif($parent_title == 'Schedule'){
					wp_nav_menu( array(
						'menu' => 'Schedule Menu',
						'container_class' => 'page_navigation'
					));
				}; ?>
				<?php if( have_rows('content_fields') ): ?>
					<div id="content">
				    <?php while ( have_rows('content_fields') ) : the_row();
				        if( get_row_layout() == 'text' ): ?>
				        	<div class="entry-content">
				        		<?php the_sub_field('text_content'); ?>
				        	</div>
				        <?php elseif( get_row_layout() == 'expandable_content' ): ?>
				        	<div class="expandable">
				        		<div class="expand_title"><div class="plus_or_minus expand_plus">+</div><?php the_sub_field('expand_title'); ?></div>
	            				<div class="expand_content"><?php the_sub_field('expand_content'); ?></div>
	            				<br clear="all">
				        	</div>
				        <?php elseif( get_row_layout() == 'google_map' ): ?>
				        	<?php 

							$location = get_sub_field('the_map');

							if( !empty($location) ):
							?>
							<div class="acf-map">
								<div class="marker" data-lat="<?php echo $location['lat']; ?>" data-lng="<?php echo $location['lng']; ?>"></div>
							</div>
							<?php endif; ?>
				        <?php endif;
				    endwhile; ?>
				    </div>
				<?php else : ?>
				<?php endif; ?>

				<?php if(is_page('artists')){ ?>
					<?php
					$artists = get_posts(array(
						'post_type' => 'artist',
						'orderby' => 'title',
						'order' => 'ASC',
						'posts_per_page' => -1
					));
					?>
					<?php if( $artists ): ?>
						<ul class="artist_list">
						<?php foreach( $artists as $post ): 
							setup_postdata($post); ?>
							<li>
								<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
							</li>
						<?php endforeach; ?>
						<?php wp_reset_postdata(); ?>
						</ul>
					<?php endif; ?>
				<?php }; ?>


				<!--BEGIN SCHEDULE SECTION-->
				<?php if(is_page(array(
						'schedule', 'performances', 'panels', 'exhibitions'
					))){ ?>
					<?php
					if(is_page('schedule')){
						$events = get_posts(array(
							'post_type' => array('performance', 'panel', 'exhibition'),
							'posts_per_page' => -1,
							'meta_query' => array(
								'date_clause' => array(
									'key' => 'date',
									'compare' => 'EXISTS'
								),
								'hour_clause' => array(
									'key' => 'start_hour',
									'compare' => 'EXISTS'
								),
								'minute_clause' => array(
									'key' => 'start_minute',
									'compare' => 'EXISTS'
								),
								'order_clause' => array(
									'key' => 'order',
									'compare' => 'EXISTS'
								)
						        
						    ),
						    'orderby' => array(
						    	'date_clause' => 'ASC',
						    	'hour_clause' => 'ASC',
						    	'minute_clause' => 'ASC',
						    	'order_clause' => 'ASC',
						    )				
						));
					} elseif(is_page('performances')){
						$events = get_posts(array(
							'post_type' => array('performance'),
							'posts_per_page' => -1,
							'meta_query' => array(
								'date_clause' => array(
									'key' => 'date',
									'compare' => 'EXISTS'
								),
								'hour_clause' => array(
									'key' => 'start_hour',
									'compare' => 'EXISTS'
								),
								'minute_clause' => array(
									'key' => 'start_minute',
									'compare' => 'EXISTS'
								),
								'order_clause' => array(
									'key' => 'order',
									'compare' => 'EXISTS'
								)
						        
						    ),
						    'orderby' => array(
						    	'date_clause' => 'ASC',
						    	'hour_clause' => 'ASC',
						    	'minute_clause' => 'ASC',
						    	'order_clause' => 'ASC',
						    )			
						));
					} elseif(is_page('panels')){
						$events = get_posts(array(
							'post_type' => array('panel'),
							'posts_per_page' => -1,
							'meta_query' => array(
								'date_clause' => array(
									'key' => 'date',
									'compare' => 'EXISTS'
								),
								'hour_clause' => array(
									'key' => 'start_hour',
									'compare' => 'EXISTS'
								),
								'minute_clause' => array(
									'key' => 'start_minute',
									'compare' => 'EXISTS'
								),
								'order_clause' => array(
									'key' => 'order',
									'compare' => 'EXISTS'
								)
						        
						    ),
						    'orderby' => array(
						    	'date_clause' => 'ASC',
						    	'hour_clause' => 'ASC',
						    	'minute_clause' => 'ASC',
						    	'order_clause' => 'ASC',
						    )				
						));
					} elseif(is_page('exhibitions')){
						$events = get_posts(array(
							'post_type' => array('exhibition'),
							'posts_per_page' => -1,
							'meta_query' => array(
								'date_clause' => array(
									'key' => 'date',
									'compare' => 'EXISTS'
								),
								'hour_clause' => array(
									'key' => 'start_hour',
									'compare' => 'EXISTS'
								),
								'minute_clause' => array(
									'key' => 'start_minute',
									'compare' => 'EXISTS'
								),
								'order_clause' => array(
									'key' => 'order',
									'compare' => 'EXISTS'
								)
						        
						    ),
						    'orderby' => array(
						    	'date_clause' => 'ASC',
						    	'hour_clause' => 'ASC',
						    	'minute_clause' => 'ASC',
						    	'order_clause' => 'ASC',
						    )			
						));
					};
					?>

				
					<?php if( $events): ?>
						<div id="content">
							<div class="event_list">
							<?php foreach( $events as $post ):
								setup_postdata($post); ?>
								<div class="single_event">
									<div class="date_and_time">
										<?php the_field('date'); ?><br>

										<?php
										$the_start_hour = get_field('start_hour');
										if($the_start_hour >= 12){
											if($the_start_hour > 12){
												$the_start_hour = $the_start_hour - 12;
											} elseif ($the_start_hour == 12){
												$the_start_hour = 12;
											};
											$am_or_pm = 'pm';
										} elseif($the_start_hour == 0){
											$the_start_hour = $the_start_hour + 12;
											$am_or_pm = 'am';
										} elseif($the_start_hour < 12 && $the_start_hour > 0){
											$am_or_pm = 'am';
										};
										if($the_start_hour < 10) {
											$the_start_hour = ltrim($the_start_hour, '0');
										};
										?>

										<?php
										$the_end_hour = get_field('end_hour');
										if($the_end_hour >= 12){
											if($the_end_hour > 12){
												$the_end_hour = $the_end_hour - 12;
											} elseif ($the_end_hour == 12){
												$the_end_hour = 12;
											};
											$am_or_pm = 'pm';
										} elseif($the_end_hour == 0){
											$the_end_hour = $the_end_hour + 12;
											$am_or_pm = 'am';
										} elseif($the_end_hour < 12 && $the_end_hour > 0){
											$am_or_pm = 'am';
										};
										if($the_end_hour < 10) {
											$the_end_hour = ltrim($the_end_hour, '0');
										};
										?>

										<?php echo $the_start_hour; ?>:<?php the_field('start_minute'); ?><?php echo $am_or_pm; ?>&ndash;<?php echo $the_end_hour; ?>:<?php the_field('end_minute'); ?><?php echo $am_or_pm; ?><br>
										<?php the_field('location'); ?>
									</div>
									<div class="right_event_col">
										<?php if(is_page('schedule')){ ?>
											<div class="event_type"><?php echo get_post_type(); ?></div>
										<?php } else { ?>
											<div class="event_type">&nbsp;</div>
										<?php } ?>
										<h2><a href="<?php the_permalink(); ?>" class="<?php echo get_post_type();?>"><?php the_title(); ?></a></h2>
										<?php $artists = get_field('artist'); ?>
										<?php if( $artists ){ ?>
										<div class="artists">
											<ul class="performance_artist schedule">
											<?php foreach( $artists as $post ){
												setup_postdata($post); ?>
												<li class="artist">
													<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a><br>
												</li>
											<?php }; ?>
											</ul>
											<?php wp_reset_postdata(); ?>
										</div>
										<?php }; ?>
									</div>
								</div>
							<?php endforeach; ?>
							<?php wp_reset_postdata(); ?>

							<?php if(is_page('exhibitions') || is_page('performances') || is_page('panels')){
							} else { ?>

								<?php $closing_party = get_page_by_path('schedule/closing-party', OBJECT, 'page');
								$closing_id = $closing_party->ID;
								if($closing_id){ ?>

									<div class="single_event">
										<div class="date_and_time">
											<?php the_field('date', $closing_id); ?><br>

											<?php
											$the_start_hour = get_field('start_hour', $closing_id);
											if($the_start_hour >= 12){
												if($the_start_hour > 12){
													$the_start_hour = $the_start_hour - 12;
												} elseif ($the_start_hour == 12){
													$the_start_hour = 12;
												};
												$am_or_pm = 'pm';
											} elseif($the_start_hour == 0){
												$the_start_hour = $the_start_hour + 12;
												$am_or_pm = 'am';
											} elseif($the_start_hour < 12 && $the_start_hour > 0){
												$am_or_pm = 'am';
											};
											if($the_start_hour < 10) {
												$the_start_hour = ltrim($the_start_hour, '0');
											};
											?>

											<?php
											$the_end_hour = get_field('end_hour', $closing_id);
											if($the_end_hour >= 12){
												if($the_end_hour > 12){
													$the_end_hour = $the_end_hour - 12;
												} elseif ($the_end_hour == 12){
													$the_end_hour = 12;
												};
												$am_or_pm = 'pm';
											} elseif($the_end_hour == 0){
												$the_end_hour = $the_end_hour + 12;
												$am_or_pm = 'am';
											} elseif($the_end_hour < 12 && $the_end_hour > 0){
												$am_or_pm = 'am';
											};
											if($the_end_hour < 10) {
												$the_end_hour = ltrim($the_end_hour, '0');
											};
											?>

											<?php echo $the_start_hour; ?>:<?php the_field('start_minute', $closing_id); ?><?php echo $am_or_pm; ?>&ndash;<?php echo $the_end_hour; ?>:<?php the_field('end_minute', $closing_id); ?><?php echo $am_or_pm; ?>
										</div>
										<div class="right_event_col">
											<div class="event_type">&nbsp;</div>
											<h2><a href="<?php echo get_the_permalink($closing_party->ID); ?>"><?php echo get_the_title($closing_party->ID); ?></a></h2>
											<?php $artists = get_field('artist', $closing_id); ?>
											<?php if( $artists ){ ?>
											<div class="artists">
												<ul class="performance_artist schedule">
												<?php foreach( $artists as $post ){
													setup_postdata($post); ?>
													<li class="artist">
														<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a><br>
													</li>
												<?php }; ?>
												</ul>
												<?php wp_reset_postdata(); ?>
											</div>
											<?php }; ?>
										</div>
									</div>
								<?php }; ?>
							<?php }; ?>


							</div>
						</div>
					<?php endif; ?>
				<?php }; ?>
				<!--END SCHEDULE SECTION-->

				<?php 

				$post_type = get_post_type();
				$post_name = get_query_var('name');
				if($post_type == 'performance' || $post_type == 'panel' || $post_type == 'exhibition' || $post_name == 'closing-party'){ ?>
					<?php $artists = get_field('artist'); ?>
					<div id="content">
						<div class="performance_title">
							<h2><?php echo the_title(); ?></h2>
						</div>
						
						<div class="performance_date">
							<?php the_field('date'); ?><br>
							<?php
							$the_start_hour = get_field('start_hour');
							if($the_start_hour >= 12){
								if($the_start_hour > 12){
									$the_start_hour = $the_start_hour - 12;
								} elseif ($the_start_hour == 12){
									$the_start_hour = 12;
								};
								$am_or_pm = 'pm';
							} elseif($the_start_hour == 0){
								$the_start_hour = $the_start_hour + 12;
								$am_or_pm = 'am';
							} elseif($the_start_hour < 12 && $the_start_hour > 0){
								$am_or_pm = 'am';
							};
							if($the_start_hour < 10) {
								$the_start_hour = ltrim($the_start_hour, '0');
							};
							?>

							<?php
							$the_end_hour = get_field('end_hour');
							if($the_end_hour >= 12){
								if($the_end_hour > 12){
									$the_end_hour = $the_end_hour - 12;
								} elseif ($the_end_hour == 12){
									$the_end_hour = 12;
								};
								$am_or_pm = 'pm';
							} elseif($the_end_hour == 0){
								$the_end_hour = $the_end_hour + 12;
								$am_or_pm = 'am';
							} elseif($the_end_hour < 12 && $the_end_hour > 0){
								$am_or_pm = 'am';
							};
							if($the_end_hour < 10) {
								$the_end_hour = ltrim($the_end_hour, '0');
							};
							?>

							<?php echo $the_start_hour; ?>:<?php the_field('start_minute'); ?><?php echo $am_or_pm; ?>&ndash;<?php echo $the_end_hour; ?>:<?php the_field('end_minute'); ?><?php echo $am_or_pm; ?>
						</div>

						<div class="performance_location">
							<?php the_field('location'); ?>
						</div>

						<?php
						$description = get_field('description'); 
						if($description){ ?>
							<div class="performance_description">
								<?php echo $description; ?>
							</div>
						<?php };
						?>
						<?php if( $artists ){ ?>
						<div class="artists">
							<ul class="performance_artist">
							<?php foreach( $artists as $post ){
								setup_postdata($post); ?>
								<li class="artist">
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a><br>
									<?php $image = get_field('artist_image');
									if( !empty($image) ): ?>
										<div class="artist_image" style="float:right; padding:0 0 20px 20px; width: 33%; height: auto; font-size:.78em;">
											<img style="width:100%; height:auto; padding-bottom:10px;" src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" />
											<?php echo $image['caption']; ?>
										</div>
									<?php endif; ?>
									<?php the_field('artist_bio'); ?>
								</li>
							<?php }; ?>
							</ul>
							<?php wp_reset_postdata(); ?>
						</div>
						<?php }; ?>
					</div>
				<?php } elseif($post_type == 'artist'){ ?>
					<div id="content" class="artist_listing">
						<div class="artist_name">
							<h2><?php echo the_title(); ?></h2>
						</div>
						<div class="artist_bio">
							<?php $image = get_field('artist_image');
							if( !empty($image) ): ?>
								<div class="artist_image" style="float:right; padding:0 0 20px 20px; width: 33%; height: auto; font-size:.78em;">
									<img style="width:100%; height:auto; padding-bottom:10px;" src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" />
									<?php echo $image['caption']; ?>
								</div>
							<?php endif; ?>
							<?php the_field('artist_bio'); ?>
						</div>
						<div class="artists_events">
							<?php
							$performances = get_posts(array(
								'post_type' => 'performance',
								'posts_per_page' => -1,
								'meta_query' => array(
									array(
										'key' => 'artist',
										'value' => '"' . get_the_ID() . '"',
										'compare' => 'LIKE'
									),
										'date_clause' => array(
										'key' => 'date',
										'compare' => 'EXISTS'
									),
									'hour_clause' => array(
										'key' => 'start_hour',
										'compare' => 'EXISTS'
									),
									'minute_clause' => array(
										'key' => 'start_minute',
										'compare' => 'EXISTS'
									),
									'order_clause' => array(
										'key' => 'order',
										'compare' => 'EXISTS'
									)
							        
							    ),
							    'orderby' => array(
							    	'date_clause' => 'ASC',
							    	'hour_clause' => 'ASC',
							    	'minute_clause' => 'ASC',
							    	'order_clause' => 'ASC',
							    )			
							));
							?>
							<?php
							$panels = get_posts(array(
								'post_type' => 'panel',
								'posts_per_page' => -1,
								'meta_query' => array(
									array(
										'key' => 'artist',
										'value' => '"' . get_the_ID() . '"',
										'compare' => 'LIKE'
										)
									),
								'orderby' => 'meta_value',
								'meta_key' => 'date',
								'order' => 'ASC'
							));
							?>
							<?php
							$exhibitions = get_posts(array(
								'post_type' => 'exhibition',
								'posts_per_page' => -1,
								'meta_query' => array(
									array(
										'key' => 'artist',
										'value' => '"' . get_the_ID() . '"',
										'compare' => 'LIKE'
										)
									),
								'orderby' => 'meta_value',
								'meta_key' => 'date',
								'order' => 'ASC'
							));
							?>
							<?php if( $performances ): ?>
								<h2>Performances</h2>
								<ul>
								<?php foreach( $performances as $post ): 
									setup_postdata($post); ?>
									<li>
										<a class="<?php echo get_post_type(); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a><br>
										<?php the_field('date'); ?><br>
										<?php
										$the_start_hour = get_field('start_hour');
										if($the_start_hour >= 12){
											if($the_start_hour > 12){
												$the_start_hour = $the_start_hour - 12;
											} elseif ($the_start_hour == 12){
												$the_start_hour = 12;
											};
											$am_or_pm = 'pm';
										} elseif($the_start_hour == 0){
											$the_start_hour = $the_start_hour + 12;
											$am_or_pm = 'am';
										} elseif($the_start_hour < 12 && $the_start_hour > 0){
											$am_or_pm = 'am';
										};
										if($the_start_hour < 10) {
											$the_start_hour = ltrim($the_start_hour, '0');
										};
										?>

										<?php
										$the_end_hour = get_field('end_hour');
										if($the_end_hour >= 12){
											if($the_end_hour > 12){
												$the_end_hour = $the_end_hour - 12;
											} elseif ($the_end_hour == 12){
												$the_end_hour = 12;
											};
											$am_or_pm = 'pm';
										} elseif($the_end_hour == 0){
											$the_end_hour = $the_end_hour + 12;
											$am_or_pm = 'am';
										} elseif($the_end_hour < 12 && $the_end_hour > 0){
											$am_or_pm = 'am';
										};
										if($the_end_hour < 10) {
											$the_end_hour = ltrim($the_end_hour, '0');
										};
										?>

										<?php echo $the_start_hour; ?>:<?php the_field('start_minute'); ?><?php echo $am_or_pm; ?>&ndash;<?php echo $the_end_hour; ?>:<?php the_field('end_minute'); ?><?php echo $am_or_pm; ?>
									</li>
								<?php endforeach; ?>
								<?php wp_reset_postdata(); ?>
								</ul>
							<?php endif; ?>
							<?php if( $panels ): ?>
								<h2>Panels</h2>
								<ul>
								<?php foreach( $panels as $post ): 
									setup_postdata($post); ?>
									<li>
										<a class="<?php echo get_post_type(); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a><br>
										<?php the_field('date'); ?><br>
										<?php
										$the_start_hour = get_field('start_hour');
										if($the_start_hour >= 12){
											if($the_start_hour > 12){
												$the_start_hour = $the_start_hour - 12;
											} elseif ($the_start_hour == 12){
												$the_start_hour = 12;
											};
											$am_or_pm = 'pm';
										} elseif($the_start_hour == 0){
											$the_start_hour = $the_start_hour + 12;
											$am_or_pm = 'am';
										} elseif($the_start_hour < 12 && $the_start_hour > 0){
											$am_or_pm = 'am';
										};
										if($the_start_hour < 10) {
											$the_start_hour = ltrim($the_start_hour, '0');
										};
										?>

										<?php
										$the_end_hour = get_field('end_hour');
										if($the_end_hour >= 12){
											if($the_end_hour > 12){
												$the_end_hour = $the_end_hour - 12;
											} elseif ($the_end_hour == 12){
												$the_end_hour = 12;
											};
											$am_or_pm = 'pm';
										} elseif($the_end_hour == 0){
											$the_end_hour = $the_end_hour + 12;
											$am_or_pm = 'am';
										} elseif($the_end_hour < 12 && $the_end_hour > 0){
											$am_or_pm = 'am';
										};
										if($the_end_hour < 10) {
											$the_end_hour = ltrim($the_end_hour, '0');
										};
										?>

										<?php echo $the_start_hour; ?>:<?php the_field('start_minute'); ?><?php echo $am_or_pm; ?>&ndash;<?php echo $the_end_hour; ?>:<?php the_field('end_minute'); ?><?php echo $am_or_pm; ?>
									</li>
								<?php endforeach; ?>
								<?php wp_reset_postdata(); ?>
								</ul>
							<?php endif; ?>
							<?php if( $exhibitions ): ?>
								<h2>Exhibitions</h2>
								<ul>
								<?php foreach( $exhibitions as $post ): 
									setup_postdata($post); ?>
									<li>
										<a class="<?php echo get_post_type(); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a><br>
										<?php the_field('date'); ?><br>
										<?php
										$the_start_hour = get_field('start_hour');
										if($the_start_hour >= 12){
											if($the_start_hour > 12){
												$the_start_hour = $the_start_hour - 12;
											} elseif ($the_start_hour == 12){
												$the_start_hour = 12;
											};
											$am_or_pm = 'pm';
										} elseif($the_start_hour == 0){
											$the_start_hour = $the_start_hour + 12;
											$am_or_pm = 'am';
										} elseif($the_start_hour < 12 && $the_start_hour > 0){
											$am_or_pm = 'am';
										};
										if($the_start_hour < 10) {
											$the_start_hour = ltrim($the_start_hour, '0');
										};
										?>

										<?php
										$the_end_hour = get_field('end_hour');
										if($the_end_hour >= 12){
											if($the_end_hour > 12){
												$the_end_hour = $the_end_hour - 12;
											} elseif ($the_end_hour == 12){
												$the_end_hour = 12;
											};
											$am_or_pm = 'pm';
										} elseif($the_end_hour == 0){
											$the_end_hour = $the_end_hour + 12;
											$am_or_pm = 'am';
										} elseif($the_end_hour < 12 && $the_end_hour > 0){
											$am_or_pm = 'am';
										};
										if($the_end_hour < 10) {
											$the_end_hour = ltrim($the_end_hour, '0');
										};
										?>

										<?php echo $the_start_hour; ?>:<?php the_field('start_minute'); ?><?php echo $am_or_pm; ?>&ndash;<?php echo $the_end_hour; ?>:<?php the_field('end_minute'); ?><?php echo $am_or_pm; ?>
									</li>
								<?php endforeach; ?>
								<?php wp_reset_postdata(); ?>
								</ul>
							<?php endif; ?>
						</div>
					</div>
				<?php }; ?>

				<div id="sidebar">
					<?php if(is_page(array(
						'performances', 'panels', 'exhibitions'
					))){
					} else {
						the_field('sidebar_intro','options');
					} ?>
					<?php if(is_page(array(
						'schedule', 'performances', 'panels', 'exhibitions'
					))){
					} else { ?>
						<?php $events = get_posts(array(
							'post_type' => array('performance', 'panel', 'exhibition'),
							'posts_per_page' => -1,
							'meta_query' => array(
								'date_clause' => array(
									'key' => 'date',
									'compare' => 'EXISTS'
								),
								'hour_clause' => array(
									'key' => 'start_hour',
									'compare' => 'EXISTS'
								),
								'minute_clause' => array(
									'key' => 'start_minute',
									'compare' => 'EXISTS'
								),
								'order_clause' => array(
									'key' => 'order',
									'compare' => 'EXISTS'
								)
						        
						    ),
						    'orderby' => array(
						    	'date_clause' => 'ASC',
						    	'hour_clause' => 'ASC',
						    	'minute_clause' => 'ASC',
						    	'order_clause' => 'ASC',
						    )				
						)); ?>
						<?php if( $events): ?>
							<div class="event_list">
							<?php foreach( $events as $post ):
								setup_postdata($post); ?>
								<div class="single_event">

									<div class="right_event_col">
										<a href="<?php the_permalink(); ?>" class="<?php echo get_post_type();?>"><?php the_title(); ?></a>
										<div class="date_and_time">
											<?php the_field('date'); ?><br>

										<?php
										$the_start_hour = get_field('start_hour');
										if($the_start_hour >= 12){
											if($the_start_hour > 12){
												$the_start_hour = $the_start_hour - 12;
											} elseif ($the_start_hour == 12){
												$the_start_hour = 12;
											};
											$am_or_pm = 'pm';
										} elseif($the_start_hour == 0){
											$the_start_hour = $the_start_hour + 12;
											$am_or_pm = 'am';
										} elseif($the_start_hour < 12 && $the_start_hour > 0){
											$am_or_pm = 'am';
										};
										if($the_start_hour < 10) {
											$the_start_hour = ltrim($the_start_hour, '0');
										};
										?>

										<?php
										$the_end_hour = get_field('end_hour');
										if($the_end_hour >= 12){
											if($the_end_hour > 12){
												$the_end_hour = $the_end_hour - 12;
											} elseif ($the_end_hour == 12){
												$the_end_hour = 12;
											};
											$am_or_pm = 'pm';
										} elseif($the_end_hour == 0){
											$the_end_hour = $the_end_hour + 12;
											$am_or_pm = 'am';
										} elseif($the_end_hour < 12 && $the_end_hour > 0){
											$am_or_pm = 'am';
										};
										if($the_end_hour < 10) {
											$the_end_hour = ltrim($the_end_hour, '0');
										};
										?>

										<?php echo $the_start_hour; ?>:<?php the_field('start_minute'); ?><?php echo $am_or_pm; ?>&ndash;<?php echo $the_end_hour; ?>:<?php the_field('end_minute'); ?><?php echo $am_or_pm; ?>
										</div>
									</div>
								</div>
							<?php endforeach; ?>
							<?php wp_reset_postdata(); ?>



							<?php $closing_party = get_page_by_path('schedule/closing-party', OBJECT, 'page');
							$closing_id = $closing_party->ID;
							if($closing_id){ ?>

								<div class="single_event">

									<div class="right_event_col">
										<a href="<?php echo get_the_permalink($closing_party->ID); ?>"><?php echo get_the_title($closing_party->ID); ?></a>
										<div class="date_and_time">
											<?php the_field('date', $closing_id); ?><br>

											<?php
											$the_start_hour = get_field('start_hour', $closing_id);
											if($the_start_hour >= 12){
												if($the_start_hour > 12){
													$the_start_hour = $the_start_hour - 12;
												} elseif ($the_start_hour == 12){
													$the_start_hour = 12;
												};
												$am_or_pm = 'pm';
											} elseif($the_start_hour == 0){
												$the_start_hour = $the_start_hour + 12;
												$am_or_pm = 'am';
											} elseif($the_start_hour < 12 && $the_start_hour > 0){
												$am_or_pm = 'am';
											};
											if($the_start_hour < 10) {
												$the_start_hour = ltrim($the_start_hour, '0');
											};
											?>

											<?php
											$the_end_hour = get_field('end_hour', $closing_id);
											if($the_end_hour >= 12){
												if($the_end_hour > 12){
													$the_end_hour = $the_end_hour - 12;
												} elseif ($the_end_hour == 12){
													$the_end_hour = 12;
												};
												$am_or_pm = 'pm';
											} elseif($the_end_hour == 0){
												$the_end_hour = $the_end_hour + 12;
												$am_or_pm = 'am';
											} elseif($the_end_hour < 12 && $the_end_hour > 0){
												$am_or_pm = 'am';
											};
											if($the_end_hour < 10) {
												$the_end_hour = ltrim($the_end_hour, '0');
											};
											?>

											<?php echo $the_start_hour; ?>:<?php the_field('start_minute', $closing_id); ?><?php echo $am_or_pm; ?>&ndash;<?php echo $the_end_hour; ?>:<?php the_field('end_minute', $closing_id); ?><?php echo $am_or_pm; ?>
										</div>
									</div>
								</div>
							<?php }; ?>
							</div>
						<?php endif; ?>	
					<?php }; ?>
				</div>
			</div>
		</div>
		<div id="footer">
			<div class="footer_content">
				<?php the_field('footer','options'); ?>
			</div>
		</div>
	<?php }; ?>
	<style type="text/css">

	.acf-map {
		width: 100%;
		height: 400px;
		border: #ccc solid 1px;
		margin: 20px 0;
	}

	</style>
	<script src="https://maps.googleapis.com/maps/api/js?v=3.exp&sensor=false"></script>
	<script type="text/javascript">
	(function($) {

	/*
	*  render_map
	*
	*  This function will render a Google Map onto the selected jQuery element
	*
	*  @type	function
	*  @date	8/11/2013
	*  @since	4.3.0
	*
	*  @param	$el (jQuery element)
	*  @return	n/a
	*/

	function render_map( $el ) {

		// var
		var $markers = $el.find('.marker');

		// vars
		var args = {
			zoom		: 16,
			center		: new google.maps.LatLng(0, 0),
			mapTypeId	: google.maps.MapTypeId.ROADMAP
		};

		// create map	        	
		var map = new google.maps.Map( $el[0], args);

		// add a markers reference
		map.markers = [];

		// add markers
		$markers.each(function(){

	    	add_marker( $(this), map );

		});

		// center map
		center_map( map );

	}

	/*
	*  add_marker
	*
	*  This function will add a marker to the selected Google Map
	*
	*  @type	function
	*  @date	8/11/2013
	*  @since	4.3.0
	*
	*  @param	$marker (jQuery element)
	*  @param	map (Google Map object)
	*  @return	n/a
	*/

	function add_marker( $marker, map ) {

		// var
		var latlng = new google.maps.LatLng( $marker.attr('data-lat'), $marker.attr('data-lng') );

		// create marker
		var marker = new google.maps.Marker({
			position	: latlng,
			map			: map
		});

		// add to array
		map.markers.push( marker );

		// if marker contains HTML, add it to an infoWindow
		if( $marker.html() )
		{
			// create info window
			var infowindow = new google.maps.InfoWindow({
				content		: $marker.html()
			});

			// show info window when marker is clicked
			google.maps.event.addListener(marker, 'click', function() {

				infowindow.open( map, marker );

			});
		}

	}

	/*
	*  center_map
	*
	*  This function will center the map, showing all markers attached to this map
	*
	*  @type	function
	*  @date	8/11/2013
	*  @since	4.3.0
	*
	*  @param	map (Google Map object)
	*  @return	n/a
	*/

	function center_map( map ) {

		// vars
		var bounds = new google.maps.LatLngBounds();

		// loop through all markers and create bounds
		$.each( map.markers, function( i, marker ){

			var latlng = new google.maps.LatLng( marker.position.lat(), marker.position.lng() );

			bounds.extend( latlng );

		});

		// only 1 marker?
		if( map.markers.length == 1 )
		{
			// set center of map
		    map.setCenter( bounds.getCenter() );
		    map.setZoom( 16 );
		}
		else
		{
			// fit to bounds
			map.fitBounds( bounds );
		}

	}

	/*
	*  document ready
	*
	*  This function will render each map when the document is ready (page has loaded)
	*
	*  @type	function
	*  @date	8/11/2013
	*  @since	5.0.0
	*
	*  @param	n/a
	*  @return	n/a
	*/

	$(document).ready(function(){

		$('.acf-map').each(function(){

			render_map( $(this) );

		});

	});

	})(jQuery);
	</script>
</body>
</html>