<?php
#Function to create shortcode for Blog Feature
if ( ! function_exists( 'woo_shortcode_post_blog_feature' ) ) {
function woo_shortcode_post_blog_feature ( $atts ) {
  $defaults = array(
    'sep' => ', ',
    'before' => '',
    'after' => '',
    'taxonomy' => 'blog_feature'
  );
  $atts = shortcode_atts( $defaults, $atts );

  $atts = array_map( 'wp_kses_post', $atts );

  $terms = get_the_terms( get_the_ID(), esc_html( $atts['taxonomy'] ) );
  $cats = '';

  if ( is_array( $terms ) && 0 < count( $terms ) ) {
    $links_array = array();
    foreach ( $terms as $k => $v ) {
      $term_name = get_term_field( 'name', $v->term_id, $atts['taxonomy'] );
      $links_array[] = '<a href="' . esc_url( get_term_link( $v, $atts['taxonomy'] ) ) . '" title="' . esc_attr( sprintf( __( 'View all items in %s', 'woothemes' ), $term_name ) ) . '">' . esc_html( $term_name ) . '</a>';
    }

    $cats = join( $atts['sep'], $links_array );
  }

  $output = sprintf('<span class="categories">%2$s%1$s%3$s</span> ', $cats, $atts['before'], $atts['after']);
  return apply_filters( 'woo_shortcode_post_categories', $output, $atts );
} // End woo_shortcode_post_categories()
}

add_shortcode( 'blog_feature', 'woo_shortcode_post_blog_feature' );


function new_projects_fields( $fields ) {
$fields['faculty'] = array(
'name' => __( 'Faculty', 'projects' ),
'description' => __( 'Enter faculty for this project.', 'projects' ),
'type' => 'text',
'default' => '',
'section' => 'info'
);
return $fields;
}
add_filter( 'projects_custom_fields', 'new_projects_fields' );



function display_new_projects_fields() {
global $post;
$faculty = esc_attr( get_post_meta( $post->ID, '_faculty', true ) );

echo '<p>' . __( 'Faculty: ', 'projects' ) . $faculty . '</p>';

}
add_action( 'projects_after_loop_item', 'display_new_projects_fields', 10 );


// add tag support to project pages
function tags_support_all() {
  register_taxonomy_for_object_type('post_tag', 'project');
}

// add category support to project pages
function category_support_all() {
  register_taxonomy_for_object_type('category', 'project');
}

// ensure all tags are included in queries
function tags_support_query($wp_query) {
  if ($wp_query->get('tag')) $wp_query->set('post_type', 'any');
}

// tag hooks
add_action('init', 'tags_support_all');
add_action('init', 'category_support_all');
add_action('pre_get_posts', 'tags_support_query');



//Add post categories and post tags to Events Manager
function my_em_own_taxonomy_register(){
    register_taxonomy_for_object_type('category',EM_POST_TYPE_EVENT);
    register_taxonomy_for_object_type('category',EM_POST_TYPE_LOCATION);
    register_taxonomy_for_object_type('post_tag',EM_POST_TYPE_EVENT);
    register_taxonomy_for_object_type('post_tag',EM_POST_TYPE_LOCATION);
    }
add_action('init','my_em_own_taxonomy_register',100);



function blog_feature_init() {
  // create a new taxonomy for blog_feature
  register_taxonomy(
    'blog_feature',
    'post',
    array(
    // Hierarchical taxonomy (like categories)
    'hierarchical' => true,
      'label' => __( 'Blog Feature' ),
      'rewrite' => array( 'slug' => 'Blog Feature'),
    )
  );
}
add_action( 'init', 'blog_feature_init' );

//Add content category to woo projects
function projects_own_taxonomy_register(){
    register_taxonomy_for_object_type('content_category',project);
    }
add_action('init','projects_own_taxonomy_register',100);



function project_category_init() {
  // create a new taxonomy for Events Manager Content Category
  register_taxonomy(
    'project_content_category',
    project,
    array(
    // Hierarchical taxonomy (like categories)
    'hierarchical' => true,
      'label' => __( 'Project Content Category' ),
      'rewrite' => array( 'slug' => 'Project Content Category'),
    )
  );
}
add_action( 'init', 'project_category_init' );

function project_department_init() {
  // create a new taxonomy for Project departments
  register_taxonomy(
    'project_department_category',
    project,
    array(
    // Hierarchical taxonomy (like categories)
    'hierarchical' => false,
      'label' => __( 'Department' ),
      'rewrite' => array( 'slug' => 'Department'),
    )
  );
}
add_action( 'init', 'project_department_init' );


// Custom shortcode function for coauthors post links

function coauthor_links_shortcode( ) {

    if ( function_exists( 'coauthors_posts_links' ) ) {
        $author = coauthors_posts_links( null, null, null, null, false );
    } else {
       $author = '[post_author_posts_link]';
    }
    return  $author;
}

add_shortcode('author_links','coauthor_links_shortcode');

// Define woo_post_meta if not set in filter yet

function woo_post_meta() {

  if ( is_page() && !( is_page_template( 'template-blog.php' ) || is_page_template( 'template-magazine.php' ) ) ) {
    return;
  }

  $post_info = '<span class="small">' . __( 'By', 'woothemes' ) . '</span> [author_links] <span class="small">' . _x( 'on', 'post datetime', 'woothemes' ) . '</span> [post_date] <span class="small">' . __( 'in', 'woothemes' ) . '</span> [post_categories before=""] ';
printf( '<div class="post-meta">%s</div>' . "\n", apply_filters( 'woo_filter_post_meta', $post_info ) );

} // End woo_post_meta()

// Replace Single Post Author (in theme-actions.php)

function woo_author_box () {
  global $post;
  $author_id=$post->post_author;

  // Adjust the arrow, if is_rtl().
  $arrow = '→';
  if ( is_rtl() ) $arrow = '←';

?>
<?php foreach( get_coauthors() as $coauthor ): ?>
<aside id="post-author">
  <div class="profile-image"> <?php echo coauthors_get_avatar( $coauthor, '80', '', false ); ?></div>
  <div class="profile-content">
    <h4><?php echo 'About '.$coauthor->display_name ?></h4>
    <?php echo $coauthor->description; ?>
    <?php if ( is_singular() ) : ?>
    <div class="profile-link">
      <a href="<?php echo get_author_posts_url( $coauthor->ID, $coauthor->user_nicename ); ?>">
        <?php echo ('View all posts by: ' . $coauthor->display_name . '<span class="meta-nav">' . $arrow . '</span>' ); ?>
      </a>
    </div><!--#profile-link-->
    <?php endif; ?>
  </div>
  <div class="fix"></div>
</aside>
<?php endforeach;
} // End woo_author_box()

// Replace Archive Titles conditions

function woo_archive_title ( $before = '', $after = '', $echo = true ) {

  global $wp_query;

  if ( is_category() || is_tag() || is_tax() ) {

    $taxonomy_obj = $wp_query->get_queried_object();
    $term_id = $taxonomy_obj->term_id;
    $taxonomy_short_name = $taxonomy_obj->taxonomy;

    $taxonomy_raw_obj = get_taxonomy( $taxonomy_short_name );

  } // End IF Statement

  $title = '';
  $delimiter = ' | ';
  $date_format = get_option( 'date_format' );

  // Category Archive
  if ( is_category() ) {

    $title = '<span class="fl cat">' . __( 'Archive', 'woothemes' ) . $delimiter . single_cat_title( '', false ) . '</span> <span class="fr catrss">';
    $cat_obj = $wp_query->get_queried_object();
    $cat_id = $cat_obj->cat_ID;
    $title .= '<a href="' . get_term_feed_link( $term_id, $taxonomy_short_name, '' ) . '" class="icon-rss icon-large" ></a></span>';

    $has_title = true;
  }

  // Day Archive
  if ( is_day() ) {

    $title = __( 'Archive', 'woothemes' ) . $delimiter . get_the_time( $date_format );
  }

  // Month Archive
  if ( is_month() ) {

    $date_format = apply_filters( 'woo_archive_title_date_format', 'F, Y' );
    $title = __( 'Archive', 'woothemes' ) . $delimiter . get_the_time( $date_format );
  }

  // Year Archive
  if ( is_year() ) {

    $date_format = apply_filters( 'woo_archive_title_date_format', 'Y' );
    $title = __( 'Archive', 'woothemes' ) . $delimiter . get_the_time( $date_format );
  }

  // Author Archive
  if ( is_author() ) {

    $title = __( 'Author Archive', 'woothemes' ) . $delimiter . coauthors( null, null, null, null, true );
  }

  // Tag Archive
  if ( is_tag() ) {

    $title = __( 'Tag Archives', 'woothemes' ) . $delimiter . single_tag_title( '', false );
  }

  // Post Type Archive
  if ( function_exists( 'is_post_type_archive' ) && is_post_type_archive() ) {

    /* Get the post type object. */
    $post_type_object = get_post_type_object( get_query_var( 'post_type' ) );

    $title = $post_type_object->labels->name . ' ' . __( 'Archive', 'woothemes' );
  }

  // Post Format Archive
  if ( get_query_var( 'taxonomy' ) == 'post_format' ) {

    $post_format = str_replace( 'post-format-', '', get_query_var( 'post_format' ) );

    $title = get_post_format_string( $post_format ) . ' ' . __( ' Archives', 'woothemes' );
  }

  // General Taxonomy Archive
  if ( is_tax() ) {

    $title = sprintf( __( '%1$s Archives: %2$s', 'woothemes' ), $taxonomy_raw_obj->labels->name, $taxonomy_obj->name );

  }

  if ( strlen($title) == 0 )
  return;

  $title = $before . $title . $after;

  // Allow for external filters to manipulate the title value.
  $title = apply_filters( 'woo_archive_title', $title, $before, $after );

  if ( $echo )
    echo $title;
  else
    return $title;

} // End woo_archive_title()

// Add Custom Post Type Support args

add_action('init', 'custom_post_type_support');
function custom_post_type_support() {
  add_post_type_support( 'portfolio', array('publicize','author') );
  /* add_post_type_support( 'product', array('publicize','author') ); -- if adding coauthor box to woocommerce */

}

?>
