<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
	<link rel="icon" type="image/x-icon" href="<?php echo get_template_directory_uri(); ?>/images/favicon.jpg">
	<title><?php wp_title( '|', true, 'right' ); ?> <?php bloginfo('name'); ?></title>
	<?php wp_head(); ?>
</head>
<body style="background-image: url('<?php echo get_template_directory_uri(); ?>/images/blue_background_02.jpg');">
	<div id="wrapper" class="single_event">
		<div id="header">
			<div class="mast_head">
				<h1 class="fest_title"><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_title','options'); ?></a></h1><h1 class="year"><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_year','options'); ?></a></h1>
				<div class="sub_heads">
					<h2><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_subtitle','options'); ?></a></h2>
					<h3><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_dates','options'); ?></a></h3>
					<div class="line"></div><div class="angled_line"></div>
				</div>
				<br clear="all">
			</div>
			<div class="nav">
				<div class="instructions"><?php the_field('header_text','options'); ?></div>
				<div class="nav_items">
					<?php wp_nav_menu(); ?>
				</div>
			</div>
		</div>
		<?php
		if(have_posts()){ ?>
			<div id="the_event">
			<?php while(have_posts()){
				the_post(); ?>

				<div class="event_box">
					<?php
					// EVENT IMAGE //
					$image = get_field('featured_image');
					if($image){
						$size = 'large';
						$large = $image['sizes'][$size];
					}
					?>

					<?php
					// EVENT LABEL //
					$label = get_the_category();
					?>

					<?php
					// EVENT TIME AND DATE //
					$start_time = new DateTime(get_field('start_time'));
					$end_time = new DateTime(get_field('end_time'));
					$start_date = $start_time->format('Y-m-d');
					$display_date = $start_time->format('M j');
					$display_start_time_hour = $start_time->format('g');
					$display_start_time_min = $start_time->format(':i');
					$display_start_time_ampm = $start_time->format('a');
					$display_end_time_hour = $end_time->format('g');
					$display_end_time_min = $end_time->format(':i');
					$display_end_time_ampm = $end_time->format('a');
					if($display_start_time_min == ':00'){
						$display_start_time_min = '';
					}
					if($display_end_time_min == ':00'){
						$display_end_time_min = '';
					}
					if($display_start_time_ampm == $display_end_time_ampm){
						$display_start_time_ampm = '';
					}
					$display_time = $display_start_time_hour . $display_start_time_min . $display_start_time_ampm . '&ndash;' . $display_end_time_hour . $display_end_time_min . $display_end_time_ampm;
					?>

					<?php
					// EVENT VENUE //
					$venue = get_field('venue');
					foreach ($venue as $v) {
						$venue_name = get_the_title($v->ID);
						$venue_display = get_field('display_venue_as', $v->ID);
					}
					?>

					<?php
					$use_event_title = get_field('use_event_title');
					?>

					<?php 
					// SET UP TITLE FOR SCHEDULE //
					$presentations = '';
					if(have_rows('presentations')){
						while(have_rows('presentations')){
							the_row();
							$artists = get_sub_field('artist');
							foreach ($artists as $artist) {
								$artist_name = get_the_title($artist->ID);
							}
							$presentations .= '<h2>' . get_sub_field('presentation_title') . '</h2><h3>' . $artist_name . '</h3>';
						}
					} ?>

					<div class="event_label">
						<?php echo $label[0]->cat_name; ?>
					</div>
					
					<div class="event_details">
						<div class="event_details_wrapper">
							<h4><?php echo $display_time; ?> / <?php echo $display_date; ?> / <?php echo $venue_display; ?></h4>
							<?php if($use_event_title == 1){ ?>
								<h2><?php the_title(); ?></h2>
							<?php } else { ?>
								<?php echo $presentations; ?>
							<?php } ?>							
						</div>
					</div>
					<div class="event_box_connector">
						<a href="<?php echo get_site_url(); ?>">Back to Schedule</a>
						<div class="vert_line"></div>
						<div class="horz_line"></div>
					</div>	
				</div>
				<div class="event_box">
					<div class="event_image">
						<img src="<?php echo $large; ?>">
						<div class="image_caption">
							<?php echo $image['caption']; ?>
						</div>
					</div>
					<div class="event_details">
						<?php if($use_event_title == 1){ ?>
							<?php echo $presentations; ?><br>
						<?php } ?>
						<?php the_field('long_description'); ?>
					</div>
				</div>

			<?php } ?>
			</div>
		<?php } ?>
	</div>
	<?php wp_footer(); ?>
</body>
</html>