<?php
/**
Template Name: Livestream Page
**/
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" style="margin-top: 0 !important;">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
	<link rel="icon" type="image/x-icon" href="<?php echo get_template_directory_uri(); ?>/images/favicon.jpg">
	<title><?php wp_title( '|', true, 'right' ); ?> <?php bloginfo('name'); ?></title>
	<?php wp_head(); ?>
</head>
<body>
	<div id="wrapper" class="single_page">
		<div id="header">
			<div class="mast_head">
				<h1 class="fest_title"><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_title','options'); ?></a></h1><h1 class="year"><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_year','options'); ?></a></h1>
				<div class="sub_heads">
					<h2><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_subtitle','options'); ?></a></h2>
					<h3><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_dates','options'); ?></a></h3>
					<div class="line"></div><div class="angled_line"></div>
				</div>
				<br clear="all">
			</div>
			<div class="nav">
				<div class="instructions"><?php the_field('header_text','options'); ?></div>
				<div class="nav_items">
					<?php wp_nav_menu(); ?>
				</div>
			</div>
		</div>
		<?php
		if(have_posts()){ ?>
			<div id="the_event">
			<?php while(have_posts()){
				the_post(); ?>
				<div class="event_box">
					<div class="event_details">
						<div class="event_details_wrapper">
							<h2><?php the_title(); ?></h2><br>
							<?php if(have_rows('content_sections')){ ?>
								<?php while(have_rows('content_sections')){ ?>
									<?php the_row(); ?>
									<?php if(get_row_layout() == 'content'){ ?>
										<?php the_sub_field('content'); ?>
									<?php } elseif(get_row_layout() == 'howlround_1') { ?>
										<?php
										$on = get_sub_field('show_howlround_1');
										if($on == 1) { ?>
											<br>
											<iframe width="100%" height="400" src="http://cdn.livestream.com/embed/newplay?layout=4&color=0xe7e7e7&autoPlay=false&mute=false&iconColorOver=0x888888&iconColor=0x777777&allowchat=true&height=400&width=600" style="border:0;outline:0" frameborder="0" scrolling="no"></iframe><br>
										<?php } ?>
									<?php } elseif(get_row_layout() == 'howlround_2') { ?>
										<?php
										$on = get_sub_field('show_howlround_2');
										if($on == 1) { ?>
											<br><br>
											<iframe width="100%" height="400" src="http://cdn.livestream.com/embed/howlround?layout=4&color=0xe7e7e7&autoPlay=false&mute=false&iconColorOver=0x888888&iconColor=0x777777&allowchat=true&height=400&width=600" style="border:0;outline:0" frameborder="0" scrolling="no"></iframe><br>
										<?php } ?>
									<?php } ?>
								<?php } ?>
							<?php } ?>
						</div>
					</div>
				</div>

			<?php } ?>
			</div>
		<?php } ?>
	</div>
	<div class="single_background" style="background-image: url('<?php echo get_template_directory_uri(); ?>/images/blue_background_02.jpg');"></div>
	<?php wp_footer(); ?>
</body>
</html>