<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" style="margin-top: 0 !important;">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
	<link rel="icon" type="image/x-icon" href="<?php echo get_template_directory_uri(); ?>/images/favicon.jpg">
	<title><?php wp_title( '|', true, 'right' ); ?> <?php bloginfo('name'); ?></title>
	<?php wp_head(); ?>
</head>
<body>
	<div id="wrapper" class="single_page">
		<div id="header">
			<div class="mast_head">
				<h1 class="fest_title"><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_title','options'); ?></a></h1><h1 class="year"><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_year','options'); ?></a></h1>
				<div class="sub_heads">
					<h2><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_subtitle','options'); ?></a></h2>
					<h3><a href="<?php echo get_site_url(); ?>"><?php the_field('festival_dates','options'); ?></a></h3>
					<div class="line"></div><div class="angled_line"></div>
				</div>
				<br clear="all">
			</div>
			<div class="nav">
				<div class="instructions"><?php the_field('header_text','options'); ?></div>
				<div class="nav_items">
					<?php wp_nav_menu(); ?>
				</div>
			</div>
		</div>
		<?php
		if(have_posts()){ ?>
			<div id="the_event">
			<?php while(have_posts()){
				the_post(); ?>
				<div class="event_box">
					<div class="event_details">
						<div class="event_details_wrapper">
							<h2><?php the_title(); ?></h2><br>
							<?php the_content(); ?>
						</div>
					</div>
				</div>

			<?php } ?>
			</div>
		<?php } ?>
	</div>
	<div class="single_background" style="background-image: url('<?php echo get_template_directory_uri(); ?>/images/blue_background_02.jpg');"></div>
	<?php wp_footer(); ?>
</body>
</html>