<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" style="margin-top: 0 !important;">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
	<link rel="icon" type="image/x-icon" href="<?php echo get_template_directory_uri(); ?>/images/favicon.jpg">
	<title><?php wp_title( '|', true, 'right' ); ?> <?php bloginfo('name'); ?></title>
	<?php wp_head(); ?>
</head>
<body style="background-image: url('<?php echo get_template_directory_uri(); ?>/images/blue_background_02.jpg');">
<div class="overflow">
	<?php
	$festival_dates = get_posts(array(
		'post_type' => 'festival_dates',
		'post_per_page' => -1,
		'meta_key' => 'date',
		'orderby' => 'meta_value_num',
		'order' => 'ASC',
	));
	$number_of_days = count($festival_dates);
	$half_hour_y = 99.75;
	$first_hour_y = 208;
	$d_1_y = 23;
	$d = 1;
	foreach ($festival_dates as $post) {
		setup_postdata( $post );

		${'start_time_' . $d} = new DateTime(get_field('start_time'));
		${'end_time_' . $d} = new DateTime(get_field('end_time'));
		${'d_' . $d} = ${'start_time_' . $d}->format('Y-m-d');
		$diff = ${'end_time_' . $d}->diff(${'start_time_' . $d});
		${'half_hours_' . $d} = (($diff->h)-1)*2;
		$y = $d;
		$d++;
		${'d_' . $d . '_y'} = (${'d_' . $y . '_y'} + 185) + (${'half_hours_' . $y}*99.75) + 212;
	}
	wp_reset_postdata();
	?>
	<div id="wrapper" class="home_page">
		<div id="header">
			<div class="fixed_header">
				<h1 class="fest_title"><?php the_field('festival_title','options'); ?></h1><h1 class="year"><?php the_field('festival_year','options'); ?></h1>
				<div class="sub_heads">
					<h2><?php the_field('festival_subtitle','options'); ?></h2>
					<h3><?php the_field('festival_dates','options'); ?></h3>
					<div class="line"></div><div class="angled_line"></div>
				</div>
				<br clear="all">
			</div>
			<div class="mast_head">
				<h1 class="fest_title"><?php the_field('festival_title','options'); ?></h1><h1 class="year"><?php the_field('festival_year','options'); ?></h1>
				<div class="sub_heads">
					<h2><?php the_field('festival_subtitle','options'); ?></h2>
					<h3><?php the_field('festival_dates','options'); ?></h3>
					<div class="line"></div><div class="angled_line"></div>
				</div>
				<br clear="all">
			</div>
			<div class="nav">
				<div class="instructions"><?php the_field('header_text','options'); ?></div>
				<div class="nav_items">
					<?php wp_nav_menu(); ?>
				</div>
			</div>
			<div class="promo" timer="<?php the_field('promo_timer','options'); ?>">
				<?php
				$promos = get_field('promo_events','options');
				if($promos){
					$p = 1;
					foreach ($promos as $post) {
						setup_postdata($posts); ?>

						<?php $image = get_field('featured_image');
						if($image){
							$size = 'large';
							$large = $image['sizes'][$size];
						} ?>

						<?php
						// EVENT TIME AND DATE //
						$start_time = new DateTime(get_field('start_time'));
						$end_time = new DateTime(get_field('end_time'));
						$start_date = $start_time->format('Y-m-d');
						$display_date = $start_time->format('M j');
						$display_start_time_hour = $start_time->format('g');
						$display_start_time_min = $start_time->format(':i');
						$display_start_time_ampm = $start_time->format('a');
						$display_end_time_hour = $end_time->format('g');
						$display_end_time_min = $end_time->format(':i');
						$display_end_time_ampm = $end_time->format('a');
						if($display_start_time_min == ':00'){
							$display_start_time_min = '';
						}
						if($display_end_time_min == ':00'){
							$display_end_time_min = '';
						}
						if($display_start_time_ampm == $display_end_time_ampm){
							$display_start_time_ampm = '';
						}
						$display_time = $display_start_time_hour . $display_start_time_min . $display_start_time_ampm . '&ndash;' . $display_end_time_hour . $display_end_time_min . $display_end_time_ampm;
						?>

						<?php 
						// SET UP TITLE FOR PROMO //
						$ex_title = '';
						$long_description = get_field('long_description');
						if(have_rows('presentations')){
							while(have_rows('presentations')){
								the_row();
								$artists = get_sub_field('artist');
								foreach ($artists as $artist) {
									$artist_name = get_the_title($artist->ID);
								}
								if($long_description){
									$ex_title .= '<h2><a href="' . get_the_permalink() . '">' . get_sub_field('presentation_title') . '</a></h2><h3><a href="' . get_the_permalink() . '">' . $artist_name . '</a></h3>';
								} else {
									$ex_title .= '<h2>' . get_sub_field('presentation_title') . '</h2><h3>' . $artist_name . '</h3>';
								}
							}
						} ?>

						<?php if($p == 1){ ?>
							<div class="single_promo active" style="background-image:url('<?php echo $large; ?>');">
						<?php } else { ?>
							<div class="single_promo" style="background-image:url('<?php echo $large; ?>');">
						<?php } ?>
							<div class="promo_title">
								<?php echo $ex_title; ?>
							</div>
							<div class="promo_date">
								<?php echo $display_time; ?> / <?php echo $display_date; ?>
							</div>
							<div class="background_gradient"></div>
							<div class="promo_link"><a href="<?php the_permalink(); ?>"></a></div>

						</div>

						<?php $p++; ?>

					<?php } ?>
					<?php wp_reset_postdata(); ?>
				<?php } ?>
			</div>
		</div>
		<div id="venues">
			<?php 
			$left_venue = get_field('left_venue','options');
			$left_venue_arr = array();
			if($left_venue){
				foreach ($left_venue as $lv) {
					$left_venue_name = get_the_title($lv->ID);
					array_push($left_venue_arr, $lv->ID);
					$left_venue_display = get_field('display_venue_as', $lv->ID);
				}
			}
			$center_venue_left = get_field('center_venue_left', 'options');
			$center_venue_left_arr = array();
			if($center_venue_left){
				foreach ($center_venue_left as $cvl) {
					$center_venue_left_name = get_the_title($cvl->ID);
					array_push($center_venue_left_arr, $cvl->ID);
					//$center_venue_left_display = get_field('display_venue_as', $cvl->ID);
				}
			}
			$center_venue_right = get_field('center_venue_right', 'options');
			$center_venue_right_arr = array();
			if($center_venue_right){
				foreach ($center_venue_right as $cvr) {
					$center_venue_right_name = get_the_title($cvr->ID);
					array_push($center_venue_right_arr, $cvr->ID);
					//$center_venue_right_display = get_field('display_venue_as', $cvr->ID);
				}
			}
			$right_venue = get_field('right_venue','options');
			$right_venue_arr = array();
			if($right_venue){
				foreach ($right_venue as $rv) {
					$right_venue_name = get_the_title($rv->ID);
					array_push($right_venue_arr, $rv->ID);
					$right_venue_display = get_field('display_venue_as', $rv->ID);
				}
			}
			?>
			<!--<div class="single_venue left_venue">
				<?php if($left_venue){ ?>
					<h3>
						<?php echo $left_venue_display; ?>
					</h3>
				<?php } ?>
			</div>
			<div class="single_venue right_venue">
				<?php if($right_venue){ ?>
					<h3>
						<?php echo $right_venue_display; ?>
					</h3>
				<?php } ?>
			</div>
			<br clear="all">-->
		</div>
		<div id="schedule">

			<?php

			$events = get_posts(array(
				'post_type' => 'events',
				'post_per_page' => -1,
				'nopaging' => true,
				'meta_key' => 'start_time',
				'orderby' => 'meta_value_num',
				'order' => 'ASC',
			));
			if($events) {
				foreach ($events as $post) {
					setup_postdata( $post ); ?>

					<?php 
					// SET UP TITLE FOR SCHEDULE //
					$title = '';
					$ex_title = '';
					$long_description = get_field('long_description');
					if(have_rows('presentations')){
						while(have_rows('presentations')){
							the_row();
							$artists = get_sub_field('artist');
							foreach ($artists as $artist) {
								$artist_name = get_the_title($artist->ID);
							}
							$title .= '<h2 class="open">' . get_sub_field('presentation_title') . '</h2><h3 class="open">' . $artist_name . '</h3>';
							if($long_description){
								$ex_title .= '<h2 class="open"><a href="' . get_the_permalink() . '">' . get_sub_field('presentation_title') . '</a></h2><h3 class="open">' . $artist_name . '</h3>';
							} else {
								$ex_title .= '<h2 class="open">' . get_sub_field('presentation_title') . '</h2><h3 class="open">' . $artist_name . '</h3>';
							}
						}
					} ?>

					<?php
					// SET UP EVENT HEIGHT //
					$start_time = new DateTime(get_field('start_time'));
					$end_time = new DateTime(get_field('end_time'));
					$diff = $end_time->diff($start_time);
					$minutes = $diff->days * 24 * 60;
					$minutes += $diff->h * 60;
					$minutes += $diff->i;
					$half_hours = $minutes / 30;
					$event_height = 'height_' . $half_hours;
					$start_date = $start_time->format('Y-m-d');
					$display_date = $start_time->format('M j');
					$display_start_time_hour = $start_time->format('g');
					$display_start_time_min = $start_time->format(':i');
					$display_start_time_ampm = $start_time->format('a');
					$display_end_time_hour = $end_time->format('g');
					$display_end_time_min = $end_time->format(':i');
					$display_end_time_ampm = $end_time->format('a');
					if($display_start_time_min == ':00'){
						$display_start_time_min = '';
					}
					if($display_end_time_min == ':00'){
						$display_end_time_min = '';
					}
					if($display_start_time_ampm == $display_end_time_ampm){
						$display_start_time_ampm = '';
					}
					$display_time = $display_start_time_hour . $display_start_time_min . $display_start_time_ampm . '&ndash;' . $display_end_time_hour . $display_end_time_min . $display_end_time_ampm;
					$s = 1;
					foreach ($festival_dates as $festival_date) {
						if($start_date == ${'d_' . $s}){
							$day = $s;
							$day_y = ${'d_' . $s . '_y'};
							$first_time = ${'start_time_' . $s};
						}
						$s++;
					}
					$first_hour = $first_time->format('Hi');
					$event_time = $start_time->format('Hi');
					$difference = $start_time->diff($first_time);
					$mins = $difference->days * 24 * 60;
					$mins += $difference->h * 60;
					$mins += $difference->i;
					$halfs = $mins / 30;
					$offset = $halfs * $half_hour_y + $day_y + 185;
					$too_high_point = $d_1_y + 185;
					if($offset <= $too_high_point){
						$too_high_class = ' too_high';
					} else {
						$too_high_class = '';
					}
					?>

					<?php
					// EVENT LABEL //
					$label = get_the_category();
					?>

					<?php
					// EVENT IMAGE //
					$image = get_field('featured_image');
					if($image){
						$size = 'large';
						$large = $image['sizes'][$size];
					}
					?>

					<?php
					// SET UP VENUE AND PLACEMENT OF EVENT //
					$venue = get_field('venue');
					foreach ($venue as $v) {
						$venue_name = get_the_title($v->ID);
						$venue_display = get_field('display_venue_as', $v->ID);
						$venue_ID = $v->ID;
					}
					if(in_array($venue_ID, $left_venue_arr)){ ?>
						<div class="left_schedule<?php echo $too_high_class; ?>" style="top: <?php echo $offset; ?>px;">
							<div class="single_event <?php echo $event_height; ?>">
								<div class="event_label open">
									<?php echo $label[0]->cat_name; ?>
								</div>
								<div class="workshop_locale open">
									<?php echo $venue_display; ?>
								</div>
								<div class="event_details">
									<div class="event_details_wrapper">
										<?php echo $title; ?>
									</div>
									<div class="background_gradient open"></div>
									<?php if($image){ ?><div class="background_image open" style="background-image:url('<?php echo $large; ?>');"></div><?php } ?>
								</div>
								<div class="connector"></div>
							</div>
							<div class="expanded_event">
								<div class="expanded_top">
									<div class="close">
										X Close
									</div>
									<?php if($image){ ?>
										<div class="event_image">
											<?php if($long_description){ ?>
												<a href="<?php the_permalink(); ?>"><img src="<?php echo $large; ?>"></a>
											<?php } else { ?>
												<img src="<?php echo $large; ?>">
											<?php } ?>
										</div>
									<?php } ?>
								</div>
								<div class="event_label">
									<?php echo $label[0]->cat_name; ?>
								</div>
								<div class="the_event">
									<div class="event_details">
										<div class="event_details_wrapper">
											<h4><?php echo $display_time; ?> / <?php echo $display_date; ?> / <?php echo $venue_display; ?></h4>
											<?php echo $ex_title; ?>
											<div class="event_content">
												<?php the_field('short_description'); ?>
												<?php if($long_description){ ?>
													<p><strong><a href="<?php the_permalink(); ?>">READ MORE</a></strong></p>
												<?php } ?>
											</div>
										</div>
									</div>
									<div class="connector"></div>
								</div>
							</div>
						</div>
					<?php } elseif(in_array($venue_ID, $right_venue_arr)){ ?>
						<div class="right_schedule<?php echo $too_high_class; ?>" style="top: <?php echo $offset; ?>px">
							<div class="single_event <?php echo $event_height; ?>">
								<div class="event_label open">
									<?php echo $label[0]->cat_name; ?>
								</div>
								<div class="workshop_locale open">
									<?php echo $venue_display; ?>
								</div>
								<div class="event_details">
									<div class="event_details_wrapper">
										<?php echo $title; ?>
									</div>
									<div class="background_gradient open"></div>
									<?php if($image){ ?><div class="background_image open" style="background-image:url('<?php echo $large; ?>');"></div><?php } ?>
								</div>
								<div class="connector"></div>
							</div>
							<div class="expanded_event">
								<div class="expanded_top">
									<div class="close">
										X Close
									</div>
									<?php if($image){ ?>
										<div class="event_image">
											<?php if($long_description){ ?>
												<a href="<?php the_permalink(); ?>"><img src="<?php echo $large; ?>"></a>
											<?php } else { ?>
												<img src="<?php echo $large; ?>">
											<?php } ?>
										</div>
									<?php } ?>
								</div>
								<div class="event_label">
									<?php echo $label[0]->cat_name; ?>
								</div>
								<div class="the_event">
									<div class="event_details">
										<div class="event_details_wrapper">
											<h4><?php echo $display_time; ?> / <?php echo $display_date; ?> / <?php echo $venue_display; ?></h4>
											<?php echo $ex_title; ?>
											<div class="event_content">
												<?php the_field('short_description'); ?>
												<?php if($long_description){ ?>
													<p><strong><a href="<?php the_permalink(); ?>">READ MORE</a></strong></p>
												<?php } ?>
											</div>
										</div>
									</div>
								</div>
								<div class="connector"></div>
							</div>
						</div>
					<?php } elseif(in_array($venue_ID, $center_venue_left_arr)){ ?>
						<div class="center left_schedule<?php echo $too_high_class; ?>" style="top: <?php echo $offset; ?>px">
							<div class="single_event <?php echo $event_height; ?>">
								<div class="event_label open">
									<?php echo $label[0]->cat_name; ?>
								</div>
								<div class="workshop_locale open">
									<?php echo $venue_display; ?>
								</div>
								<div class="event_details">
									<div class="event_details_wrapper">
										<?php echo $title; ?>
									</div>
									<div class="background_gradient open"></div>
									<?php if($image){ ?><div class="background_image open" style="background-image:url('<?php echo $large; ?>');"></div><?php } ?>
								</div>
							</div>
							<div class="expanded_event">
								<div class="expanded_top">
									<div class="close">
										X Close
									</div>
									<?php if($image){ ?>
										<div class="event_image">
											<?php if($long_description){ ?>
												<a href="<?php the_permalink(); ?>"><img src="<?php echo $large; ?>"></a>
											<?php } else { ?>
												<img src="<?php echo $large; ?>">
											<?php } ?>
										</div>
									<?php } ?>
								</div>
								<div class="event_label">
									<?php echo $label[0]->cat_name; ?>
								</div>
								<div class="the_event">
									<div class="event_details">
										<div class="event_details_wrapper">
											<h4><?php echo $display_time; ?> / <?php echo $display_date; ?> / <?php echo $venue_display; ?></h4>
											<?php echo $ex_title; ?>
											<div class="event_content">
												<?php the_field('short_description'); ?>
												<?php if($long_description){ ?>
													<p><strong><a href="<?php the_permalink(); ?>">READ MORE</a></strong></p>
												<?php } ?>
											</div>
										</div>
									</div>
								</div>
								<div class="connector"></div>
							</div>
						</div>
					<?php } elseif(in_array($venue_ID, $center_venue_right_arr)) { ?>
						<div class="center right_schedule<?php echo $too_high_class; ?>" style="top: <?php echo $offset; ?>px">
							<div class="single_event <?php echo $event_height; ?>">
								<div class="event_label open">
									<?php echo $label[0]->cat_name; ?>
								</div>
								<div class="workshop_locale open">
									<?php echo $venue_display; ?>
								</div>
								<div class="event_details">
									<div class="event_details_wrapper">
										<?php echo $title; ?>
									</div>
									<div class="background_gradient open"></div>
									<?php if($image){ ?><div class="background_image open" style="background-image:url('<?php echo $large; ?>');"></div><?php } ?>
								</div>
							</div>
							<div class="expanded_event">
								<div class="expanded_top">
									<div class="close">
										X Close
									</div>
									<?php if($image){ ?>
										<div class="event_image">
											<?php if($long_description){ ?>
												<a href="<?php the_permalink(); ?>"><img src="<?php echo $large; ?>"></a>
											<?php } else { ?>
												<img src="<?php echo $large; ?>">
											<?php } ?>
										</div>
									<?php } ?>
								</div>
								<div class="event_label">
									<?php echo $label[0]->cat_name; ?>
								</div>
								<div class="the_event">
									<div class="event_details">
										<div class="event_details_wrapper">
											<h4><?php echo $display_time; ?> / <?php echo $display_date; ?> / <?php echo $venue_display; ?></h4>
											<?php echo $ex_title; ?>
											<div class="event_content">
												<?php the_field('short_description'); ?>
												<?php if($long_description){ ?>
													<p><strong><a href="<?php the_permalink(); ?>">READ MORE</a></strong></p>
												<?php } ?>
											</div>
										</div>
									</div>
								</div>
								<div class="connector"></div>
							</div>
						</div>
					<?php } ?>
				<?php }
				wp_reset_postdata();
			}
			?>
			<div class="center_date_time">
				<?php

				$festival_dates = get_posts(array(
					'post_type' => 'festival_dates',
					'post_per_page' => -1,
					'meta_key' => 'date',
					'orderby' => 'meta_value_num',
					'order' => 'ASC',
				));
				if($festival_dates) {
					foreach ($festival_dates as $post) {
						setup_postdata( $post ); ?>
						<div class="single_center_date">
							<div class="center_date">
								<?php
								$date = new DateTime(get_field('date'));
								$date_display = $date->format('M') . ' ' . $date->format('j');
								echo $date_display;
								?>
							</div>
							<div class="center_date_line"></div>
							<div class="center_time">
								<?php
								$start_time = get_field('start_time');
								$end_time = get_field('end_time');
								$hours = new DatePeriod(
									new DateTime($start_time),
									new DateInterval('PT1H'),
									new DateTime($end_time)
								);
								foreach($hours as $hour) { ?>
									<div class="single_center_time <?php the_field('date'); ?><?php echo $hour->format('H'); ?>">
										<?php echo $hour->format('g:00'); ?>
									</div>
								<?php }	?>
							</div>
						</div>
					<?php }
					wp_reset_postdata();
				}
				?>
				<div class="sticky_date">
				</div>
				<div class="spine">
				</div>
			</div>
			<!--div class="the_background">
			</div-->
		</div>
	</div>
	<div class="jump_to">Jump to What's Playing Now</div>
	<?php wp_footer(); ?>
</div>
</body>
</html>