<?php

/**
 * De-register Featured Content widgets and register our own versions.
 */
add_action( 'widgets_init', function() {
	require __DIR__ . '/inc/widgets.php';

	unregister_widget( 'colormag_featured_posts_slider_widget' );
	register_widget( 'nlf_colormag_featured_posts_slider_widget' );

	unregister_widget( 'colormag_highlighted_posts_widget' );
	register_widget( 'nlf_colormag_highlighted_posts_widget' );

	unregister_widget( 'colormag_featured_posts_widget' );
	register_widget( 'nlf_colormag_featured_posts_widget' );

	unregister_widget( 'colormag_featured_posts_vertical_widget' );
	register_widget( 'nlf_colormag_featured_posts_vertical_widget' );
}, 20 );

/**
 * Shows meta information of post.
 *
 * Overrides pluggable function in parent theme to enable co-authors-plus functionality.
 */
function colormag_entry_meta() {
	if ( 'post' == get_post_type() ) :
		echo '<div class="below-entry-meta">';
		?>

		<?php
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string .= '<time class="updated" datetime="%3$s">%4$s</time>';
		}
		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);
		printf( __( '<span class="posted-on"><a href="%1$s" title="%2$s" rel="bookmark"><i class="fa fa-calendar-o"></i> %3$s</a></span>', 'colormag' ),
			esc_url( get_permalink() ),
			esc_attr( get_the_time() ),
			$time_string
		); ?>

		<span class="byline"><span class="author vcard"><i class="fa fa-user"></i><a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" title="<?php echo get_the_author(); ?>"><?php echo coauthors_posts_links(null, null, null, null, false ); ?></a></span></span>

		<?php
		if ( ! post_password_required() && comments_open() ) { ?>
			<span class="comments"><?php comments_popup_link( __( '<i class="fa fa-comment"></i> 0 Comments', 'colormag' ), __( '<i class="fa fa-comment"></i> 1 Comment', 'colormag' ), __( '<i class="fa fa-comments"></i> % Comments', 'colormag' ) ); ?></span>
		<?php }
		$tags_list = get_the_tag_list( '<span class="tag-links"><i class="fa fa-tags"></i>', __( ', ', 'colormag' ), '</span>' );
		if ( $tags_list ) {
			echo $tags_list;
		}

		edit_post_link( __( 'Edit', 'colormag' ), '<span class="edit-link"><i class="fa fa-edit"></i>', '</span>' );

		echo '</div>';
	endif;
}
