/*
 * SoftChalk Custom Bubble Styles
 *
 * Created Mar. 18, 2010
 */

//defining a scale factor because overlib_bubble doesn't always scale images down, but it will always scale them up
var OLImageScaleFactor = 10;

var OLSoftChalkFlowerAboveLeft = {	type:"flower_above_left",
									imageName:"flower_above_left",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:395/OLImageScaleFactor,
									contentHeight:295/OLImageScaleFactor,
									contentLeftPadding:48/OLImageScaleFactor,
									contentTopPadding:105/OLImageScaleFactor,
									arrowTipX:378/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkFlowerAboveLeftShadow = {	type:"flower_above_left_shadow",
									imageName:"flower_above_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:381/OLImageScaleFactor,
									contentHeight:295/OLImageScaleFactor,
									contentLeftPadding:62/OLImageScaleFactor,
									contentTopPadding:101/OLImageScaleFactor,
									arrowTipX:378/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkFlowerAboveRight = {	type:"flower_above_right",
									imageName:"flower_above_right",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:381/OLImageScaleFactor,
									contentHeight:309/OLImageScaleFactor,
									contentLeftPadding:72/OLImageScaleFactor,
									contentTopPadding:97/OLImageScaleFactor,
									arrowTipX:134/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkFlowerAboveRightShadow = {	type:"flower_above_right_shadow",
									imageName:"flower_above_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:379/OLImageScaleFactor,
									contentHeight:302/OLImageScaleFactor,
									contentLeftPadding:78/OLImageScaleFactor,
									contentTopPadding:97/OLImageScaleFactor,
									arrowTipX:142/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkFlowerBelowLeft = {	type:"flower_below_left",
									imageName:"flower_below_left",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:374/OLImageScaleFactor,
									contentHeight:322/OLImageScaleFactor,
									contentLeftPadding:68/OLImageScaleFactor,
									contentTopPadding:97/OLImageScaleFactor,
									arrowTipX:378/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkFlowerBelowLeftShadow = {	type:"flower_below_left_shadow",
									imageName:"flower_below_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:367/OLImageScaleFactor,
									contentHeight:317/OLImageScaleFactor,
									contentLeftPadding:75/OLImageScaleFactor,
									contentTopPadding:97/OLImageScaleFactor,
									arrowTipX:378/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkFlowerBelowRight = {	type:"flower_below_right",
									imageName:"flower_below_right",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:369/OLImageScaleFactor,
									contentHeight:326/OLImageScaleFactor,
									contentLeftPadding:75/OLImageScaleFactor,
									contentTopPadding:97/OLImageScaleFactor,
									arrowTipX:134/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkFlowerBelowRightShadow = {	type:"flower_below_right_shadow",
									imageName:"flower_below_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:359/OLImageScaleFactor,
									contentHeight:320/OLImageScaleFactor,
									contentLeftPadding:85/OLImageScaleFactor,
									contentTopPadding:97/OLImageScaleFactor,
									arrowTipX:142/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};


									
									
									
									
									
var OLSoftChalkOvalAboveLeft = {	type:"oval_above_left",
									imageName:"oval_above_left",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:397/OLImageScaleFactor,
									contentHeight:290/OLImageScaleFactor,
									contentLeftPadding:65/OLImageScaleFactor,
									contentTopPadding:93/OLImageScaleFactor,
									arrowTipX:485/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkOvalAboveLeftShadow = {	type:"oval_above_left_shadow",
									imageName:"oval_above_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:374/OLImageScaleFactor,
									contentHeight:284/OLImageScaleFactor,
									contentLeftPadding:72/OLImageScaleFactor,
									contentTopPadding:93/OLImageScaleFactor,
									arrowTipX:480/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkOvalAboveRight = {	type:"oval_above_right",
									imageName:"oval_above_right",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:379/OLImageScaleFactor,
									contentHeight:290/OLImageScaleFactor,
									contentLeftPadding:67/OLImageScaleFactor,
									contentTopPadding:93/OLImageScaleFactor,
									arrowTipX:25/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkOvalAboveRightShadow = {	type:"oval_above_right_shadow",
									imageName:"oval_above_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:369/OLImageScaleFactor,
									contentHeight:280/OLImageScaleFactor,
									contentLeftPadding:77/OLImageScaleFactor,
									contentTopPadding:93/OLImageScaleFactor,
									arrowTipX:36/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkOvalBelowLeft = {	type:"oval_below_left",
									imageName:"oval_below_left",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:369/OLImageScaleFactor,
									contentHeight:302/OLImageScaleFactor,
									contentLeftPadding:71/OLImageScaleFactor,
									contentTopPadding:123/OLImageScaleFactor,
									arrowTipX:485/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkOvalBelowLeftShadow = {	type:"oval_below_left_shadow",
									imageName:"oval_below_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:363/OLImageScaleFactor,
									contentHeight:294/OLImageScaleFactor,
									contentLeftPadding:77/OLImageScaleFactor,
									contentTopPadding:123/OLImageScaleFactor,
									arrowTipX:485/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkOvalBelowRight = {	type:"oval_below_right",
									imageName:"oval_below_right",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:363/OLImageScaleFactor,
									contentHeight:303/OLImageScaleFactor,
									contentLeftPadding:77/OLImageScaleFactor,
									contentTopPadding:123/OLImageScaleFactor,
									arrowTipX:25/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkOvalBelowRightShadow = {	type:"oval_below_right_shadow",
									imageName:"oval_below_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:368/OLImageScaleFactor,
									contentHeight:289/OLImageScaleFactor,
									contentLeftPadding:79/OLImageScaleFactor,
									contentTopPadding:126/OLImageScaleFactor,
									arrowTipX:35/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

									
									
									
									
var OLSoftChalkSpeechAboveLeft = {	type:"speech_above_left",
									imageName:"speech_above_left",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:366/OLImageScaleFactor,
									contentHeight:247/OLImageScaleFactor,
									contentLeftPadding:73/OLImageScaleFactor,
									contentTopPadding:76/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkSpeechAboveLeftShadow = {	type:"speech_above_left_shadow",
									imageName:"speech_above_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:359/OLImageScaleFactor,
									contentHeight:247/OLImageScaleFactor,
									contentLeftPadding:82/OLImageScaleFactor,
									contentTopPadding:75/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkSpeechAboveRight = {	type:"speech_above_right",
									imageName:"speech_above_right",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:366/OLImageScaleFactor,
									contentHeight:247/OLImageScaleFactor,
									contentLeftPadding:73/OLImageScaleFactor,
									contentTopPadding:76/OLImageScaleFactor,
									arrowTipX:15/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkSpeechAboveRightShadow = {	type:"speech_above_right_shadow",
									imageName:"speech_above_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:359/OLImageScaleFactor,
									contentHeight:247/OLImageScaleFactor,
									contentLeftPadding:82/OLImageScaleFactor,
									contentTopPadding:75/OLImageScaleFactor,
									arrowTipX:15/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkSpeechBelowLeft = {	type:"speech_below_left",
									imageName:"speech_below_left",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:366/OLImageScaleFactor,
									contentHeight:247/OLImageScaleFactor,
									contentLeftPadding:73/OLImageScaleFactor,
									contentTopPadding:188/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkSpeechBelowLeftShadow = {	type:"speech_below_left_shadow",
									imageName:"speech_below_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:359/OLImageScaleFactor,
									contentHeight:247/OLImageScaleFactor,
									contentLeftPadding:82/OLImageScaleFactor,
									contentTopPadding:185/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkSpeechBelowRight = {	type:"speech_below_right",
									imageName:"speech_below_right",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:366/OLImageScaleFactor,
									contentHeight:247/OLImageScaleFactor,
									contentLeftPadding:73/OLImageScaleFactor,
									contentTopPadding:188/OLImageScaleFactor,
									arrowTipX:0/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkSpeechBelowRightShadow = {	type:"speech_below_right_shadow",
									imageName:"speech_below_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:359/OLImageScaleFactor,
									contentHeight:247/OLImageScaleFactor,
									contentLeftPadding:82/OLImageScaleFactor,
									contentTopPadding:185/OLImageScaleFactor,
									arrowTipX:0/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};



									
var OLSoftChalkQuotationAboveLeft = {	type:"quotation_above_left",
									imageName:"quotation_above_left",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:478/OLImageScaleFactor,
									contentHeight:439/OLImageScaleFactor,
									contentLeftPadding:17/OLImageScaleFactor,
									contentTopPadding:16/OLImageScaleFactor,
									arrowTipX:476/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkQuotationAboveLeftShadow = {	type:"quotation_above_left_shadow",
									imageName:"quotation_above_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:468/OLImageScaleFactor,
									contentHeight:433/OLImageScaleFactor,
									contentLeftPadding:27/OLImageScaleFactor,
									contentTopPadding:16/OLImageScaleFactor,
									arrowTipX:476/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkQuotationAboveRight = {	type:"quotation_above_right",
									imageName:"quotation_above_right",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:482/OLImageScaleFactor,
									contentHeight:443/OLImageScaleFactor,
									contentLeftPadding:13/OLImageScaleFactor,
									contentTopPadding:16/OLImageScaleFactor,
									arrowTipX:30/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkQuotationAboveRightShadow = {	type:"quotation_above_right_shadow",
									imageName:"quotation_above_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:472/OLImageScaleFactor,
									contentHeight:433/OLImageScaleFactor,
									contentLeftPadding:23/OLImageScaleFactor,
									contentTopPadding:16/OLImageScaleFactor,
									arrowTipX:40/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkQuotationBelowLeft = {	type:"quotation_below_left",
									imageName:"quotation_below_left",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:478/OLImageScaleFactor,
									contentHeight:443/OLImageScaleFactor,
									contentLeftPadding:17/OLImageScaleFactor,
									contentTopPadding:51/OLImageScaleFactor,
									arrowTipX:480/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkQuotationBelowLeftShadow = {	type:"quotation_below_left_shadow",
									imageName:"quotation_below_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:468/OLImageScaleFactor,
									contentHeight:433/OLImageScaleFactor,
									contentLeftPadding:26/OLImageScaleFactor,
									contentTopPadding:51/OLImageScaleFactor,
									arrowTipX:480/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkQuotationBelowRight = {	type:"quotation_below_right",
									imageName:"quotation_below_right",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:481/OLImageScaleFactor,
									contentHeight:445/OLImageScaleFactor,
									contentLeftPadding:14/OLImageScaleFactor,
									contentTopPadding:51/OLImageScaleFactor,
									arrowTipX:41/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkQuotationBelowRightShadow = {	type:"quotation_below_right_shadow",
									imageName:"quotation_below_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:471/OLImageScaleFactor,
									contentHeight:437/OLImageScaleFactor,
									contentLeftPadding:24/OLImageScaleFactor,
									contentTopPadding:51/OLImageScaleFactor,
									arrowTipX:41/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

									
									
									
var OLSoftChalkThoughtAboveLeft = {	type:"thought_above_left",
									imageName:"thought_above_left",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:358/OLImageScaleFactor,
									contentHeight:224/OLImageScaleFactor,
									contentLeftPadding:73/OLImageScaleFactor,
									contentTopPadding:61/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkThoughtAboveLeftShadow = {	type:"thought_above_left_shadow",
									imageName:"thought_above_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:353/OLImageScaleFactor,
									contentHeight:221/OLImageScaleFactor,
									contentLeftPadding:78/OLImageScaleFactor,
									contentTopPadding:61/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkThoughtAboveRight = {	type:"thought_above_right",
									imageName:"thought_above_right",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:353/OLImageScaleFactor,
									contentHeight:221/OLImageScaleFactor,
									contentLeftPadding:87/OLImageScaleFactor,
									contentTopPadding:61/OLImageScaleFactor,
									arrowTipX:0/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkThoughtAboveRightShadow = {	type:"thought_above_right_shadow",
									imageName:"thought_above_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:353/OLImageScaleFactor,
									contentHeight:221/OLImageScaleFactor,
									contentLeftPadding:90/OLImageScaleFactor,
									contentTopPadding:61/OLImageScaleFactor,
									arrowTipX:0/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkThoughtBelowLeft = {	type:"thought_below_left",
									imageName:"thought_below_left",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:360/OLImageScaleFactor,
									contentHeight:221/OLImageScaleFactor,
									contentLeftPadding:69/OLImageScaleFactor,
									contentTopPadding:224/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkThoughtBelowLeftShadow = {	type:"thought_below_left_shadow",
									imageName:"thought_below_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:351/OLImageScaleFactor,
									contentHeight:221/OLImageScaleFactor,
									contentLeftPadding:78/OLImageScaleFactor,
									contentTopPadding:224/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkThoughtBelowRight = {	type:"thought_below_right",
									imageName:"thought_below_right",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:361/OLImageScaleFactor,
									contentHeight:221/OLImageScaleFactor,
									contentLeftPadding:81/OLImageScaleFactor,
									contentTopPadding:224/OLImageScaleFactor,
									arrowTipX:0/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkThoughtBelowRightShadow = {	type:"thought_below_right_shadow",
									imageName:"thought_below_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:352/OLImageScaleFactor,
									contentHeight:218/OLImageScaleFactor,
									contentLeftPadding:91/OLImageScaleFactor,
									contentTopPadding:224/OLImageScaleFactor,
									arrowTipX:0/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

								



var OLSoftChalkPostitAboveLeftShadow = {	type:"postit_above_left_shadow",
									imageName:"postit_above_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:449/OLImageScaleFactor,
									contentHeight:421/OLImageScaleFactor,
									contentLeftPadding:31/OLImageScaleFactor,
									contentTopPadding:58/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkPostitAboveRightShadow = {	type:"postit_above_right_shadow",
									imageName:"postit_above_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:449/OLImageScaleFactor,
									contentHeight:421/OLImageScaleFactor,
									contentLeftPadding:31/OLImageScaleFactor,
									contentTopPadding:58/OLImageScaleFactor,
									arrowTipX:0/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkPostitBelowLeftShadow = {	type:"postit_below_left_shadow",
									imageName:"postit_below_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:449/OLImageScaleFactor,
									contentHeight:421/OLImageScaleFactor,
									contentLeftPadding:31/OLImageScaleFactor,
									contentTopPadding:58/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkPostitBelowRightShadow = {	type:"postit_below_right_shadow",
									imageName:"postit_below_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:449/OLImageScaleFactor,
									contentHeight:421/OLImageScaleFactor,
									contentLeftPadding:31/OLImageScaleFactor,
									contentTopPadding:58/OLImageScaleFactor,
									arrowTipX:0/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};
									
									
									
var OLSoftChalkPushpinAboveLeftShadow = {	type:"pushpin_above_left_shadow",
									imageName:"pushpin_above_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:449/OLImageScaleFactor,
									contentHeight:394/OLImageScaleFactor,
									contentLeftPadding:31/OLImageScaleFactor,
									contentTopPadding:85/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkPushpinAboveRightShadow = {	type:"pushpin_above_right_shadow",
									imageName:"pushpin_above_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:449/OLImageScaleFactor,
									contentHeight:394/OLImageScaleFactor,
									contentLeftPadding:31/OLImageScaleFactor,
									contentTopPadding:85/OLImageScaleFactor,
									arrowTipX:0/OLImageScaleFactor,
									arrowTipY:512/OLImageScaleFactor};

var OLSoftChalkPushpinBelowLeftShadow = {	type:"pushpin_below_left_shadow",
									imageName:"pushpin_below_left_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:449/OLImageScaleFactor,
									contentHeight:394/OLImageScaleFactor,
									contentLeftPadding:31/OLImageScaleFactor,
									contentTopPadding:85/OLImageScaleFactor,
									arrowTipX:512/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};

var OLSoftChalkPushpinBelowRightShadow = {	type:"pushpin_below_right_shadow",
									imageName:"pushpin_below_right_shadow",
									imageWidth:512/OLImageScaleFactor,
									imageHeight:512/OLImageScaleFactor,
									contentWidth:449/OLImageScaleFactor,
									contentHeight:394/OLImageScaleFactor,
									contentLeftPadding:31/OLImageScaleFactor,
									contentTopPadding:85/OLImageScaleFactor,
									arrowTipX:0/OLImageScaleFactor,
									arrowTipY:0/OLImageScaleFactor};
									
var OLSoftChalkAvailableBubbleStyles = [OLSoftChalkFlowerAboveLeft, OLSoftChalkFlowerAboveLeftShadow,
										OLSoftChalkFlowerAboveRight, OLSoftChalkFlowerAboveRightShadow,
										OLSoftChalkFlowerBelowLeft, OLSoftChalkFlowerBelowLeftShadow,
										OLSoftChalkFlowerBelowRight, OLSoftChalkFlowerBelowRightShadow,
										OLSoftChalkOvalAboveLeft, OLSoftChalkOvalAboveLeftShadow,
										OLSoftChalkOvalAboveRight, OLSoftChalkOvalAboveRightShadow,
										OLSoftChalkOvalBelowLeft, OLSoftChalkOvalBelowLeftShadow,
										OLSoftChalkOvalBelowRight, OLSoftChalkOvalBelowRightShadow,
										OLSoftChalkSpeechAboveLeft, OLSoftChalkSpeechAboveLeftShadow,
										OLSoftChalkSpeechAboveRight, OLSoftChalkSpeechAboveRightShadow,
										OLSoftChalkSpeechBelowLeft, OLSoftChalkSpeechBelowLeftShadow,
										OLSoftChalkSpeechBelowRight, OLSoftChalkSpeechBelowRightShadow,
										OLSoftChalkQuotationAboveLeft, OLSoftChalkQuotationAboveLeftShadow,
										OLSoftChalkQuotationAboveRight, OLSoftChalkQuotationAboveRightShadow,
										OLSoftChalkQuotationBelowLeft, OLSoftChalkQuotationBelowLeftShadow,
										OLSoftChalkQuotationBelowRight, OLSoftChalkQuotationBelowRightShadow,
										OLSoftChalkThoughtAboveLeft, OLSoftChalkThoughtAboveLeftShadow,
										OLSoftChalkThoughtAboveRight, OLSoftChalkThoughtAboveRightShadow,
										OLSoftChalkThoughtBelowLeft, OLSoftChalkThoughtBelowLeftShadow,
										OLSoftChalkThoughtBelowRight, OLSoftChalkThoughtBelowRightShadow,
										OLSoftChalkPostitAboveLeftShadow,
										OLSoftChalkPostitAboveRightShadow,
										OLSoftChalkPostitBelowLeftShadow,
										OLSoftChalkPostitBelowRightShadow,
										OLSoftChalkPushpinAboveLeftShadow,
										OLSoftChalkPushpinAboveRightShadow,
										OLSoftChalkPushpinBelowLeftShadow,
										OLSoftChalkPushpinBelowRightShadow
										];

//defining the variables used to hold the data
var OLbubbleImageSet = "";
var OLbubbleImages = "";
var OLimgWidth = new Array();
var OLimgHeight = new Array();
var OLcontentWidth = new Array();
var OLcontentHeight = new Array();
var OLpadLeft = new Array();
var OLpadTop = new Array();
var OLarwTipX = new Array();
var OLarwTipY = new Array();

//creating the image set and other variables that are used by the poppers
for (var i = 0; i < OLSoftChalkAvailableBubbleStyles.length; i++) {
	var bubbleStyle = OLSoftChalkAvailableBubbleStyles[i];
	
	if (i == 0) {
		OLbubbleImageSet += bubbleStyle.type;
		OLbubbleImages += bubbleStyle.imageName;
	} else {
		OLbubbleImageSet += "," + bubbleStyle.type;
		OLbubbleImages += "," + bubbleStyle.imageName;
	}
	
	OLimgWidth.push(bubbleStyle.imageWidth);
	OLimgHeight.push(bubbleStyle.imageHeight);
	OLcontentWidth.push(bubbleStyle.contentWidth);
	OLcontentHeight.push(bubbleStyle.contentHeight);
	OLpadLeft.push(bubbleStyle.contentLeftPadding);
	OLpadTop.push(bubbleStyle.contentTopPadding);
	OLarwTipX.push(bubbleStyle.arrowTipX);
	OLarwTipY.push(bubbleStyle.arrowTipY);
}

OLloaded = 0;
var OLbubbleCmds = "bubble,bubbletype,adjbubble,rcbubblecolor,bubbleclose";
OLregCmds(OLbubbleCmds);
if (OLud("bubble")) {
	var ol_bubble = 0;
}
if (OLud("bubbletype")) {
	var ol_bubbletype = "";
}
if (OLud("adjbubble")) {
	var ol_adjbubble = 0;
}
if (OLud("rcbubblecolor")) {
	var ol_rcbubblecolor = "#ffffcc";
}
if (OLud("bubbleclose")) {
	var ol_bubbleclose = 0;
}

function OLund(v) {
	return eval("typeof " + v + "==\"undefined\"") ? 1 : 0;
}

if (OLund("OLbubbleImageSet")) {
	var OLbubbleImageSet = "flower,oval,square,pushpin,quotation,roundcorners";
}
if (OLund("OLbubbleImages")) {
	var OLbubbleImages = OLbubbleImageSet;
}
if (OLund("OLbubbleImageDir")) {
	var OLbubbleImageDir = "./";
}
if (OLund("OLbubbleIMGsuffix")) {
	var OLbubbleIMGsuffix = "";
}
if (OLund("OLbubbleRCsuffix")) {
	var OLbubbleRCsuffix = "";
}
if (OLund("OLimgWidth")) {
	var OLimgWidth = [250, 330, 144, 202, 200];
}
if (OLund("OLimgHeight")) {
	var OLimgHeight = [150, 160, 190, 221, 66];
}
if (OLund("OLcontentWidth")) {
	var OLcontentWidth = [200, 250, 130, 184, 190];
}
if (OLund("OLcontentHeight")) {
	var OLcontentHeight = [80, 85, 150, 176, 46];
}
if (OLund("OLpadLeft")) {
	var OLpadLeft = [30, 40, 7, 9, 5];
}
if (OLund("OLpadTop")) {
	var OLpadTop = [25, 48, 10, 34, 4];
}
if (OLund("OLarwTipX")) {
	var OLarwTipX = [180, 50, 51, 9, 19];
}
if (OLund("OLarwTipY")) {
	var OLarwTipY = [148, 5, 180, 221, 64];
}
var o3_bubble = 0, o3_bubbletype = "", o3_adjbubble = 0, o3_rcbubblecolor = "", o3_bubbleclose = 0, OLbubbleHt = 0, OLbI, OLbContentWd = OLcontentWidth, OLbContentHt = OLcontentHeight;
OLregisterImages(OLbubbleImageSet, OLbubbleImageDir, OLbubbleIMGsuffix, OLbubbleRCsuffix);

function OLloadBubble() {
	OLload(OLbubbleCmds);
	OLbubbleHt = 0;
}


function OLparseBubble(pf, i, ar) {
	var k = i, t = OLtoggle, q = OLparQuo;
	if (k < ar.length) {
		if (Math.abs(ar[k]) == BUBBLE) {
			t(ar[k], pf + "bubble");
			return k;
		}
		if (ar[k] == BUBBLETYPE) {
			q(ar[++k], pf + "bubbletype");
			return k;
		}
		if (Math.abs(ar[k]) == ADJBUBBLE) {
			t(ar[k], pf + "adjbubble");
			return k;
		}
		if (ar[k] == RCBUBBLECOLOR) {
			q(ar[++k], pf + "rcbubblecolor");
			return k;
		}
		if (Math.abs(ar[k]) == BUBBLECLOSE) {
			t(ar[k], pf + "bubbleclose");
			return k;
		}
	}
	return -1;
}


function OLchkForBubbleEffect() {
	if (o3_bubble) {
		o3_bubbletype = o3_bubbletype ? o3_bubbletype : "flower";
		for (var i = 0; i < OLbTypes.length; i++) {
			if (OLbTypes[i] == o3_bubbletype) {
				OLbI = i;
				break;
			}
		}
		o3_bgcolor = o3_fgcolor = "";
		o3_border = o3_base = 0;
		o3_fgbackground = o3_bgbackground = o3_cgbackground = o3_background = "";
		o3_cap = "";
		if (o3_sticky) {
			o3_noclose = o3_bubbleclose ? 0 : 1;
		}
		o3_fullhtml = 0;
		if (OLshadowPI) {
			o3_shadow = 0;
		}
		if (o3_bubbletype.indexOf("roundcorners") < 0) {
			o3_width = OLbContentWd[OLbI];
			o3_hpos = RIGHT;
			o3_vpos = BELOW;
			o3_vauto = 0;
			o3_hauto = 0;
			o3_wrap = 0;
			o3_nojusty = 1;
		}
	}
	return true;
}


function OLregisterImages(imgStr, path, isuffix, rsuffix) {
	if (typeof imgStr != "string") {
		return;
	}
	var p = path && typeof path == "string" ? path : ".", is = typeof isuffix == "string" ? isuffix : "", rs = typeof rsuffix == "string" ? rsuffix : "", bT;
	if (p.charAt(p.length - 1) == "/") {
		p = p.substring(0, p.length - 1);
	}
	if (OLund("OLbTypes")) {
		OLbTypes = imgStr.split(",");
	}
	if (OLund("OLbubbleImg")) {
		OLbubbleImg = new Array;
		for (var i = 0; i < OLbTypes.length; i++) {
			bT = OLbTypes[i];
			if (OLbubbleImages.indexOf(bT) < 0) {
				continue;
			}
			if (bT.indexOf("roundcorners") == 0) {
				OLbubbleImg[i] = new Array;
				var o = OLbubbleImg[i], su = (bT.length > 12 ? bT.substring(12) : "") + rs;
				o[0] = new Image;
				o[0].src = p + ("/cornerTL" + su + ".png");
				o[1] = new Image;
				o[1].src = p + ("/edgeT" + su + ".png");
				o[2] = new Image;
				o[2].src = p + ("/cornerTR" + su + ".png");
				o[3] = new Image;
				o[3].src = p + ("/edgeL" + su + ".png");
				o[4] = new Image;
				o[4].src = p + ("/edgeR" + su + ".png");
				o[5] = new Image;
				o[5].src = p + ("/cornerBL" + su + ".png");
				o[6] = new Image;
				o[6].src = p + ("/edgeB" + su + ".png");
				o[7] = new Image;
				o[7].src = p + ("/cornerBR" + su + ".png");
			} else {
				OLbubbleImg[i] = new Image;
				OLbubbleImg[i].src = p + ("/" + bT + is + ".png");
			}
		}
	}
}


function OLgenerateBubble(content) {
	if (!o3_bubble) {
		return;
	}
	if (o3_bubbletype.indexOf("roundcorners") == 0) {
		return OLdoRoundCorners(content);
	}
	var ar, X, Y, W, fc = 1, widthScale = 1, heightScale = 1, txt, sY, bHtDiff, bPadDiff = 0, bLobj, bCobj, bTopPad = OLpadTop, bLeftPad = OLpadLeft, bContentHt = OLcontentHeight, bHt = OLimgHeight, bWd = OLimgWidth, bArwTipX = OLarwTipX, bArwTipY = OLarwTipY;
	bHtDiff = fc * bContentHt[OLbI] - (OLns4 ? over.clip.height : over.offsetHeight);
	if (o3_adjbubble) {
		fc = OLresizeBubble(bHtDiff, 0.5, fc);
		ar = OLgetHeightDiff(fc);
		bHtDiff = ar[0];
		content = ar[1];
		var contentActualWidth = (OLns4 ? over.clip.width : over.offsetWidth);
		var contentActualHeight = (OLns4 ? over.clip.height : over.offsetHeight);
		var bubbleContentWidth = OLcontentWidth[OLbI];
		var bubbleContentHeight = OLcontentHeight[OLbI];
		widthScale = contentActualWidth / bubbleContentWidth;
		heightScale = contentActualHeight / bubbleContentHeight;
	}
	Y = heightScale * bTopPad[OLbI]
	X = widthScale * bLeftPad[OLbI];
	Y = Math.ceil(Y);
	X = Math.ceil(X);
	o3_width = Math.ceil(widthScale * bWd[OLbI]);
	o3_height = Math.ceil(heightScale * bHt[OLbI]);
	W = Math.ceil(widthScale * OLbContentWd[OLbI]);
	H = Math.ceil(heightScale * OLbContentHt[OLbI]);
	txt = "<img src=\"" + OLbubbleImg[OLbI].src + "\" width=\"" + o3_width + "\" height=\"" + o3_height + "\" />" + (OLns4 ? "<div id=\"bContent\">" : "<div id=\"bContent\" style=\"position:absolute; top:" + Y + "px; left:" + X + "px; width:" + W + "px; height:" + H + "px; z-index:1;\">") + content + "</div>";
	OLlayerWrite(txt);
	if (OLns4) {
		bCobj = over.document.layers.bContent;
		if (typeof bCobj == "undefined") {
			return;
		}
		bCobj.top = Y;
		bCobj.left = X;
		bCobj.clip.width = W;
		bCobj.zIndex = 1;
	}
	sY = -Math.ceil(heightScale * bArwTipY[OLbI]);
	o3_offsetx -= Math.ceil(widthScale * bArwTipX[OLbI]);
	o3_offsety += sY;
}


function OLdoRoundCorners(content) {
	var wd = OLns4 ? over.clip.width : over.offsetWidth, ht = OLns4 ? over.clip.height : over.offsetHeight, o = OLbubbleImg[OLbI], ids = " style=\"display:block;\"", wd14 = "\" width=\"14", ht14 = "\" height=\"14\"", t = "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td align=\"right\" valign=\"bottom\"><img src=\"" + o[0].src + wd14 + ht14 + ids + " /></td><td valign=\"bottom\"><img src=\"" + o[1].src + "\" width=\"" + wd + ht14 + ids + " /></td><td align=\"left\" valign=\"bottom\"><img src=\"" + o[2].src + wd14 + ht14 + ids + " /></td></tr><tr><td align=\"right\"><img src=\"" + o[3].src + wd14 + ids + "\" height=\"" + ht + "\"" + ids + " /></td><td bgcolor=\"" + o3_rcbubblecolor + "\">" + content + "</td><td align=\"left\"><img src=\"" + o[4].src + wd14 + ids + "\" height=\"" + ht + "\"" + ids + " /></td></tr><tr><td align=\"right\" valign=\"top\"><img src=\"" + o[5].src + wd14 + ht14 + ids + " /></td><td valign=\"top\"><img src=\"" + o[6].src + "\" width=\"" + wd + ht14 + ids + " /></td><td align=\"left\" valign=\"top\"><img src=\"" + o[7].src + wd14 + ht14 + ids + " /></td></tr></table>";
	OLlayerWrite(t);
	o3_width = wd + 28;
	OLbubbleHt = ht + 28;
}


function OLresizeBubble(h1, dF, fold) {
	var df, h2, fnew, alpha, cnt = 0;
	while (cnt < 2) {
		df = - OLsignOf(h1) * dF;
		fnew = fold + df;
		h2 = OLgetHeightDiff(fnew)[0];
		if (Math.abs(h2) < 11) {
			break;
		}
		if (OLsignOf(h1) != OLsignOf(h2)) {
			alpha = Math.abs(h1) / (Math.abs(h1) + Math.abs(h2));
			if (h1 < 0) {
				fnew = alpha * fnew + (1 - alpha) * fold;
			} else {
				fnew = (1 - alpha) * fnew + alpha * fold;
			}
		} else {
			alpha = Math.abs(h1) / (Math.abs(h2) - Math.abs(h1));
			if (h1 < 0) {
				fnew = (1 + alpha) * fold - alpha * fnew;
			} else {
				fnew = (1 + alpha) * fnew - alpha * fold;
			}
		}
		fold = fnew;
		h1 = h2;
		dF *= 0.5;
		cnt++;
	}
	return fnew;
}


function OLsignOf(x) {
	return x < 0 ? -1 : 1;
}


function OLgetHeightDiff(f) {
	var lyrhtml;
	o3_width = Math.ceil(f * OLcontentWidth[OLbI]);
	lyrhtml = OLcontentSimple(o3_text);
	OLlayerWrite(lyrhtml);
	return [f * OLcontentHeight[OLbI] - (OLns4 ? over.clip.height : over.offsetHeight), lyrhtml];
}

OLregRunTimeFunc(OLloadBubble);
OLregCmdLineFunc(OLparseBubble);
if (OLns4) {
	document.write("<style type=\"text/css\">\n<!--\n#bContent{position:absolute;left:0px;top:0px;width:1024}\n-->\n</style>");
}
OLbubblePI = 1;
OLloaded = 1;
