***********************************************************************.
*                                                                     *.
***********************************************************************.

FILE HANDLE SHOW     / NAME='P:\SHOW\SHOW_ESORT\RCU11FA.PRELIM.FSORT'.
FILE HANDLE ETHFILE  / NAME='P:\Show\show_raw\2011_09\ethnicity\FA11_Prelim.TXT'.

FILE HANDLE ETHFILE2  / NAME='P:\Show\show_raw\2011_09\ethnicity\FA11_PRELIM_IPED.TXT'.

FILE HANDLE SHOWSYS  / NAME='C:\TEMP\SHOW.SAV'.
FILE HANDLE HISPANIC / NAME='C:\TEMP\HISPANIC.SAV'.
FILE HANDLE ASIAN    / NAME='C:\TEMP\ASIAN.SAV'.
FILE HANDLE ZIPCODE  / NAME='C:\TEMP\ZIPCODE.SAV'.

*######################################################################.
* PART 1: READ SHOW-REG FILE AND SAVE AS SYSTEM FILE.
*######################################################################.
SET BLANKS=0.
DATA LIST FILE = SHOW /
     COLA     0003-0004 (A)
     CURYRN   0005-0008
     CURSSNA  0011-0019 (A)
     LNAME    0029-0047 (A)
     ZIP5N    0178-0182
     RCODEN   0190-0191
     STATUSA       0192 (A)
     FPTIMEN       0193
     CSTLN         0194
     SPECA         0197 (A)
     OTHSPN   0210-0211
     ETHN     0257-0258
     SEXA          0272 (A)
     DOBYRN   0273-0276
     ADMITN   0281-0282
     NEWRACE  2449-2454 (A)
     HI       2449-2449 (A)
     AI       2450-2450 (A)
     AS 	  2451-2451 (A)     
     BL	  2452-2452 (A)
     PI 	  2453-2453 (A)
     WH       2454-2454 (A).

EXECUTE.

RECODE CURYRN   (MISSING=0)(SYSMIS=0)(ELSE=COPY).
RECODE ZIP5N    (MISSING=0)(SYSMIS=0)(ELSE=COPY).
RECODE RCODEN   (MISSING=0)(SYSMIS=0)(ELSE=COPY).
RECODE FPTIMEN  (MISSING=0)(SYSMIS=0)(ELSE=COPY).
RECODE CSTLN    (MISSING=0)(SYSMIS=0)(ELSE=COPY).
RECODE OTHSPN   (MISSING=0)(SYSMIS=0)(ELSE=COPY).
RECODE DOBYRN   (MISSING=0)(SYSMIS=0)(ELSE=COPY).
RECODE ETHN     (MISSING=0)(SYSMIS=0)(ELSE=COPY).
RECODE ADMITN   (MISSING=0)(SYSMIS=0)(ELSE=COPY).

SELECT IF (ANY(COLA,'01','02','03','04','05','06','07','08','09',
                    '11','12','13','14','15','16','18','19','21',
                    '22','23','25')).

FREQ VAR=COLA.

FREQ VAR=NEWRACE.

CROSSTAB TAB=NEWRACE BY ETHN.

**************************************************.
*R/E VARIABLES FROM 2Q FORMAT.
**************************************************.

FREQ VAR=BL HI AS PI WH AI.

STRING BL1 HI1 AS1 WH1 AI1 (A1).

**************************************************.
*RECODE R/E VARIABLES TO COMPUTE SINGLE VARIABLE.
**************************************************.

*RECODE BL HI WH AI (' ','2'='X') (ELSE=COPY) INTO BL1 HI1 WH1 AI1.
RECODE BL HI WH AI ('1'='1') (ELSE='X') INTO BL1 HI1 WH1 AI1.

*DO IF AS='1' OR 'PI'='1'.
DO IF AS='1' OR PI='1'.
COMPUTE AS1='A'.
ELSE.
COMPUTE AS1='X'.
END IF.

IF BL1='1' BL1='B'.
IF HI1='1' HI1='H'.
IF WH1='1' WH1='W'.
IF AI1='1' AI1='I'.

CROSS TAB BL BY BL1 / HI BY HI1 / AS BY PI BY AS1 / WH BY WH1 / AI BY AI1. 

STRING RACEALL (A6).

VAR LABEL RACEALL 'CONCATENATED RESULTS OF 2Q R/E DATA'.

COMPUTE RACEALL=CONCAT(BL1, HI1, AS1, WH1, AI1).

FREQ VAR=RACEALL ETHN.

CROSSTAB TAB=RACEALL BY ETHN.

TEMP.
SELECT IF ADMITN=1.
FREQ VAR=COLA.

DO IF ADMITN=1.
COMPUTE NEWSTUN=1.
END IF.

CROSS TAB BL HI AS WH AI BY NEWSTUN.

***********************************************.
*CREATE NUMERIC R/E VARIABLES IN ORDER TO IDENTIFY MULTI-RACE STUDENTS.
***********************************************.

NUMERIC BLN HIN ASN PIN WHN AIN (F1.0).

RECODE BL HI AS PI WH AI (CONVERT) INTO BLN HIN ASN PIN WHN AIN.

FREQ VAR=BLN HIN ASN PIN WHN AIN.

RECODE BLN HIN ASN PIN WHN AIN (2=0) (1=1).


FREQ VAR=ASN.

FREQ VAR=BL HI AS WH AI .
RECODE BLN HIN ASN WHN AIN (1=1) (ELSE=0).

FREQ VAR=BLN HIN ASN WHN AIN.

NUMERIC TOTRACE (F1.0).
VAR LABEL TOTRACE 'NUMBER OF R/E CATEGORIES SELECTED'.
COMPUTE TOTRACE = SUM(BLN, HIN, ASN, PIN, WHN, AIN).

CROSS TAB RACEALL BY TOTRACE.

NUMERIC MULTIRACE (F1.0).

VAR LABEL MULTIRACE 'FLAG FOR MULTIPLE R/E IDENTIFICATION'.

COMPUTE MULTIRACE=0.
DO IF SUM(BLN, HIN, ASN, WHN, AIN) > 1.
COMPUTE MULTIRACE=1.
END IF.

FREQ VAR=MULTIRACE.

****************************************************************.
*RECODE 2Q-R/E FIELDS WITH A SINGLE RACE INTO CODES USED FOR 1Q-R/E FIELD.
****************************************************************.

FREQ VAR=TOTRACE.

COMPUTE NEWETH=0.

DO IF TOTRACE=1.
DO IF BLN=1.
COMPUTE NEWETH=2.
ELSE IF HIN=1.
COMPUTE NEWETH=4.
ELSE IF ASN=1.
COMPUTE NEWETH=5.
ELSE IF PIN=1.
COMPUTE NEWETH=5.
ELSE IF WHN=1.
COMPUTE NEWETH=1.
ELSE IF AIN=1.
COMPUTE NEWETH=6.
END IF.
END IF.

VAL LAB NEWETH  1 'WHITE'
		    2 'BLACK'
 		    3 'HISPANIC'
		    4 'HISPANIC'
		    5 'ASIAN'
                6 'NATIVE AMERICAN'.


FREQ VAR NEWETH.

****************************************************************.
****************************************************************.

CROSSTAB TAB=ETHN BY NEWETH.

*****************************************************************************************.
*SELECT STUDENTS WHO HAVE REPORTED ETHNICITY IN THE OLD FIELD AND THE NEW FIELD.
*USE REPORTED ETHNICITY IN OLD FIELD AS BASE PLUS NEW REPORTED ETHNICTY FOR IMPUTED.
*SELECT NEW RACE FIELD, STUDENTS REPORTED ONLY ONE ETHNICITY.
*****************************************************************************************.

TEMP.
SELECT IF ANY (ETHN, 1,2,3,4,5,6) OR ANY(NEWETH, 1, 2, 3, 4, 5).
CROSSTAB TAB=ETHN BY NEWETH.

NUMERIC ETHN4 (F1.0).

COMPUTE ETHN4=0.

VAR LAB ETHN4 'REPORTED ETHNICITY'.

VALUE LABELS ETHN4
       1 'WHITE' 2 'BLACK' 4'HISPANIC' 5 'ASIAN' 6 'AM IND'.

FREQ VAR=ETHN4, ETHN.

COMPUTE ETHN4=0.

TEMP.
SELECT IF (ETHN LE 6) AND (ETHN <>0).
FREQ VAR=ETHN.

DO IF (ETHN LE 6) AND (ETHN <> 0).
COMPUTE ETHN4=ETHN.
END IF.

DO IF (ETHN4=3).
COMPUTE ETHN4 = 4.
END IF. 

FREQ VAR=ETHN4.

*********************************************************************.
*CHECK HOW MANY NEWETH IN ETHN2=0.
*********************************************************************.

TEMP.
SELECT IF ETHN4=0.
FREQ VAR=NEWETH.

*CROSSTAB TAB=ETHN2 BY NEWETH.

*********************************************************************.

DO IF ETHN4=0.
DO IF NEWETH=1.
COMPUTE ETHN4=1.
ELSE IF NEWETH=2.
COMPUTE ETHN4=2.
ELSE IF NEWETH=3.
COMPUTE ETHN4=3.
ELSE IF NEWETH=4.
COMPUTE ETHN4=4.
ELSE IF NEWETH=5.
COMPUTE ETHN4=5.
ELSE IF NEWETH=6.
COMPUTE ETHN4=6.
ELSE.
COMPUTE ETHN4=0.
END IF.
END IF.

FREQ VAR=ETHN4.

*******************************************************************.

CROSSTAB TAB=ETHN BY ETHN4.

**********************************************************************.
* IDENTIFY STUDENTS FROM JOHN JAY'S BRANCH CAMPUS IN PUERTO RICO.
**********************************************************************.

*DO IF (COLA='16') AND (OTHSPN=22).
*COMPUTE JJPR=1.
*ELSE.
*COMPUTE JJPR=0.
*END IF.

*RECODE JJPR (1=1)(ELSE=0)(MISSING,SYSMIS=0).

***********************************************************************.
* COMPUTE ETHNIC CATEGORIES.
***********************************************************************.
RECODE ETHN (1=1)(2=2)(3,4=4)(5=5)(6=6)(ELSE=0).

RECODE ETHN4 (1=1)(2=2)(3,4=4)(5=5)(6=6)(ELSE=0).

VALUE LABELS ETHN, ETHN4
          1 'WHITE' 2 'BLACK' 4'HISPANIC' 5 'ASIAN' 6 'AM IND'.


FREQ VAR=ETHN, ETHN4.

CROSSTAB TAB=ETHN BY ETHN4.


***********************************************************************.
* COMPUTE ZIP CODE CATEGORIES.
***********************************************************************.
COMPUTE ZIPCAT=ZIP5N.
RECODE ZIPCAT (00001 THRU 01000=0)(01002 THRU 06907=01000)
   (09000 THRU 09800=0)
   (07000 THRU 07199=070)(07200 THRU 07299=072)
   (07300 THRU 07399=073)(07400 THRU 07599=074)
   (07600 THRU 07699=076)(07700 THRU 07799=077)(07800 THRU 07899=074)
   (07900 THRU 07999=079)(08000 THRU 08099=082)(08100 THRU 08199=081)
   (08200 THRU 08399=082)(08400 THRU 08499=084)(08500 THRU 08799=085)
   (08800 THRU 08999=088)
   (15000 THRU 19999=150)(20000 THRU 29999=200)(30000 THRU 98999=300)
    (10004,10005,10006,10046,10048=10004)(10019,10020=10019)
    (10314,10313=10314)(11004,11005=11004)(11360,11359=11360)
    (11370,11371=11370)(11430,11414=11430)
     (10500 THRU 10599=105)
     (10600 THRU 10699=106)
     (10700 THRU 10799=107)
     (10800 THRU 10899=108)
     (10900 THRU 10999=109)
     (11500 THRU 11599=115)
     (11700 THRU 11899=117)
     (11900 THRU 11999=119)
     (12000 THRU 14999=120).

VALUE LABELS  ZIPCAT 01000'MA,RI,NH,MA,VT,CN' 07000'NJ'
   105 'WESTCHESTER' 106'WHITE PLAN' 107'YONKERS'
   108'NEW ROCHELLE' 109'ROCKLAND'
   115'WEST NASSAU' 116'FAR ROCKAW-MISS' 117'HICKSVILE,7&8'
   119'RIVERHEAD' 120'UPSTATE NY'
   150'PA,DE' 200'DC,MA,VA,NC,SC' 300'REST OF US'
   070'NEWARK' 072'ELIZABETH' 073'JERSEY CITY' 074'PATERSON'
   076'HACKENSACK' 077'RED BANK' 079'SUMMIT' 082'SOUTH JERSEY'
   081'CAMDEN' 084'ATLANTIC CITY' 085'TRENTON' 088'NEW BRUNSWICK'.
   
** MAKING NJ 081,082,084 - HAVE LESS THAN 10 STUDENTS INTO 079 **.
IF (ZIPCAT=081 OR ZIPCAT=082 OR ZIPCAT=084) ZIPCAT=079.

***********************************************************************.
* SAVE SHOW-REG DATA IN A SYSTEM FILE.
***********************************************************************.
SORT CASES BY LNAME.
SAVE OUTFILE=SHOWSYS.

*######################################################################.
* PART 2: CREATE SYSTEM FILES AGGREGATED BY LAST-NAMES AND ZIPCODES.
*######################################################################.
GET FILE=SHOWSYS /
    KEEP=LNAME ZIPCAT ETHN4.

***********************************************************************.
* CREATE SYSTEM FILE FOR HISPANIC LAST-NAMES.
***********************************************************************.
TEMPORARY.
SELECT IF (ETHN4=3) OR (ETHN4=4).
AGGREGATE OUTFILE=HISPANIC
   /PRESORTED
   /BREAK=LNAME
   /HCOUNT=N.

***********************************************************************.
* CREATE SYSTEM FILE FOR ASIAN LAST-NAMES.
***********************************************************************.
TEMPORARY.
SELECT IF (ETHN4=5).
AGGREGATE OUTFILE = ASIAN
   /PRESORTED
   /BREAK = LNAME
   /ASCOUNT = N.

***********************************************************************.
* CREATE SYSTEM FILE FOR ETHNIC PROPORTIONS BY ZIP CODE CATEGORY.
***********************************************************************.
SORT CASES BY ZIPCAT.

TEMPORARY.
SELECT IF (ANY(ETHN4,1,2,3,4,5)).
AGGREGATE OUTFILE=ZIPCODE
   /PRESORTED
   /BREAK=ZIPCAT
   /PRCZHIS=PIN(ETHN4,3,4)
   /PRCZAS=PIN(ETHN4,5,5)
   /PRCZBL=PIN(ETHN4,2,2)
   /PRCZWH=PIN(ETHN4,1,1)
   /ZCOUNT=N.

*######################################################################.
* PART 3: MATCH SHOW-REG FILE WITH AGGREGATED FILES.
*######################################################################.

GET FILE=SHOWSYS.

***********************************************************************.
* CALCULATE PREDICTOR VARIABLES FOR HISPANIC AND ASIAN NAMES.
***********************************************************************.

MATCH FILES FILE=* / TABLE=ASIAN / TABLE=HISPANIC / BY=LNAME / MAP.

RECODE ASCOUNT (MISSING=0).
RECODE HCOUNT  (5 THRU HI=1)(ELSE=0) INTO HISP05HI.
RECODE ASCOUNT (5 THRU HI=1)(ELSE=0) INTO AS05HI.

***********************************************************************.
* CALCULATE PREDICTOR VARIABLE FOR ZIPCODE.
***********************************************************************.
SORT CASES BY ZIPCAT.

MATCH FILES FILE=* / TABLE=ZIPCODE / BY=ZIPCAT / MAP.

RECODE ZCOUNT (LO THRU 10=0)(11 THRU HI=1) INTO ZIPCOUNT.

*######################################################################.
* PART 4: USE DISCRIMINATE PROCEDURE TO IMPUTE ETHNICITY.
*######################################################################.
RECODE SEXA ('M'=1) ('F'=2)  INTO GENDER.
VALUE LABELS GENDER 1'MALE' 2'FEMALE'.

RECODE RCODEN (1,2,3,4,6,7,9=1) (5,8=2) INTO RES.
VALUE LABELS RES    1 'USA' 2 'FOREIGN'.

RECODE FPTIMEN (1,2=1)(ELSE=2) INTO FPTIME.

RECODE STATUSA ('D'=1)(ELSE=0) INTO NSTATUS.
VALUE LABELS NSTATUS 1'DEGREE' 0'NON DEGREE'.

RECODE  DOBYRN (0,1=-9).
MISSING VALUE  DOBYRN (-9).
COMPUTE AGE=CURYRN-DOBYRN.


***********************************************************************.
* RECODE COLLEGES INTO DUMMY VARIABLES - SI (COLA-07) IS BASELINE.
***********************************************************************.
RECODE  COLA ('01'=1)(ELSE=0)  INTO CC
       /COLA ('02'=1)(ELSE=0)  INTO BARUCH
       /COLA ('03'=1)(ELSE=0)  INTO HUNTER
       /COLA ('04'=1)(ELSE=0)  INTO LEHMAN
       /COLA ('05'=1)(ELSE=0)  INTO BRKLYN
       /COLA ('06'=1)(ELSE=0)  INTO QUEENS
       /COLA ('08'=1)(ELSE=0)  INTO BRONX
       /COLA ('09'=1)(ELSE=0)  INTO QCC
       /COLA ('11'=1)(ELSE=0) INTO KCC.
RECODE  COLA ('12'=1)(ELSE=0) INTO BMCC
       /COLA ('13'=1)(ELSE=0) INTO NYCT
       /COLA ('14'=1)(ELSE=0) INTO HOSTOS
       /COLA ('15'=1)(ELSE=0) INTO YORK
       /COLA ('16'=1)(ELSE=0) INTO JAY
       /COLA ('18'=1)(ELSE=0) INTO LGA
       /COLA ('19'=1)(ELSE=0) INTO EVERS
       /COLA ('21'=1)(ELSE=0) INTO GC
       /COLA ('22'=1)(ELSE=0) INTO QLAW
	 /COLA ('23'=1)(ELSE=0) INTO SPS
	 /COLA ('25'=1)(ELSE=0) INTO SJ.


***********************************************************************.
* HANDLE MISSING DATA.
***********************************************************************.
IF (ZIP5N GT 09000 AND ZIP5N LT 09800) ZIPCAT=-1.
IF (ZIPCOUNT=0) ZIPCAT=-1.
RECODE ZIPCAT (-9,0=-1).
IF (ZIPCAT = -1) PRCZBL=-9.
IF (ZIPCAT = -1) PRCZAS=-9.
IF (ZIPCAT = -1) PRCZHIS=-9.
IF (ZIPCAT = -1) PRCZWH=-9.
MISSING VALUES PRCZWH PRCZBL PRCZHIS PRCZAS (-9).

***********************************************************************.
* DISCRIMINANT ANALYSIS.
***********************************************************************.
TEMPORARY.
SELECT IF (ETHN4 LT 6).
DISC   GROUPS=ETHN4 (1,5)
      /VARS=AGE FPTIME GENDER CSTLN NSTATUS RES
            HISP05HI AS05HI
            CC BARUCH HUNTER LEHMAN BRKLYN QUEENS BRONX QCC KCC
            BMCC NYCT HOSTOS YORK JAY LGA EVERS GC  QLAW  SPS SJ
            PRCZBL PRCZHIS PRCZAS
      /PRIORS=SIZE
      /SAVE CLASS=ETHGROUP PROBS=PROBETH
      /CLASSIFY=MEANSUB
      /STAT=MEAN STDDEV UNIVF CORR FPAIR BOXM RAW TABLE.

***********************************************************************.
* WRITE OUTPUT FILE WITH SSN, COLLEGE CODE, AND ETHNIC CODE.
***********************************************************************.

*IF (ETHN4 EQ 0) AND (JJPR=1) ETHGROUP=4.
IF (ETHN4 GT 0)              ETHGROUP=ETHN4.

STRING ETH4A (A2).
STRING ETHA (A2).

RECODE ETHGROUP (1='01')(2='02')(3='03')(4='04')(5='05')(6='06')
  INTO ETHA.

FREQUENCY VARIABLES=ETHA, ETH4A.

DO IF ETHN4 =1.
COMPUTE ETH4A='01'.
ELSE IF ETHN4=2.
COMPUTE ETH4A='02'.
ELSE IF ETHN4=3.
COMPUTE ETH4A='03'.
ELSE IF ETHN4=4.
COMPUTE ETH4A='04'.
ELSE IF ETHN4=5.
COMPUTE ETH4A='05'.
ELSE IF ETHN4=6.
COMPUTE ETH4A='06'.
ELSE.
COMPUTE ETH4A='00'.
END IF.

FREQ VAR=ETH4A.

CROSSTAB TAB=ETHN4 BY ETH4A.


CROSSTABS TABLE=ETHN BY ETHA.

CROSSTAB TAB=ETHN4 BY ETHA.

SORT CASES BY CURSSNA COLA.
WRITE  OUTFILE=ETHFILE TABLE /CURSSNA 1-9(A) COLA 11-12(A) ETHA 14-15(A) ETH4A 16-17(A).
EXECUTE.

FREQUENCY VAR=COLA.

****************************************************************.
*FINISH.
****************************************************************.

*COMPUTE IPEDS RACE ETHNCITY.

****************************************************************.
*.
*CHECK MULTIRACE.
*.
****************************************************************.

FREQ VAR=MULTIRACE, PIN, AIN.

TEMP.
SELECT IF MULTIRACE=0 AND PIN=1.
FREQ VAR=MULTIRACE, PIN, AIN.

TEMP.
SELECT IF MULTIRACE=0 AND PIN=1.
CROSSTAB TAB=PIN BY AIN.

CROSSTAB TAB=PIN BY AIN BY MULTIRACE.

****************************************************************.
*COMPUTE IPED ETHNICITY.
*TWO OR MORE RACE, NATIVE HAWAIIAN OR OTHER PACIFIC ISLANDER.
*SEPARATE THE ABOVE TWO CHARACTERS FROM THE IMPUTED ETHNICITY.
*.
*IPEDETHA ='07' IS TWO OR MORE RACES.
*IPEDETHA ='08' IS NATIVE HAWAIIAN OR OTHER PACIFIC ISLANDER.
*.
****************************************************************.

STRING IPEDETHA (A2).

COMPUTE IPEDETHA ='  '.

******************************************.
*COMPUTE FOREIGN.
******************************************.

FREQ VAR=RES.

DO IF IPEDETHA='  '.
DO IF RES=2.
COMPUTE IPEDETHA='01'.
END IF.
END IF.

FREQ VAR=IPEDETHA.

******************************************.
*COMPUTE HISPANIC FROM 2Q FORMAT.
******************************************.
TEMP.
SELECT IF (IPEDETHA <> '01').
FREQ VAR=NEWETH, MULTIRACE.

TEMP.
SELECT IF (IPEDETHA <> '01').
FREQ VAR=HIN, ETHA.

TEMP.
SELECT IF (IPEDETHA <> '01').
SELECT IF ANY (ETHA, '03', '04') AND (MULTIRACE <> 1).
FREQ ETHA.

TEMP.
SELECT IF (IPEDETHA <> '01').
CROSSTAB TAB=HIN BY ETHA.




DO IF (IPEDETHA <> '01').
DO IF HIN=1.
COMPUTE IPEDETHA='08'.
ELSE IF ANY (ETHA, '03', '04') AND (MULTIRACE <> 1).
COMPUTE IPEDETHA = '08'.
END IF.
END IF.


FREQ VAR=IPEDETHA.


CROSSTAB TAB=IPEDETHA BY ETHA.

 
******************************************.
*COMPUTE TWO OR MORE RACE.
******************************************.

TEMP.
SELECT IF MULTIRACE=1.
FREQ VAR ETH4A, RES, IPEDETHA.

TEMP.
SELECT IF NOT ANY(IPEDETHA, '01', '08').
FREQ VAR=MULTIRACE.

DO IF NOT ANY(IPEDETHA, '01', '08').
DO IF MULTIRACE=1.
COMPUTE IPEDETHA='14'.
END IF.
END IF.

FREQ VAR=IPEDETHA.


******************************************.
*COMPUTE HAWAIIAN, PACIFIC ISLANDER.
******************************************.

TEMP.
SELECT IF PIN=1 AND MULTIRACE=0.
SELECT IF NOT ANY(IPEDETHA, '01', '08', '14').
FREQ VAR=ETH4A, RES, IPEDETHA, NEWETH, PIN.


DO IF NOT ANY(IPEDETHA, '01', '08', '14').
DO IF (PIN=1) AND (MULTIRACE <> 1).
COMPUTE IPEDETHA='12'.
END IF.
END IF.


FREQ VAR=IPEDETHA.

CROSSTAB TAB=ETHN BY IPEDETHA.

CROSSTAB TAB=ETHN4 BY IPEDETHA.

******************************************.
*COMPUTE OTHER RACE ETHNICITY.
******************************************.

TEMP.
SELECT IF IPEDETHA='  '.
FREQ VAR=ETHA, ETHN4.

DO IF NOT ANY(IPEDETHA, '01', '08', '14', '12').
DO IF ETHA='01'.
COMPUTE IPEDETHA='13'.
ELSE IF ETHA='02'.
COMPUTE IPEDETHA='11'.
ELSE IF ETHA='05'.
COMPUTE IPEDETHA='10'.
ELSE IF ETHA='06'.
COMPUTE IPEDETHA='09'.
ELSE.
COMPUTE IPEDETHA='07'.
END IF.
END IF.

FREQ VAR=IPEDETHA.


VAR LAB IPEDETHA 'IPED ETHNICITY'.

VAL LAB IPEDETHA '01'  'NONRESIDENT ALIEN'
		     '07'  'UNKNOWN'
		     '08'  'HISPANIC'
                 '09'  'AMERICAN INDIAN OR ALASKA NATIVE'
                 '10'  'ASIAN'
                 '11'  'BLACK'
                 '12'  'NATIVE HAWAIIAN OR PACIFIC ISLANDER'
                 '13'  'WHITE'
                 '14'  'TOW OR MORE RACE' .


CROSSTAB TAB=IPEDETHA BY ETHA.


******************************************.
******************************************.


SORT CASES BY CURSSNA COLA.
WRITE  OUTFILE=ETHFILE2 TABLE /CURSSNA 1-9(A) COLA 11-12(A) ETHA 14-15(A) ETH4A 16-17(A) IPEDETHA 19-20(A).
EXECUTE.



FREQ VAR=IPEDETHA.

FREQ VAR=COLA.
